/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.atomdata;

import java.util.Vector;
import org.jmol.util.XmlUtil;
import org.jmol.viewer.JmolConstants;

public class RadiusData {
    public static final int TYPE_ABSOLUTE = 0;
    public static final int TYPE_OFFSET = 1;
    public static final int TYPE_FACTOR = 2;
    public static final int TYPE_SCREEN = 3;
    private static final String[] typeNames = new String[]{"=", "+", "*", "."};
    public int type;
    public int vdwType = 8;
    public float value = Float.NaN;
    public float valueExtended = 0.0f;

    public RadiusData() {
    }

    public RadiusData(float f, int n, int n2) {
        this.type = n;
        this.value = f;
        this.vdwType = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{"type", typeNames[this.type]});
        vector.add(new String[]{"value", "" + this.value});
        if (this.type == 2 && this.value != 0.0f && this.vdwType >= 0) {
            vector.add(new String[]{"vdwType", this.vdwType + "|" + JmolConstants.getVdwLabel(this.vdwType)});
        }
        if (this.valueExtended != 0.0f) {
            vector.add(new String[]{"plus", "" + this.valueExtended});
        }
        XmlUtil.appendTag(stringBuffer, "radiusData", vector.toArray());
        return stringBuffer.toString();
    }
}

