/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import rene.dialogs.Warning;
import rene.gui.CloseDialog;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.HistoryTextField;
import rene.gui.IconBar;
import rene.gui.IconBarListener;
import rene.gui.Panel3D;
import rene.util.FileName;
import rene.util.parser.StringParser;
import rene.zirkel.DemoRunner;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelCanvasInterface;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.constructors.AngleConstructor;
import rene.zirkel.constructors.AreaConstructor;
import rene.zirkel.constructors.BoundedPointConstructor;
import rene.zirkel.constructors.Circle3Constructor;
import rene.zirkel.constructors.CircleConstructor;
import rene.zirkel.constructors.ExpressionConstructor;
import rene.zirkel.constructors.ImageConstructor;
import rene.zirkel.constructors.IntersectionConstructor;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.constructors.MidpointConstructor;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.constructors.ParallelConstructor;
import rene.zirkel.constructors.PlumbConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.constructors.QuadricConstructor;
import rene.zirkel.constructors.RayConstructor;
import rene.zirkel.constructors.SegmentConstructor;
import rene.zirkel.constructors.TextConstructor;
import rene.zirkel.dialogs.CommentDialog;
import rene.zirkel.dialogs.Replay;
import rene.zirkel.graphics.Drawing;
import rene.zirkel.listener.DoneListener;
import rene.zirkel.listener.StatusListener;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroBar;
import rene.zirkel.macro.MacroItem;
import rene.zirkel.macro.MacroRunner;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.LineObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TextObject;
import rene.zirkel.structures.CoordinatesXY;
import rene.zirkel.tools.AnimatorTool;
import rene.zirkel.tools.BreakpointAnimator;
import rene.zirkel.tools.DeleteTool;
import rene.zirkel.tools.DrawerTool;
import rene.zirkel.tools.EditTool;
import rene.zirkel.tools.HiderTool;
import rene.zirkel.tools.MoverTool;
import rene.zirkel.tools.ObjectTracker;
import rene.zirkel.tools.RenamerTool;
import rene.zirkel.tools.ReorderTool;
import rene.zirkel.tools.SaveJob;
import rene.zirkel.tools.SetParameterTool;
import rene.zirkel.tools.SetTargetsTool;
import rene.zirkel.tools.Tracker;
import rene.zirkel.tools.ZoomerTool;

public class ZirkelApplet
extends Applet
implements IconBarListener,
StatusListener,
KeyListener,
DoneListener,
DoActionListener,
ZirkelCanvasInterface {
    ZirkelCanvas ZC;
    IconBar IA;
    IconBar IB;
    IconBar IC;
    MacroBar IM;
    String filename = "test.zir";
    Label Status;
    Color C;
    Color CC;
    Frame F;
    public static String xaxis_text = "x-axis";
    public static String yaxis_text = "y-axis";
    public static boolean yaxis_text_vertical = false;
    public static String xaxis_variable = "X";
    public static String yaxis_variable = "Y";
    public static int decimals = 2;
    String FirstConstructor = "point";
    String Tools = "all";
    String Options = "";
    int CurrentTool = 0;
    HistoryTextField Input;
    ConstructionObject Last = null;
    boolean edit;
    boolean jumptostart;
    public static final String DefaultIcons = " point line segment area ray circle fixedcircle parallel plumb circle3 midpoint angle fixedangle move tracker objecttracker hide expression text quadric runmacro animate ";
    public static final String DefaultOptions = " back undo delete color type thickness hidden showcolor macro grid  draw twolines indicate ";
    DemoRunner DR = null;
    Replay RD = null;
    public ObjectConstructor[] ObjectConstructors = new ObjectConstructor[]{new PointConstructor(), new BoundedPointConstructor(), new IntersectionConstructor(), new LineConstructor(), new RayConstructor(), new SegmentConstructor(), new SegmentConstructor(true), new CircleConstructor(), new Circle3Constructor(), new CircleConstructor(true), new ParallelConstructor(), new PlumbConstructor(), new MidpointConstructor(), new AngleConstructor(), new AngleConstructor(true), new MoverTool(), new Tracker(), new ObjectTracker(), new AnimatorTool(), new ExpressionConstructor(), new AreaConstructor(), new QuadricConstructor(), new ImageConstructor(), new TextConstructor(), new HiderTool(), new MacroRunner(), new EditTool(), new SetParameterTool(), new SetTargetsTool(), new SaveJob(), new DeleteTool(), new ReorderTool(), new DrawerTool(), new RenamerTool(), new ZoomerTool()};
    String OldMacro = null;
    AnimatorTool A = null;

    public void init() {
        Object object;
        String string;
        Object object2;
        Object object3;
        int n;
        int n2;
        Object object4;
        String string2 = this.getParameter("language");
        if (string2 != null) {
            System.out.println("lang=" + this.getParameter("language"));
            try {
                Locale.setDefault(new Locale(string2, ""));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Global.initBundle("rene/zirkel/docs/ZirkelProperties_" + string2);
        } else {
            Global.initBundle("rene/zirkel/docs/ZirkelProperties");
        }
        Count.resetAll();
        this.CC = this.C = Global.Background;
        this.initLightColors();
        this.initObjectKeys();
        Dimension dimension = this.getToolkit().getScreenSize();
        this.F = new Frame();
        this.F.setSize(dimension);
        if (this.getParameter("oldicons") == null) {
            Global.setParameter("iconpath", "/rene/zirkel/newicons/");
            Global.setParameter("iconsize", this.getParameter("smallicons") == null ? 32 : 24);
            Global.setParameter("icontype", "png");
        } else {
            Global.setParameter("iconpath", "/rene/zirkel/icons/");
            Global.setParameter("iconsize", 20);
        }
        String string3 = this.getParameter("color");
        if (string3 != null) {
            object4 = new StringParser(this.getParameter("color"));
            ((StringParser)object4).replace(',', ' ');
            int n3 = ((StringParser)object4).parseint();
            n2 = ((StringParser)object4).parseint();
            n = ((StringParser)object4).parseint();
            Global.Background = this.C = new Color(n3, n2, n);
            Global.ControlBackground = this.C;
            this.CC = this.C;
        }
        if ((string3 = this.getParameter("colorbackground")) != null) {
            Global.setParameter("colorbackground", string3);
        } else {
            Global.removeParameter("colorbackground");
        }
        string3 = this.getParameter("colorselect");
        if (string3 != null) {
            Global.setParameter("colorselect", string3);
        } else {
            Global.removeParameter("colorselect");
        }
        ZirkelFrame.SelectColor = Global.getParameter("colorselect", Color.red);
        string3 = this.getParameter("colortarget");
        if (string3 != null) {
            Global.setParameter("colortarget", string3);
        } else {
            Global.removeParameter("colortarget");
        }
        ZirkelFrame.TargetColor = Global.getParameter("colorselect", Color.pink);
        ZirkelFrame.initLightColors(Color.white);
        object4 = this.getParameter("font");
        if (object4 != null) {
            if (((String)object4).indexOf("bold") >= 0) {
                Global.setParameter("font.bold", true);
            }
            if (((String)object4).indexOf("large") >= 0) {
                Global.setParameter("font.large", true);
            }
        }
        if (this.getParameter("demo") != null) {
            this.initDemo();
            return;
        }
        String string4 = this.getParameter("style");
        if (string4 == null) {
            string4 = "plain";
        }
        n2 = string4.equals("plain") || string4.equals("3D") || string4.equals("breaks") ? 1 : 0;
        this.edit = n2 == 0;
        n = string4.equals("full") || string4.equals("status") ? 1 : 0;
        boolean bl = string4.equals("full") || string4.equals("nonvisual") || string4.equals("icons");
        boolean bl2 = string4.equals("breaks");
        if (this.getParameter("edit") != null) {
            this.edit = true;
        }
        for (int i = 0; i < ZirkelFrame.Colors.length; ++i) {
            string3 = this.getParameter("color" + i);
            if (string3 != null) {
                Global.setParameter("color" + i, string3);
                continue;
            }
            Global.removeParameter("color" + i);
        }
        ZirkelFrame.initLightColors(Color.white);
        this.setLayout(new BorderLayout());
        this.Tools = this.getParameter("tools");
        if (this.Tools == null || this.Tools.equals("defaults")) {
            this.Tools = DefaultIcons;
        }
        this.Options = this.getParameter("options");
        if (this.Options == null || this.Options.equals("defaults")) {
            this.Options = DefaultOptions;
        }
        Global.setParameter("macrobar", this.Options.indexOf("macrobar") >= 0);
        this.makeMacroBar();
        if (bl) {
            this.IB = new IconBar(this.F);
            this.IB.setBackground(this.CC);
            this.IB.setIconBarListener(this);
            StringTokenizer stringTokenizer = new StringTokenizer(this.Tools);
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n4;
            }
            object3 = new String[n4];
            stringTokenizer = new StringTokenizer(this.Tools);
            n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object3[n4++] = stringTokenizer.nextToken();
            }
            if (n4 > 0) {
                this.FirstConstructor = object3[0];
            }
            this.IB.addToggleGroupLeft((String[])object3);
            this.IB.addSeparatorLeft();
            if (this.Options.indexOf("twolines") >= 0 || this.Options.indexOf("defaults") >= 0) {
                this.IA = new IconBar(this.F);
                this.IA.setBackground(this.CC);
                this.IA.setIconBarListener(this);
                this.setIA(this.IA, this.Options);
                object2 = new Panel();
                ((Component)object2).setBackground(this.CC);
                ((Container)object2).setLayout(new GridLayout(0, 1));
                ((Container)object2).add(this.IA);
                ((Container)object2).add(this.IB);
                if (this.IM != null) {
                    ((Container)object2).add(this.IM);
                }
                this.add("North", new Panel3D((Component)object2, this.CC));
            } else {
                this.IA = this.IB;
                this.setIA(this.IB, this.Options);
                if (this.IM != null) {
                    object2 = new Panel();
                    ((Component)object2).setBackground(this.CC);
                    ((Container)object2).setLayout(new GridLayout(0, 1));
                    ((Container)object2).add(this.IA);
                    if (this.IM != null) {
                        ((Container)object2).add(this.IM);
                    }
                    this.add("North", new Panel3D((Component)object2, this.CC));
                } else {
                    this.add("North", new Panel3D(this.IB, this.CC));
                }
            }
        } else {
            this.IB = null;
            this.IA = null;
        }
        Global.setParameter("options.intersection", false);
        Global.setParameter("options.pointon", false);
        Global.setParameter("options.choice", false);
        if (this.Options.indexOf("qchoice") >= 0) {
            Global.setParameter("options.choice", true);
        }
        if (this.Options.indexOf("qintersection") >= 0) {
            Global.setParameter("options.intersection", true);
        }
        if (this.Options.indexOf("qpointon") >= 0) {
            Global.setParameter("options.pointon", true);
        }
        Global.setParameter("options.indicate", true);
        Global.setParameter("options.indicate.simple", this.Options.indexOf("noindicate") >= 0);
        if (this.getParameter("selectionsize") != null) {
            try {
                double d2 = new Double(this.getParameter("selectionsize"));
                Global.setParameter("selectionsize", d2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ZC = new ZirkelCanvas(!this.edit, !bl2, !bl2);
        this.ZC.addMouseListener(this.ZC);
        this.ZC.addMouseMotionListener(this.ZC);
        this.ZC.setBackground(Global.getParameter("colorbackground", this.C));
        this.ZC.setFrame(this.F);
        this.ZC.setZirkelCanvasListener(this);
        if (this.getParameter("showhidden") != null) {
            this.ZC.setShowHidden(true);
        }
        if (string4.equals("plain")) {
            this.add("Center", this.ZC);
        } else {
            this.add("Center", new Panel3D(this.ZC, this.ZC.getBackground()));
        }
        this.ZC.addStatusListener(this);
        this.ZC.addKeyListener(this);
        this.setShowNames(false);
        if (n != 0) {
            this.Status = new Label("");
            this.Status.setBackground(this.CC);
            this.add("South", new Panel3D(this.Status, this.Status.getBackground()));
        } else if (string4.equals("nonvisual")) {
            this.Input = new HistoryTextField(this, "Input");
            this.ZC.setTextField(this.Input);
            this.ZC.Visual = false;
            this.setShowNames(true);
            this.add("South", new Panel3D(this.Input));
        }
        try {
            Global.setParameter("digits.edit", Integer.parseInt(this.getParameter("editdigits")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Global.setParameter("digits.lengths", Integer.parseInt(this.getParameter("displaydigits")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Global.setParameter("digits.angles", Integer.parseInt(this.getParameter("angledigits")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setOption("movename");
        this.setOption("movefixname");
        this.ZC.updateDigits();
        this.setOption("nopopupmenu");
        this.setOption("nomousezoom");
        try {
            Global.setParameter("minpointsize", new Double(this.getParameter("minpointsize")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Global.setParameter("minlinesize", new Double(this.getParameter("minlinewidth")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Global.setParameter("minfontsize", new Double(this.getParameter("minfontsize")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Global.setParameter("arrowsize", new Double(this.getParameter("arrowsize")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string5 = this.getParameter("grid");
            this.ZC.ShowGrid = !string5.equals("none");
            Global.setParameter("grid.fine", string5.equals("coordinates"));
            if (this.getParameter("snap").equalsIgnoreCase("left") || this.getParameter("snap").equalsIgnoreCase("yes")) {
                Global.setParameter("grid.leftsnap", true);
            } else {
                Global.setParameter("grid.leftsnap", false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getParameter("interactive") != null && this.getParameter("interactive").equals("false")) {
            this.ZC.setInteractive(false);
        }
        boolean bl3 = false;
        this.ZC.IW = this.getSize().width;
        this.ZC.IH = this.getSize().height;
        if (this.getParameter("germanpoints") != null && this.getParameter("germanpoints").equals("true")) {
            Global.setParameter("options.germanpoints", true);
        }
        if ((string = this.getParameter("background_image")) != null && string.length() > 0) {
            try {
                object3 = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                object3 = null;
            }
            if (object3 != null) {
                try {
                    object2 = this.getToolkit().getImage((URL)object3);
                    object = new MediaTracker(this);
                    ((MediaTracker)object).addImage((Image)object2, 0);
                    ((MediaTracker)object).waitForID(0);
                    if (((MediaTracker)object).checkID(0) && !((MediaTracker)object).isErrorAny()) {
                        this.ZC.setBackground((Image)object2);
                        this.ZC.repaint();
                        Global.setParameter("background.usesize", true);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Image could not be loaded");
                }
            }
        }
        if ((string = this.getParameter("x_axis_text")) != null && string.length() > 0) {
            xaxis_text = string;
        }
        if ((string = this.getParameter("y_axis_text")) != null && string.length() > 0) {
            yaxis_text = string;
        }
        if ((string = this.getParameter("y_axis_text_vertical")) != null && string.length() > 0) {
            yaxis_text_vertical = string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
        }
        if ((string = this.getParameter("xaxis_variable")) != null && string.length() > 0) {
            xaxis_variable = string;
        }
        if ((string = this.getParameter("yaxis_variable")) != null && string.length() > 0) {
            yaxis_variable = string;
        }
        if ((string = this.getParameter("decimals")) != null && string.length() > 0) {
            decimals = Integer.parseInt(string, 10);
        }
        this.filename = this.getParameter("file");
        if (this.filename == null) {
            this.filename = this.getParameter("job");
            bl3 = true;
        }
        if (this.filename != null) {
            boolean bl4 = true;
            while (true) {
                try {
                    object2 = this.filename.toUpperCase().startsWith("HTTP") ? new URL(bl4 ? FileName.toURL(this.filename) : this.filename) : new URL(this.getCodeBase(), bl4 ? FileName.toURL(this.filename) : this.filename);
                    this.ZC.clear();
                    object = ((URL)object2).openStream();
                    if (ZirkelFrame.isCompressed(this.filename)) {
                        object = new GZIPInputStream((InputStream)object);
                    }
                    this.showStatus(Global.name("loading"));
                    this.ZC.load((InputStream)object);
                    this.toggleGrid(this.ZC.ShowGrid);
                    if (bl3) {
                        this.ZC.displayJob(true);
                        this.ZC.setDoneListener(this);
                    }
                    if (bl) {
                        this.iconPressed(this.FirstConstructor);
                    }
                    ((InputStream)object).close();
                    if (this.getParameter("background") != null) {
                        Image image = this.getToolkit().getImage(new URL(this.getCodeBase(), this.getParameter("background")));
                        MediaTracker mediaTracker = new MediaTracker(this);
                        mediaTracker.addImage(image, 0);
                        mediaTracker.waitForID(0);
                        if (mediaTracker.checkID(0) && !mediaTracker.isErrorAny()) {
                            this.ZC.setBackground(image);
                        }
                    }
                    this.ZC.repaint();
                }
                catch (Exception exception) {
                    if (bl4) {
                        bl4 = false;
                        continue;
                    }
                    object = new Warning(this.F, FileName.chop(32, "" + exception, 64), Zirkel.name("message"), true);
                    ((CloseDialog)object).center(this.F);
                    ((Dialog)object).setVisible(true);
                    this.showStatus("" + exception);
                    exception.printStackTrace();
                    System.out.println(exception);
                }
                break;
            }
        }
        if (bl2) {
            this.IC = new IconBar(this.F);
            this.IC.setBackground(this.CC);
            this.IC.setIconBarListener(this);
            this.IC.addLeft("allback");
            if (this.haveBreaks()) {
                this.IC.addLeft("nextbreak");
            } else {
                this.IC.addLeft("oneforward");
            }
            this.IC.addLeft("allforward");
            Panel3D panel3D = new Panel3D(this.IC);
            this.add("South", panel3D);
            this.IC.setEnabled("nextbreak", false);
            this.IC.setEnabled("oneforward", false);
            this.IC.setEnabled("allforward", false);
            this.ZC.getConstruction().setOriginalOrder(true);
            boolean bl5 = this.jumptostart = this.getParameter("jumptostart") != null;
        }
        if (this.getParameter("restrictedmove") != null) {
            Global.setParameter("restrictedmove", true);
        }
        if (this.getParameter("noconfirmation") != null) {
            Global.setParameter("confirmation", false);
        }
        if (this.IA != null) {
            this.settype(2);
        }
        this.ZC.setMacroBar(this.IM);
        this.ZC.updateMacroBar();
        this.ZC.recompute();
        this.ZC.repaint();
    }

    public void setOption(String string) {
        try {
            Global.setParameter("options." + string, this.getParameter(string).equals("true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void initDemo() {
        this.setLayout(new BorderLayout());
        this.ZC = new ZirkelCanvas(false, false, false);
        this.ZC.setBackground(Global.getParameter("colorbackground", this.C));
        this.ZC.setFrame(this.F);
        this.ZC.setZirkelCanvasListener(this);
        if (this.getParameter("showhidden") != null) {
            this.ZC.setShowHidden(true);
        }
        this.add("Center", new Panel3D(this.ZC, this.ZC.getBackground()));
        this.Status = new Label("", 1);
        this.Status.setBackground(this.C);
        this.add("South", new Panel3D(this.Status, this.Status.getBackground()));
    }

    void setIA(IconBar iconBar, String string) {
        if (string.indexOf("back") >= 0) {
            iconBar.addLeft("back");
        }
        if (string.indexOf("delete") >= 0) {
            iconBar.addToggleLeft("delete");
        }
        if (string.indexOf("undo") >= 0) {
            iconBar.addLeft("undo");
        }
        if (string.indexOf("hidden") >= 0) {
            iconBar.addOnOffLeft("hidden");
        }
        if (string.indexOf("showcolor") >= 0) {
            iconBar.addMultipleIconLeft("showcolor", ZirkelFrame.Colors.length);
        }
        if (string.indexOf("color") >= 0) {
            iconBar.addMultipleIconLeft("color", 6);
        }
        if (string.indexOf("type") >= 0) {
            iconBar.addMultipleIconLeft("type", 4);
        }
        if (string.indexOf("thickness") >= 0) {
            iconBar.addMultipleIconLeft("thickness", 3);
        }
        if (string.indexOf("partial") >= 0) {
            iconBar.addOnOffLeft("partial");
        }
        if (string.indexOf("plines") >= 0) {
            iconBar.addOnOffLeft("plines");
        }
        if (string.indexOf("arrow") >= 0) {
            iconBar.addOnOffLeft("arrow");
        }
        if (string.indexOf("showname") >= 0) {
            iconBar.addOnOffLeft("showname");
        }
        if (string.indexOf("showvalue") >= 0) {
            iconBar.addOnOffLeft("showvalue");
        }
        if (string.indexOf("edit") >= 0) {
            iconBar.addToggleLeft("edit");
        }
        if (string.indexOf("obtuse") >= 0) {
            iconBar.addOnOffLeft("obtuse");
        }
        if (string.indexOf("solid") >= 0) {
            iconBar.addOnOffLeft("solid");
        }
        if (string.indexOf("grid") >= 0) {
            iconBar.addOnOffLeft("grid");
        }
        if (string.indexOf("macro") >= 0) {
            iconBar.addMultipleToggleIconLeft("macro", 3);
        }
        if (string.indexOf("replay") >= 0) {
            iconBar.addLeft("replay");
        }
        if (string.indexOf("zoom") >= 0) {
            iconBar.addToggleLeft("zoom");
        }
        if (string.indexOf("comment") >= 0) {
            iconBar.addLeft("comment");
        }
        if (string.indexOf("function") >= 0) {
            iconBar.addLeft("function");
        }
        if (string.indexOf("draw") >= 0) {
            iconBar.addToggleLeft("draw");
        }
    }

    public void makeMacroBar() {
        if (Global.getParameter("macrobar", true)) {
            this.IM = new MacroBar(this.F);
            this.IM.addKeyListener(this);
            this.IM.setIconBarListener(this);
            this.IM.setBackground(this.CC);
        }
    }

    public void updateMacroBar() {
        this.ZC.updateMacroBar();
    }

    public void iconPressed(String string) {
        Macro macro;
        int n;
        if (this.RD != null) {
            this.RD.doclose();
        }
        this.ZC.requestFocus();
        if (this.IA != null && this.IA.isControlPressed()) {
            if (string.equals("edit")) {
                if (this.CurrentTool != 26) {
                    this.IA.setState("edit", false);
                }
                this.ZC.editLast();
                this.ZC.repaint();
            }
            this.IA.clearShiftControl();
            return;
        }
        for (n = 0; n < ZirkelFrame.ObjectStrings.length; ++n) {
            if (!string.equals(ZirkelFrame.ObjectStrings[n])) continue;
            if (n == 25) {
                this.runmacro(this.IB.isShiftPressed());
            } else {
                this.settool(n);
            }
            return;
        }
        if (this.IM != null && (macro = this.IM.find(string)) != null) {
            this.runMacro(macro);
            return;
        }
        if (string.equals("hidden")) {
            this.ZC.setShowHidden(this.IA.getState("hidden"));
        } else if (string.equals("partial")) {
            this.ZC.setPartial(this.IA.getState("partial"));
        } else if (string.equals("plines")) {
            this.ZC.setPartialLines(this.IA.getState("plines"));
        } else if (string.equals("arrow")) {
            this.ZC.setVectors(this.IA.getState("arrow"));
        } else if (string.equals("color")) {
            n = this.IA.getMultipleState("color");
            if (n >= 0) {
                this.setcolor(n);
            }
        } else if (string.equals("showcolor")) {
            n = this.IA.getMultipleState("showcolor");
            if (n >= 0) {
                this.showcolor(n);
            }
        } else if (string.equals("showname")) {
            this.setShowNames(this.IA.getState("showname"));
        } else if (string.equals("obtuse")) {
            this.setObtuse(this.IA.getState("obtuse"));
        } else if (string.equals("solid")) {
            this.setSolid(this.IA.getState("solid"));
        } else if (string.equals("showvalue")) {
            this.setShowValues(this.IA.getState("showvalue"));
        } else if (string.equals("longnames")) {
            this.setLongNames(this.IA.getState("longnames"));
        } else if (string.equals("grid")) {
            this.toggleGrid(this.IA.getState("grid"));
        } else if (string.equals("comment")) {
            this.showcomment();
        } else if (string.equals("function")) {
            if (this.IA.isControlPressed()) {
                this.ZC.createFunction();
            } else {
                this.ZC.createCurve();
            }
        } else if (string.equals("type")) {
            n = this.IA.getMultipleState("type");
            if (n >= 0) {
                this.settype(n);
            }
        } else if (string.equals("thickness")) {
            n = this.IA.getMultipleState("thickness");
            if (n >= 0) {
                this.setcolortype(n);
            }
        } else if (string.equals("edit")) {
            this.settool(26);
        } else if (string.equals("back")) {
            this.ZC.back();
            this.ZC.repaint();
        } else if (string.equals("undo")) {
            this.ZC.undo();
            this.ZC.repaint();
        } else if (string.equals("replay")) {
            this.replay();
        } else if (string.equals("macro")) {
            n = this.IA.getMultipleState("macro");
            switch (n) {
                case 1: {
                    this.settool(27);
                    break;
                }
                case 2: {
                    this.settool(28);
                    break;
                }
                case 0: {
                    this.definemacro();
                }
            }
            this.IA.setState("macro", true);
        } else if (string.equals("allback")) {
            Enumeration enumeration;
            if (this.Last != null && this.Last instanceof TextObject) {
                ((TextObject)this.Last).setDoShow(false);
            }
            if ((enumeration = this.ZC.getConstruction().elements()).hasMoreElements()) {
                this.Last = (ConstructionObject)enumeration.nextElement();
                this.ZC.paintUntil(this.Last);
                if (this.Last instanceof TextObject && this.Last.valid() && !this.Last.isSuperHidden()) {
                    ((TextObject)this.Last).setDoShow(true);
                }
            }
            this.IC.setEnabled("allforward", true);
            this.IC.setEnabled("nextbreak", true);
            this.IC.setEnabled("oneforward", true);
            this.IC.setEnabled("allback", false);
            if (this.haveBreaks() && !this.Last.isBreak()) {
                this.iconPressed("nextbreak");
            }
        } else if (string.equals("allforward")) {
            if (this.Last != null && this.Last instanceof TextObject) {
                ((TextObject)this.Last).setDoShow(false);
            }
            this.ZC.paintUntil(null);
            this.Last = null;
            this.IC.setEnabled("allforward", false);
            this.IC.setEnabled("nextbreak", false);
            this.IC.setEnabled("oneforward", false);
            this.IC.setEnabled("allback", true);
        } else if (string.equals("nextbreak")) {
            if (this.Last != null && this.Last instanceof TextObject) {
                ((TextObject)this.Last).setDoShow(false);
            }
            Enumeration enumeration = this.ZC.getConstruction().elements();
            block6: while (enumeration.hasMoreElements()) {
                ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
                if (constructionObject != this.Last) continue;
                while (enumeration.hasMoreElements()) {
                    this.Last = (ConstructionObject)enumeration.nextElement();
                    if (this.Last != null && !this.Last.isBreak()) continue;
                    break block6;
                }
            }
            this.IC.setEnabled("allback", true);
            if (this.Last instanceof TextObject && this.Last.valid() && !this.Last.isSuperHidden()) {
                ((TextObject)this.Last).setDoShow(true);
            }
            this.ZC.paintUntil(this.Last);
            this.IC.setEnabled("allback", true);
            this.IC.setEnabled("nextbreak", enumeration.hasMoreElements());
            this.IC.setEnabled("allforward", enumeration.hasMoreElements());
        } else if (string.equals("oneforward")) {
            if (this.Last != null && this.Last instanceof TextObject) {
                ((TextObject)this.Last).setDoShow(false);
            }
            Enumeration enumeration = this.ZC.getConstruction().elements();
            block8: while (enumeration.hasMoreElements()) {
                ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
                if (constructionObject != this.Last) continue;
                while (enumeration.hasMoreElements()) {
                    this.Last = (ConstructionObject)enumeration.nextElement();
                    if (this.Last == null || !this.Last.isHidden()) break block8;
                    if (!(this.Last instanceof TextObject) || !this.Last.valid() || this.Last.isSuperHidden()) continue;
                    ((TextObject)this.Last).setDoShow(true);
                    break block8;
                }
            }
            this.IC.setEnabled("allback", true);
            this.ZC.paintUntil(this.Last);
            if (!enumeration.hasMoreElements()) {
                this.ZC.paintUntil(null);
                this.IC.setEnabled("allforward", false);
                this.IC.setEnabled("oneforward", false);
                this.IC.setEnabled("allback", true);
            }
        } else if (this.IB.isControlPressed() || this.IA.isControlPressed()) {
            n = this.CurrentTool;
            if (string.equals("objecttracker")) {
                this.track();
            }
            this.settool(n);
        }
        this.IA.clearShiftControl();
        this.IB.clearShiftControl();
    }

    public void settool(int n) {
        if (this.IM != null) {
            this.IM.deselectAll();
        }
        this.ZC.setTool(this.ObjectConstructors[n]);
        this.CurrentTool = n;
        if (n < 26 && this.IB.have(ZirkelFrame.ObjectStrings[n])) {
            this.IB.toggle(ZirkelFrame.ObjectStrings[n]);
        } else {
            this.IB.unselect(this.FirstConstructor);
        }
        this.ObjectConstructors[n].resetFirstTime(this.ZC);
        if (n == 28) {
            this.IA.setMultipleState("macro", 2);
        } else if (n == 27) {
            this.IA.setMultipleState("macro", 1);
        } else {
            this.IA.setMultipleState("macro", 0);
            this.IA.setState("macro", false);
        }
        this.IA.setState("delete", n == 30);
        this.IA.setState("edit", n == 26);
        this.IA.setState("draw", n == 32);
        this.IA.setState("rename", n == 33);
        this.IA.setState("zoom", n == 34);
    }

    public void setcolor(int n) {
        this.IA.setMultipleState("color", n);
        this.ZC.setDefaultColor(n);
    }

    public void settype(int n) {
        this.IA.setMultipleState("type", n);
        this.ZC.setDefaultType(n);
    }

    public void setcolortype(int n) {
        this.IA.setMultipleState("thickness", n);
        this.ZC.setDefaultColorType(n);
    }

    public void showStatus(String string) {
        super.showStatus(string);
        if (this.Status != null) {
            this.Status.setText(string);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isShiftDown();
        boolean bl2 = keyEvent.isControlDown();
        boolean bl3 = keyEvent.isAltDown();
        if (bl2) {
            int n2;
            if (this.Options.indexOf("type") > 0) {
                for (n2 = 0; n2 < ZirkelFrame.PointKeys.length; ++n2) {
                    if (ZirkelFrame.PointKeys[n2] != n) continue;
                    this.settype(n2);
                    return;
                }
            }
            if (this.Options.indexOf("color") > 0) {
                for (n2 = 0; n2 < ZirkelFrame.ColorKeys.length; ++n2) {
                    if (ZirkelFrame.ColorKeys[n2] != n) continue;
                    this.setcolor(n2);
                    return;
                }
            }
        } else if (bl3) {
            int n3;
            if (this.Options.indexOf("showcolor") > 0) {
                for (n3 = 0; n3 < ZirkelFrame.ColorKeys.length; ++n3) {
                    if (ZirkelFrame.ColorKeys[n3] != n) continue;
                    this.showcolor(n3);
                    return;
                }
            }
            if (this.Options.indexOf("thickness") > 0) {
                for (n3 = 0; n3 < ZirkelFrame.ColorTypeKeys.length; ++n3) {
                    if (ZirkelFrame.ColorTypeKeys[n3] != n) continue;
                    this.setcolortype(n3);
                    return;
                }
            }
        } else {
            switch (n) {
                case 27: {
                    if (this.ZC.getCurrentTool() instanceof DrawerTool) {
                        this.ZC.clearDrawings();
                        break;
                    }
                    this.ZC.reset();
                    break;
                }
                case 10: {
                    if (!bl) break;
                    this.track();
                }
            }
        }
        if (!keyEvent.isActionKey()) {
            return;
        }
        switch (n) {
            case 112: {
                this.showVersion();
                break;
            }
            case 118: {
                if (!bl && !bl2) break;
                this.setShowNames(!this.IA.getState("showname"));
                break;
            }
            case 119: {
                if (!bl && !bl2) break;
                this.setLongNames(!this.IA.getState("longnames"));
                break;
            }
            case 120: {
                if (bl || bl2) {
                    this.IA.setState("partial", !this.IA.getState("partial"));
                    this.ZC.setPartial(this.IA.getState("partial"));
                    break;
                }
                if (this.Options.indexOf("hidden") < 0) break;
                this.IA.setState("hidden", !this.IA.getState("hidden"));
                this.ZC.setShowHidden(this.IA.getState("hidden"));
                break;
            }
            case 121: {
                if (bl || bl2) {
                    this.IA.setState("plines", !this.IA.getState("plines"));
                    this.ZC.setPartial(this.IA.getState("plines"));
                    break;
                }
                this.showcomment();
                break;
            }
            case 122: {
                if (bl || bl2) {
                    this.IA.setState("arrow", !this.IA.getState("arrow"));
                    this.ZC.setPartial(this.IA.getState("arrow"));
                    break;
                }
                this.showconstruction();
                break;
            }
            case 123: {
                if (bl || bl2) {
                    this.IA.setState("obtuse", !this.IA.getState("obtuse"));
                    this.ZC.setObtuse(this.IA.getState("obtuse"));
                    break;
                }
                this.toggleGrid();
                break;
            }
            case 37: {
                if (bl && this.ZC.getCurrentTool() instanceof ObjectTracker) {
                    ((ObjectTracker)this.ZC.getCurrentTool()).increaseOmit();
                    break;
                }
                if (bl && this.ZC.getCurrentTool() instanceof BreakpointAnimator) {
                    ((BreakpointAnimator)this.ZC.getCurrentTool()).decreaseSpeed();
                    break;
                }
                if (bl && this.ZC.getCurrentTool() instanceof AnimatorTool) {
                    ((AnimatorTool)this.ZC.getCurrentTool()).decreaseSpeed();
                    break;
                }
                this.ZC.shift(-0.2, 0.0);
                break;
            }
            case 39: {
                if (bl && this.ZC.getCurrentTool() instanceof ObjectTracker) {
                    ((ObjectTracker)this.ZC.getCurrentTool()).decreaseOmit();
                    break;
                }
                if (bl && this.ZC.getCurrentTool() instanceof BreakpointAnimator) {
                    ((BreakpointAnimator)this.ZC.getCurrentTool()).increaseSpeed();
                    break;
                }
                if (bl && this.ZC.getCurrentTool() instanceof AnimatorTool) {
                    ((AnimatorTool)this.ZC.getCurrentTool()).increaseSpeed();
                    break;
                }
                this.ZC.shift(0.2, 0.0);
                break;
            }
            case 38: {
                this.ZC.shift(0.0, 0.2);
                break;
            }
            case 40: {
                this.ZC.shift(0.0, -0.2);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        if (keyEvent.isControlDown() || keyEvent.isAltDown()) {
            return;
        }
        for (int i = 0; i < ZirkelFrame.ObjectKeys.length; ++i) {
            if (c2 != ZirkelFrame.ObjectKeys[i]) continue;
            if (this.Tools.indexOf(ZirkelFrame.ObjectStrings[i]) >= 0) {
                this.settool(i);
            }
            return;
        }
        switch (c2) {
            case '\b': {
                this.ZC.undo();
                this.ZC.repaint();
                return;
            }
            case '+': {
                this.ZC.magnify(1.0 / Math.sqrt(Math.sqrt(2.0)));
                break;
            }
            case '-': {
                this.ZC.magnify(Math.sqrt(Math.sqrt(2.0)));
            }
        }
    }

    public void initLightColors() {
        int n = ZirkelFrame.Colors.length;
        ZirkelFrame.LightColors = new Color[n];
        Color color = this.C;
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        double d2 = 0.4;
        for (int i = 0; i < n; ++i) {
            int n5 = (int)((double)n2 * (1.0 - d2) + (double)ZirkelFrame.Colors[i].getRed() * d2);
            int n6 = (int)((double)n3 * (1.0 - d2) + (double)ZirkelFrame.Colors[i].getGreen() * d2);
            int n7 = (int)((double)n4 * (1.0 - d2) + (double)ZirkelFrame.Colors[i].getBlue() * d2);
            ZirkelFrame.LightColors[i] = new Color(n5, n6, n7);
        }
    }

    public void initObjectKeys() {
        ZirkelFrame.ObjectKeys = new char[ZirkelFrame.ObjectStrings.length];
        for (int i = 0; i < ZirkelFrame.ObjectStrings.length; ++i) {
            String string = Zirkel.name("shortcuts." + ZirkelFrame.ObjectStrings[i]);
            if (string.length() <= 0) continue;
            ZirkelFrame.ObjectKeys[i] = string.charAt(0);
        }
    }

    public void notifyDone() {
        Object object;
        this.repaint();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Global.getParameter("confirmation", true)) {
            object = new Warning(this.F, Zirkel.name("done"), Zirkel.name("message"), true);
            ((CloseDialog)object).center(this.F);
            ((Dialog)object).setVisible(true);
        }
        if ((object = this.getParameter("solution")) != null) {
            try {
                AppletContext appletContext = this.getAppletContext();
                appletContext.showDocument(new URL(this.getCodeBase(), FileName.toURL((String)object)));
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
        }
    }

    public void showcolor(int n) {
        this.ZC.setShowColor(n);
    }

    public void showcomment() {
        if (this.F == null) {
            return;
        }
        CommentDialog commentDialog = new CommentDialog(this.F, this.ZC.getComment(), Zirkel.name("comment.title"), this.ZC.displayJob());
        this.ZC.setComment(commentDialog.getText());
    }

    public void showconstruction() {
        if (this.F == null) {
            return;
        }
    }

    public void toggleGrid() {
        this.ZC.toggleShowGrid();
    }

    void definemacro() {
        if (!this.ZC.defineMacro()) {
            return;
        }
        if (this.ZC.getOC() instanceof SetTargetsTool) {
            this.settool(27);
        } else {
            this.ZC.getOC().reset(this.ZC);
        }
    }

    public void runmacro(boolean bl) {
        Macro macro = null;
        if (this.OldMacro == null && this.ZC.getMacros().size() == 1) {
            macro = ((MacroItem)this.ZC.getMacros().elementAt((int)0)).M;
        } else {
            macro = this.ZC.chooseMacro(this.OldMacro);
            if (!bl || macro == null) {
                macro = this.ZC.chooseMacro();
            }
        }
        if (macro == null) {
            this.settool(this.CurrentTool);
            return;
        }
        this.runMacro(macro);
    }

    public void runMacro(Macro macro) {
        ((MacroRunner)this.ObjectConstructors[25]).setMacro(macro, this.ZC);
        this.settool(25);
        if (this.IM != null) {
            this.IM.select(macro);
        }
        this.IB.setMultipleState("macro", 0);
        this.OldMacro = macro.getName();
    }

    public void setShowNames(boolean bl) {
        if (this.IA != null) {
            this.IA.setState("showname", bl);
        }
        Global.setParameter("options.shownames", bl);
        this.ZC.setShowNames(bl);
    }

    public void setObtuse(boolean bl) {
        this.IA.setState("obtuse", bl);
        Global.setParameter("options.obtuse", bl);
        this.ZC.setObtuse(bl);
    }

    public void setSolid(boolean bl) {
        this.IA.setState("solid", bl);
        Global.setParameter("options.solid", bl);
        this.ZC.setSolid(bl);
    }

    public void setShowValues(boolean bl) {
        this.IA.setState("showvalue", bl);
        Global.setParameter("options.showvalue", bl);
        this.ZC.setShowValues(bl);
    }

    public void setLongNames(boolean bl) {
        this.IA.setState("longnames", bl);
        Global.setParameter("options.longnames", bl);
        this.ZC.setLongNames(bl);
    }

    public void toggleGrid(boolean bl) {
        this.ZC.setShowGrid(bl);
        if (this.IA != null) {
            this.IA.setState("grid", bl);
        }
    }

    public void loadsettings() {
        this.setcolor(this.ZC.getDefaultColor());
        this.settype(this.ZC.getDefaultType());
        this.setcolortype(this.ZC.getDefaultColorType());
        this.IA.setState("partial", this.ZC.getPartial());
        this.IA.setState("plines", this.ZC.getPartialLines());
        this.IA.setState("arrow", this.ZC.getVectors());
        this.ZC.setHidden(false);
    }

    public void doAction(String string) {
        if (string.equals("Input")) {
            try {
                this.ZC.getConstruction().interpret(this.ZC, this.Input.getText(), "");
                this.Input.remember();
                this.Input.setText("");
                this.loadsettings();
                this.ZC.validate();
                this.ZC.getConstruction().updateCircleDep();
            }
            catch (ConstructionException constructionException) {
                this.ZC.warning(constructionException.getDescription());
            }
        }
    }

    public void itemAction(String string, boolean bl) {
    }

    public void start() {
        block24: {
            if (this.getParameter("demo") != null) {
                this.DR = new DemoRunner(this.ZC, this, this.getParameter("demo"), this.Status);
                return;
            }
            Construction construction = this.ZC.getConstruction();
            this.ZC.paint(this.ZC.getGraphics());
            this.ZC.allowRightMouse(true);
            if (construction.TrackP != null) {
                try {
                    ConstructionObject constructionObject;
                    ConstructionObject constructionObject2 = construction.find(construction.TrackP);
                    if (!(constructionObject2 instanceof PointObject) && !(constructionObject2 instanceof PrimitiveLineObject)) {
                        throw new ConstructionException("");
                    }
                    ConstructionObject[] constructionObjectArray = new ConstructionObject[construction.TrackPO.size()];
                    for (int i = 0; i < constructionObjectArray.length; ++i) {
                        constructionObject = construction.find((String)construction.TrackPO.elementAt(i));
                        if (constructionObject == null || !(constructionObject instanceof PointObject) && !(constructionObject instanceof PrimitiveLineObject)) {
                            throw new ConstructionException("");
                        }
                        constructionObjectArray[i] = constructionObject;
                    }
                    PointObject pointObject = null;
                    if (construction.TrackPM != null) {
                        pointObject = (PointObject)construction.find(construction.TrackPM);
                    }
                    if (construction.TrackO != null) {
                        constructionObject = construction.find(construction.TrackO);
                        if (constructionObject2 == null || pointObject == null && constructionObject instanceof ExpressionObject || constructionObject == null) {
                            throw new ConstructionException("");
                        }
                        ObjectTracker objectTracker = new ObjectTracker(constructionObject2, pointObject, constructionObject, this.ZC, construction.Animate, construction.Paint, constructionObjectArray);
                        if (construction.Animate) {
                            objectTracker.Interactive = false;
                        }
                        objectTracker.setOmit(construction.Omit);
                        this.ZC.setTool(objectTracker);
                        if (!this.edit) {
                            this.ZC.allowRightMouse(false);
                        }
                        this.ZC.validate();
                        this.ZC.repaint();
                        break block24;
                    }
                    if (constructionObject2 == null) {
                        throw new ConstructionException("");
                    }
                    this.ZC.setTool(new Tracker(constructionObject2, constructionObjectArray));
                    if (pointObject != null) {
                        pointObject.setSelected(true);
                    }
                    this.ZC.validate();
                    this.ZC.repaint();
                }
                catch (Exception exception) {}
            } else if (construction.AnimateP != null) {
                try {
                    PointObject pointObject = (PointObject)construction.find(construction.AnimateP);
                    if (pointObject == null || !pointObject.moveable()) {
                        throw new ConstructionException("");
                    }
                    Enumeration enumeration = construction.AnimateV.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        ConstructionObject constructionObject = construction.find(string);
                        if (constructionObject != null && (constructionObject instanceof SegmentObject || constructionObject instanceof PrimitiveCircleObject || constructionObject instanceof PointObject)) continue;
                        throw new ConstructionException("");
                    }
                    this.A = new AnimatorTool(pointObject, construction.AnimateV, this.ZC, construction.AnimateNegative, construction.AnimateOriginal, construction.AnimateDelay);
                    this.ZC.setTool(this.A);
                    this.ZC.allowRightMouse(false);
                    this.A.setInteractive(false);
                }
                catch (Exception exception) {}
            } else if (construction.AnimateBreakpoints) {
                BreakpointAnimator breakpointAnimator = new BreakpointAnimator();
                breakpointAnimator.setLoop(construction.AnimateLoop);
                breakpointAnimator.setSpeed(construction.AnimateTime);
                this.ZC.allowRightMouse(false);
                this.ZC.setTool(breakpointAnimator);
                breakpointAnimator.reset(this.ZC);
            } else if (this.jumptostart) {
                System.out.println("here");
                this.iconPressed("allback");
            }
        }
    }

    public void showVersion() {
        this.showStatus(Zirkel.name("program.name") + " " + Zirkel.name("program.version") + " " + Zirkel.name("program.date"));
    }

    public void stop() {
        this.ZC.invalidate();
        if (this.DR != null) {
            this.DR.stop();
        }
    }

    public void destroy() {
        this.ZC.invalidate();
        if (this.DR != null) {
            this.DR.stop();
        }
    }

    public void replay() {
        if (this.RD != null) {
            return;
        }
        this.RD = new Replay(this.F, this.ZC){

            public void doclose() {
                ZirkelApplet.this.RD = null;
                super.doclose();
            }
        };
        Dimension dimension = this.getToolkit().getScreenSize();
        this.RD.setLocation(dimension.width - 100 - this.RD.getSize().width, 100);
        this.ZC.OC.invalidate(this.ZC);
        this.RD.setVisible(true);
    }

    public void replayChosen() {
        this.replay();
    }

    public boolean enabled(String string) {
        if (this.Tools.indexOf("all") >= 0) {
            return true;
        }
        return this.Tools.indexOf(string) >= 0;
    }

    public boolean haveBreaks() {
        Enumeration enumeration = this.ZC.getConstruction().elements();
        while (enumeration.hasMoreElements()) {
            if (!((ConstructionObject)enumeration.nextElement()).isBreak()) continue;
            return true;
        }
        return false;
    }

    public String loadImage() {
        return null;
    }

    public Image doLoadImage(String string) {
        try {
            Image image = this.getToolkit().getImage(new URL(this.getCodeBase(), string));
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
            if (mediaTracker.checkID(0) && !mediaTracker.isErrorAny()) {
                return image;
            }
        }
        catch (Exception exception) {
            this.showStatus(exception.toString());
        }
        return null;
    }

    public boolean interpret(String string) {
        try {
            this.ZC.getConstruction().interpret(this.ZC, string);
            this.ZC.repaint();
            return true;
        }
        catch (ConstructionException constructionException) {
            return false;
        }
    }

    public String getConstruction() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.ZC.save(byteArrayOutputStream, true, true, false, this.ZC.getMacros(), "");
            return byteArrayOutputStream.toString("utf-8");
        }
        catch (Exception exception) {
            return "Error";
        }
    }

    public static double roundit(double d2) {
        int n = (int)Math.pow(10.0, decimals);
        double d3 = (int)Math.round((double)n * d2);
        return d3 / (double)n;
    }

    public String getAllObjects() {
        Object object;
        Enumeration enumeration;
        Object object2;
        String string = "";
        String string2 = "";
        String string3 = "";
        Enumeration enumeration2 = this.ZC.Drawings.elements();
        if (enumeration2.hasMoreElements()) {
            while (enumeration2.hasMoreElements()) {
                object2 = (Drawing)enumeration2.nextElement();
                enumeration = ((Drawing)object2).elements();
                if (!enumeration.hasMoreElements()) continue;
                object = (CoordinatesXY)enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    object = (CoordinatesXY)enumeration.nextElement();
                    string = string + "freehand_point:noname:x=" + ((CoordinatesXY)object).X + ":y=" + ((CoordinatesXY)object).Y + "\n,";
                }
            }
        }
        object2 = this.ZC.getConstruction();
        enumeration = ((Construction)object2).elements();
        while (enumeration.hasMoreElements()) {
            object = (ConstructionObject)enumeration.nextElement();
            string2 = ((ConstructionObject)object).getName().toString().toLowerCase();
            if (string2.indexOf("my_") != -1) continue;
            string3 = ((ConstructionObject)object).getTag().toString().toLowerCase();
            string = this.getDrawing(string3, string2) + "," + string;
        }
        return string;
    }

    public static String[] StringToArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public String ConvertLineNotation(String string) {
        int n = string.indexOf("x=");
        if (n != -1) {
            return string + ":perpendicular";
        }
        n = string.indexOf("x");
        if (n == -1) {
            return string + ":horizontal";
        }
        n = string.indexOf("=");
        if (n != -1) {
            int n2 = string.length();
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, n2);
            n2 = string2.length();
            n = string2.indexOf("x");
            String string4 = string2.substring(0, n);
            if (string4.length() == 0) {
                string4 = "1";
            }
            String string5 = string2.substring(n + 1, n2);
            string5 = string5.replace('y', ' ');
            string5 = string5.replace('*', ' ');
            if ((string5 = string5.replace('+', ' ')).length() == 0) {
                string5 = "1";
            }
            string4 = string4.replace('*', ' ');
            return "slope=-1*(" + string4 + ")/(" + string5 + "):constant=" + "(" + string3 + ")/(" + string5 + "):affine";
        }
        return "error: line not correct";
    }

    private String getthisintersection(String string) {
        String string2 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                IntersectionObject intersectionObject = (IntersectionObject)enumeration.nextElement();
                if (!intersectionObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    double d2 = ZirkelApplet.roundit(intersectionObject.getX());
                    double d3 = ZirkelApplet.roundit(intersectionObject.getY());
                    string2 = "point=" + string + ":" + "x=" + d2 + ":y=" + d3 + "\n";
                    ++n;
                }
                catch (Exception exception) {
                    string2 = "point=" + string + " no value error \n";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "point=" + string + " not present error\n";
        }
        return string2;
    }

    private String getthispoint(String string) {
        String string2 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                PointObject pointObject = (PointObject)enumeration.nextElement();
                if (!pointObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    double d2 = ZirkelApplet.roundit(pointObject.getX());
                    double d3 = ZirkelApplet.roundit(pointObject.getY());
                    string2 = "point=" + string + ":" + "x=" + d2 + ":y=" + d3 + "\n";
                    ++n;
                }
                catch (Exception exception) {
                    string2 = "point=" + string + " no value error \n";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "point=" + string + " not present error\n";
        }
        return string2;
    }

    private String getthisray(String string) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                RayObject rayObject = (RayObject)enumeration.nextElement();
                if (!rayObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    Enumeration enumeration2 = rayObject.depending();
                    while (enumeration2.hasMoreElements()) {
                        try {
                            PointObject pointObject = (PointObject)enumeration2.nextElement();
                            double d2 = ZirkelApplet.roundit(pointObject.getX());
                            double d3 = ZirkelApplet.roundit(pointObject.getY());
                            string3 = "x=" + d2 + ":y=" + d3 + ":" + string3;
                        }
                        catch (Exception exception) {}
                    }
                    string2 = "ray=" + string + ":" + string3 + "length=" + rayObject.getLength();
                    ++n;
                }
                catch (Exception exception) {
                    string2 = "ray=" + string + " no value error";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "ray=" + string + " not present error";
        }
        return string2;
    }

    private String getthissegment(String string) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                SegmentObject segmentObject = (SegmentObject)enumeration.nextElement();
                if (!segmentObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    Enumeration enumeration2 = segmentObject.depending();
                    while (enumeration2.hasMoreElements()) {
                        try {
                            PointObject pointObject = (PointObject)enumeration2.nextElement();
                            double d2 = ZirkelApplet.roundit(pointObject.getX());
                            double d3 = ZirkelApplet.roundit(pointObject.getY());
                            string3 = "x=" + d2 + ":y=" + d3 + ":" + string3;
                        }
                        catch (Exception exception) {}
                    }
                    string2 = "segment=" + string + ":" + string3 + "length=" + segmentObject.getLength();
                    ++n;
                }
                catch (Exception exception) {
                    string2 = "segment=" + string + " no value error";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "segment=" + string + " not present error";
        }
        return string2;
    }

    private String getthisarea(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                AreaObject areaObject = (AreaObject)enumeration.nextElement();
                if (!areaObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    string4 = "";
                    Enumeration enumeration2 = areaObject.depending();
                    while (enumeration2.hasMoreElements()) {
                        try {
                            PointObject pointObject = (PointObject)enumeration2.nextElement();
                            double d2 = ZirkelApplet.roundit(pointObject.getX());
                            double d3 = ZirkelApplet.roundit(pointObject.getY());
                            string4 = "x=" + d2 + ":y=" + d3 + ":" + string4;
                        }
                        catch (Exception exception) {}
                    }
                    string3 = areaObject.getDisplayValue();
                    string2 = "polygon=" + string4 + "area=" + string3 + "\n" + string2;
                    ++n;
                }
                catch (Exception exception) {
                    string2 = "polygon=" + string + " no value error";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "polygon=" + string + " not present error";
        }
        return string2;
    }

    private String getthisline(String string) {
        String string2 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                LineObject lineObject = (LineObject)enumeration.nextElement();
                if (!lineObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    ++n;
                    string2 = lineObject.getEquation();
                    string2 = this.ConvertLineNotation(string2);
                    string2 = "line=" + string + ":" + string2;
                }
                catch (Exception exception) {
                    string2 = "line=" + string + " no value error";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "line=" + string + " not present error";
        }
        return string2;
    }

    private String getthiscircle(String string) {
        String string2 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                CircleObject circleObject = (CircleObject)enumeration.nextElement();
                if (!circleObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    double d2 = ZirkelApplet.roundit(circleObject.getX());
                    double d3 = ZirkelApplet.roundit(circleObject.getY());
                    double d4 = ZirkelApplet.roundit(circleObject.getR());
                    string2 = "circle=" + string + ":" + "x=" + d2 + ":y=" + d3 + ":r=" + d4;
                    ++n;
                }
                catch (Exception exception) {
                    string2 = "circle=" + string + " no value error";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "circle=" + string + " not present error";
        }
        return string2;
    }

    private String getthisfixedcircle(String string) {
        String string2 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                FixedCircleObject fixedCircleObject = (FixedCircleObject)enumeration.nextElement();
                if (!fixedCircleObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    double d2 = ZirkelApplet.roundit(fixedCircleObject.getX());
                    double d3 = ZirkelApplet.roundit(fixedCircleObject.getY());
                    double d4 = ZirkelApplet.roundit(fixedCircleObject.getR());
                    string2 = "fixedcircle=" + string + ":" + "x=" + d2 + ":y=" + d3 + ":r=" + d4;
                    ++n;
                }
                catch (Exception exception) {
                    string2 = "fixedcircle=" + string + " no value error";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "fixedcircle=" + string + " not present error";
        }
        return string2;
    }

    private String getthisangle(String string) {
        String string2 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                AngleObject angleObject = (AngleObject)enumeration.nextElement();
                if (!angleObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    string2 = "angle=" + string + ":value=" + angleObject.getE();
                    ++n;
                }
                catch (Exception exception) {
                    string2 = "angle=" + string + " no value error";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "angle=" + string + " not present error";
        }
        return string2;
    }

    private String getthisfunction(String string) {
        String string2 = "";
        int n = 0;
        Construction construction = this.ZC.getConstruction();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            try {
                FunctionObject functionObject = (FunctionObject)enumeration.nextElement();
                if (!functionObject.getName().equalsIgnoreCase(string)) continue;
                try {
                    ++n;
                    string2 = functionObject.getEquation();
                    string2 = "function=" + string + ":" + string2;
                }
                catch (Exception exception) {
                    string2 = "function=" + string + " no value error";
                }
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            string2 = "function=" + string + " not present error";
        }
        return string2;
    }

    private String getthisFreeDrawing() {
        Enumeration enumeration = this.ZC.Drawings.elements();
        String string = "";
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                Drawing drawing = (Drawing)enumeration.nextElement();
                Enumeration enumeration2 = drawing.elements();
                if (!enumeration2.hasMoreElements()) continue;
                CoordinatesXY coordinatesXY = (CoordinatesXY)enumeration2.nextElement();
                while (enumeration2.hasMoreElements()) {
                    coordinatesXY = (CoordinatesXY)enumeration2.nextElement();
                    string = string + "freehand_point:noname:x=" + coordinatesXY.X + ":y=" + coordinatesXY.Y + "\n,";
                }
            }
        }
        if (string.length() < 1) {
            string = "freehand_drawing not present error";
        }
        return string;
    }

    public String getDrawing(String string, String string2) {
        String string3;
        block12: {
            int n;
            String[] stringArray;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block11: {
                                                        stringArray = ZirkelApplet.StringToArray(string2);
                                                        n = stringArray.length;
                                                        string3 = "";
                                                        if (!string.equalsIgnoreCase("freehand_drawing") && !string.equalsIgnoreCase("freehand_point")) break block11;
                                                        string3 = string3 + this.getthisFreeDrawing() + "\n";
                                                        break block12;
                                                    }
                                                    if (!string.equalsIgnoreCase("line") && !string.equalsIgnoreCase("lines")) break block13;
                                                    for (int i = 0; i < n; ++i) {
                                                        String string4 = stringArray[i];
                                                        string3 = string3 + this.getthisline(string4) + "\n";
                                                    }
                                                    break block12;
                                                }
                                                if (!string.equalsIgnoreCase("function")) break block14;
                                                for (int i = 0; i < n; ++i) {
                                                    String string5 = stringArray[i];
                                                    string3 = string3 + this.getthisfunction(string5) + "\n";
                                                }
                                                break block12;
                                            }
                                            if (!string.equalsIgnoreCase("area") && !string.equalsIgnoreCase("poly") && !string.equalsIgnoreCase("polygon")) break block15;
                                            for (int i = 0; i < n; ++i) {
                                                String string6 = stringArray[i];
                                                string3 = string3 + this.getthisarea(string6) + "\n";
                                            }
                                            break block12;
                                        }
                                        if (!string.equalsIgnoreCase("ray") && !string.equalsIgnoreCase("demiline")) break block16;
                                        for (int i = 0; i < n; ++i) {
                                            String string7 = stringArray[i];
                                            string3 = string3 + this.getthisray(string7) + "\n";
                                        }
                                        break block12;
                                    }
                                    if (!string.equalsIgnoreCase("circle") && !string.equalsIgnoreCase("circles")) break block17;
                                    for (int i = 0; i < n; ++i) {
                                        String string8 = stringArray[i];
                                        string3 = string3 + this.getthiscircle(string8) + "\n";
                                    }
                                    break block12;
                                }
                                if (!string.equalsIgnoreCase("fixedcircle") && !string.equalsIgnoreCase("fixedcircles")) break block18;
                                for (int i = 0; i < n; ++i) {
                                    String string9 = stringArray[i];
                                    string3 = string3 + this.getthisfixedcircle(string9) + "\n";
                                }
                                break block12;
                            }
                            if (!string.equalsIgnoreCase("intersection") && !string.equalsIgnoreCase("intersectionpoint")) break block19;
                            for (int i = 0; i < n; ++i) {
                                String string10 = stringArray[i];
                                string3 = string3 + this.getthisintersection(string10) + "\n";
                            }
                            break block12;
                        }
                        if (!string.equalsIgnoreCase("pointonobject") && !string.equalsIgnoreCase("pointon")) break block20;
                        for (int i = 0; i < n; ++i) {
                            String string11 = stringArray[i];
                            string3 = string3 + this.getthispoint(string11) + "\n";
                        }
                        break block12;
                    }
                    if (!string.equalsIgnoreCase("point") && !string.equalsIgnoreCase("points")) break block21;
                    for (int i = 0; i < n; ++i) {
                        String string12 = stringArray[i];
                        string3 = string3 + this.getthispoint(string12) + "\n";
                    }
                    break block12;
                }
                if (!string.equalsIgnoreCase("segment") && !string.equalsIgnoreCase("segments")) break block22;
                for (int i = 0; i < n; ++i) {
                    String string13 = stringArray[i];
                    string3 = string3 + this.getthissegment(string13) + "\n";
                }
                break block12;
            }
            if (!string.equalsIgnoreCase("angle") && !string.equalsIgnoreCase("angles")) break block12;
            for (int i = 0; i < n; ++i) {
                String string14 = stringArray[i];
                string3 = string3 + this.getthisangle(string14) + "\n";
            }
        }
        return string3;
    }

    public boolean putConstruction(String string) {
        System.out.println("trying:" + string);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "utf-8"));
            printWriter.print(string);
            printWriter.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.ZC.load(byteArrayInputStream, true, true);
            System.out.println("loaded " + byteArrayInputStream);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("error" + exception);
            return false;
        }
    }

    public void track() {
        if (this.ZC.getCurrentTool() instanceof ObjectTracker && ((ObjectTracker)this.ZC.getCurrentTool()).isComplete()) {
            ((ObjectTracker)this.ZC.getCurrentTool()).keep(this.ZC);
        }
    }
}

