/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ParallelConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PlumbObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class PlumbConstructor
extends ParallelConstructor {
    public PrimitiveLineObject create(Construction construction, PrimitiveLineObject primitiveLineObject, PointObject pointObject) {
        return new PlumbObject(construction, primitiveLineObject, pointObject);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.L == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.plumb.first", "Plumb Line: Choose a line!"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.plumb.second", "Plumb Line: Choose a Point!"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Plumb")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("point") || !xmlTag.hasParam("line")) {
            throw new ConstructionException("Plumb parameters missing!");
        }
        try {
            PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("point"));
            PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)construction.find(xmlTag.getValue("line"));
            PlumbObject plumbObject = new PlumbObject(construction, primitiveLineObject, pointObject);
            if (xmlTag.hasParam("valid")) {
                plumbObject.setRestricted(false);
            }
            this.setName(xmlTag, plumbObject);
            this.set(xmlTree, plumbObject);
            if (xmlTag.hasParam("partial")) {
                plumbObject.setPartial(true);
            }
            construction.add(plumbObject);
            this.setConditionals(xmlTree, construction, plumbObject);
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            throw new ConstructionException("Plumb parameters illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.plumb");
    }

    public String getTag() {
        return "Plumb";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject constructionObject = construction.find(stringArray[0]);
        if (constructionObject == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
        }
        ConstructionObject constructionObject2 = construction.find(stringArray[1]);
        if (constructionObject2 == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[1]);
        }
        if (!(constructionObject instanceof PrimitiveLineObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
        }
        if (!(constructionObject2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[1]);
        }
        PlumbObject plumbObject = new PlumbObject(construction, (PrimitiveLineObject)constructionObject, (PointObject)constructionObject2);
        if (!string.equals("")) {
            plumbObject.setNameCheck(string);
        }
        construction.add(plumbObject);
        plumbObject.setDefaults();
    }
}

