/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.structures.Coordinates;

public class CircleIntersectionObject
extends IntersectionObject {
    public CircleIntersectionObject(Construction construction, PrimitiveCircleObject primitiveCircleObject, PrimitiveCircleObject primitiveCircleObject2, boolean bl) {
        super(construction, primitiveCircleObject, primitiveCircleObject2);
        this.First = bl;
        this.validate();
    }

    public void updateCircleDep() {
        ((PrimitiveCircleObject)this.P1).addDep(this);
        ((PrimitiveCircleObject)this.P2).addDep(this);
    }

    public void validate() {
        boolean bl = this.Valid;
        this.Valid = this.P1.valid() && this.P2.valid();
        if (!this.Valid) {
            return;
        }
        Coordinates coordinates = PrimitiveCircleObject.intersect((PrimitiveCircleObject)this.P1, (PrimitiveCircleObject)this.P2);
        if (coordinates == null) {
            if (bl && this.getConstruction().shouldSwitch()) {
                this.doSwitch();
                if (!this.getConstruction().noteSwitch()) {
                    this.Switched = false;
                }
            } else if (bl && this.Alternate && this.Away == null && this.getConstruction().canAlternate()) {
                this.First = !this.First;
            }
            this.Valid = false;
            return;
        }
        PointObject pointObject = this.getAway();
        if (pointObject != null) {
            double d2;
            boolean bl2;
            double d3;
            double d4 = pointObject.getX();
            double d5 = (d4 - coordinates.X) * (d4 - coordinates.X) + ((d3 = pointObject.getY()) - coordinates.Y) * (d3 - coordinates.Y);
            boolean bl3 = bl2 = d5 > (d2 = (d4 - coordinates.X1) * (d4 - coordinates.X1) + (d3 - coordinates.Y1) * (d3 - coordinates.Y1));
            if (!this.StayAway) {
                boolean bl4 = bl2 = !bl2;
            }
            if (bl2) {
                this.X = coordinates.X;
                this.Y = coordinates.Y;
            } else {
                this.X = coordinates.X1;
                this.Y = coordinates.Y1;
            }
        } else if (this.First) {
            this.X = coordinates.X;
            this.Y = coordinates.Y;
        } else {
            this.X = coordinates.X1;
            this.Y = coordinates.Y1;
        }
        if (this.Restricted) {
            if (((PrimitiveCircleObject)this.P1).getStart() != this && ((PrimitiveCircleObject)this.P1).getEnd() != this && !((PrimitiveCircleObject)this.P1).contains(this.X, this.Y)) {
                this.Valid = false;
            }
            if (((PrimitiveCircleObject)this.P2).getStart() != this && ((PrimitiveCircleObject)this.P2).getEnd() != this && !((PrimitiveCircleObject)this.P2).contains(this.X, this.Y)) {
                this.Valid = false;
            }
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        super.printArgs(xmlWriter);
        if (this.First) {
            xmlWriter.printArg("which", "first");
        } else {
            xmlWriter.printArg("which", "second");
        }
    }

    public boolean isSwitchable() {
        return true;
    }

    public boolean canAlternate() {
        return true;
    }
}

