/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.TwoPointLineObject;

public class SegmentObject
extends TwoPointLineObject {
    static Count N = new Count();
    protected boolean Fixed = false;
    Expression E;
    boolean ExpressionFailed;
    boolean Arrow = false;

    public SegmentObject(Construction construction, PointObject pointObject, PointObject pointObject2) {
        super(construction, pointObject, pointObject2);
        this.validate();
        this.updateText();
        this.Unit = Global.getParameter("unit.length", "");
    }

    public String getTag() {
        return "Segment";
    }

    public int getN() {
        return N.next();
    }

    public void setDefaults() {
        this.Arrow = this.Cn.Vectors;
        super.setDefaults();
    }

    public void updateText() {
        if (!this.Fixed) {
            this.setText(SegmentObject.text2(Zirkel.name("text.segment"), this.P1.getName(), this.P2.getName()));
        } else if (this.E == null) {
            this.setText(SegmentObject.text3(Zirkel.name("text.segment.fixed"), this.P1.getName(), this.P2.getName(), "" + this.round(this.R)));
        } else {
            this.setText(SegmentObject.text3(Zirkel.name("text.segment.fixed"), this.P1.getName(), this.P2.getName(), "\"" + this.E.toString() + "\""));
        }
    }

    public void validate() {
        this.ExpressionFailed = false;
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X1 = this.P1.getX();
        this.Y1 = this.P1.getY();
        this.X2 = this.P2.getX();
        this.Y2 = this.P2.getY();
        this.DX = this.X2 - this.X1;
        this.DY = this.Y2 - this.Y1;
        this.R = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
        if (this.Fixed && this.E != null) {
            try {
                ConstructionObject constructionObject;
                double d2 = this.E.getValue();
                if (d2 < 1.0E-8) {
                    this.R = 0.0;
                    this.ExpressionFailed = true;
                    this.Valid = false;
                    return;
                }
                boolean bl = this.P1.moveableBy(this);
                boolean bl2 = this.P2.moveableBy(this);
                if (this.P2.getBound() != null) {
                    ConstructionObject constructionObject2 = this.P2.getBound();
                    if (constructionObject2 instanceof RayObject && ((RayObject)constructionObject2).getP1() == this.P1) {
                        bl2 = true;
                    }
                } else if (this.P1.getBound() != null && (constructionObject = this.P1.getBound()) instanceof RayObject && ((RayObject)constructionObject).getP1() == this.P2) {
                    bl = true;
                    bl2 = false;
                }
                if (bl2) {
                    if (this.R < 1.0E-10) {
                        this.P2.move(this.X1 + d2, this.Y1);
                    } else {
                        this.P2.move(this.X1 + d2 * this.DX / this.R, this.Y1 + d2 * this.DY / this.R);
                    }
                    this.P1.setUseAlpha(false);
                } else if (bl) {
                    if (this.R < 1.0E-10) {
                        this.P1.move(this.X2 - d2, this.Y2);
                    } else {
                        this.P1.move(this.X2 - d2 * this.DX / this.R, this.Y2 - d2 * this.DY / this.R);
                    }
                    this.P2.setUseAlpha(false);
                } else {
                    this.Fixed = false;
                }
                if (this.Fixed) {
                    this.X1 = this.P1.getX();
                    this.Y1 = this.P1.getY();
                    this.X2 = this.P2.getX();
                    this.Y2 = this.P2.getY();
                    this.DX = this.X2 - this.X1;
                    this.DY = this.Y2 - this.Y1;
                    this.R = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
                    this.P2.movedBy(this);
                    this.P1.movedBy(this);
                }
            }
            catch (Exception exception) {
                this.ExpressionFailed = true;
                this.Valid = false;
                this.R = 0.0;
                return;
            }
        }
        if (this.R < 1.0E-10) {
            this.R = 0.0;
            this.DX = 1.0;
            this.DY = 0.0;
        } else {
            this.DX /= this.R;
            this.DY /= this.R;
        }
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        String string;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        double d2 = zirkelCanvas.col(this.X1);
        double d3 = zirkelCanvas.row(this.Y1);
        double d4 = zirkelCanvas.col(this.X2);
        double d5 = zirkelCanvas.row(this.Y2);
        if (this.visible(zirkelCanvas)) {
            if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                ((MyGraphics13)myGraphics).drawMarkerLine(d2, d3, d4, d5);
            }
            myGraphics.setColor(this);
            myGraphics.drawLine(d2, d3, d4, d5, this);
            if (this.Arrow) {
                double d6 = 2.827433388230814;
                double d7 = zirkelCanvas.dx(zirkelCanvas.scale(Global.getParameter("arrowsize", 15)));
                myGraphics.drawLine(d4, d5, zirkelCanvas.col(this.X2 + (this.DX * Math.cos(d6) + this.DY * Math.sin(d6)) * d7), zirkelCanvas.row(this.Y2 + (-this.DX * Math.sin(d6) + this.DY * Math.cos(d6)) * d7), this);
                d6 = -d6;
                myGraphics.drawLine(d4, d5, zirkelCanvas.col(this.X2 + (this.DX * Math.cos(d6) + this.DY * Math.sin(d6)) * d7), zirkelCanvas.row(this.Y2 + (-this.DX * Math.sin(d6) + this.DY * Math.cos(d6)) * d7), this);
            }
        }
        if (!(string = this.getDisplayText()).equals("")) {
            myGraphics.setLabelColor(this);
            this.setFont(myGraphics);
            this.DisplaysText = true;
            if (this.KeepClose) {
                double d8 = this.YcOffset < 0.0 ? 1.0 : -1.0;
                this.drawLabel(myGraphics, string, zirkelCanvas, this.X1 + this.XcOffset * (this.X2 - this.X1), this.Y1 + this.XcOffset * (this.Y2 - this.Y1), d8 * this.DX, d8 * this.DY, 0.0, 0.0);
            } else {
                this.drawLabel(myGraphics, string, zirkelCanvas, (this.X1 + this.X2) / 2.0, (this.Y1 + this.Y2) / 2.0, this.DX, this.DY, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double d2, double d3) {
        this.KeepClose = true;
        this.XcOffset = (d2 - this.X1) / this.R * this.DX + (d3 - this.Y1) / this.R * this.DY;
        this.YcOffset = (d2 - this.X1) / this.R * this.DY - (d3 - this.Y1) / this.R * this.DX;
    }

    public String getDisplayValue() {
        return "" + this.round(this.R, ZirkelCanvas.LengthsFactor);
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (this.ExpressionFailed && this.P1.valid()) {
            return this.P1.nearto(n, n2, zirkelCanvas);
        }
        if (this.ExpressionFailed && this.P2.valid()) {
            return this.P2.nearto(n, n2, zirkelCanvas);
        }
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        double d2 = zirkelCanvas.x(n);
        double d3 = zirkelCanvas.y(n2);
        double d4 = (d2 - this.X1) * this.DY - (d3 - this.Y1) * this.DX;
        double d5 = (d2 - this.X1) * this.DX + (d3 - this.Y1) * this.DY;
        double d6 = (this.X2 - this.X1) * this.DX + (this.Y2 - this.Y1) * this.DY;
        if (d6 > 0.0) {
            if (d5 > d6) {
                d4 = Math.sqrt((d2 - this.X2) * (d2 - this.X2) + (d3 - this.Y2) * (d3 - this.Y2));
            } else if (d5 < 0.0) {
                d4 = Math.sqrt((d2 - this.X1) * (d2 - this.X1) + (d3 - this.Y1) * (d3 - this.Y1));
            }
        } else if (d5 < d6) {
            d4 = Math.sqrt((d2 - this.X2) * (d2 - this.X2) + (d3 - this.Y2) * (d3 - this.Y2));
        } else if (d5 > 0.0) {
            d4 = Math.sqrt((d2 - this.X1) * (d2 - this.X1) + (d3 - this.Y1) * (d3 - this.Y1));
        }
        this.Value = Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d4) - zirkelCanvas.col(zirkelCanvas.minX())) * 0.9;
        return this.Value < zirkelCanvas.selectionSize();
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return this.R < zirkelCanvas.dx(3 * (int)zirkelCanvas.pointSize());
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("from", this.P1.getName());
        xmlWriter.printArg("to", this.P2.getName());
        if (this.Fixed && this.E != null) {
            xmlWriter.printArg("fixed", this.E.toString());
        }
        if (this.Arrow) {
            xmlWriter.printArg("arrow", "true");
        }
        super.printArgs(xmlWriter);
    }

    public double getLength() {
        return this.R;
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean bl, String string) throws ConstructionException {
        if (!bl || string.equals("")) {
            this.Fixed = false;
            this.E = null;
        } else {
            this.E = new Expression(string, this.getConstruction(), this);
            if (!this.E.isValid()) {
                throw new ConstructionException(this.E.getErrorText());
            }
            this.Fixed = true;
        }
        this.updateText();
    }

    public void round() {
        try {
            this.setFixed(true, this.getDisplayValue());
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canFix() {
        return this.P1.moveableBy(this) || this.P2.moveableBy(this);
    }

    public boolean contains(double d2, double d3) {
        double d4 = (d2 - this.X1) * this.DX + (d3 - this.Y1) * this.DY;
        return !(d4 < -1.0E-9) && !(d4 > this.R + 1.0E-9);
    }

    public double project(double d2, double d3) {
        double d4 = super.project(d2, d3);
        if (d4 < 0.0) {
            return 0.0;
        }
        if (d4 > this.R) {
            return this.R;
        }
        return d4;
    }

    public boolean equals(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof SegmentObject) || !constructionObject.valid()) {
            return false;
        }
        SegmentObject segmentObject = (SegmentObject)constructionObject;
        return this.equals(this.X1, segmentObject.X1) && this.equals(this.X2, segmentObject.X2) && this.equals(this.Y1, segmentObject.Y1) && this.equals(this.Y2, segmentObject.Y2) || this.equals(this.X1, segmentObject.X2) && this.equals(this.Y1, segmentObject.Y2) && this.equals(this.X2, segmentObject.X1) && this.equals(this.Y2, segmentObject.Y1);
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        super.edit(zirkelCanvas);
        if (this.E != null && !this.E.isValid()) {
            Frame frame = zirkelCanvas.getFrame();
            Warning warning = new Warning(frame, this.E.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
    }

    public boolean isValidFix() {
        return this.E != null && this.E.isValid();
    }

    public String getStringLength() {
        if (this.E != null) {
            return this.E.toString();
        }
        return "" + this.round(this.R);
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    public void translate() {
        super.translate();
        try {
            this.setFixed(this.Fixed, this.E.toString());
            this.E.translate();
        }
        catch (Exception exception) {
            this.Fixed = false;
        }
    }

    public Enumeration depending() {
        if (!this.Fixed || this.E == null) {
            return super.depending();
        }
        super.depending();
        Enumeration enumeration = this.E.getDepList().elements();
        while (enumeration.hasMoreElements()) {
            DL.add((ConstructionObject)enumeration.nextElement());
        }
        return DL.elements();
    }

    public void setArrow(boolean bl) {
        this.Arrow = bl;
    }

    public boolean isArrow() {
        return this.Arrow;
    }

    public void project(PointObject pointObject) {
        double d2 = this.project(pointObject.getX(), pointObject.getY());
        pointObject.setXY(this.getX() + d2 * this.getDX(), this.getY() + d2 * this.getDY());
        pointObject.setA(d2 / this.getLength());
    }

    public void project(PointObject pointObject, double d2) {
        double d3 = d2 * this.getLength();
        pointObject.setXY(this.getX() + d3 * this.getDX(), this.getY() + d3 * this.getDY());
    }

    public boolean moveable() {
        return !this.Fixed && this.P1.moveable() && this.P2.moveable();
    }
}

