/*  This file is part of YUView - The YUV player with advanced analytics toolset
 *   <https://github.com/IENT/YUView>
 *   Copyright (C) 2015  Institut für Nachrichtentechnik, RWTH Aachen University, GERMANY
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   In addition, as a special exception, the copyright holders give
 *   permission to link the code of portions of this program with the
 *   OpenSSL library under certain conditions as described in each
 *   individual source file, and distribute linked combinations including
 *   the two.
 *
 *   You must obey the GNU General Public License in all respects for all
 *   of the code used other than OpenSSL. If you modify file(s) with this
 *   exception, you may extend this exception to your version of the
 *   file(s), but you are not obligated to do so. If you do not wish to do
 *   so, delete this exception statement from your version. If you delete
 *   this exception statement from all source files in the program, then
 *   also delete it here.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <QWidget>

#include "PlaylistTreeWidget.h"
#include <video/VideoCache.h>

namespace VideoCacheStatusWidgetNamespace
{
class VideoCacheStatusWidget : public QWidget
{
  Q_OBJECT

public:
  VideoCacheStatusWidget(QWidget *parent)
      : QWidget(parent), cacheLevelMB(0), cacheRateInBytesPerMs(0), cacheLevelMaxMB(0)
  {
  }
  // Override the paint event
  virtual void paintEvent(QPaintEvent *event) override;
  void         updateStatus(PlaylistTreeWidget *playlistWidget, unsigned int cacheRate);

private:
  // The floating point values (0 to 1) of the end positions of the blocks to draw
  QList<float> relativeValsEnd;
  unsigned int cacheLevelMB;
  unsigned int cacheRateInBytesPerMs;
  int64_t      cacheLevelMaxMB;
};
} // namespace VideoCacheStatusWidgetNamespace

class VideoCacheInfoWidget : public QWidget
{
  Q_OBJECT

public:
  VideoCacheInfoWidget(QWidget *parent = 0);

  void setPlaylistAndCache(PlaylistTreeWidget *plist, video::VideoCache *vCache)
  {
    playlist = plist;
    cache    = vCache;
  };

public slots:
  void onUpdateCacheStatus();

private slots:
  void onGroupBoxToggled(bool on);

private:
  VideoCacheStatusWidgetNamespace::VideoCacheStatusWidget *statusWidget{nullptr};
  QLabel *                                                 cachingInfoLabel{nullptr};

  PlaylistTreeWidget *playlist{nullptr};
  video::VideoCache * cache{nullptr};

  unsigned int cacheRateInBytesPerMs{0};
};
