/* GeneralizedPetersenGraphFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;
import org.grinvin.graphs.Annotation;
import org.grinvin.graphs.Embedding;
import org.grinvin.graphs.Graph;
import org.grinvin.graphs.Vertex;

/**
 * Factory that creates generalized Petersen graphs with the given parameters.
 */
public class GeneralizedPetersenGraphFactory extends AbstractGraphFactory {
    
    //
    @Override protected void createGraph(Graph graph, Embedding embedding, Annotation annotation) {
        int n = ((Integer)values[0]).intValue();
        int k = ((Integer)values[1]).intValue();
        Vertex[] vertices1 = createCycle(graph, embedding, n);
        Vertex[] vertices2 = createCycle(graph, embedding, n);
        for(int i = 0; i < n; i++) {
            double[] coords = new double[2];
            coords[0]=embedding.getCoordinates(vertices2[i])[0]*2/3;
            coords[1]=embedding.getCoordinates(vertices2[i])[1]*2/3;
            embedding.setCoordinates(vertices2[i], coords);
            graph.addNewEdge(vertices1[i], vertices2[i]);
            graph.addNewEdge(vertices1[i], vertices1[(i+1)%n]);
            graph.addNewEdge(vertices2[i], vertices2[(i+k)%n]);
        }
    }
    
    //
    @Override protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        int n = ((Integer)values[0]).intValue();
        int k = ((Integer)values[1]).intValue();
        if ( n < 3 || k < 1 || k > (n-1)/2)
            throw new FactoryParameterException("n should be bigger than 3, k should be bigger than 1 and smaller than (n-1)/2.");
    }
    
}
