# Web launcher - Print the script content
# USAGE: web_launcher $application
web_launcher() {
	local application
	application="$1"

	local prefix_type
	prefix_type=$(application_prefix_type "$application")
	case "$prefix_type" in
		('symlinks')
			launcher_headers
			web_launcher_environment "$application"

			# Generate the game prefix
			launcher_prefix_symlinks_functions
			launcher_prefix_symlinks_build

			# A fake $HOME path is used to not mess up with the user real Firefox profiles.
			persistent_path_diversion
			fake_home_persistent

			web_firefox_profile_path
			web_launcher_run "$application"

			launcher_exit
		;;
		(*)
			error_launchers_prefix_type_unsupported "$application"
			return 1
		;;
	esac
}

# Web launcher - Set the environment
# USAGE: web_launcher_environment $application
web_launcher_environment() {
	local application
	application="$1"

	local game_id path_game web_path
	game_id=$(game_id)
	path_game=$(path_game_data)
	web_path=$(application_exe_escaped "$application")

	cat <<- EOF
	# Set the environment

	GAME_ID='${game_id}'
	PATH_GAME='${path_game}'
	WEB_PATH='/${web_path}'

	EOF
}

# Web launcher - Set the path to the Firefox profile
# USAGE: web_firefox_profile_path
web_firefox_profile_path() {
	cat <<- 'EOF'
	# Compute the path to the Firefox profile for the current session
	firefox_profile_path() {
	    # Firefox profile path can be explicitely set using an environment variable
	    if [ -n "$PLAYIT_FIREFOX_PROFILE_PATH" ]; then
	        printf '%s' "$PLAYIT_FIREFOX_PROFILE_PATH"
	        return 0
	    fi
	    # Compute the default Firefox profile path if none has been explicitely set
	    printf '%s/play.it/firefox/%s' \
	        "${XDG_CACHE_HOME:="$HOME/.cache"}" \
	        "$GAME_ID"
	}

	EOF
}

# Web launcher - Run the Python 3 Web server and open Firefox
# USAGE: web_launcher_run
web_launcher_run() {
	cat <<- 'EOF'
	cd "$PATH_PREFIX"

	# Start local Web server
	WEB_HOST='localhost'
	WEB_PORT='8000'
	python3 -m http.server \
	    --directory "$PWD" \
	    --bind "$WEB_HOST" "$WEB_PORT" &
	WEB_PID=$!

	# Set the path to the dedicated Firefox profile and the local URL of the game
	FIREFOX_PROFILE_PATH=$(firefox_profile_path)
	WEB_URL="http://${WEB_HOST}:${WEB_PORT}${WEB_PATH}"

	EOF

	# Enable a fake $HOME path, to prevent messing up with the user regular Firefox profiles
	fake_home_enable

	cat <<- 'EOF'
	# Run Firefox, using a dedicated profile
	firefox -CreateProfile "./play.it $FIREFOX_PROFILE_PATH"
	## Ignore firefox failure exit code in case of crash, so post-run actions are not skipped.
	firefox -kiosk -no-remote -profile "$FIREFOX_PROFILE_PATH" "$@" "$WEB_URL" || true

	EOF

	# Disable the fake $HOME path
	fake_home_disable

	cat <<- 'EOF'
	# Stop local Web server
	kill -s TERM $WEB_PID

	EOF
}

