/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#ifndef dialog_H
#define dialog_H

#include "../V/Vlibmath.h"

#ifdef dialog_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif


struct balance_data {
	double  weight; /* weight for this test */
	VPoint  rm;     /* rest main gear location (input) */
	VPoint  rn;     /* rest nose gear location (input) */
	double  cm, cn; /* rest compression values of each strut */
	double  Gm, Gn; /* strut + tire lengths */
	double  Km, Kn; /* string constants (output) */
	double  Gpz;    /* the old "grounding point" Z value */
	double  theta;
	};

EXTERN void balance(struct balance_data *s);

EXTERN Widget CreateInfoDialog(Widget parent);

EXTERN Widget CreateGearDialog(Widget parent);

EXTERN Widget CreateDerivDialog(Widget parent);

EXTERN Widget CreatePowerplantDialog(Widget parent);

EXTERN void InitializeDialogs(craftType *c);

EXTERN void GetCraftInfo(craftType *c);

EXTERN void GearCalculate(craftType *c);

#undef EXTERN
#endif
