# Spec file for Mandriva Linux
# $Id: adanaxis.spec.fedora,v 1.4 2007/10/18 00:04:13 southa Exp $
# $Log: adanaxis.spec.fedora,v $
# Revision 1.4  2007/10/18 00:04:13  southa
# Fedora packaging review comments
#
# Revision 1.3  2007/10/17 23:44:50  southa
# Fedora packaging review comments
#
# Revision 1.2  2007/09/27 12:10:09  southa
# Fixed changelog
#
# Revision 1.1  2007/09/27 11:52:44  southa
# Fedora release
#
# Revision 1.1  2007/06/30 16:02:14  southa
# Generic packaging
#
# Revision 1.3  2007/06/29 16:48:30  southa
# Mandriva build
#
# Revision 1.2  2007/06/29 14:41:54  southa
# Mandriva release
#
# Revision 1.1  2007/06/29 12:05:04  southa
# Mandriva packaging
#

%define title     Adanaxis GPL
%define longtitle Adanaxis GPL - an action game in four spatial dimensions

Summary:        Action game in four spatial dimensions
Name:           adanaxisgpl
Version:        1.2.4
Release:        1%{?dist}
License:        GPLv2
Group:          Amusements/Games
URL:            http://www.mushware.com/

Source0:        http://www.mushware.com/files/%{name}-1.2.4.tar.gz

BuildRoot:      %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

BuildRequires:       desktop-file-utils
BuildRequires:       freeglut-devel
BuildRequires:       expat-devel
BuildRequires:       libjpeg-devel
BuildRequires:       libtiff-devel
BuildRequires:       libvorbis-devel
BuildRequires:       pcre-devel
BuildRequires:       SDL_mixer-devel

%description
Adanaxis is a fast-moving first person shooter set in deep space, where the
fundamentals of space itself are changed.  By adding another dimension to
space this game provides an environment with movement in four directions
and six planes of rotation.  Initially the game explains the 4D control
system via a graphical sequence, before moving on to 30 levels of gameplay
with numerous enemy, ally, weapon and mission types.  Features include
simulated 4D texturing, mouse and joystick control, and original music.
Screenshots, movies and further information are available at
http://www.mushware.com/.

Hardware-accelerated 3D is recommended, ideally with support for OpenGL
Shading Language.

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} INSTALL="install -p" CPPROG="cp -p" install

# Build .desktop files

cat > %{name}.desktop <<EOF
[Desktop Entry]
Encoding=UTF-8
Name=%{title}
Comment=%{longtitle}
Exec=%{_bindir}/%{name} 
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=false
Categories=Game;ActionGame;
EOF

cat > %{name}-recover.desktop <<EOF
[Desktop Entry]
Encoding=UTF-8
Name=%{title} (Recovery Mode)
Comment=%{longtitle} (Launch in Recovery Mode)
Exec=%{_bindir}/%{name} --recover
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=false
Categories=Game;ActionGame;
EOF

# Install desktop files

mkdir -p %{buildroot}%{_datadir}/applications
desktop-file-install --vendor=mushware         \
  --dir %{buildroot}%{_datadir}/applications   \
  %{name}.desktop
desktop-file-install --vendor=mushware         \
  --dir %{buildroot}%{_datadir}/applications   \
  %{name}-recover.desktop

# Icons
mkdir -p -m 755 %{buildroot}%{_datadir}/icons/hicolor/16x16/apps
mkdir -p -m 755 %{buildroot}%{_datadir}/icons/hicolor/32x32/apps
mkdir -p -m 755 %{buildroot}%{_datadir}/icons/hicolor/48x48/apps
install -p -m 644 x11/icons/%{name}-16.png %{buildroot}%{_datadir}/icons/hicolor/16x16/apps/%{name}.png
install -p -m 644 x11/icons/%{name}-32.png %{buildroot}%{_datadir}/icons/hicolor/32x32/apps/%{name}.png
install -p -m 644 x11/icons/%{name}-48.png %{buildroot}%{_datadir}/icons/hicolor/48x48/apps/%{name}.png

%post
touch --no-create %{_datadir}/icons/hicolor
if [ -x %{_bindir}/gtk-update-icon-cache ]; then
  %{_bindir}/gtk-update-icon-cache --quiet %{_datadir}/icons/hicolor || :
fi

%postun
touch --no-create %{_datadir}/icons/hicolor
if [ -x %{_bindir}/gtk-update-icon-cache ]; then
  %{_bindir}/gtk-update-icon-cache --quiet %{_datadir}/icons/hicolor || :
fi

%clean
rm -rf %{buildroot}

%files
%defattr(0755,root,root,0755)
%_bindir/*
%defattr(0644,root,root,0755)
%doc COPYING README INSTALL ChangeLog AUTHORS
%dir %{_datadir}/%{name}
%{_datadir}/applications/*
%{_datadir}/%{name}/*
%{_datadir}/icons/hicolor/16x16/apps/%{name}.png
%{_datadir}/icons/hicolor/32x32/apps/%{name}.png
%{_datadir}/icons/hicolor/48x48/apps/%{name}.png
%_mandir/man6/%{name}*.6*

%changelog
* Thu Oct 25 2007 Andy Southgate <andy.southgate@mushware.com> 1.2.4-1
- Updates following further review (bugzilla #309061)

* Wed Oct 17 2007 Andy Southgate <andy.southgate@mushware.com> 1.2.3-1
- Updates following review (bugzilla #309061)

* Thu Sep 27 2007 Andy Southgate <andy.southgate@mushware.com> 1.2.1-1
- Created from Mandriva .spec
