# gt.m4 - Macros to locate and utilise giella-core scripts and required tools
# for the Divvun and Giellatekno infrastructure. -*- Autoconf -*-
# serial 1 (gtsvn-1)
# 
# Copyright © 2011 Divvun/Samediggi/UiT <bugs@divvun.no>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 of the License.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a
# configuration script generated by Autoconf, you may include it under
# the same distribution terms that you use for the rest of that program.

# the prefixes gt_*, _gt_* are reserved here for giellatekno variables and
# macros. It is the same as gettext and probably others, but I expect no
# collisions really.

################################################################################
# Define functions for checking paths and the GIELLA core environment:
################################################################################
AC_DEFUN([gt_PROG_SCRIPTS_PATHS],
[

# Look for an environmental variable GIELLA_MAINTAINER; if found, enable
# additional checks:
AC_ARG_VAR([GIELLA_MAINTAINER], [define if you are maintaining the Giella infra to get additional complaining about infra integrity])
AM_CONDITIONAL([WANT_MAINTAIN], [test x"$GIELLA_MAINTAINER" != x])

AC_PATH_PROG([GTCORESH], [gt-core.sh], [false],
             [$GIELLA_CORE/scripts$PATH_SEPARATOR$GTHOME/giella-core/scripts$PATH_SEPARATOR$PATH])

AC_ARG_WITH([giella-core],
            [AS_HELP_STRING([--with-giella-core=DIRECTORY],
                               [set giella-core to DIRECTORY @<:@default=PATH@:>@])],
            [with_giella_core=$withval],
            [with_giella_core=false])

_giella_core_not_found_message="
GIELLA_CORE could not be set:

Could not set GIELLA_CORE and thus not find required scripts in:
       \$GIELLA_CORE/scripts 
       \$GTHOME/giella-core/scripts 
       $PATH 

       Please do the following: 
       1. svn co https://gtsvn.uit.no/langtech/trunk/giella-core
       2. then either:
         a: cd giella-core && ./autogen.sh && ./configure && make install

          or:
         b: add the following to your ~/.bash_profile or ~/.profile:

       export \$GIELLA_CORE=/path/to/giella-core/checkout/dir

       (replace the path with the real path from 1. above)

          or:
         c: run configure as follows

       ./configure --with-giella-core=/path/to/giella-core/checkout/dir

       (replace the path with the real path from 1. above)
"

AC_MSG_CHECKING([whether we can set GIELLA_CORE])

# --with-giella-core overrides everything:
AS_IF([test "x$with_giella_core" != "xfalse" -a \
          -d "$with_giella_core/scripts" ], [
    GIELLA_CORE=$with_giella_core
    ],[
    # GIELLA_CORE is the env. variable for this dir:
    AS_IF([test "x$GIELLA_CORE" != "x" -a \
              -d "$GIELLA_CORE/scripts"], [], [
        # GIELLA_HOME is the new GTHOME:
        AS_IF([test "x$GIELLA_HOME" != "x" -a \
                  -d "$GIELLA_HOME/giella-core/scripts"], [
            GIELLA_CORE=$GIELLA_HOME/giella-core
        ], [
            # GTHOME for backwards compatibility - it is deprecated:
            AS_IF([test "x$GTHOME" != "x" -a \
                      -d "$GTHOME/giella-core/scripts"], [
                GIELLA_CORE=$GTHOME/giella-core
            ], [
                # GTCORE for backwards compatibility - it is deprecated:
                AS_IF([test "x$GTCORE" != "x" -a \
                          -d "$GTCORE/scripts"], [
                    GIELLA_CORE=$GTCORE
                ], [
                    # Try the gt-core.sh script. NB! It is deprecated:
                    AS_IF([test "x$GTCORESH" != xfalse -a \
                           -d "$(${GTCORESH})/scripts"], [
                        GIELLA_CORE=$(${GTCORESH})
                    ], [
                       # If nothing else works, try pkg-config:
                       AS_IF([pkg-config --exists giella-core], [
                           GIELLA_CORE=$(pkg-config --variable=dir giella-core)
                       ], [
                       AC_MSG_ERROR([${_giella_core_not_found_message}])
                       ])
                   ])
                ])
            ])
        ])
    ])
])
AC_MSG_RESULT([$GIELLA_CORE])

### This is the version of the Giella Core that we require. Update as needed.
### It is possible to specify also subversion revision: 0.1.2-12345
_giella_core_min_version=0.3.7

# GIELLA_CORE/GTCORE env. variable, required by the infrastructure to find scripts:
AC_ARG_VAR([GIELLA_CORE], [directory for the Giella infra core scripts and other required resources])

GTCORE=${GIELLA_CORE}
AC_ARG_VAR([GTCORE], [GTCORE = GIELLA_CORE, retained for backwards compatibility while being cleaned out])

##### Check the version of the giella-core, and stop with error message if too old:
# This is the error message:
giella_core_too_old_message="

The giella-core is too old, we require at least $_giella_core_min_version.

*** ==> PLEASE ENTER THE FOLLOWING COMMANDS: <== ***

cd $GTCORE
svn up
./autogen.sh # required only the first time
./configure  # required only the first time
make
sudo make install # optional, only needed if installed
                  # earlier or installed on a server.
"

# Identify the version of giella-core:
AC_PATH_PROG([GIELLA_CORE_VERSION], [gt-version.sh], [no],
    [$GTCORE/scripts$PATH_SEPARATOR$GTHOME/giella-core/scripts$PATH_SEPARATOR$PATH])
AC_MSG_CHECKING([the version of the Giella Core])
AS_IF([test "x${GIELLA_CORE_VERSION}" != xno],
        [_giella_core_version=$( ${GIELLA_CORE_VERSION} )],
        [AC_MSG_ERROR([gt-version.sh could not be found, installation is incomplete!])
    ])
AC_MSG_RESULT([$_giella_core_version])

AC_MSG_CHECKING([whether the Giella Core version is at least $_giella_core_min_version])
# Compare it to the required version, and error out if too old:
AX_COMPARE_VERSION([$_giella_core_version], [ge], [$_giella_core_min_version],
                   [giella_core_version_ok=yes], [giella_core_version_ok=no])
AS_IF([test "x${giella_core_version_ok}" != xno], [AC_MSG_RESULT([$giella_core_version_ok])],
[AC_MSG_ERROR([$giella_core_too_old_message])])

################################
### Giella-shared dir:
################
# 1. check --with-giella-shared option
# 2. check env GIELLA_SHARED, then GIELLA_HOME, then GTHOME, then GTCORE
# 3. check using pkg-config
# 4. error if not found

AC_ARG_WITH([giella-shared],
            [AS_HELP_STRING([--with-giella-shared=DIRECTORY],
                            [search giella-shared data in DIRECTORY @<:@default=PATH@:>@])],
            [with_giella_shared=$withval],
            [with_giella_shared=false])

AC_MSG_CHECKING([whether we can set GIELLA_SHARED])
# --with-giella-shared overrides everything:
AS_IF([test "x$with_giella_shared" != "xfalse" -a \
    -f $with_giella_shared/all_langs/src/filters/make-optional-transitivity-tags.regex], [
    GIELLA_SHARED=$with_giella_shared
    ],[
    # GiELLA_SHARED is the default env. variable for this dir:
    AS_IF([test "x$GIELLA_SHARED" != "x" -a \
    -f $GIELLA_SHARED/all_langs/src/filters/make-optional-transitivity-tags.regex], [], [
        # GIELLA_HOME is the new GTHOME:
        AS_IF([test "x$GIELLA_HOME" != "x" -a \
    -f $GIELLA_HOME/giella-shared/all_langs/src/filters/make-optional-transitivity-tags.regex], [
            GIELLA_SHARED=$GIELLA_HOME/giella-shared
        ], [
            # GTHOME for backwards compatibility - it is deprecated:
            AS_IF([test "x$GTHOME" != "x" -a \
    -f $GTHOME/giella-shared/all_langs/src/filters/make-optional-transitivity-tags.regex], [
                GIELLA_SHARED=$GTHOME/giella-shared
            ], [
                # GTCORE for backwards compatibility - it is deprecated:
                AS_IF([test "x$GTCORE" != "x" -a \
    -f $GTCORE/giella-shared/all_langs/src/filters/make-optional-transitivity-tags.regex], [
                    GIELLA_SHARED=$GTCORE/giella-shared
                ], [
                   AS_IF([pkg-config --exists giella-common], [
                       GIELLA_SHARED=$(pkg-config --variable=dir giella-common)
                   ],
                   [AC_MSG_ERROR([Could not find giella-common data dir to set GIELLA_SHARED])])
                ])
            ])
        ])
    ])
])
AC_MSG_RESULT([$GIELLA_SHARED])

### This is the version of the Giella Shared that we require. Update as needed.
### It is possible to specify also subversion revision: 0.1.2-12345
_giella_shared_min_version=0.1.7

# GIELLA_SHARED is required by the infrastructure to find shared data:
AC_ARG_VAR([GIELLA_SHARED], [directory for giella shared data, like proper nouns and regexes])

##### Check the version of giella-shared, and stop with error message if too old:
# This is the error message:
giella_shared_too_old_message="

The giella-shared is too old, we require at least $_giella_shared_min_version.

*** ==> PLEASE ENTER THE FOLLOWING COMMANDS: <== ***

cd $GIELLA_SHARED
svn up
./autogen.sh # required only the first time
./configure  # required only the first time
make
sudo make install # optional, only needed if installed
                  # earlier or installed on a server.
"

# Identify the version of giella-shared:
AC_MSG_CHECKING([the version of Giella Shared])
_giella_shared_version=$( pkg-config --modversion $GIELLA_SHARED/giella-common.pc )

# Check whether a version info string was found:
case "$_giella_shared_version" in    # branch to the first pattern
  "")
    _giella_shared_version_found=no  # do this if empty string
    ;;                               # end of this case branch
  *[!0-9.]*)                         # pattern = anything containing a non-digit
    _giella_shared_version_found=no  # do this if the pattern triggered
    ;;                               # end of this case branch
  *)                                 # pattern = anything (else)
    _giella_shared_version_found=yes # do this when matching a version string
    ;;                               # end of this case branch
esac

# If not, recheck using standard pkg-config locations:
AS_IF([test "x$_giella_shared_version_found" = xno ], [
    _giella_shared_version=$( pkg-config --modversion giella-common )
], [test "x$_giella_shared_version_found" = xyes ], [
    true
], [AC_MSG_ERROR([Could not identify version of giella-common shared data])])

AC_MSG_RESULT([$_giella_shared_version])

AC_MSG_CHECKING([whether the version of Giella Shared is at least $_giella_shared_min_version])
# Compare it to the required version, and error out if too old:
AX_COMPARE_VERSION([$_giella_shared_version], [ge], [$_giella_shared_min_version],
                   [giella_shared_version_ok=yes], [giella_shared_version_ok=no])
AS_IF([test "x${giella_shared_version_ok}" != xno], [AC_MSG_RESULT([$giella_shared_version_ok])],
[AC_MSG_ERROR([$giella_shared_too_old_message])])


################################
### Giella-templates dir:
################
# 1. check --with-giella-templates option
# 2. check env GIELLA_TEMPLATES, then GIELLA_HOME, then GTHOME
# 3. error if not found

# GIELLA_TEMPLATES is required if you do infrastructure maintenance, otherwise it is ignored:
AM_COND_IF([WANT_MAINTAIN], [

AC_ARG_WITH([giella-templates],
            [AS_HELP_STRING([--with-giella-templates=DIRECTORY],
                            [search giella-templates data in DIRECTORY @<:@default=PATH@:>@])],
            [with_giella_templates=$withval],
            [with_giella_templates=false])

AC_MSG_CHECKING([whether we can set GIELLA_TEMPLATES])
# --with-giella-templates overrides everything:
AS_IF([test "x$with_giella_templates" != "xfalse" -a \
          -d "$with_giella_templates/langs-templates" ], [
    GIELLA_TEMPLATES=$with_giella_templates
    ],[
    # GIELLA_TEMPLATES is the env. variable for this dir:
    AS_IF([test "x$GIELLA_TEMPLATES" != "x" -a \
              -d "$GIELLA_TEMPLATES/langs-templates"], [], [
        # GIELLA_HOME is the new GTHOME:
        AS_IF([test "x$GIELLA_HOME" != "x" -a \
                  -d "$GIELLA_HOME/giella-templates/langs-templates"], [
            GIELLA_TEMPLATES=$GIELLA_HOME/giella-templates
        ], [
            # GTHOME for backwards compatibility - it is deprecated:
            AS_IF([test "x$GTHOME" != "x" -a \
                      -d "$GTHOME/giella-templates/langs-templates"], [
                GIELLA_TEMPLATES=$GTHOME/giella-templates
            ], [AC_MSG_ERROR([Could not find giella-templates data dir to set GIELLA_TEMPLATES])])
        ])
    ])
])
AC_MSG_RESULT([$GIELLA_TEMPLATES])

# GIELLA_TEMPLATES is required if you do infrastructure maintenance (otherwise it is ignored):
AC_ARG_VAR([GIELLA_TEMPLATES], [directory for infrastructure templates, required for maintainers])

],[])

################################
### Giella-libs dir:
################
# 1. check --with-giella-libs option
# 2. check env GIELLA_LIBS, then GIELLA_HOME, then GTHOME
# 3. empty if not found

AC_ARG_WITH([giella-libs],
            [AS_HELP_STRING([--with-giella-libs=DIRECTORY],
                            [search giella-libs data in DIRECTORY @<:@default=PATH@:>@])],
            [with_giella_libs=$withval],
            [with_giella_libs=false])

AC_MSG_CHECKING([whether we can set GIELLA_LIBS])
# --with-giella-libs overrides everything:
AS_IF([test "x$with_giella_libs" != "xfalse" -a \
          -d "$with_giella_libs" ], [
    GIELLA_LIBS=$with_giella_libs
    ],[
    # GIELLA_LIBS is the env. variable for this dir:
    AS_IF([test "x$GIELLA_LIBS" != "x" -a \
              -d "$GIELLA_LIBS"], [], [
        # GIELLA_HOME is the new GTHOME:
        AS_IF([test "x$GIELLA_HOME" != "x" -a \
                  -d "$GIELLA_HOME/giella-libs" ], [
            GIELLA_LIBS=$GIELLA_HOME/giella-libs
        ], [
            # GTHOME for backwards compatibility - it is deprecated:
            AS_IF([test "x$GTHOME" != "x" -a \
                      -d "$GTHOME/giella-libs" ], [
                GIELLA_LIBS=$GTHOME/giella-libs
            ], [
                GIELLA_LIBS=no
            ])
        ])
    ])
])
AC_MSG_RESULT([$GIELLA_LIBS])

# GIELLA_LIBS is needed for speller builds, but if not found, we'll try to fetch over the net:
AC_ARG_VAR([GIELLA_LIBS], [directory containing precompiled libraries for proofing tools])

################################
### Some software that we either depend on or we need for certain functionality: 
################

################ Weighted fst's ################
AC_PATH_PROG([BC], [bc], [no], [$PATH$PATH_SEPARATOR$with_bc])

################ YAML-based testing ################
AC_ARG_ENABLE([yamltests],
              [AS_HELP_STRING([--enable-yamltests],
                              [enable yaml tests @<:@default=check@:>@])],
              [enable_yamltests=$enableval],
              [enable_yamltests=check])

AS_IF([test "x$enable_yamltests" = "xcheck"], 
     [AM_PATH_PYTHON([3.5],, [:])
     AX_PYTHON_MODULE(yaml)
     AC_MSG_CHECKING([whether to enable yaml-based test])
     AS_IF([test "$PYTHON" = ":"],
           [enable_yamltests=no
            new_enough_python_available=no
            AC_MSG_RESULT([no, python is missing or old])
            ],
           [AS_IF([test "x$HAVE_PYMOD_YAML" != "xyes"],
                  [enable_yamltests=no
                   new_enough_python_available=yes
                   AC_MSG_RESULT([no, yaml is missing])
                   ],
                  [enable_yamltests=yes
                   new_enough_python_available=yes
                   AC_MSG_RESULT([yes])])])])

AM_CONDITIONAL([CAN_YAML_TEST], [test "x$enable_yamltests" != xno])

################ Generated documentation ################
# Check for awk with required feature:
AC_CACHE_CHECK([for awk that supports gensub], [ac_cv_path_GAWK],
  [AC_PATH_PROGS_FEATURE_CHECK([GAWK], [awk mawk nawk gawk],
    [[awkout=`$ac_path_GAWK 'BEGIN{gensub(/a/,"b","g");}'; exvalue=$?; echo $exvalue`
      test "x$awkout" = x0 \
      && ac_cv_path_GAWK=$ac_path_GAWK ac_path_GAWK_found=:]],
    [AC_MSG_ERROR([could not find awk that supports gensub - please install GNU awk])])])
AC_SUBST([GAWK], [$ac_cv_path_GAWK])

# Check for Forrest:
AC_ARG_WITH([forrest],
            [AS_HELP_STRING([--with-forrest=DIRECTORY],
                            [search forrest in DIRECTORY @<:@default=PATH@:>@])],
            [with_forrest=$withval],
            [with_forrest=yes])
AC_PATH_PROG([FORREST], [forrest], [], [$PATH$PATH_SEPARATOR$with_forrest])
AC_MSG_CHECKING([whether to do forrest validation of in-source documentation])
AS_IF([test "x$GAWK" != x], [
    AS_IF([test "x$JV" != xfalse], [
    	AS_IF([test "x$with_forrest" = xyes], [
        	AS_IF([test "x$FORREST" != x],
        	   [giellalt_forrest_validation=yes],
        	   [giellalt_forrest_validation=no])
        ],[giellalt_forrest_validation=no])
    ],[giellalt_forrest_validation=no])
],[giellalt_forrest_validation=no])
AC_MSG_RESULT([$giellalt_forrest_validation])
AM_CONDITIONAL([CAN_FORREST_VALIDATE], [test "x$giellalt_forrest_validation" != xno])

################ can rsync oxt template? ################
AC_PATH_PROG([RSYNC], [rsync], [no], [$PATH$PATH_SEPARATOR$with_rsync])
AC_PATH_PROG([WGET],  [wget],  [no], [$PATH$PATH_SEPARATOR$with_wget])

AS_IF([test "x$GIELLA_LIBS" != "xno" -a \
            "x$RSYNC"       != "xno" ],
      [can_local_sync=yes], [
       can_local_sync=no
       AS_IF([test "x$WGET" != "xno" ],
          [can_wget_giella_libs=yes],
          [can_wget_giella_libs=no])
      ])
AM_CONDITIONAL([CAN_LOCALSYNC], [test "x$can_local_sync" != xno ])
AM_CONDITIONAL([CAN_REMOTE_SYNC], [test "x$can_wget_giella_libs" != xno ])

################ Look for available diff and merge tools: ################
AC_PATH_PROGS([DIFFTOOL], [opendiff kdiff3 meld diffuse kompare], [no], [$PATH$PATH_SEPARATOR$with_difftool])

case $DIFFTOOL in
  *kdiff3 |\
  *meld   |\
  *opendiff )
        can_merge=yes
        ;;
  *)
        can_merge=no
        ;;
esac
AM_CONDITIONAL([CAN_MERGE], [test "x$can_merge" != xno ])

################ GNU Make at least 3.82 on non-OSX systems: ################
#
# Platform specific setup
#
#############################
AC_CANONICAL_HOST
# Check for which host we are on and setup a few things
# specifically based on the host
# This is the minimum GNU Make version required (except on OSX):
_GNU_make_min_version=m4_default([$1], [3.82])

# Then we check against different hosts:
case $host_os in
  darwin* )
        # Do nothing for mac: the included make is fine
        true
        ;;
    *)
        # Default Case: in all other cases check that we are using GNU make
        # and that it is new enough:
        AX_CHECK_GNU_MAKE()
        AC_MSG_CHECKING([whether GNU make is at least $_GNU_make_min_version])
        AX_COMPARE_VERSION([$ax_check_gnu_make_version], [ge],
                           [$_GNU_make_min_version],
                   [
                    AC_MSG_RESULT([yes])
                    # Reset the MAKE variable, to ensure we're using GNU make:
                    MAKE=$_cv_gnu_make_command
                   ],
                   [AC_MSG_ERROR([GNU Make too old ($ax_check_gnu_make_version), please install at least $_GNU_make_min_version])
                   ])
        ;;
esac
################ END of GNU Make check ################

# We need special treatment of Java paths in Cygwin:
AC_CANONICAL_HOST
case "${host}" in
  *-cygwin* | *-mingw*)
    CYGWINJAVAPATH='cygpath -m'
    ;;
  *)
    # Assume Unix.
    CYGWINJAVAPATH=echo
    ;;
esac
AC_SUBST(CYGWINJAVAPATH)

# Check for SubEthaEdit/see
AC_PATH_PROG([SEE], [see], [], [$PATH$PATH_SEPARATOR$with_see])

# Check for grammar checker validation tool:
AC_PATH_PROG([DIVVUN_VALIDATE_SUGGEST], [divvun-validate-suggest], [no], [$PATH$PATH_SEPARATOR$with_divvun_validate_suggest])

]) # gt_PROG_SCRIPTS_PATHS

################################################################################
# Define functions for checking the availability of the Xerox tools:
################################################################################
AC_DEFUN([gt_PROG_XFST],
[AC_ARG_WITH([xfst],
            [AS_HELP_STRING([--with-xfst=DIRECTORY],
                            [search xfst in DIRECTORY @<:@default=PATH@:>@])],
            [with_xfst=$withval],
            [with_xfst=yes])
AC_PATH_PROG([PRINTF], [printf], [echo -n])
AC_PATH_PROG([XFST], [xfst], [false], [$PATH$PATH_SEPARATOR$with_xfst])
AC_PATH_PROG([TWOLC], [twolc], [false], [$PATH$PATH_SEPARATOR$with_xfst])
AC_PATH_PROG([LEXC], [lexc], [false], [$PATH$PATH_SEPARATOR$with_xfst])
AC_PATH_PROG([LOOKUP], [lookup], [false], [$PATH$PATH_SEPARATOR$with_xfst])
AC_MSG_CHECKING([whether to enable xfst building])
AS_IF([test x$with_xfst != xno], [
    AS_IF([test "x$XFST"   != xfalse -a \
                "x$TWOLC"  != xfalse -a \
                "x$LEXC"   != xfalse -a \
                "x$LOOKUP" != xfalse  ], [gt_prog_xfst=yes],
          [gt_prog_xfst=no])
], [gt_prog_xfst=no])
AC_MSG_RESULT([$gt_prog_xfst])
AM_CONDITIONAL([CAN_XFST], [test "x$gt_prog_xfst" != xno])
]) # gt_PROG_XFST

################################################################################
# Define functions for checking the availability of Voikko tools:
################################################################################
AC_DEFUN([gt_PROG_VFST],
[AC_ARG_WITH([voikko],
            [AS_HELP_STRING([--with-voikko=DIRECTORY],
                            [search voikko in DIRECTORY @<:@default=PATH@:>@])],
            [with_voikko=$withval],
            [with_voikko=yes])
AC_PATH_PROG([VOIKKOSPELL],     [voikkospell],     [false],
                                            [$PATH$PATH_SEPARATOR$with_voikko])
AC_PATH_PROG([VOIKKOHYPHENATE], [voikkohyphenate], [false],
                                            [$PATH$PATH_SEPARATOR$with_voikko])
AC_PATH_PROG([VOIKKOGC],        [voikkogc],        [false],
                                            [$PATH$PATH_SEPARATOR$with_voikko])
AC_PATH_PROG([VOIKKOVFSTC],     [voikkovfstc],     [false],
                                            [$PATH$PATH_SEPARATOR$with_voikko])
AC_MSG_CHECKING([whether to enable voikko building])
AS_IF([test x$with_voikko != xno], [
    AS_IF([test "x$VOIKKOSPELL"      != xfalse -a \
                "x$VOIKKOHYPHENATE"  != xfalse -a \
                "x$VOIKKOGC"         != xfalse -a \
                "x$VOIKKOVFSTC"      != xfalse  ], [gt_prog_voikko=yes],
          [gt_prog_voikko=no])
], [gt_prog_voikko=no])
AC_MSG_RESULT([$gt_prog_voikko])
AM_CONDITIONAL([CAN_VFST], [test "x$gt_prog_voikko" != xno])
]) # gt_PROG_VFST

################################################################################
# Define functions for checking the availability of the Foma tools:
################################################################################
AC_DEFUN([gt_PROG_FOMA],
[AC_ARG_WITH([foma],
            [AS_HELP_STRING([--with-foma=DIRECTORY],
                            [search foma in DIRECTORY @<:@default=PATH@:>@])],
            [with_foma=$withval],
            [with_foma=no])

# If Xerox tools and Hfst are not found, assume we want Foma:
AS_IF([test x$gt_prog_xfst = xno \
         -a x$gt_prog_hfst = xno \
         -a "x$with_xfst" != xno \
         -a "x$with_hfst" != xno ],
      [
      with_foma=yes
      fallback_to_foma="INFO: Neither Xfst nor Hfst were found, falling back to using Foma"
      ])

AC_PATH_PROG([PRINTF], [printf], [echo -n])
AC_PATH_PROG([FOMA], [foma], [false], [$PATH$PATH_SEPARATOR$with_foma])
AC_PATH_PROG([FLOOKUP], [flookup], [false], [$PATH$PATH_SEPARATOR$with_foma])
AC_PATH_PROG([CGFLOOKUP], [cgflookup], [false], [$PATH$PATH_SEPARATOR$with_foma])
AC_MSG_CHECKING([whether to enable foma building])
AS_IF([test x$with_foma != xno], [
    AS_IF([test "x$FOMA"      != xfalse -a \
                "x$FLOOKUP"   != xfalse -a \
                "x$CGFLOOKUP" != xfalse  ], [gt_prog_foma=yes],
          [gt_prog_foma=no])
], [gt_prog_foma=no])
AC_MSG_RESULT([$gt_prog_foma])

AS_IF([test x$gt_prog_foma = xyes \
      -a "x$(grep 'GT_PHONOLOGY_MAIN' ${srcdir}/src/phonology/Makefile.am \
      	| grep 'twolc')" != "x" ],
      [AC_MSG_ERROR([You only have Foma, or you requested to use Foma, but \
your main phonology file is a twolc file, which Foma can not compile. You need \
to use either Hfst or the Xerox FSM tools when compiling transducers for \
$GLANG ($GLANGUAGE).
])])

AM_CONDITIONAL([CAN_FOMA], [test "x$gt_prog_foma" != xno])
AM_CONDITIONAL([HAS_FOMA], [test "x$FOMA" != xfalse ])
]) # gt_PROG_FOMA

################################################################################
# Define functions for checking the availability of the VISLCG3 tools:
################################################################################
AC_DEFUN([gt_PROG_VISLCG3],
[AC_ARG_WITH([vislcg3],
            [AS_HELP_STRING([--with-vislcg3=DIRECTORY],
                            [search vislcg3 in DIRECTORY @<:@default=PATH@:>@])],
            [with_vislcg3=$withval],
            [with_vislcg3=check])
AC_PATH_PROG([VISLCG3], [vislcg3], [no], [$PATH$PATH_SEPARATOR$with_vislcg3])
AC_PATH_PROG([VISLCG3_COMP], [cg-comp], [no], [$PATH$PATH_SEPARATOR$with_vislcg3])
AC_PATH_PROG([CG_RELABEL], [cg-relabel], [no], [$PATH$PATH_SEPARATOR$with_vislcg3])
AC_PATH_PROG([CG_MWESPLIT], [cg-mwesplit], [no], [$PATH$PATH_SEPARATOR$with_vislcg3])

AS_IF([test "x$VISLCG3" != xno], [
_giella_core_vislcg3_min_version=m4_default([$1], [1.0.0])
AC_MSG_CHECKING([whether vislcg3 is at least $_giella_core_vislcg3_min_version])
_vislcg3_version=$( ${VISLCG3} --version 2>&1 | grep -Eo '@<:@0-9@:>@+\.@<:@0-9.@:>@+' )
AX_COMPARE_VERSION([$_vislcg3_version], [ge], [$_giella_core_vislcg3_min_version],
                   [gt_prog_vislcg3=yes
                    AC_MSG_RESULT([yes - $_vislcg3_version])
                   ], [gt_prog_vislcg3=no
                    AC_MSG_RESULT([no - $_vislcg3_version])
                   ])
],
[gt_prog_vislcg3=no])
AC_MSG_CHECKING([whether we can enable vislcg3 targets])
AS_IF([test "x$gt_prog_vislcg3" != xno], [AC_MSG_RESULT([yes])],
      [AC_MSG_RESULT([no])])
AM_CONDITIONAL([CAN_VISLCG], [test "x$gt_prog_vislcg3" != xno])
]) # gt_PROG_VISLCG3

################################################################################
# Define functions for checking the availability of Saxon:
################################################################################
AC_DEFUN([gt_PROG_SAXON],
[AC_ARG_WITH([saxon],
             [AS_HELP_STRING([--with-saxon=DIRECTORY],
                             [search saxon wrapper script in DIRECTORY @<:@default=PATH@:>@])],
             [with_saxon=$withval],
             [with_saxon=check])
AC_PATH_PROG([SAXON], [saxonb-xslt saxon9 saxon8 saxon], [false], [$PATH$PATH_SEPARATOR$with_saxon])
AC_PATH_PROG([JV], [java], [false])
AC_CHECK_FILE([$HOME/lib/saxon9he.jar],
    AC_SUBST(SAXONJAR, [$HOME/lib/saxon9he.jar]),
    [AC_CHECK_FILE([$HOME/lib/saxon9.jar],
        AC_SUBST(SAXONJAR, [$HOME/lib/saxon9.jar]),
        [AC_CHECK_FILE([/opt/local/share/java/saxon9he.jar],
            AC_SUBST(SAXONJAR, [/opt/local/share/java/saxon9he.jar]),
            [AC_CHECK_FILE([/usr/share/java/Saxon-HE.jar],
                AC_SUBST(SAXONJAR, [/usr/share/java/Saxon-HE.jar]),
                [AC_CHECK_FILE([/usr/share/java/saxon.jar],
                AC_SUBST(SAXONJAR, [/usr/share/java/saxon.jar]),
                    [_saxonjar=no])
                    ])])])]
)
AS_IF([test "x$_saxonjar" != xno], [
_saxon_min_version="8.0"
_saxon_version=$( java -jar $SAXONJAR -? 2>&1 | fgrep -i 'saxon' | grep -Eo '@<:@0-9@:>@+\.@<:@0-9.@:>@+' )
AC_MSG_CHECKING([whether the Saxon JAR is at least $_saxon_min_version])
AX_COMPARE_VERSION([$_saxon_version], [ge], [$_saxon_min_version],
                   [_saxonjar=yes
                    AC_MSG_RESULT([yes - $_saxon_version])
                   ], [_saxonjar=no
                    AC_MSG_RESULT([no - $_saxon_version])
                   ])
],
[_saxonjar=no])
AC_MSG_CHECKING([whether we can enable xslt2 transformations])
AS_IF([test x$with_saxon != xno], [
    AS_IF([test "x$SAXON" != xfalse], [gt_prog_saxon=yes],
          [gt_prog_saxon=no])
    AS_IF([test x$JV != xfalse], [gt_prog_java=yes], [gt_prog_java=no])
    AS_IF([test x$gt_prog_java != xno -a x$_saxonjar != xno],
          [gt_prog_xslt=yes], [gt_prog_xslt=no])
], [gt_prog_xslt=no])
AC_MSG_RESULT([$gt_prog_xslt])
AM_CONDITIONAL([CAN_SAXON], [test "x$gt_prog_saxon" != xno])
AM_CONDITIONAL([CAN_JAVA], [test "x$gt_prog_java" != xno -a "x$_saxonjar" != xno]) 
]) # gt_PROG_SAXON

################################################################################
# Define functions for configuration of the build targets:
################################################################################
AC_DEFUN([gt_ENABLE_TARGETS],
[
# Foma-speller requires gzip, Voikko requires zip:
AC_PATH_PROG([ZIP],    [zip],      [false], [$PATH$PATH_SEPARATOR$with_zip])
AC_PATH_PROG([GZIP],   [gzip],     [false], [$PATH$PATH_SEPARATOR$with_gzip])
AC_PATH_PROGS([TAR],   [tar gtar], [false], [$PATH$PATH_SEPARATOR$with_tar])
AC_PATH_PROG([PATGEN], [patgen],   [false], [$PATH$PATH_SEPARATOR$with_patgen])
AC_PATH_PROG([PERL],   [perl],     [false], [$PATH$PATH_SEPARATOR$with_perl])
AC_PATH_PROG([XZ],     [xz],       [false], [$PATH$PATH_SEPARATOR$with_xz])
AM_CONDITIONAL([CAN_XZ], [test "x$ac_cv_prog_XZ" != xfalse])

############ (Hfst) compilation optimisation: ############
# Enable hyperminimisation of the lexical transducer - default is 'no'
AC_ARG_ENABLE([hyperminimisation],
              [AS_HELP_STRING([--enable-hyperminimisation],
                              [enable hyperminimisation of lexical fst @<:@default=no@:>@])],
              [enable_hyperminimisation=$enableval],
              [enable_hyperminimisation=no])
AM_CONDITIONAL([WANT_HYPERMINIMISATION], [test "x$enable_hyperminimisation" != xno])

# Enable symbol alignment of the lexical transducer - default is 'no'
AC_ARG_ENABLE([alignment],
              [AS_HELP_STRING([--enable-alignment],
                              [enable symbol alignment when parsing lexc @<:@default=yes@:>@])],
              [enable_alignment=$enableval],
              [enable_alignment=yes])
AM_CONDITIONAL([WANT_LEXC_ALIGNMENT], [test "x$enable_alignment" != xno])

#enable_twostep_intersect
AC_ARG_ENABLE([twostep-intersect],
              [AS_HELP_STRING([--enable-twostep-intersect],
                              [enable two-step compose-intersect (more correct in rare cases, might be slower) @<:@default=no@:>@])],
              [enable_twostep_intersect=$enableval],
              [enable_twostep_intersect=no])
AM_CONDITIONAL([WANT_TWOSTEP_INTERSECT], [test "x$enable_twostep_intersect" != xno])

#enable_reversed_intersect
AC_ARG_ENABLE([reversed-intersect],
              [AS_HELP_STRING([--enable-reversed-intersect],
                              [enable reversed compose-intersect (faster and takes less RAM in some cases) @<:@default=no@:>@])],
              [enable_reversed_intersect=$enableval],
              [enable_reversed_intersect=no])
AM_CONDITIONAL([WANT_REVERSED_INTERSECT], [test "x$enable_reversed_intersect" != xno])

############ Tool switches: ############
# Enable all stable tools in one go:
AC_ARG_ENABLE([all_tools],
			  [AS_HELP_STRING([--enable-all-tools],
			  [build all tools (excluding unstable or experimental tools, which must be explicitly enabled with --enable-dialects, --enable-glossers, --enable-phonetic, --enable-downcaseerror, --enable-L2, --enable-pattern-hyphenators, --enable-fomaspeller, --enable-vfstspeller) @<:@default=no@:>@])],
			  [enable_all_tools=$enableval],
			  [enable_all_tools=no])

# Enable morphological analysers - default is 'yes'
AC_ARG_ENABLE([analysers],
              [AS_HELP_STRING([--enable-analysers],
                              [build morphological analysers @<:@default=yes@:>@])],
              [enable_analysers=$enableval],
              [enable_analysers=yes])
AM_CONDITIONAL([WANT_MORPHOLOGY], [test "x$enable_analysers" != xno])

# Enable morphological generators - default is 'yes'
AC_ARG_ENABLE([generators],
              [AS_HELP_STRING([--enable-generators],
                              [build morphological generators @<:@default=yes@:>@])],
              [enable_generators=$enableval],
              [enable_generators=yes])
AM_CONDITIONAL([WANT_GENERATION], [test "x$enable_generators" != xno])

# Enable glossing morphological analysers - default is 'no'
AC_ARG_ENABLE([glossers],
              [AS_HELP_STRING([--enable-glossers],
                              [build glossing morphological analysers @<:@default=no@:>@])],
              [enable_glossers=$enableval],
              [enable_glossers=no])
AM_CONDITIONAL([WANT_GLOSSERS], [test "x$enable_glossers" != xno])

# Enable text transcriptors - default is 'yes'
AC_ARG_ENABLE([transcriptors],
              [AS_HELP_STRING([--enable-transcriptors],
                              [build text transcriptors @<:@default=yes@:>@])],
              [enable_transcriptors=$enableval],
              [enable_transcriptors=yes])
AM_CONDITIONAL([WANT_TRANSCRIPTORS], [test "x$enable_transcriptors" != xno])

# Enable syntactic parsing - default is 'yes'
AC_ARG_ENABLE([syntax],
              [AS_HELP_STRING([--enable-syntax],
                              [build syntax parsing tools @<:@default=yes@:>@])],
              [enable_syntax=$enableval],
              [enable_syntax=yes])
AS_IF([test "x$enable_syntax" = "xyes" -a "x$gt_prog_vislcg3" = "xno"],
             [enable_syntax=no
              AC_MSG_ERROR([vislcg3 tools missing or too old, please install or disable syntax tools!])])
AM_CONDITIONAL([WANT_SYNTAX], [test "x$enable_syntax" != xno])
# $gt_prog_vislcg3

# Enable grammar checkers - default is 'no' (via $enable_all_tools)
AC_ARG_ENABLE([grammarchecker],
              [AS_HELP_STRING([--enable-grammarchecker],
                              [enable grammar checker @<:@default=no@:>@])],
              [enable_grammarchecker=$enableval],
              [enable_grammarchecker=$enable_all_tools])
AS_IF([test "x$enable_grammarchecker" = "xyes" -a "x$gt_prog_vislcg3" = "xno"], 
      [enable_grammarchecker=no
       AC_MSG_ERROR([vislcg3 missing or too old - required for the grammar checker])],
      [AS_IF([test "x$enable_grammarchecker" = "xyes" -a "x$DIVVUN_VALIDATE_SUGGEST" = "xno"], 
          [enable_grammarchecker=no
           AC_MSG_ERROR([divvun-validate-suggest required for building grammar checkers])])])
AM_CONDITIONAL([WANT_GRAMCHECK], [test "x$enable_grammarchecker" != xno])

# Enable all spellers - default is 'no'
AC_ARG_ENABLE([spellers],
              [AS_HELP_STRING([--enable-spellers],
                              [build any/all spellers @<:@default=no@:>@])],
              [enable_spellers=$enableval],
              [enable_spellers=$enable_all_tools])
AS_IF([test "x$enable_grammarchecker" != xno],[enable_spellers=yes])
AM_CONDITIONAL([WANT_SPELLERS], [test "x$enable_spellers" != xno])

# Enable hfst desktop spellers - default is 'yes' (but dependent on
# --enable-spellers)
AC_ARG_ENABLE([hfst-desktop-spellers],
              [AS_HELP_STRING([--enable-hfst-desktop-spellers],
                              [build hfst desktop spellers (dependent on --enable-spellers) @<:@default=yes@:>@])],
              [enable_desktop_hfstspellers=$enableval],
              [enable_desktop_hfstspellers=yes])
AS_IF([test "x$enable_spellers" = xno -o "x$gt_prog_hfst" = xno], [enable_desktop_hfstspellers=no],
      [AS_IF([test "x$ZIP" = "xfalse"],
             [enable_desktop_hfstspellers=no
              AC_MSG_ERROR([zip missing - required for desktop zhfst spellers])])])
AM_CONDITIONAL([WANT_HFST_DESKTOP_SPELLER], [test "x$enable_desktop_hfstspellers" != xno])

# Enable minimised fst-spellers by default:
AC_ARG_ENABLE([minimised-spellers],
              [AS_HELP_STRING([--enable-minimised-spellers],
                              [minimise hfst spellers @<:@default=yes@:>@])],
              [enable_minimised_spellers=$enableval],
              [enable_minimised_spellers=yes])
AS_IF([test "x$enable_minimised_spellers" != "xyes"],
      [AC_SUBST([HFST_MINIMIZE_SPELLER], ["$ac_cv_path_HFST_REMOVE_EPSILONS \$(HFST_FLAGS)  "])],
      [AC_SUBST([HFST_MINIMIZE_SPELLER], ["$ac_cv_path_HFST_REMOVE_EPSILONS \$(HFST_FLAGS) \
                                         | $ac_cv_path_HFST_DETERMINIZE --encode-weights \$(HFST_FLAGS) \
                                         | $ac_cv_path_HFST_MINIMIZE    --encode-weights \$(HFST_FLAGS) "])])

# Enable Foma-based spellers, requires gzip - default is no
AC_ARG_ENABLE([fomaspeller],
              [AS_HELP_STRING([--enable-fomaspeller],
                              [build foma speller (dependent on --enable-spellers) @<:@default=no@:>@])],
              [enable_fomaspeller=$enableval],
              [enable_fomaspeller=no])
AS_IF([test "x$enable_fomaspeller" = "xyes" -a "x$gt_prog_hfst" != xno], 
      [AS_IF([test "x$GZIP" = "xfalse"],
             [enable_fomaspeller=no
              AC_MSG_ERROR([gzip missing - required for foma spellers])])])
AM_CONDITIONAL([CAN_FOMA_SPELLER], [test "x$enable_fomaspeller" != xno])

# Enable hfst mobile spellers - default is 'no' (dependent on --enable-spellers)
AC_ARG_ENABLE([hfst-mobile-speller],
              [AS_HELP_STRING([--enable-hfst-mobile-speller],
                              [build hfst mobile spellers (dependent on --enable-spellers) @<:@default=no@:>@])],
              [enable_mobile_hfstspeller=$enableval],
              [enable_mobile_hfstspeller=$enable_all_tools])
AS_IF([test "x$enable_spellers" = xno -o "x$gt_prog_hfst" = xno], [enable_mobile_hfstspeller=no],
      [AS_IF([test "x$XZ" = "xfalse"],
             [enable_mobile_hfstspeller=no
              AC_MSG_ERROR([xz is missing - required for mobile zhfst spellers])])])
AM_CONDITIONAL([WANT_HFST_MOBILE_SPELLER], [test "x$enable_mobile_hfstspeller" != xno])

# Enable Vfst-based spellers - default is no
AC_ARG_ENABLE([vfstspeller],
              [AS_HELP_STRING([--enable-vfstspeller],
                              [build vfst speller (dependent on --enable-hfst-mobile-speller) @<:@default=no@:>@])],
              [enable_vfstspeller=$enableval],
              [enable_vfstspeller=no])
AS_IF([test "x$enable_vfstspeller" = "xyes" -a "x$enable_mobile_hfstspeller" = xno],
              [enable_vfstspeller=no])
AM_CONDITIONAL([WANT_VFST_SPELLER], [test "x$enable_vfstspeller" != xno])

## Disable Hunspell production by default:
#AC_ARG_ENABLE([hunspell],
#              [AS_HELP_STRING([--enable-hunspell],
#                              [enable hunspell building (dependent on --enable-spellers) @<:@default=no@:>@])],
#              [enable_hunspell=$enableval],
#              [enable_hunspell=no])
#AS_IF([test "x$enable_spellers" = xno], [enable_hunspell=no])
#AM_CONDITIONAL([WANT_HUNSPELL], [test "x$enable_hunspell" != xno])

# Enable pattern hyphenator - default is 'no'; requires fst hyphenator
AC_ARG_ENABLE([pattern-hyphenators],
              [AS_HELP_STRING([--enable-pattern-hyphenators],
                              [build pattern-based hyphenators (requires fst hyphenator) @<:@default=no@:>@])],
              [enable_pattern_hyphenators=$enableval],
              [enable_pattern_hyphenators=no])
AS_IF([test "x$enable_pattern_hyphenators" = "xyes" -a "x$PATGEN" = "xfalse"], 
      [enable_pattern_hyphenators=no
       AC_MSG_ERROR([patgen required for building pattern hyphenators])])

# Enable fst hyphenator - default is 'no'
AC_ARG_ENABLE([fst-hyphenator],
              [AS_HELP_STRING([--enable-fst-hyphenator],
                              [build fst-based hyphenator @<:@default=no@:>@])],
              [enable_fst_hyphenator=$enableval],
              [enable_fst_hyphenator=$enable_all_tools])
# Automatically enable the fst hyphenator if pattern hyphenator is enabled:
AS_IF([test "x$enable_pattern_hyphenators" = "xyes"], 
      [enable_fst_hyphenator=yes])
AM_CONDITIONAL([WANT_FST_HYPHENATOR], [test "x$enable_fst_hyphenator" != xno])

# Set up conditional for pattern hyphenators:
AM_CONDITIONAL([WANT_PATTERN_HYPHENATORS], [test "x$enable_pattern_hyphenators" != xno])

# Enable dictionary transducers - default is 'no'
AC_ARG_ENABLE([dicts],
              [AS_HELP_STRING([--enable-dicts],
                              [enable dictionary transducers @<:@default=no@:>@])],
              [enable_dicts=$enableval],
              [enable_dicts=$enable_all_tools])
AM_CONDITIONAL([WANT_DICTIONARIES], [test "x$enable_dicts" != xno])

# Enable Oahpa transducers - default is 'no'
AC_ARG_ENABLE([oahpa],
              [AS_HELP_STRING([--enable-oahpa],
                              [enable oahpa transducers @<:@default=no@:>@])],
              [enable_oahpa=$enableval],
              [enable_oahpa=$enable_all_tools])
AM_CONDITIONAL([WANT_OAHPA], [test "x$enable_oahpa" != xno])

# Enable L2 fst's for Oahpa:
AC_ARG_ENABLE([L2],
              [AS_HELP_STRING([--enable-L2],
                              [enable L2 analyser for Oahpa @<:@default=no@:>@])],
              [enable_L2=$enableval],
              [enable_L2=no])
AS_IF([test x$enable_oahpa = xno], [enable_L2=no],
    [AS_IF([test x$enable_L2 != xno -a \
      "$(find ${srcdir}/src -name "*-L2.*" | head -n 1)" = "" ],
      [AC_MSG_ERROR([You asked for the L2 analyser, but no L2 files were found])])])
AM_CONDITIONAL([WANT_L2], [test "x$enable_L2" != xno])

# Enable downcasing error fst's for Oahpa:
AC_ARG_ENABLE([downcaseerror],
              [AS_HELP_STRING([--enable-downcaseerror],
                              [enable downcaseerror analyser for Oahpa @<:@default=no@:>@])],
              [enable_downcaseerror=$enableval],
              [enable_downcaseerror=no])
AS_IF([test x$enable_oahpa = xno], [enable_downcaseerror=no])
AM_CONDITIONAL([WANT_DOWNCASEERROR], [test "x$enable_downcaseerror" != xno])

# Enable IPA conversion - default is 'no'
AC_ARG_ENABLE([phonetic],
              [AS_HELP_STRING([--enable-phonetic],
                              [enable phonetic transducers @<:@default=no@:>@])],
              [enable_phonetic=$enableval],
              [enable_phonetic=no])
AM_CONDITIONAL([WANT_PHONETIC], [test "x$enable_phonetic" != xno])

# Enable Apertium transducers - default is 'no'
AC_ARG_ENABLE([apertium],
              [AS_HELP_STRING([--enable-apertium],
                              [enable apertium transducers @<:@default=no@:>@])],
              [enable_apertium=$enableval],
              [enable_apertium=$enable_all_tools])
AS_IF([test "x$enable_apertium" = "xyes" -a "x$new_enough_python_available" = "xno"], 
      [enable_apertium=no
       AC_MSG_ERROR([Python3 missing or too old, Python 3.5 or newer required])])
AS_IF([test "x$enable_apertium" = "xyes" -a "x$CG_RELABEL" = "xno"], 
      [enable_apertium=no
       AC_MSG_ERROR([Apertium enabled but cg-relabel not found. Please install Vislcg3.])])
AM_CONDITIONAL([WANT_APERTIUM], [test "x$enable_apertium" != xno])

# Enable CG-based MT - default is 'no'
AC_ARG_ENABLE([cgmt],
              [AS_HELP_STRING([--enable-cgmt],
                              [enable cg-based machine translation @<:@default=no@:>@])],
              [enable_cgmt=$enableval],
              [enable_cgmt=no])
AS_IF([test "x$enable_cgmt" = "xyes" -a "x$GTPRIV" = "x"], 
      [AC_MSG_ERROR([\$\$GTPRIV not set! CG-based MT requires access to closed-source tools in GTPRIV])])
AS_IF([test x$enable_tokenisers = xno -a x$enable_cgmt = xyes],
    [AC_MSG_ERROR([You need to enable tokenisers to build CG-based MT])])
AM_CONDITIONAL([CAN_CGMT], [test "x$enable_cgmt" != xno])

# Enable building of abbr.txt:
AC_ARG_ENABLE([abbr],
              [AS_HELP_STRING([--enable-abbr],
                              [enable generation of abbr.txt @<:@default=no@:>@])],
              [enable_abbr=$enableval],
              [enable_abbr=no])
AS_IF([test x$enable_abbr != xno -a \
    "$(find ${srcdir}/src/morphology/stems/ -name "abbreviations.lexc" | head -n 1)" = "" ],
    [AC_MSG_ERROR([You asked for abbr.txt generation, but have no file \
src/morphology/stems/abbreviations.lexc])])
AS_IF([test x$enable_abbr = xyes -a x$enable_generators = xno],
    [AC_MSG_ERROR([You need to enable generators to build the abbr file])])
AM_CONDITIONAL([WANT_ABBR], [test "x$enable_abbr" != xno])

# Enable building tokenisers - default is 'no'
AC_ARG_ENABLE([tokenisers],
              [AS_HELP_STRING([--enable-tokenisers],
                              [enable tokenisers @<:@default=no@:>@])],
              [enable_tokenisers=$enableval],
              [enable_tokenisers=$enable_all_tools])
AS_IF([test x$enable_tokenisers = xyes -a x$enable_analysers = xno],
    [AC_MSG_ERROR([You need to enable analysers to build tokenisers])])
AM_CONDITIONAL([WANT_TOKENISERS], [test "x$enable_tokenisers" != xno])

# Enable analyser tool - default is 'no' (via $enable_all_tools)
AC_ARG_ENABLE([analyser-tool],
              [AS_HELP_STRING([--enable-analyser-tool],
                              [enable analyser tool @<:@default=no@:>@])],
              [enable_analyser_tool=$enableval],
              [enable_analyser_tool=$enable_all_tools])
AS_IF([test "x$enable_analyser_tool" = "xyes" -a "x$gt_prog_vislcg3" = "xno"], 
      [enable_analyser_tool=no
       AC_MSG_ERROR([vislcg3 missing or too old - required for the analyser tool])])
AS_IF([test x$enable_tokenisers = xno -a x$enable_analyser_tool = xyes],
    [AC_MSG_ERROR([You need to enable tokenisers to build the analyser tool])])
AM_CONDITIONAL([WANT_ANL_TOOL], [test "x$enable_analyser_tool" != xno])

# Enable building morphers - default is 'no'
AC_ARG_ENABLE([morpher],
              [AS_HELP_STRING([--enable-morpher],
                              [enable morphological segmenter @<:@default=no@:>@])],
              [enable_morpher=$enableval],
              [enable_morpher=no])
AM_CONDITIONAL([WANT_MORPHER], [test "x$enable_morpher" != xno])

# Enable dialect-specific analysers and tools, such as spellers:
AC_ARG_ENABLE([dialects],
              [AS_HELP_STRING([--enable-dialects],
                              [build dialect specific fst's and spellers @<:@default=no@:>@])],
              [enable_dialects=$enableval],
              [enable_dialects=no])
AS_IF([test "x$enable_dialects" = "xyes" -a "x$DIALECTS" = "x"], 
      [enable_dialects=no
       AC_MSG_ERROR([You have not defined any dialects. Please see the documentation.])])
AM_CONDITIONAL([WANT_DIALECTS], [test "x$enable_dialects" != xno])

]) # ' # gt_ENABLE_TARGETS

################################################################################
# Define function to print the configure footer
################################################################################
AC_DEFUN([gt_PRINT_FOOTER],
[
cat<<EOF

  -- specialised fst's (off by default): --
  * dictionary fst's enabled: $enable_dicts
  * Oahpa transducers enabled: $enable_oahpa
    * L2 analyser: $enable_L2
    * downcase error analyser: $enable_downcaseerror
  * generate abbr.txt: $enable_abbr
  * build glossing fst's: $enable_glossers
  * build dialect specific fst's: $enable_dialects

  -- Tools (off by default): --
  * phonetic/IPA conversion enabled: $enable_phonetic
  * CG-based MT enabled: $enable_cgmt
  * Apertium MT fst's enabled: $enable_apertium
  * build tokenisers: $enable_tokenisers
  * build morphololgical segmenter: $enable_morpher
  * build analyser tool: $enable_analyser_tool

  -- Proofing tools (off by default): --
  * hyphenators:
    * fst hyphenator enabled: $enable_fst_hyphenator
    * pattern hyphenator enabled (requires fst hyph): $enable_fst_hyphenator
  * spellers (zhfst files) enabled: $enable_spellers
    * desktop spellers:
      * installable packages enabled: $enable_desktop_hfstspellers
      * foma speller enabled: $enable_fomaspeller
    * mobile spellers (off by default, even with spellers enabled):
      * hfst speller enabled: $enable_mobile_hfstspeller
      * vfst speller enabled: $enable_vfstspeller
  * grammar checker enabled: $enable_grammarchecker

-- Building $PACKAGE_STRING (more specialised build targets listed above):

  -- Fst build tools: Xerox, Hfst or Foma - at least one must be installed
  -- Xerox is default on, the others off unless they are the only one present --
  * build Xerox fst's: $gt_prog_xfst
  * build HFST fst's: $gt_prog_hfst
  * build Foma fst's: $gt_prog_foma

  -- basic packages (on by default): --
  * analysers enabled: $enable_analysers
  * generators enabled: $enable_generators
  * transcriptors enabled: $enable_transcriptors
  * syntactic tools enabled: $enable_syntax
  * yaml tests enabled: $enable_yamltests
  * generated documentation enabled: $giellalt_forrest_validation

For more ./configure options, run ./configure --help

To build, test and install:
    make
    make check
    make install
EOF
AS_IF([test x$gt_prog_xslt = xno -a \
      "$(find ${srcdir}/src/morphology/stems -name "*.xml" | head -n 1)" != "" ],
      [AC_MSG_WARN([You have XML source files, but XML transformation to LexC is
disabled. Please check the output of configure to locate any problems. The LexC
files will still compile though.
])])

AS_IF([test "x$giellalt_forrest_validation" = "xno" -a "x$with_forrest" = "xyes"],
      [AC_MSG_WARN([Could not find gawk, java or forrest. In-source documentation will not be extracted and validated. Please install the required tools. Alternatively, silence this message by disabling forrest validation: --without-forrest])])

AS_IF([test x$can_local_sync = xno -a x$can_wget_giella_libs = xno],
      [AC_MSG_WARN([Could not find GIELLA_LIBS, rsync or wget - speller installers will not be built, only zhfst files.])])

AS_IF([test x$can_wget_giella_libs = xyes],
      [AC_MSG_NOTICE([Could not find GIELLA_LIBS, but found wget - speller installers will be built, but requires a live Internet connection.])])

# Notify of fallback to Hfst
AS_IF([test "x$fallback_to_hfst" != x ],
      [AC_MSG_NOTICE([$fallback_to_hfst])])

# Notify of fallback to Foma
AS_IF([test "x$fallback_to_foma" != x ],
      [AC_MSG_NOTICE([$fallback_to_foma])])

dnl stick important warnings to bottom
dnl YAML test warning:
AS_IF([test "x$enable_yamltests" = "xno"],
      [AC_MSG_WARN([YAML testing could not be automatically enabled. To enable it, on MacOSX please do:

sudo port install python35 py35-pip
sudo pip-3.5 install PyYAML

On other systems, install python 3.5+ and the corresponding py-yaml using suitable tools for those systems.])])

]) # gt_PRINT_FOOTER
# vim: set ft=config: 
