/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.Method;
import net.sf.jiapi.file.attribute.AnnotationBase;
import net.sf.jiapi.file.attribute.AnnotationsAttribute;
import net.sf.jiapi.file.attribute.CodeAttribute;
import net.sf.jiapi.file.attribute.ExceptionsAttribute;
import net.sf.jiapi.file.attribute.LineNumberTableAttribute;
import net.sf.jiapi.file.attribute.LocalVariableTableAttribute;
import net.sf.jiapi.file.attribute.ParameterAnnotationsAttribute;
import net.sf.jiapi.file.attribute.StackMapTableAttribute;
import net.sf.jiapi.reflect.BranchInstruction;
import net.sf.jiapi.reflect.ETEntry;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.InstructionFactory;
import net.sf.jiapi.reflect.InstructionList;
import net.sf.jiapi.reflect.JiapiAnnotation;
import net.sf.jiapi.reflect.JiapiClass;
import net.sf.jiapi.reflect.LNTEntry;
import net.sf.jiapi.reflect.LVTEntry;
import net.sf.jiapi.reflect.Loader;
import net.sf.jiapi.reflect.SMTEntry;
import net.sf.jiapi.reflect.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiapiMethod {
    private static Logger log = LoggerFactory.getLogger(JiapiMethod.class);
    private final Method method;
    private final Signature signature;
    private JiapiClass declaringClass;
    private InstructionList instructions;
    private final List<LNTEntry> lineNumberTable = new LinkedList<LNTEntry>();
    private final List<ETEntry> exceptionTable = new LinkedList<ETEntry>();
    private final List<SMTEntry> stackMapTable = new LinkedList<SMTEntry>();
    private final List<LVTEntry> localVariableTable = new LinkedList<LVTEntry>();

    public JiapiMethod(Method m) {
        this.method = m;
        this.signature = new Signature(m.getDescriptor());
        CodeAttribute ca = this.method.getCodeAttribute();
        if (ca != null) {
            this.buildInstructionList(ca.getByteCode());
            this.buildExceptionTable(ca.getExceptionTable());
            this.buildLineNumberTable(ca.getLineNumberTable());
            this.buildStackMapTable(ca.getStackMapTable());
            this.buildLocalVariableTable(ca.getLocalVariableTable());
        }
    }

    public String getName() {
        return this.method.getName();
    }

    public int getModifiers() {
        return this.method.getAccessFlags();
    }

    public String getReturnType() {
        return this.signature.getReturnType();
    }

    public Signature getSignature() {
        return this.signature;
    }

    public InstructionFactory getInstructionFactory() {
        return new InstructionFactory(this.method.getConstantPool());
    }

    public InstructionList getInstructionList() {
        return this.instructions;
    }

    private void buildInstructionList(byte[] byteCode) {
        this.instructions = new InstructionList(byteCode, this.method.getConstantPool());
        this.instructions.setDeclaringMethod(this);
    }

    private void buildExceptionTable(List<CodeAttribute.ExceptionTableEntry> eTable) {
        if (eTable != null) {
            for (CodeAttribute.ExceptionTableEntry entry : eTable) {
                Instruction start = this.instructions.instructionAtOffset(entry.getStartPc());
                Instruction end = this.instructions.instructionAtOffset(entry.getEndPc());
                Instruction handler = this.instructions.instructionAtOffset(entry.getHandlerPc());
                this.exceptionTable.add(new ETEntry(entry, start, end, handler));
            }
        }
    }

    private void buildLineNumberTable(LineNumberTableAttribute lnta) {
        if (lnta != null) {
            for (LineNumberTableAttribute.Entry entry : lnta.getEntries()) {
                Instruction ins = this.instructions.instructionAtOffset(entry.getStartPc());
                this.lineNumberTable.add(new LNTEntry(entry, ins));
            }
        }
    }

    private void buildLocalVariableTable(LocalVariableTableAttribute lvtAttr) {
        if (lvtAttr != null) {
            for (LocalVariableTableAttribute.LocalVariable lv : lvtAttr.getEntries()) {
                this.localVariableTable.add(new LVTEntry(lv, this.instructions));
            }
        }
    }

    private void buildStackMapTable(StackMapTableAttribute smt) {
        if (smt != null) {
            for (StackMapTableAttribute.StackMapFrame smf : smt.getEntries()) {
                Instruction ins = this.instructions.instructionAtOffset(smf.getBytecodeOffset());
                this.stackMapTable.add(new SMTEntry(smf, ins));
            }
        }
    }

    public JiapiClass getDeclaringClass() {
        return this.declaringClass;
    }

    void setDeclaringClass(JiapiClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public JiapiClass[] getParameterTypes() throws ClassNotFoundException {
        String[] paramNames = this.getParameterTypeNames();
        JiapiClass[] types = new JiapiClass[paramNames.length];
        Loader loader = this.getDeclaringClass().getLoader();
        int i = 0;
        try {
            for (i = 0; i < paramNames.length; ++i) {
                types[i] = loader.loadClass(paramNames[i]);
            }
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(paramNames[i]);
        }
        return types;
    }

    public String[] getParameterTypeNames() {
        return this.signature.getParameters();
    }

    public JiapiClass[] getExceptionTypes() throws ClassNotFoundException {
        String[] exceptionNames = this.getExceptionNames();
        JiapiClass[] types = new JiapiClass[exceptionNames.length];
        Loader loader = this.getDeclaringClass().getLoader();
        int i = 0;
        try {
            for (i = 0; i < exceptionNames.length; ++i) {
                types[i] = loader.loadClass(exceptionNames[i]);
            }
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(exceptionNames[i]);
        }
        return types;
    }

    public String[] getExceptionNames() {
        ExceptionsAttribute a = this.method.getExceptionsAttribute();
        if (a == null) {
            return new String[0];
        }
        return a.getExceptionNames();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String ms = Modifier.toString(this.getModifiers());
        sb.append(ms);
        if (ms.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getReturnType());
        sb.append(' ');
        sb.append(this.getName());
        sb.append('(');
        String[] params = this.getParameterTypeNames();
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i]);
            if (i >= params.length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        String[] eNames = this.getExceptionNames();
        if (eNames.length > 0) {
            sb.append(" throws ");
            for (int i = 0; i < eNames.length; ++i) {
                sb.append(eNames[i]);
                if (i >= eNames.length - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public Method getMethod() {
        return this.method;
    }

    void update() {
        if (this.instructions != null) {
            this.instructions.updateOffsets();
            this.updateBranchOffsets();
            CodeAttribute ca = this.method.getCodeAttribute();
            ca.setByteCode(this.instructions.getBytes());
            this.updateMaxLocals(ca, this.instructions);
            this.updateMaxStack(ca, this.instructions);
        }
        this.updateLineNumberTableOffsets();
        this.updateExceptionTableOffsets();
        this.updateLocalVariableTable();
        this.updateStackMapTable();
    }

    private void updateLocalVariableTable() {
        for (LVTEntry lv : this.localVariableTable) {
            lv.update();
        }
    }

    private short updateMaxLocals(CodeAttribute ca, InstructionList il) {
        short maxLocals = (short)this.getParameterTypeNames().length;
        LocalVariableTableAttribute lvta = (LocalVariableTableAttribute)this.method.getAttribute("LocalVariableTable");
        if (lvta != null) {
            maxLocals = (short)(maxLocals + lvta.getEntries().size());
        }
        block9: for (int i = 0; i < il.size(); ++i) {
            Instruction ins = il.get(i);
            switch (ins.getOpcode()) {
                case 26: 
                case 34: 
                case 42: 
                case 59: 
                case 67: 
                case 75: {
                    if (maxLocals >= 1) continue block9;
                    maxLocals = 1;
                    continue block9;
                }
                case 27: 
                case 30: 
                case 35: 
                case 38: 
                case 43: 
                case 60: 
                case 63: 
                case 68: 
                case 71: 
                case 76: {
                    if (maxLocals >= 2) continue block9;
                    maxLocals = 2;
                    continue block9;
                }
                case 28: 
                case 31: 
                case 36: 
                case 39: 
                case 44: 
                case 61: 
                case 64: 
                case 69: 
                case 72: 
                case 77: {
                    if (maxLocals >= 3) continue block9;
                    maxLocals = 3;
                    continue block9;
                }
                case 29: 
                case 32: 
                case 37: 
                case 40: 
                case 45: 
                case 62: 
                case 65: 
                case 70: 
                case 73: 
                case 78: {
                    if (maxLocals >= 4) continue block9;
                    maxLocals = 4;
                    continue block9;
                }
                case 33: 
                case 41: 
                case 66: 
                case 74: {
                    if (maxLocals >= 5) continue block9;
                    maxLocals = 5;
                    continue block9;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    byte[] bytes_l = ins.getBytes();
                    byte mloc_l = bytes_l[1];
                    if (maxLocals >= mloc_l + 1) continue block9;
                    maxLocals = (short)(mloc_l + 1);
                    continue block9;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    byte[] bytes = ins.getBytes();
                    short mloc = bytes[1];
                    if (maxLocals >= mloc) continue block9;
                    maxLocals = mloc;
                }
            }
        }
        maxLocals = (short)(maxLocals + 1);
        ca.setMaxLocals(maxLocals);
        return maxLocals;
    }

    private short updateMaxStack(CodeAttribute ca, InstructionList il) {
        short maxStack = 0;
        short su = 0;
        if (il != null) {
            for (int i = 0; i < il.size(); ++i) {
                Instruction ins = il.get(i);
                if ((su = (short)(su + ins.stackUsage())) > maxStack) {
                    maxStack = su;
                }
                if (ins.getOpcode() != -78 && ins.getOpcode() != -76) continue;
                maxStack = (short)(maxStack + 1);
            }
            ca.setMaxStack(maxStack);
        }
        return maxStack;
    }

    private void updateBranchOffsets() {
        for (int i = 0; i < this.instructions.size(); ++i) {
            Instruction ins = this.instructions.get(i);
            if (!(ins instanceof BranchInstruction)) continue;
            BranchInstruction bIns = (BranchInstruction)ins;
            if (this.instructions.indexOf(bIns.getTarget()) != -1) {
                short branchOffset = bIns.getOffset();
                short targetOffset = bIns.getTarget().getOffset();
                bIns.setTargetOffset(targetOffset - branchOffset);
                continue;
            }
            log.warn("Target instruction for branch was not found. This is most likely because branch-instruction was copied from some other instruction-list, and target was not copied. Branch offset is left as is.");
        }
    }

    private void updateStackMapTable() {
        for (SMTEntry smf : this.stackMapTable) {
            smf.update(this.instructions);
        }
    }

    private void updateLineNumberTableOffsets() {
        if (this.lineNumberTable != null) {
            for (LNTEntry entry : this.lineNumberTable) {
                entry.update();
            }
        }
    }

    private void updateExceptionTableOffsets() {
        if (this.exceptionTable != null) {
            for (ETEntry entry : this.exceptionTable) {
                entry.update();
            }
        }
    }

    public int getMaxLocals() {
        CodeAttribute ca = (CodeAttribute)this.method.getAttribute("Code");
        if (ca == null) {
            throw new NullPointerException("No Code attribute found");
        }
        ca.setByteCode(this.getInstructionList().getBytes());
        return this.updateMaxLocals(ca, this.getInstructionList());
    }

    public int getMaxStack() {
        CodeAttribute ca = this.method.getCodeAttribute();
        return this.updateMaxStack(ca, this.getInstructionList());
    }

    public JiapiAnnotation[] getDeclaredAnnotations() {
        AnnotationsAttribute rva = (AnnotationsAttribute)this.method.getAttribute("RuntimeVisibleAnnotations");
        LinkedList annotations = new LinkedList();
        if (rva != null) {
            annotations.addAll(rva.getAnnotations());
        }
        if ((rva = (AnnotationsAttribute)this.method.getAttribute("RuntimeInvisibleAnnotations")) != null) {
            annotations.addAll(rva.getAnnotations());
        }
        if ((rva = (AnnotationsAttribute)this.method.getAttribute("AnnotationDefault")) != null) {
            annotations.addAll(rva.getAnnotations());
        }
        JiapiAnnotation[] aa = new JiapiAnnotation[annotations.size()];
        for (int i = 0; i < aa.length; ++i) {
            AnnotationBase.Annotation a = (AnnotationBase.Annotation)annotations.get(i);
            aa[i] = new JiapiAnnotation(a);
        }
        return aa;
    }

    public List[] getVisibleParameterAnnotations() {
        return this.getParameterAnnotations("RuntimeVisibleParameterAnnotations");
    }

    public List[] getInvisibleParameterAnnotations() {
        return this.getParameterAnnotations("RuntimeInvisibleParameterAnnotations");
    }

    private List[] getParameterAnnotations(String attributeName) {
        List[] npa = null;
        ParameterAnnotationsAttribute rva = (ParameterAnnotationsAttribute)this.method.getAttribute(attributeName);
        if (rva != null) {
            List[] pa = rva.getParameterAnnotations();
            npa = new List[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                List l = pa[i];
                npa[i] = new LinkedList();
                JiapiAnnotation[] aa = new JiapiAnnotation[l.size()];
                for (int j = 0; j < aa.length; ++j) {
                    AnnotationBase.Annotation a = (AnnotationBase.Annotation)l.get(j);
                    aa[j] = new JiapiAnnotation(a);
                }
                npa[i].add(aa);
            }
        }
        return npa;
    }

    public boolean isSynthetic() {
        return this.method.getAttribute("Synthetic") != null;
    }
}

