/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jiapi.reflect.JiapiClass;
import net.sf.jiapi.reflect.Loader;
import net.sf.jiapi.reflect.util.InstrumentationDescriptor;
import net.sf.jiapi.reflect.util.Instrumentor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationContext {
    private static Logger log = LoggerFactory.getLogger(InstrumentationContext.class);
    private ArrayList<InstrumentationDescriptor> descriptors = new ArrayList();
    private Loader loader = new Loader();

    public void addInstrumentationDescriptor(InstrumentationDescriptor id) {
        this.descriptors.add(id);
    }

    public Loader getLoader() {
        return this.loader;
    }

    public List<InstrumentationDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public void instrument(JiapiClass clazz) {
        ArrayList<Instrumentor> list = new ArrayList<Instrumentor>();
        for (InstrumentationDescriptor id : this.getDescriptors()) {
            if (!id.match(clazz.getName())) continue;
            list.addAll(id.getInstrumentors());
        }
        if (!list.isEmpty()) {
            Iterator<InstrumentationDescriptor> i = list.iterator();
            long l1 = System.currentTimeMillis();
            while (i.hasNext()) {
                Instrumentor instrumentor = (Instrumentor)((Object)i.next());
                instrumentor.instrument(clazz);
            }
            long l2 = System.currentTimeMillis();
            log.debug("It took " + (l2 - l1) + " ms to instrument " + clazz);
        } else {
            log.debug("No inclusion rules match " + clazz.getName());
        }
    }
}

