/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserDetailPane;
import org.gjt.jclasslib.browser.BrowserHistory;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.browser.BrowserTreePane;
import org.gjt.jclasslib.browser.config.window.BrowserPath;
import org.gjt.jclasslib.browser.config.window.CategoryHolder;
import org.gjt.jclasslib.browser.config.window.IndexHolder;
import org.gjt.jclasslib.browser.config.window.PathComponent;
import org.gjt.jclasslib.browser.config.window.ReferenceHolder;
import org.gjt.jclasslib.structures.ClassMember;
import org.gjt.jclasslib.structures.FieldInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.MethodInfo;

public class BrowserComponent
extends JComponent
implements TreeSelectionListener {
    private BrowserHistory history;
    private BrowserServices services;
    private JSplitPane splitPane;
    private BrowserTreePane treePane;
    private BrowserDetailPane detailPane;

    public BrowserComponent(BrowserServices browserServices) {
        this.services = browserServices;
        this.setupComponent();
    }

    public BrowserTreePane getTreePane() {
        return this.treePane;
    }

    public BrowserDetailPane getDetailPane() {
        return this.detailPane;
    }

    public BrowserHistory getHistory() {
        return this.history;
    }

    public BrowserPath getBrowserPath() {
        TreePath treePath = this.treePane.getTree().getSelectionPath();
        if (treePath == null || treePath.getPathCount() < 3) {
            return null;
        }
        BrowserTreeNode browserTreeNode = (BrowserTreeNode)treePath.getPathComponent(2);
        String string = browserTreeNode.getType();
        if (string.equals("noContent")) {
            return null;
        }
        BrowserPath browserPath = new BrowserPath();
        browserPath.addPathComponent(new CategoryHolder(string));
        int n = browserTreeNode.getIndex();
        if (string.equals("constantPool")) {
            --n;
        }
        if (string.equals("method")) {
            MethodInfo methodInfo = this.services.getClassFile().getMethods()[n];
            this.addClassMemberPathComponent(methodInfo, browserPath, treePath);
        } else if (string.equals("field")) {
            FieldInfo fieldInfo = this.services.getClassFile().getFields()[n];
            this.addClassMemberPathComponent(fieldInfo, browserPath, treePath);
        } else {
            browserPath.addPathComponent(new IndexHolder(n));
        }
        return browserPath;
    }

    public void setBrowserPath(BrowserPath browserPath) {
        Object object;
        Object object2;
        if (browserPath == null) {
            return;
        }
        LinkedList linkedList = browserPath.getPathComponents();
        Iterator iterator = linkedList.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        CategoryHolder categoryHolder = (CategoryHolder)iterator.next();
        String string = categoryHolder.getCategory();
        TreePath treePath = this.treePane.getPathForCategory(string);
        if (treePath == null) {
            return;
        }
        while (iterator.hasNext()) {
            int n;
            block10: {
                object2 = (PathComponent)iterator.next();
                if (object2 instanceof ReferenceHolder) {
                    object = (ReferenceHolder)object2;
                    try {
                        if (string.equals("method")) {
                            n = this.services.getClassFile().getMethodIndex(((ReferenceHolder)object).getName(), ((ReferenceHolder)object).getType());
                        } else {
                            if (!string.equals("field")) break;
                            n = this.services.getClassFile().getFieldIndex(((ReferenceHolder)object).getName(), ((ReferenceHolder)object).getType());
                        }
                        break block10;
                    }
                    catch (InvalidByteCodeException invalidByteCodeException) {
                        break;
                    }
                }
                if (!(object2 instanceof IndexHolder)) break;
                n = ((IndexHolder)object2).getIndex();
            }
            if (n >= ((DefaultMutableTreeNode)(object = (BrowserTreeNode)treePath.getLastPathComponent())).getChildCount()) break;
            treePath = treePath.pathByAddingChild(((DefaultMutableTreeNode)object).getChildAt(n));
        }
        object2 = this.treePane.getTree();
        ((JTree)object2).expandPath(treePath);
        ((JTree)object2).setSelectionPath(treePath);
        Object[] objectArray = treePath.getPath();
        if (objectArray.length > 2) {
            object = new TreePath(new Object[]{objectArray[0], objectArray[1], objectArray[2]});
            ((JTree)object2).scrollPathToVisible((TreePath)object);
        }
    }

    public void rebuild() {
        BrowserPath browserPath = this.getBrowserPath();
        this.reset();
        if (browserPath != null) {
            this.setBrowserPath(browserPath);
        }
    }

    public void reset() {
        JTree jTree = this.treePane.getTree();
        jTree.removeTreeSelectionListener(this);
        this.treePane.rebuild();
        this.history.clear();
        jTree.addTreeSelectionListener(this);
        this.checkSelection();
    }

    public void checkSelection() {
        JTree jTree = this.treePane.getTree();
        if (this.services.getClassFile() == null) {
            ((CardLayout)this.detailPane.getLayout()).show(this.detailPane, "noContent");
        } else if (jTree.getSelectionPath() == null) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)jTree.getModel().getRoot();
            jTree.setSelectionPath(new TreePath(new Object[]{browserTreeNode, browserTreeNode.getFirstChild()}));
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.services.activate();
        TreePath treePath = treeSelectionEvent.getPath();
        this.history.updateHistory(treePath);
        this.showDetailPaneForPath(treePath);
    }

    private void addClassMemberPathComponent(ClassMember classMember, BrowserPath browserPath, TreePath treePath) {
        try {
            browserPath.addPathComponent(new ReferenceHolder(classMember.getName(), classMember.getDescriptor()));
            if (treePath.getPathCount() > 3) {
                for (int i = 3; i < treePath.getPathCount(); ++i) {
                    BrowserTreeNode browserTreeNode = (BrowserTreeNode)treePath.getPathComponent(i);
                    browserPath.addPathComponent(new IndexHolder(browserTreeNode.getIndex()));
                }
            }
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
            // empty catch block
        }
    }

    private void showDetailPaneForPath(TreePath treePath) {
        BrowserTreeNode browserTreeNode = (BrowserTreeNode)treePath.getLastPathComponent();
        String string = browserTreeNode.getType();
        this.detailPane.showPane(string, treePath);
    }

    private void setupComponent() {
        this.setLayout(new BorderLayout());
        this.detailPane = new BrowserDetailPane(this.services);
        this.splitPane = new JSplitPane(1, this.buildTreePane(), this.detailPane);
        this.add((Component)this.splitPane, "Center");
    }

    private BrowserTreePane buildTreePane() {
        this.treePane = new BrowserTreePane(this.services);
        JTree jTree = this.treePane.getTree();
        jTree.addTreeSelectionListener(this);
        this.history = new BrowserHistory(this.services);
        return this.treePane;
    }
}

