/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.builder.CodeBuilder;
import com.claritysys.jvm.classfile.Attribute;
import com.claritysys.jvm.classfile.AttributeHandler;
import com.claritysys.jvm.classfile.CfEntry;
import com.claritysys.jvm.classfile.CfField;
import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpClass;
import com.claritysys.jvm.classfile.SigConverter;
import com.claritysys.jvm.classfile.Utils;
import com.claritysys.util.Java;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public class ClassFile
extends CfEntry
implements AttributeHandler {
    private int minor;
    private int major;
    private ConstantPool constantPool;
    private int classIndex;
    private int superclassIndex;
    private int[] interfaces;
    private int fieldCount;
    private CfField fields;
    private CfField lastField;
    private int methodCount;
    private CfMethod methods;
    private CfMethod lastMethod;
    private int sourcefileCp;
    private CodeBuilder codeBuilder;

    private ClassFile() {
    }

    public ClassFile(String className, String superclassName, String sourceFile) {
        this(null, className, superclassName, sourceFile);
    }

    public ClassFile(ConstantPool cpool, String className, String superclassName, String sourceFile) {
        this.constantPool = cpool == null ? new ConstantPool() : new ConstantPool(cpool);
        cpool = this.constantPool;
        cpool.addUtf8("Code");
        cpool.addUtf8("ConstantValue");
        cpool.addUtf8("Deprecated");
        cpool.addUtf8("Exceptions");
        cpool.addUtf8("LineNumberTable");
        cpool.addUtf8("LocalVariableTable");
        cpool.addUtf8("SourceFile");
        cpool.addUtf8("Synthetic");
        this.major = 45;
        this.minor = 3;
        this.classIndex = cpool.addClass(className).getIndex();
        this.superclassIndex = cpool.addClass(superclassName).getIndex();
        this.setSourcefile(sourceFile);
        this.setAccessFlags(33);
    }

    public static ClassFile fromFile(String path) throws IOException, ClassFileFormatException {
        ClassFile cf = new ClassFile();
        DataInputStream dataIn = new DataInputStream(new BufferedInputStream(new FileInputStream(path)));
        cf.read(dataIn);
        dataIn.close();
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile fromArray(byte[] buffer) throws ClassFileFormatException {
        ClassFile cf = new ClassFile();
        DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(buffer));
        try {
            cf.read(dataIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                dataIn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cf;
    }

    public void read(DataInputStream dataIn) throws IOException, ClassFileFormatException {
        int i;
        int fileMagic = dataIn.readInt();
        if (fileMagic != -889275714) {
            throw new ClassFileFormatException("Bad magic number: " + Integer.toHexString(fileMagic));
        }
        this.minor = dataIn.readUnsignedShort();
        this.major = dataIn.readUnsignedShort();
        this.constantPool = ConstantPool.fromStream(dataIn);
        this.setAccessFlags(dataIn.readUnsignedShort());
        if (this.isInterface()) {
            this.setAbstract(true);
        }
        this.classIndex = dataIn.readUnsignedShort();
        this.superclassIndex = dataIn.readUnsignedShort();
        int icount = dataIn.readUnsignedShort();
        this.interfaces = new int[icount];
        for (i = 0; i < icount; ++i) {
            this.interfaces[i] = dataIn.readUnsignedShort();
        }
        this.fieldCount = dataIn.readUnsignedShort();
        for (i = 0; i < this.fieldCount; ++i) {
            CfField field = new CfField(this);
            field.read(dataIn);
            if (this.fields == null) {
                this.fields = this.lastField = field;
                continue;
            }
            this.lastField.setNext(field);
            this.lastField = field;
        }
        int count = dataIn.readUnsignedShort();
        for (int i2 = 0; i2 < count; ++i2) {
            CfMethod method = new CfMethod(this);
            method.read(dataIn);
            this.addMethod(method);
        }
        Attribute attributes = Attribute.readTable(dataIn, this.constantPool, this);
        this.setAttributes(attributes);
    }

    public boolean handleAttribute(DataInputStream dataIn, String name, int length) throws IOException, ClassFileFormatException {
        boolean processed = false;
        if (name.equals("SourceFile")) {
            this.setSourcefileCp(dataIn.readUnsignedShort());
            processed = true;
        } else if (name.equals("Deprecated")) {
            this.setDeprecated(true);
            processed = true;
        }
        return processed;
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeInt(-889275714);
        dout.writeShort(this.minor);
        dout.writeShort(this.major);
        this.constantPool.write(dout);
        dout.writeShort(this.getAccessFlags());
        dout.writeShort(this.classIndex);
        dout.writeShort(this.superclassIndex);
        if (this.interfaces == null) {
            dout.writeShort(0);
        } else {
            dout.writeShort(this.interfaces.length);
            for (int i = 0; i < this.interfaces.length; ++i) {
                dout.writeShort(this.interfaces[i]);
            }
        }
        dout.writeShort(this.fieldCount);
        for (CfField field = this.getFields(); field != null; field = field.getNext()) {
            field.write(dout);
        }
        dout.writeShort(this.methodCount);
        for (CfMethod method = this.getMethods(); method != null; method = method.getNext()) {
            method.write(dout);
        }
        int attributeCount = this.getAttributeCount();
        if (this.sourcefileCp > 0) {
            ++attributeCount;
        }
        if (this.isDeprecated()) {
            ++attributeCount;
        }
        dout.writeShort(attributeCount);
        if (this.sourcefileCp > 0) {
            Attribute.writeAttribute(dout, this.constantPool, "SourceFile", 2, this.sourcefileCp);
        }
        if (this.isDeprecated()) {
            Attribute.writeAttribute(dout, this.constantPool, "Deprecated", 0, 0);
        }
        Attribute.writeTable(dout, this.getAttributes());
    }

    public void write(String path) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
        this.write(dataOutput);
        dataOutput.close();
    }

    public void write(OutputStream stream) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(stream);
        this.write(dataOut);
        dataOut.close();
    }

    public byte[] writeToArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        DataOutputStream dataOut = new DataOutputStream(baos);
        try {
            this.write(dataOut);
            dataOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    private void addMethod(CfMethod method) {
        if (this.methods == null) {
            this.methods = this.lastMethod = method;
        } else {
            this.lastMethod.setNext(method);
            this.lastMethod = method;
        }
        ++this.methodCount;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public CpClass getClassCp() {
        return (CpClass)this.constantPool.getPoolEntry(this.classIndex);
    }

    public String getClassName() {
        return ((CpClass)this.constantPool.getPoolEntry(this.classIndex)).getStringName();
    }

    public void setClassName(String className) {
        this.classIndex = this.constantPool.addClass(className).getIndex();
    }

    public int getSuperclassIndex() {
        return this.superclassIndex;
    }

    public CpClass getSuperclassCp() {
        return (CpClass)this.constantPool.getPoolEntry(this.superclassIndex);
    }

    public String getSuperclassName() {
        return ((CpClass)this.constantPool.getPoolEntry(this.superclassIndex)).getStringName();
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public String[] getInterfaceNames() {
        String[] names = new String[this.interfaces.length];
        for (int i = 0; i < this.interfaces.length; ++i) {
            int anInterface = this.interfaces[i];
            names[i] = ((CpClass)this.constantPool.getPoolEntry(anInterface)).getStringName();
        }
        return names;
    }

    public void addInterface(String className) {
        int[] newList;
        int interfaceCp = this.constantPool.addClass(className).getIndex();
        if (this.interfaces == null) {
            newList = new int[1];
        } else {
            newList = new int[this.interfaces.length + 1];
            System.arraycopy(this.interfaces, 0, newList, 0, this.interfaces.length);
        }
        newList[newList.length - 1] = interfaceCp;
        this.interfaces = newList;
    }

    public void addInterface(Class clas) {
        this.addInterface("@" + clas.getName());
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public CfField getFields() {
        return this.fields;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public CfMethod getMethods() {
        return this.methods;
    }

    public String getSourcefile() {
        String sourcefile = null;
        if (this.sourcefileCp > 0) {
            sourcefile = this.constantPool.getUtf8AsString(this.sourcefileCp);
        }
        return sourcefile;
    }

    public void setSourcefile(String sourcefile) {
        this.sourcefileCp = this.constantPool.addUtf8(sourcefile).getIndex();
    }

    public int getSourcefileCp() {
        return this.sourcefileCp;
    }

    public void setSourcefileCp(int sourcefileCp) {
        this.sourcefileCp = sourcefileCp;
    }

    public String getPackage() {
        String className = this.getClassName();
        int last = className.lastIndexOf("/");
        if (last == -1) {
            return null;
        }
        return className.substring(0, last);
    }

    public CfMethod addMethod(int accessFlags, String nameAndSignature) {
        int leftParen = nameAndSignature.indexOf(40);
        boolean shortForm = nameAndSignature.startsWith("@");
        int nameStart = shortForm ? 1 : 0;
        String name = nameAndSignature.substring(nameStart, leftParen);
        String signature = nameAndSignature.substring(leftParen);
        if (shortForm) {
            signature = "@" + signature;
        }
        return this.addMethod(accessFlags, name, signature);
    }

    public CfMethod addMethod(int accessFlags, String name, String signature) {
        CfMethod method = new CfMethod(this);
        method.setAccessFlags(accessFlags);
        if (signature.charAt(0) == '@') {
            SigConverter sigConverter = this.constantPool.getSigConverter();
            signature = sigConverter.toVmMethodSig(signature.substring(1));
        }
        method.setNameIndex(this.constantPool.addUtf8(name).getIndex());
        method.setDescriptorIndex(this.constantPool.addUtf8(signature).getIndex());
        int maxLocals = Utils.getMethodStackWords(signature);
        if (!method.isStatic()) {
            ++maxLocals;
        }
        method.setMaxLocals(maxLocals);
        method.setReturnType(Utils.getMethodReturnType(signature));
        this.addMethod(method);
        return method;
    }

    public CfMethod getMethod(String name, String signature) {
        CfMethod method;
        CfMethod found = null;
        if (signature != null && signature.charAt(0) == '@') {
            signature = this.constantPool.getSigConverter().toVmMethodSig(signature.substring(1));
        }
        for (method = this.getMethods(); method != null; method = method.getNext()) {
            if (!name.equals(method.getName()) || !method.getSignature().equals(signature) && signature != null) continue;
            found = method;
            break;
        }
        if (found == null) {
            System.out.println("No method: " + name + (signature == null ? "" : signature));
            System.out.println("Methods in class " + this.getClassName());
            for (method = this.getMethods(); method != null; method = method.getNext()) {
                System.out.println(method.getName() + method.getSignature());
            }
            throw new NoSuchElementException("No method: " + name + signature);
        }
        return found;
    }

    private void addField(CfField field) {
        if (this.fields == null) {
            this.fields = this.lastField = field;
        } else {
            this.lastField.setNext(field);
            this.lastField = field;
        }
        ++this.fieldCount;
    }

    public CfField addField(int accessFlags, String name, String signature) {
        int nameCp = this.constantPool.addUtf8(name).getIndex();
        int signatureCp = this.constantPool.addUtf8(signature).getIndex();
        return this.addField(accessFlags, nameCp, signatureCp);
    }

    public CfField addField(int accessFlags, String name, Class fieldClass) {
        StringBuffer buf = new StringBuffer();
        Java.getVmSignature((Class)fieldClass, (StringBuffer)buf);
        String fieldSig = buf.toString();
        return this.addField(accessFlags, name, fieldSig);
    }

    public CfField addField(int accessFlags, int nameCp, int signatureCp) {
        CfField field = new CfField(this);
        field.setAccessFlags(accessFlags);
        field.setNameIndex(nameCp);
        field.setDescriptorIndex(signatureCp);
        this.addField(field);
        return field;
    }

    public CfField addField(int accessFlags, String name, CpClass signature) {
        int nameCp = this.constantPool.addUtf8(name).getIndex();
        String vmSignature = "L" + signature.getStringName() + ";";
        int signatureCp = this.constantPool.addUtf8(vmSignature).getIndex();
        return this.addField(accessFlags, nameCp, signatureCp);
    }

    public CfField getField(String fieldName) {
        CfField found = null;
        for (CfField field = this.getFields(); field != null; field = field.getNext()) {
            if (!field.getName().equals(fieldName)) continue;
            found = field;
            break;
        }
        return found;
    }

    public CodeBuilder getCodeBuilder(CfMethod method) {
        CodeBuilder builder;
        if (this.codeBuilder == null) {
            builder = new CodeBuilder(method);
        } else {
            builder = this.codeBuilder;
            this.codeBuilder = null;
            builder.setMethod(method);
        }
        return builder;
    }

    public void releaseCodeBuilder(CodeBuilder builder) {
        if (this.codeBuilder == null) {
            this.codeBuilder = builder;
        }
    }
}

