/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.format;

import java.util.Vector;
import jd.util.StringUtil;
import jd.xml.xpath.object.XNumber;

public class NumberingFormat {
    private int groupingSize_;
    private char groupingSeparator_;
    private String firstSeparator_;
    private String lastSeparator_;
    private String definition_;
    private Item[] items_;
    private static final String ROMAN_UPPERCASE = "M2D5C2L5X2V5I";
    private static final String ROMAN_LOWERCASE = "m2d5c2l5x2v5i";

    public NumberingFormat(String string) {
        this(string, -1, '?');
    }

    public NumberingFormat(String string, int n, char c) {
        this.definition_ = string;
        this.groupingSize_ = n;
        this.groupingSeparator_ = c;
        Vector<Item> vector = new Vector<Item>();
        if (string == null || string.length() == 0) {
            vector.addElement(this.createItem(null, "1"));
        } else {
            Scanner scanner = new Scanner(string);
            String string2 = scanner.nextToken(false);
            String string3 = scanner.nextToken(true);
            if (string3 == null) {
                this.lastSeparator_ = string2;
                vector.addElement(this.createItem(null, "1"));
            } else {
                this.firstSeparator_ = string2;
                string2 = null;
                while (string3 != null) {
                    vector.addElement(this.createItem(string2, string3));
                    string2 = scanner.nextToken(false);
                    string3 = scanner.nextToken(true);
                }
                this.lastSeparator_ = string2;
            }
        }
        this.items_ = new Item[vector.size()];
        vector.copyInto(this.items_);
    }

    public String format(int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.firstSeparator_ != null) {
            stringBuffer.append(this.firstSeparator_);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(this.items_[n2].separator);
            }
            this.format(nArray[i], n2, stringBuffer);
            if (++n2 != this.items_.length) continue;
            --n2;
        }
        if (this.lastSeparator_ != null) {
            stringBuffer.append(this.lastSeparator_);
        }
        return stringBuffer.toString();
    }

    public String format(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.firstSeparator_ != null) {
            stringBuffer.append(this.firstSeparator_);
        }
        this.format(n, 0, stringBuffer);
        if (this.lastSeparator_ != null) {
            stringBuffer.append(this.lastSeparator_);
        }
        return stringBuffer.toString();
    }

    private void format(int n, int n2, StringBuffer stringBuffer) {
        if (n < 1 || Double.isNaN(n) || Double.isInfinite(n)) {
            stringBuffer.append(XNumber.toStringValue(n));
        } else {
            this.items_[n2].format(n, stringBuffer);
        }
    }

    private Item createItem(String string, String string2) {
        Item item = null;
        int n = string2.length();
        char c = string2.charAt(n - 1);
        switch (c) {
            case 'I': 
            case 'i': {
                item = new RomanItem(c == 'i');
                break;
            }
            case 'A': 
            case 'a': {
                item = new AlphaItem(c == 'a');
                break;
            }
            default: {
                item = new DigitItem(this.groupingSize_, this.groupingSeparator_, string2);
            }
        }
        item.separator = string == null ? "." : string;
        return item;
    }

    private static class Scanner {
        private String def_;
        private int len_;
        private int pos_;

        public Scanner(String string) {
            this.def_ = string;
            this.len_ = this.def_.length();
        }

        public String nextToken(boolean bl) {
            int n = this.pos_;
            while (this.pos_ < this.len_ && Character.isLetterOrDigit(this.def_.charAt(this.pos_)) == bl) {
                ++this.pos_;
            }
            if (this.pos_ == n) {
                return null;
            }
            return this.def_.substring(n, this.pos_);
        }
    }

    private static class DigitItem
    extends Item {
        private int padLength_;
        private int groupingSize_;
        private char groupingSeparator_;

        public DigitItem(int n, char c, String string) {
            this.groupingSize_ = n;
            this.groupingSeparator_ = c;
            int n2 = string.length();
            if (n2 > 1 && string.charAt(n2 - 1) == '1' && string.charAt(n2 - 2) == '0') {
                this.padLength_ = 2;
                for (int i = n2 - 3; i >= 0 && string.charAt(i) == '0'; --i) {
                    ++this.padLength_;
                }
            }
        }

        public void format(int n, StringBuffer stringBuffer) {
            String string = String.valueOf(n);
            if (string.length() < this.padLength_) {
                string = StringUtil.fillupLeft(string, this.padLength_, '0');
            }
            if (this.groupingSize_ > 0 && string.length() > this.groupingSize_) {
                int n2 = string.length();
                int n3 = n2 % this.groupingSize_;
                if (n3 > 0) {
                    stringBuffer.append(string.substring(0, n3));
                }
                while (n3 < n2) {
                    stringBuffer.append(this.groupingSeparator_);
                    stringBuffer.append(string.substring(n3, n3 + this.groupingSize_));
                    n3 += this.groupingSize_;
                }
            } else {
                stringBuffer.append(string);
            }
        }
    }

    private static class AlphaItem
    extends Item {
        private char base_;

        public AlphaItem(boolean bl) {
            this.base_ = (char)((bl ? 97 : 65) - 1);
        }

        public void format(int n, StringBuffer stringBuffer) {
            int n2 = stringBuffer.length();
            while (n > 0) {
                stringBuffer.insert(n2, (char)(n % 26 + this.base_));
                n /= 26;
            }
        }
    }

    private static class RomanItem
    extends Item {
        private boolean lowerCase_;

        public RomanItem(boolean bl) {
            this.lowerCase_ = bl;
        }

        public void format(int n, StringBuffer stringBuffer) {
            RomanItem.getRomanNumber(n, stringBuffer, this.lowerCase_);
        }

        private static void getRomanNumber(int n, StringBuffer stringBuffer, boolean bl) {
            String string = bl ? NumberingFormat.ROMAN_LOWERCASE : NumberingFormat.ROMAN_UPPERCASE;
            int n2 = 1000;
            int n3 = 0;
            while (true) {
                if (n >= n2) {
                    stringBuffer.append(string.charAt(n3));
                    n -= n2;
                    continue;
                }
                if (n <= 0) break;
                int n4 = n3 + 2;
                int n5 = string.charAt(n4 - 1) - 48;
                int n6 = n2 / n5;
                if (n5 == 2) {
                    n6 /= string.charAt((n4 += 2) - 1) - 48;
                }
                if (n + n6 >= n2) {
                    stringBuffer.append(string.charAt(n4));
                    n += n6;
                    continue;
                }
                n2 /= string.charAt((n3 += 2) - 1) - 48;
            }
        }
    }

    private static abstract class Item {
        public String separator;

        private Item() {
        }

        public abstract void format(int var1, StringBuffer var2);
    }
}

