/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

class ArithmeticExpression
extends BinaryExpression {
    private static final int NUMERIC_ARITHMETIC = 0;
    private static final int DATE_AND_DURATION = 1;
    private static final int DATE_DIFFERENCE = 2;
    private static final int DURATION_ADDITION = 3;
    private static final int DURATION_MULTIPLICATION = 4;
    private static final int UNKNOWN = -1;
    private static Signature[] plusTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DATE_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TYPE), new Signature(Type.DURATION_TYPE, Type.DATE_TYPE, 1, Type.DATE_TYPE), new Signature(Type.TIME_TYPE, Type.DURATION_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.TIME_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.DATE_TIME_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.YEAR_MONTH_DURATION_TYPE, Type.YEAR_MONTH_DURATION_TYPE, 3, Type.YEAR_MONTH_DURATION_TYPE), new Signature(Type.DAY_TIME_DURATION_TYPE, Type.DAY_TIME_DURATION_TYPE, 3, Type.DAY_TIME_DURATION_TYPE)};
    private static Signature[] minusTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DATE_TYPE, Type.DATE_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.DATE_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TYPE), new Signature(Type.TIME_TYPE, Type.TIME_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.TIME_TYPE, Type.DURATION_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DATE_TIME_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.YEAR_MONTH_DURATION_TYPE, Type.YEAR_MONTH_DURATION_TYPE, 3, Type.YEAR_MONTH_DURATION_TYPE), new Signature(Type.DAY_TIME_DURATION_TYPE, Type.DAY_TIME_DURATION_TYPE, 3, Type.DAY_TIME_DURATION_TYPE)};
    private static Signature[] multiplyTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.DURATION_TYPE, 4, Type.DURATION_TYPE), new Signature(Type.DURATION_TYPE, Type.NUMBER_TYPE, 4, Type.DURATION_TYPE)};
    private static Signature[] divideTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DURATION_TYPE, Type.NUMBER_TYPE, 4, Type.DURATION_TYPE)};
    private static Signature[] idivTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.INTEGER_TYPE)};
    private static Signature[] modTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE)};
    private boolean backwardsCompatible = false;

    public ArithmeticExpression() {
    }

    public ArithmeticExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        Expression expression;
        block11: {
            this.backwardsCompatible = staticContext.isInBackwardsCompatibleMode();
            SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
            RoleLocator roleLocator = new RoleLocator(1, Tokenizer.tokens[this.operator], 0);
            this.operands[0] = TypeChecker.staticTypeCheck(this.operands[0], sequenceType, this.backwardsCompatible, roleLocator);
            RoleLocator roleLocator2 = new RoleLocator(1, Tokenizer.tokens[this.operator], 1);
            this.operands[1] = TypeChecker.staticTypeCheck(this.operands[1], sequenceType, this.backwardsCompatible, roleLocator2);
            expression = super.analyze(staticContext);
            if (!(expression instanceof ArithmeticExpression)) break block11;
            ItemType itemType = this.operands[0].getItemType();
            ItemType itemType2 = this.operands[1].getItemType();
            int n = this.getAction(itemType, this.operator, itemType2);
            switch (n) {
                case 0: {
                    expression = new NumericArithmetic(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                case 3: {
                    expression = new DurationAddition(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                case 4: {
                    expression = new DurationMultiplication(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                case 1: {
                    expression = new DateAndDuration(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                case 2: {
                    expression = new DateDifference(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                default: {
                    if (!this.backwardsCompatible && Type.isSubType(itemType, Type.ATOMIC_TYPE) && itemType != Type.UNTYPED_ATOMIC_TYPE && itemType != Type.ATOMIC_TYPE && Type.isSubType(itemType2, Type.ATOMIC_TYPE) && itemType2 != Type.UNTYPED_ATOMIC_TYPE && itemType2 != Type.ATOMIC_TYPE) {
                        throw new XPathException.Type("Unsuitable operands for arithmetic operation (" + itemType.toString() + ", " + itemType2.toString() + ")");
                    }
                    return expression;
                }
            }
            try {
                if (this.operands[0] instanceof Value && this.operands[1] instanceof Value) {
                    return ExpressionTool.eagerEvaluate(this, null);
                }
            }
            catch (XPathException.Dynamic dynamic) {}
        }
        return expression;
    }

    private int getAction(ItemType itemType, int n, ItemType itemType2) {
        Signature[] signatureArray = this.getOperatorTable(n);
        int n2 = this.getEntry(signatureArray, itemType, itemType2);
        if (n2 < 0) {
            return -1;
        }
        return signatureArray[n2].operation;
    }

    private Signature[] getOperatorTable(int n) {
        switch (n) {
            case 15: {
                return plusTable;
            }
            case 16: 
            case 199: {
                return minusTable;
            }
            case 17: {
                return multiplyTable;
            }
            case 18: {
                return divideTable;
            }
            case 50: {
                return idivTable;
            }
            case 19: {
                return modTable;
            }
        }
        throw new IllegalArgumentException("Unknown arithmetic operator");
    }

    private int getEntry(Signature[] signatureArray, ItemType itemType, ItemType itemType2) {
        int n = 0;
        while (n < signatureArray.length) {
            if (Type.isSubType(itemType, signatureArray[n].operand0) && Type.isSubType(itemType2, signatureArray[n].operand1)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ItemType getItemType() {
        ItemType itemType = this.operands[0].getItemType();
        ItemType itemType2 = this.operands[1].getItemType();
        Signature[] signatureArray = this.getOperatorTable(this.operator);
        int n = this.getEntry(signatureArray, itemType, itemType2);
        if (n < 0) {
            return Type.ATOMIC_TYPE;
        }
        ItemType itemType3 = signatureArray[n].resultType;
        if (itemType3 == Type.NUMBER_TYPE) {
            itemType3 = NumericValue.promote(itemType, itemType2);
            if (this.operator == 18 && itemType3 == Type.INTEGER_TYPE) {
                itemType3 = Type.DECIMAL_TYPE;
            }
        }
        return itemType3;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.operands[1].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return null;
        }
        int n = this.getAction(atomicValue.getItemType(), this.operator, atomicValue2.getItemType());
        switch (n) {
            case 0: {
                return new NumericArithmetic(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
            case 3: {
                return new DurationAddition(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
            case 4: {
                return new DurationMultiplication(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
            case 1: {
                return new DateAndDuration(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
            case 2: {
                return new DateDifference(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
        }
        if (this.backwardsCompatible) {
            NumericValue numericValue;
            NumericValue numericValue2;
            try {
                numericValue2 = (NumericValue)atomicValue.convert(646);
                numericValue = (NumericValue)atomicValue2.convert(646);
            }
            catch (XPathException xPathException) {
                this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue.getItemType() + ", " + atomicValue2.getItemType() + ")");
                return null;
            }
            return new NumericArithmetic(numericValue2, this.operator, numericValue).evaluateItem(xPathContext);
        }
        this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue.getItemType() + ", " + atomicValue2.getItemType() + ")");
        return null;
    }

    public static class DateDifference
    extends ArithmeticExpression {
        public DateDifference(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operands[1].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            CalendarValue calendarValue2 = (CalendarValue)atomicValue2.getPrimitiveValue();
            return calendarValue.subtract(calendarValue2);
        }
    }

    public static class DateAndDuration
    extends ArithmeticExpression {
        public DateAndDuration(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
            if (Type.isSubType(expression.getItemType(), Type.DURATION_TYPE)) {
                this.operands[0] = expression2;
                this.operands[1] = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operands[1].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue2.getPrimitiveValue();
            if (this.operator == 16) {
                durationValue = durationValue.multiply(-1.0);
            }
            return calendarValue.add(durationValue);
        }
    }

    public static class DurationMultiplication
    extends ArithmeticExpression {
        public DurationMultiplication(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
            if (Type.isSubType(expression2.getItemType(), Type.DURATION_TYPE)) {
                this.operands[0] = expression2;
                this.operands[1] = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operands[1].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            NumericValue numericValue = (NumericValue)atomicValue2.getPrimitiveValue();
            double d = numericValue.asDouble();
            if (this.operator == 18) {
                d = 1.0 / d;
            }
            return durationValue.multiply(d);
        }
    }

    public static class DurationAddition
    extends ArithmeticExpression {
        public DurationAddition(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operands[1].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue2 = (DurationValue)atomicValue2.getPrimitiveValue();
            if (this.operator == 15) {
                return durationValue.add(durationValue2);
            }
            if (this.operator == 16) {
                return durationValue.subtract(durationValue2);
            }
            throw new AssertionError((Object)"Unknown operation on durations");
        }
    }

    public static class NumericArithmetic
    extends ArithmeticExpression {
        public NumericArithmetic(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
            int n = 517;
            if (this.operator == 50) {
                AtomicValue atomicValue3;
                n = 532;
                if (atomicValue2 == null) {
                    return null;
                }
                if (atomicValue2 instanceof UntypedAtomicValue) {
                    atomicValue2 = atomicValue2.convert(n);
                }
                if ((atomicValue3 = (AtomicValue)this.operands[1].evaluateItem(xPathContext)) == null) {
                    return null;
                }
                if (atomicValue3 instanceof UntypedAtomicValue) {
                    atomicValue3 = atomicValue3.convert(n);
                }
                if (!(atomicValue2 instanceof IntegerValue)) {
                    this.typeError("First argument to idiv must be an integer");
                    return null;
                }
                if (!(atomicValue3 instanceof IntegerValue)) {
                    this.typeError("Second argument to idiv must be an integer");
                    return null;
                }
                try {
                    return ((NumericValue)atomicValue2).arithmetic(this.operator, (NumericValue)atomicValue3);
                }
                catch (ArithmeticException arithmeticException) {
                    throw new XPathException.Dynamic("Arithmetic exception: " + arithmeticException.getMessage());
                }
            }
            if (atomicValue2 == null) {
                return null;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                try {
                    atomicValue2 = new DoubleValue(Value.stringToNumber(atomicValue2.getStringValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    atomicValue2 = DoubleValue.NaN;
                }
            }
            if ((atomicValue = (AtomicValue)this.operands[1].evaluateItem(xPathContext)) == null) {
                return null;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                try {
                    atomicValue = new DoubleValue(Value.stringToNumber(atomicValue.getStringValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    atomicValue = DoubleValue.NaN;
                }
            }
            if (this.operator == 199) {
                return ((NumericValue)atomicValue).negate();
            }
            if (this.operator == 50) {
                if (!(atomicValue2 instanceof IntegerValue)) {
                    this.typeError("First argument to idiv must be an integer");
                    return null;
                }
                if (!(atomicValue instanceof IntegerValue)) {
                    this.typeError("Second argument to idiv must be an integer");
                    return null;
                }
            }
            try {
                return ((NumericValue)atomicValue2).arithmetic(this.operator, (NumericValue)atomicValue);
            }
            catch (ArithmeticException arithmeticException) {
                throw new XPathException.Dynamic("Arithmetic exception: " + arithmeticException.getMessage());
            }
        }
    }

    private static class Signature {
        ItemType operand0;
        ItemType operand1;
        int operation;
        ItemType resultType;

        Signature(ItemType itemType, ItemType itemType2, int n, ItemType itemType3) {
            this.operand0 = itemType;
            this.operand1 = itemType2;
            this.operation = n;
            this.resultType = itemType3;
        }
    }
}

