/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceChecker;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public abstract class GeneralVariable
extends Instruction {
    private static final int ASSIGNABLE = 1;
    private static final int GLOBAL = 2;
    private static final int REQUIRED = 4;
    private static final int TUNNEL = 8;
    private static final int CONTAINS_LOCALS = 16;
    private byte properties = 0;
    private Expression select = null;
    private SequenceType requiredType = null;
    protected int variableFingerprint = -1;

    public void init(Expression expression, SequenceType sequenceType, int n) {
        this.select = expression;
        this.requiredType = sequenceType;
        this.variableFingerprint = n;
    }

    public void setSelect(Expression expression) {
        this.select = expression;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setVariableFingerprint(int n) {
        this.variableFingerprint = n;
    }

    public void setGlobal(boolean bl) {
        this.properties = bl ? (byte)(this.properties | 2) : (byte)(this.properties & 0xFFFFFFFD);
    }

    public void setAssignable(boolean bl) {
        this.properties = bl ? (byte)(this.properties | 1) : (byte)(this.properties & 0xFFFFFFFE);
    }

    public void setRequiredParam(boolean bl) {
        this.properties = bl ? (byte)(this.properties | 4) : (byte)(this.properties & 0xFFFFFFFB);
    }

    public void setContainsLocals(boolean bl) {
        this.properties = bl ? (byte)(this.properties | 0x10) : (byte)(this.properties & 0xFFFFFFEF);
    }

    public void setTunnel(boolean bl) {
        this.properties = bl ? (byte)(this.properties | 8) : (byte)(this.properties & 0xFFFFFFF7);
    }

    public final boolean isAssignable() {
        return (this.properties & 1) != 0;
    }

    public int getVariableFingerprint() {
        return this.variableFingerprint;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public SequenceType getResultType() {
        return new SequenceType(NoNodeTest.getInstance(), 256);
    }

    public final boolean isGlobal() {
        return (this.properties & 2) != 0;
    }

    public final boolean containsLocals() {
        return (this.properties & 0x10) != 0;
    }

    public final boolean isRequiredParam() {
        return (this.properties & 4) != 0;
    }

    public final boolean isTunnelParam() {
        return (this.properties & 8) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        if (namePool != null) {
            instructionDetails.setProperty("name", namePool.getDisplayName(this.variableFingerprint));
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            XPathContext xPathContext = controller.newXPathContext();
            SequenceIterator sequenceIterator = this.getSelectValue(xPathContext).iterate(xPathContext);
            int n = 0;
            Item item = sequenceIterator.next();
            if (item == null) {
                stringBuffer.append("()");
            } else {
                while (n++ < 4) {
                    String string = item instanceof NodeInfo ? ((NodeInfo)item).generateId() : item.getStringValue();
                    if (string.length() < 20) {
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append(string.substring(0, 20));
                        stringBuffer.append("...");
                    }
                    item = sequenceIterator.next();
                    if (item == null) break;
                    stringBuffer.append(", ");
                }
            }
            instructionDetails.setProperty("value", stringBuffer.toString());
            return;
        }
        catch (TransformerException transformerException) {
            stringBuffer.append("*ERROR*");
            return;
        }
    }

    public Value getSelectValue(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        NamePool namePool = controller.getNamePool();
        if (this.select == null) {
            Object object;
            SequenceReceiver sequenceReceiver = controller.getReceiver();
            SequenceOutputter sequenceOutputter = new SequenceOutputter();
            Object object2 = sequenceOutputter;
            object2.setNamePool(namePool);
            controller.changeToSequenceOutputDestination(sequenceOutputter);
            if (this.requiredType != null) {
                object = new SequenceChecker();
                ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
                ((SequenceChecker)object).setRequiredType(this.requiredType);
                object2 = object;
                controller.setReceiver((SequenceReceiver)object);
            }
            if (this.isGlobal() && this.containsLocals()) {
                object = controller.getBindery();
                ((Bindery)object).openStackFrame(ParameterSet.EMPTY_PARAMETER_SET, null);
                this.processChildren(controller.newXPathContext());
                ((Bindery)object).closeStackFrame();
            } else {
                this.processChildren(controller.newXPathContext());
            }
            controller.resetOutputDestination(sequenceReceiver);
            if (this.requiredType != null) {
                ((SequenceChecker)object2).finalCheck();
            }
            return sequenceOutputter.getSequence();
        }
        if (this.isAssignable() || this.isGlobal()) {
            if (this.containsLocals()) {
                Bindery bindery = controller.getBindery();
                bindery.openStackFrame(ParameterSet.EMPTY_PARAMETER_SET, null);
                Value value = ExpressionTool.eagerEvaluate(this.select, controller.newXPathContext());
                bindery.closeStackFrame();
                return value;
            }
            return ExpressionTool.eagerEvaluate(this.select, controller.newXPathContext());
        }
        return ExpressionTool.lazyEvaluate(this.select, controller.newXPathContext());
    }
}

