/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.util.Set;
import org.cojen.classfile.AbstractCodeAssembler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.LocationRange;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.TypeDesc;

public class NullCodeAssembler
extends AbstractCodeAssembler {
    private final MethodInfo mMethod;
    private final LocalVariable[] mParams;
    private int mInstrCount;

    public NullCodeAssembler(MethodInfo mi) {
        this.mMethod = mi;
        TypeDesc[] paramTypes = this.mMethod.getMethodDescriptor().getParameterTypes();
        this.mParams = new LocalVariable[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            this.mParams[i] = new Variable(null, paramTypes[i]);
        }
    }

    protected int getInstructionsSeen() {
        return this.mInstrCount;
    }

    public int getParameterCount() {
        return this.mMethod.getMethodDescriptor().getParameterCount();
    }

    public LocalVariable getParameter(int index) {
        return this.mParams[index];
    }

    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        return new Variable(name, type);
    }

    public Label createLabel() {
        return new DummyLabel();
    }

    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
    }

    public void mapLineNumber(int lineNumber) {
    }

    public void loadNull() {
        ++this.mInstrCount;
    }

    public void loadConstant(String value) {
        ++this.mInstrCount;
    }

    public void loadConstant(TypeDesc type) {
        ++this.mInstrCount;
    }

    public void loadConstant(boolean value) {
        ++this.mInstrCount;
    }

    public void loadConstant(int value) {
        ++this.mInstrCount;
    }

    public void loadConstant(long value) {
        ++this.mInstrCount;
    }

    public void loadConstant(float value) {
        ++this.mInstrCount;
    }

    public void loadConstant(double value) {
        ++this.mInstrCount;
    }

    public void loadLocal(LocalVariable local) {
        ++this.mInstrCount;
    }

    public void loadThis() {
        ++this.mInstrCount;
    }

    public void storeLocal(LocalVariable local) {
        ++this.mInstrCount;
    }

    public void loadFromArray(TypeDesc type) {
        ++this.mInstrCount;
    }

    public void storeToArray(TypeDesc type) {
        ++this.mInstrCount;
    }

    public void loadField(String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void loadField(String className, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void loadField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void loadStaticField(String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void loadStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void storeField(String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void storeField(String className, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void storeField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void storeStaticField(String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void storeStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    public void returnVoid() {
        ++this.mInstrCount;
    }

    public void returnValue(TypeDesc type) {
        ++this.mInstrCount;
    }

    public void convert(TypeDesc fromType, TypeDesc toType) {
        ++this.mInstrCount;
    }

    public void convert(TypeDesc fromType, TypeDesc toType, int fpConvertMode) {
        ++this.mInstrCount;
    }

    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeVirtual(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeStatic(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeInterface(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeSuper(TypeDesc superClassDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeConstructor(TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeConstructor(String className, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeConstructor(TypeDesc classDesc, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void invokeSuperConstructor(TypeDesc[] params) {
        ++this.mInstrCount;
    }

    public void newObject(TypeDesc type) {
        ++this.mInstrCount;
    }

    public void newObject(TypeDesc type, int dimensions) {
        ++this.mInstrCount;
    }

    public void dup() {
        ++this.mInstrCount;
    }

    public void dupX1() {
        ++this.mInstrCount;
    }

    public void dupX2() {
        ++this.mInstrCount;
    }

    public void dup2() {
        ++this.mInstrCount;
    }

    public void dup2X1() {
        ++this.mInstrCount;
    }

    public void dup2X2() {
        ++this.mInstrCount;
    }

    public void pop() {
        ++this.mInstrCount;
    }

    public void pop2() {
        ++this.mInstrCount;
    }

    public void swap() {
        ++this.mInstrCount;
    }

    public void swap2() {
        ++this.mInstrCount;
    }

    public void branch(Location location) {
        ++this.mInstrCount;
    }

    public void ifNullBranch(Location location, boolean choice) {
        ++this.mInstrCount;
    }

    public void ifEqualBranch(Location location, boolean choice) {
        ++this.mInstrCount;
    }

    public void ifZeroComparisonBranch(Location location, String choice) {
        ++this.mInstrCount;
    }

    public void ifComparisonBranch(Location location, String choice) {
        ++this.mInstrCount;
    }

    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        ++this.mInstrCount;
    }

    public void jsr(Location location) {
        ++this.mInstrCount;
    }

    public void ret(LocalVariable local) {
        ++this.mInstrCount;
    }

    public void math(byte opcode) {
        ++this.mInstrCount;
    }

    public void arrayLength() {
        ++this.mInstrCount;
    }

    public void throwObject() {
        ++this.mInstrCount;
    }

    public void checkCast(TypeDesc type) {
        ++this.mInstrCount;
    }

    public void instanceOf(TypeDesc type) {
        ++this.mInstrCount;
    }

    public void integerIncrement(LocalVariable local, int amount) {
        ++this.mInstrCount;
    }

    public void monitorEnter() {
        ++this.mInstrCount;
    }

    public void monitorExit() {
        ++this.mInstrCount;
    }

    public void nop() {
        ++this.mInstrCount;
    }

    public void breakpoint() {
        ++this.mInstrCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Variable
    implements LocalVariable {
        private String mName;
        private final TypeDesc mType;

        Variable(String name, TypeDesc type) {
            this.mName = name;
            this.mType = type;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public void setName(String name) {
            this.mName = name;
        }

        @Override
        public TypeDesc getType() {
            return this.mType;
        }

        @Override
        public boolean isDoubleWord() {
            return this.getType().isDoubleWord();
        }

        @Override
        public int getNumber() {
            return -1;
        }

        @Override
        public Set<LocationRange> getLocationRangeSet() {
            return null;
        }
    }

    private static class DummyLabel
    implements Label {
        DummyLabel() {
        }

        public Label setLocation() {
            return this;
        }

        public int getLocation() {
            return -1;
        }

        public int compareTo(Location loc) {
            return 0;
        }
    }
}

