## Key commands
Please replace some keys with the following in macOS:

- Ctrl → command
- Alt → option
- BackSpace → delete
- Delete → fn+delete

### General
| Key         | Command                     |
| ----------- | --------------------------- |
| Ctrl+N      | Create new module           |
| Ctrl+O      | Open module                 |
| Ctrl+S      | Save module                 |
| Ctrl+P      | Open module property dialog |
| Return      | Play/stop song              |
| Space       | Toggle jam/edit mode        |
| F1          | Show effect list dialog     |
| F2          | Focus on pattern editor     |
| F3          | Focus on order list         |
| F4          | Focus on instrument list    |
| F5          | Play from start             |
| F6          | Play pattern                |
| F7          | Play from current position  |
| Ctrl+F7     | Play from marker            |
| Ctrl+Return | Play only current step      |
| F8          | Stop song                   |
| F12         | Kill sound                  |

### Instrument list
| Key    | Command                        |
| ------ | ------------------------------ |
| Insert | Add instrument                 |
| Delete | Remove instrument              |
| Ctrl+I | Open current instrument editor |

### Order list
| Key             | Command             |
| --------------- | ------------------- |
| Ctrl+C          | Copy                |
| Ctrl+V          | Paste               |
| Ctrl+A          | Select track/all    |
| Ctrl+D          | Duplicate order     |
| Alt+D           | Clone patterns      |
| Home            | Jump to first order |
| End             | Jump to last order  |
| PageUp          | Jump to upper oder  |
| PageDown        | Jump to lower oder  |
| Insert or Alt+B | Insert order below  |
| Delete          | Delete order        |
| Escape          | Deselect            |

### Pattern editor
| Key                           | Command                                     |
| ----------------------------- | ------------------------------------------- |
| Ctrl+C                        | Copy                                        |
| Ctrl+X                        | Cut                                         |
| Ctrl+V                        | Paste                                       |
| Ctrl+M                        | Paste and mix                               |
| Ctrl+A                        | Select track/all                            |
| Ctrl+G                        | Interpolate                                 |
| Ctrl+R                        | Reverse                                     |
| Ctrl+F1 or Ctrl+scroll up     | Decrease note                               |
| Ctrl+F2 or Ctrl+scroll down   | Increase note                               |
| Ctrl+F3                       | Decrease octave                             |
| Ctrl+F4                       | Increase octave                             |
| Shift+F1 or Shift+scroll up   | Fine decrease values                        |
| Shift+F2 or Shift+scroll down | Fine increase values                        |
| Shift+F3                      | Coarse decrease values                      |
| Shift+F4                      | Coarse increase values                      |
| Alt+F9                        | Toggle track                                |
| Alt+F10                       | Solo track                                  |
| Alt+Left                      | Select previous instrument                  |
| Alt+Right                     | Select next instrument                      |
| Alt+S                         | Replace instrument                          |
| Alt+L                         | Expand effect column                        |
| Alt+K                         | Shrink effect column                        |
| Ctrl+K                        | Add/Remove bookmark on the current position |
| Ctrl+B                        | Set/Delete marker                           |
| Alt+G                         | Show Go To dialog                           |
| Tab                           | Jump to right track                         |
| BackTab                       | Jump to left track                          |
| Home                          | Jump to first step                          |
| End                           | Jump to last step                           |
| PageUp                        | Jump to upper step                          |
| PageDown                      | Jump to lower step                          |
| Ctrl+Up                       | Jump to upper 1st highlighted step          |
| Ctrl+Down                     | Jump to lower 1st highlighted step          |
| Ctrl+PageUp                   | Jump to previous bookmark                   |
| Ctrl+PageDown                 | Jump to next bookmark                       |
| Ctrl+Left                     | Go to previous order                        |
| Ctrl+Right                    | Go to next order                            |
| Insert or Alt+Down            | Insert step                                 |
| BackSpace or Alt+Up           | Delete the step above                       |
| Delete                        | Delete commands                             |
| Escape                        | Deselection                                 |
| -                             | Key off                                     |
| \* (numpad)                   | Increase octave/echo buffer number          |
| / (numpad)                    | Decrease octave/echo buffer number          |
| ^                             | Echo buffer access                          |

There are two rows of a piano keyboard:

```
Current octave+1
 2 3  5 6 7  9
Q W ER T Y UI O

Current octave
 S D  G H J  L
Z X CV B N M, .
```

The keyboard shortcuts and layout can be changed in the configuration.
