/*
 *		Unofficial release 1.3.0
 *	        	B I N G
 *
 * This part is responsible for sending the probes that bing uses to 
 * measure the Rtts.
 */

/* $Id: bing_probes.h,v 1.3 1999/10/11 05:25:19 fgouget Exp $ */

#ifndef _bing_probes_h_
#define _bing_probes_h_

/* types.h provides u_short on HPUX10 and Solaris */
#include <sys/types.h>

#ifdef WIN32
/*#include "win32/win32.h"*/
#include <winsock.h>
/*#include "win32/types.h"*/
#else
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#include "bing_defs.h"

/*
 * Some general limits
 */
/* (!!) there must be a minimum packet size, what is it ? or is this the payload size */
#define MAX_PKT_SIZE      (65536-60-8)
#define PAD_PKT_SIZE      44
#define STD_TTL_LIMIT     30

/*
 * This defines the options to
 */

/*
 * To set a bing_probes option, use SOL_BP as the option level and one
 * of the option names below.
 */
#define SOL_BP             1515
#define BPO_FILLING           1
#define BPO_PATTERN           2
#define BPO_OM                3
#define BPO_UDP_PORT          4

/*
 * To specify what the packets payload should be, use BPO_FILLING as the 
 * option and specify one of the following values as the data.
 *
 * Note:
 * You must use BPO_PATTERN before you can enable the use of the pattern 
 * with BPO_FILLING. The parameter of BPO_PATTERN is a pointer to a byte 
 * array the length of which must be given in len.
 */
#define BP_FILL_MASK          3
#define BP_FILL_SEQ           0
#define BP_FILL_PATTERN       1
#define BP_FILL_RANDOM        2

/*
 * To specify the probe operating mode, use BPO_OM and set option data
 * to one of the following values. 
 */
#define BP_OM_MASK            3
#define BP_OM_UNREACH_PORT    0
#define BP_OM_TTL_EXCEEDED    1
#define BP_OM_ECHO_REPLY      2

typedef void* bp_handle;

/*
 * This structure is used by probe_send to return its results
 */
typedef struct {
    /* This structure describes the packet that was received by 
     * do_probe in response to its probe. It depends both on the 
     * method used and on the outcome of the probe.
     */
    double rtt;                 /* the rtt in milliseconds */
    struct sockaddr src_addr;   /* the host this return packet comes from */
         /* (!!) this should be changed to in_addr or even something more 
            general for IP_V6 for instance */
    struct sockaddr dst_addr;   /* the host this return packet was being sent to */
    char type, subtype;         /* this is the ICMP packet type and subtype 
                                 * of the return packet.
                                 */
    int size;                   /* the packet size */
    char* contents;             /* the full packet contents, this includes 
                                 * the IP header, ICMP...
                                 */
} bp_probedata_t;

/*
  --------------------------------------------------------------------------
	probe_open performs some initialisation tasks and returns a 
	pointer to be used with the other functions.
  ------------+----+-----+--------------------------------------------------
  Parameter   | IN | OUT | Role
  ------------+----+-----+--------------------------------------------------
  ------------+----+-----+--------------------------------------------------
  RETURN      |    |  X  | The probe handle if successful, NULL otherwise
  ------------+----+-----+--------------------------------------------------
*/
extern BINGAPI bp_handle BINGPROTO(
    probe_open,
    (
	void
    ));

/*
  --------------------------------------------------------------------------
	probe_setoption sets a probe/socket option. At the SOL_BP level the 
	valid options are:
	BPO_UDP_PORT: sets the UDP port used in BP_UNREACH_PORT mode
	        option_data must point to a short in host order
	BPO_FILLING: sets the pattern used to fill packet in pattern mode.
	BPO_PATTERN: sets the pattern used to fill the packets
	        option_data must point to an hexadecimal string 
		representing the pattern
	Options concerning other levels are given to the underlying levels.
  ------------+----+-----+--------------------------------------------------
  Parameter   | IN | OUT | Role
  ------------+----+-----+--------------------------------------------------
  handle      | X  |     | The probe handle to modify
  level       | X  |     | Level at which the option reside. This may be 
              |    |     | either SOL_BP or SOL_SOCKET.
  option      | X  |     | Option to modify
  optval      | X  |     | The option data. If the option data is an integer
              |    |     | it should be pointed to not passed as the pointer..
  optlen      | X  |     | The option data length. Note that for a pointer
              |    |     | this is the length of the data pointed to.
  ------------+----+-----+--------------------------------------------------
  RETURN      |    |  X  | 0 if successful, -1 otherwise
  ------------+----+-----+--------------------------------------------------
*/
extern BINGAPI int BINGPROTO(
    probe_set_option,
    (
	bp_handle handle,
	int level,
	int option,
	void* optval,
	int optlen
    ));


/*
 * The following values describe the result of a probe. This is the value
 * returned by do_probe. See do_probe for a detailed explanation of these
 * constants.
 */
#define BP_RES_TIMEOUT        0
#define BP_RES_TTL_EXCEEDED   1
#define BP_RES_HIT            2
#define BP_RES_UNKNOWN        4

/*
  --------------------------------------------------------------------------
	do_probe sends a packet to "probe" the network. It can be used for
	two purposes:
	- measure the RTT to a specific host.
	- perform a traceroute operation by progressively increasing the TTL
	  parameter.

	When measuring the RTT, do_probe can perform the probe in three 
	different modes:
	- BP_UNREACH_PORT: We send an UDP packet to a host on an invalid 
	  UDP port. We expect to receive a fixed size ICMP Port Unreachable
	  message in return.
	- BP_ECHO_REPLY: We send an ICMP Echo Request message to the host, 
	  and expect to receive an ICMP Echo Reply message of the same size.
	- BP_TTL_EXCEEDED: This method behaves differently depending on 
	  whether it is performed on an intermediate host in the path or on
	  the last host in the network. In the first case we send an ICMP  
	  Echo Request message to the last host but with a TTL so that the
	  host we want to probe returns a fixed size ICMP TTL Exceeded 
	  message. In the second case we cannot get this behavior and will 
	  always receive an ICMP Echo Request message. Thus this method behaves
	  like BP_UNREACH_PORT for intermediate hosts and like BP_ECHO_REPLY
	  for the terminal host. This last method is required on the Win32
	  platforms because of the restrictions placed on sending and 
	  receiving ICMP packets.

	In addition to the parameters listed below do_probe takes the following 
	parameters from the structure pointed to by the handle parameter:
        bp_udp_port, bp_pattern_size, bp_pattern.
  ------------+----+-----+--------------------------------------------------
  Parameter   | IN | OUT | Role
  ------------+----+-----+--------------------------------------------------
  handle      | X  |     | Probe handle
  target      | X  |     | Address of the target host
  size        | X  |     | Size of the outgoing message payload
  ttl         | X  |     | Specifies the TTL of the outgoing packet
  probe       |    |  X  | Stores the probe result
  ------------+----+-----+--------------------------------------------------
  RETURN      |    |  X  | -1 if an error occured and the probe could not 
              |    |     |   be sent properly or we could not set up to 
              |    |     |   receive the packet. probe does not contain any 
              |    |     |   useful data.
              |    |     | BP_RES_TIMEOUT: No answer was ever received and 
              |    |     |   the probe finally timed out. probe does not 
              |    |     |   contain any useful data.
              |    |     | BP_RES_TTL_EXCEEDED: The ttl was too small and 
              |    |     |   probe contains the packet we received.
              |    |     | BP_RES_HIT: The probe reached the target host and
              |    |     |   probe contains the packet that it returned.
              |    |     | BP_RES_UNKNOWN: Some unknown/other type of 
              |    |     |   packet was received. probe describes this 
              |    |     |   packet for diagnosis purposes.
  ------------+----+-----+--------------------------------------------------
*/
extern BINGAPI int BINGPROTO(
    do_probe,
    (
	bp_handle handle,
        struct sockaddr* target, 
	int size,
	int ttl,
	bp_probedata_t *probe
    ));

/*
  --------------------------------------------------------------------------
	probe_close releases the resources allocated by probe_open.
  ------------+----+-----+--------------------------------------------------
  Parameter   | IN | OUT | Role
  ------------+----+-----+--------------------------------------------------
  handle      | X  |     | Probe handle
  ------------+----+-----+--------------------------------------------------
  RETURN      |    |  X  | 0 if successful, -1 otherwise
  ------------+----+-----+--------------------------------------------------
*/
extern BINGAPI int BINGPROTO(
    probe_close,
    (
        bp_handle handle
    ));

#endif /* end of file */
