/*
 * pic18f67j50.h - device specific declarations
 *
 * This file is part of the GNU PIC library for SDCC,
 * originally devised by Vangelis Rokas <vrokas AT otenet.gr>
 *
 * It has been automatically generated by inc2h-pic16.pl,
 * (c) 2007 by Raphael Neider <rneider AT web.de>
 */

#ifndef __PIC18F67J50_H__
#define __PIC18F67J50_H__ 1



// Configuration Bits
#define	__CONFIG1L          	0x1FFF8
#define	__CONFIG1H          	0x1FFF9
#define	__CONFIG2L          	0x1FFFA
#define	__CONFIG2H          	0x1FFFB
#define	__CONFIG3L          	0x1FFFC
#define	__CONFIG3H          	0x1FFFD
#define	_DEVID1             	0x3FFFFE
#define	_DEVID2             	0x3FFFFF

extern __sfr __at (0xF40) PMSTAT;

extern __sfr __at (0xF40) PMSTATL;
typedef union {
	struct {
		unsigned OB0E      	: 1;
		unsigned OB1E      	: 1;
		unsigned OB2E      	: 1;
		unsigned OB3E      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OBUF      	: 1;
		unsigned OBE       	: 1;
	};
} __PMSTATLbits_t;
extern volatile __PMSTATLbits_t __at (0xF40) PMSTATLbits;

extern __sfr __at (0xF41) PMSTATH;
typedef union {
	struct {
		unsigned IB0F      	: 1;
		unsigned IB1F      	: 1;
		unsigned IB2F      	: 1;
		unsigned IB3F      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IBOV      	: 1;
		unsigned IBF       	: 1;
	};
} __PMSTATHbits_t;
extern volatile __PMSTATHbits_t __at (0xF41) PMSTATHbits;

extern __sfr __at (0xF42) PMEL;
typedef union {
	struct {
		unsigned PTEN0     	: 1;
		unsigned PTEN1     	: 1;
		unsigned PTEN2     	: 1;
		unsigned PTEN3     	: 1;
		unsigned PTEN4     	: 1;
		unsigned PTEN5     	: 1;
		unsigned PTEN6     	: 1;
		unsigned PTEN7     	: 1;
	};
} __PMELbits_t;
extern volatile __PMELbits_t __at (0xF42) PMELbits;

extern __sfr __at (0xF42) PMEN;

extern __sfr __at (0xF43) PMEH;
typedef union {
	struct {
		unsigned PTEN8     	: 1;
		unsigned PTEN9     	: 1;
		unsigned PTEN10    	: 1;
		unsigned PTEN11    	: 1;
		unsigned PTEN12    	: 1;
		unsigned PTEN13    	: 1;
		unsigned PTEN14    	: 1;
		unsigned PTEN15    	: 1;
	};
} __PMEHbits_t;
extern volatile __PMEHbits_t __at (0xF43) PMEHbits;

extern __sfr __at (0xF44) PMDIN2;

extern __sfr __at (0xF44) PMDIN2L;

extern __sfr __at (0xF45) PMDIN2H;

extern __sfr __at (0xF46) PMDOUT2;

extern __sfr __at (0xF46) PMDOUT2L;

extern __sfr __at (0xF47) PMDOUT2H;

extern __sfr __at (0xF48) PMMODE;

extern __sfr __at (0xF48) PMMODEL;
typedef union {
	struct {
		unsigned WAITE0    	: 1;
		unsigned WAITE1    	: 1;
		unsigned WAITM0    	: 1;
		unsigned WAITM1    	: 1;
		unsigned WAITM2    	: 1;
		unsigned WAITM3    	: 1;
		unsigned WAITB0    	: 1;
		unsigned WAITB1    	: 1;
	};
} __PMMODELbits_t;
extern volatile __PMMODELbits_t __at (0xF48) PMMODELbits;

extern __sfr __at (0xF49) PMMODEH;
typedef union {
	struct {
		unsigned MODE0     	: 1;
		unsigned MODE1     	: 1;
		unsigned MODE16    	: 1;
		unsigned INCM0     	: 1;
		unsigned INCM1     	: 1;
		unsigned IRQM0     	: 1;
		unsigned IRQM1     	: 1;
		unsigned BUSY      	: 1;
	};
} __PMMODEHbits_t;
extern volatile __PMMODEHbits_t __at (0xF49) PMMODEHbits;

extern __sfr __at (0xF4A) PMCON;

extern __sfr __at (0xF4A) PMCONL;
typedef union {
	struct {
		unsigned RDSP      	: 1;
		unsigned WRSP      	: 1;
		unsigned BEP       	: 1;
		unsigned CS1P      	: 1;
		unsigned CS2P      	: 1;
		unsigned ALP       	: 1;
		unsigned CSF0      	: 1;
		unsigned CSF1      	: 1;
	};
} __PMCONLbits_t;
extern volatile __PMCONLbits_t __at (0xF4A) PMCONLbits;

extern __sfr __at (0xF4B) PMCONH;
typedef union {
	struct {
		unsigned PTRDEN    	: 1;
		unsigned PTWREN    	: 1;
		unsigned PTBEEN    	: 1;
		unsigned ADRMUX0   	: 1;
		unsigned ADRMUX1   	: 1;
		unsigned PSIDL     	: 1;
		unsigned           	: 1;
		unsigned PMPEN     	: 1;
	};
} __PMCONHbits_t;
extern volatile __PMCONHbits_t __at (0xF4B) PMCONHbits;

extern __sfr __at (0xF4C) UEP0;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP0bits_t;
extern volatile __UEP0bits_t __at (0xF4C) UEP0bits;

extern __sfr __at (0xF4D) UEP1;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP1bits_t;
extern volatile __UEP1bits_t __at (0xF4D) UEP1bits;

extern __sfr __at (0xF4E) UEP2;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP2bits_t;
extern volatile __UEP2bits_t __at (0xF4E) UEP2bits;

extern __sfr __at (0xF4F) UEP3;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP3bits_t;
extern volatile __UEP3bits_t __at (0xF4F) UEP3bits;

extern __sfr __at (0xF50) UEP4;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP4bits_t;
extern volatile __UEP4bits_t __at (0xF50) UEP4bits;

extern __sfr __at (0xF51) UEP5;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP5bits_t;
extern volatile __UEP5bits_t __at (0xF51) UEP5bits;

extern __sfr __at (0xF52) UEP6;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP6bits_t;
extern volatile __UEP6bits_t __at (0xF52) UEP6bits;

extern __sfr __at (0xF53) UEP7;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP7bits_t;
extern volatile __UEP7bits_t __at (0xF53) UEP7bits;

extern __sfr __at (0xF54) UEP8;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP8bits_t;
extern volatile __UEP8bits_t __at (0xF54) UEP8bits;

extern __sfr __at (0xF55) UEP9;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP9bits_t;
extern volatile __UEP9bits_t __at (0xF55) UEP9bits;

extern __sfr __at (0xF56) UEP10;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP10bits_t;
extern volatile __UEP10bits_t __at (0xF56) UEP10bits;

extern __sfr __at (0xF57) UEP11;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP11bits_t;
extern volatile __UEP11bits_t __at (0xF57) UEP11bits;

extern __sfr __at (0xF58) UEP12;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP12bits_t;
extern volatile __UEP12bits_t __at (0xF58) UEP12bits;

extern __sfr __at (0xF59) UEP13;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP13bits_t;
extern volatile __UEP13bits_t __at (0xF59) UEP13bits;

extern __sfr __at (0xF5A) UEP14;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP14bits_t;
extern volatile __UEP14bits_t __at (0xF5A) UEP14bits;

extern __sfr __at (0xF5B) UEP15;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP15bits_t;
extern volatile __UEP15bits_t __at (0xF5B) UEP15bits;

extern __sfr __at (0xF5C) UIE;
typedef union {
	struct {
		unsigned URSTIE    	: 1;
		unsigned UERRIE    	: 1;
		unsigned ACTVIE    	: 1;
		unsigned TRNIE     	: 1;
		unsigned IDLEIE    	: 1;
		unsigned STALLIE   	: 1;
		unsigned SOFIE     	: 1;
		unsigned           	: 1;
	};
} __UIEbits_t;
extern volatile __UIEbits_t __at (0xF5C) UIEbits;

extern __sfr __at (0xF5D) UEIE;
typedef union {
	struct {
		unsigned PIDEE     	: 1;
		unsigned CRC5EE    	: 1;
		unsigned CRC16EE   	: 1;
		unsigned DFN8EE    	: 1;
		unsigned BTOEE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BTSEE     	: 1;
	};
} __UEIEbits_t;
extern volatile __UEIEbits_t __at (0xF5D) UEIEbits;

extern __sfr __at (0xF5E) UADDR;
typedef union {
	struct {
		unsigned ADDR0     	: 1;
		unsigned ADDR1     	: 1;
		unsigned ADDR2     	: 1;
		unsigned ADDR3     	: 1;
		unsigned ADDR4     	: 1;
		unsigned ADDR5     	: 1;
		unsigned ADDR6     	: 1;
		unsigned           	: 1;
	};
} __UADDRbits_t;
extern volatile __UADDRbits_t __at (0xF5E) UADDRbits;

extern __sfr __at (0xF5F) UCFG;
typedef union {
	struct {
		unsigned PPB0      	: 1;
		unsigned PPB1      	: 1;
		unsigned FSEN      	: 1;
		unsigned UTRDIS    	: 1;
		unsigned UPUEN     	: 1;
		unsigned           	: 1;
		unsigned UOEMON    	: 1;
		unsigned UTEYE     	: 1;
	};
} __UCFGbits_t;
extern volatile __UCFGbits_t __at (0xF5F) UCFGbits;

extern __sfr __at (0xF60) UFRM;

extern __sfr __at (0xF60) UFRML;
typedef union {
	struct {
		unsigned FRM0      	: 1;
		unsigned FRM1      	: 1;
		unsigned FRM2      	: 1;
		unsigned FRM3      	: 1;
		unsigned FRM4      	: 1;
		unsigned FRM5      	: 1;
		unsigned FRM6      	: 1;
		unsigned FRM7      	: 1;
	};
} __UFRMLbits_t;
extern volatile __UFRMLbits_t __at (0xF60) UFRMLbits;

extern __sfr __at (0xF61) UFRMH;
typedef union {
	struct {
		unsigned FRM8      	: 1;
		unsigned FRM9      	: 1;
		unsigned FRM10     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UFRMHbits_t;
extern volatile __UFRMHbits_t __at (0xF61) UFRMHbits;

extern __sfr __at (0xF62) UIR;
typedef union {
	struct {
		unsigned URSTIF    	: 1;
		unsigned UERRIF    	: 1;
		unsigned ACTVIF    	: 1;
		unsigned TRNIF     	: 1;
		unsigned IDLEIF    	: 1;
		unsigned STALLIF   	: 1;
		unsigned SOFIF     	: 1;
		unsigned           	: 1;
	};
} __UIRbits_t;
extern volatile __UIRbits_t __at (0xF62) UIRbits;

extern __sfr __at (0xF63) UEIR;
typedef union {
	struct {
		unsigned PIDEF     	: 1;
		unsigned CRC5EF    	: 1;
		unsigned CRC16EF   	: 1;
		unsigned DFN8EF    	: 1;
		unsigned BTOEF     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BTSEF     	: 1;
	};
} __UEIRbits_t;
extern volatile __UEIRbits_t __at (0xF63) UEIRbits;

extern __sfr __at (0xF64) USTAT;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned PPBI      	: 1;
		unsigned DIR       	: 1;
		unsigned ENDP0     	: 1;
		unsigned ENDP1     	: 1;
		unsigned ENDP2     	: 1;
		unsigned ENDP3     	: 1;
		unsigned           	: 1;
	};
} __USTATbits_t;
extern volatile __USTATbits_t __at (0xF64) USTATbits;

extern __sfr __at (0xF65) UCON;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned SUSPND    	: 1;
		unsigned RESUME    	: 1;
		unsigned USBEN     	: 1;
		unsigned PKTDIS    	: 1;
		unsigned SE0       	: 1;
		unsigned PPBRST    	: 1;
		unsigned           	: 1;
	};
} __UCONbits_t;
extern volatile __UCONbits_t __at (0xF65) UCONbits;

extern __sfr __at (0xF66) PMDIN1;

extern __sfr __at (0xF66) PMDIN1L;

extern __sfr __at (0xF67) PMDIN1H;

extern __sfr __at (0xF68) PMADDR;

extern __sfr __at (0xF68) PMADDRL;

extern __sfr __at (0xF68) PMDOUT1;

extern __sfr __at (0xF68) PMDOUT1L;

extern __sfr __at (0xF69) PMADDRH;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CS1       	: 1;
		unsigned CS2       	: 1;
	};
} __PMADDRHbits_t;
extern volatile __PMADDRHbits_t __at (0xF69) PMADDRHbits;

extern __sfr __at (0xF69) PMDOUT1H;

extern __sfr __at (0xF6A) CMSTAT;
typedef union {
	struct {
		unsigned COUT1     	: 1;
		unsigned COUT2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CMSTATbits_t;
extern volatile __CMSTATbits_t __at (0xF6A) CMSTATbits;

extern __sfr __at (0xF6A) CMSTATUS;
typedef union {
	struct {
		unsigned COUT1     	: 1;
		unsigned COUT2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CMSTATUSbits_t;
extern volatile __CMSTATUSbits_t __at (0xF6A) CMSTATUSbits;

extern __sfr __at (0xF6B) SSP2CON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK1    	: 1;
		unsigned ADMSK2    	: 1;
		unsigned ADMSK3    	: 1;
		unsigned ADMSK4    	: 1;
		unsigned ADMSK5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP2CON2bits_t;
extern volatile __SSP2CON2bits_t __at (0xF6B) SSP2CON2bits;

extern __sfr __at (0xF6C) SSP2CON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSP2CON1bits_t;
extern volatile __SSP2CON1bits_t __at (0xF6C) SSP2CON1bits;

extern __sfr __at (0xF6D) SSP2STAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_W       	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_A       	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_READ  	: 1;
		unsigned I2C_START 	: 1;
		unsigned I2C_STOP  	: 1;
		unsigned I2C_DAT   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP2STATbits_t;
extern volatile __SSP2STATbits_t __at (0xF6D) SSP2STATbits;

extern __sfr __at (0xF6E) SSP2ADD;

extern __sfr __at (0xF6E) SSP2MSK;
typedef union {
	struct {
		unsigned MSK0      	: 1;
		unsigned MSK1      	: 1;
		unsigned MSK2      	: 1;
		unsigned MSK3      	: 1;
		unsigned MSK4      	: 1;
		unsigned MSK5      	: 1;
		unsigned MSK6      	: 1;
		unsigned MSK7      	: 1;
	};
} __SSP2MSKbits_t;
extern volatile __SSP2MSKbits_t __at (0xF6E) SSP2MSKbits;

extern __sfr __at (0xF6F) SSP2BUF;

extern __sfr __at (0xF70) CCP5CON;
typedef union {
	struct {
		unsigned CCP5M0    	: 1;
		unsigned CCP5M1    	: 1;
		unsigned CCP5M2    	: 1;
		unsigned CCP5M3    	: 1;
		unsigned DCCP5Y    	: 1;
		unsigned DCCP5X    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DC5B0     	: 1;
		unsigned DC5B1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP5CONbits_t;
extern volatile __CCP5CONbits_t __at (0xF70) CCP5CONbits;

extern __sfr __at (0xF71) CCPR5;

extern __sfr __at (0xF71) CCPR5L;

extern __sfr __at (0xF72) CCPR5H;

extern __sfr __at (0xF73) CCP4CON;
typedef union {
	struct {
		unsigned CCP4M0    	: 1;
		unsigned CCP4M1    	: 1;
		unsigned CCP4M2    	: 1;
		unsigned CCP4M3    	: 1;
		unsigned DCCP4Y    	: 1;
		unsigned DCCP4X    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DC4B0     	: 1;
		unsigned DC4B1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP4CONbits_t;
extern volatile __CCP4CONbits_t __at (0xF73) CCP4CONbits;

extern __sfr __at (0xF74) CCPR4;

extern __sfr __at (0xF74) CCPR4L;

extern __sfr __at (0xF75) CCPR4H;

extern __sfr __at (0xF76) T4CON;
typedef union {
	struct {
		unsigned T4CKPS0   	: 1;
		unsigned T4CKPS1   	: 1;
		unsigned TMR4ON    	: 1;
		unsigned T4OUTPS0  	: 1;
		unsigned T4OUTPS1  	: 1;
		unsigned T4OUTPS2  	: 1;
		unsigned T4OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T4CONbits_t;
extern volatile __T4CONbits_t __at (0xF76) T4CONbits;

extern __sfr __at (0xF77) CVRCON;
typedef union {
	struct {
		unsigned CVR0      	: 1;
		unsigned CVR1      	: 1;
		unsigned CVR2      	: 1;
		unsigned CVR3      	: 1;
		unsigned CVRSS     	: 1;
		unsigned CVRR      	: 1;
		unsigned CVROE     	: 1;
		unsigned CVREN     	: 1;
	};
} __CVRCONbits_t;
extern volatile __CVRCONbits_t __at (0xF77) CVRCONbits;

extern __sfr __at (0xF77) PR4;

extern __sfr __at (0xF78) TMR4;

extern __sfr __at (0xF79) T3CON;
typedef union {
	struct {
		unsigned TMR3ON    	: 1;
		unsigned TMR3CS    	: 1;
		unsigned T3SYNC    	: 1;
		unsigned T3CCP1    	: 1;
		unsigned T3CKPS0   	: 1;
		unsigned T3CKPS1   	: 1;
		unsigned T3CCP2    	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T3INSYNC  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T3SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T3CONbits_t;
extern volatile __T3CONbits_t __at (0xF79) T3CONbits;

extern __sfr __at (0xF7A) TMR3L;

extern __sfr __at (0xF7B) TMR3H;

extern __sfr __at (0xF7C) BAUDCON2;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned DTRXP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCON2bits_t;
extern volatile __BAUDCON2bits_t __at (0xF7C) BAUDCON2bits;

extern __sfr __at (0xF7D) SPBRGH2;

extern __sfr __at (0xF7E) BAUDCON;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned DTRXP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCONbits_t;
extern volatile __BAUDCONbits_t __at (0xF7E) BAUDCONbits;

extern __sfr __at (0xF7E) BAUDCON1;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned DTRXP     	: 1;
		unsigned RCMT      	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXCKP     	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned           	: 1;
	};
} __BAUDCON1bits_t;
extern volatile __BAUDCON1bits_t __at (0xF7E) BAUDCON1bits;

extern __sfr __at (0xF7F) SPBRGH;

extern __sfr __at (0xF7F) SPBRGH1;

extern __sfr __at (0xF80) PORTA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned RA6       	: 1;
		unsigned RA7       	: 1;
	};
	struct {
		unsigned AN0       	: 1;
		unsigned AN1       	: 1;
		unsigned AN2       	: 1;
		unsigned AN3       	: 1;
		unsigned T0CKI     	: 1;
		unsigned AN4       	: 1;
		unsigned OSC2      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned VREFM     	: 1;
		unsigned VREFP     	: 1;
		unsigned           	: 1;
		unsigned C2INA     	: 1;
		unsigned CLKO      	: 1;
		unsigned           	: 1;
	};
} __PORTAbits_t;
extern volatile __PORTAbits_t __at (0xF80) PORTAbits;

extern __sfr __at (0xF81) PORTB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
	struct {
		unsigned INT0      	: 1;
		unsigned INT1      	: 1;
		unsigned INT2      	: 1;
		unsigned INT3      	: 1;
		unsigned KBI0      	: 1;
		unsigned KBI1      	: 1;
		unsigned KBI2      	: 1;
		unsigned KBI3      	: 1;
	};
	struct {
		unsigned FLT0      	: 1;
		unsigned PMA4      	: 1;
		unsigned PMA3      	: 1;
		unsigned PMA2      	: 1;
		unsigned PMA1      	: 1;
		unsigned PMA0      	: 1;
		unsigned PGC       	: 1;
		unsigned PGD       	: 1;
	};
} __PORTBbits_t;
extern volatile __PORTBbits_t __at (0xF81) PORTBbits;

extern __sfr __at (0xF82) PORTC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
	struct {
		unsigned T1OSO     	: 1;
		unsigned T1OSI     	: 1;
		unsigned CCP1      	: 1;
		unsigned SCK       	: 1;
		unsigned SDI       	: 1;
		unsigned SDO       	: 1;
		unsigned TX        	: 1;
		unsigned RX        	: 1;
	};
	struct {
		unsigned T13CKI    	: 1;
		unsigned CCP2_PORTC	: 1;
		unsigned           	: 1;
		unsigned SCL       	: 1;
		unsigned SDA       	: 1;
		unsigned C2OUT     	: 1;
		unsigned CK        	: 1;
		unsigned DT        	: 1;
	};
} __PORTCbits_t;
extern volatile __PORTCbits_t __at (0xF82) PORTCbits;

extern __sfr __at (0xF83) PORTD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned RD3       	: 1;
		unsigned RD4       	: 1;
		unsigned RD5       	: 1;
		unsigned RD6       	: 1;
		unsigned RD7       	: 1;
	};
	struct {
		unsigned PMD0      	: 1;
		unsigned PMD1      	: 1;
		unsigned PMD2      	: 1;
		unsigned PMD3      	: 1;
		unsigned PMD4      	: 1;
		unsigned PMD5      	: 1;
		unsigned PMD6      	: 1;
		unsigned PMD7      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SDO2      	: 1;
		unsigned SDA2      	: 1;
		unsigned SCL2      	: 1;
		unsigned SS2       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SDI2      	: 1;
		unsigned SCK2      	: 1;
		unsigned           	: 1;
	};
} __PORTDbits_t;
extern volatile __PORTDbits_t __at (0xF83) PORTDbits;

extern __sfr __at (0xF84) PORTE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned RE3       	: 1;
		unsigned RE4       	: 1;
		unsigned RE5       	: 1;
		unsigned RE6       	: 1;
		unsigned RE7       	: 1;
	};
	struct {
		unsigned PMRD      	: 1;
		unsigned PMWR      	: 1;
		unsigned PMBE      	: 1;
		unsigned PMA13     	: 1;
		unsigned PMA12     	: 1;
		unsigned PMA11     	: 1;
		unsigned PMA10     	: 1;
		unsigned PMA9      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned REFO      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP2_PORTE	: 1;
	};
} __PORTEbits_t;
extern volatile __PORTEbits_t __at (0xF84) PORTEbits;

extern __sfr __at (0xF85) PORTF;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RF2       	: 1;
		unsigned RF3       	: 1;
		unsigned RF4       	: 1;
		unsigned RF5       	: 1;
		unsigned RF6       	: 1;
		unsigned RF7       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned AN7       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned AN10      	: 1;
		unsigned AN11      	: 1;
		unsigned SS        	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned C2INB     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CVREF     	: 1;
		unsigned C1INA     	: 1;
		unsigned C1OUT     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned PMA5      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned C1INB     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTFbits_t;
extern volatile __PORTFbits_t __at (0xF85) PORTFbits;

extern __sfr __at (0xF86) PORTG;
typedef union {
	struct {
		unsigned RG0       	: 1;
		unsigned RG1       	: 1;
		unsigned RG2       	: 1;
		unsigned RG3       	: 1;
		unsigned RG4       	: 1;
		unsigned           	: 1;
		unsigned REPU      	: 1;
		unsigned RDPU      	: 1;
	};
	struct {
		unsigned CCP3      	: 1;
		unsigned TX2       	: 1;
		unsigned RX2       	: 1;
		unsigned CCP4      	: 1;
		unsigned CCP5      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned PMA8      	: 1;
		unsigned CK2       	: 1;
		unsigned DT2       	: 1;
		unsigned PMCS1     	: 1;
		unsigned PMCS2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned PMA7      	: 1;
		unsigned PMA6      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTGbits_t;
extern volatile __PORTGbits_t __at (0xF86) PORTGbits;

extern __sfr __at (0xF89) LATA;
typedef union {
	struct {
		unsigned LATA0     	: 1;
		unsigned LATA1     	: 1;
		unsigned LATA2     	: 1;
		unsigned LATA3     	: 1;
		unsigned LATA4     	: 1;
		unsigned LATA5     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LATAbits_t;
extern volatile __LATAbits_t __at (0xF89) LATAbits;

extern __sfr __at (0xF8A) LATB;
typedef union {
	struct {
		unsigned LATB0     	: 1;
		unsigned LATB1     	: 1;
		unsigned LATB2     	: 1;
		unsigned LATB3     	: 1;
		unsigned LATB4     	: 1;
		unsigned LATB5     	: 1;
		unsigned LATB6     	: 1;
		unsigned LATB7     	: 1;
	};
} __LATBbits_t;
extern volatile __LATBbits_t __at (0xF8A) LATBbits;

extern __sfr __at (0xF8B) LATC;
typedef union {
	struct {
		unsigned LATC0     	: 1;
		unsigned LATC1     	: 1;
		unsigned LATC2     	: 1;
		unsigned LATC3     	: 1;
		unsigned LATC4     	: 1;
		unsigned LATC5     	: 1;
		unsigned LATC6     	: 1;
		unsigned LATC7     	: 1;
	};
} __LATCbits_t;
extern volatile __LATCbits_t __at (0xF8B) LATCbits;

extern __sfr __at (0xF8C) LATD;
typedef union {
	struct {
		unsigned LATD0     	: 1;
		unsigned LATD1     	: 1;
		unsigned LATD2     	: 1;
		unsigned LATD3     	: 1;
		unsigned LATD4     	: 1;
		unsigned LATD5     	: 1;
		unsigned LATD6     	: 1;
		unsigned LATD7     	: 1;
	};
} __LATDbits_t;
extern volatile __LATDbits_t __at (0xF8C) LATDbits;

extern __sfr __at (0xF8D) LATE;
typedef union {
	struct {
		unsigned LATE0     	: 1;
		unsigned LATE1     	: 1;
		unsigned LATE2     	: 1;
		unsigned LATE3     	: 1;
		unsigned LATE4     	: 1;
		unsigned LATE5     	: 1;
		unsigned LATE6     	: 1;
		unsigned LATE7     	: 1;
	};
} __LATEbits_t;
extern volatile __LATEbits_t __at (0xF8D) LATEbits;

extern __sfr __at (0xF8E) LATF;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned LATF2     	: 1;
		unsigned LATF3     	: 1;
		unsigned LATF4     	: 1;
		unsigned LATF5     	: 1;
		unsigned LATF6     	: 1;
		unsigned LATF7     	: 1;
	};
} __LATFbits_t;
extern volatile __LATFbits_t __at (0xF8E) LATFbits;

extern __sfr __at (0xF8F) LATG;
typedef union {
	struct {
		unsigned LATG0     	: 1;
		unsigned LATG1     	: 1;
		unsigned LATG2     	: 1;
		unsigned LATG3     	: 1;
		unsigned LATG4     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LATGbits_t;
extern volatile __LATGbits_t __at (0xF8F) LATGbits;

extern __sfr __at (0xF92) DDRA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DDRAbits_t;
extern volatile __DDRAbits_t __at (0xF92) DDRAbits;

extern __sfr __at (0xF92) TRISA;
typedef union {
	struct {
		unsigned TRISA0    	: 1;
		unsigned TRISA1    	: 1;
		unsigned TRISA2    	: 1;
		unsigned TRISA3    	: 1;
		unsigned TRISA4    	: 1;
		unsigned TRISA5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISAbits_t;
extern volatile __TRISAbits_t __at (0xF92) TRISAbits;

extern __sfr __at (0xF93) DDRB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
} __DDRBbits_t;
extern volatile __DDRBbits_t __at (0xF93) DDRBbits;

extern __sfr __at (0xF93) TRISB;
typedef union {
	struct {
		unsigned TRISB0    	: 1;
		unsigned TRISB1    	: 1;
		unsigned TRISB2    	: 1;
		unsigned TRISB3    	: 1;
		unsigned TRISB4    	: 1;
		unsigned TRISB5    	: 1;
		unsigned TRISB6    	: 1;
		unsigned TRISB7    	: 1;
	};
} __TRISBbits_t;
extern volatile __TRISBbits_t __at (0xF93) TRISBbits;

extern __sfr __at (0xF94) DDRC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
} __DDRCbits_t;
extern volatile __DDRCbits_t __at (0xF94) DDRCbits;

extern __sfr __at (0xF94) TRISC;
typedef union {
	struct {
		unsigned TRISC0    	: 1;
		unsigned TRISC1    	: 1;
		unsigned TRISC2    	: 1;
		unsigned TRISC3    	: 1;
		unsigned TRISC4    	: 1;
		unsigned TRISC5    	: 1;
		unsigned TRISC6    	: 1;
		unsigned TRISC7    	: 1;
	};
} __TRISCbits_t;
extern volatile __TRISCbits_t __at (0xF94) TRISCbits;

extern __sfr __at (0xF95) DDRD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned RD3       	: 1;
		unsigned RD4       	: 1;
		unsigned RD5       	: 1;
		unsigned RD6       	: 1;
		unsigned RD7       	: 1;
	};
} __DDRDbits_t;
extern volatile __DDRDbits_t __at (0xF95) DDRDbits;

extern __sfr __at (0xF95) TRISD;
typedef union {
	struct {
		unsigned TRISD0    	: 1;
		unsigned TRISD1    	: 1;
		unsigned TRISD2    	: 1;
		unsigned TRISD3    	: 1;
		unsigned TRISD4    	: 1;
		unsigned TRISD5    	: 1;
		unsigned TRISD6    	: 1;
		unsigned TRISD7    	: 1;
	};
} __TRISDbits_t;
extern volatile __TRISDbits_t __at (0xF95) TRISDbits;

extern __sfr __at (0xF96) DDRE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned RE3       	: 1;
		unsigned RE4       	: 1;
		unsigned RE5       	: 1;
		unsigned RE6       	: 1;
		unsigned RE7       	: 1;
	};
} __DDREbits_t;
extern volatile __DDREbits_t __at (0xF96) DDREbits;

extern __sfr __at (0xF96) TRISE;
typedef union {
	struct {
		unsigned TRISE0    	: 1;
		unsigned TRISE1    	: 1;
		unsigned TRISE2    	: 1;
		unsigned TRISE3    	: 1;
		unsigned TRISE4    	: 1;
		unsigned TRISE5    	: 1;
		unsigned TRISE6    	: 1;
		unsigned TRISE7    	: 1;
	};
} __TRISEbits_t;
extern volatile __TRISEbits_t __at (0xF96) TRISEbits;

extern __sfr __at (0xF97) DDRF;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned RF1       	: 1;
		unsigned RF2       	: 1;
		unsigned RF3       	: 1;
		unsigned RF4       	: 1;
		unsigned RF5       	: 1;
		unsigned RF6       	: 1;
		unsigned RF7       	: 1;
	};
} __DDRFbits_t;
extern volatile __DDRFbits_t __at (0xF97) DDRFbits;

extern __sfr __at (0xF97) TRISF;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TRISF2    	: 1;
		unsigned TRISF3    	: 1;
		unsigned TRISF4    	: 1;
		unsigned TRISF5    	: 1;
		unsigned TRISF6    	: 1;
		unsigned TRISF7    	: 1;
	};
} __TRISFbits_t;
extern volatile __TRISFbits_t __at (0xF97) TRISFbits;

extern __sfr __at (0xF98) DDRG;
typedef union {
	struct {
		unsigned RG0       	: 1;
		unsigned RG1       	: 1;
		unsigned RG2       	: 1;
		unsigned RG3       	: 1;
		unsigned RG4       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DDRGbits_t;
extern volatile __DDRGbits_t __at (0xF98) DDRGbits;

extern __sfr __at (0xF98) TRISG;
typedef union {
	struct {
		unsigned TRISG0    	: 1;
		unsigned TRISG1    	: 1;
		unsigned TRISG2    	: 1;
		unsigned TRISG3    	: 1;
		unsigned TRISG4    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISGbits_t;
extern volatile __TRISGbits_t __at (0xF98) TRISGbits;

extern __sfr __at (0xF9B) OSCTUNE;
typedef union {
	struct {
		unsigned TUN0      	: 1;
		unsigned TUN1      	: 1;
		unsigned TUN2      	: 1;
		unsigned TUN3      	: 1;
		unsigned TUN4      	: 1;
		unsigned TUN5      	: 1;
		unsigned PLLEN     	: 1;
		unsigned INTSRC    	: 1;
	};
} __OSCTUNEbits_t;
extern volatile __OSCTUNEbits_t __at (0xF9B) OSCTUNEbits;

extern __sfr __at (0xF9C) RCSTA2;
typedef union {
	struct {
		unsigned RCD8      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RC9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned RX9D      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RC8   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RX9       	: 1;
		unsigned           	: 1;
	};
} __RCSTA2bits_t;
extern volatile __RCSTA2bits_t __at (0xF9C) RCSTA2bits;

extern __sfr __at (0xF9D) PIE1;
typedef union {
	struct {
		unsigned TMR1IE    	: 1;
		unsigned TMR2IE    	: 1;
		unsigned CCP1IE    	: 1;
		unsigned SSPIE     	: 1;
		unsigned TXIE      	: 1;
		unsigned RCIE      	: 1;
		unsigned ADIE      	: 1;
		unsigned PMPIE     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSP1IE    	: 1;
		unsigned TX1IE     	: 1;
		unsigned RC1IE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE1bits_t;
extern volatile __PIE1bits_t __at (0xF9D) PIE1bits;

extern __sfr __at (0xF9E) PIR1;
typedef union {
	struct {
		unsigned TMR1IF    	: 1;
		unsigned TMR2IF    	: 1;
		unsigned CCP1IF    	: 1;
		unsigned SSPIF     	: 1;
		unsigned TXIF      	: 1;
		unsigned RCIF      	: 1;
		unsigned ADIF      	: 1;
		unsigned PMPIF     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSP1IF    	: 1;
		unsigned TX1IF     	: 1;
		unsigned RC1IF     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR1bits_t;
extern volatile __PIR1bits_t __at (0xF9E) PIR1bits;

extern __sfr __at (0xF9F) IPR1;
typedef union {
	struct {
		unsigned TMR1IP    	: 1;
		unsigned TMR2IP    	: 1;
		unsigned CCP1IP    	: 1;
		unsigned SSPIP     	: 1;
		unsigned TXIP      	: 1;
		unsigned RCIP      	: 1;
		unsigned ADIP      	: 1;
		unsigned PMPIP     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSP1IP    	: 1;
		unsigned TX1IP     	: 1;
		unsigned RC1IP     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR1bits_t;
extern volatile __IPR1bits_t __at (0xF9F) IPR1bits;

extern __sfr __at (0xFA0) PIE2;
typedef union {
	struct {
		unsigned CCP2IE    	: 1;
		unsigned TMR3IE    	: 1;
		unsigned LVDIE     	: 1;
		unsigned BCLIE     	: 1;
		unsigned USBIE     	: 1;
		unsigned CM1IE     	: 1;
		unsigned CM2IE     	: 1;
		unsigned OSCFIE    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCL1IE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE2bits_t;
extern volatile __PIE2bits_t __at (0xFA0) PIE2bits;

extern __sfr __at (0xFA1) PIR2;
typedef union {
	struct {
		unsigned CCP2IF    	: 1;
		unsigned TMR3IF    	: 1;
		unsigned LVDIF     	: 1;
		unsigned BCLIF     	: 1;
		unsigned USBIF     	: 1;
		unsigned CM1IF     	: 1;
		unsigned CM2IF     	: 1;
		unsigned OSCFIF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCL1IF    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR2bits_t;
extern volatile __PIR2bits_t __at (0xFA1) PIR2bits;

extern __sfr __at (0xFA2) IPR2;
typedef union {
	struct {
		unsigned CCP2IP    	: 1;
		unsigned TMR3IP    	: 1;
		unsigned LVDIP     	: 1;
		unsigned BCLIP     	: 1;
		unsigned USBIP     	: 1;
		unsigned CM1IP     	: 1;
		unsigned CM2IP     	: 1;
		unsigned OSCFIP    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCL1IP    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR2bits_t;
extern volatile __IPR2bits_t __at (0xFA2) IPR2bits;

extern __sfr __at (0xFA3) PIE3;
typedef union {
	struct {
		unsigned CCP3IE    	: 1;
		unsigned CCP4IE    	: 1;
		unsigned CCP5IE    	: 1;
		unsigned TMR4IE    	: 1;
		unsigned TX2IE     	: 1;
		unsigned RC2IE     	: 1;
		unsigned BCL2IE    	: 1;
		unsigned SSP2IE    	: 1;
	};
} __PIE3bits_t;
extern volatile __PIE3bits_t __at (0xFA3) PIE3bits;

extern __sfr __at (0xFA4) PIR3;
typedef union {
	struct {
		unsigned CCP3IF    	: 1;
		unsigned CCP4IF    	: 1;
		unsigned CCP5IF    	: 1;
		unsigned TMR4IF    	: 1;
		unsigned TX2IF     	: 1;
		unsigned RC2IF     	: 1;
		unsigned BCL2IF    	: 1;
		unsigned SSP2IF    	: 1;
	};
} __PIR3bits_t;
extern volatile __PIR3bits_t __at (0xFA4) PIR3bits;

extern __sfr __at (0xFA5) IPR3;
typedef union {
	struct {
		unsigned CCP3IP    	: 1;
		unsigned CCP4IP    	: 1;
		unsigned CCP5IP    	: 1;
		unsigned TMR4IP    	: 1;
		unsigned TX2IP     	: 1;
		unsigned RC2IP     	: 1;
		unsigned BCL2IP    	: 1;
		unsigned SSP2IP    	: 1;
	};
} __IPR3bits_t;
extern volatile __IPR3bits_t __at (0xFA5) IPR3bits;

extern __sfr __at (0xFA6) EECON1;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WR        	: 1;
		unsigned WREN      	: 1;
		unsigned WRERR     	: 1;
		unsigned FREE      	: 1;
		unsigned WPROG     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __EECON1bits_t;
extern volatile __EECON1bits_t __at (0xFA6) EECON1bits;

extern __sfr __at (0xFA7) EECON2;

extern __sfr __at (0xFA8) TXSTA2;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
	struct {
		unsigned TXD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_TX8   	: 1;
		unsigned           	: 1;
	};
} __TXSTA2bits_t;
extern volatile __TXSTA2bits_t __at (0xFA8) TXSTA2bits;

extern __sfr __at (0xFA9) TXREG2;

extern __sfr __at (0xFAA) RCREG2;

extern __sfr __at (0xFAB) SPBRG2;

extern __sfr __at (0xFAC) RCSTA;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned RCD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC9       	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RC8   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC8_9     	: 1;
		unsigned           	: 1;
	};
} __RCSTAbits_t;
extern volatile __RCSTAbits_t __at (0xFAC) RCSTAbits;

extern __sfr __at (0xFAC) RCSTA1;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned RCD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC9       	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RC8   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC8_9     	: 1;
		unsigned           	: 1;
	};
} __RCSTA1bits_t;
extern volatile __RCSTA1bits_t __at (0xFAC) RCSTA1bits;

extern __sfr __at (0xFAD) TXSTA;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
	struct {
		unsigned TXD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_TX8   	: 1;
		unsigned           	: 1;
	};
} __TXSTAbits_t;
extern volatile __TXSTAbits_t __at (0xFAD) TXSTAbits;

extern __sfr __at (0xFAD) TXSTA1;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
	struct {
		unsigned TXD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_TX8   	: 1;
		unsigned           	: 1;
	};
} __TXSTA1bits_t;
extern volatile __TXSTA1bits_t __at (0xFAD) TXSTA1bits;

extern __sfr __at (0xFAE) TXREG;

extern __sfr __at (0xFAE) TXREG1;

extern __sfr __at (0xFAF) RCREG;

extern __sfr __at (0xFAF) RCREG1;

extern __sfr __at (0xFB0) SPBRG;

extern __sfr __at (0xFB0) SPBRG1;

extern __sfr __at (0xFB1) CCP3CON;
typedef union {
	struct {
		unsigned CCP3M0    	: 1;
		unsigned CCP3M1    	: 1;
		unsigned CCP3M2    	: 1;
		unsigned CCP3M3    	: 1;
		unsigned DC3B0     	: 1;
		unsigned DC3B1     	: 1;
		unsigned P3M0      	: 1;
		unsigned P3M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP3Y     	: 1;
		unsigned CCP3X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP3CONbits_t;
extern volatile __CCP3CONbits_t __at (0xFB1) CCP3CONbits;

extern __sfr __at (0xFB1) ECCP3CON;
typedef union {
	struct {
		unsigned CCP3M0    	: 1;
		unsigned CCP3M1    	: 1;
		unsigned CCP3M2    	: 1;
		unsigned CCP3M3    	: 1;
		unsigned DC3B0     	: 1;
		unsigned DC3B1     	: 1;
		unsigned P3M0      	: 1;
		unsigned P3M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP3Y     	: 1;
		unsigned CCP3X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECCP3CONbits_t;
extern volatile __ECCP3CONbits_t __at (0xFB1) ECCP3CONbits;

extern __sfr __at (0xFB2) CCPR3;

extern __sfr __at (0xFB2) CCPR3L;

extern __sfr __at (0xFB3) CCPR3H;

extern __sfr __at (0xFB4) ECCP3DEL;
typedef union {
	struct {
		unsigned PDC0      	: 1;
		unsigned PDC1      	: 1;
		unsigned PDC2      	: 1;
		unsigned PDC3      	: 1;
		unsigned PDC4      	: 1;
		unsigned PDC5      	: 1;
		unsigned PDC6      	: 1;
		unsigned PRSEN     	: 1;
	};
	struct {
		unsigned P3DC0     	: 1;
		unsigned P3DC1     	: 1;
		unsigned P3DC2     	: 1;
		unsigned P3DC3     	: 1;
		unsigned P3DC4     	: 1;
		unsigned P3DC5     	: 1;
		unsigned P3DC6     	: 1;
		unsigned P3RSEN    	: 1;
	};
} __ECCP3DELbits_t;
extern volatile __ECCP3DELbits_t __at (0xFB4) ECCP3DELbits;

extern __sfr __at (0xFB5) ECCP3AS;
typedef union {
	struct {
		unsigned PSSBD0    	: 1;
		unsigned PSSBD1    	: 1;
		unsigned PSSAC0    	: 1;
		unsigned PSSAC1    	: 1;
		unsigned ECCPAS0   	: 1;
		unsigned ECCPAS1   	: 1;
		unsigned ECCPAS2   	: 1;
		unsigned ECCPASE   	: 1;
	};
	struct {
		unsigned PSS3BD0   	: 1;
		unsigned PSS3BD1   	: 1;
		unsigned PSS3AC0   	: 1;
		unsigned PSS3AC1   	: 1;
		unsigned ECCP3AS0  	: 1;
		unsigned ECCP3AS1  	: 1;
		unsigned ECCP3AS2  	: 1;
		unsigned ECCP3ASE  	: 1;
	};
} __ECCP3ASbits_t;
extern volatile __ECCP3ASbits_t __at (0xFB5) ECCP3ASbits;

extern __sfr __at (0xFB6) CCP2CON;
typedef union {
	struct {
		unsigned CCP2M0    	: 1;
		unsigned CCP2M1    	: 1;
		unsigned CCP2M2    	: 1;
		unsigned CCP2M3    	: 1;
		unsigned DC2B0     	: 1;
		unsigned DC2B1     	: 1;
		unsigned P2M0      	: 1;
		unsigned P2M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP2Y     	: 1;
		unsigned CCP2X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP2CONbits_t;
extern volatile __CCP2CONbits_t __at (0xFB6) CCP2CONbits;

extern __sfr __at (0xFB6) ECCP2CON;
typedef union {
	struct {
		unsigned CCP2M0    	: 1;
		unsigned CCP2M1    	: 1;
		unsigned CCP2M2    	: 1;
		unsigned CCP2M3    	: 1;
		unsigned DC2B0     	: 1;
		unsigned DC2B1     	: 1;
		unsigned P2M0      	: 1;
		unsigned P2M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP2Y     	: 1;
		unsigned CCP2X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECCP2CONbits_t;
extern volatile __ECCP2CONbits_t __at (0xFB6) ECCP2CONbits;

extern __sfr __at (0xFB7) CCPR2;

extern __sfr __at (0xFB7) CCPR2L;

extern __sfr __at (0xFB8) CCPR2H;

extern __sfr __at (0xFB9) ECCP2DEL;
typedef union {
	struct {
		unsigned PDC0      	: 1;
		unsigned PDC1      	: 1;
		unsigned PDC2      	: 1;
		unsigned PDC3      	: 1;
		unsigned PDC4      	: 1;
		unsigned PDC5      	: 1;
		unsigned PDC6      	: 1;
		unsigned PRSEN     	: 1;
	};
	struct {
		unsigned P2DC0     	: 1;
		unsigned P2DC1     	: 1;
		unsigned P2DC2     	: 1;
		unsigned P2DC3     	: 1;
		unsigned P2DC4     	: 1;
		unsigned P2DC5     	: 1;
		unsigned P2DC6     	: 1;
		unsigned P2RSEN    	: 1;
	};
} __ECCP2DELbits_t;
extern volatile __ECCP2DELbits_t __at (0xFB9) ECCP2DELbits;

extern __sfr __at (0xFBA) ECCP2AS;
typedef union {
	struct {
		unsigned PSSBD0    	: 1;
		unsigned PSSBD1    	: 1;
		unsigned PSSAC0    	: 1;
		unsigned PSSAC1    	: 1;
		unsigned ECCPAS0   	: 1;
		unsigned ECCPAS1   	: 1;
		unsigned ECCPAS2   	: 1;
		unsigned ECCPASE   	: 1;
	};
	struct {
		unsigned PSS2BD0   	: 1;
		unsigned PSS2BD1   	: 1;
		unsigned PSS2AC0   	: 1;
		unsigned PSS2AC1   	: 1;
		unsigned ECCP2AS0  	: 1;
		unsigned ECCP2AS1  	: 1;
		unsigned ECCP2AS2  	: 1;
		unsigned ECCP2ASE  	: 1;
	};
} __ECCP2ASbits_t;
extern volatile __ECCP2ASbits_t __at (0xFBA) ECCP2ASbits;

extern __sfr __at (0xFBB) CCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned P1M0      	: 1;
		unsigned P1M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP1Y     	: 1;
		unsigned CCP1X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP1CONbits_t;
extern volatile __CCP1CONbits_t __at (0xFBB) CCP1CONbits;

extern __sfr __at (0xFBB) ECCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned P1M0      	: 1;
		unsigned P1M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP1Y     	: 1;
		unsigned CCP1X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECCP1CONbits_t;
extern volatile __ECCP1CONbits_t __at (0xFBB) ECCP1CONbits;

extern __sfr __at (0xFBC) CCPR1;

extern __sfr __at (0xFBC) CCPR1L;

extern __sfr __at (0xFBD) CCPR1H;

extern __sfr __at (0xFBE) ECCP1DEL;
typedef union {
	struct {
		unsigned PDC0      	: 1;
		unsigned PDC1      	: 1;
		unsigned PDC2      	: 1;
		unsigned PDC3      	: 1;
		unsigned PDC4      	: 1;
		unsigned PDC5      	: 1;
		unsigned PDC6      	: 1;
		unsigned PRSEN     	: 1;
	};
	struct {
		unsigned P1DC0     	: 1;
		unsigned P1DC1     	: 1;
		unsigned P1DC2     	: 1;
		unsigned P1DC3     	: 1;
		unsigned P1DC4     	: 1;
		unsigned P1DC5     	: 1;
		unsigned P1DC6     	: 1;
		unsigned P1RSEN    	: 1;
	};
} __ECCP1DELbits_t;
extern volatile __ECCP1DELbits_t __at (0xFBE) ECCP1DELbits;

extern __sfr __at (0xFBF) ECCP1AS;
typedef union {
	struct {
		unsigned PSSBD0    	: 1;
		unsigned PSSBD1    	: 1;
		unsigned PSSAC0    	: 1;
		unsigned PSSAC1    	: 1;
		unsigned ECCPAS0   	: 1;
		unsigned ECCPAS1   	: 1;
		unsigned ECCPAS2   	: 1;
		unsigned ECCPASE   	: 1;
	};
	struct {
		unsigned PSS1BD0   	: 1;
		unsigned PSS1BD1   	: 1;
		unsigned PSS1AC0   	: 1;
		unsigned PSS1AC1   	: 1;
		unsigned ECCP1AS0  	: 1;
		unsigned ECCP1AS1  	: 1;
		unsigned ECCP1AS2  	: 1;
		unsigned ECCP1ASE  	: 1;
	};
} __ECCP1ASbits_t;
extern volatile __ECCP1ASbits_t __at (0xFBF) ECCP1ASbits;

extern __sfr __at (0xFC0) WDTCON;
typedef union {
	struct {
		unsigned SWDTE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DEVCFG    	: 1;
		unsigned           	: 1;
		unsigned LVDSTAT   	: 1;
		unsigned REGSLP    	: 1;
	};
	struct {
		unsigned SWDTEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned ADSHR     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __WDTCONbits_t;
extern volatile __WDTCONbits_t __at (0xFC0) WDTCONbits;

extern __sfr __at (0xFC1) ADCON1;
typedef union {
	struct {
		unsigned ADCS0     	: 1;
		unsigned ADCS1     	: 1;
		unsigned ADCS2     	: 1;
		unsigned ACQT0     	: 1;
		unsigned ACQT1     	: 1;
		unsigned ACQT2     	: 1;
		unsigned ADCAL     	: 1;
		unsigned ADFM      	: 1;
	};
} __ADCON1bits_t;
extern volatile __ADCON1bits_t __at (0xFC1) ADCON1bits;

extern __sfr __at (0xFC1) ANCON0;
typedef union {
	struct {
		unsigned PCFG0     	: 1;
		unsigned PCFG1     	: 1;
		unsigned PCFG2     	: 1;
		unsigned PCFG3     	: 1;
		unsigned PCFG4     	: 1;
		unsigned PCFG5     	: 1;
		unsigned PCFG6     	: 1;
		unsigned PCFG7     	: 1;
	};
} __ANCON0bits_t;
extern volatile __ANCON0bits_t __at (0xFC1) ANCON0bits;

extern __sfr __at (0xFC2) ADCON0;
typedef union {
	struct {
		unsigned ADON      	: 1;
		unsigned DONE      	: 1;
		unsigned CHS0      	: 1;
		unsigned CHS1      	: 1;
		unsigned CHS2      	: 1;
		unsigned CHS3      	: 1;
		unsigned VCFG0     	: 1;
		unsigned VCFG1     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO_DONE   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned NOT_DONE  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON0bits_t;
extern volatile __ADCON0bits_t __at (0xFC2) ADCON0bits;

extern __sfr __at (0xFC2) ANCON1;
typedef union {
	struct {
		unsigned PCFG8     	: 1;
		unsigned PCFG9     	: 1;
		unsigned PCFG10    	: 1;
		unsigned PCFG11    	: 1;
		unsigned PCFG12    	: 1;
		unsigned PCFG13    	: 1;
		unsigned PCFG14    	: 1;
		unsigned PCFG15    	: 1;
	};
} __ANCON1bits_t;
extern volatile __ANCON1bits_t __at (0xFC2) ANCON1bits;

extern __sfr __at (0xFC3) ADRES;

extern __sfr __at (0xFC3) ADRESL;

extern __sfr __at (0xFC4) ADRESH;

extern __sfr __at (0xFC5) SSP1CON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK1    	: 1;
		unsigned ADMSK2    	: 1;
		unsigned ADMSK3    	: 1;
		unsigned ADMSK4    	: 1;
		unsigned ADMSK5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP1CON2bits_t;
extern volatile __SSP1CON2bits_t __at (0xFC5) SSP1CON2bits;

extern __sfr __at (0xFC5) SSPCON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK1    	: 1;
		unsigned ADMSK2    	: 1;
		unsigned ADMSK3    	: 1;
		unsigned ADMSK4    	: 1;
		unsigned ADMSK5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPCON2bits_t;
extern volatile __SSPCON2bits_t __at (0xFC5) SSPCON2bits;

extern __sfr __at (0xFC6) SSP1CON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSP1CON1bits_t;
extern volatile __SSP1CON1bits_t __at (0xFC6) SSP1CON1bits;

extern __sfr __at (0xFC6) SSPCON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSPCON1bits_t;
extern volatile __SSPCON1bits_t __at (0xFC6) SSPCON1bits;

extern __sfr __at (0xFC7) SSP1STAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_W       	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_A       	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_READ  	: 1;
		unsigned I2C_START 	: 1;
		unsigned I2C_STOP  	: 1;
		unsigned I2C_DAT   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP1STATbits_t;
extern volatile __SSP1STATbits_t __at (0xFC7) SSP1STATbits;

extern __sfr __at (0xFC7) SSPSTAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_W       	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_A       	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_READ  	: 1;
		unsigned I2C_START 	: 1;
		unsigned I2C_STOP  	: 1;
		unsigned I2C_DAT   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPSTATbits_t;
extern volatile __SSPSTATbits_t __at (0xFC7) SSPSTATbits;

extern __sfr __at (0xFC8) SSP1ADD;

extern __sfr __at (0xFC8) SSP1MSK;

extern __sfr __at (0xFC8) SSPADD;

extern __sfr __at (0xFC9) SSP1BUF;

extern __sfr __at (0xFC9) SSPBUF;

extern __sfr __at (0xFCA) T2CON;
typedef union {
	struct {
		unsigned T2CKPS0   	: 1;
		unsigned T2CKPS1   	: 1;
		unsigned TMR2ON    	: 1;
		unsigned T2OUTPS0  	: 1;
		unsigned T2OUTPS1  	: 1;
		unsigned T2OUTPS2  	: 1;
		unsigned T2OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T2CONbits_t;
extern volatile __T2CONbits_t __at (0xFCA) T2CONbits;

extern __sfr __at (0xFCB) PR2;

extern __sfr __at (0xFCC) PADCFG1;
typedef union {
	struct {
		unsigned PMPTTL    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PADCFG1bits_t;
extern volatile __PADCFG1bits_t __at (0xFCC) PADCFG1bits;

extern __sfr __at (0xFCC) TMR2;

extern __sfr __at (0xFCD) ODCON3;
typedef union {
	struct {
		unsigned SPI1OD    	: 1;
		unsigned SPI2OD    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ODCON3bits_t;
extern volatile __ODCON3bits_t __at (0xFCD) ODCON3bits;

extern __sfr __at (0xFCD) T1CON;
typedef union {
	struct {
		unsigned TMR1ON    	: 1;
		unsigned TMR1CS    	: 1;
		unsigned T1SYNC    	: 1;
		unsigned T1OSCEN   	: 1;
		unsigned T1CKPS0   	: 1;
		unsigned T1CKPS1   	: 1;
		unsigned T1RUN     	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T1INSYNC  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T1SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T1CONbits_t;
extern volatile __T1CONbits_t __at (0xFCD) T1CONbits;

extern __sfr __at (0xFCE) ODCON2;
typedef union {
	struct {
		unsigned USART1OD  	: 1;
		unsigned USART2OD  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned U1OD      	: 1;
		unsigned U2OD      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ODCON2bits_t;
extern volatile __ODCON2bits_t __at (0xFCE) ODCON2bits;

extern __sfr __at (0xFCE) TMR1L;

extern __sfr __at (0xFCF) ODCON1;
typedef union {
	struct {
		unsigned ECCP1OD   	: 1;
		unsigned ECCP2OD   	: 1;
		unsigned ECCP3OD   	: 1;
		unsigned CCP4OD    	: 1;
		unsigned CCP5OD    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ODCON1bits_t;
extern volatile __ODCON1bits_t __at (0xFCF) ODCON1bits;

extern __sfr __at (0xFCF) TMR1H;

extern __sfr __at (0xFD0) RCON;
typedef union {
	struct {
		unsigned NOT_BOR   	: 1;
		unsigned NOT_POR   	: 1;
		unsigned NOT_PD    	: 1;
		unsigned NOT_TO    	: 1;
		unsigned NOT_RI    	: 1;
		unsigned NOT_CM    	: 1;
		unsigned           	: 1;
		unsigned IPEN      	: 1;
	};
	struct {
		unsigned BOR       	: 1;
		unsigned POR       	: 1;
		unsigned PD        	: 1;
		unsigned TO        	: 1;
		unsigned RI        	: 1;
		unsigned CM        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RCONbits_t;
extern volatile __RCONbits_t __at (0xFD0) RCONbits;

extern __sfr __at (0xFD1) CM2CON;
typedef union {
	struct {
		unsigned C1CH0     	: 1;
		unsigned C1CH1     	: 1;
		unsigned CREF      	: 1;
		unsigned EVPOL0    	: 1;
		unsigned EVPOL1    	: 1;
		unsigned CPOL      	: 1;
		unsigned COE       	: 1;
		unsigned CON       	: 1;
	};
	struct {
		unsigned CCH0      	: 1;
		unsigned CCH1      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CM2CONbits_t;
extern volatile __CM2CONbits_t __at (0xFD1) CM2CONbits;

extern __sfr __at (0xFD1) CM2CON1;
typedef union {
	struct {
		unsigned C1CH0     	: 1;
		unsigned C1CH1     	: 1;
		unsigned CREF      	: 1;
		unsigned EVPOL0    	: 1;
		unsigned EVPOL1    	: 1;
		unsigned CPOL      	: 1;
		unsigned COE       	: 1;
		unsigned CON       	: 1;
	};
	struct {
		unsigned CCH0      	: 1;
		unsigned CCH1      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CM2CON1bits_t;
extern volatile __CM2CON1bits_t __at (0xFD1) CM2CON1bits;

extern __sfr __at (0xFD2) CM1CON;
typedef union {
	struct {
		unsigned C1CH0     	: 1;
		unsigned C1CH1     	: 1;
		unsigned CREF      	: 1;
		unsigned EVPOL0    	: 1;
		unsigned EVPOL1    	: 1;
		unsigned CPOL      	: 1;
		unsigned COE       	: 1;
		unsigned CON       	: 1;
	};
	struct {
		unsigned CCH0      	: 1;
		unsigned CCH1      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CM1CONbits_t;
extern volatile __CM1CONbits_t __at (0xFD2) CM1CONbits;

extern __sfr __at (0xFD2) CM1CON1;
typedef union {
	struct {
		unsigned C1CH0     	: 1;
		unsigned C1CH1     	: 1;
		unsigned CREF      	: 1;
		unsigned EVPOL0    	: 1;
		unsigned EVPOL1    	: 1;
		unsigned CPOL      	: 1;
		unsigned COE       	: 1;
		unsigned CON       	: 1;
	};
	struct {
		unsigned CCH0      	: 1;
		unsigned CCH1      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CM1CON1bits_t;
extern volatile __CM1CON1bits_t __at (0xFD2) CM1CON1bits;

extern __sfr __at (0xFD3) OSCCON;
typedef union {
	struct {
		unsigned SCS0      	: 1;
		unsigned SCS1      	: 1;
		unsigned IOFS      	: 1;
		unsigned OSTS      	: 1;
		unsigned IRCF0     	: 1;
		unsigned IRCF1     	: 1;
		unsigned IRCF2     	: 1;
		unsigned IDLEN     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned FLTS      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __OSCCONbits_t;
extern volatile __OSCCONbits_t __at (0xFD3) OSCCONbits;

extern __sfr __at (0xFD3) REFOCON;
typedef union {
	struct {
		unsigned RODIV0    	: 1;
		unsigned RODIV1    	: 1;
		unsigned RODIV2    	: 1;
		unsigned RODIV3    	: 1;
		unsigned ROSEL     	: 1;
		unsigned ROSSLP    	: 1;
		unsigned           	: 1;
		unsigned ROON      	: 1;
	};
} __REFOCONbits_t;
extern volatile __REFOCONbits_t __at (0xFD3) REFOCONbits;

extern __sfr __at (0xFD5) T0CON;
typedef union {
	struct {
		unsigned T0PS0     	: 1;
		unsigned T0PS1     	: 1;
		unsigned T0PS2     	: 1;
		unsigned PSA       	: 1;
		unsigned T0SE      	: 1;
		unsigned T0CS      	: 1;
		unsigned T08BIT    	: 1;
		unsigned TMR0ON    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T0PS3     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T0CONbits_t;
extern volatile __T0CONbits_t __at (0xFD5) T0CONbits;

extern __sfr __at (0xFD6) TMR0L;

extern __sfr __at (0xFD7) TMR0H;

extern __sfr __at (0xFD8) STATUS;
typedef union {
	struct {
		unsigned C         	: 1;
		unsigned DC        	: 1;
		unsigned Z         	: 1;
		unsigned OV        	: 1;
		unsigned N         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __STATUSbits_t;
extern volatile __STATUSbits_t __at (0xFD8) STATUSbits;

extern __sfr __at (0xFD9) FSR2L;

extern __sfr __at (0xFDA) FSR2H;

extern __sfr __at (0xFDB) PLUSW2;

extern __sfr __at (0xFDC) PREINC2;

extern __sfr __at (0xFDD) POSTDEC2;

extern __sfr __at (0xFDE) POSTINC2;

extern __sfr __at (0xFDF) INDF2;

extern __sfr __at (0xFE0) BSR;

extern __sfr __at (0xFE1) FSR1L;

extern __sfr __at (0xFE2) FSR1H;

extern __sfr __at (0xFE3) PLUSW1;

extern __sfr __at (0xFE4) PREINC1;

extern __sfr __at (0xFE5) POSTDEC1;

extern __sfr __at (0xFE6) POSTINC1;

extern __sfr __at (0xFE7) INDF1;

extern __sfr __at (0xFE8) WREG;

extern __sfr __at (0xFE9) FSR0L;

extern __sfr __at (0xFEA) FSR0H;

extern __sfr __at (0xFEB) PLUSW0;

extern __sfr __at (0xFEC) PREINC0;

extern __sfr __at (0xFED) POSTDEC0;

extern __sfr __at (0xFEE) POSTINC0;

extern __sfr __at (0xFEF) INDF0;

extern __sfr __at (0xFF0) INTCON3;
typedef union {
	struct {
		unsigned INT1F     	: 1;
		unsigned INT2F     	: 1;
		unsigned INT3F     	: 1;
		unsigned INT1E     	: 1;
		unsigned INT2E     	: 1;
		unsigned INT3E     	: 1;
		unsigned INT1P     	: 1;
		unsigned INT2P     	: 1;
	};
	struct {
		unsigned INT1IF    	: 1;
		unsigned INT2IF    	: 1;
		unsigned INT3IF    	: 1;
		unsigned INT1IE    	: 1;
		unsigned INT2IE    	: 1;
		unsigned INT3IE    	: 1;
		unsigned INT1IP    	: 1;
		unsigned INT2IP    	: 1;
	};
} __INTCON3bits_t;
extern volatile __INTCON3bits_t __at (0xFF0) INTCON3bits;

extern __sfr __at (0xFF1) INTCON2;
typedef union {
	struct {
		unsigned RBIP      	: 1;
		unsigned INT3P     	: 1;
		unsigned T0IP      	: 1;
		unsigned INTEDG3   	: 1;
		unsigned INTEDG2   	: 1;
		unsigned INTEDG1   	: 1;
		unsigned INTEDG0   	: 1;
		unsigned NOT_RBPU  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT3IP    	: 1;
		unsigned TMR0IP    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RBPU      	: 1;
	};
} __INTCON2bits_t;
extern volatile __INTCON2bits_t __at (0xFF1) INTCON2bits;

extern __sfr __at (0xFF2) INTCON;
typedef union {
	struct {
		unsigned RBIF      	: 1;
		unsigned INT0F     	: 1;
		unsigned T0IF      	: 1;
		unsigned RBIE      	: 1;
		unsigned INT0E     	: 1;
		unsigned T0IE      	: 1;
		unsigned PEIE      	: 1;
		unsigned GIE       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT0IF    	: 1;
		unsigned TMR0IF    	: 1;
		unsigned           	: 1;
		unsigned INT0IE    	: 1;
		unsigned TMR0IE    	: 1;
		unsigned GIEL      	: 1;
		unsigned GIEH      	: 1;
	};
} __INTCONbits_t;
extern volatile __INTCONbits_t __at (0xFF2) INTCONbits;

extern __sfr __at (0xFF3) PROD;

extern __sfr __at (0xFF3) PRODL;

extern __sfr __at (0xFF4) PRODH;

extern __sfr __at (0xFF5) TABLAT;

extern __sfr __at (0xFF6) TBLPTR;

extern __sfr __at (0xFF6) TBLPTRL;

extern __sfr __at (0xFF7) TBLPTRH;

extern __sfr __at (0xFF8) TBLPTRU;

extern __sfr __at (0xFF9) PC;

extern __sfr __at (0xFF9) PCL;

extern __sfr __at (0xFFA) PCLATH;

extern __sfr __at (0xFFB) PCLATU;

extern __sfr __at (0xFFC) STKPTR;
typedef union {
	struct {
		unsigned STKPTR0   	: 1;
		unsigned STKPTR1   	: 1;
		unsigned STKPTR2   	: 1;
		unsigned STKPTR3   	: 1;
		unsigned STKPTR4   	: 1;
		unsigned           	: 1;
		unsigned STKUNF    	: 1;
		unsigned STKOVF    	: 1;
	};
	struct {
		unsigned SP0       	: 1;
		unsigned SP1       	: 1;
		unsigned SP2       	: 1;
		unsigned SP3       	: 1;
		unsigned SP4       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned STKFUL    	: 1;
	};
} __STKPTRbits_t;
extern volatile __STKPTRbits_t __at (0xFFC) STKPTRbits;

extern __sfr __at (0xFFD) TOS;

extern __sfr __at (0xFFD) TOSL;

extern __sfr __at (0xFFE) TOSH;

extern __sfr __at (0xFFF) TOSU;


#endif

