#ifndef H_CDW_BURN_DISC
#define H_CDW_BURN_DISC

#include "main.h"

/* mode of writing files to a CD/DVD disc */
enum {
	CDW_SESSION_MODE_INIT = -1,
	CDW_SESSION_MODE_START_MULTI = 0,  /**< \brief Start writing to disc in mode allowing further appending of data (don't close disc after writing) */
	CDW_SESSION_MODE_CREATE_SINGLE,    /**< \brief Start writing to disc in mode NOT allowing further appending of data (close disc after writing)*/
	CDW_SESSION_MODE_CONTINUE_MULTI,   /**< \brief Continue writing to disc in mode allowing further appending of data (don't close disc after writing) */
	CDW_SESSION_MODE_WRITE_FINAL,      /**< \brief Write to disc in mode NOT allowing further appending of data (close disc after writing) */
	CDW_SESSION_MODE_ERROR,
	CDW_SESSION_MODE_N_MAX
};


/* mode of writing files to a CD/DVD disc */
#define CDW_DISC_MODE_INIT        0x100000000000
#define CDW_DISC_MODE_UNSPECIFIED 0x000000000000   /**< \brief Let a tool select its own mode */
#define CDW_DISC_MODE_TAO         0x000000000001   /**< \brief Track at once */
#define CDW_DISC_MODE_DAO         0x000000000010   /**< \brief Disc at once */
#define CDW_DISC_MODE_SAO         0x000000000100   /**< \brief Session at once */
#if 0 /* currently unsupported modes */
#define CDW_DISC_MODE_RAW         0x000000001000   /**< \brief Raw */
#define CDW_DISC_MODE_RAW96P      0x000000010000
#define CDW_DISC_MODE_RAW96R      0x000000100000
#define CDW_DISC_MODE_RAW16       0x000001000000
#endif
#define CDW_DISC_MODE_ERROR       0x010000000000

#define CDW_DISC_MODE_N_MODES    5 /* includes "Error" */
// #define CDW_DISC_MODE_MODES_TABLE_SIZE     CDW_DISC_MODE_SAO






typedef struct {
	cdw_id_label_t tool;

	/* Single session, append, finalize, etc. */
	cdw_id_t session_modes[CDW_SESSION_MODE_N_MAX];
	int session_modes_n_labels;
	cdw_id_t session_mode;

	/* Allowed disc modes: tao, sao, etc.; I'm not using
	   single int + ORing, because the order of modes is
	   significant: first mode on the list is most
	   appropriate/probable. */
	cdw_id_t disc_modes[CDW_DISC_MODE_N_MODES];
	int disc_modes_n_labels;
	cdw_id_t disc_mode;

	cdw_id_t speed_id; /* ID of write speed (ID, not the speed itself). */
	bool verify;       /* Verify checksums after writing and image to disc. */
	bool dummy;        /* Dummy write. */
	bool eject;        /* Eject after write is completed. */

	/* Size of data being burned to disc. This variable
	   should not store _exact_ size of data, value stored
	   in this variable should be used only when
	   approximate data size needs to be known, e.g. in
	   progress window when displaying approximate
	   progress of task.  Depending on type of task this
	   variable stores size of iso image file being burned
	   to optical disc, or size of files selected for
	   burning to optical disc. */
	double data_size_mb;

	/* cdrecord-specific. */
	bool cdrecord_burnproof;
	bool cdrecord_pad;
	int  cdrecord_pad_size;

	char *cdrecord_other_options;
	char *xorriso_burn_other_options;
	char *growisofs_other_options;
} cdw_write_t;



cdw_rv_t cdw_burn_disc(int task_id);


cdw_rv_t cdw_write_copy(cdw_write_t *target, cdw_write_t *source);
void     cdw_write_init(cdw_write_t *write);
void     cdw_write_clean(cdw_write_t *write);
cdw_rv_t cdw_write_set_defaults(cdw_write_t *write);
void     cdw_write_debug_print_options(cdw_write_t *write);

#endif /* H_CDW_BURN_DISC */
