<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Cxn/Cxn.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:c08750593de1e3fd08e6a9899b555cde)
 */

/**
 * Database access object for the Cxn entity.
 */
class CRM_Cxn_DAO_Cxn extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '4.6';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_cxn';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Connection ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Application GUID
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $app_guid;

  /**
   * Application Metadata (JSON)
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $app_meta;

  /**
   * Connection GUID
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $cxn_guid;

  /**
   * Shared secret
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $secret;

  /**
   * Permissions approved for the service (JSON)
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $perm;

  /**
   * Options for the service (JSON)
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $options;

  /**
   * Is connection currently enabled?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * When was the connection was created.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_date;

  /**
   * When the connection was created or modified.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $modified_date;

  /**
   * The last time the application metadata was fetched.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $fetched_date;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_cxn';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Cxns') : ts('Cxn');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Connection ID'),
          'description' => ts('Connection ID'),
          'required' => TRUE,
          'where' => 'civicrm_cxn.id',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '4.6',
        ],
        'app_guid' => [
          'name' => 'app_guid',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Application GUID'),
          'description' => ts('Application GUID'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_cxn.app_guid',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'add' => '4.6',
        ],
        'app_meta' => [
          'name' => 'app_meta',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Application Metadata (JSON)'),
          'description' => ts('Application Metadata (JSON)'),
          'where' => 'civicrm_cxn.app_meta',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'add' => '4.6',
        ],
        'cxn_guid' => [
          'name' => 'cxn_guid',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Connection GUID'),
          'description' => ts('Connection GUID'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_cxn.cxn_guid',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'add' => '4.6',
        ],
        'secret' => [
          'name' => 'secret',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Secret'),
          'description' => ts('Shared secret'),
          'where' => 'civicrm_cxn.secret',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'html' => [
            'label' => ts("Secret"),
          ],
          'add' => '4.6',
        ],
        'perm' => [
          'name' => 'perm',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Perm'),
          'description' => ts('Permissions approved for the service (JSON)'),
          'where' => 'civicrm_cxn.perm',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'html' => [
            'label' => ts("Permissions"),
          ],
          'add' => '4.6',
        ],
        'options' => [
          'name' => 'options',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Options'),
          'description' => ts('Options for the service (JSON)'),
          'where' => 'civicrm_cxn.options',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_JSON,
          'html' => [
            'label' => ts("Options"),
          ],
          'add' => '4.6',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Active'),
          'description' => ts('Is connection currently enabled?'),
          'required' => TRUE,
          'where' => 'civicrm_cxn.is_active',
          'default' => '1',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'add' => '4.6',
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Created Date'),
          'description' => ts('When was the connection was created.'),
          'required' => FALSE,
          'where' => 'civicrm_cxn.created_date',
          'default' => NULL,
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'html' => [
            'label' => ts("Created Date"),
          ],
          'add' => '4.6',
        ],
        'modified_date' => [
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Modified Date'),
          'description' => ts('When the connection was created or modified.'),
          'required' => FALSE,
          'where' => 'civicrm_cxn.modified_date',
          'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'html' => [
            'label' => ts("Modified Date"),
          ],
          'readonly' => TRUE,
          'add' => '4.6',
        ],
        'fetched_date' => [
          'name' => 'fetched_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Fetched Date'),
          'description' => ts('The last time the application metadata was fetched.'),
          'required' => FALSE,
          'where' => 'civicrm_cxn.fetched_date',
          'default' => NULL,
          'table_name' => 'civicrm_cxn',
          'entity' => 'Cxn',
          'bao' => 'CRM_Cxn_BAO_Cxn',
          'localizable' => 0,
          'html' => [
            'label' => ts("Fetched Date"),
          ],
          'add' => '4.6',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'cxn', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'cxn', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_appid' => [
        'name' => 'UI_appid',
        'field' => [
          0 => 'app_guid',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_cxn::1::app_guid',
      ],
      'UI_keypair_cxnid' => [
        'name' => 'UI_keypair_cxnid',
        'field' => [
          0 => 'cxn_guid',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_cxn::1::cxn_guid',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
