# CiviCRM 5.1.0

Released May 2, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| Alter the API?                                                  |   no    |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-21677](https://issues.civicrm.org/jira/browse/CRM-21677) Report
  improvements ([11814](https://github.com/civicrm/civicrm-core/pull/11814),
  [11898](https://github.com/civicrm/civicrm-core/pull/11898),
  [11889](https://github.com/civicrm/civicrm-core/pull/11889),
  [11880](https://github.com/civicrm/civicrm-core/pull/11880),
  [11876](https://github.com/civicrm/civicrm-core/pull/11876),
  [11875](https://github.com/civicrm/civicrm-core/pull/11875),
  [11867](https://github.com/civicrm/civicrm-core/pull/11867), and
  [11855](https://github.com/civicrm/civicrm-core/pull/11855))**

  Reports that don't have detailed information about contacts now no longer join
  to the address, phone, and email tables.

- **[CRM-21434](https://issues.civicrm.org/jira/browse/CRM-21434) Add activities
  to recent items on view and edit
  ([11891](https://github.com/civicrm/civicrm-core/pull/11891))**

  A recently viewed or edited activity will now appear on the list of recent
  items in Backdrop, Drupal, and Joomla.

- **[CRM-21489](https://issues.civicrm.org/jira/browse/CRM-21489) Deadlock
  retries have been accidentally blocked
  ([11336](https://github.com/civicrm/civicrm-core/pull/11336) and
  [197](https://github.com/civicrm/civicrm-packages/pull/197))**

  This restores functionality that retries transactions if they face a deadlock
  in the database.  The number of times is now a constant that can be set in
  `civicrm.settings.php`.

- **[CRM-21840](https://issues.civicrm.org/jira/browse/CRM-21840) Show Tool Icon
  For Radio Button Groups
  ([11819](https://github.com/civicrm/civicrm-core/pull/11819))**

  A group of radio buttons will now display a wrench icon if the user has the
  permission to edit the options.  This now matches the feature for select
  boxes.

- **[CRM-20981](https://issues.civicrm.org/jira/browse/CRM-20981) Allow custom
  base-pages with less `crmApp` boilerplate
  ([10783](https://github.com/civicrm/civicrm-core/pull/10783))**

  Extensions that use AngularJS can now define a base path more easily.

- **[CRM-20624](https://issues.civicrm.org/jira/browse/CRM-20624) Expose
  description field for option values in UI
  ([10403](https://github.com/civicrm/civicrm-core/pull/10403))**

  Custom field options have a `description` field (that has been in the database
  for a while); now it can be set from the user interface and viewed when
  managing option values.

- **[CRM-21835](https://issues.civicrm.org/jira/browse/CRM-21835) Detailed
  Logging - Use INNODB if Archive is not available
  ([11786](https://github.com/civicrm/civicrm-core/pull/11786))**

  The Archive storage engine is not always available in MariaDB, even though it
  is the default for log tables when detailed logging is enabled.  Now, CiviCRM
  will fall back to InnoDB if Archive is not available.

- **[CRM-21753](https://issues.civicrm.org/jira/browse/CRM-21753) Support
  'criteria' in url on batch merge form
  ([11666](https://github.com/civicrm/civicrm-core/pull/11666)) (completes prior
  work)**

  This improves handling of criteria set in the URL for batch merges.

- **[CRM-20811](https://issues.civicrm.org/jira/browse/CRM-20811) Schedule
  Reminders uses mixed terminology for Active state: Active? versus Send Email
  ([10602](https://github.com/civicrm/civicrm-core/pull/10602))**

  The option for whether a scheduled reminder is active is now displayed as a
  checkbox with "Scheduled Reminder Active" rather than "Send Email" or "Send
  email or SMS".

- **CRM_Utils_Check - Soften messages for read-only extensionsDir
  ([11895](https://github.com/civicrm/civicrm-core/pull/11895))**

  When a site's extensions directory is not writable by the web server, the
  system check message now has a lower severity and explains the consequences
  rather than indicating that this is definitely a problem.

- **Meld Address custom field display template with main custom field template
  ([11844](https://github.com/civicrm/civicrm-core/pull/11844))**

  The display for address custom fields now uses the main custom field template.

- **[CRM-21784](https://issues.civicrm.org/jira/browse/CRM-21784) View custom
  data for recurring contributions
  ([11697](https://github.com/civicrm/civicrm-core/pull/11697))**

  This resolves a problem where custom data could be set for recurring
  contributions but could not be viewed outside of the API.

### CiviContribute

- **[CRM-20610](https://issues.civicrm.org/jira/browse/CRM-20610) Replace
  payment details block with editable payment list on 'Edit Contribution' form
  ([10776](https://github.com/civicrm/civicrm-core/pull/10776))**

  The backend contribution edit form is now based on the same payment editing
  interface as events with multiple payments.

- **Tweak layout on contribution view screen to make payments clearer
  ([11863](https://github.com/civicrm/civicrm-core/pull/11863))**

  When viewing a contribution on the back end, a table of payments now displays
  immediately below the total amount.

### CiviMail

- **[CRM-20719](https://issues.civicrm.org/jira/browse/CRM-20719) Show warning
  on system status page if reply_id for mailing is not set to any default.
  ([10496](https://github.com/civicrm/civicrm-core/pull/10496))**

  This warns users if no auto-reply message is selected as default, as this will
  prevent CiviMail messages from being submitted.

### Drupal Integration

- **Add activity created_date, modified_date and original_id fields to views
  ([525](https://github.com/civicrm/civicrm-drupal/pull/525))**

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#83](https://lab.civicrm.org/dev/core/issues/83) Fix regression
  whereby relationship types option no longer in adv search
  ([12045](https://github.com/civicrm/civicrm-core/pull/12045))**

- **Flush versionCheck cache when upgrading
  ([12034](https://github.com/civicrm/civicrm-core/pull/12034))**

  A recently-upgraded site will no longer potentially have a cached message
  indicating that an upgrade is needed.

- **[dev/core#64](https://lab.civicrm.org/dev/core/issues/64) - In custom
  searches, column headings are being ignored
  ([12005](https://github.com/civicrm/civicrm-core/pull/12005))**

  This resolves a regression that displayed standard column headings on results
  of custom searches.

- **Fix trigger generation for modified_date on custom data
  ([11984](https://github.com/civicrm/civicrm-core/pull/11984))**

- **Phone: standardize appearance and translation of extension label
  ([11930](https://github.com/civicrm/civicrm-core/pull/11930))**

- **[dev/core#16](https://lab.civicrm.org/dev/core/issues/16) Select "Enable
  multiple bulk email address for a contact", "hold_date" can not be updated
  ([11807](https://github.com/civicrm/civicrm-core/pull/11807) and
  [11884](https://github.com/civicrm/civicrm-core/pull/11884))**

- **Handle eq (equals) operator in the report url
  ([11885](https://github.com/civicrm/civicrm-core/pull/11885))**

  When setting report filters via the URL, the `eq` operator now works like the
  others.  It didn't work in past versions.

- **Fix report form isTableSelected to treat relative date filters as filters
  ([11882](https://github.com/civicrm/civicrm-core/pull/11882))**

- **[CRM-21842](https://issues.civicrm.org/jira/browse/CRM-21842) broken link
  ([11879](https://github.com/civicrm/civicrm-core/pull/11879))**

  Links to the "Installation and basic set-up" documentation page had errors.

- **[dev/core#22](https://lab.civicrm.org/dev/core/issues/22) Unable to delete
  Smart Group ([11826](https://github.com/civicrm/civicrm-core/pull/11826))**

  This resolves a fatal error that would appear when attempting to delete a
  broken smart group.

- **Fix template structures
  ([11818](https://github.com/civicrm/civicrm-core/pull/11818),
  [11839](https://github.com/civicrm/civicrm-core/pull/11839),
  [11851](https://github.com/civicrm/civicrm-core/pull/11851),
  [11862](https://github.com/civicrm/civicrm-core/pull/11862), and
  [11869](https://github.com/civicrm/civicrm-core/pull/11869))**

  This standardizes a number of page templates that didn't match the typical
  structure.

- **Fix ajax error on rendering multi custom data tab when field limit reached
  ([11856](https://github.com/civicrm/civicrm-core/pull/11856))**

- **Escape custom group title.
  ([11854](https://github.com/civicrm/civicrm-core/pull/11854))**

  This fixes a bug causing the display of multi-entry custom data sets when the
  set's title has an apostrophe in it.

- **[CRM-20790](https://issues.civicrm.org/jira/browse/CRM-20790) Import
  Contacts, Current Employer (Employee of field) is not being imported at all
  ([11843](https://github.com/civicrm/civicrm-core/pull/11843)) (completes prior
  work)**

  Unit tests now ensure relationships are added on import.

- **[dev/core#17](https://lab.civicrm.org/dev/core/issues/17) Convert Campaign
  Interview Task to use Pseudoconstant and remove PHP notices
  ([11809](https://github.com/civicrm/civicrm-core/pull/11809))**

  This replaces use of the deprecated `CRM_Core_OptionGroup::getValue()` with
  `CRM_Core_PseudoConstant::getKey()` and fixes PHP notices.

- **[CRM-21838](https://issues.civicrm.org/jira/browse/CRM-21838) When CRM.alert
  falls back to standard JS alert it should strip html
  ([11797](https://github.com/civicrm/civicrm-core/pull/11797))**

### CiviContribute

- **[CRM-21763](https://issues.civicrm.org/jira/browse/CRM-21763) Cannot record
  payment for only cents owed
  ([11668](https://github.com/civicrm/civicrm-core/pull/11668))**

  This resolves a bug where the sum of payments would be fractions of a cent off
  from the total amount due.  A new utility subtracts currency amounts using the
  correct number of decimals for that currency.

- **[CRM-21791](https://issues.civicrm.org/jira/browse/CRM-21791) Accounting
  batch closed by default when created in localized civicrm
  ([11878](https://github.com/civicrm/civicrm-core/pull/11878))**

  If an accounting batch is created in a site with a language other than US
  English, a bug caused the batch to start out closed.

- **[dev/core#26](https://lab.civicrm.org/dev/core/issues/26) On behalf form
  fails to create new organisation
  ([11841](https://github.com/civicrm/civicrm-core/pull/11841))**

- **[CRM-21807](https://issues.civicrm.org/jira/browse/CRM-21807) Deleted
  contacts included by default in Membership and contribution detail report.
  ([11727](https://github.com/civicrm/civicrm-core/pull/11727))**

- **[CRM-21264](https://issues.civicrm.org/jira/browse/CRM-21264) print
  contribution in tabular format with group by contact not working
  ([11820](https://github.com/civicrm/civicrm-core/pull/11820))**

### CiviEvent

- **Fix fatal error when selecting a $0 price option in change fee selection
  ([11934](https://github.com/civicrm/civicrm-core/pull/11934))**

### CiviMail

- **[dev/mail#8](https://lab.civicrm.org/dev/mail/issues/8) Using ACL to
  restrict mailing recipients leads to fatal error
  ([11963](https://github.com/civicrm/civicrm-core/pull/11963))**

- **[dev/core#25](https://lab.civicrm.org/dev/core/issues/25) Wrap split_jobs in
  a transaction ([11836](https://github.com/civicrm/civicrm-core/pull/11836))**

  The process of splitting mail jobs is now a database transaction, preventing
  other processes from potentially processing child jobs before it is finished.

### CiviMember

- **[CRM-21711](https://issues.civicrm.org/jira/browse/CRM-21711) When updating
  multiple memberships thru a contribution page custom fields are only updated
  on one ([11586](https://github.com/civicrm/civicrm-core/pull/11586))**

- **[CRM-19151](https://issues.civicrm.org/jira/browse/CRM-19151) Add / fix the
  Ability to merge memberships
  ([11298](https://github.com/civicrm/civicrm-core/pull/11298)) (initial work)**

  When merging contacts that each have memberships, one membership and all its
  data will be deleted unless you check the Add New box.  Now, the surviving
  membership is updated to have the earliest Join Date and latest End Date of
  the two, and the Membership Status is recalculated.

- **[CRM-19850](https://issues.civicrm.org/jira/browse/CRM-19850) Add a offline
  membership without 'record payment' option, later edit the membership and
  saving with 'record payment' option
  ([11087](https://github.com/civicrm/civicrm-core/pull/11087))**

  This resolves an error that failed to show the payment information when
  editing an unpaid membership and checking the "Record Payment" box.

- **[dev/core#15](https://lab.civicrm.org/dev/core/issues/15) Wrong parameter
  passing in LineItem.php
  ([11816](https://github.com/civicrm/civicrm-core/pull/11816))**

  This addresses an intermittent bug where membership line items would refer to
  the wrong contribution.

- **[CRM-21682](https://issues.civicrm.org/jira/browse/CRM-21682) Automatic
  membership renewal fixes
  ([11824](https://github.com/civicrm/civicrm-core/pull/11824) and
  [11825](https://github.com/civicrm/civicrm-core/pull/11825))**

- **“Deceased” status could be translated
  ([11890](https://github.com/civicrm/civicrm-core/pull/11890))**

  The membership status update job would look for the status labeled "Deceased",
  which may be translated.

### Drupal Integration

- **[dev/core#83](https://lab.civicrm.org/dev/core/issues/18) Log tables for
  CiviCRM Drupal Modules can cause WSODs after running upgrades when
  re-calculating ([11865](https://github.com/civicrm/civicrm-core/pull/11865))**

### Joomla Integration

- **[CRM-21348](https://issues.civicrm.org/jira/browse/CRM-21348) Don't hide the
  "edit" link from logged-in users in profile listings in joomla front-end.
  ([11199](https://github.com/civicrm/civicrm-core/pull/11199))**

- **[CRM-21203](https://issues.civicrm.org/jira/browse/CRM-21203) cli.php PHP
  error prevents cron jobs from running
  ([11609](https://github.com/civicrm/civicrm-core/pull/11609)) (completes prior
  work)**

### WordPress Integration

- **[CRM-21277](https://issues.civicrm.org/jira/browse/CRM-21277)
  CRM_Utils_System_WordPress::validInstallDir spams log with warnings when
  open_basedir restriction is in effect
  ([11086](https://github.com/civicrm/civicrm-core/pull/11086))**

## <a name="misc"></a>Miscellany

- **Increment minimum upgradable version
  ([11864](https://github.com/civicrm/civicrm-core/pull/11864))**

  New versions of CiviCRM no longer contain code facilitating a direct upgrade
  from versions before 4.1.3.  Older sites attempting to upgrade should upgrade
  to one or more intermediate versions before upgrading to 5.1.0.

- **(NFC) make (includes taxes) translation work
  ([11927](https://github.com/civicrm/civicrm-core/pull/11927))**

- **Extract fetchRelationshipDetails function
  ([11918](https://github.com/civicrm/civicrm-core/pull/11918))**

- **NFC Minor comments cleanup on MembershipType
  ([11909](https://github.com/civicrm/civicrm-core/pull/11909))**

- **Remove cloning hack from export and add unit tests
  ([11703](https://github.com/civicrm/civicrm-core/pull/11703))**

- **NFC Fix function name typo
  ([11888](https://github.com/civicrm/civicrm-core/pull/11888))**

- **[NFC] Fix mispelled variable and simplify a couple of other vars
  ([11886](https://github.com/civicrm/civicrm-core/pull/11886))**

- **[NFC] remove unused vars
  ([11874](https://github.com/civicrm/civicrm-core/pull/11874))**

- **CiviUnitTestCase - Extract Api3TestTrait and Api3DocTrait
  ([11872](https://github.com/civicrm/civicrm-core/pull/11872))**

- **Consolidate CustomData code into shared tpl
  ([11857](https://github.com/civicrm/civicrm-core/pull/11857))**

- **[nfc] Add test for thousand separators on import
  ([11859](https://github.com/civicrm/civicrm-core/pull/11859))**

- **[nfc] Minor test tidy ups
  ([11860](https://github.com/civicrm/civicrm-core/pull/11860))**

- **[NFC] fix line endings, using windows line endings, change to 'unix
  ([11858](https://github.com/civicrm/civicrm-core/pull/11858))**

- **NFC reformat whitespace in Email.tpl files
  ([11842](https://github.com/civicrm/civicrm-core/pull/11842))**

- **Version check test: in alphas don't test for site stats not provided for
  alphas ([11831](https://github.com/civicrm/civicrm-core/pull/11831))**

- **Fix style warnings
  ([526](https://github.com/civicrm/civicrm-drupal/pull/526))**

- **add GitHub PR template and Contributing templates to WP repo
  ([127](https://github.com/civicrm/civicrm-wordpress/pull/127))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt, Eli Lisseck; Agileware - Agileware
Team, Alok Patel, Francis Whittle, Justin Freeman; Andrew Thompson; Australian
Greens - Seamus Lee; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha
Chaku; CompuCorp - Michael Devery, Mukesh Ram; Coop SymbioTIC - Samuel Vanhove;
Davis Media Access - Darrick Servis; Fuzion - Jitendra Purohit; JMA Consulting -
Monish Deb; Joinery - Allen Shaw; Kompetenzzentrum
Technik-Diversity-Chancengleichheit - Niels Heinemann; Left Join Labs - Sean
Madsen; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew
Wire; Naomi Rosenberg; Olivier Tétard; Oxfam Germany - Yuliyana Liyana; Tadpole
Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Ben Jarlett; British Humanist Association - Andrew West; Chris Burgess;
Christian Wach; CiviDesk - Sunil Pawar; Community Builders - Andrew Perry;
CompuCorp - Jamie Novick; Coop SymbioTIC - Mathieu Lutfy; David Hepper; DevApp -
Adam Kwiatkowski; Donald Hirst; Francesc Bassas i Bullich; Fuzion - Peter Davis;
Ginkgo Street Labs - Frank Gómez; JMA Consulting - Monish Deb; Johan Vervloet;
John Kingsnorth; Korlon - Stuart Gaston; Lemniscus - Noah Miller; Lighthouse
Design and Consulting - Brian Shaughnessy; Lorenzo Ardizzone; Lyons Digital
Media - Barbara Forbes-Lyons; Marcello Gribaudo; National Democratic Institute -
Evan Summers; Neil Zampella; Nicol Wistreich; Pratik Joshi; Progressive
Technology Project - Jamie McClelland; Responsive Development Technologies -
Thomas Nilefalk; Richard Edgar; SEN Magazine - Jeremy Nicholls; Skvare - Mark
Hanna; small biz

## <a name="feedback"></a>Feedback

These release notes are edited by Andie Hunt.  If you'd like to provide
feedback on them, please login to https://chat.civicrm.org/civicrm and contact
`@agh1`.
