# CiviCRM 5.5.0

Released September 5, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

#### Api4 Extension now included
The [Api v4 extension](https://github.com/civicrm/org.civicrm.api4) is now included in the CiviCRM download.
It provides the latest version of CiviCRM's api for integration with extensions and other software; is is still under active development but considered complete enough to use.
Because it is not yet used by CiviCRM core, it is disabled by default.
If you install an extension which requires this api, it will be enabled automatically. 

## <a name="features"></a>Features

### Core CiviCRM

- **Further fix for updating custom fields linked to optiongroups.
  ([12729](https://github.com/civicrm/civicrm-core/pull/12729))**

  When a user editing a custom field that uses an option group, you may now
  switch to any non-reserved option groups.

- **Further Fix for updating custom field when not linked to an option group.
 ([12789](https://github.com/civicrm/civicrm-core/pull/12789))**

  Further following fix from 12729 to ensure that the Edit Custom Field form works when
  not linked to an option group.

- **Upgrader - When updating message templates, identify them by name
  ([12674](https://github.com/civicrm/civicrm-core/pull/12674))**

  On the Upgrade screen, when a change has been made to a message template, this
  change makes it so that the name of the message template is included in the
  message displayed.

- **Refine upgrade message for `save Report Criteria`
  ([12670](https://github.com/civicrm/civicrm-core/pull/12670))**

  This change alters the update message for "save Report Criteria" to be more
  readable and concise.

- **[dev/core#217](https://lab.civicrm.org/dev/core/issues/217) Allow
  replacement of PrevNextCache implementation (for search screens)
  ([12558](https://github.com/civicrm/civicrm-core/pull/12558),
  [12556](https://github.com/civicrm/civicrm-core/pull/12556),
  [12543](https://github.com/civicrm/civicrm-core/pull/12543),
  [12544](https://github.com/civicrm/civicrm-core/pull/12544),
  [12545](https://github.com/civicrm/civicrm-core/pull/12545),
  [12528](https://github.com/civicrm/civicrm-core/pull/12528),
  [12438](https://github.com/civicrm/civicrm-core/pull/12438)) (preliminary
  work)**

  Preliminary work to allow contact searches to retain their results via
  Redis/Memcache (instead of MySQL).

- **Export - add tests out header output, move phone_type_id to metadata
  ([12587](https://github.com/civicrm/civicrm-core/pull/12587))**

  This change makes it so one can export phone_type_id.

- **api - CustomValue::get - add handling for comma separated return fields
  ([12604](https://github.com/civicrm/civicrm-core/pull/12604))**

  This change makes it so twhen using the CustomValue get api accepts comma
  separated return fields.

- **[dev/core#291](https://lab.civicrm.org/dev/core/issues/291) Allow password
  field sizes to be set in props a la text fields
  ([12589](https://github.com/civicrm/civicrm-core/pull/12589))**

  This change makes it so password fields can be any size. Prior to this change
  password fields were all the same size.

- **Entity form : Establish methodology to allow default values to be passed in
  on the url ([12185](https://github.com/civicrm/civicrm-core/pull/12185))**

  This change makes it so that some values can be passed thru the url for more
  information see: [dev/core#115](https://lab.civicrm.org/dev/core/issues/115).

- **[dev/core#244](https://lab.civicrm.org/dev/core/issues/244) Allow use of
  custom fields of type select without specifying an optiongroup
  ([12440](https://github.com/civicrm/civicrm-core/pull/12440))**

  This change makes it so one can dynamically populate a custom field of type
  select using hooks without using an optiongroup.

- **Reduce config required to use Redis.
  ([12546](https://github.com/civicrm/civicrm-core/pull/12546))**

  This change makes it so if using Redis, Sysadmins only have to specify the port
  if not using the standard port 6379.

- **Update navigation menu items to use FontAwesome
  ([12541](https://github.com/civicrm/civicrm-core/pull/12541) and
  [223](https://github.com/civicrm/civicrm-packages/pull/223))**

  Updates the menu "caret" (triangles) to use FontAwesome instead of
  an image file. This is a performance improvement.

- **Link to option group page from option group menu item
  ([12540](https://github.com/civicrm/civicrm-core/pull/12540))**

  This change adds a link to the option group page from the option group menu
  item to make it easier to access the "Option Groups" page.

- **[dev/core#259](https://lab.civicrm.org/dev/core/issues/259) OptionGroup
  Admin UI workflow improvements
  ([12473](https://github.com/civicrm/civicrm-core/pull/12473))**

  This change improves the Option Group Administration workflow by adding
  options to edit group settings, displaying a Reserved column on the option
  group settings, not allowing users to change the data type on reserved option
  groups, when a user edits an option group redirecting them to the option
  groups list instead of the default admin page.

- **Icons in colored boxes for relationship permissions
  ([12526](https://github.com/civicrm/civicrm-core/pull/12526))**

  This change makes it so that on the Relationship tab for a contact permissioned
  relationships are denoted by icons in squares. Specifically, view permissions
  appear as a green box with an eye icon and edit permissions as a blue box with
  a pencil icon. Before this change relationship permissions were denoted with
  an asterisk and view permissions with an eye icon.

- **[dev/accessibility#3](https://lab.civicrm.org/dev/accessibility/issues/3)
  Add aria-label (and label?) to form elements missing them
  ([12207](https://github.com/civicrm/civicrm-core/pull/12207) and
  [12373](https://github.com/civicrm/civicrm-core/pull/12373)) (preliminary work)**

  Advances work to to use accessible labels on all pages/forms specifically on
  the Contribution form and the Contact Edit Form.

- **[dev/core#233](https://lab.civicrm.org/dev/core/issues/233) Expose
  information about where a contact has been merged to
  ([12489](https://github.com/civicrm/civicrm-core/pull/12489))**

  This change makes it so that if a contact has been merged and is still in the
  trash next to the contacts name is text explaining which ontact the contact
  has been merged to. Additionally this change makes it so one can access
  information on where a contact was merged from/to via the api.

- **[dev/core#34](https://lab.civicrm.org/dev/core/issues/34) Split edit/view
  access on permissioned relationships
  ([12487](https://github.com/civicrm/civicrm-core/pull/12487) and
  [12415](https://github.com/civicrm/civicrm-core/pull/12415))**

  This change makes it so that permissioned relationships can be view only,
  before this change permissioned relationships were view AND edit. Now one can
  permission a relationship as view only or view and edit. This change also adds
  a title to the icon tags that specify if a user has view or edit
  permissions.

- **BAO_Navigation: Respect domain_id param
  ([12476](https://github.com/civicrm/civicrm-core/pull/12476))**

  This change makes it so that when creating or updating a navigation menu item
  one can set the domain_id.

- **[dev/core#93](https://lab.civicrm.org/dev/core/issues/93) Update
  CRM_Utils_Rule::mysqlOrderBy() to accommodate more than 2 joins
  ([12456](https://github.com/civicrm/civicrm-core/pull/12456))**

  This change makes it so that API users can do more than two joins.

- **[dev/core#176](https://lab.civicrm.org/dev/core/issues/176) Odd / Even
  street number sort column missing from Reports
  ([12422](https://github.com/civicrm/civicrm-core/pull/12422))**

  This change adds a Odd/Even street number sort column to reports.

### CiviContribute

- **[dev/core#219](https://lab.civicrm.org/dev/core/issues/219)
  Improve consistency displaying "Test Transactions"
  ([12385](https://github.com/civicrm/civicrm-core/pull/12385))**

  This change makes it so that when you are viewing a test membership help text
  appears at the top stating that the membership is a test.

- **Expose UI support for custom fields on financial types
  ([12501](https://github.com/civicrm/civicrm-core/pull/12501))**

  This change makes a user interface for custom fields on financial types.

- **[dev/financial#28](https://lab.civicrm.org/dev/financial/issues/28)
  Financial Account cannot be change to non deductible
  ([12500](https://github.com/civicrm/civicrm-core/pull/12500))**

  This change makes it so that a Financial Account can be changed from
  deductible to non-deductible.

- **[dev/core#241](https://lab.civicrm.org/dev/core/issues/241) Fix Manage
  Premiums UI ([12436](https://github.com/civicrm/civicrm-core/pull/12436))**

  This change makes it so that on the Manage Premiums Form Financial Type is
  displayed properly, Money is formatted properly and the Cost field is
  displayed.

### CiviMail

- **[CRM-21768](https://issues.civicrm.org/jira/browse/CRM-21768) NOFOLLOW
  Trackable links in public online view of mailings
  ([12561](https://github.com/civicrm/civicrm-core/pull/12561))**

  This change adds the nofollow tag to the trackable URLs in the public view of
  mailings to prevent the links from being indexed by google.

- **[CRM-21574](https://issues.civicrm.org/jira/browse/CRM-21574) Allow to
  disable sending of email from source contact for tell a friend on pcp
  ([12475](https://github.com/civicrm/civicrm-core/pull/12475))**

  When sending an email using the "Tell a Friend" functionality for personal
  campaign pages this change makes it so you can choose whether the email should
  come from the default email for the organization OR the contact IDs email
  address. Before this change the emails would always go out from the contact
  which can break SPF/DMARC and lead to bounced/failed email delivery.  

- **[CRM-20845](https://issues.civicrm.org/jira/browse/CRM-20845) create
  alterMailingRecipients hook
  ([10673](https://github.com/civicrm/civicrm-core/pull/10673))**

  This change creates a hook to alter the mailing recipients after they have
  been constructed but before the mailing is sent.

- **[CRM-21425](https://issues.civicrm.org/jira/browse/CRM-21425) Make 'Inbound
  E-mail' Activities Editable
  ([12445](https://github.com/civicrm/civicrm-core/pull/12445))**

  Before this change no one had permission to edit activities of type "Inbound
  Email", this change adds two new permissions 'edit inbound email basic
  information' and 'edit inbound email basic information and content' users with
  these permissions can edit activities of type "Inbound Email".

### CiviMember

- **[dev/core#111](https://lab.civicrm.org/dev/core/issues/111) Support Custom
  Data for MembershipType entity
  ([12439](https://github.com/civicrm/civicrm-core/pull/12439))**

  This change makes it so that one can view/edit custom data on the
  MembershipType form.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[infrastructure/ops#842](https://lab.civicrm.org/infrastructure/ops/issues/842)
  RSS feed and Getting Started are not displaying in dashlets
  ([12756](https://github.com/civicrm/civicrm-core/pull/12756))**

- **[dev/core#353](https://lab.civicrm.org/dev/core/issues/353) As of 5.4.0,
  Activity Search gives an empty result set
  ([12742](https://github.com/civicrm/civicrm-core/pull/12742))**

- **Fix for issue editing custom fields with option groups after #12423
  ([12718](https://github.com/civicrm/civicrm-core/pull/12718))**

  This change fixes a bug where one could not save changes to a custom field
  that uses option groups so that one can save changes to a custom field with
  option groups.

- **Update civicrm_generated mysql file following changes to custom mysql…
  ([12719](https://github.com/civicrm/civicrm-core/pull/12719))**

  This change ensures that some default custom groups are not reserved.

- **[dev/core#293](https://lab.civicrm.org/dev/core/issues/293) Error log is
  filled with geocoding configuration errors when no provider is set
  ([12600](https://github.com/civicrm/civicrm-core/pull/12600))**

  This change fixes a bug where if no geocoding provider is set on a site an
  error was thrown to the error log so that no error is thrown.

- **[dev/core#232](https://lab.civicrm.org/dev/core/issues/232) Contact types
  with double hyphens in 'name' field : searches not returning any contactsh
  ([12416](https://github.com/civicrm/civicrm-core/pull/12416))**

  This change fixes a bug where when searching for contacts using a contact sub type
  no results were returned so that contacts of that sub type are returned.

- **[dev/core#210](https://lab.civicrm.org/dev/core/issues/210) Regex filter
  broken in Search Builder
  ([12364](https://github.com/civicrm/civicrm-core/pull/12364))**

  This change fixes the Regex filter in the Search Builder so that it returns
  more accurate results.

- **Theme layer Fix search for Shoreditch compatibility
  ([12536](https://github.com/civicrm/civicrm-core/pull/12536))**

  This change fixes the ui on the search page to show the table headers for
  sites using the shoreditch theme.

- **Shoreditch support: Fix following change in core that resulted in visual
  regression in shoreditch in advanced search
  ([12524](https://github.com/civicrm/civicrm-core/pull/12524))**

  This change improves the layout of the advanced search page for users using
  Shoreditch.

- **[dev/core#150](https://lab.civicrm.org/dev/core/issues/150) Chain select for
  country/state in Search Builder does not stay within OR groupings
  ([12230](https://github.com/civicrm/civicrm-core/pull/12230))**

  This change fixes a bug in search builder where if one Choose a Country in the
  "Include contacts where" section that would also filter the available state
  options in the "Also include contacts where" section.

- **[dev/core#230](https://lab.civicrm.org/dev/core/issues/230) Saved Search :
  Set Mapping id to null on mapping delete
  ([12486](https://github.com/civicrm/civicrm-core/pull/12486))**

  This change fixes a db error when deleting a saved search so that one can
  delete a saved search without getting a database error.

- **Fix false negatives in checkResourceUrl()
  ([12460](https://github.com/civicrm/civicrm-core/pull/12460))**

  This change fixes a bug where an "The Resource URL is not set correctly.
  Please set the CiviCRM Resource URL." error was being thrown when the CiviCRM
  Resource URL  was set to "[civicrm.root]/"  so that no error is thrown when
  the CiviCRM Resource URL is set.

- **Fix activity report to bring it under standardised report testing
  ([12453](https://github.com/civicrm/civicrm-core/pull/12453))**

  This change makes it possible to write unit tests for the Activity Report.

- **[dev/core#155](https://lab.civicrm.org/dev/core/issues/155) Improvements and
  bugfixes to Option Groups UI
  ([12423](https://github.com/civicrm/civicrm-core/pull/12423)) (preliminary work)**

  This change makes it so that Option Groups that are created thru the user
  interface can be used with custom fields.

- **Disable inline-edit of multi-record custom fields in profiles
  ([12312](https://github.com/civicrm/civicrm-core/pull/12312))**

  This change makes it so that one cannot inline-edit multi-record custom fields
  in profiles. Before this change there was a button to edit but clicking it
  would throw a javascript error.

- **Make domain_id optional in membership_type api.
  ([12461](https://github.com/civicrm/civicrm-core/pull/12461))**

  This change makes the domain_id a optional parameter in the membership_type
  api, if it is not sent it is set to be the current domain.

- **[dev/core#141](https://lab.civicrm.org/dev/core/issues/141) Custom groups
  with different names but same title would not be saved
  ([12464](https://github.com/civicrm/civicrm-core/pull/12464))**

  This change makes it so you can have custom groups with the same title so long
  as they have different names.

- **CustomValue gettree api - More accurate permission check
  ([12449](https://github.com/civicrm/civicrm-core/pull/12449))**

  This change makes it so that a user can call the gettree api from ajax if they
  have the permission to view the main object. Prior to this change the user had
  to have the permission 'administer CiviCRM' to access the gettree api from
  ajax.

- **[dev/core#221](https://lab.civicrm.org/dev/core/issues/221) Inappropriate
  warning on preview page of empty custom data set
  ([12392](https://github.com/civicrm/civicrm-core/pull/12392))**

  Removes an Undefined Offset error being thrown when a new custom data set is
  created and then previewed.

- **[dev/core#228](https://lab.civicrm.org/dev/core/issues/228) Option group
  disabled on update
  ([12410](https://github.com/civicrm/civicrm-core/pull/12410))**

  Fixes a bug where Option Groups being being created or updated thru the api
  without the is_active parameter set were being set as not active.

- **Implement CRM_Utils_SQL_Delete
  ([12441](https://github.com/civicrm/civicrm-core/pull/12441))**

  This change makes CRM_Utils_SQL_Delete a query-building utility and has it
  extend a common base-class as CRM_Utils_SQL_Select.

- **[dev/core#174](https://lab.civicrm.org/dev/core/issues/174) Consistently use
  swappable cache interfaces
  ([12427](https://github.com/civicrm/civicrm-core/pull/12427)) (preliminary
  work)**

  This patch makes tests more reliable by refining the way SqlGroup handles
  trivially short TTLs.

- **[dev/core#212](https://lab.civicrm.org/dev/core/issues/212) Contribution
  Details report fails when "Is not one of" condition is used for Groups field
  ([12406](https://github.com/civicrm/civicrm-core/pull/12406))**

  Fixes a DB error when contribution detail report is filtered by the "is not
  one of" Group operator.

- **[dev/core#292](https://lab.civicrm.org/dev/core/issues/292) Search builder
  stops working after 5.3.1 (due accents on custom set fields titles)
  ([225](https://github.com/civicrm/civicrm-packages/pull/225))**

  Fixes a bug where search builder would choke on accented characters in custom
  set field titles so that Search builder can handle accented characters in
  custom set field titles.

- **[CRM-21754](https://issues.civicrm.org/jira/browse/CRM-21754) Duplicate
  rows in Activity Details report when address fields are displayed
  ([11660](https://github.com/civicrm/civicrm-core/pull/11660))**

  Fixes a bug where the Activity Details report would show duplicate rows when
  activity contacts had different addresses so that only one row is shown per
  Activity.

- **[dev/core#326] (https://lab.civicrm.org/dev/core/issues/326) Fatal Error in Section Headers
of Contribution Detail report
([12766](https://github.com/civicrm/civicrm-core/pull/12766))**

  Fixes a DB fatail error when running the contribution detail report and selectng contact name as a
  section header for the report.

### CiviCase

- **[dev/core#289](https://lab.civicrm.org/dev/core/issues/289) CiviCase
  Dashboard link to edit an activity status broken
  ([12607](https://github.com/civicrm/civicrm-core/pull/12607))**

  This change fixes a bug on the CiviCase dashboard where when a user clicked
  the pencil to edit an activity CiviCRM would throw a 'required params missing'
  error and crash so that one can edit a case from the CiviCase dashboard by
  clicking the pencil.

- **[dev/core#278](https://lab.civicrm.org/dev/core/issues/278) DB syntax error
  when try to search deleted cases
  ([12560](https://github.com/civicrm/civicrm-core/pull/12560))**

  This change fixes a DB syntax error that was being thrown whens searching
  deleted cases.

- **[dev/core#218](https://lab.civicrm.org/dev/core/issues/218) On Case Type
  listing page, for reserved ones the, 'More' link don't show any options
  ([12384](https://github.com/civicrm/civicrm-core/pull/12384))**

  Fixes a bug where on the Case Types Listing page the 'More' link would not
  show any options for reserved case types.

### CiviContribute

- **[dev/core#325](https://lab.civicrm.org/dev/core/issues/325) and
  [dev/core#327](https://lab.civicrm.org/dev/core/issues/327) Fatal errors 'DB
  Error: no such field' and 'Call to undefined method' on Contribution detail
  report ([12763](https://github.com/civicrm/civicrm-core/pull/12763))**

- **[CRM-21104](https://issues.civicrm.org/jira/browse/CRM-21104) CiviCRM
  Contribution pages which have no Profile associated with them do not include a
  ReCaptcha and as a result are prime targets for credit card fraud.
  ([11197](https://github.com/civicrm/civicrm-core/pull/11197))**

  This change makes it so that ReCaptcha is shown on all Contribution pages that
  use a payment processor to process online payments. Before this change
  ReCaptcha only was shown on contribution pages that used profiles.

- **[dev/core#277](https://lab.civicrm.org/dev/core/issues/277) Recurring
  contribution tab shouldn't count test transactions
  ([12610](https://github.com/civicrm/civicrm-core/pull/12610) and
  [12553](https://github.com/civicrm/civicrm-core/pull/12553))**

  This change makes it so that the Recurring Contributions tab count only counts
  the 'Active Recurring Contributions' (does not count 'Inactive Recurring
  Contributions') and sorts the Recurring Contributions by start date starting
  with the newest.

- **[dev/core#242](https://lab.civicrm.org/dev/core/issues/242) Fix display of
  premiums on contribution pages
  ([12437](https://github.com/civicrm/civicrm-core/pull/12437))**

  This change fixes a bug where premium products without financial types
  were not being displayed on contribution pages so that premium products are displayed on
  contribution pages regardless of whether they have a financial type.

- **[dev/financial#27](https://lab.civicrm.org/dev/financial/issues/27) Paypal
  recurring IPNs don't work under some circumstances
  ([12387](https://github.com/civicrm/civicrm-core/pull/12387))**

  This change fixes a bug where IPNs for recurring donations made using PayPal
  Standard did not work if the business emails did not match.

- **[dev/core#188](https://lab.civicrm.org/dev/core/issues/188) Fix Floating
  Point Precision Comparison Exception on Order Creation
  ([12352](https://github.com/civicrm/civicrm-core/pull/12352))**

  This change fixes a bug where sometimes contributions would fail because the
  total amount and the total of the line items would not be exactly equal
  because of floating point precision issues.

- **PriceField: show pre/post help if not empty, not if isset.
  ([12458](https://github.com/civicrm/civicrm-core/pull/12458))**

  Fixes a bug for multilingual mode where radio options in price sets with empty
  pre/post help were displaying pre/post help as ':' so that no ':' are shown.

- **[dev/core#346](https://lab.civicrm.org/dev/core/issues/346) Fix Online Pay Now links when used from Dashboard.
 ([12777](https://github.com/civicrm/civicrm-core/pull/12777))**

  This fixes an issue with the Online Paynow link when the dashboard is access by an annonmyous user using a checksum link.

### CiviEvent

- **Fix + Add test for exporting location types with changed names
  ([12671](https://github.com/civicrm/civicrm-core/pull/12671))**

  This change fixes a bug where if a location types name did not exactly match
  its value it was not exporting properly so that the label exports properly.

- **Event Info: show waitinglist statusline only when registration is open
  ([11949](https://github.com/civicrm/civicrm-core/pull/11949))**

  This change makes it so when on an Event Info page, if the event is closed, no
  other notices about registration are shown.

- **[dev/core#255](https://lab.civicrm.org/dev/core/issues/255) Changes to
  copied event location reflects in original event location
  ([12459](https://github.com/civicrm/civicrm-core/pull/12459))**

  Fixes a bug where if one copied an event and then changed the location, the
  location would also be changed on the original event so that one can change
  the event on the copy without it having an effect on the original.

- **[dev/core#239](https://lab.civicrm.org/dev/core/issues/239) Huge title
  dialog box on hovering form element on Event's configuration backend form
  ([12430](https://github.com/civicrm/civicrm-core/pull/12430))**

  This change improves the user interface on the Event Configuration Form by
  making the dialog boxes when hovering on form elements cleaner.

### CiviMail

  This change fixes a bug where DoNotSms preference was not being respected when
  sending Mass Sms messages.

- **[dev/core#256](https://lab.civicrm.org/dev/core/issues/256) - Wrong A/B test
  recipient assignment when reaching 2^31 recipients overall
  ([12465](https://github.com/civicrm/civicrm-core/pull/12465))**

  This change fixes a bug where when submitting an A/B mailing to a big enough
  group (2^31) the whole target group would receive Version A, so that 50% of
  the sample group receives version A, the other half version B, and the rest is
  assigned to Final mailing.

- **CiviMail: Fix logic for handling SMTP socket errors, temporary failures and
  permanent failures
  ([11838](https://github.com/civicrm/civicrm-core/pull/11838))**

  Fixes support for sending mail directly to AWS SES via SMTP by detecting
  additional temporary failure modes.

- **[dev/mail#15](https://lab.civicrm.org/dev/mail/issues/15) Extraneous space
  in From address causes on-hold set on all recipients
  ([12346](https://github.com/civicrm/civicrm-core/pull/12346))**

  This change fixes a bug where if there were extraneous spaces in the From
  address for a CiviMail mailing then no emails were sent and all recipients
  were marked as On-Hold so that the extraneous space is stripped out and the
  mailing goes out successfully.

### CiviMember

- **[dev/core#368](https://lab.civicrm.org/dev/core/issues/368) Scheduled
  Reminder edit form does not populate date criteria correctly when editing old
  reminders ([12755](https://github.com/civicrm/civicrm-core/pull/12755))**

- **Only auto-renew membership when contribution status is completed
  ([12315](https://github.com/civicrm/civicrm-core/pull/12315))**

  This change makes it so that Membership will only auto-renew when the
  contribution is in state "Completed".

### Backdrop Integration

- **[dev/core#243](https://lab.civicrm.org/dev/core/issues/243) Backdrop
  authentication function missing in kcfinder package.
  ([216](https://github.com/civicrm/civicrm-packages/pull/216))**

  Fixes Kcfinder package authentication for Backdrop users.

### Drupal Integration

- **Allow Drupal 8 vendor folder outside webroot
  ([12499](https://github.com/civicrm/civicrm-core/pull/12499))**

  This change makes it so that civicrm Drupal 8 integrations can store vendor
  folders outside the webroot.

- **Fix Views custom field handler not displaying select value labels when
  fields share the same label.
  ([532](https://github.com/civicrm/civicrm-drupal/pull/532))**

  Fixes a bug where views custom field handler was not displaying select value
  labels when more than one field had the same label.

### WordPress Integration

- **[CRM-21812](https://issues.civicrm.org/jira/browse/CRM-21812) WordPress
  install variable causes conflict with some WP plugins
  ([125](https://github.com/civicrm/civicrm-wordpress/pull/125))**

  This change makes it so civicrm is compatible with the wp-cli-login-server
  wordpress plugin.

## <a name="misc"></a>Miscellany

- **Extract contact summary basic block to its own tpl
  ([12751](https://github.com/civicrm/civicrm-core/pull/12751))**

- **Simplify input params on OptionValue::addOptionValue
  ([12414](https://github.com/civicrm/civicrm-core/pull/12414))**

- **Enable syntaxConformance on entities that now succeed
  ([12412](https://github.com/civicrm/civicrm-core/pull/12412))**

- **CRM_Core_BAO_PrevNextCache - Remove unused buildSelectedContactPager()
  ([12418](https://github.com/civicrm/civicrm-core/pull/12418))**

- **NFC - Deprecate duplicate function
  ([12602](https://github.com/civicrm/civicrm-core/pull/12602))**

- **[NFC] Update comment link
  ([12429](https://github.com/civicrm/civicrm-core/pull/12429))**

- **[NFC] Export - don't pass arrays as reference when they are not changed
  ([12596](https://github.com/civicrm/civicrm-core/pull/12596))**

- **(NFC) Update readme to link to GitLab instead of JIRA
  ([12578](https://github.com/civicrm/civicrm-core/pull/12578))**

- **(NFC) Remove deprecated recursive array utils
  ([12539](https://github.com/civicrm/civicrm-core/pull/12539))**

- **(NFC) Deprecate redundant array util function
  ([12529](https://github.com/civicrm/civicrm-core/pull/12529))**

- **[NFC] Comment fixes
  ([12450](https://github.com/civicrm/civicrm-core/pull/12450))**

- **(NFC) Remove deprecated function use
  ([221](https://github.com/civicrm/civicrm-packages/pull/221))**

- **(NFC) Ignore generated karma.cv.js file
  ([12462](https://github.com/civicrm/civicrm-core/pull/12462))**

- **(NFC) Update comment on membership type domain_id API Test
  ([12477](https://github.com/civicrm/civicrm-core/pull/12477))**

- **(NFC) Regenerate OptionGroup DAO file
  ([12478](https://github.com/civicrm/civicrm-core/pull/12478))**

- **NFC cleanup to financial classes
  ([12482](https://github.com/civicrm/civicrm-core/pull/12482))**

- **Stdise references to BAO_Query->_fields [nfc]
  ([12585](https://github.com/civicrm/civicrm-core/pull/12585))**

- **Test fix for intermittant error
  ([12673](https://github.com/civicrm/civicrm-core/pull/12673))**

- **Test fix, update activity report adds a this.month filter by default,
  accomodate ([12616](https://github.com/civicrm/civicrm-core/pull/12616))**

- **Customvalue ID is ignored
  ([12606](https://github.com/civicrm/civicrm-core/pull/12606))**

- **Towards using EntityForm.tpl for Membership type & enabling custom data
  ([12591](https://github.com/civicrm/civicrm-core/pull/12591))**

- **Export Add unit test + minor refactor covering specifiable payment output
  fields for participant export.
  ([12535](https://github.com/civicrm/civicrm-core/pull/12535))**

- **Export clean up sql columns
  ([12577](https://github.com/civicrm/civicrm-core/pull/12577))**

- **crmRouteBinder - Don't convert arrays to objects
  ([12530](https://github.com/civicrm/civicrm-core/pull/12530))**

- **Added code to throw exception on getvalue api call
  ([12573](https://github.com/civicrm/civicrm-core/pull/12573))**

- **[dev/financial#24](https://lab.civicrm.org/dev/financial/issues/24) Link
  payment method to financial account when created using api
  ([12388](https://github.com/civicrm/civicrm-core/pull/12388))**

- **Move relationship return properties to the processor class to fix leakage
  related test fail
  ([12521](https://github.com/civicrm/civicrm-core/pull/12521))**

- **Extract code for getting additional return properties, test
  ([12505](https://github.com/civicrm/civicrm-core/pull/12505))**

- **Fix signature on BAO_Product::add to make ids optional
  ([12523](https://github.com/civicrm/civicrm-core/pull/12523))**

- **Export : Add a lot of unit tests. Fix an enotice
  ([12518](https://github.com/civicrm/civicrm-core/pull/12518))**

- **Fix regression on case export from recent export fix
  ([12517](https://github.com/civicrm/civicrm-core/pull/12517))**

- **Remove LOWER from street_address search, rely on mysql to handle.
  ([12503](https://github.com/civicrm/civicrm-core/pull/12503))**

- **Respect '0' as a default when generating DAOs
  ([12483](https://github.com/civicrm/civicrm-core/pull/12483))**

- **Export cleanup Extract bulk of the transformation for each field to its own
  function ([12469](https://github.com/civicrm/civicrm-core/pull/12469))**

- **Fix enotice in test
  ([12507](https://github.com/civicrm/civicrm-core/pull/12507))**

- **Test fix, use separate emails so distinct doesn't meld them
  ([12490](https://github.com/civicrm/civicrm-core/pull/12490))**

- **Export cleanup - pass processor object rather than the query object
  ([12485](https://github.com/civicrm/civicrm-core/pull/12485))**

- **Minor refactor preparatory to function extraction
  ([12468](https://github.com/civicrm/civicrm-core/pull/12468))**

- **Cleanup redundant array functions
  ([12452](https://github.com/civicrm/civicrm-core/pull/12452))**

- **Export code tidy up Use queryFields rather than query. Look to stop passing
  around query. ([12484](https://github.com/civicrm/civicrm-core/pull/12484))**

- **Export class code cleanup Start building export processor class.
  ([12479](https://github.com/civicrm/civicrm-core/pull/12479))**

- **Rename CRM_Contribute_BAO_ManagePremiums to CRM_Contribute_BAO_Product and
  deprecate CRM_Contribute_BAO_ManagePremiums
  ([12474](https://github.com/civicrm/civicrm-core/pull/12474))**

- **Remove unused variables & comment cleanup
  ([12472](https://github.com/civicrm/civicrm-core/pull/12472))**

- **Non functional changes towards shared functions in Core_Form_Task
  ([12320](https://github.com/civicrm/civicrm-core/pull/12320))**

- **Export class code readability - Reduce passing of variable, define on class
  ([12290](https://github.com/civicrm/civicrm-core/pull/12290))**

- **Deprecate  array on ManagePremiums
  ([12451](https://github.com/civicrm/civicrm-core/pull/12451))**

- **Remove old deprecated crmeditable.tpl
  ([12442](https://github.com/civicrm/civicrm-core/pull/12442))**

- **Fix potential undefined array index
  ([12443](https://github.com/civicrm/civicrm-core/pull/12443))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Alok Patel; Australian Greens - Seamus
Lee; Calibrate - Wannes De Roy; Caltha - Tomasz Pietrzkowski; Chris Burgess;
CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Sunil
Pawar, Yashodha Chaku; CompuCorp - Camilo Rodriguez, Mukesh Ram; Coop SymbioTIC -
Mathieu Lutfy; Electronic Frontier Foundation - Mark Burdett; eQuality
Technology - Greg Rundlett; Freeform Solutions - Herb van den Dool; Fuzion -
Jitendra Purohit; JMA Consulting - Monish Deb; John Kingsnorth; Left Join Labs -
Sean Madsen; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting -
Matthew Wire; OSSeed Technologies - Madhavi Malgaonkar; Oxfam Germany - Thomas
Schüttler; Pradeep Nayak; Progressive Technology Project - Jamie McClelland;
Richard van Oosterhout; Romain Thouvenin; Squiffle Consulting - Aidan Saunders;
Tadpole Collective - Kevin Cristiano; Third Sector Design - Michael McAndrew;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Agileware - Agileware Team; Andrew
Cormick-Dockery; Ben Mango; CEDC - Laryn Kragt Bakker; Chris Burgess; Christian
Wach; Circle Interactive - Dave Jenkins; Francesc Bassas i Bullich; Fuzion -
Luke Stewart, Peter Davis; GMCVO Databases - Jon-Man Cheung; Greenleaf
Advancement - Karen Stevenson; Laurynn Lowe; Lemniscus - Noah Miller; Lighthouse
Design and Consulting - Brian Shaughnessy; marsh-circle; MillerTech - Chamil
Wijesooriya; myDropWizard - David Snopek; Semper IT - Karin Gerritsen; Tanya
Bouman

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
