# CiviCRM 5.53.0

Released September 7, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |


## <a name="features"></a>Features

### Core CiviCRM

- **Make Recent Items available providers an option group so extensions can  
  extend it ([dev/core#3783](https://lab.civicrm.org/dev/core/-/issues/3783):
  [24164](https://github.com/civicrm/civicrm-core/pull/24164))**

  Makes it so extension developers can extend the Recent Items content.

- **Allow custom fields to have custom fields
  ([23995](https://github.com/civicrm/civicrm-core/pull/23995))**

  Makes it so custom fields can have custom fields.

- **CiviCRM Standalone: base classes
  ([22227](https://github.com/civicrm/civicrm-core/pull/22227))**

  Work towards a standalone CiviCRM (no CMS needed).

- **SearchKit: HTML fields display
  ([dev/core#3723](https://lab.civicrm.org/dev/core/-/issues/3723):
  [24023](https://github.com/civicrm/civicrm-core/pull/24023))**

  Allows HTML in SearchKit fields.

- **APIv4 Contact.get - include email, phone, address?
  ([dev/core#3659](https://lab.civicrm.org/dev/core/-/issues/3659):
  [23972](https://github.com/civicrm/civicrm-core/pull/23972))**

  Makes it easier to search and display contact primary email, phone, and IM
  without using any joins in SearchKit.

- **Add (pixels) to available label & pdf layout units
  ([24136](https://github.com/civicrm/civicrm-core/pull/24136))**

  Makes `px` (pixels) an available layout unit for labels and pdfs.

- **Metadata - Add label field for SavedSearch
  ([24162](https://github.com/civicrm/civicrm-core/pull/24162))**

  Adds a label field to the metadata for the SavedSearch entity.

- **Make civi 2 nanoseconds faster
  ([24169](https://github.com/civicrm/civicrm-core/pull/24169))**

  Performance improvement.

- **Importer - Increase size of queue batches
  ([24151](https://github.com/civicrm/civicrm-core/pull/24151))**

  Performance improvement.

- **Afform - provide easy way to add navigation menu from the form
  ([24013](https://github.com/civicrm/civicrm-core/pull/24013))**

  Allows administrators to create a navigation menu entry while editing an
  Afform.

- **Afform - Allow groups and tags and age to be filters
 ([23974](https://github.com/civicrm/civicrm-core/pull/23974))**

  Ensures Contact filter fields (groups, tags, age) are available as Afform
  search filters.

- **Afform - Post-submit redirect tokens
 ([24016](https://github.com/civicrm/civicrm-core/pull/24016))**

  Supports tokens in the redirect url, so that e.g. after creating a new contact
  you can be redirected to that contacts' summary page.

- **define format at one place
  ([24049](https://github.com/civicrm/civicrm-core/pull/24049))**

  Moves pdf format array to one place so that it can be altered using hooks.

- **Set target="_blank" on external footer links
 ([23875](https://github.com/civicrm/civicrm-core/pull/23875))**

  Adds rel="external" and target="_blank" attributes to external links in the
  footer.

- **Status Check - Report the overall status (accurately)
 ([24027](https://github.com/civicrm/civicrm-core/pull/24027))**

  Improves the Status reported in the footer.

- **Upgrade task to handle %A date format specifier change
  ([24077](https://github.com/civicrm/civicrm-core/pull/24077))**

  Adds a post upgrade message about the change to teh date token %A output.

### CiviCase

- **Case custom field with clickable contact reference
  ([24072](https://github.com/civicrm/civicrm-core/pull/24072))**

  Makes Case contact reference custom fields clickable.

- **Improvements to Case Detail report
  ([dev/core#3768](https://lab.civicrm.org/dev/core/-/issues/3768):
  [24120](https://github.com/civicrm/civicrm-core/pull/24120),
  [24155](https://github.com/civicrm/civicrm-core/pull/24155) and
  [24109](https://github.com/civicrm/civicrm-core/pull/24109))**

  Improves the Case Detail report by adding an option to include city as a
  column and adding a filter for 'Activity type of the last activity'

### CiviContribute

- **Add `paid_amount `, `balance_amount`, `tax_exclusive_amount` available to
  apiv4 ([24118](https://github.com/civicrm/civicrm-core/pull/24118))**

  Improves APIv4 by adding `paid_amount `, `balance_amount` and
  `tax_exclusive_amount`.

- **Get offline contribution-receipt fully working with preview screen (Work
  Towards [dev/core#3694](https://lab.civicrm.org/dev/core/-/issues/3694):
  [23870](https://github.com/civicrm/civicrm-core/pull/23870))**

  Improves user experience of the offline contribution receipt preview.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **CiviCRM Reports, setting the Report option "Available for Dashboard?" will
  now add the Report to all users Dashboards, which is new and undesirable
  behaviour ([dev/core#3799](https://lab.civicrm.org/dev/core/-/issues/3799):
  [24238](https://github.com/civicrm/civicrm-core/pull/24238))**

- **Export fails for contact reference of type multi-select
  ([dev/core#3751](https://lab.civicrm.org/dev/core/-/issues/3751):
  [24047](https://github.com/civicrm/civicrm-core/pull/24047))**

- **Some file upload fields not uploading
  ([dev/core#3736](https://lab.civicrm.org/dev/core/-/issues/3736):
  [24004](https://github.com/civicrm/civicrm-core/pull/24004))**

  Fixes uploading files on the message template form.

- **Errors with multiple-contact reference field handling
  ([dev/core#3712](https://lab.civicrm.org/dev/core/-/issues/3712):
  [23932](https://github.com/civicrm/civicrm-core/pull/23932))**

- **DB Error when Create User Record
  ([dev/core#3803](https://lab.civicrm.org/dev/core/-/issues/3803):
  [24363](https://github.com/civicrm/civicrm-core/pull/24363))**

- **Import - remove import button if it will not work
  ([24346](https://github.com/civicrm/civicrm-core/pull/24346))**

- **Upgrader - Apply extension updates after core updates
  ([dev/core#3490](https://lab.civicrm.org/dev/core/-/issues/3490):
  [24030](https://github.com/civicrm/civicrm-core/pull/24030))**

- **E-notice fix on Is delete record  
  ([24157](https://github.com/civicrm/civicrm-core/pull/24157))**

- **APIv4 - Fix resolving pseudoconstants for less-permissioned users
  ([24203](https://github.com/civicrm/civicrm-core/pull/24203))**

- **Fix regression causing custom groups to reset to 'Contact' when updated
  ([24220](https://github.com/civicrm/civicrm-core/pull/24220))**

- **Fix ActionLog BAO to not overwrite existing data
  ([24035](https://github.com/civicrm/civicrm-core/pull/24035))**

- **Call static function statically
  ([24114](https://github.com/civicrm/civicrm-core/pull/24114))**

- **Remove extraneous closing tags
  ([24108](https://github.com/civicrm/civicrm-core/pull/24108))**

- **Fix regex on windows
  ([24094](https://github.com/civicrm/civicrm-core/pull/24094))**

- **Fix Angular datepicker to keep up with $digest cycle
  ([24079](https://github.com/civicrm/civicrm-core/pull/24079))**

- **Fix grep in guzzle mock patch
  ([24096](https://github.com/civicrm/civicrm-core/pull/24096))**

- **Update cweagans/composer-patches to 1.7.2 to fix delete-and-reinstall
  problem ([24015](https://github.com/civicrm/civicrm-core/pull/24015))**

- **SearchKit - Fix editable when displaying an icon
  ([24255](https://github.com/civicrm/civicrm-core/pull/24255))**

- **SearchKit - Fix adding deep joins
  ([23993](https://github.com/civicrm/civicrm-core/pull/23993))**

  Fixes a UI bug that was preventing joins past a depth of 2 to be added.

- **SearchKit - Fix viewing search display for anonymous user
  ([24180](https://github.com/civicrm/civicrm-core/pull/24180))**

- **Cannot uninstall Searchkit (dmaster)
  ([dev/core#3179](https://lab.civicrm.org/dev/core/-/issues/3179#note_77504):
  [23895](https://github.com/civicrm/civicrm-core/pull/23895))**

- **Update zetacomponents/mail to 1.9.3 so can remove patches
  ([24198](https://github.com/civicrm/civicrm-core/pull/24198))**

- **zetacomponents/mail - Ensure latest mail patches are included
  ([24233](https://github.com/civicrm/civicrm-core/pull/24233))**

- **CrmUi - Fix crmSelect2 to work with ngOptions
  ([24224](https://github.com/civicrm/civicrm-core/pull/24224))**

- **CrmUi - Fix tabSetOptions variable
  ([24204](https://github.com/civicrm/civicrm-core/pull/24204))**

- **composer.json - Declare requirement for `composer-runtime-api`
  ([24202](https://github.com/civicrm/civicrm-core/pull/24202))**

- **Api4 Explorer - Use metadata for field suffixes instead of guessing
  ([24168](https://github.com/civicrm/civicrm-core/pull/24168))**

- **API - Consistently save custom data for v3 & v4
  ([24036](https://github.com/civicrm/civicrm-core/pull/24036))**

- **APIv4 - Allow values to start with a dollar sign in chaining
  ([24052](https://github.com/civicrm/civicrm-core/pull/24052))**

- **APIv4 - Fix mishandling of boolean custom values
  ([23970](https://github.com/civicrm/civicrm-core/pull/23970))**

- **APIv4 export action: find DAO by ID instead of just calling the constructor
  and setting the ID  
  ([24089](https://github.com/civicrm/civicrm-core/pull/24089))**

- **Afform - Require Authx
  ([23767](https://github.com/civicrm/civicrm-core/pull/23767))**

  Makes Authx a dependency for Afform.

- **Form Builder: Load contact summary blocks on Print Summary page
  ([dev/core#3743](https://lab.civicrm.org/dev/core/-/issues/3743):
  [24024](https://github.com/civicrm/civicrm-core/pull/24024))**

- **Afform - show icon on button only if icon is selected
  ([24073](https://github.com/civicrm/civicrm-core/pull/24073))**

- **Afform - Update correct existing email,phone,address & prevent deletion of
  others ([24172](https://github.com/civicrm/civicrm-core/pull/24172))**

- **Afform - Fix js error when checking to refresh menuBar
  ([24163](https://github.com/civicrm/civicrm-core/pull/24163))**

- **Afform - Switch to APIv4 for managed afform_type option group
  ([23896](https://github.com/civicrm/civicrm-core/pull/23896))**

  Updates managed entity code, with handling to prevent errors in weird upgrade
  scenarios.

- **Afform - Add "clear" button to non-required radios
  ([23413](https://github.com/civicrm/civicrm-core/pull/23413))**

- **afform: breadcrumbs present when flagged for frontend
  ([dev/core#3741](https://lab.civicrm.org/dev/core/-/issues/3741):
  [24022](https://github.com/civicrm/civicrm-core/pull/24022))**

- **remove start/end date as mandatory in Demographics report
  ([24048](https://github.com/civicrm/civicrm-core/pull/24048))**

- **Poly-fill-me-up
  ([23954](https://github.com/civicrm/civicrm-core/pull/23954))**

  Adds polyfill for PHP 7.4, 8.0, 8.1, and 8.2.

### CiviCase

- **Use fontawesome icon helper for activity/Page/AJAX
  ([24021](https://github.com/civicrm/civicrm-core/pull/24021))**

  Fixes a missing delete icon on case roles on some themes.

### CiviContribute

- **Fix line item 'title' determination
  ([24142](https://github.com/civicrm/civicrm-core/pull/24142))**

- **Import of contributions (update existing) errors
  ([dev/core#3820](https://lab.civicrm.org/dev/core/-/issues/3820) and
  [dev/core#3828](https://lab.civicrm.org/dev/core/-/issues/3828):
  [24366](https://github.com/civicrm/civicrm-core/pull/24366) and
  [24414](https://github.com/civicrm/civicrm-core/pull/24414))**

- **Fix and followups for invoice receipt message template
  ([24111](https://github.com/civicrm/civicrm-core/pull/24111) and
  [24101](https://github.com/civicrm/civicrm-core/pull/24101))**

  Removes extraneous closing tags from the invoice receipt message template and
  adds an upgrade warning regarding the change.

- **5.51 regression - Contribution import - external id/contact id matches to
  wrong records
  ([dev/core#3784](https://lab.civicrm.org/dev/core/-/issues/3784):
  [24166](https://github.com/civicrm/civicrm-core/pull/24166))**

- **Scheduled Job, Process Pledges reports an error when executed - Scheduled
  Job Failure: Finished execution of Process Pledges with result: Failure,
  Error message: invalid criteria for IN
  ([dev/core#3749](https://lab.civicrm.org/dev/core/-/issues/3749):
  [24059](https://github.com/civicrm/civicrm-core/pull/24059))**

- **remove pledge status as mandatory in Pledge report
  ([24028](https://github.com/civicrm/civicrm-core/pull/24028))**

- **Fix 'Pledge Made Date' display to show date and not time
  ([24031](https://github.com/civicrm/civicrm-core/pull/24031))**

- **E_NOTICEs from CRM_Contribute_Task::permissionedTaskTitles() - undefined /
  null array errors
  ([dev/core#3737](https://lab.civicrm.org/dev/core/-/issues/3737):
  [24010](https://github.com/civicrm/civicrm-core/pull/24010))**

- **Error thrown when 'remove'ing from CiviContribute Batch
  ([dev/core#3050](https://lab.civicrm.org/dev/core/-/issues/3050):
  [24025](https://github.com/civicrm/civicrm-core/pull/24025))**

- **Stop adding 'In Progress' and 'Overdue' statuses to
  civicrm_contribution.contribution_status_id option group (Work Towards
  [dev/financial#201](https://lab.civicrm.org/dev/financial/-/issues/201):
  [24050](https://github.com/civicrm/civicrm-core/pull/24050) and
  [24051](https://github.com/civicrm/civicrm-core/pull/24051))**

  Fixes PaypalPro IPN to refer to correct option group and fixes pledge payment
  to not refer to Contribution status.

- **Avoid sending blank invoices
  ([24065](https://github.com/civicrm/civicrm-core/pull/24065))**

### CiviEvent

- **CiviCRM 5.51, Import Participants when matching by External / Contact ID
  always matches to Contacts with ID < 10
  ([dev/core#3786](https://lab.civicrm.org/dev/core/-/issues/3786):
  [24153](https://github.com/civicrm/civicrm-core/pull/24153))**

### CiviMember

- **Notice: Undefined offset: 18 in CRM_Member_Form_Task_Batch->buildQuickForm()
  ([dev/core#3772](https://lab.civicrm.org/dev/core/-/issues/3772):
  [24124](https://github.com/civicrm/civicrm-core/pull/24124))**

- **Fix error on membership imports
  ([24349](https://github.com/civicrm/civicrm-core/pull/24349))**

### Drupal Integration

- **Error: Trying to access array offset on value of type null in
  Drupal\civicrm\Plugin\Block\CivicrmBlock->build
  ([dev/drupal#181](https://lab.civicrm.org/dev/drupal/-/issues/181):
  [75](https://github.com/civicrm/civicrm-drupal-8/pull/75))**

  Fixes an error when a user without proper permissions tries to view the Recent
  Items block.

- **Drupal 10 requires Guzzle 7
  ([dev/drupal#171](https://lab.civicrm.org/dev/drupal/-/issues/171):
  [22918](https://github.com/civicrm/civicrm-core/pull/22918))**

  Allows guzzle 7 for drupal 10.

- **Lower minimum polyfill version since conflicts with drupal/core-recommended
  ([24017](https://github.com/civicrm/civicrm-core/pull/24017))**

### WordPress Integration

- **Downgrade Symfony Service Contracts to 2.2.0 to fix php fatal error in
  wordpress ([24171](https://github.com/civicrm/civicrm-core/pull/24171))**

- **fix broken url for wordpress in example code
  ([24084](https://github.com/civicrm/civicrm-core/pull/24084))**

## <a name="misc"></a>Miscellany

- **Log a bit more deprecation info
  ([24064](https://github.com/civicrm/civicrm-core/pull/24064))**

- **Skip warning about event-online message template during upgrade
  ([24141](https://github.com/civicrm/civicrm-core/pull/24141))**

- **APIv4 - Improve pseudoconstant support in getFields
  ([24099](https://github.com/civicrm/civicrm-core/pull/24099))**

- **Replace all calls to deprecated method
  CRM_Core_PseudoConstant::activityType()
  ([dev/core#3692](https://lab.civicrm.org/dev/core/-/issues/3692):
  [23981](https://github.com/civicrm/civicrm-core/pull/23981),
  [23982](https://github.com/civicrm/civicrm-core/pull/23982) and
  [23979](https://github.com/civicrm/civicrm-core/pull/23979))**

- **[REF] Move reCAPTCHA to core extension
  (Work Towards [dev/core#2571](https://lab.civicrm.org/dev/core/-/issues/2571):
  [20588](https://github.com/civicrm/civicrm-core/pull/20588))**

- **Regenerate sql
  ([24119](https://github.com/civicrm/civicrm-core/pull/24119))**

- **composer.json - Update scssphp and related libraries (for PHP 8.1)
  ([24044](https://github.com/civicrm/civicrm-core/pull/24044))**

- **net_smtp upgrade to 1.10.0
  ([23998](https://github.com/civicrm/civicrm-core/pull/23998))**

- **Add whitespace to exception message
  ([24057](https://github.com/civicrm/civicrm-core/pull/24057))**

- **Update contributor-key.yml
  ([24078](https://github.com/civicrm/civicrm-core/pull/24078))**

- **Make unshared function private, remove unused return
  ([24105](https://github.com/civicrm/civicrm-core/pull/24105))**

- **Move hook_civicrm_translateFields from message_admin to core
  ([24063](https://github.com/civicrm/civicrm-core/pull/24063))**

- **Minor test cleanup
  ([24071](https://github.com/civicrm/civicrm-core/pull/24071))**

- **Whitespace cleanup  in invoice template
  ([24113](https://github.com/civicrm/civicrm-core/pull/24113))**

- **Fix test to not use Contribution option group for ContributionRecur status
  ([24135](https://github.com/civicrm/civicrm-core/pull/24135))**

- **composer.lock hash out of date
  ([24011](https://github.com/civicrm/civicrm-core/pull/24011))**

- **add classes to the contribution view page
  ([24012](https://github.com/civicrm/civicrm-core/pull/24012))**

- **removed import contacts access argument for summary path
  ([24206](https://github.com/civicrm/civicrm-core/pull/24206))**

- **Remove `loadAll` parameter from loadRelatedObjects
  ([24140](https://github.com/civicrm/civicrm-core/pull/24140))**

- **Remove some fixmes from message tpls
  ([24107](https://github.com/civicrm/civicrm-core/pull/24107))**

- **Remove extra space, offline receipt
  ([24106](https://github.com/civicrm/civicrm-core/pull/24106))**

- **Remove call to `loadRelatedObjects` from `completetransaction`
  ([24087](https://github.com/civicrm/civicrm-core/pull/24087))**

- **Remove legacy `apiquery` call from `isContactInGroup`
  ([24062](https://github.com/civicrm/civicrm-core/pull/24062))**

- **Remove deprecated call to `loadRelatedObjects`
  ([24088](https://github.com/civicrm/civicrm-core/pull/24088))**

- **Remove unused variable
  ([24128](https://github.com/civicrm/civicrm-core/pull/24128))**

- **Remove reference to CiviAuction
  ([24187](https://github.com/civicrm/civicrm-core/pull/24187))**

- **[REF] Fix Test fails on import by ensuring that Month Abbreviations are
  formatted based on the first of each month
  ([24100](https://github.com/civicrm/civicrm-core/pull/24100))**

- **[REF] OAuth - Move some API code to the BAO for better reusability
  ([23725](https://github.com/civicrm/civicrm-core/pull/23725))**

- **[REF] Convert Elavon Payment Processor to use Guzzle and ensure that we are
  using POST requests not GET requests to Elavon end point
  ([24131](https://github.com/civicrm/civicrm-core/pull/24131))**

- **[REF] Upgrade DOMPDF to 2.x branch
  ([23946](https://github.com/civicrm/civicrm-core/pull/23946))**

- **[REF][PHP8.1] Batch 4 of fixing issues found in unit tests where passing
  NULL values triggers deprecations
  ([24018](https://github.com/civicrm/civicrm-core/pull/24018))**

- **[REF][PHP8.1] Upgrade oauth2-client,zetacomponents/base,htmlpurfier packages
  to versions that support php8.1
  ([23984](https://github.com/civicrm/civicrm-core/pull/23984))**

- **[php 8.1 compat] Avoid passing null to explode()
  ([24177](https://github.com/civicrm/civicrm-core/pull/24177))**

- **[php 8.1 compat] Avoid passing null to strlen
  ([24178](https://github.com/civicrm/civicrm-core/pull/24178))**

- **[php 8.1 compat] Avoid CRM_Utils_System::url null for $query param
  ([24176](https://github.com/civicrm/civicrm-core/pull/24176))**

- **[REF][PHP8.1] Fix a couple of deprecations in php8.1 by specifying that
  return type may change in BaseParamQuery and by ensuring that we don't pass
  null into function_exists in I18n class
  ([23851](https://github.com/civicrm/civicrm-core/pull/23851))**

- **[REF] Additional PHP8.1 fix for passing in NULL value to strlen
  ([349](https://github.com/civicrm/civicrm-packages/pull/349))**

- **[REF][PHP8.1] A third batch of fixes where passing in NULL values causes
  deprecation notices in php8.1
  ([23999](https://github.com/civicrm/civicrm-core/pull/23999))**

- **Fix test. Don't hide errors. (Followup to 23999)
  ([24007](https://github.com/civicrm/civicrm-core/pull/24007))**

- **[REF][PHP8.1] Replace usage of the date_format modifer with crmDate to
  resolve issues with strftime
  ([24008](https://github.com/civicrm/civicrm-core/pull/24008))**

- **[REF][PHP8.1][INTL] Remove dependency on strftime function by using ts to
  generate day full names and abbreviations and month abbreviations
  ([24032](https://github.com/civicrm/civicrm-core/pull/24032))**

- **[REF][PHP8.1] Apply patches from upstream to ensure league/csv can work on
  php8.1 ([24046](https://github.com/civicrm/civicrm-core/pull/24046))**

- **[php 8.1 compat] Avoid CRM_Utils_System::url null for $query param
  ([24192](https://github.com/civicrm/civicrm-core/pull/24192))**

- **[REF][PHP8.1] Update phpoffice/phpword and tecnickcom/tcpdf  packages for
  php8.1 compatability
  ([24045](https://github.com/civicrm/civicrm-core/pull/24045))**

- **[REF][PHP8.1] Another batch of fixes for passing in NULL values into
  functions that expect string|array parameters
  ([24082](https://github.com/civicrm/civicrm-core/pull/24082))**

- **[NFC][PHP8.1] Ensure that Trait function is only accessed by classes that
  use the trait ([24081](https://github.com/civicrm/civicrm-core/pull/24081))**

- **[REF][PHP8.1] Permit single quotes within html attributes
  ([24083](https://github.com/civicrm/civicrm-core/pull/24083))**

- **[REF][PHP8.1] Do not set auto_detect_line_endings to true on php versions
  8.1 and later as it is deprecated
  ([24092](https://github.com/civicrm/civicrm-core/pull/24092))**

- **[REF][PHP8.1] Apply patch in PHPWord to fix passing in null value into
  strlen in validating locale
  ([24093](https://github.com/civicrm/civicrm-core/pull/24093))**

- **[REF][PHP8.1] Apply PR patch to fix issue in php8.1 where mysqli error
  reporting changed
  ([23996](https://github.com/civicrm/civicrm-core/pull/23996))**

- **[REF][PHP8.1] Fix some further places where passing in NULL is deprecated in
  php8.1 ([348](https://github.com/civicrm/civicrm-packages/pull/348))**

- **[REF][PHP8.1] Fix issues where passing in NULL values causes deprecations in
  php8.1 ([346](https://github.com/civicrm/civicrm-packages/pull/346))**

- **[REF][PHP8.1] Fix return type hint deprecations in php8.1 in the IDS
  ([347](https://github.com/civicrm/civicrm-packages/pull/347))**

- **[REF][PHP8.1] Fix Return type hints and passing in NULL values causing
  deprecation notices in php8.1 in Property Bag
  ([24000](https://github.com/civicrm/civicrm-core/pull/24000))**

- **[REF][PHP8.1] Fix issues in core extensions where passing in NULL values is
  no longer supported
  ([23997](https://github.com/civicrm/civicrm-core/pull/23997))**

- **[NFC] Convert Payment Processor ID field to payment processor in event
  create in tests
  ([24256](https://github.com/civicrm/civicrm-core/pull/24256))**

- **(NFC) Add common `@group` for import-related tests
  ([24150](https://github.com/civicrm/civicrm-core/pull/24150))**

- **NFC - remove unused variables, minor tidy up
  ([24139](https://github.com/civicrm/civicrm-core/pull/24139))**

- **[NFC] Resolve phpunit warning about using assertContains on strings
  ([24091](https://github.com/civicrm/civicrm-core/pull/24091))**

- **(NFC) HookStyleListener - Comments
  ([24055](https://github.com/civicrm/civicrm-core/pull/24055))**

- **(NFC) CRM_Core_Permission - More docblocks
  ([24043](https://github.com/civicrm/civicrm-core/pull/24043))**

- **[NFC] Add in convertDeprecationsToExceptions='true' to core extension's
  phpunit.xml.dist files
  ([23986](https://github.com/civicrm/civicrm-core/pull/23986))**

- **[NFC] Convert Deprecations in tests to exceptions
  ([23985](https://github.com/civicrm/civicrm-core/pull/23985))**

- **[NFC] fix composer.lock hash
  ([23978](https://github.com/civicrm/civicrm-core/pull/23978))**

- **[NFC] dompdf patch whitespace fix
  ([23977](https://github.com/civicrm/civicrm-core/pull/23977))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Justin Freeman; Alexy Mikhailichenko;
Circle Interactive - Pradeep Nayak; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy;
CSES (Chelmsford Science and Engineering Society) - Adam Wood; Dave D;
Freeform Solutions - Herb van den Dool; Jens Schuppe;
JMA Consulting - Seamus Lee; Joinery - Allen Shaw; KAM z.s. - Vít Maňásek;
Lemniscus - Noah Miller; Megaphone Technology Consulting - Jon Goldberg;
MJW Consulting - Matthew Wire; Robert J. Lang;
Tadpole Collective - Kevin Cristiano; Third Sector Design - Kurund Jalmi,
Michael McAndrew; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Francis Whittle; Andy Burns; Artful Robot - Rich Lott;
avall-llovera; Betty Dolfing; Circle Interactive - Pradeep Nayak;
CiviCoop - Jaap Jansma; Francesc Bassas i Bullich; JMA Consulting - Monish Deb;
Levi.k; Mikey O'Toole; Savion Lee; Squiffle Consulting - Aidan Saunders

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
