title: Programming Guide
toc: [Documentation, Programming Guide]

# Programming Guide

Programming WAMP application components is tied to the particular client library you're using. The [Autobahn](/autobahn) family of WAMP client libraries is provided by us, whereas you can find more WAMP client libraries [here](http://wamp.ws/implementations/#libraries).

We also operate a public [Crossbar.io Demo Instance](Demo Instance) and offer a range of materials for [IoT devices, components and applications](http://crossbario.com/iotcookbook).

> For administrators, we provide a [Administration Manual](Administration) that provides documentation about administration aspects related to Crossbar.io.

The following introduces different areas of WAMP application programming with Crossbar.io:

### Usage

- [Starting and Stopping Crossbar.io](Starting and Stopping Crossbario)
- [Configuring Crossbar.io's Logging](Configuring Crossbario Logging)

### General

- [URI Format](URI Format)
- [Logging in Crossbar.io](Logging in Crossbario)
- [Error Handling](Error Handling)
- [Session Meta Events and Procedures](Session Metaevents and Procedures)
- [Development with External Devices](Development-with-External-Devices)

### Publish and Subscribe

- [How Subscriptions Work](How Subscriptions Work)
- [Basic Subscriptions](Basic Subscriptions)
- [Subscriber Black- and Whitelisting](Subscriber Black and Whitelisting)
- [Publisher Exclusion](Publisher Exclusion)
- [Publisher Identification](Publisher Identification)
- [Pattern-Based Subscriptions](Pattern Based Subscriptions)
- [Subscription Meta Events and Procedures](Subscription Meta Events and Procedures)
- [Event History](Event History)

### Remote Procedure Calls

- [How Registrations Work](How Registrations Work)
- [Basic Registrations](Basic Registrations)
- [Caller Identification](Caller Identification)
- [Progressive Call Results](Progressive Call Results)
- [Pattern-Based Registrations](Pattern Based Registrations)
- [Shared Registrations](Shared Registrations)
- [Registration Meta Events and Procedures](Registration Meta Events and Procedures)

### Specific Usages

- [Adding Real-Time to Django Applications](Adding Real Time to Django Applications)
- [[AngularJS Application Components]]
- [Database Programming with PostgreSQL](Database Programming with PostgreSQL)

### Specific Languages

Details of programming depend on the [specific WAMP library](/about/Supported-Languages/) you are using. You may find more information in the documentation for the respective libraries, e.g.

- [Programming with Autobahn|Python](http://autobahn.readthedocs.io/en/latest/wamp/programming.html)
- [Programming with Autobahn|JavaScript](https://github.com/crossbario/autobahn-js/blob/master/doc/programming.md)
