#include "balancer"

void Balancer::deletebackend(unsigned i) {
    if (backend(i).up())
	throw Error("Only 'down' back ends can be deleted.");
    if (backend(i).connections()) {
	ostringstream o;
	o << "Back end cannot be deleted, there are still "
	  << backend(i).connections() << " connections";
	throw Error(o.str());
    }

    int lock;
    mutex_lock(&lock);
    backends.erase(backends.begin() + i,
		   backends.begin() + i + 1);
    mutex_unlock(&lock);
}
