#include "FuseOpenTest.h"

int FuseOpenTest::OpenFile(const char *filename, int flags) {
  int fd = OpenFileAllowError(filename, flags);
  EXPECT_GE(fd, 0);
  return fd;
}

int FuseOpenTest::OpenFileReturnError(const char *filename, int flags) {
  int fd = OpenFileAllowError(filename, flags);
  if (fd >= 0) {
    return 0;
  } else {
    return -fd;
  }
}

int FuseOpenTest::OpenFileAllowError(const char *filename, int flags) {
  auto fs = TestFS();

  auto realpath = fs->mountDir() / filename;
  int fd = ::open(realpath.c_str(), flags);
  if (fd >= 0) {
    return fd;
  } else {
    return -errno;
  }
}
