#include "cursor.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace impl {
namespace msg {

void CursorStation::enq(impl::Enq& enq) const
{
    if (enq.search_b_values(station_values)) return;
    const auto key = enq.key;
    const auto len = enq.len;
    switch (len) {
        case 3:
            if (key[0] == 'l') {
            switch (key[1]) {
                case 'a':
                    if (key[2] == 't') {
                        enq.set_lat(station.coords.lat);
                    } else {
                        enq.search_alias_values(station_values);
                    }
                    break;
                case 'o':
                    if (key[2] == 'n') {
                        enq.set_lon(station.coords.lon);
                    } else {
                        enq.search_alias_values(station_values);
                    }
                    break;
                default: enq.search_alias_values(station_values);
            }
            } else {
                enq.search_alias_values(station_values);
            }
            break;
        case 5:
            if (memcmp(key + 0, "ident", 5) == 0) {
                enq.set_ident(station.ident);
            } else {
                enq.search_alias_values(station_values);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(station.report);
                    } else {
                        enq.search_alias_values(station_values);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(station.id);
                    } else {
                        enq.search_alias_values(station_values);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(!station.ident.is_missing());
                    } else {
                        enq.search_alias_values(station_values);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(station.coords);
                    } else {
                        enq.search_alias_values(station_values);
                    }
                    break;
                default: enq.search_alias_values(station_values);
            }
            break;
        case 7:
            if (memcmp(key + 0, "station", 7) == 0) {
                enq.set_station(station);
            } else {
                enq.search_alias_values(station_values);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        return;
                    } else {
                        enq.search_alias_values(station_values);
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(station.report);
                    } else {
                        enq.search_alias_values(station_values);
                    }
                    break;
                default: enq.search_alias_values(station_values);
            }
            break;
        default: enq.search_alias_values(station_values);
    }
}

void CursorStationData::enq(impl::Enq& enq) const
{
    if (enq.search_b_value(*cur)) return;
    const auto key = enq.key;
    const auto len = enq.len;
    switch (len) {
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                enq.set_lat(station.coords.lat);
                            } else {
                                enq.search_alias_value(*cur);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                enq.set_lon(station.coords.lon);
                            } else {
                                enq.search_alias_value(*cur);
                            }
                            break;
                        default: enq.search_alias_value(*cur);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        enq.set_varcode(cur->code());
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                default: enq.search_alias_value(*cur);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        enq.set_ident(station.ident);
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttrs", 4) == 0) {
                        enq.set_attrs(cur->get());
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                default: enq.search_alias_value(*cur);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(station.report);
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(station.id);
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(!station.ident.is_missing());
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(station.coords);
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                default: enq.search_alias_value(*cur);
            }
            break;
        case 7:
            if (memcmp(key + 0, "station", 7) == 0) {
                enq.set_station(station);
            } else {
                enq.search_alias_value(*cur);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        return;
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(station.report);
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ariable", 7) == 0) {
                        enq.set_var(cur->get());
                    } else {
                        enq.search_alias_value(*cur);
                    }
                    break;
                default: enq.search_alias_value(*cur);
            }
            break;
        case 10:
            if (memcmp(key + 0, "context_id", 10) == 0) {
                return;
            } else {
                enq.search_alias_value(*cur);
            }
            break;
        default: enq.search_alias_value(*cur);
    }
}

void CursorData::enq(impl::Enq& enq) const
{
    if (enq.search_b_value(*(cur->var))) return;
    const auto key = enq.key;
    const auto len = enq.len;
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(cur->level.l1);
                            break;
                        case '2':
                            enq.set_dballe_int(cur->level.l2);
                            break;
                        default: enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(cur->trange.p1);
                            break;
                        case '2':
                            enq.set_dballe_int(cur->trange.p2);
                            break;
                        default: enq.search_alias_value(*(cur->var));
                    }
                    break;
                default: enq.search_alias_value(*(cur->var));
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                enq.set_lat(station.coords.lat);
                            } else {
                                enq.search_alias_value(*(cur->var));
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                enq.set_lon(station.coords.lon);
                            } else {
                                enq.search_alias_value(*(cur->var));
                            }
                            break;
                        default: enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        enq.set_int(datetime.day);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        enq.set_int(datetime.minute);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        enq.set_int(datetime.second);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        enq.set_varcode(cur->var->code());
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                default: enq.search_alias_value(*(cur->var));
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        enq.set_int(datetime.year);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        enq.set_int(datetime.hour);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                default: enq.search_alias_value(*(cur->var));
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        enq.set_ident(station.ident);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        enq.set_int(datetime.month);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "evel", 4) == 0) {
                        enq.set_level(cur->level);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttrs", 4) == 0) {
                        enq.set_attrs(cur->var->get());
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                default: enq.search_alias_value(*(cur->var));
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(station.report);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(station.id);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(!station.ident.is_missing());
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(station.coords);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "range", 5) == 0) {
                        enq.set_trange(cur->trange);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                default: enq.search_alias_value(*(cur->var));
            }
            break;
        case 7:
            if (memcmp(key + 0, "station", 7) == 0) {
                enq.set_station(station);
            } else {
                enq.search_alias_value(*(cur->var));
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        return;
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(station.report);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "atetime", 7) == 0) {
                        enq.set_datetime(datetime);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ariable", 7) == 0) {
                        enq.set_var(cur->var->get());
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                default: enq.search_alias_value(*(cur->var));
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                enq.set_dballe_int(cur->level.ltype1);
                                break;
                            case '2':
                                enq.set_dballe_int(cur->level.ltype2);
                                break;
                            default: enq.search_alias_value(*(cur->var));
                        }
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        enq.set_dballe_int(cur->trange.pind);
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ontext_id", 9) == 0) {
                        return;
                    } else {
                        enq.search_alias_value(*(cur->var));
                    }
                    break;
                default: enq.search_alias_value(*(cur->var));
            }
            break;
        default: enq.search_alias_value(*(cur->var));
    }
}

}
}
}
