/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * @file diagnostics/basic_exceptions/violated_invariance.cpp
 *
 * @brief The exception to be used if a code invariance is does not hold.
 *
 * $Id: violated_invariance.cpp 296 2007-11-27 00:21:41Z tautschn $
 *
 * @author Christian Schallhart <schallha@in.tum.de>
 * @date   Thu Nov 23 08:21:06 CET 2006
*/

#include <diagnostics/basic_exceptions/violated_invariance.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

Violated_Invariance::~Violated_Invariance() DIAGNOSTICS_EXCEPTIONS_THROW_DECL
{
}

Violated_Invariance::Violated_Invariance(Self const & other)
    : Super(other)
{
}

Violated_Invariance::Violated_Invariance(::std::string const & what)
    : Super(what)
{
}

char const * Violated_Invariance::name() const
{
    return "Violated_Invariance";
}

DIAGNOSTICS_NAMESPACE_END;

