/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/mutexed_test_data.hpp
 *
 * @brief [LEVEL: alpha] @ref diagnostics::unittest::Mutexed_Test_Data class
 *
 * $Id: mutexed_test_data.hpp,v 1.6 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test none
 *
 * @todo add test
 */
#ifndef DIAGNOSTICS__UNITTEST__TEST_SYSTEM__MUTEXED_TEST_DATA_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__TEST_SYSTEM__MUTEXED_TEST_DATA_HPP__INCLUDE_GUARD

// used as base class
#include <diagnostics/unittest/test_data.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

/**
 * @class Mutexed_Test_Data diagnostics/unittest/test_system/mutexed_test_data.hpp
 *
 * @brief A @ref diagnostics::unittest::Test_Data implementation which
 * uses another @ref diagnostics::unittest::Test_Data implementation
 * as backend. The calls to @ref diagnostics::unittest::Test_Data::get
 * and @ref diagnostics::unittest::Test_Data::compare are delegated to
 * the backend, but these calls are all mutexed using @ref
 * diagnostics::internal::Lock_Guard. 
 *
 * @nosubgrouping
 */
class Mutexed_Test_Data :
    public Test_Data
{
    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creation
     * @{
     */
public:
    /**
     * @brief the only way -- backend()==NULL, prefix()==""
     *
     * @throw never
     */
    Mutexed_Test_Data();

    /**
     * @throw never
     */
    virtual ~Mutexed_Test_Data();
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Configuration
     * @{
     */
public:
    /**
     * @brief attaches @a backend to this -- NO ownership transfer.
     *
     * Once a backend is attached to this, the @ref get and @ref
     * compare methods can be used.
     *
     * @pre @a backend!=NULL
     * @post POST.backend() == @a backend
     *
     * @throw Test_System_Exception if the precondition is not met
     */
    void attach(Test_Data * const backend);

    /**
     * @brief returns the currently attached backend.
     *
     * @throw never
     */
    inline Test_Data * backend() const { return m_backend; }
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Implementation of the @ref Test_Data interface
     * @{
     */
public:
    /**
     * @brief equivalent to backend().get(id) -- but the call is
     * guarded by @ref DIAGNOSTICS_LOGGING_FACILITY_LOCK_GUARD.
     *
     * @throw Test_System_Exception if the underlying backend throws it or 
     * if @ref backend()==NULL
     * @throw Test_Exception if the underlying backend throws it
     */
    virtual ::std::string const & get(::std::string const & id) const;

    /**
     * @brief equivalent to backend().compare(id,data) -- but the call
     * is guarded by @ref DIAGNOSTICS_LOGGING_FACILITY_LOCK_GUARD.
     *
     * @throw Test_System_Exception if the underlying backend throws it or 
     * if @ref backend()==NULL
     * @throw Test_Exception if the underlying backend throws it
     */
    virtual bool compare(::std::string const & id,::std::string const & data) const;
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Encapsulated State
     * @{
     */
private:
    Test_Data * m_backend;
    // @}
};

UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


#endif
// vim:ts=4:sw=4
