# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
# Copyright (C) 2012-2014 Bastian Kleineidam
from re import compile
from ..scraper import make_scraper
from ..util import tagre, quote, fetchUrl, case_insensitive_re, getPageContent

# SmackJeeves is a crawlers nightmare - users are allowed to edit HTML directly.
# That's why there are so much different search patterns.

_imageSearch = compile(tagre("img", "src", r'([^"]+)', after='id="comic_image"'))
_linkSearch = tagre("a", "href", r'([^>"]*/comics/\d+/[^>"]*)', quote='"?')
_attrs = dict(
    back = case_insensitive_re("back"),
    prev = case_insensitive_re("prev"),
    next = case_insensitive_re("next"),
)
_prevSearch = (
    compile(_linkSearch +
  r'(?:<img[^>]+alt="[^"]*%(prev)s|<img[^>]+(?:button_previous|naviButtons_Previous|nav_prev4|prev|previous|webbuttonback|PrevArrow)\.|[^<]*%(back)s|\s*<<? (?:%(back)s|%(prev)s)|[^<]*%(prev)s)' % _attrs),
    compile(_linkSearch + r'[^<]*Atras<'),
    compile(_linkSearch + tagre("img", "src", r'[^"]+/(?:backrg|JZj4a3C|b5175a677Zd6b)\.png')),
    compile(_linkSearch + tagre("img", "src", r"[^']+/(?:backnav)\.png", quote="'")),
    compile(_linkSearch + r"\s*" + tagre("img", "src", r'[^"]+/prev\.jpg')),
)
_nextSearch = (
    compile(_linkSearch +
  r'(?:<img[^>]+alt="%(next)s|<img[^>]+(?:button_next|naviButtons_Next|nav_next4|next|webbuttonnext-1|NextArrow)\.|\s*<?[^<]*%(next)s)' % _attrs),
    compile(_linkSearch + r'Siguiente'),
    compile(_linkSearch + tagre("img", "src", r'[^"]+/(?:arrow3_zps03f490e3|60ecbaed7gbJs)\.png[^"]*')),
    compile(_linkSearch + tagre("img", "src", r"[^']+/(?:forthnav)\.png[^']*", quote="'")),
)

def add(name, url, description, adult, bounce):
    classname = 'SmackJeeves_' + name

    def modifier(pageUrl):
        if adult:
            # mature content can be viewed directly with:
            # http://www.smackjeeves.com/mature.php?ref=<percent-encoded-url>
            return 'http://www.smackjeeves.com/mature.php?ref=' + quote(pageUrl)
        return pageUrl

    @classmethod
    def _starter(cls):
        """Get start URL."""
        url1 = modifier(url)
        data, baseUrl = getPageContent(url1, cls.session)
        url2 = fetchUrl(url1, data, baseUrl, cls.prevSearch)
        if bounce:
            data, baseUrl = getPageContent(url2, cls.session)
            url3 = fetchUrl(url2, data, baseUrl, _nextSearch)
            return modifier(url3)
        return modifier(url2)

    @classmethod
    def namer(cls, imageUrl, pageUrl):
        parts = pageUrl.split('/')
        name = parts[-2]
        num = parts[-3]
        return "%s_%s" % (name, num)

    globals()[classname] = make_scraper(classname,
        name = 'SmackJeeves/' + name,
        adult = adult,
        url = url,
        starter = _starter,
        prevUrlModifier = lambda cls, url: modifier(url),
        stripUrl = url + '%s/',
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        prevUrlMatchesStripUrl = not adult,
        description = description,
        lang = 'es' if name.lower().endswith('spanish') else 'en',
        help = 'Index format: nnnn (some increasing number)',
        namer = namer,
    )


# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('20TimesKirby', 'http://20xkirby.smackjeeves.com/comics/', u"20 kirbies, considered different from all the others by Kirby, go on a journey to find out their past... At least that's what Kirby wants, since he can't stand the fact of knowing nothing about them all. The answers come slowly, the suspense builds, and the question is, are they going to find out everything? Or are they just going to have random adventures, and never know all of it? Updates every other day.", False, True)
add('2Kingdoms', 'http://2kingdoms.smackjeeves.com/comics/', u'Lost in the middle of the dangerous seaweed forest of Lebanon, Uegon Prince Apollo is searching for the way home. Joined by his cousin Paris, his faithful pet Pyou, and a pair of Uegon sisters named Diane and Juno, the group must face a deceptive maze of seaweed trees, giant flesh eating monsters, the Unknown Dark Lands of the Herse, and the biggest hurdle of all, a war in the royal house of the High Waters!', False, False)
add('355Days', 'http://355days.smackjeeves.com/comics/', u"This was originally a comic where I attempted to make an homage to Kurt Vonnegut's Timequake, but it slowly evolved into A Dada Humor comic, which has now evolved onto a actual storyline that has gone on since April 1st 2012. This is my experimental comic where I attempt to post a comic daily with anything I can get my hands on, just attempting to get at least one page up! ***ENDED AS OF 9/2/12*** If you liked this comic check out my new comic: Euphemistic Eephus. http://www.smackjeeves.com/comicprofile.php?id=127121", False, True)
add('AB', 'http://alistairandboggart.smackjeeves.com/comics/', u"*Updates when I'm not working! :D Alistair Wind and Boggart Cabera. slice of life/supernatural/humor If you\u2019re not into BL or Shonen ai or relationships other than hetero then this may not the comic for you. This is a side series which mainly focuses on their relationship aspect from the main series I am working on. Welcome to their unremarkable everyday with the occasional demons and drama. Warning: BL, profanity, sexual themes/contents.", True, True)
add('ADoodleADay', 'http://adoodleaday.smackjeeves.com/comics/', u"As an alternative to a diary or anything boring like that, I'm doing a comic. On the back of a page-a-day calendar, here are the stupid thoughts that go through my head on a daily basis. (Some characters may be imaginary because I didn't want to offend real people by drawing them). Just jump in anywhere, there's one case of continuity in the last year. All you actually need to know is that I'm in uni, and play a lot of games. A comic a day, almost guaranteed! (I might still be five pages behind, but I'm hoping to fix that). The start is a little sticky because I didn't start the project until part way through January. The first few pages were done throughout the year with left over ideas. Please note, this is a year behind. So everything relates to last year, hence some of the out of date content.", False, True)
add('AGirlAndHerShadow', 'http://agirlandhershadow.smackjeeves.com/comics/', u"There's something under the little girl's bed. It likes to play hide-and-seek and it's always hungry. It's also her best friend.", False, True)
add('AGirlontheServer', 'http://girlontheserver.smackjeeves.com/comics/', u"The true and mostly true stories of a girl playing online games and having to deal with all the crap that comes with it. Because apparently, girls don't exist on the Internet!", False, True)
add('AKirbyKomic', 'http://akirbykomic.smackjeeves.com/comics/', u"Join Kirby, Meta, and friends as they travel throughout the Kirby video game series and attempt to stop evil who are trying to destroy this series. It's a daily 4-panel adventure filled with science fiction, humor, and randomness.", False, True)
add('ALaMode', 'http://alamode.smackjeeves.com/comics/', u"Lamode sells talking pretzels to pay the rent. Her apprentice Schulz handles the wilder creations. Her new home Arryn, a college neighborhood pretending to be a town, helps Lamode discover love, acute distaste for movies, and the best way to a customer's stomach. A La Mode updates on Tuesdays and Thursdays.", False, False)
add('ANGELOU', 'http://angelou-esp.smackjeeves.com/comics/', u'ANGELOU Historia y dibujo: CaiN Personajes: CaiN y PatoBorracho Genero: Aventura, Fantasia, Humor y cuanta cosa se me ocurra jajaja Sipnosis: La historia se centra en Nikole Keitaro, una chica de 12 a\xf1os, qui\xe9n emprende un viaje en busca de la persona que asesin\xf3 a su padre, y tambi\xe9n para buscar el misterio se su origen.', False, True)
add('APTComic', 'http://aptcomic.smackjeeves.com/comics/', u'The random adventures of a catgirl named Ammika [who goes by PrincesTomboy the adorable oxymoron], and a bunch of other people. Updates Fridays - If anyone wants to contact me, my email is "PrincesTomboy@yahoo.com " Please note that it and my username are short for \'Princess Tomboy\', not the plural of a prince. -- Until I figure out how to add "tags", here have a large block of things. Ammika Inferno \'ferny Ferny Kumi Kumimi Ally The Pampered Alley Cat Adventures Heroine on Heroin Ember Alex Overcast Helena Foxx High Billy Sometimes Yellow My His Name is Bobby Bunni Bunny Rabbit Candi Candy Sweet Cat Fox Wolf Dog Chicken Sonic the hedgehog Kirby Furry Anthro Cat girl Catgirl So Many Tags Animal ears tail cute cutesy kawaii Keroro gunsou magic updates on fridays.', False, True)
add('AQuestionOfCharacter', 'http://aqoc.smackjeeves.com/comics/', u"Authors ([24/25]); Slash Segary Shard kitsune fire The Magnificent Z Snurple-the-Hedgehog gatemaster Ultimate the Hedgehog Coco the rabbit 101917 ZachLight aqua the hedgie Zero the hedgehog ClareSilver47 Xenocide contradiction123 TouhouShake DarkScarz DelSoul Nick Cypher The Flames HeavyArms_Spriter ;StardustFantasies; Legoalex-625 DaBrokor Dub_L_Eon canecacomleite REMEMBER, A MAXIMUM OF TWO OF YOUR CHARACTERS CAN ANSWER PER WEEK. -----PLACES OPEN UP EVERY SUNDAY AT 7PM EST (OR WHENEVER SHARD GETS AROUND TO IT AFTER A NEW QUESTION IS POSTED) IF ANYONE LEAVES/A PLACE IS MADE AVAILABLE----- THERE ARE CURRENTLY: 1 SLOT(S) AVAILABLE. IF YOU WISH TO APPLY FOR A SPOT, PLEASE SEND IN AN APPLICATION, EITHER VIA THE APP SYSTEM OR VIA PM TO Z OR SHARD. YOUR APP MUST INCLUDE YOUR REASON FOR WANTING TO JOIN AS WELL AS AN EXAMPLE OF (COMIC) WORK YOU'VE DONE IN THE PAST. REMEMBER, WE WORK ON A 'FIRST COME FIRST SERVED' BASIS, SO IF YOU DON'T MAKE IT THIS TIME, FEEL FREE TO TRY AGAIN IN FUTURE!", False, True)
add('ASongforElise', 'http://asongforelise.smackjeeves.com/comics/', u"Andi, Marcus and Elise are best friends since high school. But it hasn't been an easy friendship... And it will get worse. How much change will their relationship be able to deal with, whether it's love or death? A yaoi manga with all the EMO that it requires! ;)", True, True)
add('AYuriCollab', 'http://ayuricollabbitches.smackjeeves.com/comics/', u"Alright, so this is a collab, welcome to as many people who want to join. :3 This is a Yuri collab, so in other words, it's girl on girl. Don't like it, don't join it. Basic Story: Humans can have spirit protectors that arrive when they have life bad enough to protect them in partial human form (their spirit animal can be anything). Rules: Max of 3 characters State who you wish to reply to in comments When you apply, send a link of the character you would like to use for the comic NO FURRIES Thank you, and have fun. :3 I have the mature content warning on already just in case ;)", True, True)
add('Aarrevaara', 'http://aarrevaara.smackjeeves.com/comics/', u"Geir Himmelg\xe5rd doesn't want to have any friends, because he doesn't want to waste his time on something he must abandon one day... But when the teacher gives a teamwork to do, Geir sits on table of two people who will not let him go anymore. Updates on Wednesdays and Sundays!", False, True)
add('AchievementStuck', 'http://achievementstuck.smackjeeves.com/comics/', u'The main 6 Achievement Hunter members wake up in the game Minecraft with no knowledge of how they got there. The real game has started. Inspired by Homestuck and Minecraft (obviously). Updates every week. [ON HIATUS UNTIL AUGUST OR OCTOBER] Created by Squidlicious Website design by Geniusguy445', False, True)
add('AcidMonday', 'http://acidmonday.smackjeeves.com/comics/', u'REPRINT PREORDERS OPEN!! http://igg.me/at/acidmondayreprint/x/197012 PAGES FROM THE NEW CHAPTER POST EVERY TUESDAY + FRIDAY DURING THE FUNDRAISER. Before, Clover only knew Monday as the local acid addict. This changes after Clover snaps at him in the boy\'s bathroom. As fate would have it, Clover\'s mother forces him into a job at her rehab clinic as a mentor for none other than Monday. Is it fate bringing them together or is there some ulterior motive for the acidhead being at the clinic? Acid Monday was created on March 14, 2008, and completed January 19, 2010. This comic is rated 18+, though the main comic that is available online only has a handful of explicit pages. (The extra material in the book is NSFW) Other warnings also apply: drug addiction references, swearing, brief blood and violence, and gay sex yes. Please note that I made this comic when I was 17 and hadn\'t done a lot of research on LSD (acid) as an addiction. Turns out LSD isn\'t particularly addictive or as dangerous as some other drugs. The name sounded good though, so I went with it. ;D Just think of Monday\'s "addiction" as a delusional catalyst for a silly boys love comic.', True, True)
add('Adalsysla', 'http://adalsysla.smackjeeves.com/comics/', u'a fishgirl and a freckly guy in 17th century estonia are trying to find their loved ones, running into new loving friends (and enemies) along the way. updates wednesdays and saturdays! warnings for some occasional blood, nudity and such.', False, True)
add('AddictiveScience', 'http://addictivescience.smackjeeves.com/comics/', u'The day-to-day life of a mad scientist and her roommates, struggling with the daily crasy.', False, True)
add('AdventuresofLumandFriends', 'http://aolaf.smackjeeves.com/comics/', u'The daily life of a group of wild Pokemon. Join a Ralts, Gardevoir and Mawile on their eternal quest for food, money and TMs. May contain violence towards human trainers, other Pokemon and cannibalism. Mmmm Tepig...', False, True)
add('AdventuresoftheWeird', 'http://adventuresoftheweird.smackjeeves.com/comics/', u"Ally and Carly were just two normal girls until a catboy named Kuro fell from the sky in front of them. Along with a weirdo called Inu, the four of them have to find a way back to Kuro's world to stop a war. Random boyxboy moments here and there.", False, True)
add('AetherTheories', 'http://aethertheories.smackjeeves.com/comics/', u"Two conjurors face all kinds of supernatural foes, but their greatest challenge to overcome may be each other... Set in an alternate 1920's, Aether Theories follows Ambrose and his (somewhat reluctant) assistant Nekoda as they solve paranormal problems using magic. But something isn't quite right, and there are secrets aplenty between the unlikely duo. Will opposites attract, or will the skeletons in their closets be their end?", False, True)
add('AgeoftheGray', 'http://ageofthegray.smackjeeves.com/comics/', u'When the unseen war between heaven and hell finds itself bound to the plane of humans, several kids discover themselves caught in the middle. The almighty angels of heaven and the wicked demons of hell battle for their kingdoms, a revolution that could mean the end of humanity, and when god and the devil decide to take it into their own hands, only chaos can follow. Featuring a cast of familiar names such as Lucifer, Michael, Metatron, Lilith, and many more. Rated Mature for drug use. Updates every Sunday night.', True, True)
add('AllInLOVE', 'http://allinlove.smackjeeves.com/comics/', u'A young boy starts his new day in another school. This school isn\x92t like others. In this world, exist two species named Kay and Black Angel. Those species are in war, they can not love each other by there differences. This school was made for the two species gather together and make peace in to the world. Roy Figure (main character) is very different than anyone around him. A lot of things happened to him at his new school\x85 He is somehow special to others\x85 in the weird way. Website- http://uty-studio.wix.com/all-in-love Updates every Thursday.', False, True)
add('AllStarHeroes', 'http://allstarheroes.smackjeeves.com/comics/', u'(Massive video game crossover) The planet Corneria is under a constant threat of evil. The All Star Heroes, a team of six individuals with varying skills and abilities, are tasked with protecting this planet. The team consists of a Gremio from Suikoden (the leader), Billy Kane from Fatal Fury (the athlete), Ally Gator from Black & Bruised (the fighter), Coco Bandicoot from Crash Bandicoot (the tech expert), Toad from Mario Bros (the muscle) and Scorch from Army Men (the pyromaniac). Who will this team of six face next? It literally could be anyone.', False, True)
add('Allthatglitters', 'http://atg.smackjeeves.com/comics/', u'The members of the rock band celebrating in the a little pub, despite their troublemaker past someone \'ll undertake to be their manager. The band\'s singer, Istv\xe1n meet with "Andrea", who could change the band\'s future. BL love! Yaoi warning! :) It was a one-shot hungarian BL antology competition, mine didn\'t pass into it. So I\'ll draw other chapters.', True, True)
add('AloversRule', 'http://aloversrule.smackjeeves.com/comics/', u"SUMMARY.......... Oliver thought moving to America with Alden to peruse his dream as a musician was like a dream come true. He felt like the luckiest guy to meet Alden until one day his attitude began to change, becoming obsessed, abusive and controlling. When Oliver meets Julian, A retired military man, He believes that fate has brought them together through his music as he tries to develop a friendship with him. As a heterosexual man, Julian feels insulted by Oliver's approach and turned him down even though he felt something for oliver. Meanwhile, Jacob who is Alden's ex lover is filled with regrets as he reflects on his Past relationship with Alden. Finally realizing that he's still in love with him, he tries to find a way to break up Oliver and Alden's relationship. -----------------------WARNING------------------------------- This comic has really graphic sexual content. GENRES: Drama - Romance - Shounen Ai - Yaoi- boyxboy-some violence included, bad language. Comic status: Active Updates:Every day or Every other day! :) Reads: Left to Right", True, True)
add('AlwaysDamnedWebcomic', 'http://alwaysdamned.smackjeeves.com/comics/', u'"He\'s been single for as long as I\'ve known him and now that we\'re Seniors in High School, everybody and there MOM wants in his pant!?" Josh tries to confess his love to his childhood friend Demetrius, but it doesn\'t quite work out as he plans. Something or someone is always getting in his way! Will he be able to tell his best-friend how he feels? Or will he let himself be distracted from his goal? Silly comic that will try to update on Mondays (and maybe days in between!) WARNING! This is a BL (Boy\'s Love) comic with Het and GL (Girl\'s Love) as a side serving. Dirty (& improper)language, bad art, pingas, boobs. No smexy stuff yet, but its coming soon!', True, True)
add('AlwaysRainingHere', 'http://alwaysraininghere.smackjeeves.com/comics/', u'MOVED TO http://alwaysraininghere.com/ !! A totally original high school story about a couple of gay guys who annoy each other. Also massive amounts of UST. Updates every Thursday.', False, True)
add('Amaravati', 'http://amaravati.smackjeeves.com/comics/', u"Princess Itharelandriel Baer'Nathen quests to lift her brother's curse in any way possible, guided and protected by her new friends, Ryo and Lance. In this fantasy of magic and mystery, nothing is as it seems and the truth is buried in a tale that began over two thousand years before. --Updates when a college student can manage-- WARNING: Some language and violence may not be suitable for all audiences.", False, True)
add('AmorVincitOmnia', 'http://avo.smackjeeves.com/comics/', u"It is said, that on the day I was born an angel descended from the heavens. He delivered unto me a blessing... and a curse. Updates once weekly (Unless I say otherwise) (Oh, and most likely on weekends) Warnings: -This is a Bl comic. That means man on man action. So don't be suprised, 'kay? I may also do het and gl pairings later if I feel like it. -Rating WILL be boosted to mature later on. Also, it can be rated mature for anything. I like to keep my options open.", True, True)
add('AmsdenEstate', 'http://monsterous.smackjeeves.com/comics/', u"BL/YAOI COLLAB- SEEKING LODGERS~ --------------- An old safe house for hunted monsters and creatures is reopened for housing and living! (And not just for monsters anymore~) :D Come stay awhile~ we won't bite! ...Unless you want us to ;D", False, True)
#add('Amya', 'http://amya.smackjeeves.com/comics/', u'Amya is a high-fantasy graphic novel; following the adventures of a mute spell-touched and her unlikely companions as they are dragged into an adventure that is a little beyond them. Ultimately \x96 Amya is a story about self sacrifice for the greater good. It is also a story of how far one will go to obtain unearthly power; even if it includes throwing the world into a mythical war between fate and chaos. Amya updates every Wednesday.', False, True)
add('Anathemacomics', 'http://anathema-comics.smackjeeves.com/comics/', u'1810 England, the height of the Napoleonic wars. It was thought that humans walked the path of enlightenment leaving monsters and dark things behind. However, those monsters and night stalkers merely hide in the darkness, as a young maid, Bernadette, soon finds out.', False, True)
add('AngelBeast', 'http://angel-beast.smackjeeves.com/comics/', u'Celebrities vs Rare beast Chupacabra. http://angelbeast-en.blogspot.com/ This is a Japanese style manga. Please read this manga from right to left.', False, True)
add('AngelGuardian', 'http://angel-guardian.smackjeeves.com/comics/', u'Kyrsiel is a young apprentice of Guardian Angel. His teacher, Gersiel, is responsible he achieves a successful test mission to graduate. Moreover, Gersiel may not continue his evolution as Angel until Kyrsiel, who is his last student, graduates. And this is not easy! Both will play an important mission on Earth: Protect Midori, a young student girl, from the demons that are chasing her. . Will Kyrsiel do it successfully or will he fail again? Story and drawings: \xa9 Reenave http://reenave.deviantart.com Translated into English by: Louise Brown http://cast-into-the-abyss.deviantart.com/', False, True)
add('AnimalAdventures', 'http://animaladventures.smackjeeves.com/comics/', u'In a world similar to Pokemon minus the humans, intelligent creatures called Animals must use their amazing powers to save the galaxy. Many of the characters and storyline resemble things from various media. Contains action, violence, gore, romance, clean humor, adventure, possibly a few swear words, and extreme cuteness. Is read from left to right. This comic contains a lot of characters. Note: This comic does not update any schedule. I update when a new page is done.', False, True)
add('Animayhem', 'http://animayhem.smackjeeves.com/comics/', u"Twelve-year-old social reject Vera and her best friend Maggie love anime more than life itself. Too bad they live in a world that's hostile to the magic of Japanese cartoons. And go to a school that contains a portal to the Underworld. And have to fight demons when they could be cosplaying or watching a Princess Neko-chan marathon... Vera and Maggie's adventures with the occult are twisted, gory...and so absurd, they can only result in total Animayhem! Written and illustrated by JoJo, currently set to update every other day until there ain't no more pages!", False, True)
add('Anythingaboutnothing', 'http://www.anythingcomic.com/comics/', u'A collection of comics and cartoons about anything and nothing. Updates on Saturdays and Tuesdays :) Read one week ahead - http://tapastic.com/series/anything', False, True)
add('ArchportCityChronicles', 'http://tjs.smackjeeves.com/comics/', u'Archport City is the interdenominational hub and there are always stories to tell... This first one is what happens when you just have to get that picture... Dissatisfied on what was supposed to be a fun trip it was only a matter of time until adventure lured Joe in. Now a group of discredited bounty hunters with a dangerous target have dragged him along for the ride.. updates T and Thr..', False, True)
add('Area9', 'http://area-9.smackjeeves.com/comics/', u"Taishi Iwasaka had always dreamed of working in Area 9, a research facility surrounded by a huge wall that is famous for protecting the people from lethal viruses that have wiped out nearly half of the population. Feeling useless, Taishi has recently given up on his dream, but in a strange turn of events he finds himself trapped in Area 9 as a hostage with a crazy bomber called 'Bomb', who claims to be a terrorist who will blow Area 9 up if they don't hand over everything they own. Is there anything Taishi can do before it's too late? Just who is Bomb, and why does he want to destroy Area 9? Taishi will have to overcome his feelings of helplessness if he's going to do anything about it, as well as make a few shocking discoveries along the way. <<Reads from right to left<<", False, False)
add('AroundtheBlock', 'http://aroundtheblock.smackjeeves.com/comics/', u'Rooming with two old friends seemed like a good idea at the time, but Nase quickly discovered that his laidback lifestyle clashed with the daily shenanigans that happen on Floor 5 at 115 Green Lane.', False, True)
add('ArtofAFantasy', 'http://artofafantasy.smackjeeves.com/comics/', u"WARNING: CONTAINS BL/YAOI/BoyXBoy/MAJOR Mature content, and some swearing because certain characters think its cool. -_-' You were advised and warned. Rupert is the everyday, average nerd who just started going to a college away from home. He's skilled in almost every area, but he excels in the field of art. He also isn't that much of a people person. So when confronted with the threat of blackmail, he has no choice but to bend over(figuratively of course...-_^) for Evan, the jerkwad of the century. The detailed drawings in his mind lead to larger problems that he simply doesn't need. Will his drawings only bring bad luck, or perhaps give him good fortune?", True, True)
add('AtArmsLength', 'http://atarmslength.smackjeeves.com/comics/', u'The story of three magical ladies and their lives with their husbands, making it in the modern world and dealing with the occasional monster attack. Updated Tuesdays, Thursdays and Saturdays.', False, True)
add('Atlaswebcomic', 'http://atlaswebcomic.smackjeeves.com/comics/', u'The home of Gyan and Manu is about to literally fall apart. With the help of two friends they set out on a journey to save it. Their only hope are the 4 spirits that are said to have created the world. updates half a chapter every monday and friday!', False, True)
add('Autophobia', 'http://autophobia.smackjeeves.com/comics/', u'Louis Beau is a perfectionist and anxiety-ridden eleventh-grader attending Roseborough High. He lives with his strict and somewhat neglectful father, and constantly tries to best himself to make his father proud. His life, however, runs off course when he befriends Daniel, his ostrasized classmate, and the two soon find themselves in a secret love affair. Louis struggles with his sexuality, and his growing fondness of Daniel, all the while trying to gain the approval of his father, his peers, and ultimately, his self. [updates every Sunday] Autophobia is also available on InkBlazers with coloured pages! Updates every Tuesday & Thursday. If you\'re a fan of the comic, I definitely invite you to read it over there, as there are significant scene/dialogue that you won\'t want to miss! http://autophobia.inkblazers.com --- Warning: gay ppl, straight ppl, awkward ppl, a plethora of dialogue, profanity, sexual themes/content, and an absurd amount of fluff. *Mature content is on for some of the future themes explored, but there\'s nothing explicit. **It\'s labelled a "BL", but the story is not a typical "shounen ai" :U', True, False)
add('Aware', 'http://aware.smackjeeves.com/comics/', u"A journey through the multiverse by a wall-aware feline in order to find a scarf with the power of destruction. It can't really be that simple, can it...?", False, True)
add('AwesomeSauce', 'http://tdawesomesauce.smackjeeves.com/comics/', u"Stupid comics from the dark depths of TD's notebooks. View at your own risk. Updates never.", False, True)
add('AyaTakeo', 'http://ayatakeo.smackjeeves.com/comics/', u'A story about love and perseverance between a noblewoman separated from her lowly warrior, amidst a backdrop of a neo-classical Japan under invasion from spider mecha - but who is the true enemy? Artwork by Sonia Leong, story by Lloyd Prentice. Originally launched at Anime Boston April 2007 and due to run until Summer 2010, updated every Sunday. Printed version vol.1 available from Sweatdrop Studios!', False, True)
add('BLDShortComics', 'http://bldshortcomics.smackjeeves.com/comics/', u"Short comics with bLD's characters that most times will fill in gaps with information not on the main comic or simply complement the story. Most of them are intended to be funny, even though I'm perfectly aware I fail sometimes! Updates every Tuesday. Rated PG-13 due to some themes. It is suggested that you read their main storyline too so you'll know more about the characters - these short comics don't really tell the important parts in their story. http://bld.smackjeeves.com", False, True)
add('BLOT', 'http://blotcomic.smackjeeves.com/comics/', u"In the near future, robots fueled by human blood have begun their uprising - thankfully there's a few folks who won't take that sitting down.", False, True)
add('BabysittingFourDemons', 'http://babysitting4demons.smackjeeves.com/comics/', u'Ezz, also known as Ghost the Echidna on her Smackjeeves account, has become a babysitter. She\'s finally on her own, and starting a nice, steady babysitting service at her home. Little does she know is that the children she is to babysit happen to be four demons... Who are these four? Why, none other than Sonic, Amy, Knuckles and Tails! Open Author Spaces: NONE. DON\'T EVEN ASK. Don\'t even request. Don\'t comment "CAN I JOIN LAWLZ" or I\'ll come after you. Thanks! -Hope Status: No one banned. Please start updating more, people. I\'ve made up my mind that I\'m gonna update more, you guys can help out too. -Hope', False, True)
add('Babywhatsyoursign', 'http://babywhatsyoursign.smackjeeves.com/comics/', u"UPDATES FRIDAYS~ Sometimes even more often! : o Christian and Liam are brothers going to the same prestigious high school. Christian has a big crush on one of his classmates, Tristan. Liam has one on Dominique. But, Dominique's twin brother, Colton has a thing for Liam. My goodness! Not only is there a ridiculous amount of gay and the drama of high school crushes and love triangles, there's also a little detail that has yet to be mentioned. Tristan, Dominique and Colton are only a few members of a large group of individuals keeping a huge secret. A secret that's full of power. But, the last time this secret got out, it put an end to many people's lives. This secret can not get out again. And there are some people who will make sure it won't. CONTENT ADVISORY: Online Comic will not contain anything visually explicit. There is cursing here and there and general sexuality. YES. BL. GAY. YAOI. WELL, MORE LIKE SHONEN-AI. ALSO SOME STRAIGHT. <3", False, True)
add('BadassRiz', 'http://badassriz.smackjeeves.com/comics/', u"Stories about Riz and her weird friends, Tsuno and Mullet Guy. Note: I'll be reposting old comics until I reach where I last left off. Then I will draw new stuff!", False, True)
add('BallandChain', 'http://ballandchain.smackjeeves.com/comics/', u'Sliver is as a modern-day gladiator who fights with a ball and chain. Her life takes an unexpected turn after she meets Dorioth, a scatter-brained pick pocket thief. The story takes place in the wake of a nuclear disaster, which has brought forth the generation known as "Nuclear Babies" (people born with strange mutations). Updates irregularly!', False, True)
add('Bard', 'http://barred.smackjeeves.com/comics/', u"So; A centaurian bouncer, a tomboy sheep, a bearded human, a squishy thing, a transgender ghost, and a dog with big boobs walk into a bar. The bouncer walks up to the bar, and orders a drink. The manager chides him and the others on being late to work, and then some sort of punchline occurs. I dunno. I'm working on it. Cameo details on this page: http://barred.smackjeeves.com/comics/569893/closing-call/", False, True)
add('BassComicAdventures', 'http://basscomicadventures.smackjeeves.com/comics/', u'A sprite comic that follows the (mis)-adventures of the Capcom characters of Bass, Mega Man, and the rest of the group. Featuring original storylines, new characters, a fresh take on the classic games, and some potential amusement. Updates on Mondays, Wednesdays, and Fridays', False, True)
add('BattleSequence', 'http://battlesequence.smackjeeves.com/comics/', u'Trainer Rayne is working hard to train her pokemon to be the best they can be. Is she tough enough to take on all of these new challenges? Follow along with her on her journey to be the very best! UPDATES: Every friday. WARNING: This comic contains adult humor and suggestive actions.', False, True)
add('Bearhoney', 'http://bear-honey.smackjeeves.com/comics/', u'Everyday adventures of Bear and Honey. A new adventure every weekend!', False, True)
add('BearlyAbel', 'http://bearlyabel.smackjeeves.com/comics/', u'Abel is a American-Asian boy with an active imagination. He lives with his mom and sister and goes on adventures with his bear, Barry. This webcomic ran from August 2008 until Oct 2010.', False, False)
add('BeautifulLies', 'http://beautiful-lies.smackjeeves.com/comics/', u"Action, Drama, Psychological * Contains some mature contact such as profanity, violence and blood/gore. It's a story about a group of adolescents living dull or miserable lives who seek comfort in their own fantasy world. They all encounter a similar situation which transports them to a lawless, fantasy world that shapes itself to their inner desires. There is no time to age them, no rules to control them, no authority to subdue them. As they search for a way to return to the real world, they begin to question if they want to leave at all.", False, True)
add('BehindTheObsidianMirror', 'http://obsidian-mirror.smackjeeves.com/comics/', u"If you were to awake in a place unknown to you, without remembering anything... you would be happy to be taken in by someone, right? But what if this someone was a god? Aztec gods and BL. What more could you want? x3x Warnings for homosexual content, blood, violence, and possibly gore and sex in the future. Don't like, don't read. UPDATES EVERY TUESDAY!! Although I have read a lot about Aztecs and their culture and mythology, I am hardly an expert on that subject. So forgive everything that might be off, or wrong, since I actually don't bother to get everything right or just change things to my liking. The Aztecs and their religion etc. depicted in this comic are far from realistic, and don't aim to be, although I'm trying to make it all seem plausible. Just so you know. Enjoy. ;) Remember to read from right to left, Japanese reading order. ;) Sketch/WIP tumblr: http://teejaystumbles.tumblr.com/", True, True)
add('Behindtheglasscurtain', 'http://g1ass.smackjeeves.com/comics/', u"Scarlet spent all her life in a dismal, dark prison that just so happens to be located in a dismal, dark realm bereft of all flora and fauna. One night she ignores the frog's rule to never look out the window when darkness approaches. What she sees next will change her life and everything she once knew. It's a comic that delves deep into other character's lives and reflects on their back stories. Even though the main story seems to branch off to smaller stories, there is a basic plot, which the reader has to decide on. updated on weekends, but best to check it on Monday. It's finished! COMPLETELY FINISHED! Don't keep on checking for updates. Yes the first 100 pages looked like crap but mind you I started this when I was 14!", False, True)
add('BeretCatComics', 'http://beretcatcomics.smackjeeves.com/comics/', u"A comic about video games. Because there aren't enough of those already. Updating on Mondays and Fridays.", False, True)
add('Bestbrosforever', 'http://bestbrosforever.smackjeeves.com/comics/', u'A story about two dorks', False, True)
add('Betovering', 'http://betovering.smackjeeves.com/comics/', u"Alex's family from his mother side are witches, but only women are. But somehow Alex turn out to be an exception. He's life has not been the best, but after someone confesses his love for him, things turn out to be interesting and dangerous. BL/Romance/Fantasy/Drama", False, True)
add('BettencourtHotel', 'http://www.welcometobettencourt.com/comics/', u'"You are advised not to leave your room from midnight to 2 a.m." A little horror story about pretty boys working in a murderous hotel. Some shounen-ai. ~Updates on Fridays~', False, True)
add('BetweenLightandDark', 'http://bld.smackjeeves.com/comics/', u"The adventures of 13 friends as evil turns against them. (Or they go looking for trouble, that's more like it!) Fantasy and adventure webcomic with some humor and romance in the middle. Updates every Sunday and Wednesday. PG-13 due to language here and there and some themes. There are also short comics updating every Tuesday here -> http://bldshortcomics.smackjeeves.com It is not mandatory to read those to know important things in this, but some strips are intended to be connected to the story!", False, True)
add('BetweenWorlds', 'http://betweenworlds.smackjeeves.com/comics/', u'It is the 80th birthday of the benevolent tyrant, King Bergan. His four loyal knights prepare to march in his honour, but all is not well. The senile ruler, plagued by hallucinations and delirious dreams, begins to cast strange allegations of witchcraft on one of his most loyal servants, the knight named Lynx, the soldier named Juno...', True, True)
add('Betwin', 'http://be-twin.smackjeeves.com/comics/', u'Be-Twin is an amateur comic which smells of powder, shootings, and the mafia. Its true premise however, centers around two destinies which have, with difficulty, found their place in this dangerous world. Two individuals who are different in every way\u2026 or perhaps\u2026 not very different at all. I upload pages every two weeks, on Sundays. I\u2019m French, so please forgive any mistakes I may make. I really wanted to share this story with my non-French readers. ;-; Thank you so much for reading... >w<', False, True)
add('BeyondTemptation', 'http://beyondtemptation.smackjeeves.com/comics/', u"An accidental meeting turns Reimee's life up and down. She finds herself in the middle of an affair regarding enslaved demons, magical artefacts and many temptations of the modern world. Will she get tempted? Or will she be the one to tempt? And finally, will she find what she's looking for in the Eternal City of Rome? Inspired by eastern folklore, religion, Grimm tales and life itself, set in modern times Rome it's a paranormal action romance in which the borderline between good and evil is very thin...", False, True)
add('BeyondTheOrdinary', 'http://bto.smackjeeves.com/comics/', u"This comic will feature Beive Ramn who's new to town after her father died. Her mother wanted her to get away from her old life and while everything seems to be pretty calm; it's not. Mystical creatures, mythological beings and Swedish folklore.", False, True)
add('BioRevelation', 'http://biorevelation.smackjeeves.com/comics/', u'Ever wonder what would happen if cloning was made legal? What could they do for mankind? Would they have the same rights as natural born people? Bio-Revelation tells the story of a distopian society of corruption, theocracy, and the underdog. Follow the story of Trevor Watson and his friends battle against the religious fanatics known as the FOH to gain the freedoms they dream of.', False, True)
add('Bl3', 'http://bl3.smackjeeves.com/comics/', u'Mostly a crossover of BLEACH and BLAZBLUE (the title may be read as "bl3" or "bleablazblue") All characters here are the property of either Tite Kubo or Arc Systems Works, particularly Toshimichi Mori. There is one original character, but half of that is owned by Daisuke Ishiwatari. This takes place between the Deicide and Lost Agent arcs of BLEACH. Please read RIGHT TO LEFT, like a Japanese manga.', False, True)
add('BlackDragon', 'http://blackdragon.smackjeeves.com/comics/', u"Since mankind has subjugated dragons, men struggle for power by using dragons. Sora also wants to become a dragonrider and so he climbs the Dragon-Mountains to catch a dragon This is a manga. Read from the right to the left! If you can't wait, you can get the complete Manga on Amazon: http://www.amazon.com/dp/B007NZGBZ8 http://www.amazon.com/dp/B009MOQLLM http://www.amazon.com/dp/B00BRJHPTW http://www.amazon.com/dp/B00EMHWJVK Update: one chapter per month", False, True)
add('BlackFridayRule', 'http://blackfridayrule.smackjeeves.com/comics/', u'', False, True)
add('BlackSheepcomic', 'http://black-sheep.smackjeeves.com/comics/', u"------------------------------------------- Contains disturbing and/or violent images. I'm not held responsible for any repercussions you may get from reading this. ------------------------------------------- Black Sheep tells the story of a man delving into a hell personal to his own in his journey to unravel the secrets of Rabbithole, a land of promised paradise and granted wishes. ------------------------ Smackjeeves updates once every two weeks. Visit blacksheep.inkblazers.com for updates every week. Read left to right. ------------------------", False, True)
add('BlackandBlue', 'http://black-and-blue.smackjeeves.com/comics/', u'A sci-fi fairytale. A boys nightmare. So, this is about an Evil Empire soldier with a few problems... not the least of which is a slight gender issue and a weird entanglement with an astronaut. Awkwardness ensues. D: I thought "The Crying Game" was a comedy, you\'ve been warned. Ha! e_e Also I started this about 200 years ago and the art is pretty rough I\'M SO SORRY! ;_; FORGIVE ME!', False, True)
add('Blackdemon', 'http://blackdemoncomics.smackjeeves.com/comics/', u"everyone has a demon inside them, even the nicest people in the world has a demon. what happens if the demon inside takes total control of you? it could effect your life style, personality, and for artist's; imagination. that's what this comic is about. a girl with poor social skills and a large imagination, how will she fix both problems? (WARNING:some chapters in this comic are based on real events that occurred in the author's life) comic updates:Monday's, Wednesday's, and Friday's(if not updated, that means i got a LOT of HW or my laptop is damaged)", False, True)
add('BleachRedux', 'http://bleachredux.smackjeeves.com/comics/', u"Myself and others were extremely disappointed with Ulquiorra's death in the official Bleach manga, so I've taken it upon myself to draw out what could've possibly happened had Orihime pulled her head out of her ass and saved him. WARNING: UlquiHime. Any negative comments (or futile attempts at validating other ships that make even less sense (ie: IchiHime)) will be deleted. NOTE: READ RIGHT TO LEFT LIKE JAPANESE MANGA.", False, True)
add('BlindandBlue', 'http://blindandblue.smackjeeves.com/comics/', u"Boy's Love! (Gay relationship romance) Caecus (Case) woke up one morning to find that he was completely blind. He's picked on by the school bully, and things aren't so great. Fortunately for Case, he finds a friend - and eventually a boyfriend - in the new kid, Darryl, and together they make it through the things life throws at them. A smackjeeves mirror to the comic on DrunkDuck, which you can read [url=http://www.drunkduck.com/Case_1048_Blind_and_Blue/]here[/url] Comic contains swearing very rarely,so if you don't like it...you'll be fine actually And if you're homophobic...message me with your reasons why as I am very curious on the topic.", False, False)
add('BloodhuntersBirthofavampire', 'http://bloodhunters.smackjeeves.com/comics/', u".In a world full of vampires and monsters only the hunters can protect the humans. Their job's to eliminate everything that seem to be dangerous. But really every nonhuman being's evil? The story's following Dren,a young vampire who's different from the other vampires both in nature and abilities ( and eats fruits?) Continuation in the comic Bloodhunters. You can read it here: http://www.smackjeeves.com/comicprofile.php?id=142255 Read from left to right", False, True)
add('Bloodyfairytale', 'http://yaika.smackjeeves.com/comics/', u'Contains (yaoi, boylove, blood and others) I will only update once a week from now on. : ) But if I have time and energy to it, I will update twice a week.', False, True)
add('BloomaPokemonConquestComic', 'http://bloomconquest.smackjeeves.com/comics/', u'According to the Legend of the Ransei region, if all 17 kingdoms of the region are united, the legendary Pokemon that formed the region would appear. Young Saku, along with her stubborn Axew, set off on the road of conquest. However, the warlord Nobunaga is only one kingdom away from uniting the region. Can Saku conquer Ransei before he does? ______________ There is a bit of violence later on, but hey, Pokemon has a certain lack of violence that they need to make up for. Nothing too bad. Also, I am constantly improving, so please ignore the bad art at the beginning. >.< Pokemon (c) Nintendo Updates Wednesdays and Saturdays. **Temporarily updating irregularly-see news for more details', False, True)
add('BlueHair', 'http://bluehair.smackjeeves.com/comics/', u'', False, True)
add('BlueWell', 'http://www.bluewellcomic.com/comics/', u'Leif Kavanaugh grew up in the country-side and came to the city to attend college. He moves into "The Blue Well" boarding home, which houses several other college students just like himself. While he hopes everything will go smoothly, Leif learns it\'s not the city that makes life crazy, it\'s the people.', False, False)
add('BoilingPointofBrain', 'http://bpob.smackjeeves.com/comics/', u"The company 'Brain' is going through terrible waves of financial depression as their only client 'Erika' has succumbed to the roadblocks in life. It is up to Sir and the Intern as well as the employees to help their client get back up on her feet.", False, True)
add('BoogeyDancingMonkeyPot', 'http://monkeypot.smackjeeves.com/comics/', u'A story about a race of dark creatures known as Boogey men. Their world is falling apart by war and horrors untold. With a King falling down a path of no return, an hero trying to save the people, and a human girl thrown into the mix its a dramatic and action packed story. The characters learn many hardships and struggle to over come their own dark desires.', False, True)
add('BreachofAgency', 'http://breachofagency.smackjeeves.com/comics/', u'Panacea has the gift of healing, which makes her a target for both sides of a civil war. The Minister, leader of the Agency, is determined to have her cure his fatal illness and prolong his life. Forever. But the Gunman and his accomplices want her dead. All Panacea wants is to find her own destiny. When she and her bodyguard, Aegis, stumble upon Traver, who takes them in after they narrowly escape a brush with death, Panacea believes she may have found a real home. But the Agency has eyes everywhere, the Gunman is always waiting in the shadows, and Panacea can never be sure who her allies are.', False, True)
add('BreakfastonaCliff', 'http://boac.smackjeeves.com/comics/', u'A boy named Cinna goes to a new school. See what happens! Updates: Fridays Or any other time ending with "day."', False, True)
add('Burn', 'http://burn.smackjeeves.com/comics/', u'Spunky young college student Darryn Gainnes has just turned 20, and decided to tone his wild ways down a bit. All he needs in life are his two best friends, their band, his books, and his music. He thinks nothing of it when he literally bumps into a pretty (and gloomy) High-School-boy at the park. But soon, Darryn finds himself swept up in a world he had never even known existed, a world of intrigues and violence and magic! And of course what is sweeping both boys off their feet is their budding romance... and so many incredible obstacles thrown in their way. Where will it all lead? Who is on their side... and who will be left standing? .:. 3rd place in the "Drama" category of the 2013 Smackie Awards! ^_^ WARNINGS: Occasional violence, "bad" language. BL: This is a Boys\' Love/Yaoi comic! If you don\'t like those, don\'t read this one! DIRECTION: This comic reads right to left, for no other reason than that I like it that way. ALSO: I never have as much time as I would like, so for the most part this comic is pencil sketches and a bit of Photoshop. But I hope you enjoy it. ART: Improves as you go along! I promise. I started this thing a long time ago. ^^;', False, True)
add('ByTheBook', 'http://bythebook.smackjeeves.com/comics/', u"After stumbling across a copy of 'The Adventurers Handbook 3.5' an orc, goblin and kobold decide to leave the dungeon and become mighty adventurers! Updates every Wednesday and Saturday.", False, False)
add('CafeAmargo', 'http://cafeamargo.smackjeeves.com/comics/', u'Domingo Ramirez has lost everything; his family, his job and happiness. The only thing he still has left is bills to pay. Even though his future seems worse than death itself, he decides to keep strong and search for his "light of hope" that appears even in the darkest and most difficult situations, but, the shape of that light is not what he was expecting... Set in the year 1939 in a country of South America. C\xf3mic en Espa\xf1ol: http://cafeamargo.subcultura.es/', False, True)
add('CafeSuada', 'http://cafesuada.smackjeeves.com/comics/', u"Down by the riverside there is a quaint little teahouse run by our heroine, Geraldine, who's only desire is to spread her love of the golden beverage - But what's going to happen to her business when a new coffee house springs up right next door?! And what is the meaning of Cafe Suada? Guess you'd better read and find out, huh?", False, True)
add('Cambion', 'http://cambion.smackjeeves.com/comics/', u"Beware the Cambion. The demon longs for the taste of newborn flesh and has called away many a fair maiden to beget them with child just for a taste of it. Be cautious of his sweet words and promises. A Cambion can never defy it's nature. Warnings: Will contain MxM MxF and FxF(possibly) Also graphic blood/violence.", True, True)
add('CaptiveSoul', 'http://captive-soul.smackjeeves.com/comics/', u'A BL Pirate manga! :P Sai works on the ship "The Liberty", he was taken in at a young age after his town was burned down and he lost his family. The event was traumatizing and Sai lost his ability to speak. He has sworn to hunt down the pirates that destroyed his home and bring them to justice(however that seems a long ways away) However, recently the captain of the ship, Kuragi, has taken an interest in Sai! Will Kuragi\'s advances distract Sai from his goal to avenge his family? A stormy relationship ahead! Will update every Thursdays :D', False, True)
add('Captor', 'http://captor.smackjeeves.com/comics/', u'3 new pages every Sunday!', False, True)
add('CaravanaTaleofGodsandMen', 'http://www.caravantale.com/comics/', u"In a world of magic, mystery, and mayhem a sickly child and her protectors will attempt to transverse great deserts and expansive grasslands to reach the sea, and a hope for a cure. A witch, her sole purpose to protect the girl. A scarred man, beholden to the child who holds his stolen name. With each step they're drawn further into a mystery that will unravel truths about the lands in which they live. What will this world hold for them? Only time will tell.", False, True)
#add('Carciphona', 'http://carciphona.smackjeeves.com/comics/', u'In an era where magic is forbidden, a sorceress struggles to restore her once peaceful life.', False, True)
add('Cataclysm', 'http://cataclysm.smackjeeves.com/comics/', u'Set on the last remaining hospitable island on a frozen world, a covert faction known as Militia attempts to overthrow a utopian civilization and their benevolent rulers, The Council.', False, True)
add('Catnip', 'http://catnipmanga.smackjeeves.com/comics/', u'Ikita is a young and impressionable noble, who has been bound to a young lady by arranged marraige. Felix is his hired bodyguard; a quick witted and reliable one at that - but who has more to his past than he would like to reveal. As Felix follows Ikita as his bodyguard, they start to have mixed feelings about their positions, and where the future may lead... Based in an 19th centrury-esque alternate history, this tale consists of friendship, compassion, love and regret.', True, True)
add('Cerintha', 'http://cerintha.smackjeeves.com/comics/', u'The Empire is dying and barbarians are on the move. As the age of darkness seems imminent and inevitable, the people of this transitional world move to protect their interests.', False, True)
add('ChampionofChampions', 'http://championofchampions.smackjeeves.com/comics/', u"COC: Requested Matches and Round 2 are down until the month of August. Round 1 and Round 3 are available to read. WARNING: This comic has blood and gore. Viewer discretion is advised! Its like the Mortal Kombat of Sprite Tournaments! If you like over the top, nonsensical action and glorious potrayals of your favorite characters, then this comic is for you! This webcomic puts you, the reader, in a tournament called: CHAMPION OF CHAMPIONS! It's not your average sprite fighting tournament! 18 characters are chosen at random and you get to decide who wins and who loses. All characters were picked at RANDOM meaning that you will get to witness fights that you have never seen before! Sonic the Hedgehog vs Ghost Rider! Naruto vs Nightcrawler! Superman vs Thor! Vegeta vs Ken! Kirby vs Super Buu! Jin Kazama vs Ryu! The list goes on and on! Voting is limited to once per day. Also, this comic has major focus on action. DISCLAIMER: ALL SPRITES BELONG TO THEIR RESPECTIVE OWNERS, I TAKE OWNERSHIP FOR NOTHING! I'M ONLY MAKING THIS COMIC FOR FUN!", False, True)
add('ChampionsandHeroesAgeofDragons', 'http://championsandheroes.smackjeeves.com/comics/', u'In a land far away, or possibly in a dimension just next to us, lies the lands of Thedas. The world of Thedas is made up by endless possibilities - a man can be a mage, a rogue, a warrior, even a woman. From the Free Marches to Ferelden we find champions and heroes saving the world... poorly. Updates Mondays. Also available on tumblr http://championsandheroes.tumblr.com/ All hail Bioware.', False, True)
add('ChannelDDDNews', 'http://dddnews.smackjeeves.com/comics/', u"Ah, the loyal Reporter Dees, risking life and limb to get a story on air. This comic is a tie-in with Kirby's Dream Adventure, so expect to see the same characters bouncing back and forth! [[Updates Monday through Friday]]", False, True)
add('ChaosAdventuresII', 'http://chaosadventuresii.smackjeeves.com/comics/', u'Creds to: Characters Chaos/Halo - Master Rezz - Nebula Ki - Megablueblastaa Tails - Hypero Sarah \x96 Foxx Etch \x96 No Details Blur - Cylent Nite Thorn/Young Thorn - Cylent Nite Omega - Hypero (customised by me!) The demons - Gardow Styxs - Sakura Courage Solo Backdrops- Wacky Workbench Zone - Shadowbot Green Hill Zone - kinny-man Chemical Plant Zone - Domenico Sky Canyon - kinny-man Emerald Alter - Apocalypse the Hedgehog Angel Island Zone - SkyLights Other Tails\x92 plane - Rogultgot', False, True)
add('ChaosTheory2005', 'http://chaostheory2005.smackjeeves.com/comics/', u'An old sprite-comic I created back in 2005, featuring the adventures of Typhoon the Hybrid and his time with the Sonic Boom Team. This consists of Series I, II, and the short-lived Series III, from 2005. Series IV was started in 2014.', False, True)
add('ChaoticNation', 'http://chaoticnation.smackjeeves.com/comics/', u'Karians were first born during the cataclysm. Once human, the race mutated. They became stronger, faster, and changed in physical appearance and magical ability. In a world already devastated, a rebellion rises to defend the dwindling human race from the growing fear of the Karian army. Their one hope may lie in a mysterious mage whose kind heart has the courage to stand against the oppression and torture brought on by the impending war. WEEKLY UPDATES ON TUESDAYS Contents - Nudity, Language, Violence, Blood and Gore, Hentai, Yaoi', True, True)
add('Charaktermaske', 'http://charaktermaske.smackjeeves.com/comics/', u"April 16th, 2012, in a midwestern city, at St. Cuthbert's School, a device is set off to create a door between universes. Things go rapidly downhill. This comic includes magic, superpowers, stories, queers, losers, winners, and drunk old people. Updates Monday and Fridays", False, True)
add('Chatuplines', 'http://chatuplines.smackjeeves.com/comics/', u'Welcome to "Chat-up lines"! A South Park Doujinshi from CraigTucker and me. Pairing: Craig x Stan Story: Stan hates Craig and his friends are fags! They haven\'t time for him.. Bad friends.. But in a chatroom.. he meet a guy.. and he is cool. ..and they will be friends... !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! PART 2 !!!! http://www.smackjeeves.com/comicprofile.php?id=121933 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! WE LOVE YOU!', False, True)
add('CheneysGotaGun', 'http://cheney.smackjeeves.com/comics/', u"Cheney's back! Ever wonder what Dick Cheney is doing in his secure undisclosed location? The Hunting \ufffdaccident\ufffd was only the beginning. Dick Cheney has now found his true calling. Tag along as the vice president cleans out his guns, and dusts off the ammo boxes as he fights his way through a world of terrorists from Cidy Sheehan to Osama Bin Laden. This is a graphic novel I did a few years ago and have decided to give it a rerun.", False, True)
add('ChickenScratches', 'http://chickenscratches.smackjeeves.com/comics/', u'A slice of life 4-panel comic. A journal about a young man and his troubles in life. Updates Monday to Friday. Sunday is a Sketchbook entry.', False, True)
add('ChildrenoftheNight', 'http://cotn.smackjeeves.com/comics/', u'Vampires are at the brink of extinction ruled with a heavy hand by the Hunters, an order of vampire slayers that has existed since the beginning of mankind. The centuries-old law is very clear; a vampire can only feed off criminals whose names are on the lists provided by the Hunters. Any other interaction with humans means punishment and even execution if they are harmed. But when an unlikely friendship between a human girl and a vampire starts to grow into something much deeper, can these laws be obeyed? CotN is a romance webcomic set in the Victorian Era, depicting forbidden love amidst a clash between vampires and the Hunters, an order of vampire slayers. :It updates every Monday:', False, True)
add('ChimiMouryou', 'http://cmmr.smackjeeves.com/comics/', u'Near the top of one of Japan\'s many mountains away from all the human villages, there is a forest inhabited by youkai who are constantly learning how to deal with each other. Basically, "The Daily Lives of Crazy Youkai" This comic is a bunch of random short stories and not one continuous one. Everything is acted out in pantomime AKA there are no written words. Chimi mouryou can be roughly translated as "evil monsters in the mountains and rivers". The legend of it keeps the forest safe from humans. I am still researching more about the Edo period and youkai, so I apologize for unintentional inaccuracies. For now, the updates for this comic are random. I apologize!', False, True)
add('ChocolatewithPepper', 'http://chocolate-with-pepper.smackjeeves.com/comics/', u"The story takes place in the 1920s in a lovely small town called Ventura, in Brazil. Its economic growth depends on a local chocolate factory called Bombom, which is very famous for its chocolate. Ana Francisca is a beautiful young girl, but she is from a poor family. She hides her beauty with big glasses, old hairstyle, and outdated clothing. She lost her parents not too long ago and moved to Ventura to live with her other family members. In that family, there are her Grandma Carmen, Uncle Margarido, Cousins Marcia and Timothy, and Dalia, who was accepted into the family. Ana helps out at home until she is accepted a job to work as a janitor at the Chocolate Factory after school. There she meets Ludovico, the factory owner who pretends to be one of the workers at the factory. Ludovico returns to Ventura to investigate his greedy sister Jezebel, who lives like a queen after taking over the factory. While Ana's in Ventura, she falls in love with Danilo, the town's flirt who has dated almost every girl in town. However, his main love interest is the beautiful girl, Olga. Although he says he never fall in love, will that possibly change after meeting Ana Francisca?", False, True)
add('CityFolk', 'http://cityfolk.smackjeeves.com/comics/', u'Tired of a dull life in the wilderness of British Columbia, a beaver and a moose make the trip of a lifetime; into the heart of the city. This is their story.', False, True)
add('ClairetheFlare', 'http://clairetheflare.smackjeeves.com/comics/', u"Claire is new to this whole superhero thing, but she knows what it's all about. Getting famous! But with veteran heroine Bulldozer breathing down her neck its not going to be easy. Updates Three Days a Week! Monday, Wednesday and Friday.", False, False)
add('CleanCure', 'http://cleanpluscure.smackjeeves.com/comics/', u'-A few hundred years into the future, life has changed, but remained relatively the same from a social standpoint. Various government plans to deal with the changing global climate ended in many successes, but many more failures. As a result, certain mutations began to appear in humans as well as animals, and though most were bred out, some remain to the present. -Enter Ezra and Percy; two young men, cat-boys in fact, whom are facing a tough time not only surviving day to day, but making their dreams a reality. After losing their current job, they are offered a new one by a seemingly normal, but secretive man with a lot of money. Their new boss employs them as maids, frilly dresses and all, and makes them clean his and the mansions of others. It quickly becomes apparent that their boss is more interested in the ever mutating rat-like creatures which are making their homes in the dirty world of military cover-ups and powerful family connections. When these two get caught up in the lies and secrecy of their new occupation, will they be able to escape? And what is the connection between mutations and the incident 20 years ago?', False, True)
add('ClockworkAtrium', 'http://www.clockwork-atrium.com/comics/', u'In a misguided attempt to develop their full potential for success, students at a German university are forced to participate in a campus chess "game" in which they are the pieces and the captures could consist of murder. Updates Sundays.', False, True)
add('CloeRemembrance', 'http://cloe.smackjeeves.com/comics/', u"This story is set in the victorian era. Liam is an 11 year-old boy that arrives to a wealthy mansion to work with his father, the gardener. In this place he is asked to be the playmate of the youngest master, Edward, who's about his age. However, Edward turns out to be a spoilt and malicious kid that wants to keep all the attention to himself... What will Liam do to gain his trust and become his friend? ---------------------------------------- This is a young love shounen-ai (boy/boy) Manga format: *Please read from right to left* THIS STORY IS ALREADY FINISHED!", False, False)
add('CockroachTheater', 'http://cockroachtheater.smackjeeves.com/comics/', u"If it can't be told by cockroaches, then it ain't worth the telling.", False, True)
add('Cogs', 'http://cogs.smackjeeves.com/comics/', u"Kid wakes up with amnesia and surrounded by beasts. Next thing he knows he's enrolled in the worlds most inhumane school, Cogs. Children of Genetic Science. I have literally no idea whats going on! Updates Mondays, Wednesdays & Fridays @ 5 PM", False, True)
add('ColorBlind', 'http://cbcomic.smackjeeves.com/comics/', u'Five 13-year olds discover a world that makes theirs seem grey in comparison in a closet at their school. It is a world of magic, and adventure, and a war that the kids might have gotten sucked into accidentally. Main Site: http://colorblindcomic.com/ Updates are Mondays and Fridays.', False, True)
add('ConventionalWisdom', 'http://conventionalwisdom.smackjeeves.com/comics/', u'Ever wondered what goes on inside an anime convention, but are too afraid go anywhere near one yourself? Well, wonder no more! Conventional Wisdom is a comic that shows you what this strange, geeky world is really like, based ENTIRELY ON REAL LIFE! ...well, sort of. (Currently moving over from DrunkDuck, so please be patient)', False, True)
add('CosmicDash', 'http://cosmicdash.smackjeeves.com/comics/', u'Follow the adventures of the crew of the Lucky Strike, a cargo-ship exploring a shifting galactic landscape.', False, True)
add('Cramberries', 'http://cramberries.smackjeeves.com/comics/', u"Lucinda is just a normal girl who lives with her roommate in an apartment... until her childhood friend came back to visit here. Now, she has been cursed with a demonic eye and almost everyone seems to be after her. Could it be her eye that everyone is after or is it there something more to it? Follow Lucinda and her friends as they uncover dark secrets and traverse their way along a perilous journey filled with all manners of action, humour, evil and good, love and stupidity. Updates Monday, Wednesday, and Friday @ 13(EST) (Might not always update on time) KitKatMuffin: Artist and Creator Seranatis: Editor and Assistant NOTE: The Editor sometimes post some random art and leaves messages when I'm not available on the website; regardless, they are NOT canon.", False, True)
add('CrimsonWings', 'http://crimson-wings.smackjeeves.com/comics/', u"Devon Rider was just another normal kid with evolving problems in a quickly changing world. The government had fallen and shape-shifting hybrids called Alphas were stationed everywhere, changing everyday life and bringing back physical punishment. However, Devon has a hard time adapting to the New Order and before he knew what happened, he found himself in even more trouble then he ever could have imagined. Turning into a mutant himself, he finds himself with more responsibility than he could ever dream to handle. And to make things worse, the New Order has plans of wiping the human race off the face of the earth. Can Devon and his friends even survive the next year of the rapidly changing world? I'd rate this story as 14+ due to language, realistic and fictional violence, and gore. This story is told by the point of view of a teenage boy, and it contains war and several violent sci-fy elements. This comic reads left to right and will be updated on MONDAY(for now) This story is mainly an experimental trial for me and will mostly be for practice. So the art and the storyline will not be my best or stylistically consistent but will hopefully evolve as I improve!", False, True)
add('CrocodileTears', 'http://crocodile-tears.smackjeeves.com/comics/', u"Violence? Check. Bad language? Check. Twisted sense of humour? Check. Lots of booze? Check. Busty ladies and hot guys? Check. Crazy reptilians? Check. Surprise buttsex? Check. ... on second thought, we'll keep the booze. But you can have all the rest ;)", True, True)
add('CupofOlea', 'http://cupofolea.smackjeeves.com/comics/', u"Cup of Olea is a text-based adventure game inspired by Lunar Hill! Take command of Cliff Gradel and his friends to serve your land and your king! And don't worry if you get confused; it makes the adventure that much more fun. Just submit a command on the latest page and see what happens! Updates Wednesdays and Sundays. Don't be afraid of the page count! It reads quickly!", False, True)
add('CurseLineage', 'http://curselineage.smackjeeves.com/comics/', u'Read from right to left. Ayla Exonuke, A young Yuzcazi is being chased by the Kirimangalou Empire, They think she is the last one of a long-lost lineage. Together with her brother Kokei (not related by blood) They try to survive to the empire attacks and any other things that get in their way. Genre:Action,Adventure,Fantasy. release schedule: Thursday.', False, True)
add('DBON', 'http://dbondoujin.smackjeeves.com/comics/', u'An 8 issue long crossover manga of Shounen Jump classics, Dragonball Z, Bleach, One Piece and Naruto. that i did a little while back as something iv always wanted to do/see, and also practice for my own original long running manga Ryak-Lo (Reads Right to Left) this is a fan comic, all characters belong to their respective creators.', False, True)
add('DEGAF', 'http://degaf.smackjeeves.com/comics/', u"Death God Alchemists from the Future (DEGAF) is a (hopefully) humorous magical girl manga spoof about an ordinary girl named Britney. When a Death God possesses her cat, she learns that her destiny is to lead a magical girl team with fruit related powers. And probably save the world or something. Inter-dimensional demons are involved. Possibly an evil Alchemist. Plot Cat's a little fuzzy on the details... The characters are loosely based on myself and my friends (some of which are not represented by their correct genders). The quality of art has increased over time, but rather than try to redo the original pages, I will focus my energy on furthering the story. Updates Thursdays", False, True)
add('DEMENTED', 'http://demented.smackjeeves.com/comics/', u"// Warning 18+ Only: BL, Violence, Strong Language // We're all going to Hell eventually. But what happens if you've taken a visit to it and a certain little someone followed you back on Earth..? CHAOS ensues. Take a ride with Slayne, a killer-for-hire where everyday is the worst day of his life~", True, True)
add('DaddysGirl', 'http://daddysgirl.smackjeeves.com/comics/', u"Andy doesn't go looking for fights -- they always seem to find her. She's learned the hard way to appreciate how easily life can be taken from others, and tries her best to be a friendly pacifist. But sometimes fighting is the only option, especially when she gets on the bad side of a violent money launderer. Daddy's Girl (almost always) updates every three days.", False, True)
add('DanielleDark', 'http://danielledark.smackjeeves.com/comics/', u"Danielle Dark is a vampire trying to make it in the mortal world. It isn't easy, and she is discovering that she is different than other vampires in many ways.", False, True)
add('Dasien', 'http://dasien.smackjeeves.com/comics/', u'Leotards rule! Dasien is a superhero in the classic sense. Fun costume. Cool powers. Tons of action. Throw in some relationship drama and kinky humor, and you have Dasien! Superhero girly goodness!', True, True)
add('DavidDoesntGetIt', 'http://daviddoesntgetit.smackjeeves.com/comics/', u'A diary comic of me and my three siblings.', False, True)
add('DeadtoDay', 'http://deadtoday.smackjeeves.com/comics/', u'A weird comic about a weirder family in the afterlife. =UPDATES WITH MULTIPLE PAGES EVERY MONDAY AT 10:00AM EST=', False, True)
add('DeathNoteIridescent', 'http://dn-iridescent.smackjeeves.com/comics/', u'Iridescent: Producing a display of lustrous, rainbowlike colors. Completed. Extra chapters in the making~', False, False)
add('DebtSettlement2OperationExtinction', 'http://debts2.smackjeeves.com/comics/', u'Direct sequel to "Debt Settlement". (It is recommended to read that before this one): "3 years later. There is trouble on the way as the Red Star Security find their officers being gunned down. Seeing there is no other choice, they decide to make a direct approach towards their rival organization, Blue Labels and see if they know anything about these attakcs. With the old cast and a big list of new ones, DSOE opens up the reality Samantha is now living in. She and the rest of RSS has to learn to work with their old enemies and find a way to survive when someone obviously wants them all dead. Who are the Nightbringers and are they a threat? Can Samantha really deal with the responsibility she chose to carry in the crew? And is rest of her family really willing to let such new arrival just run them over in to the leaders position? A lot of questions are answered and secrets revealed."', True, True)
add('Debtsettlement', 'http://debts.smackjeeves.com/comics/', u'DEBT SETTLEMENT " Samantha is 14-year-old girl with little to no hope for her own future. Her mother is an alcoholic in a debt trap and after getting even Samantha in to trouble because of her own mistakes, the only people who can help the girl now, are on the side of the family Samantha didn\'t even know existed. Problem is, does she really want their help? " DEBT SETTLEMENT:RUNAWAY BROTHERS " 27 pages long spin-off which will reveal you how did Kiran and Deepak, the brothers from a super religious Aditya family ended up working for RSS. "', True, True)
add('DefyingGravityTheFourGreatGuardians', 'http://defyinggravitycomic.smackjeeves.com/comics/', u'In mid-Apocalyptic Europe, three half human half demons learn that it is their duty to save the world. Only question that remains is: How? ****Updates 3 pages every Sunday****', False, True)
add('DemonBattles', 'http://demonbattles.smackjeeves.com/comics/', u'Sweet and bubbly Angel Donitello has the gift to see angels and demons; shy and some what mysterious Malachi Knight has the gift to see demons. God brings these two teenagers together for one grand purpose: to battle demons. Equipped with weapons from the heavenly realms and the Holy Spirit to guide them, they will face the toughest challenges and fight their greatest battles.', False, True)
add('DemonCat', 'http://demoncat.smackjeeves.com/comics/', u"Hello Everyone! Yes, i have made me another webcomic - but this one will be very different compared to the others. I have already finished this comic... during class (in school... ) and now i'm just outlining it on photoshop, to make it look better. But i will be updating everything maybe 12 pages at a time? But not that much because it is a very short story... and as i've said... this is my first story... that is BL... so I wanted to tell everyone just so you guys no, that its not an intense BL... just a little sprinkle of it... i was just very curious to try it out... and i think it came out good... Anyway, i wanted to show it to you guys - Cause you're AWESOME! xD ~~~~ The story is about a Demon who runs away to Earth but finds out that he's turned into a cat... and finds that he's liking it. As well as the human who takes care of him, but his human's (master) friend is jealous and starts to develop plans to get rid of the cat. ~~~~~~ Warning: BL (not that much though) WARNING: SHORT STORY!", False, True)
add('DemonEater', 'http://demoneater.smackjeeves.com/comics/', u'A cannibalistic world where the inhabitants only food is each other.', True, False)
add('DenizensAttention', 'http://denizensattention.smackjeeves.com/comics/', u"Alicka and her little brother Winston are sent to Winterkill Boarding School. The number one dumping ground of unwanted troubled teens. A miniature Gormenghast filled with bad seeds and black sheep. +++++++ Winterkill: to kill by or die from exposure to cold winter weather. ++++++ This comic will update when i can. i'm trying for once a week, but not always managing. ++++ Denizens! Attention! how has its very own tumblr http://confessionsofawannabecomicartist.tumblr.com for updates, news and random comic making thoughts and sketches.", False, False)
add('Destinationunknown', 'http://destination-unknown.smackjeeves.com/comics/', u'The long, convoluted story of Yuri, a recovering drug addict marooned on an alien planet, and the host of characters he encounters as he tries to navigate the difficulties he faces. He may or may not be the key player in a looming crisis that threatens to change the ENTIRE UNIVERSE(!) Among the people who help or hinder him in his journey are: MIRIYAM YUSEF, a rock and roll messiah CAMRUN SHAFT, an old man who apparently knows more than he\'s letting on BISHOP TIADORA, the pope of Iona V SISTER LENA, a nun formerly of the Geul Order JAELL, a choirgirl who is infatuated with Yuri, GRAVES, who may or may not be The Devil, and MALEAH, an "extreme extraction specialist" or assassin from Terra who has a contract to fulfill. Underneath it all, DESTINATION: UNKNOWN explores the theme of Destiny vs. Free Will with rayguns and spaceships (eventually) and rock and roll (soon) Please read on, and I hope you enjoy it!', False, True)
add('DevilTrainee', 'http://deviltrainee.smackjeeves.com/comics/', u'When devil trainee Dan come to the human world, bored of his life, he decided to have fun with some stupid human, finding Lucy, a 16 years old girl who lives alone and loves MONKEYS! What will happen when both of them meet? Read from right to left!!! Please, comment. That will motivate me to follow drawing the manga ^^', False, True)
add('DevilTraineeSpanish', 'http://deviltraineespanish.smackjeeves.com/comics/', u'Cuando el demonio en pr\xe1cticas Dan viene al mundo humano, aburrido de su vida, decide divertirse con alg\xfan est\xfapido humano, encontrando a Lucy, una chica de 16 a\xf1os que vive sola \xa1y a la que le encantan los MONOS! \xbfQua pasar\xe1 cuando ambos se conozcan? Leer de derecha a izquierda Por favor, comentar. Eso me motivara para seguir dibujando el manga ^^. NOTA: Al ser esta pagina en ingles, los acentos no se ven en los comentarios. Es horrible porque yo siempre los escribo >_< y tendre que acostumbrarme a no hacerlo T_T', False, True)
add('DevilsCake', 'http://devilscake.smackjeeves.com/comics/', u"When Kea finds that her bad luck with boys isn't a 'what' but a 'who', will her sanity survive the IN-sanity that ensues? PG-13 Currently Updates Mondays", False, False)
add('DevotoMusicinHell', 'http://devoto.smackjeeves.com/comics/', u"This is the story of how the now-fallen Principality of Music, formerly an angel of decent reputation, was given an opportunity to provide inspiration for one working man desperately in need of a muse. Guys make out. Warnings for: - Explicit gay content - Blood/Gore (but not in sexual contexts) Relevant tags: Yaoi , BL , gay , M/M , erotica , pornography , porn , F/F , yuri SJ Note: I understand SJ policy, and thus it's worth noting that this comic does not and will not portray sexual situations with minors or individuals who appear to be minors. Furthermore, this comic will not portray non-consensual (or dubiously consensual) sex.", True, True)
add('Diaz', 'http://diaz.smackjeeves.com/comics/', u'Novela gr\xe1fica ambientada en el a\xf1o 2007 en Santiago de Chile cuya protagonista es una chica de 18 a\xf1os llamada Elizabeth, quien entra a estudiar dise\xf1o a la universidad. A trav\xe9s de las p\xe1ginas se revela su historia, su forma positiva de ver la vida, sus ganas de ser profesional y la forma que tiene para socializar y hacer amigos dentro de la universidad. Este trabajo se titula D\xedaz ya que \xe9ste es el apellido de la protagonista, a quien me gusta llamar cari\xf1osamente Eli :) College life, Chile, Santiago, 2007, graphic design students', False, True)
add('Diexemor', 'http://diexemor.smackjeeves.com/comics/', u'diexemor is the about a gambler named mephena trying to deliver her special friend from prison, veremor. It a fantasy world, the land is called Din, where not a whole lot makes sense. Monsters, man with a spiral for a face and people are accuse of being from an other world. That all exist in Din but why? Everybody has something to hide and even our main character, Mephena. it contains F/F and possibly M/M romance. so basically yuri, gl stuff like that. also for extra stuff follow me at: http://memoriacaelestie.deviantart.com/ or caelestie.tumblr.com', False, True)
add('DigimonSaviors', 'http://digimonsaviors.smackjeeves.com/comics/', u'.:THE ALMOST ORIGINAL:. When 9 children are mysteriously transported to a new world, they come across strange monsters called Digimon. These digimon help them survive the digital world as they try to do anything possible to find an escape from this world... ------------------------------------------------------ After defeating the D-reaper in the Real World, a vision was shown to Neroe and Agumon that the digital world was in danger. Upon returning there, they learn how much trouble they set themselves up for exactly. How will the digidestined fight this ultimate threat? Find out on Arc 5 of Digimon Saviors! Neroe - Agumon Shard - Gaomon AnXjak - Crabmon Ankh - Gotsumon Marly - Impmon Beth - Hawkmon Neo - Guilmon CD - Wormmon Radd - Renamon Van - Veemon anime.... in... space', False, True)
add('DigimonTamersMiraiProject', 'http://digimontamersmiraiproject.smackjeeves.com/comics/', u"Its been 6 years after d-reaper accident. a stable battling system is created by the goverments for digimons and tamers to direct their fighting instinct, and so that the accident didnt happen again. but is it their only purpose? the tamers knew something was wrong, and they want to find out what. thus digging deep into goverments dark secrets... ------------------------------------------------------ A revamp ver. of my doujin at Digimanga.deviantart.com. But as for now they'll all still conceptual... A project for local doujin publishing (hopefully =w=u) but in the meantime, hope you guys can comment on what can be comment on (story, paneling, angle, pacing...)", False, True)
add('DigisRandomSpriteshack', 'http://digisspriteshack.smackjeeves.com/comics/', u"meh, its where i post my random things. Started 22 Dec 2008. Ended 31 March 2014. No longer doing requests anymore. Don't bother me for them.", False, True)
add('DigitalInsanity', 'http://digitalinsanity.smackjeeves.com/comics/', u"Digital Insanity is a slice of life type comic where you follow four friends on their wacky adventures. Sometimes you'll laugh, sometimes you'll cry and sometimes you'll just go What the fu...??", False, True)
add('DoItYourself', 'http://diy.smackjeeves.com/comics/', u'Lucas had expected a summer full of video games and hanging out with friends before his parents "volunteered" him to put his college degree to use and help his aunt Lola and cousin Noelle renovate their house. Though he is strongly against wasting his summer on backbreaking labor for room and board in a sleepy little town with no cable or internet, he finds it even worse that he has to renovate alongside Noelle\'s best friend Ashley, who is also helping in his spare time out of the goodness of his heart. Lucas is convinced Ashley has an ulterior motive and is determined to ambush him at every angle. This is a BL comic, meaning it will contain scenes with romance between two boys. But I bet you already knew that, amirite? ;) Updates every Friday (at the very least)', False, True)
add('Dontdie', 'http://dontdie.smackjeeves.com/comics/', u'Once you are in this Game the only way to get out is to win it. The only way to win is to find out how to win and of course to survive. So watch for every hint, grab every stuff, avoid getting killed and never ever break the rules!', False, True)
add('DoodleBeans', 'http://beans.smackjeeves.com/comics/', u'No arms? No legs? No problem! Superheroes, Tentacle Monsters, Video Games, Violence, and PLOT!? If you like it, please comment and +favs Comic updates Monday-Friday at Midnight (PDT)', True, True)
add('DoodlingAround', 'http://doodlingcomic.smackjeeves.com/comics/', u'', False, True)
add('DoomsdayMyDear', 'http://www.doomsdaymydear.com/comics/', u'A turn-of-the-20th century webcomic drama about a modern day plague, the political turmoil that follows in its wake, and the lives of the people it touches.', False, True)
add('DragonKid', 'http://dragonkid.smackjeeves.com/comics/', u"Dragon Kid is the story of Keiko Shoda, a little girl from a land called Dragon Haven. Curious and strong-headed, she disobeys her brothers' warnings and ventures into the lair of the Dark Dragon, Kuronaga, accidentally freeing him. Now banished into the Mortal Realms because of her doing, she must become the heroine she is destined to be.", False, True)
add('Dragonet', 'http://dragonet.smackjeeves.com/comics/', u'A wizard tries to raise an orphaned dragon in a world filled with fantasy, magic, war, and adventure. He soon finds out a dragon does what it wants...and he may make all the difference.', False, True)
add('DumpofManyPeople', 'http://dumpofmanypeople.smackjeeves.com/comics/', u"A dump. RULES: 1. You can have direct ads to your comics. 2. Try to keep content PG-13 or under. 3. Be nice, blah. 4. Obey KK. 5. Shippings must be reasonable. 6. You need to give KK your soul. If you feel like adding rules, ask me, Kirby Knight 1000, first Quotes: Kirby Knight 1000: Love me or die. Sapar: M'gldy PCP: *reading book* Eggy: Indeedy GK: Wait what do I say her-*slapped with a fish* Kit: *Holding fish* THE HOLY MACKERAL imadoofus: Pootispenser here Quirby: GBC! Yosh: What even Skyy: Ready the combustible lemons! Melody: Um...*squeaks* Kylie: *eating lemons* THOSE were the combustible lemons? That explains a lot! 1ce_k1d: 1ce_k1d: Slasher: Huh I guess I'm here Ryjora: Holy French Satanism! blitzfan: Who wants a muffin?! Divide: I ship SugaryKnight OTP Josh: Muffins? But I just got here! Hanna: Um...I'd RP, make a comic, or draw something, but I need to play MineCraft! *biggest procrastinator* Heracross: YOU LEFT A MESS. LOOKS LIKE I HAVE TO SWEEP IT UP. *grabs onto Aerodactyl's legs and starts shooting missiles* Vesuvi: k PK: Tee hee!~", False, True)
add('DungeonHordes', 'http://dungeonhordes.smackjeeves.com/comics/', u'In 1986 Dungeon Hordes was released on the Playtendo and moved 1 million units world wide which is way more successful than its previous release on the Batari 2200 in 1979. Now in 2011 Dungeon Hordes has returned bigger and better than ever with mind numbing graphics and all new enemies to fight. So how do the characters in game feel about this? Only time will tell. Enter the lives of Tiggz and Tomes, two level 5 bosses tired of being easily killed by player 1 and wanting the glory of finally becoming more than just petty bandits. Will they survive the new creatures that the mighty programmers have added to the game? Will they ever kill player 1 and move up the mob boss ladder? Will they ever get a raise from their uptight dungeon boss Kalakis and finally pay off their ale tabs at the Stinky Dragon Inn? Stay tuned and find out..... Will be updated Every Monday, Wednesday and Friday. Dungeon Hordes Facebook http://www.facebook.com/pages/Dungeon-Hordes#!/pages/Dungeon-Hordes/195568970460655', False, True)
add('EATATAU', 'http://eatatau.smackjeeves.com/comics/', u'', False, True)
add('EDepthAngel', 'http://edepth.smackjeeves.com/comics/', u'In the future, even machines will need an angel, hired as a nurse for cyborgs, Angel finds herself thrown into explosive mech battles and a cyborg family gang war. It\u2019s about a girl without any super powers being forced to face a family of crazy cyborgs with mechs and all sorts of weapons that want to kill each other. Not only does she need to survive, but she will also have to help bring them something they\u2019ve been missing, peace. Update Every Wednesday', False, True)
add('ERAConvergence', 'http://convergence.smackjeeves.com/comics/', u"UPDATES MONDAY AND THURSDAY! The Darkwood corporation is in jeapordy if Velias doesn't manage to retrieve evidence stolen by a pesky rebel rat. He decides to hatch a plan to kidnap the rebel's clueless little sister, but finds that more difficult than he thought...", False, True)
add('ERAIbuki', 'http://eraibuki.smackjeeves.com/comics/', u"Trailer: http://youtu.be/I_UcznZSydo Japanese trailer: http://youtu.be/HJTORFFi6OY A short story about a girl with a kind heart who is faced against a world that's just too strong for her to fight. But it doesn't stop her from trying. Updates DAILY", False, True)
add('ERRORERROR', 'http://errorerror.smackjeeves.com/comics/', u'A finnish teenage boy Tomi is a normal nerd. He plays videogames and gets average grades, but also is terribly bored with his life. But one day he accidentally gets inside of his computer and meets there a girl, who calls herself princess Jooda. And there is a profecy about Tomi, sword and Viruses. Warnings: If you are under 13 years old, I do not recommend this comic to you. Contains bad language, blood and somewhat sexual themes. ps. This started out as a test for new tablet, so the start looks like that too. Also, sorry about the style changes, I practice. Updates 2-4 pages a week.', False, False)
add('EidolonWhispersofEternity', 'http://whispersofeternity.smackjeeves.com/comics/', u"In a distant future, on a foreign world, Knights, Dukes and Princes seek to coexist amid a bounty of marvelously advanced technologies and a desire to maintain the old ways. The Luminary Council, an Order of Knights run by the ghostly manifestations of the thousand-year-old Eidolon, seek to bring the world together for mutual gain...but one nation, Kitez, proves to be a thorn in their side. On the eve of a potential breakthrough, catastrophe strikes, and it seeks to destabilize everything the Eidolon had striven for. Ten years pass...and the threat of retaliation seems over. Kitez has been locked down to the outside, but new forces loom on the horizon, daring to kick at the sleeping Lion. Follow the Knight Gabriel Lugios, and his partners Ren Nibasai and Setharion Rydell as they venture into unknown dangers and uncover a millennium's worth of dark secrets... UPDATES EVERY 5-7 WEEKS! (Sorry, full chapters take a long time to produce!)", False, True)
add('ElementalSpirits', 'http://elementalspirits.smackjeeves.com/comics/', u"Alex's notes to self #23: Do not grab seemingly innocuous sword. Life changing events and general bad things may follow... Elemental Spirits updates every Monday.", False, True)
add('ElfenLiedDifferences', 'http://differences.smackjeeves.com/comics/', u"One of my favorite mangas is Lynn Okamoto's famous Elfen Lied (Which likewise I should clarify that I absolutely HATE the anime version) This comic is based on a trilogy story I wrote for FF.Net which I can't say was the best but it was fun nonetheless. --- Differences can be considered an alternate Universe Sequel to the manga. The story revolves around the actions of the second Queen Diclonius. --- It's all I can say, I'm not an artist, I just draw for fun. Enjoy Because it's based off of a Seinen Manga, there's going to be some adult content including Blood and Gore Language Nudity Sorry for inconsistent art as well. Read Right to Left like a normal manga now Be nice, but feel free to criticize. --- Re-doing Volume I, updates will probably be weekly.", True, True)
add('EnkeltenKentta', 'http://enkeltenkentta.smackjeeves.com/comics/', u"Sakari Kauria has been living the humble life of a show bartender for a few years. His life isn't glamorous, but when he isn't too self-aware about the quirks in his appearance, it's good enough. He knows who he is, and he knows how the cogwheels of the world run... Except he really doesn't. Luckily during one chaotically eventful night, he encounters Lucifer. A youngster with a similar twist in his appearance, who knows a lot more about the world they live in, and a few answers to some questions about Sakari himself that have plagued him ever since he knew he wasn't like the rest of his kind.", True, True)
add('Enthrall', 'http://enthrall.smackjeeves.com/comics/', u'In Angland, a country where humans live by the whims of their vampire overlords... The leader of the Abolitionists, an activist group against the vampire dominion, is captured and enslaved. A born slave is freed after saving the lives of many in the Angli-Frencan War, to become a free man for the first time. How will they act in a world that is constantly changing around them?', True, True)
add('Entreeuxdeux', 'http://entreuxdeux.smackjeeves.com/comics/', u'"Entre eux deux" est une bande-dessin\xe9e amateur qui sent bon la poudre, les fusillades et la mafia, mais qui en fait se pr\xe9occupe plus des deux destins qui y ont difficilement trouv\xe9 leur place. Deux \xeatres que tout s\xe9pare, mais finalement pas tant que \xe7a... Je poste les pages par quatre (quand j\'y arrive) tous les 15 jour, le dimanche. Merci \xe0 tous ceux qui passent par ici. >w<', False, True)
add('Entuthrie', 'http://entuthrie.smackjeeves.com/comics/', u'A story about personages in turmoil, and the coincidences that follow. Taking steps forward, one (en), two (tu), three (thrie), is the way to reach to a conclusion.', True, True)
add('Eorah', 'http://eorah.smackjeeves.com/comics/', u'', True, True)
add('EozinKadonnutKuningas', 'http://eozinkadonnutkuningas.smackjeeves.com/comics/', u'30 vuotta sitten Eozin kuningaskuntaa kohtasi vampyyrien joukkohy\xf6kk\xe4ys jonka taistelussa kruunupari menett\xe4v\xe4t henkens\xe4 ja kruunun perillisist\xe4 vanhempi katoaa j\xe4ljett\xf6miin taistelun keskell\xe4 kun nuorempi perillinen saadaan siirretty\xe4 turvaan, mutta norukaisen olinpaikasta ei ole t\xe4n\xe4k\xe4\xe4n p\xe4iv\xe4n\xe4 mit\xe4\xe4n tietoa. Er\xe4\xe4n\xe4 p\xe4iv\xe4n\xe4 kaapuun pukeutunut vaeltava nuorukainen kohtaa siivekk\xe4\xe4n olennon. Syyst\xe4 tai toisesta he alkavat matkustaa yhdess\xe4 kohdaten matkallaan yst\xe4v\xe4llist\xe4 v\xe4ke\xe4, mutta my\xf6s vaarallista. Matka on tuntematon ja uhmakas, eik\xe4 kaksikon heikko suhde toisiinsa edist\xe4 matkaa, mutta ajan kuluessa tapahtuu molemmille hyvin yll\xe4tyksellisi\xe4 asioita.', False, True)
add('EpicChaos', 'http://epicchaos.smackjeeves.com/comics/', u"How would you react if you woke up next to your best friends doppelganger? You'd probably react how Mel did. Follow JJ, Mel, Nathan and Epic Nat (EN for short) throughout their adventures through college, jobs, and all of the chaos EN brings with him!", False, True)
add('Equsopia', 'http://equsopia.smackjeeves.com/comics/', u'Because of black magic, the king and his loyal knight were sent to another world. Now they must find the way home. Read from left to right. Facebook page : http://www.facebook.com/Equsopia Join me on FB page for more arts, contests, and gifts!', False, True)
add('EternalKnights', 'http://eternalknights.smackjeeves.com/comics/', u'Suicidal immortal knight Kathryn "Artemis" Kennedy is haunted by lost loved ones and the friend she couldn\'t save. She finds reasons to live in new friend Detective Erica Richards and squire Julia... and also finds a way to die. #superhero #action #violence #fantasy #princess #super-heroes #superhero #superpowers #powers #cute #superheroine #heroine #hero #anti-hero #dark #wizard #spells #Merlin #King Arthur #Brian Boru #ghost #supernatural #immortal #knights #Artemis #Diana #mythology #myth #mythological #demon #monster #horror #sci-fi #science fiction #robot #psychic #teen #teenage #history #historical #Oberon #Shakespeare #Avalon #gun #cop #police #NYPD #New York #New York City #Irish #faerie #faerie tales #fairy #fairy tale #vampire #vampires #humor #humour #funny #jokes #drama #writing #dialogue #story #tale #cross #catholic #christian #panties #panty #nipples #boob #boobs #breast #breasts #cleavage #titties #blonde #brunette #sexy #sex #pussy #cunt #twat #penis #dick #swearing #adult #NSFW #nude #nudity #full-frontal #Sapphic #LBGT #lesbian #gay #bi #trans #homosexual', True, True)
add('EuphemisticEephus', 'http://eephus.smackjeeves.com/comics/', u'A webcomic that started out as a story about someone with narcolepsy, and has evolved into something about the mind in a world post-assimilation plot with Jackson Pollock inspired pages from a certain point on... **Based upon the Smackjeeves 24 hour comic challenge in 2012, look for the comic with Roman Numerals and a forums post on Dream Sequences. http://www.smackjeeves.com/comicprofile.php?id=125269 ***Updates Tuesdays, Thursdays and Saturdays', False, True)
add('EvD', 'http://ev-d.smackjeeves.com/comics/', u'Gail never seems to be able to have peace. Not when everyone is out to get him. And yet the person at the top of that list is himself. Nothing is good and everything hurts. But perhaps.. This is just what the gods wanted. [Contains innappropriate language occassionally] Updates on Wednesdays', False, True)
add('EvilPlan', 'http://evilplan.thewebcomic.com/comics/', u"Evil Plan takes the superhero world and flips it, viewing things from the supervillain's perspective. The story follows Dr. Kinesis' journey on the road to world conquest. On the way, he'll have to deal with a troublesome AI, his unwilling friendship with crazy black-market dealers, and the possibility of romance with his second-in-command. And the superhero. Can't forget that guy. With all this going on, Evil Plan is a comic for people who want to see the bad guy win. If he doesn't blow himself up first. Story and Line Art: Alexis Royce Color: Megan Johnston, Chelsea Capobianco Updates: Every Sunday", False, False)
add('ExperimentalMegaman', 'http://ex90081.smackjeeves.com/comics/', u"Distant in the future, a weapon of mass destruction is created to destroy all Megamen- A maverick more powerful than any of them. As the ninth prototype is created, it's creators take it for a test run. Aparently though, there are a few bugs in his system... .:Updates on Mondays and Friday:.", False, True)
add('EyesofaDigimon', 'http://eoad.smackjeeves.com/comics/', u'A fictional Digimon manga about a boy and a unique Digimon. Based off the series by Akiyoshi Hongo.', False, True)
add('FailureConfetti', 'http://failureconfetti.smackjeeves.com/comics/', u'Failure Confetti is a webcomic about life, words, science, games, and human observations. Updates weekly, on Wednesdays.', False, False)
add('FairyTaleRejects', 'http://fairytalerejects.thewebcomic.com/comics/', u"A vengeful viking centaur. A drunken cowardly satyr. What do these creatures have in common? Absolutely nothing, but they're on a quest to save little Tomato's mom.", True, True)
add('FaithlessDigitals', 'http://faithlessdigitals.smackjeeves.com/comics/', u'Kade Norne was never one to be good at talking to girls or making friends but this never bothered him, he was content by just staying in his room all the time watching anime, reading manga, and playing video-games. A year and a half after graduating high school he finds himself stuck in a boring loop of a life, but through a strange turn of events involving a blunt redheaded girl and sassy black haired girl with electric blue horns warning him about the approaching end of Earth...he soon finds himself being forced to overcome his social anxiety issues by gathering old classmates and others in order to prevent what SEEMS to be the beginning of an apocalypse, but turns out to be something completely different... Medium: Copic Markers', False, True)
add('FalconersDailyStrips', 'http://falcdaily.smackjeeves.com/comics/', u'Daily comic strips I throw together with little effort just for funzies.', False, True)
add('FallenAngelslove', 'http://fallen-angels-love.smackjeeves.com/comics/', u"A cute BL story No smex for awhile sorry! :D Hiro and Taisuke have known each other for many years, they have been friends for as long as they can remember. However, Hiro is a demon who is fated to be locked up for all his life and Taisuke is an angel who's a bit of a play boy. What will happen when Hiro begins to long for freedom so much he would do anything to obtain it? When Taisuke realizes that his feelings for Hiro are a bit more than friendship will he run away or embrace those feelings? When heaven and hell clash how could such a love be accepted? Sounds cliche but I promise it will be a enjoyable read XD", False, True)
add('FarOutMantic', 'http://meteorflo.smackjeeves.com/comics/', u'a kinda large comic this time. about love, creativity, music and discos!! just a fun comic really, nothing too perpelxing. have fun!!~', False, True)
add('FarOutThere', 'http://faroutthere.smackjeeves.com/comics/', u'A manga-esque Sci-Fi Comedy. Far Out There is the webcomic where things happen... IN SPACE!!! (currently being transfered over from DrunkDuck, so pardon the mess)', False, True)
add('FatetheAnthologyofKaienandhisfuckingmagicfriends', 'http://fatehoho.smackjeeves.com/comics/', u'Fate is a story documenting the adventures of Kaien and his friends. An orphan of war, Kaien doesn\'t want to go through with a certain coming of age ceremony, and through the commotion of his denial, manages to embark himself on a journey with a demon looking for "assistance." LGBT friendly is this comics middle name, except that it isn\'t because comics don\'t have middle names, obv. But it does feature some gay characters, and it doesn\'t devalue them as the awesome and cute little fuckers that they are. Expect to find both same sex and opposite sex relationships in this webcomic. I\'d give it an MA rating. It has a lot of swearing and adult themes, and sexual references though it is not too explicit by way of actual sex scenes (though characters having sex will be referenced) or gratuitous violence. It\'s recommended for young adults, as I am one myself and assume that is who this will appeal too. It\'s a comedy also, but you may find it\'s sense of humor kind of niche. I encourage you read it for yourself to discover whether the jokes are your cup of tea or not.', False, True)
add('FeathersPI', 'http://featherpi.smackjeeves.com/comics/', u"Feather Von Muse was born in the 1600's to a sickly mother and an abusive father. She had no siblings, on the eve of her 18th birthday a terrible war flooded into her village, her mother passed from the stress and her father was killed in the fighting. Trying to run Feather was captured and was turned. she then served the Kingdom of Four Gods until it fell, now she and her partner Diki run a PI group in order to hunt down and kill evil beings!!", True, True)
add('FemmeSchism', 'http://femmeschism.smackjeeves.com/comics/', u'Femme Schism is an action/adventure webcomic about an indigenous woman who is forced to shack up with a spoiled rotten Christian missionary.', False, True)
add('FeralGentry', 'http://feralgentry.smackjeeves.com/comics/', u'Feral Gentry is an occasionally animated new weird comic about modern fairies. Tuomi is a fairy who has lived for a long time in hiding among humans, with only his plants to keep him company. His peaceful yet lonely life changes when he meets Cypress, a strong-willed fairy who is intent on bringing Tuomi back among his own kind. But change is rarely easy, and the summer is only ever so long... The comic is updated on Wednesdays and the story will span four chapters.', False, True)
add('FinalArcanum', 'http://finalarcanum.smackjeeves.com/comics/', u"Anyone can be a hero, even the unsuspecting, unwieldy sky pirate Acacitli. When he gets separated from his ship and crew, he quickly learn there's a little more to life than rum, thievery, and failing a little at life more than he'd care to admit.", False, True)
add('FireWire', 'http://firewire.smackjeeves.com/comics/', u"When Kennedy H'naka's cell phone becomes the new home of the dragon FireWire Balisk, she finds herself sucked into a world of battles, secrets, and shadowy organizations. What's a girl to do when she has to save the world and still pass the tenth grade? Updates: Fridays Reads: left to right. Comments greatly appreciated ^^", False, True)
add('FireredLisasReise', 'http://lisasreise.smackjeeves.com/comics/', u'This comic is a Firered Nuzlocke run. Lisa, a young girl from kanto starts her journey to become the Pok\xe9mon master. Updates Sundays! Also visit my tumblr account and ask Leaf questions! http://lisa-leaf.tumblr.com/ Laufente has helped me with the coloring until page 63, but I figured I should learn how to do backgrounds and attacks myself so I will do it alone from now on. Laufente has her own Nuzlocke as well so please look at Road to Glory as well :D', False, True)
add('FlyorFail', 'http://flyorfail.smackjeeves.com/comics/', u"ever had an idea for a comic but you never tried it because you thought no one would read it. well what if that comic really would be the best comic ever! well hopefully that won't be a problem any more this is Da Bag Man and Awsome Guy creators of this amazing creation what you do is make a comic and post it and everybody will tell you if it was good or not please no fillers but comics asking about about fillers are okay preferably no ads i dont want this to be another shameless advertisements but if your idea flies and you post a follow up advertising the site that's okay so co-author now!", False, False)
#add('FootLoose', 'http://footloose.smackjeeves.com/comics/', u'Beware, some strong language! Akio is sick of having fake friends who are only after his money and his looks, so what better to do then start at a new school, with a new personality... and gender, sort of. Some shoujo-ai and shounen-ai involved. PAIRINGS, psychotic bullies, and gender confused guys, what more could you ask for? Comic is completed, updates weekly with re-drawn pages-expect a sequel and an altered ending soon. Art: Alycia Cover art and story: Me read left to right', False, True)
add('ForcedSeduction', 'http://forced-seduction.smackjeeves.com/comics/', u'"Can you make the next person walking through this door fall in love with you within a month?" "Sounds easy." BL!!! I apologize for the lack of creativity and the super sketchy outlines. I\'m totally being forced XD (Just kidding) Oh, and English is not my first language. It\'d be lovely if you could help me to improve ;) (meaning correct me please XD) Better read from right to left ;)', False, True)
add('ForestHill', 'http://www.foresthillcomic.org/comics/', u'Life happens.', False, False)
add('ForgettheDistance', 'http://forgetthedistance.smackjeeves.com/comics/', u"(There's a little smidgen of nudity at the beginning but then it's smooth fluff sailing from there until...chapter 4? yeah, i think so.) Includes THEMES of BL/Yaoi/BoyXBoy: Logan's mother hasn't had a good eye for good men since his father went missing so when Brian comes along, he is automatically disliked. Any man who his mother brings home receives the same treatment: sarcasm,pranks and vile language. But unlike the others, Brian doesn't give up. He doesn't leave. Doing so earns him some respect from the teen and even though they begin to get along,the competition continues. They both love her dearly and neither will give up the game. Brian won't lose to a child such as Logan, and Logan won't lose to a man such as Brian. In the end are they really competing for his mother's love or for each others? Who will lose? Joint with my sister: Juli(AUTHOR/CO-ARTIST), Somi(ARTIST) UPDATES: We've gotten it down to about one every week...normally....if not within two. We're back on schedule cause we're free and hopefully drawing more.", True, True)
add('Fortheloveofabrokenstring', 'http://fortheloveofabrokenstring.smackjeeves.com/comics/', u"while waiting at the park Hyunjin meets a strange man who seems to look like the man in her dream, only to find out later that he's a fox demon?! Now finding she has a connection to this Fox Demon, she sets out to find his story while slowly finding out her own. What is their connection? Why does her grandfather try so hard to not let them interact with each other? What was the meaning to her dream?", False, True)
add('FramebyFrame', 'http://frame-by-frame.smackjeeves.com/comics/', u"Comic updates Tuesday unless otherwise stated. The hostility between our two lead comic artists is slowly dissipating but lots of things are changing for our little group in general. Many are moving, some are having revaluations about their life, but nothing is going to stop them from enjoying the Halloween Party at the DVDungeon. Volume 2 of Frame by Frame has it all; ghosts, romance, and angry ex girlfriends to boot. +Alex is at his wits end with Tai, his ex-girlfriend and live-in roommate. Has the time come to move on, both physically and emotionally? Maybe something new would do him wonders. +David continues to work hard in both his work and establishing his life there in Poulsbo. He's gaining courage to do something impossible with high hopes of it being possible. However, it's unknown if it'll be a good idea in the end... --WARNINGS-- +The typical warnings: adult language, adult situations, adult nonsense.", True, True)
add('FrenzyRedux', 'http://theadventuresoffrenzy.smackjeeves.com/comics/', u'Neo Arcadia discovers an ancient reploid of immense power. Could he be their ultimate defense against the inevitable arrival of Zero?', False, True)
add('FrobertTheDemon', 'http://frobby.smackjeeves.com/comics/', u"A gag-a-day comic about one little demon's journey to cause mass chaos and wreak havoc upon the poorly-drawn folk known as stix.", False, False)
add('FrogKing', 'http://frogking.smackjeeves.com/comics/', u"READ FROM LEFT TO RIGHT. This comic contains bad humor and sometimes badly written English (because my native language is not English) It also has many mistakes so that itself is enough of a reason to start reading it now. Don't get butthurt. Updates every MONDAY. (random story about mine (Murderduck) and RottenCats characters)", False, True)
add('FromnowonImagirl', 'http://fromnowonimagirl.smackjeeves.com/comics/', u"One day out of nowhere Hikaru's girlfriend broke up with him because she found out she is lesbian. He decides he will never fall in love with women again so... he has to love men. with his big sister's help he is no longer hikaru the boy but a girl!(cross-dresser) Hikaru meet Natsu who made his life hell and decides to get his revange and... The rest is still unclear read from right to left Contains BL maybe yaoi, romance,GenderBender and comedy Hope you enjoy *improving drawing style", False, True)
add('FruitloopAndMrDownbeat', 'http://fruitbeat.smackjeeves.com/comics/', u'After hitting a bump in the road of life, Danny Lawson ended up moving back to the city where he attended college. His next door neighbor, Alan Taylor, is a senior in high school who falls in love with Danny almost immediately. AND THUS THEY BECAME FRUITLOOP & MR. DOWNBEAT. (bad intro, yes.) (contains boy/boy, girl/girl, foul language, cartoon violence, some sexual themes) Tries to update weekly. (Tries)', False, True)
add('FuckMyLife', 'http://fuckmylife.smackjeeves.com/comics/', u"--HIATUS-- A journal comic of my gay and flamboyant life. Contains: -Me and my friends swearing like sailors -Family drama -Hopeless romance -Ridiculous things you wouldn't expect most people to do Moosefroos@Deviantart", False, True)
add('FurtherDowntheRabbitHole', 'http://fdtrh.smackjeeves.com/comics/', u"Wonderland has a dark edge to it. After so many years of being told that Wonderland was all made up in his twisted mind, Alex had about enoungh. He returned the very rabbit hole he first fell down in only to find it wasn't there. Was it true then? Was all his adventures and friends he made in Wonderland all made up? Was he really crazy like his family said? This is a Boy love collab. Don't like? Don't care, you don't have to read or join. Also this comic is gonna be a bit insanity/horror. Rules will be posted on first page. Any questions, pm me. Characters needed: Alice:(taken) Hatter:(taken) Tweedle twins:(taken) March Hare: (taken) White Rabbit:.( taken) Red Queen:(taken) White Queen:(taken) Chesire Cat:(taken) Knave:(taken) Catipiller:(taken) Dormouse:(taken) White Knight: (taken)", True, True)
add('GATEKEEPER', 'http://gatekeepercomic.smackjeeves.com/comics/', u"Olivia Kane thinks she's found the perfect job interning for Mr. Porter, a renowned criminal psychologist, until she stumbles upon a frightening discovery. Through Mr. Porter, Olivia is then introduced to the life of Gatekeepers, professionals who are commissioned by the rich and powerful to conceal heinous crimes. Contains: Violence, Gore, Sexual themes Updates: Sunday, Tuesday, Friday", False, True)
add('GamerCafe', 'http://gamercafe.smackjeeves.com/comics/', u"Welcome to the Gamer Caf\xe9. A caf\xe9 created by gamers, for gamers. To the sides we have the gaming booths - tables with their own personal LAN modems for up to 6 players. LAN modems are charged for their use by the hours - Therefore, anyone wishing to use the Booths without charge are welcome to do so. The center of the establishment is the Caf\xe9 itself with free Wifi available. Gen, Mana and Warren are your regular waiting staff, and they're waiting to take your orders. Sincerely, The Gamer Caf\xe9 manager Derryl.", False, True)
add('GamesPeoplePlayUpdatedWeekly', 'http://gamespeopleplay.smackjeeves.com/comics/', u'A webcomic about the little nuances of table-top roleplaying games, and the people who play them. Updated weekly. Feedback and comments at azalin1@lycos.com', False, True)
add('GardenofHearts', 'http://gardenofhearts.smackjeeves.com/comics/', u"Alyn, royal guardsman to the elven Queen of the North leaves for a quest to the far south with his wise-cracking necromancer friend Skylar. They are seeking a long-lost magical talisman that could dispel the eternal winter of the northern lands--and just perhaps elevate Alyn to Queen's Consort after he returns a hero. To journey into the south Alyn will need the help of his childhood friend, Nirin. Only, Nirin is a lot more enchanting than he remembered and every step closer to the mythical Garden of Hearts is a step further from his goals. story specs: light-hearted fantasy romance BOY X GIRL. tech: hand-drawn, b & w, toned.", False, True)
add('GayBacon', 'http://gaybacon.smackjeeves.com/comics/', u'Here you can read strips about random things in my life or thoughts that may occur in this messed-up head. This is what the quiet, weird kid draws whenever he gets a chance. Updates at random times. [Contains a lot of cursing]', False, True)
add('GayTimesWithRyanandJay', 'http://gtwraj.smackjeeves.com/comics/', u"Ryan Laytey's got no problem with gays. I mean, it's not like he's a homophobe or anything. As long as they leave him alone, he'll return the favor. If gay people would just stop complaining about their problems and keep their business to themselves, everybody would be happy. But of course, none of this matters, because Ryan, like any self-respecting 15-year-old male, doesn't hang out with any gay people. Oh, and while we're on the subject, have you met his best friend, Jay Ambrose? _______________________________________________________ Gay Times With Ryan and Jay is a comic I created to explore the complex themes of being gay as a teenager and growing up in general. It's mostly (subtle) comedy, though there are a few more dramatic, sad, and (possibly?) romantic moments, which you'll all see soon enough. *Updates Weekly. Now in Chapter 4, where Ryan and Jay discuss the latter's newly found identity. Page 1 will be up next week. ***Currently testing out banners!***", False, True)
add('GearTheTakedown', 'http://geartd.smackjeeves.com/comics/', u'Time traveling... some trippy business. Gear is taking a dangerous path in time traveling. Gear had been taking risks to right the wrongs he made. Although, it seems like it may have taken in a turn for the worse... [ Due to the lack of responses to those who provided bio for the cameos, some were removed, ALTHOUGH, that is good news! More spots had opened up and you are welcome to send your cameos in! Make sure you send in your latest sprite sheets with a short bio! ]', False, True)
add('GetUpandGo', 'http://getupandgo.smackjeeves.com/comics/', u'', True, True)
add('GigisNuzlockeRuns', 'http://giginuzlocke.smackjeeves.com/comics/', u"Gigi's Nuzlocke Runs is a 3 part series of one trainer's Pokemon adventure to regain her lost memory. The first game is Emerald, then PMD: Sky, then...who knows! Current run: Sky", False, True)
add('Gloomverse', 'http://gloomverse.smackjeeves.com/comics/', u'She was just a regular, unwanted kid, until she was lucky enough to get a job under the best magician in the world! Unfortunately for her, her new boss is a self absorbed sociopath. Updates are currently Monday, with some sporadic mid-week updates if I have time! Dark/Twisted Comedy!', False, True)
add('Gnoph', 'http://gnoph.smackjeeves.com/comics/', u'Life, love, and internal parasites.', False, True)
add('GoldenSunGenerationsAftermathVolume1', 'http://gsgbtsyearone.smackjeeves.com/comics/', u"- BEFORE THE STORM SERIES EPISODE I: VOLUME ONE - A fantasy RPG story based from the underrated RPG game series Golden Sun. Three time traveled Adepts granted a second chance at life after living seventeen years in an alternate destroyed reality, must quickly get used to their new surroundings as they are thrown into the fray dealing with new friends, family, emerging enemies and a big sailing adventure they'll never forget. Part 1 of a 4 Year Webcomic Series BEFORE THE STORM, a Golden Sun doushinji. - Rated +13 for slapstick humor, mild language, and fantasy violence VOLUME ONE COMPLETED; VOLUME TWO AVAILABLE HERE: http://gsgaftermathv2.smackjeeves.com/", False, False)
add('GoldenSunGenerationsColossoVolume6', 'http://gsgbtsyearthree.smackjeeves.com/comics/', u'- BEFORE THE STORM: EPISODE III - A fantasy RPG story based from the underrated RPG game series Golden Sun. The main focus is on the character Ethan who has grown up the last two years in terms of height and skill, seeks to win the heart of the werewolf girl Tasha by competing in a tough fighting Tournament. The first round is over and now the festivities truly begin! Part 3 of a 4 Year Webcomic Series BEFORE THE STORM, a Golden Sun Fancomic. - Rated Web +14 for gutter humor, mild language, romantic situations (BxG love) and fantasy violence COMPLETE - SECOND HALF OF COLOSSO BEGINS FEBRUARY 2011: http://gsgcolossov7.smackjeeves.com/', False, False)
add('GoodGame', 'http://goodgame.smackjeeves.com/comics/', u'Three friends want to get some fun and play a computer game in their hi-tech fantasy world. But they got something wrong...', False, True)
add('GoodnightMrsGoose', 'http://goose.smackjeeves.com/comics/', u'Hard working lawyer mom Valerie Clark is letting her work life overcome her family life. However after a magical encounter, she gets the chance to rediscover her childhood and also help cleanse her world of odd creatures.', False, True)
add('GraveImpressions', 'http://graveimpressions.smackjeeves.com/comics/', u'Grave Impressions is a story of deception, speculation, and assumption. When no one is who they appear to be, some secrets are worth keeping... \xa9 Ziska, Aleksi, Nym (Z.A.N)', True, True)
add('Grayscale', 'http://grayscale.smackjeeves.com/comics/', u'A comic with a chaotic medley of murder, mad science and man love. Grayscale is a comic adaptation of a story written by Ski and Demi/Silvae (I usually go by Silvae, that name was taken) in RP format. We decided we wanted to see the whole thing visually in the form of a comic, and this is the result. Both of them write, Silv draws, Ski offers praise/feedback/awesomeness. Rinse and repeat! Updates on Tuesdays at fourfears.com Follow us on Tumblr: http://fourfears.tumblr.com/', True, True)
add('GreenKirbyandabunchofotherpeopledoinstuff', 'http://gkandabunchofotherppl.smackjeeves.com/comics/', u"Oh look I've changed this comic's description. Soon it will have a new name and banner. Yaaaay.Rules: Swearing or some other rude words in comics and comments is 100% unacceptable. NO mature content. No flaming or trolling in comments. Also, post your sprites for each fc you will be using in this comic. Chat rules:No swearing, trolling, or spamming. Not only members can come to the chat, so you can vist if you want. Please remember to come to the chat often, because it's lonely there. :'( Also, this comic isn't just for Kirbys. If you have fcs who are not Kirbys, they can be used.", False, True)
add('GuardianGhost', 'http://guardianghost.smackjeeves.com/comics/', u"After being hit by a car a few months ago, things have been very strange for Max. Not only can he see ghosts, but one in particular claims to have saved him from death! But there are reasons why ghosts are not allowed to save humans. Updates Tuesdays(and Thursdays if there's time)with a massive quality shift from chapter to chapter (and pages before CH5 are slowly getting text fixups)", False, True)
add('GuardiansoftheGalaxialSpaceways', 'http://ggs.smackjeeves.com/comics/', u'Join Captain Taxxi Serbus and the crew of the Artful Dodger as they battle space pirates, giant comic book geeks, and intergalactic viruses in a star-spanning adventure!', False, False)
add('HIPS', 'http://hips.smackjeeves.com/comics/', u'An admittedly done before bl romance. Here is my attempt at a gripping back cover summary: In an effort to get away from his criminal family, Julius Green has turned witness for the city. He is secreted away and hidden in a posh private academy as...a girl?! Suffocated by the charade, will Julius be able to pull off school life as Penny Adams? And will he be able to save himself when the two rulers of the school, Max Lawson and Alex Watch, take particular interest in him?', True, True)
add('Habibahssong', 'http://habibahsong.smackjeeves.com/comics/', u'transgender issues, bullies, in a furry world', False, True)
add('Harfang', 'http://harfang.smackjeeves.com/comics/', u"Harfang is a fantasy story, based on the Jorinde & Joringel Grimm tale. Designs are inspired from asia (Korea/Mongolia/China). I update it one page every monday ! I hope you'll like it. ^____^ ***************************************** You can buy the first book in full colors on my shop : www.auroreblackcat.bigcartel.com ***************************************** ENGLISH TRANSLATION ***************************************** My english is bad, don't hesitate to correct my grammar. Thank you ! ^__^ *****************************************", False, True)
add('HarvestMoonParadiseFound', 'http://paradisefound.smackjeeves.com/comics/', u'When a single phone call changes your destiny...do you find the strength to embrace it? A Harvest Moon Doujinshi (fan comic) Read RIGHT to LEFT. Updates Thursdays. (Harvest Moon title and concept are copyright of Marveslous Interactive)', False, True)
add('HatShop', 'http://hatshop.smackjeeves.com/comics/', u'You may be thinking this is a comic about hats. It\'s not. A strange comedy about a boy who is fired in the first panel and accidentally sells his soul to an eccentric hat maker. Shenanigans ensue. Note to new readers: The art gets better. Note on the format: I originally drew it vertically because I did it by hand and that\'s how it would fit on the page (It just seemed like a good idea at the time). Three years later, it\'s stuck. It sometimes changes to full pages if the story needs it, but the vertical format is the default and I\'m not planning on changing it. Updates every three days unless otherwise specified. Note: This is a "whatever the author feels like" comic. You have been warned.', False, False)
add('HatethePlayer', 'http://hatetheplayer.thewebcomic.com/comics/', u"Hate the Player is a comic based on a number of concepts Tron, and Quantum Leap. The overall idea is the character M.C. (A play on words for Main Character). A horrible game magazine reviewer who gets transfer'd into the game world by Beans, who use to be a developer until M.C. ruined him, now an editor who came to get revenge on M.C., He forces M.C. to re-enact the various game worlds as the Hero of the world, until a freak glitch causes issues.", False, True)
add('Helix', 'http://helix.smackjeeves.com/comics/', u"A street rat is given a second chance when he is dragged from the gutter and into a new life. Will he accept his position at the side of royalty, or fight every step of the way? -Rated M for sex (M/M, consensual), violence, nudity, language and dark themes.- Warnings: -References to child abuse and sexual abuse.- If you can handle these subjects, I hope you'll enjoy the comic. :) Thanks for reading! ~Join Helix on tumblr at http://helix-comic.tumblr.com ! ~", True, False)
add('HeltonShelton', 'http://heltonshelton.smackjeeves.com/comics/', u'This is a goofy sketch at a party that grew into a two-book saga about a multi-generational battle against the darkness inside us. Shelton1 and Shelton2 set out to fight the Final Boss, but victory carries a cost for Shelton1. A party of heroes begin a quest of vengeance, but can they overcome their rivalries before facing their ultimate foe? A spellcasting musician learns to deal with death, but can she deal with life?', False, True)
add('Hephaestus', 'http://hephaestus.thewebcomic.com/comics/', u"(a retelling of Greek mythology, with more than likely deviation from the original myths) While other gods on Mt. Olympus are known to be beautiful and laid back, Hephaestus is more humble in appearance and works his hands to the bone. However, that is not to say that the god of crafting and fire doesn't have any interesting tales about himself... <<Current Chapter>> 7) Soul Man Part 1: Hephaestus recounts the beginning of the first winter with the introduction of Kore, the child of Demeter <<Previous Chapters>> 1)Road to Athens: 2)Origins: Part 1 3)Passive Affection 4) Origins Part 2 5) Hermes' First Flight 6) Origins: Part 3 0) Under the Waves:", False, False)
add('HereBeVoodoo', 'http://herebevoodoo.smackjeeves.com/comics/', u"Voodoo is the story of Sunday, a ten-year old girl and her doll, Mojo. But Voodoo isn't a story about their fun and magical adventures through a candy colored world (Well, with a story titled Voodoo, I kind of hope you were warned). Voodoo is about how far you can go to take revenge. About the necessary evil and the far less necessary About the choices who are not always the right one, and sometimes not having a choice at all. About making mistakes, and seeking redemption, or choosing not to. And in a less cryptic way, note that the story will mention explicitly: -Disturbingly cute voodoo dolls wielding butcher knives. -Zombis (dog, bird, humans, bugs, more or less whole.) -Grave robbing. -Human remains tinkering. -Black magic. -Naked ladies and gentlemens. -Werewolves. (Who are also the naked ladies and gentlemens). -Profanity and swearing -Act of questionable morality from both the good guys, the bad guys, and the dolls who wouldn't know what morality is if it bite them in their straw-filled head. -Black humor, dark enough to depress an undertaker. Please, do not suggest this story to children, innocents and/or faint of heart. Thank you.", True, True)
add('HiddenStrengthAWhiteNuzlocke', 'http://hsnuzlocke.smackjeeves.com/comics/', u'Clover, Cheren, and Belle graduate from trainer school, looking forward to finally being able to go on a pokemon journey of their own. Things start out like any other adventure, however soon the trio becomes entangled in the mess that is Team Plasma, finding out secrets that have been hiding in plain sight all their lives. How will their adventure unfold? This is a Nuzlocke story comic. [THIS COMIC IS FINISHED]', False, True)
add('Hinata', 'http://hinata.smackjeeves.com/comics/', u'Fifteen years ago, mankind faced a terrible disaster. In order to protect his daughter, Hinata, from danger, Shinsuke Akao retreated deep into the forest. He secluded himself, never leaving the forest while he reared and educated Hinata, never allowing her to leave either. On the morning after her sixteenth birthday, Hinata wakes up to find her father missing. With no clues as to where he went, Hinata casts aside the safety of the forest and forges out for the first time into the post-apocalyptic cityscape on a quest to find her father and discover what exactly happened to the world fifteen years ago.', False, True)
add('HitandMiss', 'http://hitandmiss.smackjeeves.com/comics/', u"It's a autobiographic comic about, well, me and my daily life! Doesn't that sound interesting? WARNING: This comic may contain the following; misspelling, weird situations, gaming, horrible puns, cats, depression, and the occasionally lovey dovey stuff. http://www.theduckwebcomics.com/Hit_and_Miss/ ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ The link to DrunkDuck Hit and Miss!", False, True)
add('Holocrash', 'http://holocrash.smackjeeves.com/comics/', u'Welcome to HoloCrash, the adventures of Commander Teelianna Santo ("Teela") and her Genetically Enhanced Nanotech Android trainer ("G.E.N.A"). Teela, a brilliant science officer and an exceptional athlete, volunteers for a year round trip aboard the cargo freighter Argenta-619 so that she, along with her trainer G.E.N.A, can train for the upcoming Pan System games in heavy gravity conditions. Soon, what seems like a normal freight run to the Cordas System, turns into an adventure like no other!', True, True)
add('HolyBlasphemy', 'http://holyblasphemy.smackjeeves.com/comics/', u'Making fun of religions since 2010. Better stay clear of this comic if you really cannot stand people making fun of Atheism, Buddhism, Christianity, Creationism, Germanic and Greek Polytheism, Hinduism, Islam or Judaism as well as of Abraham, Agni, Aliens, Angels, the Easter Bunny, Great Ctuluh, Isaac, Jahweh, Jesus, John the Baptist, Joseph, Mary, Mohammed, normal humans, Pascal, robots, Santa Claus, Satan, Tantalus, Thor, Vishnu, well-built catholic girls, Zao Jun or Zeus (more religious belief systems and persons may follow). Updates whenever I find the time (not that often lately...). Comments and voting highly welcome!', False, False)
add('HolyCrap', 'http://holycrap.smackjeeves.com/comics/', u"Hi there! Welcome to what-ma cha' call it? ... Oh that's right Crap Holy. No no... AH! WELCOME TO ME! I AM HOLY CRAP!", False, True)
add('HopeForABreeze', 'http://h4ab.smackjeeves.com/comics/', u'Hope For A Breeze - This is a story of a girl named Sophia and her journeys through life. webcomic, web comic, school life, slice of life, school, drama, anime, autobiography, memoirs, manga, cartoon, comic', False, False)
add('HotChocolate', 'http://hot-chocolate.smackjeeves.com/comics/', u"COMPLETE! Other art and doodads will be added, but as for the story, it's finished! Thanks to all the readers!", False, True)
add('HouseofCraziness', 'http://craziness.smackjeeves.com/comics/', u'A house of pure craziness.', False, True)
add('HurrocksFardel', 'http://hurrocksfardel.smackjeeves.com/comics/', u'', False, True)
add('Hybristorific', 'http://hybristorific.smackjeeves.com/comics/', u'A graphic graphic novel about friendship, philosophy, and serial murder. Updates every Sunday and Wednesday.', True, True)
add('IWishIggysWish', 'http://i-wish-comic.smackjeeves.com/comics/', u'Iggy and his companions are the resident wish-granters of a sleepy little English town. All three of them are perfectly happy doing their jobs and making human wishes come true, but one day they get a message from the Embassy of Magic which could change all this for good... Can Iggy restore faith in human nature and save the town he loves from being cut off from the magical world forever? Updates: Once a week, usually on Mondays.', False, True)
add('Ianua', 'http://ianua.smackjeeves.com/comics/', u"/\u02c8ja\u02d0.nu.a/ Welcome to a land where magic has always existed. In recent years the ability to summon 'other worldly' creatures has brought about sharp class distinctions and radically altered society as a whole.", False, True)
add('IciVontLesMorts', 'http://icivontlesmorts.smackjeeves.com/comics/', u"Ici Vont Les Morts raconte l'histoire de Sunday une petite fille d'une dizaine d'ann\xc3\xa9es et de sa poup\xc3\xa9e Mojo. Mais si vous cherchez des aventures magiques et amusantes dans un monde color\xc3\xa9 comme un paquet de bonbons, passez votre chemin. Ici Vont Les Morts parleras de vengeance, de ce qu'on est pr\xc3\xaat \xc3\xa0 sacrifier pour l'obtenir. Du mal n\xc3\xa9cessaire et de celui qui l'est moins. Des choix qui ne sont pas toujours les bons ou, parfois, de ne pas avoir le choix tout court. Des erreurs que l'on fait, que l'on choisit de corriger, ou pas. Dans Ici Vont Les Morts, vous trouverez t\xc3\xb4t ou tard : -Des zombis (humains, oiseaux, chiens, insectes, tous plus ou moins d\xc3\xa9compos\xc3\xa9s) -Des violations de s\xc3\xa9pultures. -De la magie noire. -Des demoiselles et des messieurs nus. -Des loup-garous. Qui sont aussi les demoiselles et messieurs nus. -Des blasph\xc3\ufffd\xc2\xa8mes, jurons et autres noms d'oiseaux. -Des actes de moralit\xc3\xa9s douteuses, autant des gentils, que des m\xc3\xa9chants et des poup\xc3\xa9es vaudous qui ne sauraient pas ce qu'est une moralit\xc3\xa9 si on leur tapait dessus avec. -De l'humour noir. Tr\xc3\xa9s noir.", True, True)
add('ImminentMoose', 'http://imminentmoose.smackjeeves.com/comics/', u'"EVERYTHING IS WONDERFUL" :~ THE HIATUS IS OVER! UPDATES EVERY SUNDAY!~: NOW DOING COMMISSIONS!', False, True)
add('InHouseHumor', 'http://inhousehumor.smackjeeves.com/comics/', u'', False, True)
add('Inchoatica', 'http://inchoatica.smackjeeves.com/comics/', u"Don't eat the demon-infested sandwiches, no matter how tasty.", False, True)
add('Ingloriousbasterds', 'http://ingloriousbasterds.smackjeeves.com/comics/', u'Tired of sad stories with a grey and gloomy graphics? Then watch this bright arcade. The comic is not translated into English.', False, True)
add('Inhuman', 'http://inhumancomic.smackjeeves.com/comics/', u"1000 years in the future, a schizophrenic has been kidnapped by a group of rebel soldiers. And it seems they've bitten off more than they can chew...", False, True)
add('InsideOuTAYuriTale', 'http://insideout-a-yuri-tale.smackjeeves.com/comics/', u'A new Yuri series dealing with love, life and true friendship. The story follows new high school student Hitomi who decided to stop pretending to be someone else and start being herself. This decision leads to many odd encounters as she enters high school life and find her life is turned Inside OuT. Warning this manga is read Right to left. <<This way<<', False, False)
add('InspiredByADream', 'http://inspiredbyadream.smackjeeves.com/comics/', u'in\xb7spire |in-spahyuhr| ~to fill or affect with a specified feeling, thought, etc ~to prompt or instigate (utterances, acts, etc.) by influence, without avowal of responsibility dream |dreem| ~a succession of images, thoughts, or emotions passing through the mind during sleep ~a vision voluntarily indulged in while awake; daydream; reverie ~a wild or vain fancy Updates: Saturdays 1-2 pages a week.', False, True)
add('InthePride', 'http://in-the-pride.smackjeeves.com/comics/', u"Well, I can't really describe this thing.", False, True)
add('Intoxicated', 'http://intoxicated.smackjeeves.com/comics/', u"This is the story of Robert, who tries to manage his relationships in his life of drug abuse, break up's and strong emotions. The comic is finished, but being redrawn, so quality might change between newer and older chapters. Contains drugs, sex and profanity. Approximately rated: 15", True, True)
add('Itsan8BitWorldBlankWorld', 'http://8bitblankworld.smackjeeves.com/comics/', u'This comic\'s premise is simple. This is the White Space, or "Blank World" of my It\'s an 8-bit World Comicverse. Here all the characters, past, present, and future can interact and do crazy, random, and all-together odd things for your own entertainment. Of course, they have to be careful so as not to piss off the local Rulers of the Universe...', False, True)
add('JackiesStory', 'http://jackiestory.smackjeeves.com/comics/', u"Jackie's Story is an online flash webcomic adventure story about an alien named Jack (Better known as Jackie) who gets talked into participating in something that she hopes will bring back her dead brother. For the animated version: http://jackiestory.weebly.com/index.html", False, True)
add('Jantar', 'http://jantar.smackjeeves.com/comics/', u"Comic inspired mostly by Polish history and mythology. I'm not quite sure what genre this is. I just draw something I'd like to read. Mostly it's about romance and fantasy", False, True)
add('Jantarpol', 'http://jantar-pl.smackjeeves.com/comics/', u"Polish version. I'll submit English translation on this profile soon. Troch\u0119 romansu i troch\u0119 fantasy. Ci\u0119\u017cko mi w zasadzie opisa\u0107 co to za gatunek. Po prostu robi\u0119 komiks jaki sam chcia\u0142bym przeczyta\u0107", False, True)
add('Jason', 'http://jasoncomic.smackjeeves.com/comics/', u'Jason UPDATES ON MONDAYS AND FRIDAYS Based on characters from Wuthering Heights, the story follows Jason as he encounters new people in his first year of University, and is torn between his feelings for the tempestuous and unpredictable Elijah, and Lon, a universally adored musical prodigy. All the while Jason is haunted by his self-destructive past, threatening to interfere with his future. TRIGGER WARNING: Contains graphic violence, sex, sexual assault, reference to suicide, self-harm, mental illness and strong language throughout. For my other art and more Jason artwork, go to my tumblr at jezbelizia.tumblr.com', False, True)
add('JoeysAdventure', 'http://joeysadventure.smackjeeves.com/comics/', u'Currently posting one page per day. This is the story about a self-confident young boy named Joey going through his Pokemon journey with his trust-worthy Teddiursa, Teddy. His original plan was to become a Pokemon Master as quickly as possible and beat both his older sister Cara and rival Dave to the title, but then he is told to travel with the clueless Zoe. Not far into their quest, the new trainers discover that Zoe can see auras that others cannot see, making her a target of a certain team that settles in a different region.', False, True)
add('JourneyMan', 'http://journeyman.smackjeeves.com/comics/', u'Life is a journey. Will finally seemed to be going places. But his plans take unexpected turns when cosmic forces intrude with occult plots and alien invasions. Can Will get a life as the galaxy burns? The first chapter includes old art from 2005 that will be fixed, later chapters have much better art.', False, True)
add('JoyToTheWorld', 'http://joytotheworld.smackjeeves.com/comics/', u'Meet Joy Fulbright, an 11 year old tomboy. Joy for the most part, is smarter than the world around her. Shes an angry only child who lives with her divorced mother and is does video blogs, films, and other mischievous activities. Joy ends up living in her own little world with her friends Kimmy and Neil, her schoolyard antagonists Gary and Joanna, and her arch-nemesis...boredom. Updates Sunday and Thursday weekly!', False, True)
add('June', 'http://june.smackjeeves.com/comics/', u'SORRY! NO DOGS ALLOWED (A 100% true autobiographic horror story. @tumblr: http://junecomic.tumblr.com) (@ MangaMagazine: http://www.mangamagazine.net/manga-and-comics/JUNE/detail-page/403?lang=en)', False, True)
add('JustAnotherLife', 'http://justanotherlife.smackjeeves.com/comics/', u"This is a comic on my daily life in highschool, and other stuff as well. WARNING: May be uploaded slowly because I am extremely lazy. (Or I don't have anything interesting to draw.) There is also some minor cursing, just saying.", False, True)
add('JustCrazy', 'http://justcrazy.smackjeeves.com/comics/', u'17 year old Jay\u2019s childhood ends up being destroyed by a spirit from the unknown. Ever since that night, Jay has been haunted with one question, which repeatedly reappears in his daily life. Testing Jay\u2019s strength and beliefs within himself, Jay finds him self constantly involved in people\u2019s lives. All Jay ever wanted was to live a normal life; he shortly finds out that life is anything but normal. In fact life is Just Crazy. :::Please read Right to Left thx:::', False, True)
add('Justmyluck', 'http://justmyluck.smackjeeves.com/comics/', u'Andreia is a normal girl, if you forget the fact that she\x92s the unluckiest girl in the world. Tired of her life, she leaves her home and goes to another town. But of course things don\x92t go as planned. Andreia meets Jason, who is a pain in the ass and very cold to her. She finds herself stuck in the biggest problem of her life, with nowhere to turn.', False, True)
add('KCNO', 'http://kcno.smackjeeves.com/comics/', u"A simple town in love with a simple radio station show. KCNO's Love Me Do, is the most popular show on the airwaves. Its success is owed to the host, Jason who has impeccable advice to give people struggling through love. But when a simple question moves the town to seek out Jason, his attempts at secrecy become the newest talk of the town.", False, True)
add('KaitoShuno', 'http://kaitoshuno.smackjeeves.com/comics/', u"a man named Kaito goes to commit suicide after living a boring, loveless, cubicle job. He meets a strange guy named Shuno...and Shuno immediatly takes a liking to him...almost too fast to be real XD Kaito quickly makes it clear that he isnt gay...but will Shuno's actions toward him make him alittle...'confused'? lol Kaito's been in such a need for love that maybe Shuno's affection doesnt look THAT bad...or does it?:P YAOI!! RSS FEED: http://kaitoshuno.smackjeeves.com/rss/", True, True)
add('KasaKeira', 'http://kasakeira.smackjeeves.com/comics/', u'<b>The story of a girl, her magic umbrella and the hundreds of demons trying to kill her</b>', False, False)
add('Katran', 'http://katran.smackjeeves.com/comics/', u'This is the Story of Nirrod, an almost normal 14 year old boy. He is living with his Family and his clan in a big village in the north of Katran. Build on a giant cliff, it became one of the safest places in the land, and soon a very precious trading point. Nirrod is living his life well protected and without sorrows in the lap of his clan. he is playing with other kids, playing pranks....a normal life. but all of this is going to change....', False, True)
add('KazanatoFuneralPlanningService', 'http://kazanato.smackjeeves.com/comics/', u'Chou and Fuyuka are partners who work for Kazanato Funeral Planning Service. They guarantee that their clients are fully satisfied, especially the deceased.', False, True)
add('KezroChroniclesPhantomOps', 'http://phantomops.smackjeeves.com/comics/', u'An Anthropomorphic Cyberpunk Adventure. Follow a whole cast of characters as they uncover the secrets of the underworld, corrupt governments, love, and cybernetics. *Most Pages are PG-13 Some pages may be NSFW* Updates on Fridays', False, True)
add('Kirbandfriendsshowcase', 'http://kas.smackjeeves.com/comics/', u'a new kirb and friends!^^', False, True)
add('KirbiesoftheAlternateDimension', 'http://kirbyaltdimension.smackjeeves.com/comics/', u"A delightful comic that may contain mild language about the life of the kirbies that live in the other dimension. It is a story about adventure, suspense, and drama, and of course, comedy. (A comic isn't a comic without comedy.) Current Chapter: Epilogue The final pages of this comic, which will lead up to the arrival of the YouTube series of Kirbies of the Alternate Dimension. A dark threat approaches and Team KAD has defeated Daroach an his crew. All things are looking good for everyone, but the masked Kirby and the shadow Kirby have something up their sleeves.", False, True)
add('KirbyAdventure', 'http://kirbysadventure.smackjeeves.com/comics/', u'Meet the Kirby Adventure Squad: a group of Kirbies who take requests from random clients and attempt to complete them! And mostly fail miserably! Huzzah!', False, False)
add('KirbyDreamTeam', 'http://kirbysdreamteam.smackjeeves.com/comics/', u'Join Kirby and his Dream Team as they team up to take down evil!', False, True)
add('KirbyFunfestTheOriginals', 'http://kirbyfunfestold.smackjeeves.com/comics/', u'Kirby and his best friend Dee are minding their own business, when Dedede challenges Kirby to a duel! Since then, Kirby and Dee have to save the world from seemingly unstoppable forces of nature, and all the while they still have time to be funny... NOTE: I am restarting this comic, see it at http://kirbyfunfest.smackjeeves.com/', False, False)
add('KirbyTheDeeArmy', 'http://kirbyandthedeearmy.smackjeeves.com/comics/', u"One day, a kirby named Sapphire comes from the future and warns Kirby about a coming disaster. Kirby, of course, doesn't listen and sets the events into play. However, there is a way to stop it. But they must hurry, or the future will be doomed... Idea and pages by Luigi_96, Helped by Ultimate Yoshi. Updates: Tuesdays --- Kirby and related characters owned by HAL and Nintendo. Sprite credit to the various people who ripped them.", False, True)
add('KirbysDreamAdventure', 'http://kirbyda.smackjeeves.com/comics/', u"What's better than one Kirby? A whole mess of them, that's what! Follow them around their little adventures and daily lives, from the early randomness to the more story-built latter parts. It's a Kirby adventure worth watching, even if the main pink puffball doesn't get as much direct screen time as he should! ~+~New pages come out daily, old pages get redone during the weekend.~+~", False, True)
add('KirbysDreamlandAdventures', 'http://kirbysdreamlandadventures.smackjeeves.com/comics/', u'A retelling of the many adventures Kirby has had over the years since 1992. Updates Saturdays and sometimes Wednesdays.', False, True)
add('KissmeSnow', 'http://kissmesnow.smackjeeves.com/comics/', u'\u201cThe Snow just keeps falling, never melting away, never allowing spring to arrive.\u201d Shirayama, a small mountain town, hasn\u2019t seen spring in decades. Young man named Keiji suffers from fear of cold, and wants nothing more than get away from the town and its prevailing eternal winter. However, when he encounters a mysterious girl called Lumi and finds out the secret behind the mysterious hypothermia deaths, he has to confront his own fears, not only for his own, but also for the entire town\u2019s future. ---------------------- Updates on Mondays', False, True)
add('KissoftheDevil', 'http://kissofthedevil.smackjeeves.com/comics/', u'Vist us at http://www.smackjeeves.com/comicprofile.php?id=110041 Thanks! Shadow Leafeon', False, True)
add('Knife', 'http://knife.smackjeeves.com/comics/', u"READ LEFT TO RIGHT -------------> It's BL Story's not too greatly done, contains some ugh, stuff. Like incest rape stuff. Though you don't see anything, putting that out there for people sensitive to such matters. Might offend you. Though the stuff is kind of dark it's not about depression. And I haven't been through the stuff the characters have gone through, I don't even know why I wrote about this. im gonna shut up now.", False, True)
add('Knightface', 'http://knightface.smackjeeves.com/comics/', u'A paladin who betrayed abusive people who used to be his friends seeks to rebuild faith in himself and his god.', True, True)
add('KnightsRequiem', 'http://knightsrequiem.smackjeeves.com/comics/', u'With weaponry called Emblems, the knights of NYX had always protected humanity from monsters of the night, the vampires. This is a story of a few new knights discovering just what it is like to become slayers', False, True)
add('KojiX5', 'http://kojix5.smackjeeves.com/comics/', u'\xbfQue de qu\xe9 va? Pues a grandes rasgos, es la historia de Hideyuki Hori, un chico muy t\xedmido y torpe, que en el d\xeda de su graduaci\xf3n se encuentra con un mago que le da un libro con un conjuro m\xe1gico que se supone que le ayudar\xe1 con su problema, pero lo cierto es que le causa m\xe1s entuertos. Adem\xe1s se enamora de su profesor de matem\xe1ticas, que no se entera de nada. Bueno, pues este es bastante antiguo, lo ide\xe9 en el 2003, y esta es la versi\xf3n que dibuj\xe9 durante 2006 y 2007. Es tan antiguo, tan antiguo, que no sab\xeda ni para qu\xe9 serv\xeda una regla. La dibuj\xe9 a una super velocidad mientras estaba en clase. Es una historia que sigo desarrollando actualmente. B\xe1sicamente, esta es una idea "deshechada" (vamos, que s\xf3lo queda de ella algunos personajes) pero hay algunas cosas que me gustan todav\xeda. Ah, s\xed, se lee de izquierda a derecha. Te gustar\xe1 si: -Sabes espa\xf1ol -No odias el shonen-ai -Te gusta ver al protagonista pasar verg\xfcenza', False, True)
add('Kranburn', 'http://kranburn.thewebcomic.com/comics/', u'An Australian Post Apocalypse Comic', False, True)
add('Kreetor', 'http://kreetor.smackjeeves.com/comics/', u'', False, True)
add('Kruptos', 'http://kruptos.smackjeeves.com/comics/', u"NOTICE! This comic was made in 2011-2014. I didn't plan it enough and started it pretty much as a improvisation comic that didn't have an actual plot so it's a quite fuzzy. --- Kruptos means hidden in greek which descripts very well the whole comic. Kruptos is actually a story about two wolf brothers whose parents were murdered and who just try to survive together. WARNINGS: slight connotations to things like transgender, homosexuality, cannibalism, massacre and murder but also strong content (blood and violence)", False, True)
add('KuroNeko', 'http://kuro-neko.smackjeeves.com/comics/', u"A cold day, Yuta finds something unexpected on the way home: a boy bruised and unconscious in a dark alley. Everything would be normal if not for that boy has the peculiarity of having cat ears and tail. Despite the opposition in the beginning of that boy-cat, named Riku, finally begins coexistence between the two, which, far from the tranquility that might be expected, is not devoid of surprises. And is that something doesn't ceases to torment Riku... \u2605 Yaoi / BL \u2605 \u2605 Reading from right to left \u2605 For reading in Spanish here \u2192 http://kuronekoyaoiwebcomic.blogspot.com.es/", False, True)
add('KuronaFlutterandLylaSpamTime', 'http://icantflyaplane.smackjeeves.com/comics/', u'Self-explanatory. Credit to SEGA, CAPCOM and NINTENDO for most edited sprites in here. Alternate title: Aura and his girls~', False, True)
add('LOGOS', 'http://logoscomic.smackjeeves.com/comics/', u'In the far future, on a distant planet, a man made of plastics discovers what it truly means to be human.', True, False)
add('LOKI', 'http://loki.smackjeeves.com/comics/', u'LOKI is the story of Lochlan and Kian, two down on their luck and only vaguely competent guns for hire, and their adventures. Updates on Tuesdays and Fridays!', False, True)
add('LastBlockStanding', 'http://lastblockstanding.smackjeeves.com/comics/', u'A post-apocalyptic story (yeah, we\'ve never seen that before in a comic!) with just one premise: what would you do if you were the last people left on an utterly devastated world? Even more weirdly, what would you do if you were not only the last living things left alive, but you were all stuck in the same 40 storey ("story" US people) block of flats (apartments, US etc...)? Answer? defecate yourselves? commit suicide or somehow find someway to survive? These are the stories, drawn and written using only the Sketchbook App on an iPad with my clubby fingers. It\'s guerilla comic book creation and I hope you enjoy it despite its erratic fonts and pretty awful draftsmanship... Enjoy...', False, True)
add('LastLivingSouls', 'http://lastlivingsouls.smackjeeves.com/comics/', u"It's probably safe to assume you know what a zombie is; A living corpse with an insatiable craving for human flesh that mindlessly acts on primal instincts. But, what would happen...if a zombie became able to think? Along side an empty road, a teenager named Eddie awakens, confused and fearful due to his inability to remember anything. He heads towards the nearest city in hopes of getting some help, but realizes it is nearly empty of residents and is instead being slowly consumed by a group of undead. It quickly becomes his purpose to survive and also to understand why these creatures are plaguing the city...and why he is one of them.", False, True)
add('LatchkeyKingdom', 'http://latchkeykingdom.smackjeeves.com/comics/', u'Comic tales of a (mostly) fearless adventurer in a land of many dangers and little adult supervision.', False, True)
add('LavenderLegend', 'http://lavenderlegend.smackjeeves.com/comics/', u'Epic Romantic Adventure! The men have gone to war. The princess is sealed away from their sight. Her favorite maid has a scandalous secret, and plans to overthrow the king.', False, True)
add('LeCirquedObscure', 'http://cirquedobscure.smackjeeves.com/comics/', u'A dark circus collaboration roleplay comic- open to everyone!', False, False)
add('LedbyaMadMan', 'http://ledbyamadman.smackjeeves.com/comics/', u'The country is devoid of life save for five people who try to stay alive the best that they can.', False, True)
add('LegendofZeldaAHerosStory', 'http://aherosstory.smackjeeves.com/comics/', u"The story of Ocarina of Time retold, will Link summon the courage to save his friends and the ones he cares about before it's too late? Find out and see!!", False, True)
add('LegendofZeldaStaffofPower', 'http://loz-sop.smackjeeves.com/comics/', u'An ancient weapon created for harmony brought civil war. Shattering it brought tentative peace, until the leader of the Gerudo attempts to slaughter an entire race of people, then turning his hatred upon the monarchy of Hyrule. Defeated by the Hero of Time and the Princess of Destiny, he was sealed away in the Sacred Realm. Years later, he has gained more power, and has broken free. Now it will take the very weapon he seeks to destroy him, and an unlikely wielder to complete the task. Who will win? ~Like the comic? Want to support the author? Click the image at the bottom of the page to do so!~', False, True)
add('LegendofZeldaTheEdgeandTheLight', 'http://legendofzelda.smackjeeves.com/comics/', u"After years of absence, Link finally returns to Hyrule from his travels abroard. Initially expecting to greet Princess Zelda, he instead finds the kingdom in decline, plagued by all kinds of trouble. Just what is causing these problems, and does it have anything to do with why Link left in the first place? NB: This story is now finished, at 11 chapters and 312 pages! Thanks to everyone who read it. For those who want to know what I'm doing next, please check my DeviantArt account (http://queeniechan.deviantart.com/)", False, True)
add('LegendofZeldaTheWindWaker', 'http://zeldawindwaker.smackjeeves.com/comics/', u'The Legend of Zelda: The Wind Waker turned into a webcomic. I hope you enjoy it. Written by Emily-Ann Coons and drawn by Kitty Lyre. Currently updates every Monday at Noon EST.', False, True)
add('LegendsofMobiusBookOne', 'http://legendsofmobius-bookone.smackjeeves.com/comics/', u'It\'s been two years after Sonic the Hedgehogs last adventures. A hedgehog named Crusade travels around planet Mobius and randomly or not, becomes friends with several other mobians. But on his journey dangerous things happen and concerning news spread. And so, Crusade and his comrads, later known as "Team Element", decide to search for the root of everything. Without knowing that they get involved into a war which will decide about the worlds future...', False, True)
add('Lemongrass', 'http://lemongrass.smackjeeves.com/comics/', u"A soldier on a mission that goes disastrously wrong, two assassins caught in the web woven by their enigmatic mistress, and a mercenary on the run from just about everyone he's ever worked with. Brought together through by chance, they find their lives thrown into chaos by a disaster centuries in the making. Gay, lesbian and bisexual characters. Full colour. Currently updating with two pages every Sunday.", False, True)
add('LesCendresdelHiver', 'http://cendres.smackjeeves.com/comics/', u"Il \xe9tait une fois un f\xe9, une Belle Dame Sans Merci ; et il \xe9tait une fois le chevalier, un parmi beaucoup d'autre, que le f\xe9 s\xe9duisit. Puis le f\xe9 se lassa du chevalier, comme il s'\xe9tait lass\xe9 de beaucoup d'autres, et le quitta. Mais ce chevalier n'\xe9tait pas comme les autres et les choses tourn\xe8rent tr\xe8s mal. Bien des si\xe8cles plus tard, Meine, un garde du corps sans histoire, est approch\xe9 par un \xe9tranger qui semble le conna\xeetre... Et s'attendre \xe0 une r\xe9action bien particuli\xe8re de sa part. Quand il refuse de jouer le jeu de l'autre homme, Meine entra\xeene une s\xe9rie d'\xe9v\xe9nements qui pourraient changer non seulement sa vie, mais aussi celle de tous ceux qu'il aime.", False, True)
add('LetLoveRule', 'http://letloverule.smackjeeves.com/comics/', u"When Daisy de Jong is forced to go on a cruise with her mother in order to find a rich fiance, she notices strange things happen on deck. After an odd turn of events she falls overboard and finally comes ashore of a strange island, where a mysterious boy takes her with him. Do the strange situations on the ship have something to do with the weird island? Will she ever see her mother or home again? Read 'Let Love Rule' to find out!", False, True)
add('LethalDose', 'http://lethaldosecomic.smackjeeves.com/comics/', u"WARNING: This comic contains heterosexual AND homosexual relationship, Drug abuse, sexual themes and violence. READ RIGHT TO LEFT - JAPANESE FORMAT Updates every Sun & Wed. ________________________________ Follows the life paths of various youths. Our main protagonist is Bobby. Although he was a happy kid, various choices in life have led him down a dark and dangerous path. Lonely and stuck with an undesirable life, he has turned to drugs and alcohol to mull the days away with. But after a strange encounter in an alleyway one night, Bobby finds himself trapped in a much more 'hardcore' underground world of drugs and abuse; one that's secrets are so dark it's not too easy to leave behind.", True, False)
add('LetsBreakitforReals', 'http://breaktehmentality.smackjeeves.com/comics/', u"We're back, not sure who cares about it or wants it but whatever. Screw the whole trying to be the largest author comic on SJ, let's just go crazy. Rules: 1.Keep it pg-13, odd swear here and there is fine. 2.Respect people and try not to undermine them. 3.No spamming updates. 4.No rapping.", False, True)
add('LicensedHeroes', 'http://licensedheroes.smackjeeves.com/comics/', u'Join Tempest, newly licensed hero, as he delves deep into the reeking bowels of the dungeons of unemployment, crosses the scorching desert of menial labor and infiltrates the dreaded towers of bureaucracy. Updates Wednesdays and Saturdays.', False, True)
add('LifeAsACutOut', 'http://lifeasacutout.thewebcomic.com/comics/', u'Come follow the adventures of the train obsessed, "failed" government experament, Railin "Rail" Machanic and his assorted friends and aquatinces across real places of Southern Pennsylvania, and some not so real. The mundain is far from boring here.', False, True)
add('LifeAsItWas', 'http://lifeasitwas.smackjeeves.com/comics/', u"It's a web comic, I make it and you read it. Updated daily.", False, True)
add('LifeLessOrdinary', 'http://lifelessordinary.smackjeeves.com/comics/', u'"Live a life less ordinary Live a life extraordinary with me My face had said too much Before our hands could even touch To greet a \'hello\'" The story of four guys living together under one roof, their individual feats and those that they move through together. Some BLs and HLs. Some inspiration drawn from the song Life Less Ordinary by Carbon Leaf.', True, True)
add('Lifeonpaper', 'http://lifeonpaper.smackjeeves.com/comics/', u'"Life on Paper". Is a comic strip very loosely based on my life, originally it was titled, "Lil Bastard" It follows me and all my jobs, relationship, and even through marriage. With 2000+ strips. Which will eventually be uploaded here. Please Enjoy my life.', False, True)
add('LightLovers', 'http://lightlovers.smackjeeves.com/comics/', u"Jay and Nicolas are the Lightlovers. Thanks to their love, they are the most powerful magical beings in the Galaxy of Geland. They will be confronted to all sorts of characters (flying-men, butterfly-men, elves, daemons, vampires, ...). Ten stories have already been written. Drawing them will take a little more time, patience ! You won't be disappointed ! Dear readers, be tolerant with my English, it's not my mother tongue !", False, True)
add('LightwithinShadow', 'http://lightwithinshadow.smackjeeves.com/comics/', u"After the truth about her adoption is told and a string of weird dreams a girl named Lizzie sets out on a journey of self discovery....it's more then she bargained for- -But maybe with the help of her goofball best friend, her history teacher,her loyal dog, and a hired mercenary she just might get through this.", False, True)
add('LilLevi', 'http://lillevi.smackjeeves.com/comics/', u"Lil' Levi is 9 years old. His mother is human. His father is The Devil...no really...we're not kidding. His life is going to be one hell of a ride! It's kind of like The Omen...but funnier!", False, True)
add('LiliBleu', 'http://lilibleu.smackjeeves.com/comics/', u'Webcomic en espa\xf1ol La humanidad ha quedado al borde de la extinci\xf3n por causa de un virus que los muta en superhumanos poderosos, dotados de una gran belleza y poder que han tomado control del planeta. De entre el nuevo orden se alza la \xfaltima esperanza de la humanidad: Espartaco Garc\xeda, armado s\xf3lo con una de las mentes m\xe1s brillantes del mundo en contra de seres que pueden derribar monta\xf1as con su mirada. S\xf3lo hay un problema: Quiere salvar el mundo... para gobernarlo \xe9l.', False, True)
add('LondonUnderworld', 'http://lunderworld.smackjeeves.com/comics/', u"Miss Ameliea Worton is sick of the rich, upper class, boring world she has been brought up in. She seeks entertainment from London's dark under belly, making friends with crooks and con artists and playing their games against the aristocracy she has grown bitter of. But, when Ameliea decides to join forces with the king of the London Underworld, she discovers how naive she has been, and how dangerous London can really be.", False, True)
add('LostNova', 'http://lostnova.smackjeeves.com/comics/', u'Two women of different birth search for the lost Compass Isle of Nova. One for glory, one for truth. And in the process they will find themselves and each other.', False, True)
add('LoveHarbor', 'http://shipcentral.smackjeeves.com/comics/', u"This is a comic about shipping your characters. You can do as you please with your shippings, but please try to keep them to a T rating and below. Shipping: To support a relationship between two characters, be it canon or not. You will get a chapter here. All shipping of your design are to be posted in your own chapter. The point is to post pictures of shippings. (Sprites, Drawn, pixel art, etc.) These can be in the form of comics, author comments, etc. Your shippings can be gay, straight, lesbian and bi. So homophobes beware. You may post shipping of other authors. If you have any questions, contact 'aqua the hedgie' for more information. ------ Don't ship real people. At least poke holes in the box.", False, True)
add('LoveMeLoveMyTeddyBear', 'http://teddybear.smackjeeves.com/comics/', u"The story is of a girl named Harmony Adams, who's loving father gave her a teddy bear when she was born. He wished on the teddy bear that if anything was ever to happen to him, the teddy bear would be there to protect and love Harmony. But when Harmony is 16 years old, her father passes away, and in fulfilling his wish, the teddy bear gains the ability to turn into a human...", False, True)
add('LoveTwister', 'http://lovetwister.smackjeeves.com/comics/', u"Love Twister! For Chiko,only working and studying is her priority in life,But when Warren came many things began to change until she knew that this person's face is not having two but three. His other twin is Harren her Math teacher,he is the complete opposite of Warren and the other is Darren, an aspiring celebrity who's known for being a playboy And its getting more complicated living with the three guys with the same face under one roof,What will she do when Love came like a twister? genre: shoujo manga read left to right", False, True)
add('LoveandIcecream', 'http://lovexandxicecream.smackjeeves.com/comics/', u"Beware its a Yaoi! (Boy + boy) This comic is about two boys (surprise) (GOD the start is ugly) Akio and Bambi is two very different boys who met each other because Bambi had to teach Akio in math. Bambi is the only person who ever believed in Akio which is making Akio fall easily in love with him. Sadly Bambi has a homophobic big brother named Cinder who won't let Akio get closer to Bambi. Will Akio and Bambi ever get a chance for love? Gotta read and find out Don't let the ugly start pages scare you away\xa0 I UPDATE WHEN I WANT (Often enough)", False, True)
add('LoveroftheSunandMoon', 'http://loverofthesunandmoon.smackjeeves.com/comics/', u"[will HOPEFULLY be uploading new pages every friday, so if you're interested in this webcomic check for updates on fridays!] Kari is the child of the sun goddess and the moon god, and after a lunar eclipse he becomes a boy with white hair and pale skin, but after a solar eclipse he becomes a girl with golden hair and eyes and tanned skin! however the goddess of chaos, Rei, wants Kari captured and sacrificed on the alter of chaos as a girl in order to give her the power she needs to break free from the chaos realm to fill the human world with her delicious chaos! now Kari is on the run from Rei, and along the way he meets Gaku, a bouncer at a small bar, who decides to tag along with Kari and try to help him escape from Rei and her followers! has yaoi - boys love (boy meets boy) but also has some straight opportunities! but if you dont care for yaoi then please dont read this or if you love yaoi and the idea of a straight couple freaks you out dont read this either since the main boy turns female and this is supposed to be a love story that trancends gender!", False, True)
add('LsEmpire', 'http://l-empire.smackjeeves.com/comics/', u'Luigi has left Mario, and gone out to prove he himself. With the help of Dimentio, Geminiman and Void; will his dreams of recognition come to fruition, or is he doomed to being second banana? Either way, we can be sure that it will be very silly. Updated 8:00am every day. Specials go up at 12:00am.', False, False)
add('LuffinpuffandEric', 'http://luffinpuff.smackjeeves.com/comics/', u'The magical adventures of a fat kid named Eric and his fanciful imaginary friend, Llewellyn Luffinpuff!', False, True)
add('LumasParadise', 'http://luma.smackjeeves.com/comics/', u"Welcome to Luma's Paradise, the one and only place in the galaxy where you can find sprite comics starring the Lumas!", False, True)
add('MUTE', 'http://muterobot.smackjeeves.com/comics/', u'We fight for what we believe in and for those we care about. With terms and beliefs like these, who is to decide what is right and what is wrong? It is our emotions that fuel our actions, but is allowing them to take over really the right course of action in drastic situations...? Comic completed.', False, True)
add('MYth', 'http://myth.smackjeeves.com/comics/', u"MYth is a collection of original short stories inspired by the Greek mythology. Since it's MY version, the storyline differs from the classic mythology. .: MYth: My Seasons :. Demeter's sudden disappearance left Hades nothing but a daughter named Persephone... .: MYth: Eternal Gift :. The story of Poseidon and his true love... .: MYth: A PROMISE :. Before the time of the Olympians. Promises...made and broken... Between two brothers, only regrets remained. ***MATURE CONTENT APPLIES TO MYth: A PROMISE ONLY*** MYth (c) Zelda C. Wang http://zeldacw.idv.st http://zelda994612.deviantart.com", False, False)
add('MagicalGirlAlice', 'http://magicalgirlalice.smackjeeves.com/comics/', u'Behold the daily life of Alice Kamelot, a magical girl who is just looking to have fun and excitement.', False, True)
add('MagicalMisfits', 'http://magicalmisfits.smackjeeves.com/comics/', u'Two Dwarf Brothers are asked to start an Institute of Magic to promote peace on Terra. They have no idea what they are about to unleaseh', False, True)
add('Magience', 'http://www.magience.co/comics/', u'------------------------------ Updates: M - W - F at Midnight EST Rated PG-16 for Language, Violence, and Adult Themes ------------------------------ "Magience" was a new video game, one you could play while awake OR asleep thanks to an innovative headset. No one was quite sure the exact technology behind it, only that it was top-of-the-line and very mysterious. In a world of fantasy, players get one character to level and adventure with, exploring an infinitely growing and evolving world. However, it\'s not long before people start to notice certain oddities, and certain strange theories and rumors start popping up all over the place, both in game and in real life. Crazy as it sounded, what if "Magience" wasn\'t just a game after all?', False, True)
add('Magipunk', 'http://magipunk.smackjeeves.com/comics/', u"Sci-fi Fantasy adventure comedy webcomic! Magical wooden spaceships, elves, aliens, pirates and robots! Infamous pirates Runt and Candy have a plan to get their hands on the ultimate treasure! But as they face the wonders and terrors of a galaxy's seedy underbelly, the greatest threat may prove to be their own ineptitude...", False, True)
add('Manifestedpart1', 'http://manifested.smackjeeves.com/comics/', u'Hi there my names Stuart and I\'m the main character of Manifested ...and i hate my author...even though hes me. "shut it and describe my comic to all the nice viewers out there." fine, basically its about how i came upon a power to enter other peoples stories(video games movies cartoons all that jazz)and just mess around in them meeting my favorite characters and getting some awesom stuff like more superpowers and new friends. it was awesome till he introduced some assholes who decided to ruin the fun. if ya want a higher quality version my deviantart is http://statrux.deviantart.com/ so far i have gone into many places of those there has been the Spider-Man movie, Devil May Cry, X-man, Legend of Zelda Twilight Princess, and Kingdom hearts 2. there are also many other references . also say hi to the other main characters Tyler and Midna...yes that Midna the one from the game.', False, True)
add('MarXistemTWC', 'http://marxistem.smackjeeves.com/comics/', u'The worst best worst comic about gaming life and coexistence ever made in the Internet, for the Internet users. (WARNING: CONTAINS STRONG AND SEXUAL LANGUAGE)', False, True)
add('MarioandLuigiMisadventures', 'http://mandladventures.smackjeeves.com/comics/', u'Cackletta is up to no good and stuff', False, True)
add('MariosDayJob', 'http://mariosjob.smackjeeves.com/comics/', u'A silly comic about Mario and Luigi\'s "real" jobs as Plumbers. Updates weekly', False, True)
add('MariovsSonicvsMegaMan', 'http://mvsvmm.smackjeeves.com/comics/', u"It's a battle of the three main video game mascots of the late 80's and the early 90's, Mario, Sonic, and Mega Man. Who will win this titanic battle worthy of Pay-Per-View?", False, False)
add('MarsMind', 'http://marsmind.smackjeeves.com/comics/', u'Attempting a comic journal. Lets see where it goes.', False, True)
add('Mascara', 'http://mascara.smackjeeves.com/comics/', u"As the smartest boy in school and a prodigy, everyone expects Ian to be a high achiever--\x97a future Nobel Prize winning genius. But he doesn't want to be the next Einstein. He just wants to be a makeup artist.", False, True)
add('MasqueradeWTTM', 'http://masqueradewttm.smackjeeves.com/comics/', u'Life sucks. Life sucks worse when you\u2019re doing it alone. Elias learns the hard way that falling down can be devastating without friends. And getting up after falling down is never easy. Unless, of course, you\u2019re not alone anymore. --- Masquerade will update on Sunday every week. NOTE: You may read up to two completed chapters ahead at Twelve Gates Manga (http://twelvegatesmanga.com). I post complete chapters there as opposed to weekly pages here. There are a few up already if you prefer to get ahead and read in bulk!', False, True)
add('MatildasSweetCakeCafe', 'http://mscc.smackjeeves.com/comics/', u"Welcome to Matilda's Sweet Cake Caf\xe9! Here you'll find four (fan)service minded girls ready to satisfy your sweet desires. So come on in, have a seat and enjoy the scenery.", True, True)
add('MaytheRainCome', 'http://maytheraincome.smackjeeves.com/comics/', u'William Weasel returns home after seven years of war only to find his hometown deep in a drought, and his life eerily empty and devoid of meaning. ------------ This comic became finished on March 31st, 2013 - about a year and a half after I began it. May the Rain Come is rated PG-13 (for depictions of PTSD and scary moments). Inspirations: Black-and-white movies, cartoon animals, stories passed down through the family about the horrors of war.', False, True)
add('Mazscara', 'http://mazscara.smackjeeves.com/comics/', u'After her tragic suicide, Hollywood celebrity elite Victoria Starfield is ressurected and assigned by a secret supernatural organization called Crowd Control ,to protect five specific children (and her fans) from a slew of demons, serial killers, hellraisers and fallen angels. Her only weapon, 250 feet of razor sharp, flesh splitting barbed wire and an infinite trail of black tears. Call her, Mazscara. WARNING: Mazscara is rated +18 for Graphic Violence, Profanity and Mature Themes.', False, True)
add('MegaManBattleNetwork7', 'http://mmbn7-twt.smackjeeves.com/comics/', u'The year is 20XX... People are very lazy because they have Net Navis that do everything for them since even desks are controlled through the internet. Some people use these Net Navis for fighting and are called "Net Battlers". But, who is the strongest Net Battler? This new tournament will decide that.', False, True)
add('MegaManTales', 'http://megamantales.smackjeeves.com/comics/', u'Follow the Adventures of G.B.A, a boy who ended up the MegaMan world and must find a way back home. Status: FINISHED! FOR REALZ NOW!', False, True)
add('MegaManiacs', 'http://megamaniacscomics.smackjeeves.com/comics/', u'The adventures of the MM7 cast, plus the fun-loving Andante, in an attempt to stop the forces of evil.', False, True)
add('MegaPain', 'http://megapain.smackjeeves.com/comics/', u"Core and Daniel find an old Mega Man 5 cartridge at a yard sale. As they pop it in, there's more to this game then they realize. A lot more. Updates on Sundays and Wednesdays.", False, True)
add('MelodyAndMacabre', 'http://melodyandmacabre.smackjeeves.com/comics/', u'A little girl befriends Death and encounters those who seek him. An odd little series about obsession and... you guessed it... death.', False, True)
add('MerirosvotSeikkailumerella', 'http://merirosvotseikkailumerella.smackjeeves.com/comics/', u'Satamakaupungissa asustavat kaverukset huomaavat kaupunginjuhlissa kaksi ep\xe4ilytt\xe4v\xe4\xe4 vierailijaa. Kolmikko p\xe4\xe4tt\xe4\xe4 ottaa selv\xe4\xe4 mit\xe4 vierailijat ovat miehi\xe4\xe4n, ja p\xe4\xe4ttyv\xe4t el\xe4m\xe4ns\xe4 suurimpaan ja vaarallisimpaan seikkailuun.', False, True)
add('MetroJack', 'http://metro-jack.smackjeeves.com/comics/', u'A gay ex-lumberjack and a straight metro-sexual room together while attending Boston College. Humorous shounen-ai hijinks and confused sexual orientations abound. BL/Yaoi UPDATES EVERY SUNDAY! Follow Metro-Jack on Tumblr!: http://metro-jack.tumblr.com/', True, True)
add('MewsDynasty', 'http://mews-dynasty.smackjeeves.com/comics/', u'A group of Pokemon professors meet to decide Mews fate. How will Mew respond?', False, True)
add('MidnightPrince', 'http://midnightprince.smackjeeves.com/comics/', u'Jeremy Locke is just a normal high school student, but his best friend Erik has a secret. He\'s a vampire and not just any vampire, a prince! Alexei Drako is Erik\'s ex-fiance and he\'s the prince of Neutrals, a race mostly like the humans but with the power to use magic and known to live longer than five centuries. Two years after his painful break up with Erik, he\'s back to look for a new "wife" and has set his eyes on Jeremy! Will Erik let this happen and will Cleo Saint, Jeremy\'s stalker friend, allow it as well? *Not really planning to put mature things in it yet but it does contain strong language and sometime in the future partial nudity. It\'s not just Shounen Ai, there\'s hetero love too *UPDATES ON FRIDAY AND/OR SATURDAY*', False, True)
add('MineS', 'http://mines.smackjeeves.com/comics/', u'A Minecraft parody webcomic. Updates Tuesday, Thursday, Saturday, Sunday.', False, True)
add('Minibot', 'http://minibot.smackjeeves.com/comics/', u'Created from the "Minibot Command" threads on the Smackjeeves forums. People gave suggestions of what Minibot should do next and I drew them! Special thanks to MINIBOT COMMANDERS (listed alphabetically) Afrohawkman, AFStaff, Antitime, avian-reader, Bagpipe, Bat McStar, Beany, Bowserknight, BreakCanyon, Eggie, Gibson Twist, granmastern, Hunterkirizaki, Jake48.2, johlin, MacSimon, neoblade42, Pyroman, The Radical, robybang, skystears, SonicBoom01, SuperBiasedMan, Supertoad, and wendy w. Original threads here: http://www.smackjeeves.com/forum/viewtopic.php?t=10155 http://www.smackjeeves.com/forum/viewtopic.php?f=20&t=2534', False, True)
add('MinorActsofHeroism', 'http://www.minoractsofheroism.com/comics/', u'The adventures of three young superhero sidekicks!', False, True)
add('Missing', 'http://missing.smackjeeves.com/comics/', u"When Alice's team is signaled missing, the lieutenant Rosae has to undertake a recovering mission. James will have to find his way in the tropical forest of Mesembre, which holds Underwater panthers, ninjas and a forgotten order besides natural dangers. But he will not be alone since Manon, Virgil and Setsu will be his teammates in this periple. However, this means James will also have much to do in his own team ... At least one update a week.", False, True)
add('Missingversionfrancaise', 'http://missingfr.smackjeeves.com/comics/', u"Quand l\u2019\xe9quipe d'Alice est signal\xe9e disparue, le lieutenant Rosae est charg\xe9 d'une mission de secours. James devra se frayer un chemin a travers les for\xeats tropicales de Mesembre, qui rec\xe8lent des Panth\xe8res d'Eau, des ninjas et un ordre oubli\xe9 en plus d'innombrables dangers naturels. Le lieutenant ne sera toutefois pas seul car Manon, Virgil et Setsu seront ses co\xe9quipiers pendant ce p\xe9riple. Cependant, cela signifie que James aura aussi beaucoup \xe0 faire avec sa propre \xe9quipe... Update tous les jours jusqu'au rattrapage de la version anglaise et ensuite au moins une fois par semaine. English version : http://missing.smackjeeves.com/comics/1472832/cover/", False, True)
add('MixupofallMixups', 'http://mixupofmixups.smackjeeves.com/comics/', u'Arcs sometimes happen here. Oh, and crossovers too but character wise. All characters and backgrounds used in this belong to their rightful owners, and credit goes to the people who ripped, edited and/or recoloured the sprites used.', False, True)
add('MobianChaos', 'http://mobianchaos.smackjeeves.com/comics/', u'Mobian Chaos: What year did rational thinking go out of style again?', False, True)
add('Mokepon', 'http://mokepon.smackjeeves.com/comics/', u"He wants to be the very best! That no one ever was... uh, no. Scratch that. Adventures and friendship were never something that appealed to Atticus... Shame that it's a pokemon world he lives in, and so teenage boys living in Pallet Town are not expected to sit idly by. But the life of a hero is not one he's about to consider; too much hard work for little reward, and so instead he embarks on his quest not to become the greatest... But at least, the richest. Although the biggest challenge may be ignoring the adventures and friendships which may attempt to ensnare him along the way... Updates Mondays, Wednesdays and Fridays.", False, False)
add('MomthegamestorerippedusoffAGAIN', 'http://crappygames.smackjeeves.com/comics/', u'Here are some game consoles. They are old. They don\'t work very well. They are slightly discolored. Did I mention that they don\'t work well? This comic used to be called "Mommy, my NES crapped out on me AGAIN!!!" but then I started showing some other console glitches.', False, True)
add('Monstar', 'http://monstar.thewebcomic.com/comics/', u'The adventures of Monstar, the anthropomorphic personification of jealousy, Bunnee, his psychotic sidekick and a cast of odd creatures in the rural town of Longreach.', False, True)
add('MoonValley', 'http://moonvalley.smackjeeves.com/comics/', u'Her old school was a nightmare because of him, the school bully Demian... So Kaia is anything but happy to go back there in her last year. Besides she wants to learn virtual creating and there is no virtual net in that small town, where she grew up... Or at least that is what she thinks... For there is a new boy in her class and he is the reason why nothing is the same as before...', False, True)
add('MoonlitDawnAMythicalTale', 'http://moonlitdawn.smackjeeves.com/comics/', u'When there is an end to a cycle, there is a new beginning already forming. The passage of the fates are brittle, all those who inhabit our world unknowingly follow a predestined fate. However, a corrupted wolf goddess plans to rival against the fates with her army of Beastmen. Unfortunately for her, she had inadvertently caused an imbalance among the elements bringing forth new faces to rebuke her efforts. Wolf brothers, Joker and Mischief, have been roaming since they were exiled from their pack; their goal to put the past miles behind them. Until they are halted by Harmony, a half-goddess, who declares the brothers are elemental guardians.Their quest sounded simple; use their abilities to eliminate the Beastmen and prevent the goddess from destroying fate itself. As the journey progresses it begins to burden the brothers as they confront their shrouded past and unearth family secrets. Uncovering the core of themselves could strengthen them rendering defeat of the corrupt goddess, or it could disintegrate morale and all could fall into chaos. Updates: Every Friday Moonlit Dawn updates a page ahead on the official website: www.moonlitdawncomic.com', False, True)
add('MorphE', 'http://morphe.thewebcomic.com/comics/', u'Updates Tuesday, Thursday and Saturday at 7am EST. After their rescue from a madwoman\'s hellish subterranean caverns, five humans have their eyes opened to the dark truth lurking under normal society. A "benefactor" takes them in, but he\'s a cold-blooded killer with a deadly fixation on the new mages. In a world of magic, mages, and far creeper creatures, can he be trusted? Can anyone? Warning: morphE is a kinetic novel slightly animated in flash. It involves themes of brutal violence, sexuality (gay, straight, and other), and much cruelty. If dark or adult content offends you, this may not be your cup of tea.', False, True)
add('Mortifer', 'http://mortifer.smackjeeves.com/comics/', u"This comic has been completed! RATED WEB14 and up for gore and foul language! A mercenary team compiled of three men, Valentine, the asian prostitute obsessed with money, Mathew, a bloodlusting vampire with an anger problem, and Joey, an intellegent, but very odd, mercenary who always smiles. Things go well, until the presidency of the mercenary company is handed over to Joey, after mysterious death's of his competitors. Things slowly begin to get dangerous... and people's secrets begin to get exposed. Is Joey actually planning good things for the company... or something much more horrible?", False, True)
add('MrFactory', 'http://mrfactory.smackjeeves.com/comics/', u"Dee Bananahead is the coolest gangstah in da hood. Burglarizing 50 banks in 1 night? NO PROBLEM. But when she makes an outrageous promise to blow up the factory that everyone in the city hates, things start getting complicated. Updates, like, everyday. Unless it doesn't. But it typically does.", False, True)
add('MyBoyfriendisaMobBoss', 'http://mbmb.smackjeeves.com/comics/', u"Jace Indoveri gets asked out by one of the most well known and liked people at his college, Xander Aio. Taken by surprise by this confession, Jace accepts and begins to date him. By spending more and more time with Xander, Jace finds out a really outrageous secret, Xander is the head of the most powerful Mob circuits around. But that shouldn't get in the way of their relationship would it?? Reads RIGHT TO LEFT Is a yaoi! and will contain intimacy. So be fair warned!! Also contains: some bad language and Violence in certain situations.", True, True)
add('MyFakeHeart', 'http://myfakeheart.smackjeeves.com/comics/', u"A tale of unending confusion, aggravation, adoration, and exclamation. Amanda's best friend just got dumped. How else to win her ex back than by pretending to date Amanda? Meanwhile, playboy of the school Zach has discovered he's rather bored toying with all the girls who fawn over him. After kissing Amanda's brother Leonard on a dare, he decides to do some follow up; he wants to know if he is so hot a guy would fall for him. Luckily for him, Leonard's already interested in his gender. Less work for Zach! In case you can't tell, it's full of gay kids. There's like, three straight kids total. If that doesn't float your boat, don't rock mine.", False, False)
add('MySistertheDragon', 'http://sisterdragon.smackjeeves.com/comics/', u'A boy finds an egg in the woods, and he and the dragon that hatches from it are raised as brother and sister. Hijinks ensue, including but not limited to the wacky variety.', False, True)
add('MySparklingPrincesama', 'http://kiraouji.smackjeeves.com/comics/', u'Before you start... THIS MANGA IS READ FROM RIGHT TO LEFT! ------------------- \u79c1\u306e\u30ad\u30e9\u30ad\u30e9\u306e\u738b\u5b50\u69d8 \u2665 (My Sparkling Prince-sama \u2665) While Hanami was at the beach during one summer vacation, she met a boy who was making a pendant by the seaside. After he left she found a pendant with a name tag. When she went back to high school the following year, Hanami joined the Jewellery Club, and to her surprise, the president of the club was the student council president, who was a complete... nerd. ------------------- Genre:: SHOUJO, shoujo and more shoujo <_<... (you can tell from that lame title...)', False, True)
add('MyStereoBot', 'http://mystereobot.smackjeeves.com/comics/', u'In the city of Voxen Tin, Infinity, an odd looking stereohead, tries to live his life as best as he can, along with his partner, Cloudburn,and his cousin, Ohm Follow up on more MSB Goodies on mystereobot.tumblr.com', False, True)
add('MyTrollLife', 'http://mytrolllife.smackjeeves.com/comics/', u"This is a webcomic with rage comics surrounding real events in my life. NOTE: these comics are for jokes and laughs and should not be judged (but if you wanna still bitch then why are you here in the first place, you knew what you were gonna expect in the tittle's picture) UPDATES: ***Normal Schedule: Once A Week or Once Every Second Week (depending on schedule)***", False, True)
add('MyTwoCentsPlusTax', 'http://mtcpt.smackjeeves.com/comics/', u'In the modern world there are many evils out there. Super villains who want to destroy the world, Evil masterminds with plans for revenge, and bad dudes who go around not paying their taxes. It is up to Sanders, Jock, and Payton, three tax collectors, to bring these evil fiends to justice! Contains: [Cartoon Violence.]', False, True)
add('MysticanDreams', 'http://mysticandreams.smackjeeves.com/comics/', u'A story about a war torn country lead by the Golden Raced Echo and her insane father who happen to clash against the Silver Raced queen and her plot to take over the entire country of Mystica. (Yuri)', False, True)
add('MythsofUnovaAWhiteNuzlockeRunHardMode', 'http://mythsofunova.smackjeeves.com/comics/', u'Sort of a sequel of my Diamond Nuzlocke Run! You can read the previous nuzlocke comics here: http://ky-nim.deviantart.com/gallery/28245977 Different region, different characters...or are they so different from the first? See how Nina and her two best friends set out on an adventure that may be more life-changing then they initially had wanted...', False, True)
add('NIK', 'http://nik.smackjeeves.com/comics/', u"The Character: Nikolai is a young mage who shows great potential. He is able to wield magic without using his hands or chanting words by using the light magic he has webbed around him at all times. The Plot: The world has forever been balanced between good and evil. Each mortal lying somewhere between the two extremes. Now that a new mage has taken over the council, the light beings have a burst of power which breaks the balance they have with the dark beings of the world. And they aren't willing to keep the balance, no, the mage council decides to use this power for all they can and wipe out every ounce of dark-energy in their section of the world... This balance being broken can change many things. The mortals are directly influenced by the energies! But wouldn't a world of pure light magic be a good thing? ... (This is a BL, yaoi, shounen ai, boy-love comic. With some Hetero.)", False, True)
add('Nah', 'http://thecomicformerlyknownasgenlab.smackjeeves.com/comics/', u"I don't like doing things I really dont like doing things i give up i ggive the fucck U P", False, True)
add('Negligence', 'http://negligence.smackjeeves.com/comics/', u"Two kids, a bottle of mouthwash, and an almost non-existent parental figure. What could possibly go wrong, besides cult families, twisted public television shows, a baby's death, and a pseudo-incestuous relationship? Welcome to Negligence, a crazy journey.", False, True)
#add('NekotheKitty', 'http://www.nekothekitty.net/comics/', u"Such a sweet little sociopath. Yes he is, yes he IS! D'awwww", False, True)
add('NeoCrystalAdventures', 'http://neocrystaladventures.smackjeeves.com/comics/', u'My best, and longest lasting attempt at a sprite comic! Has a mix of things, ideas, and characters in it! All put into a dramatic/romantic/comedy setting! Currently numbering at 1200+ comics and still going strong, this comic is updated daily if at all possible! Enjoy your stay, and have fun reading!', False, True)
add('NeonGlow', 'http://neonglow.smackjeeves.com/comics/', u"Animals that are exposed to a special nuclear radiation and die become what is called a neon. Neons are a phantom/zombie creatures that can be dangerous. It's up to Zedof and Jake to hunt them down to keep them from harming the public. May have some light boy love, but it is not the main focus of the comic.", False, True)
add('NevertheHero', 'http://neverthehero.smackjeeves.com/comics/', u"Far in the future, select humans can sometimes turn into 'white-eyes'. These white-eyes have powers and endurance far beyond what modern science can explain. This is the story of what happens when a couple of jerks get these powers. Updates Mondays and Fridays. Contains language, violence, and some gore.", False, True)
add('Nexus', 'http://nexus.smackjeeves.com/comics/', u'Magical girls and monsters abound! Updates Fridays!', False, True)
add('NiceKitty', 'http://nicekitty.smackjeeves.com/comics/', u"UPDATES TUESDAY, THURSDAY,and SATURDAY! About Nice Kitty: It is the touching coming of age story of a young boy and his cuddly feline companion, trying to find love and acceptance in a world fraught with peril and harsh realities. Will the mysterious new friend they meet one fateful day be able to answer the call of their lonely hearts, and bring some life and color to their otherwise blue and lonely world? You'll laugh, you'll cry, you'll pray for it to stop, but It won't because you can't stop the rock and why are you still reading this? You came to read the comic so READ already. This drivel certainly won't help you understand the story any better. Get going! And just remember: Be nice to your kitty, and he'll be NICE to you..........", False, False)
add('NighHeavenandHell', 'http://nighheavenandhell.smackjeeves.com/comics/', u'A grudge as old as mankind. Three travelers entwined by fate. This road, once travelled, can never be undone. Between damnation & salvation, you find the truth hidden by God, Nigh Heaven & Hell. //Updates Every Friday//', False, True)
add('NightSpace', 'http://nightspace.smackjeeves.com/comics/', u'The adventures of a ragtag group of aliens, (including a rebellious king, a rather rude diplomat, a mute royal mage, a grumpy yet kind of sassy royal advisor, a very optimistic servant, a very short ex-assassin, a mentally unstable police consultant who is the last of his kind, another police consultant who is less mentally unstable, and a few different pilots), as they try to stop a mysterious group from taking over their little section of space. Updates Fridays~ Please ignore the art at the beginning! I promise it gets better.', False, True)
add('NihilWandasJourney', 'http://nihil.smackjeeves.com/comics/', u'I did this comic in coorperation with a friend of mine. Drawings, idea, characters and translation [The originalversion is in German] are all my fault. Wanda strongly believes she is a princess and wants to prove it, since most people just do not want to pay tribute to her. Together with Avis, a wood imp who accompanies her out of pity, Wanda embarks on a journey to the Garucian Mountains to see the mighty wizard Hon-ar, whom she expects to trace her [as she believes] lost, royal parents. Unfortunately it turns out that the world has other plans for the young woman.', False, True)
add('NissiesDragonPrincess', 'http://drgnprincess.smackjeeves.com/comics/', u'Raleigh and Zane are a pair of mercenaries off to save Princess Mina from a terrible curse. However, the three will learn about themselves and the true nature of the curse in their travels together.', False, True)
add('NixsFireRedNuzlocke', 'http://nixnuzlocke.smackjeeves.com/comics/', u"Join Nix across the hell that is Kanto and all its Pokemon, specifically the poison types. oh god, the poison types... Mostly Basic rules: 1)Pokemon faints, it dies. 2)Can only catch the first pokemon on a route -If it's a duplicate you may retry -Exceptions include shinies and gift pokemon -No catching Legendaries -Each area in the safari zone counts individually", False, True)
add('NoEnd', 'http://no-end.smackjeeves.com/comics/', u'No End is a weekly updating webcomic about a group of people trying to survive and make lives for themselves in a cold, post-apocalyptic world ravaged by hordes of undead. LGBT+ themes, content warning for occasional blood, gore, violence and strong language. Updates every Sunday! Tumblr at http://noendcomic.tumblr.com', False, True)
add('NobleHeartsHiruandMerroug', 'http://hiruandmerroug.smackjeeves.com/comics/', u'', True, True)
add('NormalcyisforWimps', 'http://normalcyisforwimps.smackjeeves.com/comics/', u"Sonic and Tails have gotten bored of living away from civilazation and have decided to move to Onette, at least that's what Sonic decided. Warning: Contains Demonic landlords, magic, insanity, and something else I can't think of right now.", False, True)
add('NotyoursamI', 'http://notyoursami.smackjeeves.com/comics/', u'Lyle\u2019s secret affection towards his twin sister\u2019s boyfriend, Kaden, is near the point of no return. The years of suppression and unrewarded sacrifices eventually molded him into a vulnerable man of conflictions. Just as when he thought all hope was lost, however, an opportunity to get much closer to Kaden during his sister\u2019s absence turns up. For Lyle, any such opportunity is gold, even if it means losing his own identity. After all, it is a sin he can enjoy only until her return. But when she does, what would truly become of Lyle? At the end of it all, who does Lyle really need, his beloved sister or his forbidden lover? "Not Yours, Am I?" is an original Yaoi / BL practice comic by Cinnamon Rub/Scottwm. It was first published online in September 2009. A revamped version of the first 5 chapters was compiled in one volume and was published in print in April 2014. -READ FROM RIGHT TO LEFT-', True, True)
add('ObsidianHeart', 'http://obsidianheart.smackjeeves.com/comics/', u'Micah is the only survivor of his country Atedon after a bloody war. He is now out to seek revenge on the ones who have killed his friends and family. But perhaps this task is too heavy for one simple tribal boy, and he has to accept help from a suspiciously friendly stranger.', False, True)
add('October20th', 'http://www.october20comic.com/comics/', u'10 years ago, on October the 20th, 6 people from different parts of the globe were each responsible to taking an innocent life. Every anniversary following it, they have been stalked and hunted by a mysterious creature that only shows itself on the infamous date. Only the American called Catherine and the Argentinian called Rai are left. Is this the year they finally discover the truth about the curse that has taken everything from them, and find a way to stop the relentless beast? And who is the shadowy figure oddly called Shields McKloskey, who seems to hold all the answers?', False, True)
add('OddContact', 'http://oddcontact.smackjeeves.com/comics/', u"I looked the old version and I felt like redrawing. (not remaking) This version 'll be only shounen-ai. ---------------------- It's a story about a demon and an angel. (BL) Leonard have a peaceful life. One day his village was destroyed, and he was captured and taken far away from his homeland. In his luck or unluck an angel saved him. In return he had to join as the angel's servant. The only problem Leonard never learnt magic.... Would they fail, because the little demon is too recalcitrant and willful?", False, True)
add('OddPlaceOddTime', 'http://oddplaceoddtime.smackjeeves.com/comics/', u'Far away in a land no one knows//Way beyond where the mutant grass grows//A place reeking of familiarity//Where fiction smells better than reality//Every second an odd mishap//Fall deeper into our surreal trap//Come on by and sit for a spell//Cast by a witch who tells a tale//We\u2019ve probably never heard before//And we\u2019ll never want to hear once more.', False, True)
add('Ohman', 'http://ohman.smackjeeves.com/comics/', u'A simple, manga styled action and comedy webcomic. Join the plain, slow witted high schooler Stein Kovas with limitless power in his not so plain adventure through the energy filled world with LEMON. Updates Chapters! (around 9 pages+) Weekly on Saturdays reads left to right other releases on other days on this site are to spreadddddd da word', False, True)
add('OldElastikid', 'http://oldelastikid.smackjeeves.com/comics/', u'These are all of the old Elastikid comics from prior to February, 2011. This was before Joe decided to become a superhero, and consists mostly of gag-a-day jokes with no real overall storyline. The tone of the series was rather different, so rather than continue on this comic, I decided to release all of the new strips as a "sequel" comic continuing in the same continuity. You can read the current Elastikid strips at http://elastikid.smackjeeves.com/ which is still being updated.', False, True)
add('OneFrameGags', 'http://oneframegags.smackjeeves.com/comics/', u'One panel (and occasionally two or more) gag cartoons featuring no main characters.', False, True)
add('OneRainyDay', 'http://one-rainy-day.smackjeeves.com/comics/', u'Basically a BL story like "the prince and the pauper" No sex scenes (at least not for a hundred pages or so) Mostly a cute story about a developing relationship Aki was abandoned when he was eight, for ten years he\'s lived on the streets with nothing but his wits and strength to support him. Needless to say he is unhappy. But one day he runs into some one who looks exactly like him! This mysterious boy named Ryuuta turns out to be the young master of a large corporation who just wants to be free and discover himself. Aki and this Ryuuta trade lives for the summer and Aki\'s doing fine in his new life until his identity is discovered by the Ryuuta\'s intimidating body guard named Kaidou. Can a love bloom between a stoic individual and a street rat?', True, True)
add('Onlyonelovesong', 'http://onlyonelovesong.smackjeeves.com/comics/', u"[available as a paperback on Indyplanet with a few extra spicy pages, revamped dialogue and prettier speech bubble arrangement!] A spoiled, frustrated and capricious rock star accidentally meets a common girl seemingly imprevious to his charm. Hiding his true identity from her, he selfishly decides to make her fall in love with him. But as he gets to know her better he finds himself falling instead. Only, there's a secret in her past keeping her heart locked away... [story specs: BOY x GIRL romance, mostly comedy, some heavy drama, censored swearing, occasional gratuitous male fanservice] [tech: b&w pages, color covers,hand-drawn&inked then photoscreentoneshopped to death]", False, True)
add('OperationTheater', 'http://operation-theater.smackjeeves.com/comics/', u'"It\'s only Paranoia if I\'m wrong. I can handle being wrong, but if I\'m right I\'m screwed!" Bastian Weber is a weird geeky jitterbug, a punching bag for everyone, but his life turned upside down when he met Izrael and Claudius, two strange guys who are living at his attic... [CONTAINS BL/GL, sexual confusions, comedy, drama, gore, horror, blood, some bondage, crazy people and lots of shit XD] So if you like weird people, unprecedented fights, Nerds/Geeks, friendship and a hero who gets mortally injured on a daily basis, get some snacks and look forward to "Operation Theater"! P.s. - I\'m pretty bad at sticking with genres, so this is supposed to be a bloody comedy with added drama and lot\'s of gay jokes :I P.p.s. - It\'s not porn', False, True)
add('OriginBook1Codearth', 'http://theoriginbooks.smackjeeves.com/comics/', u'A thousand or so years in the future, humanity rests in the palms of two companies. Unknowingly living in a world that could easily collapse and an outside world of vast nothingness. From here we shall mainly focus on two young people; Code Chestock and Dominic Eode as they shift through the world learning its secrets. I try to update every Friday through Sunday (mostly Friday) and maybe on some other random day, because why not? basically I update whenever I finish a page. So if that means updating everyday, twice a day, or after a long period of time, let it happen. I will take helpful critique for this comic as well, because I know it needs a lot of work.', False, True)
add('OurTimeinEden', 'http://ourtimeineden.smackjeeves.com/comics/', u'A story of lost innocence, lost direction and lost hope. Words by Gibson Twist Pictures by Ben Steeves (Dangerface)', False, True)
add('Outbreak', 'http://xoutbreak.smackjeeves.com/comics/', u"On a rainy night, two boys escape from a mysterious laboratory in the middle of the woods. After being separated, they are both scooped up into the arms of kind individuals who begin to teach them that the world isn't only made up of pain. But things start to go a bit crazy as an outbreak of super-human abilities begins to follow them where ever they go. These events begin to cause a chain reaction that spirals out of control. Can it be stopped? Or will it be too late...? [This is a Boys Love story. Updates on Fridays.]", False, True)
add('OutofKey', 'http://outofkey.smackjeeves.com/comics/', u"When Teal needs to change electives, she joins a choir that's just as out of place as she is. Currently updates T & Th", False, True)
add('OverSync', 'http://linearperspective.smackjeeves.com/comics/', u'Oversync is a comic about a young girl who stumbles into another world. Jacqueline dives into the world of Arcadia but soon finds herself tangled in a mess of secrets and conflicts. Can she punch her way out of this mess or will these battles prove to be surprisingly fist proof. A silly web comic focused on character interactions and exploring a fantasy world filled with curious things. New Pages every tuesday, wednesday, and thursday!', False, True)
add('PMDExplorersofHeart', 'http://pmd-explorers-of-heart.smackjeeves.com/comics/', u"The world is in complete chaos. The legendary dragons Reshiram and Zekrom have begun to lash out for no particular reason, causing agitation and fury to sweep through pokemon one by one. Mystery Dungeons keep opening up, and, as more pokemon become agitated and blind with anger, more rescue teams are popping up all over the region. Erika, a young Vulpix, can't remember a thing from her past, besides two things; one is her name, the other, the fact that she was a human. All she wants is to figure out about her past and possibly return home. With the help of an Oshawott named Zeke, the two form a rescue team, hoping that eventually they will find the cause of her turning into a pokemon. UPDATES - Whenever", False, True)
add('PMDTeamFirefox', 'http://pmdteamfirefox.smackjeeves.com/comics/', u"What happens when you turn into a pokemon, forget everything, and lay unconsciously on the beach? Go save the world from time freezing, obviously! Well that's just what Team FireFox is going to do! It's a pokemon mystery dungeon sky gijinka comics :3 Oh yeah, art gradually gets better. Grammar? Not so much.", False, True)
add('PMDVictoryFire', 'http://victoryfire.smackjeeves.com/comics/', u"Sometimes the most interesting stories come from the strangest places. Victory Fire starts off as most Mystery Dungeon comics do, a human comes to the pokemon world. But THAT'S where the similarities end.... New pages are posted on Tuesdays and Fridays, please check back :) **Broken images? SmackJeeves servers playing up? VF is mirrored on sulfurbunny.deviantart.com **", False, True)
add('PRAGUERACE', 'http://praguerace.smackjeeves.com/comics/', u'PRace is a story about friendship and adventure. Author is Petra Erika Nordlund, also known as LEPPU and her other artwork can be found from tumblr and deviantart with the same nickname. email for contact is petra.nordlund at gmail.com', False, True)
add('PTO', 'http://pto.smackjeeves.com/comics/', u'"I just want to feel loved" The year is 2374 in the future. What is going to happen, when a gang of useless men adopt an adorable living doll? Well, a lot of drama and heartbreaks, that\'s for sure. ---- UPDATED EVERY DAY! Includes sex, nudity and a bit of violence. Check out also (http://ptobonus.smackjeeves.com/)', True, False)
add('Pahantekija', 'http://pahantekija.smackjeeves.com/comics/', u'When vampires killing humans is an everyday occurrence, one more death is barely worth mentioning. In one village, though, people seem to be a bit too willing to dismiss it, and Ausra the novice decides to find out why. However, her obstinacy backfires and before long she finds herself in a rather life-threatening company. Contains gore, violence and other shady stuff. Be prepared.', False, True)
add('Panacea', 'http://panacea.smackjeeves.com/comics/', u"Caelen is part shapeshifter but his dual heritage becomes a curse when he learns his unstable body is slowly deteriorating. Life seems pretty miserable and pointless. With no faith in himself and even less faith in others he has very much sunken into pitiful state. After hitting his lowest point, landing in the streets with nowhere to be, he manages to catch the attention of a stranger. Will Sairys' compassion and cheerful attitude be enough to break through the barriers Caelen manage to erect around himself? *~*~*~*~*~*~*~*~*~*~*~*~*~*~ Boy Love Warning! Hopefully I'll manage to update once a week. You can expect new pages on Mondays and Thursdays... usually, unless something comes up and I can't make the deadline.", True, False)
add('PantsParty', 'http://partypants.smackjeeves.com/comics/', u"This is the Pants Party! Its a Party With Pants. Three friends live and stink up the Lab of famous Dr. Light, will their shenanigans get them into trouble? or will Z just give Dr. Light a raging boner? Find out at the PANTS PARTY Updates usually whenever. The Pants Party Hosts- Boh - Supreme Commander in Chief (Also known as the God King) The Magnificent Z - The Magnificent Gatamigo - Vice President Joe Biden. If you wanna vote for the Pants Party, just give me a message, you just might get a cameo. Probably a better one than Gata too. Hey, you can't lose right? Vote Pants Party. Edit: But I'm an author now so how the fuck could they get a better cameo than me -Vice President Gata Edit Edit: Because even though you're an author, you're still lowest on the totem pole. - Supreme Commander in Chief Boh. Edit Edit Edit: And I'm sandwiched in between you two. ~Z Edit Edit Edit Edit: Phrasing! Boom! - Boh The Host.", False, True)
add('PanzerDragonandEnigmaCompleteEdition', 'http://panzerdragonandenigma.smackjeeves.com/comics/', u'Panzer Dragon and Enigma: Complete Edition contains all of the comics from the first incarnation of the Panzer Dragon and Enigma Saga. The archives were fully completed as of March 20, 2012. For the current incarnation of the story, head to the following address: http://pdezwei.smackjeeves.com The current incarnation, Panzer Dragon and Enigma Zwei, updates every Monday, Thursday, and Saturday.', False, True)
add('Paradox', 'http://paradoxcomic.smackjeeves.com/comics/', u'Taken as prisoners of war, Dake and Tommy are sold as slaves, one to a wealthy but kind woman, the other to a man of unknown species who has a very bad habit of eating people. Forced to endure the horrors of war, racism, homophobia, and the occasional molestation, can these two opposites somehow attract? Contains sexual situations, violence, drug use and probably many other bad things.', True, True)
add('Paripety', 'http://paripety.smackjeeves.com/comics/', u'Summary: While the flesh is deceitful, the soul holds the image of our true selves. Only under some circumstances do those soul images break through the barrier of flesh \u2013 and in Leif\u2019s case, as a grotesque, wolf-like horror with an insatiable hunger. But there is a legend of an entity able to cure the soul; changing the soul image from a spidered ribs and empty frames to a soul image of light and warmth. And after his curse causes a disaster which he can never take back, Leif must go on his journey to find it. Please follow my tumblr blog for this manga if you want to get update notices, sketches, and other things~ ^^ Also, you can use that to message me about whatever~ Please come talk to me! =D http://mushkikizou-chan-manga.tumblr.com/', False, True)
add('Pause', 'http://pause.smackjeeves.com/comics/', u'"Pause" is a light story about a boy, Yoshiro Koizumi, who can freeze time whenever he wants to. When he suddenly meets a girl who is unaffected by his time-freezing powers, his peaceful high school life is thrown into chaos as she discovers his dark secrets which Yoshiro only shows when time is frozen. -Updates every 3-4 days.', False, True)
add('PencilviewUpdatesMondayscough', 'http://pencilview.smackjeeves.com/comics/', u"If you've never seen someone sleep in a toaster, dress themselves as a candle (by setting their head on fire), or get bitten by a crayon, then you haven't met Percy. And if you like calling people short and are still breathing, you haven't met Bill. Feel the need to remedy this situation? Then read the adventures and silliness that is Pencil View. Remember, laughter is good for your health.", False, True)
add('Perinto', 'http://perinto.smackjeeves.com/comics/', u'Serkukset Kati ja Hilla eiv\xe4t tule toimeen kesken\xe4\xe4n. Kuitenkin he joutuvat mummunsa hautajaisten j\xe4lkeisen\xe4 p\xe4iv\xe4n\xe4 kohtaamaan yhdess\xe4 kummallisen perint\xf6esineen tuomat vaikeudet. Selviyty\xe4kseen Katin ja Hillan on m\xe4\xe4r\xe4 tehd\xe4 yhteisty\xf6t\xe4, mutta onnistuuko heilt\xe4 yhteisty\xf6 vai k\xe4\xe4nt\xe4v\xe4tk\xf6 tyt\xf6t toisilleen selk\xe4ns\xe4 h\xe4d\xe4n hetkell\xe4?', False, True)
add('PerplexingMagnoliaDisruption', 'http://smgpmd.smackjeeves.com/comics/', u"Perplexing Magnolia Disruption is a serious comic filled with love, hate, drama, and... Who are we kidding, it's a Team SMG Pokemon Comic. Don't expect this to be serious at all. COMIC COMPLETED. The sequel can be found here: http://www.smackjeeves.com/comicprofile.php?id=118656", False, True)
add('PeterPan', 'http://peterpan.smackjeeves.com/comics/', u"An adaptation of the classic children's story Peter Pan. Closely following J.M. Barrie's original story, come follow the adventures of Peter and the Darling children in Neverland! If you've never read the book, here's your chance to experience the real story! If you have, and enjoyed it, then this is the comic for you! Updates Sundays and Wednesdays!", False, True)
add('Phantomland', 'http://phantomland.smackjeeves.com/comics/', u"UPDATES ON THURSDAYS Santa Luison is a large city that employs it's strange minority of subhumans at a crime fighting organization. Introduce Chie: a fresh little rookie who receives her training from the baddest, meanest veteran officer around. Phantomland started as a self-published print comic back in 2009 and is now getting it's online debut at Smackjeeves.", False, True)
add('PhotoShootnarusasuDoujinshi', 'http://photoshootnarusasu.smackjeeves.com/comics/', u"NaruxSasu Doujinshi Sometimes the person you fall in love with is the last person you'd expect. Naruto never thought he'd fall for Sasuke; will having to work together change his mind?", True, True)
add('PlasticKings', 'http://plastickings.smackjeeves.com/comics/', u"A young king and his rock n' roll queen must give up their party-animal ways and beg the gods for help when their newborn son falls ill. However, this is only the first of many problems facing the kingdom and the gods who watch over it. Updates Mon-Fri", False, True)
add('PlatonicBoyfriends', 'http://platonicboyfriends.smackjeeves.com/comics/', u"All Sydney Simon wanted was some quiet so he could read and study-- instead he ends up stuck with a professional slacker and their odd variety of friends who just won't leave him be", False, True)
add('PlayTime', 'http://dollysplaytime.smackjeeves.com/comics/', u'Megumi was just a timid high school girl trying to cope with life until the day a magic ribbon came into her life and a new hero was born!', False, True)
add('Plotlessnesses', 'http://plotlessnesses.smackjeeves.com/comics/', u'A comic about willows and everything else. Read Filler House, if you dare: http://www.smackjeeves.com/comicprofile.php?id=40140', False, True)
add('PokeVenturous', 'http://pokeventuras.smackjeeves.com/comics/', u"It will all be mine power so divine it's my destiny Team Rocket, it's my destiny Follows the adventures of the trainer Lea who is also a psychic and stuck working for team Rocket, as they fight other corporations for a piece of the global market. Disclaimer: This story uses pokemon from every generation. You have been warned Also Pokemon is a Trademark of Nintendo", False, True)
add('PokemonBeta', 'http://pokemonbeta.smackjeeves.com/comics/', u'The Trygon facility was made to create better Pok\xe9mon that can survive in their world, as species over the years have been dying out. Rymadanas, the head of the Red tower, desire Pok\xe9mon to become equals, with no weaknesses or be disadvantaged. Pok\xe9mon are recruited into the facilities by force if they lack the necessary amount of specimen. The Trygon capture Pokemon and genetically experiment on them, and even themselves to achieve their goals. Those captured unwillingly are wiped of their memories, forcing them to obey without question. Some regions had seen the only way out is to urge their residents to undergo experimentation to keep families from being separated, and body counts low. Opposition to the Trygon Organization has reached an all time pitfall. Only few pieces of land are still free of the shadow cast from the buildings. Is risky science the way to salvation? What is the root cause of Pokemon to be dying out? Unbeknownst to a Totodile, he would find the answers to everything...', False, True)
add('PokemonCrystalDoubleNuzlockeChallenge', 'http://miinuzlocke.smackjeeves.com/comics/', u"Another Nuzlocke Challenge, Pokemon Crystal Version :D. Note: English is not my main language :B, so you're free to correct me anytime.", False, True)
add('PokemonGleamingCrystal', 'http://gleamingcrystal.smackjeeves.com/comics/', u'A pokemon sprite comic by ShadowEmerl about 3 schmucks who explore the Johto region. Characters and story by ShadowEmerl, Lady Darkrina and Skweeman Rated [T]: Excessive Coarse Language Updates:', False, True)
add('PokemonLANDSKY', 'http://www.landxsky.com/comics/', u'LAND//SKY follows the adventures of seventeen year old twins Xander and Lexi as they leave their hometown in the Hoenn region to travel and to see what the world of Pokemon has to offer. Story by Sky King Artwork by Freedomthai', False, True)
add('PokemonMysteryDungeonTeamCrystal', 'http://crystalmysterydungeon.smackjeeves.com/comics/', u"Just a little something I wanted to try as a result of playing pkmn mystery dungeon games a lot. Will have a bit of everything category wise :) Will up the rating to M if it calls for it..but hopefully it won't. It IS rated T for language though! Updated whenever I can!", False, True)
add('PokemonParallel', 'http://pokemon-parallel.smackjeeves.com/comics/', u"Parallel... After the when humans vanished hundred years ago, used to fighting battles the Pokemon that once were owned are on a verge of killing themselves off... However a secret threat emerges that is about to change what is horrible to something nightmarish. What happened? What happened to the world of Pokemon and Humans? Can it ever be restored? See through the eyes of a Latios and figure out his mystery and story. Travel with a group of Poke'mon that each have their own personal journeys to make in order to fix their pasts. Discover a world of Poke'mon in a way you never imagined. And the sacrifices one has to take to understand what it means to forgive and live on. ~~~~~~~~~~~ A Pokemon Story by Lavender Okamari Adventure, Mystery, Some Romance ... but basically SERIOUS stuff - (i don't know about funny, whenever i try to make a joke it turns out not to be funny at all... but i will try.) Warning: Might contain language, violence (blood etc.) -- Updates will be slow-- Read from Left to Right.", False, True)
add('PokemonSAKOHJU', 'http://sakohju.smackjeeves.com/comics/', u"Different adventures kick off with different characters in different parts of the Pokemon world! There's darkness in the Pokearth, and it's not just Team Plasma. A group by the name of Team Midnight is on the rise. However, their biggest obstacle appears when the protoganists come together to form SAKOHJU, an organization dedicated to ridding the Pokemon world of evil. As the fight rages, it's unclear how many will make it out alive, as it all comes down to SAKOHJU vs. Team Midnight... ____________________ I started this comic a couple years ago so some parts of it (beginning especially) aren't all that good. It's become more of a sketch comic and it's a learning experience for me, I improve and as my first project I'm seeing this thing to the end no matter what. I also have lots of characters based off real people. I will say that now. Also breaks the fourth wall. A LOT. Pokemon (c) Nintendo", False, True)
add('PokemonnoRakuen', 'http://pokemon-no-rakuen.smackjeeves.com/comics/', u"Summery- Gray has NEVER had a single girlfriend in his 17 years of life. His mother gets him a Totodile and then weird things happen... The Totodile becomes a human! What's going on?! Will going on a Pokemon journey give Gray the answers to his questions? Why did the Totodile become a human? What does Gray's father have to do with any of this? Will Gray EVER get a girlfriend? (Unlikely) Read to find out For ages 13 and up Warning- May contain death, blood and Implications", False, True)
add('Ponzi', 'http://ponzi.smackjeeves.com/comics/', u"About: It's a new beginning, a new age and a new world where people enjoy advanced industrial games, technology and entertainment. At this moment, after a mysterious broadcast, the world media has launched a new tournament called N.E.O.SIN. The prize for this competition is unlike any other, the winners will receive an evolutionary enhancement of their body. This enhancement will improve their physical and mental capacity as a human being. Ever dream of super speed, super vision or any other kind of supernatural enhancement? Who will win the key to the evolution of the human race? (You can read more info on the official site: www.pigtailstudio.com )", False, True)
add('PrettyMouth', 'http://prettymouth.smackjeeves.com/comics/', u'Evan is not a monster, he just has a few extra mouths. After what was supposed to be a one night stand with Rizo, a real monster, Evan finds things difficult to break off. Rizo just might be able to undo Evan\u2019s curse. With a monster in the woods, witches in the shadows, and a laughing mouth without a body, Evan needs to decide if it\u2019s even worth putting aside prejudice. http://www.prettymouthcomic.com/', False, True)
add('PrincessChroma', 'http://princesschroma.smackjeeves.com/comics/', u"As darkness threatens to engulf all life, the universe cries out for a champion with a pure heart. But they'll have to settle for schoolgirl June Summer. With the help of her friends and her mentor, a winged bunny, June will battle monsters, struggle to maintain a normal school life, and occasionally watch television. Hey, even heroines need a little downtime. -A Magical Girl Parody. Updates Wednesdays!", False, True)
add('ProfessorDolphinpresentsPokemon', 'http://pdpp.smackjeeves.com/comics/', u'', False, True)
add('ProjectCAPLimit', 'http://imagecap.smackjeeves.com/comics/', u'Have you ever wanted to see me post comics on YOUR computer screen, with some authors you may all know? THIS IS PROJECT CAP LIMIT! A new comic featuring the works of authors Cascade and Alienoid. A comic filled with adventure, stupidity, robots, definitely robots, and occasionally humor! Updates whenever we come up with clever material.', False, True)
add('Puck', 'http://puck.smackjeeves.com/comics/', u'This site is the Smackjeeves mirror site for Puck where older comics are posted. The actual Puck website contains the latest content at... WWW.PUCKCOMICS.COM', False, True)
add('PulseandBolt', 'http://pulse-bolt.smackjeeves.com/comics/', u'Two female human batteries become armored superheroes.', False, True)
add('PumpkinFlower', 'http://pumpkinflower.smackjeeves.com/comics/', u"CONTAINS: BL When being stalked by an amnesiatic ghost is the best thing going for you there may be a problem. Now if only the ghost could understand the term 'personal space.' FINISHED", False, True)
add('PurpureaNoxa', 'http://purpureanoxa.smackjeeves.com/comics/', u'A VAMPIRE YAOI BOYS LOVE BL web comic set in Italy between the cities of Lucca and Pisa (Tuscany) based on the story of our RPG (Role Play Game). We thought that it could be fun drawing the "misadventures" of our characters :)', True, True)
add('QueerQueen', 'http://queerqueen.smackjeeves.com/comics/', u"Queer Queen is a comedy shounen ai manga centred around Helium, a transvestite male student attending a boys' school, who falls in love with his own form-teacher. For this love is unrequited, he decides to ask out a fellow student to make his teacher jealous. Updated at least once a week.", False, True)
add('RANDOM', 'http://randomthecomic.smackjeeves.com/comics/', u"Is logic at the door? Well tell it to beat it! You won't need it for this series. RANDOM is about one thing, complete nonsense. Join Joe B. Gamble, Smart T. Guy, Iam 2. Cute, I-I and Speedo. Every comic teaches you a new idiom to use for yourself, except you will learn it in a very unorthodox way. With a cast that gets in your face and glues itself to it too, RANDOM is what it wants and when it wants. No plot, story or sense, just a lot of laughs and idioms; that is RANDOM.", False, True)
add('ROSIER', 'http://rosier.smackjeeves.com/comics/', u"[COMPLETED WORK] A Dark Fantasy Romance: Vanney is a ditzy acolyte at the Temple of the God of Wealth and spends her days daydreaming about adventures with her best friend Jaelia. When the Temple sends the two of them to escort a caravan to the mysterious, far-off border town of Shadow Charing Vanney's time for adventure has come. But her sunny imaginings have nothing to do with the shadowy world of witches, demons, magic and netherworlds her path takes her to...", False, True)
add('RainLGBT', 'http://rainlgbt.smackjeeves.com/comics/', u'Written by Jocelyn Samara DiDomenick (aka LittleLynn84) "Rain" is a comedy/drama that follows the daily life of teenage transsexual (who is coincidentally named Rain) attempting to go through her senior year being only identified as a woman. I\'d like for it to be very funny and entertaining, but the story will also touch on many rather heavy subjects including acceptance from family and piers, blind hatred and many of the other difficulties faced by members of the LGBT community. This comic contains: - Occasionally strong language - Sexual themes and situations (but no nudity) - Gay, lesbian, bi and transgendered (and straight) characters - Lousy or non-existent backgrounds', False, False)
add('RainxSasori', 'http://rainxsasori.smackjeeves.com/comics/', u"WARNING. The art is REALLY bad at first but it gets wayyyy better! Promise! :) This is my first comic so I'm trying new things with it. I'm experimenting and practicing all sorts of things like back grounds, shading and neatness. Horrible handwriting, that can't be helped sorry. BL. YAOI Sasori Mahitto, 19. College student from Japan (just moved to New York). Rain Westong, mid 20's. Demon, man whore. Their paths cross and Sasori's naiveness gets him into a lot of trouble with Rain. Somewhere along the lines of Sasori getting into trouble with Rain he ends up becoming his house maid? And is asked to do some. . .unmentionable things?... contains: a little nudity, foul language, alcohol, cigarettes, sex, demons, cute uke boys, and YAOI. :) Enjoy. :) Updates every Saturday at 7 AM. :) (Currently off schedule. Updates when I finish a page :))", True, True)
add('RareCandyTreatment', 'http://www.rarecandytreatment.com/comics/', u'A webcomic targetting the flaws and hypothetical situations in the Pok\xe9mon games. Ridiculing the trainers, mocking the various species, and overall making fun of a popular game we all hold very dear (author included).', False, True)
add('RavenWolf', 'http://ravenwolf.smackjeeves.com/comics/', u"Due to human negligence the world as we know it has ended and been reborn. The animal spirits that guide man giving them the forms of animals so that they would be able to survive in this new wilderness. Though now carrying the form of beasts man has not forgotten the place they once had, as an existence greater then just what nature wanted of them, an existence above all. Those that worked to gain their humanity are known as domestics, while those who wished to follow the roles the spirits had given them were known as wilds. Both groups grew arrogant and hateful of one another because of how differently they thought. The raven and the wolf spirits grew tired of the destruction and fighting and sided with the wilds in their ideals, the domestics only capable of further destroying nature. In their anger they marked a tribe of wilds with a curse, they being removed from the sacred circle of life, the curse upon them only broken once the domestics are gone once and for all. The cursed tribe now known to all by the name of the spirits whom cursed them. 'Raven Wolf' Updates: Wed, Fri and Sun", False, True)
add('Razor', 'http://razor-.smackjeeves.com/comics/', u"Alright with that friggin 'yaoi' comment on the banner, now I've got your attention! Haruka Ito (Chainsmoker, masochist) suffers from severe depression. His life is about sex, drugs, violence and hiding his scars. Every day he indulges in s&m with his best friend Sato, which not only bruises him on the outside but inside as well. Their friend, Kenzo, is very eager to get in Haruka's pants, but he seems to want more with Haruka than that. As Haruka's life only gets worse by every day, he injures himself repeatedly, attempts suicide, and who will save him? Warning Hardcore yaoi sex, some blood, a lot of cursing, and depressing things, rape, bondage Read at own risk! (Also the first 7 pages are too small/too big, but the rest are a decent size c:) UPDATES EVERY DAY (unless work totally gets in the way, and sometimes if you readers are all good boys and girls, I will double update because why not) OH and sequel: http://www.smackjeeves.com/comicprofile.php?id=144459", True, True)
add('RedVelvetRequiem', 'http://rvr.smackjeeves.com/comics/', u'Alexandra Carter lived with only one focus in life, loyalty to her lord and country. Unfortunately for her, other members of her country did not see it that way. Framed for murder and treason, she endured unspeakable tortures and waited for her time to strike. What will she find before the crawling darkness consumes her and the land? (contains violence, strong language, and adult situations)', False, True)
add('Regina', 'http://regina.smackjeeves.com/comics/', u"'Regina' is a sketch comic. It's a daily sketch challenge comic designed to get me to draw one comic page a day so I can stay in practice everyday. Also to practice page layouts and conversational writing. Regina was drawn using only with a black ball-point pen but now has tones, for a new look. The story of Regina is a slice of life about a girl named Regina and her random group of friends,where what ever happens, happens and I try to make it as interesting as possible. Updates: Daily", False, True)
add('ReidyandFriendsShowcase', 'http://reidynfriends.smackjeeves.com/comics/', u"A general showcase where pretty much anyone can post anything they want, barring porn. Maybe. Probably. We also try to be civil whenever possible, so don't go out of your way to piss people off. Other than that just sit back, relax, and enjoy the showcase. Anyways, you should have at least SOME experience spriting before applying to join, should you want to. We don't accept recolors and are very much against sprite thieves.", False, False)
add('RemoteAngel', 'http://remoteangel.smackjeeves.com/comics/', u"READ FROM LEFT TO RIGHT. Alice Desangi has been having this obscure dreams lately and leads to this demon, Rose, to attempt to kill her. She discovers that she's an angel of God. One of the children of light who God chooses in the world. Her deceased sister, Becky, gives her hints on dealing with the goodness and evils of the world. The mysteries behind Alice, her friends and enemies begin to unfold as the story goes on. Genre: Action, Comedy, Romance, Slice of life, Supernatural, Drama", False, True)
add('Replica', 'http://replica.smackjeeves.com/comics/', u'Edelric Helgard, a young Marquis, returns to the house of his childhood in order to save his family\u2019s lands from an epidemic. During his research, he encounters a foreign slave who looks disturbingly like his first love, his late half-brother. Thus begins a game of replicas mingling memories and reality. -Read from Left to Right -Boys Love -R-18 from chapter 2 onwards -Updates on Fridays', True, True)
add('Respectable', 'http://respectable.smackjeeves.com/comics/', u'Toby Barnes has everything he\'d ever hoped for. The good job, the gorgeous girlfriend, the whole respectable lifestyle. But there\'s thing he didn\'t count on: it\'s driving him crazy! Everything\'s too normal, and with his rocker friends trying to get him to be himself, he\'s finding he can\'t mesh the two opposing sides. Can he balance his sensible life with his true self, or has something got to give? Perhaps being "Respectable" is not all it promised...', True, True)
add('ReturntoEden', 'http://rte.smackjeeves.com/comics/', u"When you're the last angel remaining, being mistaken for Satan's lunch is *not* going to make things easier.... (may contain fun stuff like angels, demons, complete disregard for the bible, crazy people and bare butts, sometimes bare-butted crazy people. Add a hint of BL, and you've been warned)", False, True)
add('RiversideExtras', 'http://www.riversidecomics.co/comics/', u'In Riverside, WA, year 1919, there lives a woman with no known surviving family and no history on file. She goes through aliases like tissue paper. The people closest to her have no idea where she came from, or who she really is. The unanswered question repeats: who is Ophelia Banksly? Will you try your own hand?', True, True)
add('RottenApple', 'http://rottenapple.smackjeeves.com/comics/', u'I might just be rotten... not bad... just rotten. I an still be useful. Sort of a diary/ comic of musings from someone with high functioning autism. Done in a Kokuto Yuki inspired character style with zendoodles (zentangle) illustrations.', False, True)
add('RoyalIcing', 'http://royalicing.smackjeeves.com/comics/', u'AVAILABLE IN PRINT AT AMAZON.COM! Look for "Royal Icing Graphic Novel". Synopsis: When little Emily bakes a cake, she gets more than she bargained for. Strange flora and fauna, a cold-hearted prince, and a mystery that must be solved before she can return home from the Sucre Isles. What adventures await her in the land of curious candies?', False, True)
add('RubyNation', 'http://www.therubynation.com/comics/', u"This is the story of Ruby Harrison, former middle-upper-class American high schooler turned nine-foot-tall post-human giantess with powers of mass destruction. Dragged into a worldwide conspiracy that treats human beings as mere test subjects, Ruby's goal is to create a safe haven for her fellow post-human victims. But their powers are too valuable for the world to let be, and Ruby and her comrades will have to make hard decisions to preserve her new home.", False, True)
add('RuderiQuest', 'http://ruderi.smackjeeves.com/comics/', u'Four kids confront a school full of demonic teachers!', False, True)
add('RuneSpark', 'http://runespark.smackjeeves.com/comics/', u'Ever have your house crash-landed on by time-travelling aliens? Ever been put on trial by interdimensional magical princesses? Then you and Li have a lot in common! Pull up a seat and check out RuneSpark, an adventure spanning three worlds. Currently updated Monday-Friday.', False, True)
add('RyuManwebcomicversion', 'http://ryuman-web.smackjeeves.com/comics/', u'Seven original one-shot manga by Zen Migawa, done as school assignments during his study abroad period in Tokyo from 2009 to 2013. (Read right to left!)', False, True)
add('SAKANA', 'http://sakana.smackjeeves.com/comics/', u'A thrilling tale of two socially dysfunctional brothers working at the largest fish market in the world, and the things they must do to get paid, make friends and date ladies. Also, this comic updates a few days ahead of time on Mangamagazine.net! http://www.mangamagazine.net/manga-and-comics/SAKANA/detail-page/125', False, True)
add('SChIzO', 'http://schizophrenic.smackjeeves.com/comics/', u"Hector never seems to want to leave Ruby alone. He's always there, bugging her and tracking her every move and she can't stand him much longer. Of course...she has to learn to live with it seeing as he isn't going anywhere. Afterall, he IS just that little voice in her head. Join the schizophrenic Ruby, her mute best friend and roommate Kenneth, their eccentric neighbor Lynn and a whole cast of oddball characters as they try to live through the everyday trials of moving out and living on your own...despite being a little messed up in the head.", False, True)
add('SFCBlackjackBay', 'http://blackjackbay.smackjeeves.com/comics/', u'39 Days... 21 Fan Characters... 3 Tribes... 1 Sole Survivor... And probably some other numbers too. This...is Survivor Fan Characters: Blackjack Bay!', False, True)
add('SFCForestofDreams', 'http://sfcforestofdreams.smackjeeves.com/comics/', u'A strict, megalomaniacal lioness. A egocentric, muscular vampire. A sarcastic, antisocial eraser. A surprisingly sane blob. A small, mute pikmin. An optimistic, friendly green thing. A stubborn, determined mouse. A curious woman from the future. A meek, brilliant scientist. A calm, fatherly fighter. A serious, taciturn war veteran. A crazy, hyper girl. A confident, eager architect. A savvy, sly chimpanzee. A frustrated, busty teenager. A sad, lonely emo. A fangirlish, lovestruck fairy. A dominant, genius octopus. A loud, grumpy senior citizen. And a sadistic, creepy alien. Who will win the $1,000,000 grand prize?', False, True)
add('SLightlyabOVeavErage', 'http://slightlyaboveaverage.smackjeeves.com/comics/', u'Keiko Tachibana is an average High school girl. Scratch that. She\'s a self proclaimed "Slighty above average" High school girl who has dedicated herself to being only moderately better than the social norm. However one day she gets a visit from someone Way over the top. An inter dimensional cutie whom goes by the name Llla-Elac Ngtholi Cllegogg, also known as "Laila" to humans. She has come to destroy the sanity, and lives of everyone at Daisuke Ryuzaki high school. However, poor Keiko seems to be the only one at school whom has noticed this terrifying beast, and to make matters worse, she\'s staying at her house!! Will Keiko be driven insane by the ramblings of this terrible alien and her Slightly above average lifestyle tossed to the wind? Or will she succeed in defeating this strange alien menace!? Find out in this incredibly odd web comic inspired by the works of H.P. Lovecraft!', True, True)
add('SOSRadio', 'http://sosradio.smackjeeves.com/comics/', u'WORKERS WARNING, CONTAINS MUSIC PLAYER "Set at very low volume, Lyrics warning" 50.5 The Sounds Of Survival Apocalyptic Radio "Because it\'s never to late to liberate!" A web-comic of sound, music, and a quest for creative freedom from an entertainment starved tyrannical monarchy where anyone with the gift of art and self expression are not only hunted but enslaved. Chainsaw Adam\'s, a lone pirate radio dj travels a post apocalyptic wasteland broadcasting a message of rebellion. Calling to the abstract souls and the free spirits, he inspires those in hiding from the powers that be to rise up and fight back to create a new society built on the stuff that dreams are made of. "CLIFF-NOTES FOR NEW VIEWERS" After breaching the city walls of Tulsa, Chainsaw finds Rockette, the sister of the woman he seeks "The Girl with Green Eyes" AKA (Quill). Ready to venture to the prison to rescue her, the two find themselves confronted by re-animated robots bent on destruction. Can Chainsaw\'s abilities as a \'Natural\' save them!? WHY READ? Read BEFORE we become popular. THEN when your friends start reading too, you can say "Hey I\'ve been reading for years, suck it!', False, True)
add('SPRITEDHeroesofDobalia', 'http://spritedhod.smackjeeves.com/comics/', u"The best sprite adventure comic ever made may not be this one. But now that you're here, follow the adventures of the heirs of Dobalia in 2D mobian format. (WARNING: CONTAINS STRONG LANGUAGE)", False, True)
add('SUNRISESTORY', 'http://sunrisestory.smackjeeves.com/comics/', u'A Story about a monster searching for the sun. A Story without words, told in colour.', False, True)
add('SabishiiGhost', 'http://sabishiighost.smackjeeves.com/comics/', u'A ghost story. Boy-love. Horror, violence, romance, and drama.', False, True)
add('SaintforRent', 'http://saint-for-rent.smackjeeves.com/comics/', u"Saint runs an inn for time travelers, which leaves him little time to write his trashy romance novels. Always a pit stop in the crisscrossing lives of his out-of-date friends and family, Saint wonders where his place is in a world that's quickly passing him by. Unfortunately, he also attracts the more\u2026 supernatural \u201cguests,\u201d too. [Animated .gif webcomic] Updates Tuesdays & Fridays. Time travels I MEAN REDIRECTS to main site --> http://www.saintforrent.com", False, True)
add('SakuraDAY', 'http://sakuraday.smackjeeves.com/comics/', u'She lived then died and resurrected once more. Join Meija as she meets the strange and mysterious (and oddly interesting) people of LALA dormitory and starts her new adventure in a world strangely familiar but entirely new. P.S. this comic is read in the "manga way": RIGHT TO LEFT. UPDATES WEEKLY { Saturday & Sunday } Enjoy~', False, True)
add('SakuraMishzo', 'http://sakurazo.smackjeeves.com/comics/', u'An original gekiga set in Sengoku Period and featuring the strange relationship between the warlord Nobunaga, his valet Ranmaru and the ninja Mitsubachi.', True, True)
add('SalemUncommons', 'http://salemuncommons.smackjeeves.com/comics/', u"In a hidden corner of Salem MA stands the Salem Uncommon boarding house...It was purchased years ago by Karl (formerly Dr. Frankenstein's nameless monster), and has since attracted every manner of ghoul, ghost, goblin, and monster (as well as a few odd humans)...If you like your humor a little dark but good natured, like the Addams and Munsters of old, stop by. Salem always has room for more Uncommons...", False, True)
add('SallySprocketAndPistonPete', 'http://ssnpp.smackjeeves.com/comics/', u"A novel-length tale, set in the Steampunk-ified Wild West, that follows the adventures of a daddy-daughter duo (except the daddy's an android inventor and the daughter's a cyborg of his handiwork...)", False, False)
add('SaltyKiss', 'http://saltykiss.smackjeeves.com/comics/', u"Salty Kiss is my new harem manga that I've been working on for awhile. It will be like your basic harem manga but theres a twist... it will be set on cargo ship. ----------- The story starts out with Reese Sorelle, a 21 year old geek who spends most of his time on the computer. One night he goes partying (alone, because he doesn't really have any friends.) And gets drunk and wakes up on a cargo ship in the middle of the ocean! And the crew is all women! How will Reese survive this? ----------- I got the idea for this while in Anthropology class during college. I loved harem manga, it was my favorite genre. My favorite mangas were Love Hina and Ichigo 100% at that time. So I thought, why couldn't I combine my love for manga and my anthropology education? So the idea for Salty Kiss was born. I love ships and the ocean, so I set most of the comic on a cargo ship. The characters on the ship will go to port towns around the world for more adventures. tags: romance adventure manga HL hetero heterosexual straight not BL not GL Pokemon Shonen", False, True)
add('Saywhatyoumean', 'http://saywhatyoumean.smackjeeves.com/comics/', u"A comic pulled out of the freaked up author's subconscious. humor and pain, philosophy and non-sense,love and violence and sexy things, based on real events or completely fake, who knows what the next update will bring", False, True)
add('SchoolofRejectsSoRe', 'http://sore.smackjeeves.com/comics/', u"Have you ever wondered what happens to the characters that DON'T make it into the stories? There is a place where rejected, unfinished, and imperfect characters can go to study, play, and talk to each other. A place that an ordinary girl has stumbled upon... This is the School of Rejects.", False, True)
add('ScionsoftheSeraph', 'http://www.sossaga.com/comics/', u'SCIONS OF THE SERAPH author - crestforte current artist - starexorcist Another year. Another death. Jennie Schaffer lost count of how many family members had died. And the only ones left now were her parents. Until her sixteenth birthday... Entering into the Caspian household, Jennie found herself being entangled in a destiny she could have done without. What secrets will she uncover?', True, True)
add('ScrappedProject', 'http://scrappedproject.smackjeeves.com/comics/', u'This is a simple tale of what happens when ideas get discarded and go looking for their purpose in life. Told through the eyes of a robot. ~Journey Completed~ (thanks for reading ^.^)', False, True)
add('SecretPowerbk1', 'http://secretpower1.smackjeeves.com/comics/', u"Since the begining of time... There's been a power to control all... It's been locked away, and kept a secret... Until now. Jump threw time, control magic, and learn from a new world known as Spartelia. -Author's note- I created this book, about three-four years ago. i was younger and my art style isn't the best, but i have more that are better. But i'm sure the story will be better than the artwork. ~ Enjoy", False, True)
add('SecretPowerbk2', 'http://secretpower2.smackjeeves.com/comics/', u"book 2, please enjoy book 1 and 2, and if your reading this for your every first time, I wouldn't if I were you, because nothing would make sence, read book 1 first before reading this book.", False, True)
add('Seki', 'http://se-ki.smackjeeves.com/comics/', u"i really suck at descriptions so i deleted it ovo just read This manga contains Explicit Sexual imagery(between men)! read at your own risk! (\u25d5\u203f\u25d5\u273f) English is not my first language... and i'm dyslectic so there will be spelling and grammar errors..i apologize in advance m(._.)m read japanese style!", True, True)
add('SenoireDelirium', 'http://senoiredelirium.smackjeeves.com/comics/', u"Omnibus of Senoire Delirium 1: Conquer (2007) and Senoire Delirium 2: Rivalry (2009). Updating almost daily. The Senoires were a team of legendary heroes who saved the world and created the magical Madness Pizza Slices. Generations later, a race of candy people took over the world and humans were moved to the artificial internal planet known as the Bernoulli 2. A woman raised four boys to become the next generation of the Senoires and her timing couldn't be better.", False, True)
add('SerendipityAnEquestrianTale', 'http://talesofserendipity.smackjeeves.com/comics/', u'Serendipity is the phenomenon of finding wonderful things you were never searching for. With that said, join the herd into the land of Equestria and beyond, seeing the intertwining lives of the ponies who live there.', False, True)
add('SeriousTimes', 'http://serioustimes.smackjeeves.com/comics/', u"Let's get serious...", False, True)
add('ShacklesInstallment02', 'http://shackles02.smackjeeves.com/comics/', u'After escaping badly wounded with her target captured, Kas loses conciousness and crashlands on an alien planet. Captured by a tribe of the native aliens, Kas is forced to work together with Otakaog Phimosh, her own prisoner, and she starts to suspect he knows a lot more about her than he should...', False, True)
add('Shameless', 'http://shamelesscomic.smackjeeves.com/comics/', u'The story of a 14 year old girl who suddenly wakes up with the duty to create a region on a barren world known as Origen, alongside six other "Cosmos" that are alien in appearance. Join her as she faces the hardships of unrequited love, friendship, jealousy, and the inevitable...', False, True)
add('ShamelessAdvertisements', 'http://advertiseat.smackjeeves.com/comics/', u"Ever made a comic that none notice? But do you think the comic would be very successful? Well, you just gotta advertise somewhere, maybe a multi-author comic, but that'll annoy other authors. NOT ANYMORE! In this comic, you can post as many advertisements as you like! Show others your comics, and watch comics from others! That way, everyone will be able to read the latest comics! Please only place advertisements for comics here. So no fillers, no bios, no spritesheets. Don't forget to add a link towards your comic profile in the comments section below the ad! We request that you read the rules & guidelines section if you haven't done so already. Please don't be negative about comics in the comments, no one wants their ad to look bad. For those interested: Last author count: 491 authors (May 2014)", False, True)
add('ShotoutofCanon', 'http://akumathfs.smackjeeves.com/comics/', u"Shot out of Canon is the new direction for the former Fallout Shelter Comics. Like the Fallout Shelter Comics, it'll be about the forums (and sometimes comics) I go to. Unlike the former Fallout Shelter Comics, this will deal with things besides there. And unlike that, it won't be Canon with my Main Comics. Formerly: My Fallout Shelter Comics I do for the Fallout Shelter: http://z1.invisionfree.com/forums/The_Fallout_Shelter/index.php?act=idx", False, True)
add('ShroudofLight', 'http://shroudoflight.smackjeeves.com/comics/', u'Shroud of Light takes place in a world enshrouded in darkness, following a Young Lumin hunter Mina, who on a routine hunt discovers something that could change the world as she knows it', False, True)
add('Signifikat', 'http://signifikat.smackjeeves.com/comics/', u"Life's but a walking shadow, a poor player That struts and frets his hour upon the stage And then is heard no more: it is a tale Told by an idiot, full of sound and fury, Signifying nothing.", True, True)
add('SimonSues', 'http://simonsues.smackjeeves.com/comics/', u"Simon, once brilliant law student at the prestigious Haversford Campus, now finds himself council for those in need of representation against the occult. It's the age old Faustian tale, but this time, Faust has a killer lawyer. Updates(religiously!) Monday, Wednesday, and Friday! ************************************************* WARNING! -Main Comic (Not BL) contains horror and graphic violence. -Bonus Comics contain sexual content/BL. ************************************************* Please support Simon Sues on Ink Blazers http://simonsues.inkblazers.com The more fans and hits I get, the more money goes toward the comic! *Check out my tumblr to see process pages and random sketches! http://simonsues.tumblr.com/", False, False)
add('SimpleBear', 'http://simplebear.smackjeeves.com/comics/', u'Bear Copenhagen is just a simple bear and nothing else. Spoiler: Not for long. Simple Bear is an action packed, supernatural thrill ride that uses words like this in the summary to make people want to read it. Also this comic features cartoon animals, not "furries." Just thought I\'d throw that out there. Updates 2-to-3 times a week', False, False)
add('SimplySarah', 'http://simplysarah.smackjeeves.com/comics/', u'A slice-of-life story about people and their own unique problems as seen through the eyes of one girl as she grows up dealing with her own.', False, True)
add('Sire', 'http://sire.thewebcomic.com/comics/', u"Have you ever read a book, and cared about the characters? More than a normal person might? Did you notice strange parallels between their lives and yours? Then perhaps you'll have something to learn from Anna and Susan, and the people they meet at Lineage Haven. There, the only way to survive is by reading between the lines... Sire updates on Wednesdays.", False, True)
add('Skeptical', 'http://skeptical.smackjeeves.com/comics/', u'A regular slice of life/death romantic comedy about an unusual family and their relations to a group of creatures that call themselves "skull people". Said human family(and half the comic itself) was created by and belongs to TyrannicalShipper! Warning- there\'s an abundance of foul language, and blood. Lots of blood, including the first page. Also, constructive critiques are always appreciated! Currently updates every Monday, Wednesday, and Friday!', False, True)
add('Slackmatic', 'http://slackmatic.smackjeeves.com/comics/', u'Slackmatic is a comic diary with me, a Lava man from the Center of the Earth, Gandalf, Darth Vader, my daughter and a mad scientist cat.', False, True)
add('SlipstreamSingularity', 'http://slipstreamsingularity.smackjeeves.com/comics/', u'350 years have passed since the first and only mission beyond Human Occupied Space was launched. In search of the alien intelligence that sent such wondrous knowledge back to Earth, the Odyssey mission was lost. Now, denied their own home world by the rebellion of their own children creations, the Synthetics, humanity has become a race of despots and wanderers that meander through the stars, eking out an existence. Updated Tuesdays and Saturdays.', False, True)
add('SmallPressAdventures', 'http://smallpressadventures.smackjeeves.com/comics/', u"Action and adventure from all across the small press! Featuring genres ranging from superhero to horror to who knows? This comic is updated every Wednesday, so come on back! Don't forget to check out all our other strips!!!", False, False)
add('SocksMittensandScarfs', 'http://socksmitsscarfs.smackjeeves.com/comics/', u'A GL story. Everyone wants to be different. Except Alice. Alice IS different. Alice is gay. Alice just wants to be "normal" This is the story about Alice growing up and struggling to come to terms with her sexuality. the comic is 16+. There is a small amount of nudity. Not enough to warrant the mature tag on the comic. Any pages with nudity or "adult" themes will be marked as NSFW. Enjoy. Updates about every 4 days.', False, True)
add('SomebodyShootMe', 'http://somebodyshootme.smackjeeves.com/comics/', u"An autobiographical comic chronicling the negative aspects of Kita's life in a light and often humorous manner. P.S. Kita sometimes has a potty mouth. It can only get worse. UPDATES DAILY!", False, True)
add('SomethingLikeaPhenomenon', 'http://somethinglikeaphenomenon.smackjeeves.com/comics/', u'All kinds of love in mid 90s fictional NYC like city. Vampires and other supernatural things included. Updates Wednesdays, unless otherwise specified.', True, True)
add('SonicAuthorAdventII', 'http://saa2.smackjeeves.com/comics/', u'TEH CHAT IS BACK. Dont forget to space between your sentences.- Mr. Jack If you\'ve come to SAAII thinking "Oh my god- another author comic!"- Never fear. this one is the ORIGINAL AND FIRST author comic. Well, it\'s prequel, SAA, run by mostly the the same people, was.-Rikco the Robot Random post of death and doom. ~ Ryan We demand cookies! ~ Shin Guess who\'s back and fluffier than ever! ~ Shard Oh Praise the mightly Lords of the Laziness ~Jayh TEAM JINJO PWNZ YOUR SOULS! AND IM BACK! -2021 Run around for all I care! I have me my flying ceiling! HA! ~Slash Beware the newness! ~3000', False, True)
add('SonicBoom', 'http://sonic-boom.smackjeeves.com/comics/', u"Rules: 1. No random images that have nothing to do with the comic. 2. No content over PG-13. 3. Excessive trolling is prohibited. Some minor jokes are fine, but don't take it too far please. 4. If you're gonna give criticism, be constructive! No blatant insults! 5. Homophobia is also undesired. 6. Try to stay active! Spar does inactive purges now!", False, True)
add('SonicClub', 'http://sonicclub.smackjeeves.com/comics/', u"****RETIRED/DEAD/COMPLETED**** The Characters: Sonic Shadow Amy Tails Knuckles Rouge Capuchino(me) Nikomy(Capuchino's girlfriend) Lola(Capuchino's little sister) Lanz(Capuchino's older brother) Andry(I made him up... he's just a Shadow android) Xavier (Xevious) Degreenfreak Miles-XD(Just Miles) Stochi The Vampire Chao Crackuchino The Hedgehog Crazy China Crappuchino Ghost the Echidna(inlove with Knuckles.. XD) Green Darkness Flame the demon hedgehog Glandor the hedgehog and his brother cendar the fox", False, True)
add('SonicDashly', 'http://sonicdashly.smackjeeves.com/comics/', u'Another Generic Sonic comic? More likely than you think...', False, True)
add('SonicFuture', 'http://sonicfuture.smackjeeves.com/comics/', u'A sprite comic that takes place 25 years in the future of Planet Mobius. Rated E-10+.', False, True)
add('SonicSchoolRedo', 'http://sonicschoolredo.smackjeeves.com/comics/', u'THIS COMIC HAS BEEN MOVED TO CRAZY R US.', False, True)
add('SonicUniverseAsk', 'http://sonicuniverseask.smackjeeves.com/comics/', u'HI THERE! Do you read Sonic: Universe, or Sonic Universe- Sides?... No? WELL! Would you like to learn about it? n...no?... AH WELL! Here you can ask the characters anything you wish! And they will answer as they please! Probable Spoilers for the Main Comic', False, True)
add('SoulGuardian', 'http://soulguardian.smackjeeves.com/comics/', u'How far would you go...to get home alive? Ren has been kidnapped, and sent to the future. Upon her arrival, a strange cloaked young man finds her. On hearing her circumstances...he offers to help her, for a price. READ: Right to left UPDATES: Wednesday', False, False)
add('SouthernCross', 'http://southerncross.thewebcomic.com/comics/', u"This a webcomic about a bunch of hopefully amusing people known as the eight state capital cities of Australia. Southern Cross is a moe anthropomorphization comic - in the vein of Hetalia, Afganisu-tan and the OS-tans to name a few - featuring Sydney, Melbourne, Brisbane, Canberra, Hobart, Darwin, Adelaide and Perth. It's about their relationships, their rivalries, their teamwork, their personal tragedies, and the fact that they're all, at heart...a little dysfunctional. Primarily a comedy (or at least trying to be), you don't have to know anything about Australia for this. Hell, you don't even have to care about Australia either. And maybe you'll learn a thing or two...but don't worry. It's not that kind of educational. Updates when I can!", False, True)
add('SovereignTheMostAmazingComicEver', 'http://mostamazingcomicever.smackjeeves.com/comics/', u'Sovereign is the most amazing story ever told about an extremely boring boy, who is fortunately kidnapped by sky pirates. Updates Tuesday and Thursday! http://www.mostamazingcomicever.com/', False, True)
add('SpaghettiAndMeatballs', 'http://spaghettiandmeatballs.smackjeeves.com/comics/', u"What do you do when you should be studying? MAKE A WEBCOMIC. Seriously though. You want puns? You got it. You want women? You can imagine getting them. You want crazy ass ninjas jumping around and shit?! Then you've clicked on the wrong comic and I apologize for wasting your time. Like LoveitWilde on Facebook for updates straight to your news feed! https://www.facebook.com/LoveitWilde", True, True)
add('SparElricsextras', 'http://sparextras.smackjeeves.com/comics/', u"Just a bunch of random shit that I wanna put up. :P Such as sprite-sheets, W.I.P.s, drawings and more! :D BTW, if you have a problem with that, just click the BACK button and leave. I do NOT tolerate trolls/assholes. Thank you! <33 Also, you're welcome to join in on the fun if you so choose! Just PM me!", False, True)
add('SparkStory', 'http://sparkstory.smackjeeves.com/comics/', u'Darker forces than anyone expected have set a sinister plot in motion, and these heroes will have to find a way to save themselves from becoming unwilling pawns in a brutal war. Introducing the story of Spark and her friends, not quite the perfect team, but prepared to defend their new home from anything that comes their way. Current Arc: 2 - Chained Heat Brokor: Hey! Wheres Carbon? Wheres RJ? Wheres Aurora? Did sending myself back in time go THIS far? Ryjora: PRINCESS EMMERSON DEMANDS MORE QUOTES! GET MOVING PEOPLE! Melody: Wait, I never said anything about quotes! What are you-huh? You say I\'m being recorded for quotes? WHAT DO YOU MEAN?! TURN OFF THAT MIC BEFORE I JAM IT UP YOUR *end broadcast* Plazem: This is a quote, it\'s a quote quoting the quote that I just quoted. I like this quote. PurpleChickenPineapple: "I once said: "I once said: "I once said." - PCP Zaph: When suddenly FROG THE JAM...what does that even mean?', False, True)
add('Spellcross', 'http://spellcross.smackjeeves.com/comics/', u'In the City of Aria, the last great capital of the world, life revolves around mysterious dungeons and the monsters that crawl from them. Adventurers gather from the world over to battle in these dangerous labyrinths, seeking the fame and fortune that comes from exploring them. Follow Caldwell the Alchemist as he strives to raise himself up the ranks of adventurers, to gather a party of friends, and to overcome his fears. Updates three times a week on Monday, Wednesday, and Friday!', False, True)
add('SpiderWings', 'http://spiderwings.smackjeeves.com/comics/', u'This is a story about a girl named Momo, who has a brush with death and is thrown into the world of Limbo...Now she must find away back home but that is easier said than done. Updated: every Tuesday Rated-pg-13 Now updating chapter 6', False, True)
add('Spidersilk', 'http://spidersilk.smackjeeves.com/comics/', u"Ah, Kalviva! A bright, bustling city. It's a crossroad for trade and all kinds of people have made their way there. Sometimes ... very strange people. Kalviva is also home to the biggest, most impressive, thief system. Prentice, following his exiled brother from the north, has made his way to Kalviva. He stumbles into one such thief cell (much to the embarrassment of his guildmates). Casting aside his strict warrior training doesn't come easily. His attempts at fitting in are nearly as bad as his attempts at thieving. However, the thieves live comfortably, certain of their protection, certain of their domain, and certain of each other. It is this stability Prentice seeks. But perhaps they are a little too comfortable. They will be hard pressed to handle what happens. Updates twice a week, Monday and Friday! Fantasy/ Comedy/ Drama/ Action/ Adventure/ Romance", False, True)
add('SplitScreen', 'http://splitscreencomic.smackjeeves.com/comics/', u"Jan Lumeneski and Jeremy Tanner were inseparable best friends from childhood through high school, but Jan wanted more. When things didn't go her way Jan vowed never to speak to Jeremy again. More than a decade later a chance meeting puts the pair together again, but a lot has happened. Jan is a successful fashion designer while Jeremy is now fat and depressed. Still Jan can't help but feel that old flame burning, but is she just going to end up back where she started?", True, True)
add('Spriterschaos', 'http://spriterschaos.smackjeeves.com/comics/', u'random things happen everyday', False, True)
add('Sprytts', 'http://sprytts.smackjeeves.com/comics/', u'---COMPLETE COMIC--- For the past few hundred years, the two great countrys, Carvia and Gloomland, have been enemies. While Carvia, land of the Sprytts, is full of wonder, delight, and magic, Gloomland, land of the Gools is full of demons, nightmares and violence. Blado, a royal guard to Queen Mellaba, is in search of the mysteries behind his past. Not long after he and three other royal guards encounter the princess, they get caught up in the middle of this international conflict.', False, True)
add('StarTrip', 'http://startrip.smackjeeves.com/comics/', u'Chronicles the travels of a human girl and her alien companion as they visit every habitable planet in the galaxy. Updates a page every two days!', False, True)
add('Stay', 'http://stay-comic.smackjeeves.com/comics/', u"Stay is a comic I started in 2008 and I'm just now uploading it in 2012 >_>; It is a Yaoi comic Description: Lee is just an ordinary dude, he's very studious, studies on the weekends and does well in school, but then he meets Jude - a punk guy with streaks in his hair, piercings and tattoos -- his total opposite! Jude is a mysterious guy with a mysterious past that for some reason wants to be all over Lee the nerd, and as he makes his moves hy-jinks ensue!", True, False)
add('StellaInChrome', 'http://stellainchrome.smackjeeves.com/comics/', u'Lost in the rubble at a condominium development lies a key that unlocks more than doors. Can Stella unlock the mystery that surrounds the key itself? Updated 8:00 PM CST each Wednesday, every Wednesday.', False, False)
add('Stereophonic', 'http://stereophonic.thewebcomic.com/comics/', u"In 1966, Elliot Wood is an artist struggling to make ends meet. After a final warning from his landlord, Elliot is left with no choice but to go in search of a flatmate. His situation seems bleak until he meets an offbeat freeloader named Alex Wright- who despite his strange nature, seems to be Elliot's last hope. Without many options left, the two strangers are stuck together, for better or worse. Updates Mondays.", False, True)
add('Storyofadamnedlove', 'http://storyofadamnedlove.smackjeeves.com/comics/', u'A typical love, nothing out of the ordianary, just a vamprie and the to be Devil of hell, nothing unusal about this.', False, True)
add('StrangersandFriends', 'http://hemu.smackjeeves.com/comics/', u'The small English town of Wootton Bassett begins to be haunted by a series of mysterious and horrific murders! Hemu, a new-comer to the town, becomes an obvious and easy target to the local community- he does have his fair share of secrets! But what secrets are the other locals hiding? A comic about the peculiar prejudices and customs of small communities, with a hint of social commentary on modern Britain, and a sinister splash of horror ;)', False, False)
add('Striped', 'http://striped.smackjeeves.com/comics/', u"'Altan Silvan is a new transfer student at this highschool. And he's already this popular! But there is something weird about him- he always wears a scarf! Hey, wait, maybe he has a flu... WEll, what's more, since he became one of our students, strange things started to happen at this school! Hey... What's with this blood?! Where's everybody?! Hello?!!' Updated irregularly. Edit: This is my first comic ever, so art is changing and improving (at least I think so xD) with each chapter. WARNING: This comic contains nudity, violence, gore, swearing, because that's how life is.", True, True)
add('StuntRayWalterswish', 'http://stuntray.smackjeeves.com/comics/', u'Akira Bogard had his life changed when a strange race called DH\xc8MINS appeared from nowhere and toke her girlfriend, Jo kisaragi, away from him. Dh\xe9mins are beings that can control a dangerous substance called DARK MATTER that can be used in inumerous ways! With the intelligent professor Simon at his side they try to stand up against these creatures. Akira will end up involving some of his friends in this journey... But everything will change when they meet the dh\xe9min hunter Raymond Siroff... Suspense, lots of action, a bit of humor, some beloved ecchi bits and a complex story line makes StuntRay a story word reading! Where did the dh\xe9mins came from? What exacly is dark matter? And why Akira is seriously involved in this? Updates almost every day!! READY FROM LEFT TO RIGHT!', False, True)
add('SubjecttoChangeCollegeWoes', 'http://subject-to-change.smackjeeves.com/comics/', u'Erin and her friends are about to embark on the greatest test on life and their friendship, going away to college. The five girls will have to survive the tests of roommates (egads!), college tests, and new relationships. Through it all the girls will find out if their friendship can really outlast the world of College Woes.', False, True)
add('Sunfall', 'http://sunfall.thewebcomic.com/comics/', u'Sunfall is the story about a girl named Nia and her struggle to fit into two different worlds, all while training to become one of the most powerful people in existence.', False, True)
add('SunmeetsMoon', 'http://sunmeetsmoon.smackjeeves.com/comics/', u"This is a story about a boy and a girl who met in the summer and fell in love. But the end of the summer parted them for a long time. The meeting again wasn't as happy as they expected... Between them stand a lot of differences.She being a loner, attracted by witchcraft and some serious supernatural stuff. He being a sociable fellow with a childish behaviour. But most of all he having a new girlfriend ;) The story has four parts, each one made in a different year: 1. The Riddle ('07) 2. Marg's revenge ('06) 3. Who's that girl? ('07/'08) 4. Passing by Midnight ('08/'09)", False, False)
add('SuperDimensionAfterTheHero', 'http://afterthehero.smackjeeves.com/comics/', u"Updates once every weekend. (Mondays count as weekend.) Super-Dimension comics are just the name I give all my superhero comics. This has no relation to any other Super-Dimension comics. Dennis Lockham was Paladin. A guardian superhero of L.A. But now his powers are gone. He's just a man. And that is the one thing he can't take on. Rated 12+ for *&%$'ed cussing, and violence. Neither of much, though.", False, True)
add('SuperMarioBros3', 'http://smb3.smackjeeves.com/comics/', u'The story of the Super Mario Bros. 3 game, now in delicious comic form!', False, True)
add('SuperMarjoBros', 'http://marjobros.smackjeeves.com/comics/', u'An Aggressively discreet Marjo Parody. Currently a pass-time for bigger and better things ahead.', False, True)
add('SupermassiveBlackHoleA', 'http://smbhax.smackjeeves.com/comics/', u'Stories of a human civilization at the center of the Milky Way galaxy: an area of space dominated by a gigantic black hole, where energy is abundant and life is cheap. Updates M-F, usually multiple times per day.', False, True)
add('SurvivorFanCharacters', 'http://sfc.smackjeeves.com/comics/', u'Fan Characters will be competing for $1,000,000.', False, True)
add('SweetestPoison', 'http://sweetestpoison.smackjeeves.com/comics/', u"Everyone is dreaming about something. Everyone wants something. Most of the people want to be famous, rich, successful in life, others want love, family, happiness. So many people, and so many dreams. Though, there is something that makes them alike: they want to reach their goal so badly, they would give anything for it. This fallibility makes them so seductive for the demons. They are potential clients. Zef Mefistopheles is a manager. He is one of the best in making musicians famous. He helped a lots of mortal people to become famous and rich musicians, he is really popular. But one day appears a young boy, who changes Zef's life... At the first look, Fynne is like the other people, he prevously met: a purposeful, spirited daydreamer, whom dream is to become a musician. But he isn't really like the others: because he is a demon, too.", False, True)
add('SwitchMechanism', 'http://switchmechanism.smackjeeves.com/comics/', u'A story about a boy struggling with his demons, mainly the one in the vinyl catsuit.', False, True)
add('Symbios', 'http://symbios.smackjeeves.com/comics/', u"Almost every nation in existence has a tale of terrors and hauntings to pass on to their posterity... Xedondria is no different. Their tale was to keep children from doing wrong, and if they behaved, their reward was to sleep with a clear conscience. But if they didn't behave, not only would they suffer the consequences from man, they would also be visited by the Night Horror: a monstrosity only nightmares could bring, only living in one's sleep... Now one must ask: who is it that sleeps, yet suffers the torture of this very real Horror? ***Comic will be marked mature due to any violence or sexual themes, Thank you!***", True, True)
add('TEN', 'http://ten.smackjeeves.com/comics/', u"What happens when sci-fi meets boyslove? --- Dez is a security officer at a small company in New York. A half blind security officer. Aside from that funny fact he has no past. Or at least he doesn't remember anything from before 2 years ago - when he got fished out of the ocean - and he almost gave up on ever remembering. Until a homeless boy stumbles into his life that seems to know a little too much about him. Intrigued and strangely attracted he tries to pull the boy into his life and gets pulled into his own unsettling past in return...", False, False)
add('TLAAOK', 'http://tlaaok.smackjeeves.com/comics/', u"Percival Livingston may not entirely look the part, but he is one of the world's leading experts when it comes to authenticating rare artifacts. Thus, he is invited by a private collector to take a look at a rather strange find. However, before Percy is able to get a good look at the object, it is stolen by a thief! Oh hell no! Percy chases the man down, but is sucked into another world when he collides with said thief as he happens to be opening an inter dimensional gate! Now Percy has to deal with the thief, get the artifact, and find a way back home! Of course, knowing Percy, he may just want to do a little exploring in between... Warnings: -It's bl. SilverHyena may have an addiction problem... hmmm... -It's rated mature, because I plan on being a bit... tasteless. Yeeees. -It's on crack. Don't expect anything too serious. XP", True, True)
add('TPTruePower', 'http://truepower.smackjeeves.com/comics/', u'A fun comic about friendship, aliens, and flashlights! Updates: Wednesdays (or Thursdays) and Saturdays Visit us on Facebook: https://www.facebook.com/truepowercomic', False, False)
add('TRIPP', 'http://tripp.smackjeeves.com/comics/', u"The story of an ordinary guy stuck in a never-ending acid trip. Tripp must learn to cope with his new psychotropically enhanced existence with the aid of his spirit guide, Edgar Allan Poe. This comic is not an endorsement of drug use, merely one guy's effort to deal with an accidental, perpetual hallucinatory life change. Updates on Mondays (really Sunday night at 11:45) and Thursdays See the official site at http://trippcomic.com", False, True)
add('TaikiTheWebcomic', 'http://taiki.smackjeeves.com/comics/', u"FINISHED! Taiki is a typical shy 16 year old high school student who is starting the 10th grade with her best friend Nikki. Going into the 2nd half of high school, Taiki thinks it\u2019s strange that she has never liked someone or fallen in love. One day she unexpectedly meets someone who changes all of this. However this person turns out to be a girl! Taiki has always wanted to know what it was like to fall in love, but what she didn\u2019t expect was that finding out would also be a journey of self discovery, realizing her sexuality, and maybe even heartbreak. -IMPORTANT!!- This is a mirror of my own website, check it out if you want to see more artwork --> http://www.taikiwebcomic.com/ This comic was started in 2006, so the art in the beginning isn't very good compared to what it is now. This story contains GL and HL, it is MOSTLY GIRL LOVE THOUGH.", False, False)
add('TailsAdventureThroughTimeandOtherWorlds', 'http://tailsadventure.smackjeeves.com/comics/', u'Tails unexpectedly goes on an adventure through different worlds and even through different times! It all started from falling through a purple portal. How will his adventures go? Credit goes to those who ripped/edited the sprites used for this. None of the characters used belong to me except for my own.', False, True)
add('TakingPicturesofStrangers', 'http://darrenandkale.smackjeeves.com/comics/', u"Darren lived the charmed life of barhopping before he met Kale. It was a new guy every night, lots of drinking, lots of sex, etc. But when he snagged big, quiet Kale, Darren uncovered Kale's secret and set into motion a series of events that lead them both down a path no one expected. Warnings: first and foremost, very gay. Gay romance, gay sex, gay gay gay. If this isn't your cup of tea, you probably shouldn't bother continuing reading. Second, the occasional bad word. Third, booze. (Does booze require a warning? It's not underage drinking or anything.) Fourth; drama and cheeze out the wazoo. Fifth and final warning; very badly drawn. (And probably badly spelled, too.)", True, True)
add('TalesfromAaronsWings', 'http://tfaw.smackjeeves.com/comics/', u'A series of short comics exploring the life of Tempus, a Witness.', False, True)
add('TeKscloset', 'http://tekchats.smackjeeves.com/comics/', u"TeK's mind and friends. You're god is now forlorn.", True, True)
add('TechnicolorLondon', 'http://technicolorlondon.smackjeeves.com/comics/', u"Toby Landon's love life is a bloody mess.His on and off girlfriend has once again tossed him aside. His mate Mark gives him some advice: Try something different. With a kiss, the lives of these two friends go from being black and white to being full of vivid color. No longer a checkerboard, This is Technicolor London. //Yaoi/Boylove Plus a little bit of everything else// //Updates are Every Tuesday & Friday//", False, False)
add('ThatWasntThereYesterday', 'http://twty.smackjeeves.com/comics/', u'A mysterious stranger meets a mysterious road.', False, False)
add('The13thWorld', 'http://the13thworld.smackjeeves.com/comics/', u"In the galaxy known as Andromeda ruled by the Goddess Palutena; creatures known as O'phans rule the thirteen worlds and it is up to her chosen followers to save and bring peace to the thirteen planets. This is a mashup of several anime and video game worlds.", False, True)
add('TheAdventuresofBanjoZ', 'http://abz-fancomic.smackjeeves.com/comics/', u"The crossover fancomic to end all crossover fancomics (seriously, it makes Family Guy look like That 80's Show). It all started when Banjo decided to finally fix his house. A portal opens behind him, sending the hapless honeybear tumbling into yet another series of preposterously magical events. He's got no Jiggies, no Jinjos, and certainly no Red-Crested Breegulls to shoot the breeze with, though a mole or two might show up just to make his life more hair-raising than ever. I don't own BANJO-KAZOOIE. Or ZERO NO TSUKAIMA. Or GUILTY GEAR. Or any of the characters/franchises represented in these pages. This is written by fans for fans and anyone else looking for a laugh. Banjo, Mumbo Jumbo, Gruntilda, and the Kremlings are the property of RAREWARE ENTERTAINMENT. On 6/16, we will be back to our regularly-scheduled AND NOW FOR SOMETHING COMPLETELY DIFFERENT!!", True, True)
add('TheAntihero', 'http://antihero.smackjeeves.com/comics/', u"Most stories have good guys and bad. Some have only good guys, but with antagonists. Then some have only dastardly villains trying to do villainous things to decent people while all along screaming at the top of their lungs into the rain. This is one of those comics This is also a very depressing comic. Seriously. Every chapter is 'death' in a different language, and each title page is the Protagonist about to die. ... I told you it was depressing. Anyways, don't let that stop you! It takes place 20 years in the future. The U.S. has deteriorated into a kind of middle-ages scenario, where the government is corrupt, inflation rules, and the Mafia basically control the country. It doesn't get any better than that. But Isaac, the commander of the NY Mafia, notices there's a new gang in town. The Redblades. And there's something familiar about the commander... I'd rate it about 12+. There's mild gore, blood, and violence. Also comic cussing (!@#$%^& it!). And it's basically aimed at an older audiance, but if you're okay with the above, go ahead.", False, False)
add('TheArchipelago', 'http://thearchipelago.smackjeeves.com/comics/', u"Credenza's life as a waitress on a magical chain of islands is interrupted when a mysterious man with a missing eye washes up on the beach, beginning a series of events that will pull her into a battle to save the world and the people she loves.", False, True)
add('TheAttackoftheRecoloursSeason1', 'http://mysticalvalley.smackjeeves.com/comics/', u'The Recolours are attacking and the edits will have to eliminate them. Flash, Leeroy and Kedar500 are creating the recolors and sending them out to fight but Sonic, Josephk and others who are preventing them from succeeding. Will they save the world from whatever Flash and Kedar500 are planning? Read the Seasons and find out! Comic came 13th Place in the 2013 Smackie Awards (Sprite). Oh well... Warning: Mild Language may be used *Completed*', False, True)
add('TheAvianStories', 'http://theavianstories.smackjeeves.com/comics/', u'Sybil and Zakk are a pair of mythical humanoid avian monsters called avians with spirits of birds. When they meet each other they are spewed into a quest to stop genocidal acts on humans from a rouge group of avians.', False, True)
add('TheBattleInTheSky', 'http://thebattleinthesky.smackjeeves.com/comics/', u'High school student Al Morris has a fairly normal life. But that all changes when he is bitten by a zombie, then rescued from a brain-eating fate by a mysterious angel of death. As Al and his buddies travel the world on the R.A.S.(Reaper Airship) Whale, they encounter all sorts of people and predicaments, from funny to frightening to just plain odd. A unique supernatural story where almost every character is based on a Hetalia character, The Battle in the Sky is funny, heartfelt, and full of adventure!', False, True)
add('TheBookofNosferatu', 'http://www.thebookofnosferatu.com/comics/', u'Two unusual sisters strive to survive a post apocalyptic world where supernatural creatures reign supreme.', False, True)
add('TheBrideoftheShark', 'http://sameyome.smackjeeves.com/comics/', u"Toshio is a pearl diver, dealing with his love problems in Onjuku. 'Ehukai is a shark, instantly falling in love with the boy and claiming him his wife in front of his family...", True, False)
add('TheBucket', 'http://thebucket.smackjeeves.com/comics/', u'An art/comic journal including a psychological side story, "ENS Special".', False, True)
add('TheCafedAlizee', 'http://alizee.smackjeeves.com/comics/', u"Eliza Jones always had a dream of opening a cafe, but met a tragic fate before she ever could. Thus, the Caf\xe9 d'Alizee was opened in her honor. This story really isn't about her, though. Instead, this story follows the interesting, strange, and in some cases eccentric staff of the Cafe d'Alizee as they wander through the trials and tribulations of life. They may not know where they are going, but they have the four most important things in the world: love, life, coffee, and cake. *Updates every Monday and Thursday.* P.S. I should also mention that because this comic deals with the lives of various people, there may be situations that include relationships of any gender combination as well as violence or sexual situations, but there will be nothing graphic. So because they are (mostly) all adults, expect adult situations to occur. :)", False, False)
add('TheCavernofSecrets', 'http://cavern.smackjeeves.com/comics/', u'A webcomic about Pok\xe9mon and caves. ------------------ Updates on odd-numbered dates. (1, 3, 5, etc.) Pokemon is (c) Nintendo Rated T or PG-13 or whatever you kids call it these days. Contains: Blood, swearing, sexual references, etc. ------------------', False, True)
add('TheColony', 'http://thecolony.smackjeeves.com/comics/', u"In the secluded hills of upstate New York, there is a place known only to few. It is a haven for all things macabre; werewolves, vampires, zombies. If you fear it, chances are it resides there. Every 300 years, a new regent is crowned, and this time you're invited to the ceremony. The Colony is updated every Tuesday, so come on back!", True, True)
add('TheContract', 'http://the-contract.smackjeeves.com/comics/', u'After a series of dreams, Starken wakes up in another world. There he meets Phalarin, a demon who seems harmless.', False, True)
add('TheCrawl', 'http://www.thecrawlcomic.com/comics/', u'A fantasy comic about a unique prison.', False, True)
add('TheCurtandTonyShow', 'http://thecurtandtonyshow.smackjeeves.com/comics/', u'A collaborative episodic comic featuring old friends and new friends of the Curt and Tony universe. The comic was made by Squirreltastic-Blue, IamBlair and Alea respectively.', False, True)
add('TheDarkAgeofMobius', 'http://thedarkageofmobius.smackjeeves.com/comics/', u'It was 20 years ago that the Emerald war began. Many died. Sonic, and Eggman are but a few. There were, however, survivers. A mysterious overlord has taken over much of the world. There are those who oppose him. This is the story of one.', False, True)
add('TheDarkLegacy', 'http://tdlcomic.smackjeeves.com/comics/', u'', False, True)
add('TheDemonicAdventuresofAngelWitchPita', 'http://angelwitchpita.smackjeeves.com/comics/', u"The story of Angel Witch Pita is about a classically average, unspectacular young woman who comes across a book that, upon reading an incantation inside of it, releases dozens of monsters and incubi and succubi that had been sealed within it over a century ago. She is then contracted by a winged pig named Buhi, who claims that he is a cherub in training, to find those she's released and stop them from harming mankind. He empowers her with his halo, giving her an angelic appearance and the power to call upon an angel form. As her adventures progress, she collects an Incubus in child form named Jinx (who is really the leader of all of those from the book) and a Succubus named Beliel. She initially believes herself to be a type of magical girl, but the truth is far darker, and far deeper than she could ever imagine.", True, True)
add('TheDestroyer', 'http://heartless-destroyer.smackjeeves.com/comics/', u"A Shadow-cat demon named Kairo Ventaiga finds his solitude interrupted when he finds out his family isn't dead. However, he's gotten used to his deadly lifestyle and doesn't want to change... In a neighboring kingdom, Princess Nicole, a daughter of Light, doesn't want her father's crown. She is strangely sympathetic toward Shadow demons, her kind's mortal enemy. She's determined to befriend the Destroyer; perhaps she knows something Kairo doesn't... Reilyn Ventaiga only wants to find out what happened to his parents the night Kairo disappeared, but getting any answers out of his brother is looking more and more impossible... TakJak, a former thief, starts to notice that the Heartless Destroyer isn't as heartless as he seems... Updates: every Saturday with one or two pages Warning for minors: contains prevalent cursing, blood and gore, violence, and maaaybe farther down the line, partial nudity or hints at it. Also gay people. If you don't like any of the above, I'd advise against reading my comic.", True, True)
add('TheDragonandtheLemur', 'http://dal.smackjeeves.com/comics/', u'The Dragon and the Lemur is a web manga drawn by Vilani Vil\xe1 and scripted by the same and CherryVincent. In few words, a RP between the artist and CherryVincent, which Vilani decided to transform into a Manga. D.a.L (for short) tells us the story of two characters, Hakakku (a humanoid, hybrid between Cat and a Lemur) and Chain (a humanoid, dragon). They both met, probably not under the best circumstances and ended up falling in love. The script is currently finished. This comic contains explicit content and homosexual relationships. Bestiality/shota/incest may be often mentioned. May have blood and gore. NC-17 YAOI/HENTAI/YURI Update schedule: MONDAY Started: Sept 2005 Status: On going', True, True)
add('TheDreaming', 'http://thedreaming.smackjeeves.com/comics/', u"'The Dreaming' is a 3-volume mystery-horror series, published by TOKYOPOP from 2004-2007. It's written and drawn by me, and the story is about Amber and Jeanie, a pair of twin sisters who arrive at a mysterious boarding school deep in the Australian bush. Soon after, they start having strange dreams, and discover that there is a long history of students disappearing from the school, covered up by the vice-principal of the school. Just what is the vice-principal hiding? And can they unravel the mystery of 'The Dreaming' in time? IMPORTANT: I will be uploading half a chapter every Friday, but will only be uploading 2 volumes out of 3. If you want to finish reading the story, please purchase the third book (from the links on the bottom of each page.)", False, True)
add('TheDrifter', 'http://thedrifter.smackjeeves.com/comics/', u'Finding no other purpose in his life, a lone traveler drifts across the vast network of roads that line the continent. When he thought his journey would never meet an end, the traveler makes a stop at a small city in the tropical South coast. It is here he finds someone - a "sheep" in the midst of wolves. The drifter soon realizes his long journey has come to a close. --- Rated R for language, sexual content, and strong bloody violence. Updates weekly, sometimes faster. --- Inspirations for The Drifter include the works of Nicolas Winding Refn, 80s/90s America, and anthro characters in general.', True, True)
add('TheElectricRose', 'http://electricrosecomic.smackjeeves.com/comics/', u'What happens when three normal girls in high school are ripped straight out of their beds and brought to a completely different planet? Why, they\u2019re asked to save it, of course! Agreeing to become a Barrier Guardian could mean the lives of Elysia and her friends, but choosing not to could mean the end of their world. So what do they do? And will these three girls even survive long enough to decide?', False, True)
add('TheForestofWhispers', 'http://theforestofwhispers.smackjeeves.com/comics/', u'Kanna is a two year old she-wolf and member of the Whispers Pack. She like to run away from problems that are out of her control or hide behind someone. But this time, not even her best friend, Caleb a young wolf that seems to be in love with her, may no longer be able to save Kanna from the problems that are about to come. When a old and evil force is about to awake and just a shy and small wolf like Kanna has the power to stop it, everything will be lost? Or there will be a chance for salvation? UPDATES EVERY WEEKEND!', False, True)
add('TheGhostWithTheMost', 'http://theghostwiththemost.smackjeeves.com/comics/', u"A romance fan comic, based on the 1980's animated Beetlejuice series. Beetlejuice and Lydia were the best of friends. They did absolutely everything together and were always there for each other. So Beetlejuice never considered the idea that they would ever be separated. That is, until Lydia starts growing up and begins to call upon him less and less. Then, eventually cuts ties with him completely, leaving poor Beetlejuice lonely and confused. He remains loyal and waits for her call. 30 years later, Beetlejuice is suddenly called upon once more. But it's not his dear Lydia.... It's her daughter! But where is Lydia? Can Beetlejuice cope with why she stopped calling all those years ago? Will a romance bloom between Lydia's daughter and Beetlejuice? Find out! Read: The Ghost With The Most Updates Once a Week! ^_^", False, True)
add('TheGoldRiderofPern', 'http://goldrider.smackjeeves.com/comics/', u"I started this comic a little over a year ago, and it's been going strong ever since. Taking place in the 3rd pass of Pernese history, K'mlar, a young genius Masterweaver was placed at Ista Weyr as his first appointment after being given the station of Master. There he impresses a young Gold hatchling, an event completely unheard of in Pernese history. Despite being aggressively anti-social, he manages to make a place for himself at the Weyr that he never would have dreamed possible.", False, True)
add('TheGrayZone', 'http://thegrayzone.smackjeeves.com/comics/', u'A daily cartoon featuring the lives of extraterrestrial "grays"', False, True)
add('TheHeadhunters', 'http://headhunters.smackjeeves.com/comics/', u"It's about people trying to capture a floating head. Every Mondays, Wednesdays and Saturdays.", False, True)
add('TheHeartofEarth', 'http://heart-of-earth.smackjeeves.com/comics/', u'World is on the edge of war. Two factions will fight, until one of them perish from the earth.Only one hero can stop the destruction of the world.', False, True)
add('TheHobbitbic', 'http://hobbit.smackjeeves.com/comics/', u"This is not a comic. It's a profusely illustrated novel... may be a Graphic Novel. The Hobbit, from J.R.R. Tolkien drawn with a blue biro. I hope you enjoy it.", False, True)
add('TheJosephComics', 'http://josephcomics.smackjeeves.com/comics/', u'What started out as "Joseph and His Comics" in 2003 became the first minimal comic strip series by amateur cartoonist Joseph Scarbrough. The comic centered around fifteen-year-old Joseph Armstrong - just you\'re typical, average, American teenager who just so happens to get himself in and out of random situations that give way to continuing storylines with serial cliffhangers much like the old "Rocky and Bullwinkle" show (which adopted said format from old movies and westerns of the 50s). In 2004, Scarbrough "revamped" the comic strips, renamed it to simply "Joseph Comics" which carried on until Scarbrough announced his retiring from comic strips, thus making Joseph and his friends find their place in the Old Cartoon Stars Retirement Home permanently come 2008.', False, True)
add('TheKeyHotelEnding', 'http://tekeyhotel.smackjeeves.com/comics/', u'Alright, the Key was fun while it lasted, but due to a lack of updates and interaction, I must shut down the Key Hotel. It now belongs to SteamingBullets Uboa. See ya!', False, True)
add('TheKeyToReality', 'http://keytoreality.smackjeeves.com/comics/', u'A comedy horror comic about three walking cuteness generators and their adventures in a universe inhabited by ghosts ^_^ Also on deviantart: http://maryyana.deviantart.com/ Updates daily, most of the time. Warning for gore, blood and other adorable things.', False, True)
add('TheKwiddexProtocol', 'http://kwiddexprotocol.smackjeeves.com/comics/', u'Welcome to Satellite Falls. Starstorm has returned after a 15-year absence. So has the White Rose. Plus there\'s a monster tearing up the city. Now, it\'s up to disgraced cop Jerry Binder to find out just what the hell is going on in his city and just what the hell "The Kwiddex Protocol" means. The Kwiddex Protocol is updated every Monday, so come on back!', False, False)
add('TheLastBloodCafe', 'http://lastbloodcafe.smackjeeves.com/comics/', u'The day to day adventures inside the Last Blood Cafe: A small coffee shop situated on the shores of the river Styx. Their mission? To provide a final opportunity of mortal comforts and hospitality before the inevitable journey to the final resting place. Though the cafe itself is rumored to be haunted...', False, True)
add('TheLegendaryQueen', 'http://legendaryqueen.smackjeeves.com/comics/', u"Being drawn, then written out, this comic is about my character Crystal, a normal 15-year old hedgehog who soon finds out she's worth much more than she ever believed she could be. There will be love, fighting, death..friendship..and above all else, family and self importance. Journey along with her, as she becomes what everyone has been waiting for...and stays true to herself! Updates: Whenever I get pages drawn XD", True, True)
add('TheLifeofMagFlamequill', 'http://lifeofmag.smackjeeves.com/comics/', u"The coming of age ceremony is tomorrow. Participants will take their birth-feathers and soar gracefully into the sky, cheered on by their proud friends and relatives. But what if you're Mag Flamequill, the bird-woman with a fear of heights?", False, True)
add('TheLoneSwordsman', 'http://theloneswordsman.smackjeeves.com/comics/', u"Heaven has fallen, including its Leader, Aven, thanks to the Demon King Shutendoji's new Elite Demons. Now Shutendoji has his eyes set on Earth. Can a Lone Swordsman wielding Aven's sword stand a chance against such hopeless odds? Or will the madness of the souls he must absorb destroy him from the inside? Rated PG-13 due to cartoon violence, blood and mild language. The Lone Swordsman and all related subsidiaries are property of Sol's Dawning Creations. The use of such without permission for the purpose of monetary gain is illegal and will be met with legal action.", False, True)
add('TheLostland', 'http://thelostlandcomic.smackjeeves.com/comics/', u'"It all starts with some dubious info, a misunderstanding, and a well-known incident that sets a chain of events in motion..." The adventures of four travelers unknowingly wrapped up in a chain of events, all leading to one man\'s plot to turn the world on it\'s head. Action, laughs, and mystery all packed into one Post-Apoc world. Updates Every Wednesday & Saturday! --- Also available on: INKBLAZERS http://www.inkblazers.com/manga-and-comics/The-Lostland/detail-page/1344?lang=en', False, True)
add('TheMegaManandSonicSpriteShowcase', 'http://megamanshowcase.smackjeeves.com/comics/', u"Credit to all the authors listed for the sprites. We do 8 bit, 16, bit and 32 bit sprites (mostly 8 bit) and Sonic sprites. WE TAKE REQUESTS. no trolling, flaming, cussing (some allowed) and ABSOLUTELY NO STEALING SPRITES AND DON'T CLAIM ANY AS YOUR OWN, unless you actually made them and your part of this showcase. *One new rule: I would like to address the fact that THIS IS NO LONGER A SHOWCASE WHERE WE POST RESOURCE SPRITES OR SPRITES WE DIDN'T MAKE! I'm gonna remove the sheets that aren't ours soon. any body else that posts anything that isn't theirs will be punished, if caught, with the following: 1st offense: a warning. 2nd offense: comment privilege taken away. 3rd offense: uploading privilege taken away Anything past the third offense will result in removal from this comic.", False, True)
add('TheMewExperiment', 'http://themewexperiment.smackjeeves.com/comics/', u'A Tokyo Mew Mew spinoff about a genetically engineered mew and her fight for freedom against the aliens hired for the sole purpose of her capture. However, an accident robbed her of her memories and she must relearn her forgotten powers in order to survive. The comic is for practice, so please ignore the bad art! (Especially in the first two chapters.) Also, you do not need to be familiar with the series Tokyo Mew Mew whatsoever to read! Because college is college I am only updating during breaks (every thursday)!', False, True)
add('TheMoistTouch', 'http://themoisttouch.smackjeeves.com/comics/', u'VERY GOOD SMUT WEBCOMIC YOU SHOULD READ IT ITS GOOD 10/10 NO YAOI ONLY HENTAI', False, True)
add('TheNOMEDSEGA', 'http://nomed.smackjeeves.com/comics/', u"Join Commander Scunt Fishing and his friends Max and Saladass as they travel the stars trying to do something or something. Updates weekdays, if it's drawn. Sister Comic: Asinine Pitfrogs by PotatoMasterlord! http://assfrogs.smackjeeves.com/ Darion Paone says (9:21 PM) dude this is worse than tits DOCTAH JIM says (9:21 PM) i thought you liked tits Darion Paone says (9:21 PM) you don't DOCTAH JIM says (9:21 PM) fair enough", False, True)
add('TheNightSurfers', 'http://thenightsurfers.smackjeeves.com/comics/', u'When the coastal city of Costa Nueva is threatened by sand creatures sent by a mysterious evil, four teenagers rise from tragedy to become heroes. They are The Night Surfers. Read it here at Smack Jeeves, or get even more content and the most recent updates at: http://thenightsurfers.com! If you have a few extra dollars and wanna help out, check out my Patreon profile: http://www.patreon.com/thenightsurfers', False, True)
add('TheNocheComicSeries', 'http://nochecomicseries.smackjeeves.com/comics/', u'A story about a girl named Noche who has memory loss and is trying to figure out who she is. ------------------------------- Other sites you can read Noche on. Deviantart - http://theinfamousjoelinder.deviantart.com/gallery/39987883 ComicFury - http://nochecomicseries.thecomicseries.com/comics/first Manga Magazine - http://www.mangamagazine.net/read-manga/The-Noche-Comic-Series/3516/0/0?lang=en SmackJeeves - http://www.smackjeeves.com/comicprofile.php?id=133439 Facebook Fanpage - https://www.facebook.com/NocheComicSeries/photos_albums Tumblr - http://nochecomicseries.tumblr.com/ Youtube - https://www.youtube.com/playlist?list=PLyFWACvwp02kK2MXUwrtfEdkZRVUjE6zJ', True, True)
add('ThePirateBalthasar', 'http://thepiratebalthasar.smackjeeves.com/comics/', u'Wilson Kane wins a fortune and his future bride at a game of dice from the former pirate Balthasar. When he decides to go and get the girl, the pirate way, by kidnapping her, not only he finds out that she is more than a pirate could ever want from a wife... but that she has 4 identical sisters as well. This discovery hits him when his men, who were supposed to help him out, each kidnaps a different girl... and none of them gets the right one! But Wilson Kane wants the girl he had met and no one else! Luckily for him it will be the girl herself to solve his problem and put an end to his dilemma... a solution that will eventually fling her into a new way of life, aboard the Alidivento, across the Mediterranea sea!', False, False)
add('ThePremise', 'http://thepremise.smackjeeves.com/comics/', u'The Premise is a story about moral contradictions and ethical dilemmas. Conflicts that arise when two policemen discover a criminal gang, commonly known as \u201cThe Executioners Sect\u201d, which would be hiding something much bigger: a group that has claimed for itself the power to enforce justice through a horrible method.', False, True)
add('ThePrincessandtheGiant', 'http://princess.smackjeeves.com/comics/', u'A silent fairytale about a young princess and another, rather larger individual. Updates Sundays.', False, True)
add('ThePropertyofHate', 'http://tpoh.smackjeeves.com/comics/', u'A voyage.', False, True)
add('TheRandomObscureFairyTaleNoOnesEverReallyHeardOf', 'http://tro.smackjeeves.com/comics/', u"Yeah, so I ran out of characters for the title. Trust the banner. 12-year-old girl Wolfgang Rock manages to convince her mom to let her stay with her ex-uncle-in-law-in-law instead of having to move. Soon enough, however, the said uncle, Dieter Jung, starts to have an innocent crush on the girl... This was the first full-length comic I ever did. Don't mind the amateur art and the fact that its unrealistic story could only be written by a child (indeed it was) and the JPEG fuzziness and and and... *COMPLETED! *Reads left to right *Not suitable for impressionable young girls/adult men with developing complexes *Nothing inherently inappropriate, either *The original comic before He Who Has Partners, which apparently takes place in an alternate universe", False, False)
add('TheReborn', 'http://reborn.smackjeeves.com/comics/', u'Every teenage girl looks forward to her sixteenth birthday, and Angela is no exception. But on that day her life turns upside. Angela learns a stunning secret about herself, and finds herself caught up in war between two demon clans. Updated Mondays! This comic may not be suitable for younger readers. It may contain violence, gore, occasional bad language and other stuff that may not be appropiate for readers under 13.', False, False)
add('TheSearchforHenryJekyll', 'http://thesearchforhenryjekyll.smackjeeves.com/comics/', u'London, 1891: While the police are tangled in the recent line of murders, it may be up to Doctor Henry Jekyll and his mysterious companion to close the case. But when the clues start to point towards old friends, will the good doctor be able to get out alive?', False, True)
add('TheSilverLeague', 'http://thesilverleague.smackjeeves.com/comics/', u'The Silver League is a comic based around the members of the site of the same name and placing them in our own interpretation of the Pokemon World. Silver August of Harvestone Town is a teen that never really knew life outside his hometown; however after rescuing his Sister from the hands of Team Reaction, Silver becomes motivated to explore the world as a Pok\xc3\xa9mon Trainer! However on his journey, Silver discovers that behind the battles he\'d watch on TV lies corruption because of devices known as "Modifiers" that allow a Trainer to alter a Pokemon\'s stats by force without having to earn them through training. This leads Silver and the friends he makes along the way to form "The Silver League Movement" which vows to travel the region, collecting badges but also recruiting Gym Leaders and convincing them to join their cause so that they can form a league of their own, take down the Team Reaction organization and bring honour, fun and hard work back to Pokemon Battles! http://www.thesilverleague.com/', False, True)
add('TheSomewhereOther', 'http://somewhere-other.smackjeeves.com/comics/', u'Who would have thought fitting into such a weird world would be so hard.', False, True)
add('TheSummerofBlakeSinclair', 'http://blake-sinclair.smackjeeves.com/comics/', u"A slice of life comic set in the summer of a student's university life. about hipsters, Punks, and ultimately self reflection and 'honesty'. This comic is Apparently what you would call a 'social comedy' and a sattire on generation Y. loosely based on my recently passed student experiences =) Hopefuly this comic will remind you of summer when you read it; enjoy!", False, True)
add('TheTimeDog', 'http://timedog.smackjeeves.com/comics/', u'Ayaka travels through time with "the time-dog". A strange and weird story :)', False, True)
add('TheTytonNuzlockeChallengeEmeraldEdition', 'http://tytonnuzlockeemerald.smackjeeves.com/comics/', u"Kids, I'm going to tell you a story. The story of how I... no, wait. Sorry. Welcome to the Tyton Nuzlocke Challenge, a character-driven graphic novel created entirely in Microsoft Paint. It updates daily, including weekends, holidays, and apocalypses (apocalypsi?). In a world overrun with eager trainers, the Pokemon Administration has taken desperate measures to ensure the remaining wild Pokemon survive, while allowing trainers to continue their paths. This has resulted in the limiting of catching wild Pokemon, the banning of certain items, and finally--the closing of Pokemon Resurrection Stations in all Pokemon Centers. Enter Tyton. He's thirteen and has less than a year to get all the way to the Pokemon League. Join him and his team as they follow the road to the Elite Four, get wrapped up in the schemes of Teams Aqua and Magma, and (possibly) uncover the mystery of Scott the poofy-haired stalker. There's also a Latin ladies' man Lombre, a swagalicious Gloom, a Numel that hates everyone he's ever met, a firecracker of a Whismur, and the most lovable Dustox you've ever seen. But we'll get to that.", False, False)
add('TheWastelands', 'http://wastelands.smackjeeves.com/comics/', u'A world abandoned by its Gods and the people who find out why. Did they really abandon their people? Updated Sundays here. ** http://wastelands.inkblazers.com **', False, True)
add('TheWhiteTower', 'http://thewhitetower.smackjeeves.com/comics/', u'Cotton has no memory of who he is. He just woke up from a seven month coma. His hair is completely gone. And no one is telling him anything. A sci-fi/mystery/drama comic. Warning: partial nudity, some violence and cursing.', False, True)
add('TheWinterCampaign', 'http://winterc.smackjeeves.com/comics/', u'Japan, 1919. 16-year-old Akio and his mother move into a new home with the mysterious Kikugawa family: A secretive father, a fragile and reclusive son, and the shadow of a mother whose death years ago may be more than it appears. The lines between truth and fantasy, and friend and enemy begin to blur as winter sets in... Drama/Historical/Coming-Of-Age/Romance? Updates once or twice a week.', False, True)
add('TheYoshiHerd', 'http://theyoshiherd.smackjeeves.com/comics/', u"A comic about a young Yoshi, and his efforts to become a hero. To evolve, become something more than he was meant to be; little does he know, more people than he alone depend on this. I swear, it's better than it sounds. Not by a LOT but it IS. The Yoshi Herd. Wish I could say it's updated weekly - so I decided to start updating weekly! Every F\u034f\u032a\u0356\u0339\u032c\u0359\u0329\u034dr\u0328i\u0334\u0356\u0325\u033bd\u0323\u0345\u0324\u0339\u033b\u0355\u031fa\u0338\u0317y\u032a\u0354\u0348, usually late at night - Australian time anyway - point is, there's roughly a six hour window every F\u035fr\u0352\u030f\u0301\u0305\u0341i\u0338d\u034ba\u0311\u0303\u036d\u0300\u031a\u034a\u0341y\u030a\u030e\u0302\u0321 where you might see it pop up. But, uh, keep it on the down-low. People might start EXPECTING it to update. As if it was MAKING A COMEBACK or something. So this? This is between you, and me. If you tell anyone - look, just don't tell anyone. You don't wanna know, capiche?", False, True)
add('Theatrics', 'http://theatrics.smackjeeves.com/comics/', u'A weekly movie review comic, starring two ruthless critics who will bash a different cinematic release, both new blockbusters and obscure classics, every week. By Itamar Katz', False, True)
add('ThehumanBEing', 'http://thehumanbeing.smackjeeves.com/comics/', u'"A story about friends and enemies; love and hate; forgiving and forgetting; holding on and letting go. A story about being human, and being MORE..." Follow the story of ten friends as they survive college, friendship, love, and life in general. No matter who we are, what we know, or what we believe, we are all HUMAN. Updates: Tuesdays Reads left to right', False, False)
add('TheiaMania', 'http://theia-mania.smackjeeves.com/comics/', u"My own take on Greek mythology. Join Hermes, Hades, Persephone, Athena and the others as they try to deal with themselves, their complicated family and those strange humans. NEKYIA: A journey down to the Underworld. A philosopher and a necromantic priestess enter Hades' realm to find the answer to the question what a good life really is. At the same time, the messenger god Hermes arrives with a message to Hades... DADDY'S GIRL: Athena is miraculously born from her father's head. She's stronger and more intelligent than most people, but deep down she is just a confused child who tries to understand herself, her family and the world around her. This story takes place long before the events in NEKYIA. HERO BONES: A short story about Hermes, love and fossils. Has some mature content, but nothing too explicit. Takes place after NEKYIA DESTROYER OF LIGHT: Tells the story of Persephone and her life with her mother, the harvest goddess Demeter, before she became the queen of the Underworld. Snakes, flowers and dark secrets. Has some mature content. Updates usually once a week.", False, True)
add('ThelaughingDeath', 'http://thelaughingdeath.smackjeeves.com/comics/', u'When Leyr was a little boy, he was taken from the head of the business organisation "Light" - River, who forms him for purposes of the organization to a perfect assassin. But for many reasons, with the passing years, members of the organization get more and more terrified of Leyr. In the end, they decide to kill him ... "Please read from right to left! ^^"', False, True)
add('Themadman', 'http://themadman.smackjeeves.com/comics/', u'everyday insanity, taking what life throws at you and lets imagination run wild^^ updates most likely mondays', False, True)
add('Theswordsmanandtheamnesiac', 'http://tsata.smackjeeves.com/comics/', u'a comic by earthan black and padmini black. updates monday, wednesday, friday Two unrelated stories become one when strangers become friends. One follows a dream while the other flees a nightmare across the haunted land.', True, True)
add('ThiefCatcherRingTail', 'http://tcringtail.smackjeeves.com/comics/', u"RingTail is the hero name of the main character, Lynia, who is actually formally a thief! After her family is arrested she is hired by her rich, genius classmate Rose to test out her superhero inventions. Together, they stop thieves and uncover the sinister plot of Arcadio, Lynia's former employer. This comic reads Left to Right.", False, True)
add('ThinkBeforeYouThink', 'http://thinkbeforeyouthink.smackjeeves.com/comics/', u'A funny, awkward, and spontaneous comic about a guy who can read minds. Updates Fridays.', False, True)
add('ThornTopia', 'http://tnt100.smackjeeves.com/comics/', u"Thorn is reknown for her alts. This a showcase of all the ones she's got! This series is now completed! Many thanks to all the contributors and followers for sticking around!", False, True)
add('ThornsComic', 'http://thornscomic.smackjeeves.com/comics/', u"Isabella's life changes when she meets a centuries-old cursed vagabond prince from another world. Suddenly she is pulled into the curse and demons that control his life. Will she believe in the truth of fairy tales in time to help him? Updates every Sunday. Thorns updates a page ahead on it's original website www.thornscomic.com", False, True)
add('ThroughtheWonkyEye', 'http://through-the-wonky-eye.smackjeeves.com/comics/', u'Going through life changing events, a young man named, Howard Ale, was the famous contortionist: "The Rubber Band Man" from the Hanna Berry Circus. With all his success and fame going to the top why did he mysteriously quit?', False, True)
add('TitleUnrelated', 'http://www.titleunrelated.com/comics/', u'Title Unrelated is a story of family, love, friendship, and identity. An odd family travels to another world in search of their missing sister, but things are not as simple as they hope... Updates Mondays and alternate Fridays.', False, True)
add('TosiHuonoYaoiSarjis', 'http://tosihuonoyaoisarjis.smackjeeves.com/comics/', u'T\xe4m\xe4 on tosi huono Yaoi sarjis, jumalauta se on PASKA oikeesti hyv\xe4 is\xe4 \xe4l\xe4k\xe4\xe4 ny lukeko t\xe4t\xe4 kauhiaa mit\xe4 kuraa ja sontaa t\xe4m\xe4 on eik\xe4! In english: Adin is a young art student who has just broken up with his boyfriend... Suddenly he meets a mysterious guy who helps him out... Where does this situation end up in? UPDATES EVERY DAY!', True, True)
add('TotalPokemonIsland', 'http://tpi.smackjeeves.com/comics/', u"Welcome t'Total Pokemon Island, where 15 teens are gonna rough it out. Watch alliances be made, frienships tested, and a bunch'a other crazy stuff! Not really looking for any co-authors unless I ask you.", False, True)
add('TotallyCrossover', 'http://totallycrossover.smackjeeves.com/comics/', u'There are a lot of typical generic gaming webcomics out there. This one, however, is not one of them. Where most comics are fully happy to parody the gaming world one game at a time, Totally Crossover will parody them all. At the same time. The gaming stars of 2010 unite to face an unknown enemy which could destroy all of time and space itself. This should be fun.', False, True)
add('TrainerWantstoFight', 'http://twtf.smackjeeves.com/comics/', u'Yet another Pokemon webcomic. Updates Tuesdays and Thursdays.', False, True)
add('TransUMan', 'http://transuman.smackjeeves.com/comics/', u'Mutants. Aliens and Zombies, Oh My! It starts simply enough: another day of survival. But then...', True, True)
add('Transfusions', 'http://transfusions.smackjeeves.com/comics/', u"Transfusions is a BL (boylove) webcomic. It's a story about young media student Dylan and vampire Joa, who died in the 80's. Despite the rough start with threatening and snarking their relationship will develop from cute awkwardness to a beautiful romance. For now the comic is SFW, but there will later be some Adult content. When the time comes it will be mentioned beforehand and the pages with adult content will be marked.", False, True)
add('TrillyAndSilly', 'http://trillysilly.smackjeeves.com/comics/', u"This usefull story written by Cynthia and Debby alias Silerna(Silly) and Trilly for those who could use a little edge. Follow their daily shabbies and meet lots of new strange creatures. Give their furry companion and Cynthia's best friend Kitty a big hug and she shall teach you the important things in life as well! Each chapter includes a few short-comic stories that you will enjoy! Seriously... don't try this at home alright ? ~ This comic reads from left to right.", False, True)
add('Troublenextdoor', 'http://troublenextdoor.smackjeeves.com/comics/', u"Ilona hates her new neighbor! Sure he might be a tall, athletic, motorcycle-riding hot model kind of a guy but he's snarky and rude. Just like the jocks in school that used to make fun of Ilona because she was a nerdy tomboy girl. And did he say something about Ilona's panties?! This means war! Ilona wants him gone, right now! Because he's a horrible person...but wait, he actually has a kind side? ...and how come he's always helping her out when she's in a pinch? this is...(you guessed it!) a BOYxGIRL romance sprinkled with a lot of humor and a few tearjerking moments. Hand-drawn, scanned and screentoned.", False, True)
add('UglyBoysLove', 'http://shounenai.smackjeeves.com/comics/', u'', False, True)
add('Uglygame', 'http://uglygame.smackjeeves.com/comics/', u'so takumis had a crush on his teacher mr. asakura (who he lovingly calls sensei) for a long time now, but there are these dumb games that the girls play to see who can get a specific teacher to fall in love with them first, then dump them afterwards. and asakura\u2019s next in the game. not only that, but this kid satoru, whos always bullying takumi, is getting in on the game too and according to everyone hes in the lead. takumi knows what a little shit satoru is and doesn\u2019t want sensei to get hurt, and basically gets tricked into playing the game too. now hes gotta get sensei to fall in love with him before its too late. plots based off scramble game (it made me so mad I thought I could do it better HA) reads from left to right bl/yaoi will have nasty stuff later on~~', False, True)
add('UndertheDeadSkies', 'http://underthedeadskies.thewebcomic.com/comics/', u'Bethany had everything you could ask for. A condo that was (almost) paid off, a well paying job, and most importantly, a family. It all changed in a heart beat and she had to watch as her whole world crumbled around her and soon she found herself alone in a city of flesh-eating zombies. Despite the overwhelming odds against her, Beth has managed to do what very few people have been able to do in this post-apocalyptic nation. She has survived. However, after coming across a young man with an unexpected trait, she finds herself torn between staying in the comfort and safety of her current routine or risking it all for the greater good of humanity.', True, True)
add('UnicampaLapis', 'http://ual.smackjeeves.com/comics/', u'A vida universitaria transformada em manga!', False, True)
add('UpDown', 'http://updown.smackjeeves.com/comics/', u"Eidi is a police officer working in Sunshine City. Being paid less than minimum wage and living in a shabby room with his crabby roommate and partner, Levi, makes life pretty tough for him. On the surface, the world they live in doesn't sound too bad. The city seems quite prosperous, with many MANY skyscrapers and industrial sites. It seems to be a pretty peaceful but loud and fun city. The taxes are low, there's freedom everywhere, very few people are homeless and poor. But if everyone in the world is happy, then it doesn't quite balance out. Underneath the surface, the city is filled with smuggling, murder, and various fights break out in the underground slums. The burden shifts to the police officers, who by law is ordered to make sure the surface of the city is crimeless and keep the two worlds separated. This peace can not last forever. BL/no actual porno Has a main story and some romance bits Not all characters are gay/not every character will have a relationship/if they are in a relationship just because it's BL doesn't mean it's super romantic/ etc etc Updates: Whenever", True, True)
add('UshalaatWorldsEnd', 'http://ushala.smackjeeves.com/comics/', u'Exiled from her tribe for being the reincarnation of their most hated enemy, Ushala wanders a fantastic world in search of answers and redemption. Follow her, the Carrion Wraith Kivar, and the storyteller Cor on a quest to right the wrongs of one ill-lived life.', True, True)
add('VACANT', 'http://vacant.smackjeeves.com/comics/', u'VACANT is a science fiction web comic following Commander Hayze, an agent of "The Eye" a powerful alien government/ corporate agency. Sent on a seemingly simple rescue mission, Hayze stumbles upon a possible explanation for the near extermination of the human race that had taken place over 100 years prior. His only lead is a virus and, along with his crew, Hayze tries to find the cure. Look at official site here: http://www.imaginetheending.net/Vacant.html VACANT also has a Etsy: http://www.etsy.com/shop/ImagineTheEnding?ref=si_shop tumblr: http://vacantcomic.tumblr.com/ twitter: https://twitter.com/VacantComic or Facebook: http://www.facebook.com/pages/Vacant/161911700538775', False, True)
add('Vacan7', 'http://vacan7.smackjeeves.com/comics/', u"Django is living with his younger brother in the heart of the big city named Los Perdidos. He's been stuck in a limbo between being a policeman and being a detective for a while now, and he finds himself falling for his new trainer and partner. On top of that Django starts to see and hear things others can't, and hopes his odd behaviour won't get him in trouble. Six voices seek the seventh, Django. Are they here to help or harm him? Updates Thursdays. Contains m/m. Mature: Occasional swearing and half naked dudes.", True, True)
add('VampireFetish', 'http://vampire-fetish.smackjeeves.com/comics/', u'A crossdressing vampire hunter takes on compulsive vampires in modern London, all the while trying to break into the writing business using the name of the girl he was accused of murdering. Join Jude Hawthorne -- amateur writer, professional vampire hunter! COMEDY - HORROR - ACTION - MYSTERY YA Graphic Novel: Urban Fantasy ----------------------- Read full chapters online monthly @ Manga Magazine Online! http://www.mangamagazine.net loomcomics.com', False, True)
add('VerloreGeleentheid', 'http://verlore.thewebcomic.com/comics/', u'"Verlore Geleentheid" is \'n wetenskapfiksie strokiesprent wat hom deur van die ouer wetenskapfiksie soos "All the Way Back" (Michael Shaara) en "Die Oorlewendes" en "Ruimteskip Celeste" (albei deur Johan Bredell) laat inspireer. "Lost Opportunity" is a sci-fi webcomic which is inspired by older SF like "All the Way Back" (Michael Shaara) and "The Survivors" and "Spaceship Celeste" (both by Johan Bredell). It is in Afrikaans. The English version is here: http://lost-opportunity.thewebcomic.com/', False, True)
add('VoidMisadventures', 'http://voidmisadventures.smackjeeves.com/comics/', u"Quotes ------------------------------------------------------- Alexini: GAAAH! SPARK! Y U TOOK MAH BUCKET?!?!?!?! :C \\_/ Burey: By the name of Daucaus, I shall EAT those cookies! Carbon: i'm hardcore Dry: HYPER-NOVA SAYO-NARA SUCK-AAAAAAAAAA Firekitty: Meow. *coughs up burning hairball onto something flammable* Gigi: You've gotta tell me when you turn on the mic, ok? Wait, it's already on?! HOW COUL- Jason: cavestorycavestorycavestorycavestorycavestorycaoeocirvgiarbvrsvoefssr S Spark: *gets burning hairball coughed onto hair* AAAAAAAAAAAAAAAAAAAHHHH *grabs Alexini's bucket and pours it on self* Tater: :( Ryan: What's that? You want an explanation? Well too bad! ------------------------------------------------------- Skype Chat: Add firecat1311 on skype and we can see how it works from there. Most of us are there every day, and some amount of activity is expected from everyone, so keep that in mind.", False, True)
add('VoyageoftheBrokenPromise', 'http://voyageofthebrokenpromise.smackjeeves.com/comics/', u'The pirate crew of the mysterious starship Broken Promise seek revenge on a corrupt Admiral who ordered the destruction of a defenseless agricultural colony. Space pirates, aliens, princesses and valiant captains ply the space lanes in this epic journey! ****Mature Content****** Nudity and erotic content.', True, True)
add('WHATaboutSHADOWS', 'http://was.smackjeeves.com/comics/', u'Charlie is a relatively normal teenage boy, who enjoys hunting supernatural creatures with his homemade "ghost-tracking-device" in his spare time. One day he meets a strange man, who has lost his cane. Charlie then decides to help the man find it, which was probably the worst decision he ever made. Updates Mondays (or Tuesday sometimes whoops).', False, True)
add('WakeEcho', 'http://echo.smackjeeves.com/comics/', u'After an encounter with a soul-stealing shadow, Arial sets off on a journey to reclaim what he has lost. However, his task is much more complicated than he bargains for, and he quickly begins to learn the consequences of wandering into the dark...', False, True)
add('Wander', 'http://wander.smackjeeves.com/comics/', u"Three young ladies meet each other through circumstances absurd and unavoidable. Friendship formed (despite any attempts to prevent it) they wander through their world, traveling to new places and having adventures. Piper has to avenge her ex girlfriend's broken heart. Arilsden has to seek out her own path, not follow her family's footsteps. Fantz wants this itch on her butt to go away. Updates Mondays and Thursdays.", False, True)
add('WantedDeadorDead', 'http://wanteddeadordead.smackjeeves.com/comics/', u'Two greedy undead bandits cause havoc in the wild west until one day a misterious little girl in a weird outfit hires them in order to help her father. Demons, monsters and wild west action! Beware of violence and foul language. Read L-->R Updates: Wednesday and Friday. Comment plz! :3', False, True)
add('Wayfar', 'http://wayfar.smackjeeves.com/comics/', u'In the middle of nowhere, surrounded by a really big wall, rests Hometown. Here, the metal faced Teks rule and act as a constant reminder of the people\u2019s place in the world \u2013 in town and without question. Be efficient, productive and avoid wasting time and mind on trivialities. Under the two suns, in an out-of-the-way part of town, two friends are content making art.', False, True)
add('Waysoftheheart', 'http://wayoftheheart.smackjeeves.com/comics/', u'"Fate is destined for one fennec when he bumps into a raccoon one morning. Theyd fall in love, and eventually become mates. But shes not the only one fighting for the young fennecs heart."', False, True)
add('WeAreGolden', 'http://wearegolden.smackjeeves.com/comics/', u'"We are not what you think we are, we are golden" (Mika, We are Golden 2009) A story of self-discovery, sexuality and relationships. When Olivia Barclay was forced to move from her high class private school to a scummy comprehensive it felt like the end of the world. But it was only the beginning... (God, anyone want some wine with that cheese? I\'m really no good at taglines!) Warning: contains examples of British humour. If there\'s any slang you don\'t understand, just ask :) Also, yaoi, yuri, het and any other kind of relationships you can think of. Updated Wednesday and Sunday. Mostly.', True, True)
add('WelcometoFreakshow', 'http://welcometofreakshow.smackjeeves.com/comics/', u'The audience roars, the acrobats and performers provide them with a spectacle unrivaled in all of Europe. The lights die, and the audience is now the entertainment for the apathetic circus. As blood and bone rush to the surface, one man leads the troupe downward to the darkest ring of all. Welcome to the Freakshow. //Updates Every Friday//', False, False)
add('WelcometothePCA', 'http://welcometothepca.smackjeeves.com/comics/', u'Pokemon Combat Academy - where fighting is your schoolwork! Timid little Cyndaquil Hirohiko Rangoku has to square off against a monster of a delinquent for his Combat mid-terms! Not only must he conquer his fears, he must also contend with a little battlefield drama, too! Loosely based off the FurAffinity/DeviantArt art-and-RP community of the same name.', False, True)
add('WhatAboutLove', 'http://whataboutlove.smackjeeves.com/comics/', u"Takao has had a secret crush on his classmate, Hisoka, since he first entered high school. Now it's Takao's last year and he figures it's now or never so he does the crazy thing and confesses. Much to his surprise, Hisoka agrees to be his boyfriend. Takao is in pure bliss... until he realizes Hisoka has different aims. While Takao wants an actual relationship all Hisoka seems to be interested in is, well, physical stuff. So now Takao has to figure out a way to make Hisoka see him in a different way, but that's not easy since other men (realizing Hisoka goes that way) have taken an interest. Can Takao fend off potential rivals and get the guy he loves to love him back while facing all the other drama that comes with high school? Probably not, but that won't stop him from trying! Warning: - This is a Yaoi comic. I think that should be self-explanatory, but that means man on man action.", True, True)
add('Whatisdeepinonesheart', 'http://ones-mindt.smackjeeves.com/comics/', u'loosely translated: " inner feelings /what is deep in one\'s heart" The one that devoured the Eceshion bible holds the source to the worlds survival; Those who are being destroyed and those who are now conquering. Take heed that the one who devoured such a powerful book needs to know how to control it or it will cause destruction to all living beings. Claim it as your own, but don\'t let it sit forever unclaimed, for in the end one must decide what is more important, the ones close to you, our survival or the one we are omitted to care for. contains: boys love, cross dressing, monsters,vampires, animal people all around dementedness. NOTES: (Posting because it is a collaborative comic with Dani) 1. the comic was drawn back in 2009, so the art is a bit wonky till it catches up 2. The comic content does contain yaoi, However, due to smack jeeves rules and regulations: that content WILL NOT be seen on this site. The yaoi version of the comic in full will be seen on a Tumblr. this version is the version that contains black out pages and currently redrawn to contain version without Yaoi. 3. posting will be daily till it\'s caught up to the latest page: 1 page a day.', False, True)
add('WhenSheWasBad', 'http://whenshewasbad.smackjeeves.com/comics/', u'For every story about a hero, there is a "bad guy". Only, this story isn\'t about the hero. It\'s about the smart-alec, tough-as-nails villain. About her fights, her triumphs, her losses, her lackeys... And maybe her love life. If she can ever get the guts to ask the girl of her dreams out. (contains mostly yuri/GL and a bit of background het...Beware of foul language. It\'s mostly rated "mature" for violence and cursing. Sort of like an extremely f-d up reverse version of a magical girl story.) Read L->R, western style. **Updates Tuesdays and Fridays, currently.** Sidenote... This comic is not for horny guys hoping to see "HOTT LESBO ACTION ZOMG!!!11ONE" Yes, the main character happens to be a lesbian. But this story is about the plot, not "porn".', False, True)
add('Whenweweresilent', 'http://silence.smackjeeves.com/comics/', u'Two girls with different pasts, problems and ambitions - one future and one friendship.', False, False)
add('WhereaboutsOfTime', 'http://wot.smackjeeves.com/comics/', u"Inuyasha (c) Rumiko Takahashi Kagome Chronicles-Whereabouts of Time(c) matsujun4me aka Catherine Fermin Sukujou & Renkayasha(c) matsujun4me So this is my story: Whereabouts of Time or WOT for short. The full name is really long: Kagome Chronicles-Whereabouts of Time. I forgot to write the date I actually started this, but I believe that it was in June 09, 2009. This is actually the first comic that I post to the public. I've done others but they're old works. So this is more practice for the future. This is a story more based on Kagome and her adventures three years after defeating Naraku. I don't write much of the story itself here cause once you see the first page, you'll see the description. Enjoy!", False, True)
add('WhiteHeart', 'http://whiteheart.smackjeeves.com/comics/', u'"Lady Love received a magical book of the dark powers to her hands, and summoned a great, divine spirit. The spirit promises that Lady can make one wish, if she catches all the eight special albino souls and brings them to the spirit. Greedy Lady accepts the mission, and so the bloody collecting of albino humans begin... White is a tough and intense young man from the streets. He has been running away from Lady ever since when Love killed his gang and beloved. White is thirsty for revenge, but can do nothing but run away from Love and her henchmen... However, White finally meets Black, a friendly musician, who takes White with him and wants to help him in any way he possibly can. Both of them become good friends, but living in the same apartment makes both of them feel something stronger than just friendship..." WARNING: This comic contains gay relationships, sex, blood, swearing, crying and angsting, confusing scenes, drama and possible grammar mistakes. NOTICE! I started the comic in 2008, so the first four chapters are pretty awful to read... but please bear it, \'cause I\'m saving all the re-drawn pages for the possible-author\'s edition.', True, False)
#add('WhiteNoise', 'http://white-noise.smackjeeves.com/comics/', u'Warning: Shoujo/Shojo Story about the lives of 4 individuals. ~ Romance/Humour ~ Read from left to right >>>>>', False, True)
add('WildWingBoys', 'http://wwb.smackjeeves.com/comics/', u"It's the original Wild Wing Boys, never before seen in its entirety on the Internet! Follow the wacky hijinks of the Gundam Wing characters with sandwich obsessions, meat collecting, and cameos a-plenty! Updates when I can get around to it because school is killer.", False, True)
add('WildWingBoysKoathArc', 'http://wwbka.smackjeeves.com/comics/', u'When a freak dimensional portal sends the five main characters of Gundam Wing into a fantasy world and puts Heero in a coma, the four remaining pilots, accompanied by a young catboy named Toko, must conquer various obstacles in finding a cure...and a way home.', False, True)
add('Wildflowers', 'http://wildflowers.smackjeeves.com/comics/', u'A web comic about love, life, and trying to comes to terms with being transgender. Sometimes dark, sometimes light, and always an attempt at a honest look at transexual life. Updating every day, including weekends!', False, True)
add('WingsOverEthereal', 'http://wings-over-ethereal.smackjeeves.com/comics/', u'[Comic is on break while I prep for more Crisis of the Ancients pages, see you on the 25th!] The age-old fantasy story of a boy and a princess, yet a tale unlike any other... ********************************************* Set in the fictional world of Chrona, "Wings Over Ethereal" is a twisting tale of love and hate set in two Kingdoms living with the tension of an ever-present threat of war. While the beings of these kingdoms go on with their lives either fearing war or welcoming it, they remain blind to the true darkness that seeks to change the course of their world forever. The fate of these two Kingdoms, and perhaps the entire world, rests in the Love between a Human... And an Angel... *********************************************', False, True)
add('WingsTurnedtoDust', 'http://wingsturnedtodust.smackjeeves.com/comics/', u"Sei, Noruku, and Kana were all born with a touch of animal parts, which is actually quite common in their world! Unfortunately for the bunch, their powers that come with the cute ears and tail combo aren't all that welcome by ones born without them. As they train to get stronger for reasons unknown to them, they begin to realize what dangers lie ahead of them as the world opens up and shows its true colors, challenging their friendship and family bonds. Want to support this comic? Physical copies of each completed book are available, as well as merchandise! Book 1 - http://www.lulu.com/shop/spoony-and-murphy/wings-turned-to-dust-book-1/paperback/product-17447851.html Book 2 - http://www.lulu.com/shop/spoony-and-murphy/wings-turned-to-dust-book-2/paperback/product-20665472.html Merchandise - http://flurryofschemingdestiny.spreadshirt.com/", False, True)
add('WolfWolf', 'http://wolfwolf.smackjeeves.com/comics/', u'The daily lives of an ordinary group of friends: Mafer, The carnivorous Woman. London, The helpless romantic gamer. German, Hairstylist by day, Boxer by night. Elena, Possible Robot. Mayo, Japanophile psychopath. Vidal, Cross-dresser. Jose Maria, 24 FPS Dreamer. Updates: Twice a week. (random) Genre: Seinen; Daily life, Comedy, Super Robot, Romance, Tragedy, NTR. Length: 22 episodes.', False, True)
add('WonderTheatre', 'http://wondertheater.smackjeeves.com/comics/', u'Here is my own take of Alice in Wonderland. This is a story about Alfie and Mary-ann, and their encounters of the "Wonder Theatre". One night, while working as a carpenter in an old theatre, Alfie meets Mary-ann, a girl who seems to secretly appear where ever he goes... Just before they become friends, a set of bizarre characters show up in the name of the "Red Prince", to hunt down the mysterious "White Princess". Alfie soon discovers he must protect this White Princess around the clock, without knowing whom she really is... So with the assistance of a rally of mad acquaintances, he has his mirror disguise "Jasper", to use his magic against the "Duchess"\'s wrath, while he fools the public into thinking it\'s all a big mad act! Meanwhile, as Mary-ann holds hope in her father\'s return, she finds she must use her own magic, in order to inspire and protect her friends, and childhood crush... May the show begin!!', False, True)
add('Wootlabs', 'http://wootlabs.thewebcomic.com/comics/', u'"Square Woot is the worst supervillain I ever fought. She held her death ray backwards and vaporized half of her robot army." - Riot Girl, superhero "An uplifting story for anyone that loves cute things in hats." - Penguin Parade Weekly "THIS IS THE STORY OF CATBOT 9000. EVERYONE ELSE IN IT IS STUPID AND NOT CATBOT 9000." - Catbot 9000 Square Woot is a genius with robots, weapons, and that funky little thing called science. Joined by her penguin sidekick and her family of creations, all she wants to do is rule the world. At least, that\'s all she used to want. A chance encounter has the group thinking that it might be more fun to be heroes from now on. Is the city ready to be saved through mad science?', False, True)
add('XXMoralityXx', 'http://xxmoralityxx.smackjeeves.com/comics/', u"Follow the live's of the members of squad 2. The newly graduated Light members, about to go on their first mission, to Fenris Castle. Their goal? To find the Light Princess before the Dark's consumes the world. There will be laughs, tears and love, but can squad 2 finish their mission with out falling to the Dark?", False, True)
add('YadotCakeShop', 'http://yadotcakeshop.smackjeeves.com/comics/', u"The oh so popular Yadot Cake Shop has packed up it's things and moved to a new location, still within the area of Canada. The owner, young 16 year old Tai, had to move the shop to another location in order to avoid law issues that would have closed down Yadot forever. Though some employees have been lost the doors are open for more, to ever make more friends and relationships. The Yadot Cake Shop is an all male cafe that has a habit of having it's employee fall in love within it's walls. Besides making amazing cakes and pastries it is also a great source of fanservice. COME AND ENJOY THE SPLENDOR~! :ACCEPTING APPLICATIONS FOR A LIMITED TIME: :WARNING: THERE IS MATURE THEMES WITHIN THIS COMIC, I GUARANTEE :WARNING:", True, True)
add('YamanaokiHighSchool', 'http://yamanaokihs.smackjeeves.com/comics/', u"there're a lot of dimensions on this world and Honjitsu is where 8 students will live the adventure of their lives... Facebook page: http://www.facebook.com/#!/pages/Yamanaoki/167250876624086 version espa\xf1ol: http://yamanaoki.smackjeeves.com be nice 8D", False, True)
add('YouAreTheReasonForTheEndOfTheWorld', 'http://thereasonfortheendoftheworld.smackjeeves.com/comics/', u"Based on Norse mythology, the comic follows the Aesir Odin, Freyr, Thor and Loki as they and their children struggle to overcome their fates: to burn and die in the fires of Ragnarok, the so-called Twilight of the Gods. However, the enemies of the Asgard, the Jotun, aren't about to go quietly and they have found a way to twist Fate to their advantage. I started this comic to work on my drawing skills, it's all done by hand, with pencil, pen, ink brush and markers.I try to get a chapter up at the beginning of every month!", False, True)
add('YoungCannibals', 'http://www.youngcannibals.net/comics/', u"The story of one girl's battle NOT to kill her friends. Updates every Monday & Friday.", False, True)
add('ZaenWell', 'http://zaenwell.smackjeeves.com/comics/', u'Thrown into the well of the Gods as part of an initiation, Renee Nathans has fourteen days to find a suitable God to bring back into the world of humanity. Danger lurks behind every corner, however, and when a rogue God decides humanity is no longer necessary, an already difficult task becomes even harder...', False, True)
add('ZeldaTheNewAdventureofLinkIIMajorasMask', 'http://newlink.smackjeeves.com/comics/', u'In the land of Termina, in small Clock Town, a carnival is held in honor of the seasons. A looming evil, however, lurks above the town sent by a mischievous Skull Kid wearing a foreboding mask. Now Termina is in need of heroes. Heroes who are willing to traverse the land through dangerous dungeons, defeat terrible enemies and wake the creature that can stop the coming disaster. Once again, join Link and Cloud along with some new friends on their newest adventure to stop the forces of evil... but can even they stop the evil in three days? Updated weekly... usually. Based on the characters and story created and owned by Nintendo. Final Fantasy characters owned by Square Enix. Other characters parodied shown belong to their respective owners.', False, True)
add('_A_', 'http://a-the-stalker.smackjeeves.com/comics/', u'"A" is a light story of how a young girl, Ryza Hartfelt, learns how to deal with infatuation, stress, friendship, and an unknown person who calls himself "A". At first, she dislikes "A" for being a stalker, but that soon changes as she goes through a journey of self-discovery with him. This manga series was completed on July 10, 2013 Please read from right to left ^^', False, True)
