// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file strings.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__STRINGS_HPP
#define FAST_DDS_GENERATED__STRINGS_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(STRINGS_SOURCE)
#define STRINGS_DllAPI __declspec( dllexport )
#else
#define STRINGS_DllAPI __declspec( dllimport )
#endif // STRINGS_SOURCE
#else
#define STRINGS_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define STRINGS_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure StringStruct defined by the user in the IDL file.
 * @ingroup strings
 */
class StringStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StringStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StringStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StringStruct that will be copied.
     */
    eProsima_user_DllExport StringStruct(
            const StringStruct& x)
    {
                    m_var_string8 = x.m_var_string8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StringStruct that will be copied.
     */
    eProsima_user_DllExport StringStruct(
            StringStruct&& x) noexcept
    {
        m_var_string8 = std::move(x.m_var_string8);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StringStruct that will be copied.
     */
    eProsima_user_DllExport StringStruct& operator =(
            const StringStruct& x)
    {

                    m_var_string8 = x.m_var_string8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StringStruct that will be copied.
     */
    eProsima_user_DllExport StringStruct& operator =(
            StringStruct&& x) noexcept
    {

        m_var_string8 = std::move(x.m_var_string8);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StringStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StringStruct& x) const
    {
        return (m_var_string8 == x.m_var_string8);
    }

    /*!
     * @brief Comparison operator.
     * @param x StringStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StringStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_string8
     * @param _var_string8 New value to be copied in member var_string8
     */
    eProsima_user_DllExport void var_string8(
            const std::string& _var_string8)
    {
        m_var_string8 = _var_string8;
    }

    /*!
     * @brief This function moves the value in member var_string8
     * @param _var_string8 New value to be moved in member var_string8
     */
    eProsima_user_DllExport void var_string8(
            std::string&& _var_string8)
    {
        m_var_string8 = std::move(_var_string8);
    }

    /*!
     * @brief This function returns a constant reference to member var_string8
     * @return Constant reference to member var_string8
     */
    eProsima_user_DllExport const std::string& var_string8() const
    {
        return m_var_string8;
    }

    /*!
     * @brief This function returns a reference to member var_string8
     * @return Reference to member var_string8
     */
    eProsima_user_DllExport std::string& var_string8()
    {
        return m_var_string8;
    }



private:

    std::string m_var_string8;

};
/*!
 * @brief This class represents the structure WStringStruct defined by the user in the IDL file.
 * @ingroup strings
 */
class WStringStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport WStringStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~WStringStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object WStringStruct that will be copied.
     */
    eProsima_user_DllExport WStringStruct(
            const WStringStruct& x)
    {
                    m_var_string16 = x.m_var_string16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object WStringStruct that will be copied.
     */
    eProsima_user_DllExport WStringStruct(
            WStringStruct&& x) noexcept
    {
        m_var_string16 = std::move(x.m_var_string16);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object WStringStruct that will be copied.
     */
    eProsima_user_DllExport WStringStruct& operator =(
            const WStringStruct& x)
    {

                    m_var_string16 = x.m_var_string16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object WStringStruct that will be copied.
     */
    eProsima_user_DllExport WStringStruct& operator =(
            WStringStruct&& x) noexcept
    {

        m_var_string16 = std::move(x.m_var_string16);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x WStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const WStringStruct& x) const
    {
        return (m_var_string16 == x.m_var_string16);
    }

    /*!
     * @brief Comparison operator.
     * @param x WStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const WStringStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_string16
     * @param _var_string16 New value to be copied in member var_string16
     */
    eProsima_user_DllExport void var_string16(
            const std::wstring& _var_string16)
    {
        m_var_string16 = _var_string16;
    }

    /*!
     * @brief This function moves the value in member var_string16
     * @param _var_string16 New value to be moved in member var_string16
     */
    eProsima_user_DllExport void var_string16(
            std::wstring&& _var_string16)
    {
        m_var_string16 = std::move(_var_string16);
    }

    /*!
     * @brief This function returns a constant reference to member var_string16
     * @return Constant reference to member var_string16
     */
    eProsima_user_DllExport const std::wstring& var_string16() const
    {
        return m_var_string16;
    }

    /*!
     * @brief This function returns a reference to member var_string16
     * @return Reference to member var_string16
     */
    eProsima_user_DllExport std::wstring& var_string16()
    {
        return m_var_string16;
    }



private:

    std::wstring m_var_string16;

};
/*!
 * @brief This class represents the structure SmallStringStruct defined by the user in the IDL file.
 * @ingroup strings
 */
class SmallStringStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SmallStringStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SmallStringStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SmallStringStruct that will be copied.
     */
    eProsima_user_DllExport SmallStringStruct(
            const SmallStringStruct& x)
    {
                    m_var_small_string = x.m_var_small_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SmallStringStruct that will be copied.
     */
    eProsima_user_DllExport SmallStringStruct(
            SmallStringStruct&& x) noexcept
    {
        m_var_small_string = std::move(x.m_var_small_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SmallStringStruct that will be copied.
     */
    eProsima_user_DllExport SmallStringStruct& operator =(
            const SmallStringStruct& x)
    {

                    m_var_small_string = x.m_var_small_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SmallStringStruct that will be copied.
     */
    eProsima_user_DllExport SmallStringStruct& operator =(
            SmallStringStruct&& x) noexcept
    {

        m_var_small_string = std::move(x.m_var_small_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SmallStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SmallStringStruct& x) const
    {
        return (m_var_small_string == x.m_var_small_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x SmallStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SmallStringStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_small_string
     * @param _var_small_string New value to be copied in member var_small_string
     */
    eProsima_user_DllExport void var_small_string(
            const eprosima::fastcdr::fixed_string<1>& _var_small_string)
    {
        m_var_small_string = _var_small_string;
    }

    /*!
     * @brief This function moves the value in member var_small_string
     * @param _var_small_string New value to be moved in member var_small_string
     */
    eProsima_user_DllExport void var_small_string(
            eprosima::fastcdr::fixed_string<1>&& _var_small_string)
    {
        m_var_small_string = std::move(_var_small_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_small_string
     * @return Constant reference to member var_small_string
     */
    eProsima_user_DllExport const eprosima::fastcdr::fixed_string<1>& var_small_string() const
    {
        return m_var_small_string;
    }

    /*!
     * @brief This function returns a reference to member var_small_string
     * @return Reference to member var_small_string
     */
    eProsima_user_DllExport eprosima::fastcdr::fixed_string<1>& var_small_string()
    {
        return m_var_small_string;
    }



private:

    eprosima::fastcdr::fixed_string<1> m_var_small_string;

};
/*!
 * @brief This class represents the structure SmallWStringStruct defined by the user in the IDL file.
 * @ingroup strings
 */
class SmallWStringStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SmallWStringStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SmallWStringStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SmallWStringStruct that will be copied.
     */
    eProsima_user_DllExport SmallWStringStruct(
            const SmallWStringStruct& x)
    {
                    m_var_small_wstring = x.m_var_small_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SmallWStringStruct that will be copied.
     */
    eProsima_user_DllExport SmallWStringStruct(
            SmallWStringStruct&& x) noexcept
    {
        m_var_small_wstring = std::move(x.m_var_small_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SmallWStringStruct that will be copied.
     */
    eProsima_user_DllExport SmallWStringStruct& operator =(
            const SmallWStringStruct& x)
    {

                    m_var_small_wstring = x.m_var_small_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SmallWStringStruct that will be copied.
     */
    eProsima_user_DllExport SmallWStringStruct& operator =(
            SmallWStringStruct&& x) noexcept
    {

        m_var_small_wstring = std::move(x.m_var_small_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SmallWStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SmallWStringStruct& x) const
    {
        return (m_var_small_wstring == x.m_var_small_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x SmallWStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SmallWStringStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_small_wstring
     * @param _var_small_wstring New value to be copied in member var_small_wstring
     */
    eProsima_user_DllExport void var_small_wstring(
            const std::wstring& _var_small_wstring)
    {
        m_var_small_wstring = _var_small_wstring;
    }

    /*!
     * @brief This function moves the value in member var_small_wstring
     * @param _var_small_wstring New value to be moved in member var_small_wstring
     */
    eProsima_user_DllExport void var_small_wstring(
            std::wstring&& _var_small_wstring)
    {
        m_var_small_wstring = std::move(_var_small_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_small_wstring
     * @return Constant reference to member var_small_wstring
     */
    eProsima_user_DllExport const std::wstring& var_small_wstring() const
    {
        return m_var_small_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_small_wstring
     * @return Reference to member var_small_wstring
     */
    eProsima_user_DllExport std::wstring& var_small_wstring()
    {
        return m_var_small_wstring;
    }



private:

    std::wstring m_var_small_wstring;

};
/*!
 * @brief This class represents the structure LargeStringStruct defined by the user in the IDL file.
 * @ingroup strings
 */
class LargeStringStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport LargeStringStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~LargeStringStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object LargeStringStruct that will be copied.
     */
    eProsima_user_DllExport LargeStringStruct(
            const LargeStringStruct& x)
    {
                    m_var_large_string = x.m_var_large_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object LargeStringStruct that will be copied.
     */
    eProsima_user_DllExport LargeStringStruct(
            LargeStringStruct&& x) noexcept
    {
        m_var_large_string = std::move(x.m_var_large_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object LargeStringStruct that will be copied.
     */
    eProsima_user_DllExport LargeStringStruct& operator =(
            const LargeStringStruct& x)
    {

                    m_var_large_string = x.m_var_large_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object LargeStringStruct that will be copied.
     */
    eProsima_user_DllExport LargeStringStruct& operator =(
            LargeStringStruct&& x) noexcept
    {

        m_var_large_string = std::move(x.m_var_large_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x LargeStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const LargeStringStruct& x) const
    {
        return (m_var_large_string == x.m_var_large_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x LargeStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const LargeStringStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_large_string
     * @param _var_large_string New value to be copied in member var_large_string
     */
    eProsima_user_DllExport void var_large_string(
            const eprosima::fastcdr::fixed_string<41925>& _var_large_string)
    {
        m_var_large_string = _var_large_string;
    }

    /*!
     * @brief This function moves the value in member var_large_string
     * @param _var_large_string New value to be moved in member var_large_string
     */
    eProsima_user_DllExport void var_large_string(
            eprosima::fastcdr::fixed_string<41925>&& _var_large_string)
    {
        m_var_large_string = std::move(_var_large_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_large_string
     * @return Constant reference to member var_large_string
     */
    eProsima_user_DllExport const eprosima::fastcdr::fixed_string<41925>& var_large_string() const
    {
        return m_var_large_string;
    }

    /*!
     * @brief This function returns a reference to member var_large_string
     * @return Reference to member var_large_string
     */
    eProsima_user_DllExport eprosima::fastcdr::fixed_string<41925>& var_large_string()
    {
        return m_var_large_string;
    }



private:

    eprosima::fastcdr::fixed_string<41925> m_var_large_string;

};
/*!
 * @brief This class represents the structure LargeWStringStruct defined by the user in the IDL file.
 * @ingroup strings
 */
class LargeWStringStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport LargeWStringStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~LargeWStringStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object LargeWStringStruct that will be copied.
     */
    eProsima_user_DllExport LargeWStringStruct(
            const LargeWStringStruct& x)
    {
                    m_var_large_wstring = x.m_var_large_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object LargeWStringStruct that will be copied.
     */
    eProsima_user_DllExport LargeWStringStruct(
            LargeWStringStruct&& x) noexcept
    {
        m_var_large_wstring = std::move(x.m_var_large_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object LargeWStringStruct that will be copied.
     */
    eProsima_user_DllExport LargeWStringStruct& operator =(
            const LargeWStringStruct& x)
    {

                    m_var_large_wstring = x.m_var_large_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object LargeWStringStruct that will be copied.
     */
    eProsima_user_DllExport LargeWStringStruct& operator =(
            LargeWStringStruct&& x) noexcept
    {

        m_var_large_wstring = std::move(x.m_var_large_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x LargeWStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const LargeWStringStruct& x) const
    {
        return (m_var_large_wstring == x.m_var_large_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x LargeWStringStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const LargeWStringStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_large_wstring
     * @param _var_large_wstring New value to be copied in member var_large_wstring
     */
    eProsima_user_DllExport void var_large_wstring(
            const std::wstring& _var_large_wstring)
    {
        m_var_large_wstring = _var_large_wstring;
    }

    /*!
     * @brief This function moves the value in member var_large_wstring
     * @param _var_large_wstring New value to be moved in member var_large_wstring
     */
    eProsima_user_DllExport void var_large_wstring(
            std::wstring&& _var_large_wstring)
    {
        m_var_large_wstring = std::move(_var_large_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_large_wstring
     * @return Constant reference to member var_large_wstring
     */
    eProsima_user_DllExport const std::wstring& var_large_wstring() const
    {
        return m_var_large_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_large_wstring
     * @return Reference to member var_large_wstring
     */
    eProsima_user_DllExport std::wstring& var_large_wstring()
    {
        return m_var_large_wstring;
    }



private:

    std::wstring m_var_large_wstring;

};

#endif // _FAST_DDS_GENERATED_STRINGS_HPP_


