/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __NULL_STAT_HPP_INCLUDED
#define __NULL_STAT_HPP_INCLUDED

#include "frontend/ast/SeqStat.hpp"
#include "frontend/visitor/Visitor.hpp"

namespace ast {

//! VHDL null statement.
/** This class represents a VHDL null statement, which is a noop. */
class NullStat : public SeqStat {
public:
	//! c'tor
	/** @param loc location of the NullStat. */
	NullStat(Location loc) : SeqStat(loc) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "NULL;";
	}

};
	
}; /* namespace ast */

#endif /* __NULL_STAT_HPP_INCLUDED */
