/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/reporting/TypeError.hpp"

namespace ast {

TypeError::TypeError(
	const AstNode &node,
	const TypeDeclaration &decl,
	std::string msg
	) : 	CompileError(node, msg), typeName(*decl.name), 
		declLoc(decl.location)
{
	assert(decl.name != NULL);
}

void 
TypeError::put(std::ostream& stream) const
{
	stream << this->location << ": "
	       << this->message
	       << " (type: " << this->typeName
	       << ", declared at " << this->declLoc << ")"
	       << std::endl;
}


}; /* namespace ast */
