/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.typeresolution.TypeHelper;

public class StringToStringRule
extends AbstractRule {
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (!TypeHelper.isA(node.getNameDeclaration(), String.class)) {
            return data;
        }
        boolean isArray = node.isArray();
        for (NameOccurrence occ : node.getUsages()) {
            NameOccurrence qualifier = occ.getNameForWhichThisIsAQualifier();
            if (qualifier == null) continue;
            if (!isArray && qualifier.getImage().indexOf("toString") != -1) {
                this.addViolation(data, occ.getLocation());
                continue;
            }
            if (!isArray || qualifier.getLocation() == null || ASTName.class.equals(qualifier.getLocation().getClass()) || !qualifier.getImage().equals("toString")) continue;
            this.addViolation(data, occ.getLocation());
        }
        return data;
    }
}

