//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armchangeanalysis

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
	"time"
)

// ChangesClient contains the methods for the Changes group.
// Don't use this type directly, use NewChangesClient() instead.
type ChangesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewChangesClient creates a new instance of ChangesClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewChangesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ChangesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ChangesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// NewListChangesByResourceGroupPager - List the changes of a resource group within the specified time range. Customer data
// will always be masked.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-04-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// startTime - Specifies the start time of the changes request.
// endTime - Specifies the end time of the changes request.
// options - ChangesClientListChangesByResourceGroupOptions contains the optional parameters for the ChangesClient.ListChangesByResourceGroup
// method.
func (client *ChangesClient) NewListChangesByResourceGroupPager(resourceGroupName string, startTime time.Time, endTime time.Time, options *ChangesClientListChangesByResourceGroupOptions) *runtime.Pager[ChangesClientListChangesByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ChangesClientListChangesByResourceGroupResponse]{
		More: func(page ChangesClientListChangesByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ChangesClientListChangesByResourceGroupResponse) (ChangesClientListChangesByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listChangesByResourceGroupCreateRequest(ctx, resourceGroupName, startTime, endTime, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ChangesClientListChangesByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ChangesClientListChangesByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ChangesClientListChangesByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listChangesByResourceGroupHandleResponse(resp)
		},
	})
}

// listChangesByResourceGroupCreateRequest creates the ListChangesByResourceGroup request.
func (client *ChangesClient) listChangesByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, startTime time.Time, endTime time.Time, options *ChangesClientListChangesByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ChangeAnalysis/changes"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-04-01")
	reqQP.Set("$startTime", startTime.Format(time.RFC3339Nano))
	reqQP.Set("$endTime", endTime.Format(time.RFC3339Nano))
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listChangesByResourceGroupHandleResponse handles the ListChangesByResourceGroup response.
func (client *ChangesClient) listChangesByResourceGroupHandleResponse(resp *http.Response) (ChangesClientListChangesByResourceGroupResponse, error) {
	result := ChangesClientListChangesByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChangeList); err != nil {
		return ChangesClientListChangesByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListChangesBySubscriptionPager - List the changes of a subscription within the specified time range. Customer data will
// always be masked.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-04-01
// startTime - Specifies the start time of the changes request.
// endTime - Specifies the end time of the changes request.
// options - ChangesClientListChangesBySubscriptionOptions contains the optional parameters for the ChangesClient.ListChangesBySubscription
// method.
func (client *ChangesClient) NewListChangesBySubscriptionPager(startTime time.Time, endTime time.Time, options *ChangesClientListChangesBySubscriptionOptions) *runtime.Pager[ChangesClientListChangesBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ChangesClientListChangesBySubscriptionResponse]{
		More: func(page ChangesClientListChangesBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ChangesClientListChangesBySubscriptionResponse) (ChangesClientListChangesBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listChangesBySubscriptionCreateRequest(ctx, startTime, endTime, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ChangesClientListChangesBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ChangesClientListChangesBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ChangesClientListChangesBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listChangesBySubscriptionHandleResponse(resp)
		},
	})
}

// listChangesBySubscriptionCreateRequest creates the ListChangesBySubscription request.
func (client *ChangesClient) listChangesBySubscriptionCreateRequest(ctx context.Context, startTime time.Time, endTime time.Time, options *ChangesClientListChangesBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ChangeAnalysis/changes"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-04-01")
	reqQP.Set("$startTime", startTime.Format(time.RFC3339Nano))
	reqQP.Set("$endTime", endTime.Format(time.RFC3339Nano))
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listChangesBySubscriptionHandleResponse handles the ListChangesBySubscription response.
func (client *ChangesClient) listChangesBySubscriptionHandleResponse(resp *http.Response) (ChangesClientListChangesBySubscriptionResponse, error) {
	result := ChangesClientListChangesBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChangeList); err != nil {
		return ChangesClientListChangesBySubscriptionResponse{}, err
	}
	return result, nil
}
