//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AzureStackEdgeFormat.
func (a AzureStackEdgeFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureStackEdge", a.AzureStackEdge)
	objectMap["deviceType"] = DeviceTypeAzureStackEdge
	populate(objectMap, "networkFunctions", a.NetworkFunctions)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStackEdgeFormat.
func (a *AzureStackEdgeFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureStackEdge":
			err = unpopulate(val, "AzureStackEdge", &a.AzureStackEdge)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &a.DeviceType)
			delete(rawMsg, key)
		case "networkFunctions":
			err = unpopulate(val, "NetworkFunctions", &a.NetworkFunctions)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Device.
func (d *Device) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDevicePropertiesFormatClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DevicePropertiesFormat.
func (d DevicePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["deviceType"] = d.DeviceType
	populate(objectMap, "networkFunctions", d.NetworkFunctions)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunction.
func (n NetworkFunction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", n.Etag)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionPropertiesFormat.
func (n NetworkFunctionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "device", n.Device)
	populate(objectMap, "managedApplication", n.ManagedApplication)
	populate(objectMap, "managedApplicationParameters", &n.ManagedApplicationParameters)
	populate(objectMap, "networkFunctionContainerConfigurations", &n.NetworkFunctionContainerConfigurations)
	populate(objectMap, "networkFunctionUserConfigurations", n.NetworkFunctionUserConfigurations)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "skuName", n.SKUName)
	populate(objectMap, "skuType", n.SKUType)
	populate(objectMap, "serviceKey", n.ServiceKey)
	populate(objectMap, "vendorName", n.VendorName)
	populate(objectMap, "vendorProvisioningState", n.VendorProvisioningState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionRoleConfiguration.
func (n NetworkFunctionRoleConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customProfile", n.CustomProfile)
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	populate(objectMap, "osProfile", n.OSProfile)
	populate(objectMap, "roleName", n.RoleName)
	populate(objectMap, "roleType", n.RoleType)
	populate(objectMap, "storageProfile", n.StorageProfile)
	populate(objectMap, "userDataParameters", &n.UserDataParameters)
	populate(objectMap, "userDataTemplate", &n.UserDataTemplate)
	populate(objectMap, "virtualMachineSize", n.VirtualMachineSize)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionTemplate.
func (n NetworkFunctionTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkFunctionRoleConfigurations", n.NetworkFunctionRoleConfigurations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionUserConfiguration.
func (n NetworkFunctionUserConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	populate(objectMap, "osProfile", n.OSProfile)
	populate(objectMap, "roleName", n.RoleName)
	populate(objectMap, "userDataParameters", &n.UserDataParameters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionVendorConfiguration.
func (n NetworkFunctionVendorConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	populate(objectMap, "osProfile", n.OSProfile)
	populate(objectMap, "roleName", n.RoleName)
	populate(objectMap, "userDataParameters", &n.UserDataParameters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterface.
func (n NetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ipConfigurations", n.IPConfigurations)
	populate(objectMap, "macAddress", n.MacAddress)
	populate(objectMap, "networkInterfaceName", n.NetworkInterfaceName)
	populate(objectMap, "vmSwitchType", n.VMSwitchType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceIPConfiguration.
func (n NetworkInterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsServers", n.DNSServers)
	populate(objectMap, "gateway", n.Gateway)
	populate(objectMap, "ipAddress", n.IPAddress)
	populate(objectMap, "ipAllocationMethod", n.IPAllocationMethod)
	populate(objectMap, "ipVersion", n.IPVersion)
	populate(objectMap, "subnet", n.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCredential.
func (s *SKUCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acrServerUrl":
			err = unpopulate(val, "AcrServerURL", &s.AcrServerURL)
			delete(rawMsg, key)
		case "acrToken":
			err = unpopulate(val, "AcrToken", &s.AcrToken)
			delete(rawMsg, key)
		case "expiry":
			err = unpopulateTimeRFC3339(val, "Expiry", &s.Expiry)
			delete(rawMsg, key)
		case "repositories":
			err = unpopulate(val, "Repositories", &s.Repositories)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &s.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHConfiguration.
func (s SSHConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publicKeys", s.PublicKeys)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfile.
func (s StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDisks", s.DataDisks)
	populate(objectMap, "imageReference", s.ImageReference)
	populate(objectMap, "osDisk", s.OSDisk)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VendorNetworkFunctionPropertiesFormat.
func (v VendorNetworkFunctionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkFunctionVendorConfigurations", v.NetworkFunctionVendorConfigurations)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "skuName", v.SKUName)
	populate(objectMap, "skuType", v.SKUType)
	populate(objectMap, "vendorProvisioningState", v.VendorProvisioningState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VendorPropertiesFormat.
func (v VendorPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "skus", v.SKUs)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
