// Code generated by smithy-go-codegen DO NOT EDIT.

package trustedadvisor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/trustedadvisor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the accounts that own the resources for an organization aggregate
// recommendation. This API only supports prioritized recommendations.
func (c *Client) ListOrganizationRecommendationAccounts(ctx context.Context, params *ListOrganizationRecommendationAccountsInput, optFns ...func(*Options)) (*ListOrganizationRecommendationAccountsOutput, error) {
	if params == nil {
		params = &ListOrganizationRecommendationAccountsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOrganizationRecommendationAccounts", params, optFns, c.addOperationListOrganizationRecommendationAccountsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOrganizationRecommendationAccountsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOrganizationRecommendationAccountsInput struct {

	// The Recommendation identifier
	//
	// This member is required.
	OrganizationRecommendationIdentifier *string

	// An account affected by this organization recommendation
	AffectedAccountId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListOrganizationRecommendationAccountsOutput struct {

	// The account recommendations lifecycles that are applicable to the Recommendation
	//
	// This member is required.
	AccountRecommendationLifecycleSummaries []types.AccountRecommendationLifecycleSummary

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOrganizationRecommendationAccountsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListOrganizationRecommendationAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListOrganizationRecommendationAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOrganizationRecommendationAccounts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListOrganizationRecommendationAccountsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOrganizationRecommendationAccounts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListOrganizationRecommendationAccountsAPIClient is a client that implements the
// ListOrganizationRecommendationAccounts operation.
type ListOrganizationRecommendationAccountsAPIClient interface {
	ListOrganizationRecommendationAccounts(context.Context, *ListOrganizationRecommendationAccountsInput, ...func(*Options)) (*ListOrganizationRecommendationAccountsOutput, error)
}

var _ ListOrganizationRecommendationAccountsAPIClient = (*Client)(nil)

// ListOrganizationRecommendationAccountsPaginatorOptions is the paginator options
// for ListOrganizationRecommendationAccounts
type ListOrganizationRecommendationAccountsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOrganizationRecommendationAccountsPaginator is a paginator for
// ListOrganizationRecommendationAccounts
type ListOrganizationRecommendationAccountsPaginator struct {
	options   ListOrganizationRecommendationAccountsPaginatorOptions
	client    ListOrganizationRecommendationAccountsAPIClient
	params    *ListOrganizationRecommendationAccountsInput
	nextToken *string
	firstPage bool
}

// NewListOrganizationRecommendationAccountsPaginator returns a new
// ListOrganizationRecommendationAccountsPaginator
func NewListOrganizationRecommendationAccountsPaginator(client ListOrganizationRecommendationAccountsAPIClient, params *ListOrganizationRecommendationAccountsInput, optFns ...func(*ListOrganizationRecommendationAccountsPaginatorOptions)) *ListOrganizationRecommendationAccountsPaginator {
	if params == nil {
		params = &ListOrganizationRecommendationAccountsInput{}
	}

	options := ListOrganizationRecommendationAccountsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOrganizationRecommendationAccountsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOrganizationRecommendationAccountsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOrganizationRecommendationAccounts page.
func (p *ListOrganizationRecommendationAccountsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOrganizationRecommendationAccountsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListOrganizationRecommendationAccounts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListOrganizationRecommendationAccounts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOrganizationRecommendationAccounts",
	}
}
