//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armagrifood

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// FarmBeatsExtensionsClient contains the methods for the FarmBeatsExtensions group.
// Don't use this type directly, use NewFarmBeatsExtensionsClient() instead.
type FarmBeatsExtensionsClient struct {
	host string
	pl   runtime.Pipeline
}

// NewFarmBeatsExtensionsClient creates a new instance of FarmBeatsExtensionsClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewFarmBeatsExtensionsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*FarmBeatsExtensionsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &FarmBeatsExtensionsClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// Get - Get farmBeats extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-09-01-preview
// farmBeatsExtensionID - farmBeatsExtensionId to be queried.
// options - FarmBeatsExtensionsClientGetOptions contains the optional parameters for the FarmBeatsExtensionsClient.Get method.
func (client *FarmBeatsExtensionsClient) Get(ctx context.Context, farmBeatsExtensionID string, options *FarmBeatsExtensionsClientGetOptions) (FarmBeatsExtensionsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, farmBeatsExtensionID, options)
	if err != nil {
		return FarmBeatsExtensionsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return FarmBeatsExtensionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return FarmBeatsExtensionsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *FarmBeatsExtensionsClient) getCreateRequest(ctx context.Context, farmBeatsExtensionID string, options *FarmBeatsExtensionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.AgFoodPlatform/farmBeatsExtensionDefinitions/{farmBeatsExtensionId}"
	if farmBeatsExtensionID == "" {
		return nil, errors.New("parameter farmBeatsExtensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{farmBeatsExtensionId}", url.PathEscape(farmBeatsExtensionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FarmBeatsExtensionsClient) getHandleResponse(resp *http.Response) (FarmBeatsExtensionsClientGetResponse, error) {
	result := FarmBeatsExtensionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FarmBeatsExtension); err != nil {
		return FarmBeatsExtensionsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get list of farmBeats extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-09-01-preview
// options - FarmBeatsExtensionsClientListOptions contains the optional parameters for the FarmBeatsExtensionsClient.List
// method.
func (client *FarmBeatsExtensionsClient) NewListPager(options *FarmBeatsExtensionsClientListOptions) *runtime.Pager[FarmBeatsExtensionsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FarmBeatsExtensionsClientListResponse]{
		More: func(page FarmBeatsExtensionsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FarmBeatsExtensionsClientListResponse) (FarmBeatsExtensionsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return FarmBeatsExtensionsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return FarmBeatsExtensionsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FarmBeatsExtensionsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *FarmBeatsExtensionsClient) listCreateRequest(ctx context.Context, options *FarmBeatsExtensionsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.AgFoodPlatform/farmBeatsExtensionDefinitions"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.FarmBeatsExtensionIDs != nil {
		for _, qv := range options.FarmBeatsExtensionIDs {
			reqQP.Add("farmBeatsExtensionIds", qv)
		}
	}
	if options != nil && options.FarmBeatsExtensionNames != nil {
		for _, qv := range options.FarmBeatsExtensionNames {
			reqQP.Add("farmBeatsExtensionNames", qv)
		}
	}
	if options != nil && options.ExtensionCategories != nil {
		for _, qv := range options.ExtensionCategories {
			reqQP.Add("extensionCategories", qv)
		}
	}
	if options != nil && options.PublisherIDs != nil {
		for _, qv := range options.PublisherIDs {
			reqQP.Add("publisherIds", qv)
		}
	}
	if options != nil && options.MaxPageSize != nil {
		reqQP.Set("$maxPageSize", strconv.FormatInt(int64(*options.MaxPageSize), 10))
	}
	reqQP.Set("api-version", "2021-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *FarmBeatsExtensionsClient) listHandleResponse(resp *http.Response) (FarmBeatsExtensionsClientListResponse, error) {
	result := FarmBeatsExtensionsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FarmBeatsExtensionListResponse); err != nil {
		return FarmBeatsExtensionsClientListResponse{}, err
	}
	return result, nil
}
