//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcosmos_test

import (
	"context"
	"testing"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v2"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/internal/testutil"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armresources"
	"github.com/stretchr/testify/suite"
)

type PrivateendpointconnectionsTestSuite struct {
	suite.Suite

	ctx                           context.Context
	cred                          azcore.TokenCredential
	options                       *arm.ClientOptions
	accountName                   string
	cosmosAccountId               string
	privateEndpointConnectionName string
	privateEndpointId             string
	location                      string
	resourceGroupName             string
	subscriptionId                string
}

func (testsuite *PrivateendpointconnectionsTestSuite) SetupSuite() {
	testsuite.ctx = context.Background()
	testsuite.cred, testsuite.options = testutil.GetCredAndClientOptions(testsuite.T())
	testsuite.accountName = "databaseaccountpec2"
	testsuite.location = testutil.GetEnv("LOCATION", "westus")
	testsuite.resourceGroupName = testutil.GetEnv("RESOURCE_GROUP_NAME", "scenarioTestTempGroup")
	testsuite.subscriptionId = testutil.GetEnv("AZURE_SUBSCRIPTION_ID", "00000000-0000-0000-0000-000000000000")

	testutil.StartRecording(testsuite.T(), "sdk/resourcemanager/cosmos/armcosmos/testdata")
	resourceGroup, _, err := testutil.CreateResourceGroup(testsuite.ctx, testsuite.subscriptionId, testsuite.cred, testsuite.options, testsuite.location)
	testsuite.Require().NoError(err)
	testsuite.resourceGroupName = *resourceGroup.Name
	testsuite.Prepare()
}

func (testsuite *PrivateendpointconnectionsTestSuite) TearDownSuite() {
	_, err := testutil.DeleteResourceGroup(testsuite.ctx, testsuite.subscriptionId, testsuite.cred, testsuite.options, testsuite.resourceGroupName)
	testsuite.Require().NoError(err)
	testutil.StopRecording(testsuite.T())
}

func TestPrivateendpointconnectionsTestSuite(t *testing.T) {
	suite.Run(t, new(PrivateendpointconnectionsTestSuite))
}

func (testsuite *PrivateendpointconnectionsTestSuite) Prepare() {
	var err error
	// From step DatabaseAccount_Create
	databaseAccountsClient, err := armcosmos.NewDatabaseAccountsClient(testsuite.subscriptionId, testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	databaseAccountsClientCreateOrUpdateResponsePoller, err := databaseAccountsClient.BeginCreateOrUpdate(testsuite.ctx, testsuite.resourceGroupName, testsuite.accountName, armcosmos.DatabaseAccountCreateUpdateParameters{
		Location: to.Ptr(testsuite.location),
		Properties: &armcosmos.DatabaseAccountCreateUpdateProperties{
			CreateMode:               to.Ptr(armcosmos.CreateModeDefault),
			DatabaseAccountOfferType: to.Ptr("Standard"),
			Locations: []*armcosmos.Location{
				{
					FailoverPriority: to.Ptr[int32](0),
					IsZoneRedundant:  to.Ptr(false),
					LocationName:     to.Ptr("eastus"),
				}},
		},
	}, nil)
	testsuite.Require().NoError(err)
	var databaseAccountsClientCreateOrUpdateResponse *armcosmos.DatabaseAccountsClientCreateOrUpdateResponse
	databaseAccountsClientCreateOrUpdateResponse, err = testutil.PollForTest(testsuite.ctx, databaseAccountsClientCreateOrUpdateResponsePoller)
	testsuite.Require().NoError(err)
	testsuite.cosmosAccountId = *databaseAccountsClientCreateOrUpdateResponse.ID

	// From step PrivateEndpoint_Create
	template := map[string]interface{}{
		"$schema":        "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#",
		"contentVersion": "1.0.0.0",
		"outputs": map[string]interface{}{
			"privateEndpointConnectionName": map[string]interface{}{
				"type":  "string",
				"value": "[parameters('privateEndpointName')]",
			},
			"privateEndpointId": map[string]interface{}{
				"type":  "string",
				"value": "[resourceId('Microsoft.Network/privateEndpoints', parameters('privateEndpointName'))]",
			},
		},
		"parameters": map[string]interface{}{
			"cosmosAccountId": map[string]interface{}{
				"type":         "string",
				"defaultValue": "$(cosmosAccountId)",
			},
			"networkInterfaceName": map[string]interface{}{
				"type":         "string",
				"defaultValue": "endpointk8s1-nic",
			},
			"privateEndpointName": map[string]interface{}{
				"type":         "string",
				"defaultValue": "endpointk8s1",
			},
			"virtualNetworksName": map[string]interface{}{
				"type":         "string",
				"defaultValue": "k8svnet1",
			},
		},
		"resources": []interface{}{
			map[string]interface{}{
				"name":       "[parameters('virtualNetworksName')]",
				"type":       "Microsoft.Network/virtualNetworks",
				"apiVersion": "2020-11-01",
				"location":   "eastus",
				"properties": map[string]interface{}{
					"addressSpace": map[string]interface{}{
						"addressPrefixes": []interface{}{
							"10.0.0.0/16",
						},
					},
					"enableDdosProtection": false,
					"subnets": []interface{}{
						map[string]interface{}{
							"name": "default",
							"properties": map[string]interface{}{
								"addressPrefix":                     "10.0.0.0/24",
								"delegations":                       []interface{}{},
								"privateEndpointNetworkPolicies":    "Disabled",
								"privateLinkServiceNetworkPolicies": "Enabled",
							},
						},
					},
					"virtualNetworkPeerings": []interface{}{},
				},
			},
			map[string]interface{}{
				"name":       "[parameters('networkInterfaceName')]",
				"type":       "Microsoft.Network/networkInterfaces",
				"apiVersion": "2020-11-01",
				"dependsOn": []interface{}{
					"[resourceId('Microsoft.Network/virtualNetworks/subnets', parameters('virtualNetworksName'), 'default')]",
				},
				"location": "eastus",
				"properties": map[string]interface{}{
					"dnsSettings": map[string]interface{}{
						"dnsServers": []interface{}{},
					},
					"enableIPForwarding": false,
					"ipConfigurations": []interface{}{
						map[string]interface{}{
							"name": "privateEndpointIpConfig.ab24488f-044e-43f0-b9d1-af1f04071719",
							"properties": map[string]interface{}{
								"primary":                   true,
								"privateIPAddress":          "10.0.0.4",
								"privateIPAddressVersion":   "IPv4",
								"privateIPAllocationMethod": "Dynamic",
								"subnet": map[string]interface{}{
									"id": "[resourceId('Microsoft.Network/virtualNetworks/subnets', parameters('virtualNetworksName'), 'default')]",
								},
							},
						},
					},
				},
			},
			map[string]interface{}{
				"name":       "[parameters('privateEndpointName')]",
				"type":       "Microsoft.Network/privateEndpoints",
				"apiVersion": "2020-11-01",
				"dependsOn": []interface{}{
					"[resourceId('Microsoft.Network/virtualNetworks/subnets', parameters('virtualNetworksName'), 'default')]",
				},
				"location": "eastus",
				"properties": map[string]interface{}{
					"customDnsConfigs":                    []interface{}{},
					"manualPrivateLinkServiceConnections": []interface{}{},
					"privateLinkServiceConnections": []interface{}{
						map[string]interface{}{
							"name": "[parameters('privateEndpointName')]",
							"properties": map[string]interface{}{
								"groupIds": []interface{}{
									"Sql",
								},
								"privateLinkServiceConnectionState": map[string]interface{}{
									"description":     "Auto-Approved",
									"actionsRequired": "None",
									"status":          "Approved",
								},
								"privateLinkServiceId": "[parameters('cosmosAccountId')]",
							},
						},
					},
					"subnet": map[string]interface{}{
						"id": "[resourceId('Microsoft.Network/virtualNetworks/subnets', parameters('virtualNetworksName'), 'default')]",
					},
				},
			},
			map[string]interface{}{
				"name":       "[concat(parameters('virtualNetworksName'), '/default')]",
				"type":       "Microsoft.Network/virtualNetworks/subnets",
				"apiVersion": "2020-11-01",
				"dependsOn": []interface{}{
					"[resourceId('Microsoft.Network/virtualNetworks', parameters('virtualNetworksName'))]",
				},
				"properties": map[string]interface{}{
					"addressPrefix":                     "10.0.0.0/24",
					"delegations":                       []interface{}{},
					"privateEndpointNetworkPolicies":    "Disabled",
					"privateLinkServiceNetworkPolicies": "Enabled",
				},
			},
		},
		"variables": map[string]interface{}{},
	}
	params := map[string]interface{}{
		"cosmosAccountId": map[string]interface{}{"value": testsuite.cosmosAccountId},
	}
	deployment := armresources.Deployment{
		Properties: &armresources.DeploymentProperties{
			Template:   template,
			Parameters: params,
			Mode:       to.Ptr(armresources.DeploymentModeIncremental),
		},
	}
	deploymentExtend, err := testutil.CreateDeployment(testsuite.ctx, testsuite.subscriptionId, testsuite.cred, testsuite.options, testsuite.resourceGroupName, "PrivateEndpoint_Create", &deployment)
	testsuite.Require().NoError(err)
	testsuite.privateEndpointConnectionName = deploymentExtend.Properties.Outputs.(map[string]interface{})["privateEndpointConnectionName"].(map[string]interface{})["value"].(string)
	testsuite.privateEndpointId = deploymentExtend.Properties.Outputs.(map[string]interface{})["privateEndpointId"].(map[string]interface{})["value"].(string)
}

// Microsoft.DocumentDB/databaseAccounts/privateEndpointConnections
func (testsuite *PrivateendpointconnectionsTestSuite) TestPrivateendpointconnection() {
	var err error
	// From step PrivateEndpointConnection_Create
	privateEndpointConnectionsClient, err := armcosmos.NewPrivateEndpointConnectionsClient(testsuite.subscriptionId, testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	privateEndpointConnectionsClientCreateOrUpdateResponsePoller, err := privateEndpointConnectionsClient.BeginCreateOrUpdate(testsuite.ctx, testsuite.resourceGroupName, testsuite.accountName, testsuite.privateEndpointConnectionName, armcosmos.PrivateEndpointConnection{
		Properties: &armcosmos.PrivateEndpointConnectionProperties{
			GroupID: to.Ptr("Sql"),
			PrivateEndpoint: &armcosmos.PrivateEndpointProperty{
				ID: to.Ptr(testsuite.privateEndpointId),
			},
			PrivateLinkServiceConnectionState: &armcosmos.PrivateLinkServiceConnectionStateProperty{
				Description: to.Ptr("Approved by johndoe@contoso.com"),
				Status:      to.Ptr("Approved"),
			},
			ProvisioningState: to.Ptr("Succeeded"),
		},
	}, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, privateEndpointConnectionsClientCreateOrUpdateResponsePoller)
	testsuite.Require().NoError(err)

	// From step PrivateEndpointConnection_Get
	_, err = privateEndpointConnectionsClient.Get(testsuite.ctx, testsuite.resourceGroupName, testsuite.accountName, testsuite.privateEndpointConnectionName, nil)
	testsuite.Require().NoError(err)

	// From step PrivateEndpointConnection_ListByDatabaseAccount
	privateEndpointConnectionsClientNewListByDatabaseAccountPager := privateEndpointConnectionsClient.NewListByDatabaseAccountPager(testsuite.resourceGroupName, testsuite.accountName, nil)
	for privateEndpointConnectionsClientNewListByDatabaseAccountPager.More() {
		_, err := privateEndpointConnectionsClientNewListByDatabaseAccountPager.NextPage(testsuite.ctx)
		testsuite.Require().NoError(err)
		break
	}

	// From step PrivateEndpointConnection_Delete
	privateEndpointConnectionsClientDeleteResponsePoller, err := privateEndpointConnectionsClient.BeginDelete(testsuite.ctx, testsuite.resourceGroupName, testsuite.accountName, testsuite.privateEndpointConnectionName, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, privateEndpointConnectionsClientDeleteResponsePoller)
	testsuite.Require().NoError(err)
}

// Microsoft.DocumentDB/databaseAccounts/privateLinkResources
func (testsuite *PrivateendpointconnectionsTestSuite) TestPrivatelinkresource() {
	var err error
	// From step PrivateLinkResource_Get
	privateLinkResourcesClient, err := armcosmos.NewPrivateLinkResourcesClient(testsuite.subscriptionId, testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	_, err = privateLinkResourcesClient.Get(testsuite.ctx, testsuite.resourceGroupName, testsuite.accountName, "sql", nil)
	testsuite.Require().NoError(err)

	// From step PrivateLinkResource_LisyByDabasebaseAccount
	privateLinkResourcesClientNewListByDatabaseAccountPager := privateLinkResourcesClient.NewListByDatabaseAccountPager(testsuite.resourceGroupName, testsuite.accountName, nil)
	for privateLinkResourcesClientNewListByDatabaseAccountPager.More() {
		_, err := privateLinkResourcesClientNewListByDatabaseAccountPager.NextPage(testsuite.ctx)
		testsuite.Require().NoError(err)
		break
	}
}
