//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdesktopvirtualization

import "time"

// AgentUpdatePatchProperties - The preferred settings for updating the agent components (RDAgent, Geneva Monitoring agent,
// and side-by-side stack) on session hosts.
type AgentUpdatePatchProperties struct {
	// The time zone for updating the agent components. Valid time zones can be found here: https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0.
	// A time zone
	// must be specified if useSessionHostLocalTime is false.
	MaintenanceWindowTimeZone *string `json:"maintenanceWindowTimeZone,omitempty"`

	// The maintenance windows (day and time) for updating the agent components. At least 1 window must be specified. Optionally,
	// a 2nd window can be specified.
	MaintenanceWindows []*MaintenanceWindowPatchProperties `json:"maintenanceWindows,omitempty"`

	// The preferred mechanism for updating the agent components. This is either Scheduled or Default.
	Type *SessionHostComponentUpdateType `json:"type,omitempty"`

	// Boolean indicating whether to update the agent components in the local time zone of each session host in the host pool.
	// By default, this is false.
	UseSessionHostLocalTime *bool `json:"useSessionHostLocalTime,omitempty"`
}

// AgentUpdateProperties - The preferred settings for updating the agent components (RDAgent, Geneva Monitoring agent, and
// side-by-side stack) on session hosts.
type AgentUpdateProperties struct {
	// The time zone for updating the agent components. Valid time zones can be found here: https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0.
	// A time zone
	// must be specified if useSessionHostLocalTime is false.
	MaintenanceWindowTimeZone *string `json:"maintenanceWindowTimeZone,omitempty"`

	// The maintenance windows (day and time) for updating the agent components. At least 1 window must be specified. Optionally,
	// a 2nd window can be specified.
	MaintenanceWindows []*MaintenanceWindowProperties `json:"maintenanceWindows,omitempty"`

	// The preferred mechanism for updating the agent components. This is either Scheduled or Default.
	Type *SessionHostComponentUpdateType `json:"type,omitempty"`

	// Boolean indicating whether to update the agent components in the local time zone of each session host in the host pool.
	// By default, this is false.
	UseSessionHostLocalTime *bool `json:"useSessionHostLocalTime,omitempty"`
}

// Application - Schema for Application properties.
type Application struct {
	// REQUIRED; Detailed properties for Application
	Properties *ApplicationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGroup - Represents a ApplicationGroup definition.
type ApplicationGroup struct {
	// REQUIRED; Detailed properties for ApplicationGroup
	Properties *ApplicationGroupProperties                  `json:"properties,omitempty"`
	Identity   *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string                                  `json:"managedBy,omitempty"`
	Plan      *ResourceModelWithAllowedPropertySetPlan `json:"plan,omitempty"`
	SKU       *ResourceModelWithAllowedPropertySetSKU  `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGroupList - List of ApplicationGroup definitions.
type ApplicationGroupList struct {
	// List of ApplicationGroup definitions.
	Value []*ApplicationGroup `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ApplicationGroupPatch - ApplicationGroup properties that can be patched.
type ApplicationGroupPatch struct {
	// ApplicationGroup properties that can be patched.
	Properties *ApplicationGroupPatchProperties `json:"properties,omitempty"`

	// tags to be updated
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGroupPatchProperties - ApplicationGroup properties that can be patched.
type ApplicationGroupPatchProperties struct {
	// Description of ApplicationGroup.
	Description *string `json:"description,omitempty"`

	// Friendly name of ApplicationGroup.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// ApplicationGroupProperties - Schema for ApplicationGroup properties.
type ApplicationGroupProperties struct {
	// REQUIRED; Resource Type of ApplicationGroup.
	ApplicationGroupType *ApplicationGroupType `json:"applicationGroupType,omitempty"`

	// REQUIRED; HostPool arm path of ApplicationGroup.
	HostPoolArmPath *string `json:"hostPoolArmPath,omitempty"`

	// Description of ApplicationGroup.
	Description *string `json:"description,omitempty"`

	// Friendly name of ApplicationGroup.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The registration info of HostPool.
	MigrationRequest *MigrationRequestProperties `json:"migrationRequest,omitempty"`

	// READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool `json:"cloudPcResource,omitempty" azure:"ro"`

	// READ-ONLY; ObjectId of ApplicationGroup. (internal use)
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`

	// READ-ONLY; Workspace arm path of ApplicationGroup.
	WorkspaceArmPath *string `json:"workspaceArmPath,omitempty" azure:"ro"`
}

// ApplicationGroupsClientCreateOrUpdateOptions contains the optional parameters for the ApplicationGroupsClient.CreateOrUpdate
// method.
type ApplicationGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGroupsClientDeleteOptions contains the optional parameters for the ApplicationGroupsClient.Delete method.
type ApplicationGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGroupsClientGetOptions contains the optional parameters for the ApplicationGroupsClient.Get method.
type ApplicationGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGroupsClientListByResourceGroupOptions contains the optional parameters for the ApplicationGroupsClient.ListByResourceGroup
// method.
type ApplicationGroupsClientListByResourceGroupOptions struct {
	// OData filter expression. Valid properties for filtering are applicationGroupType.
	Filter *string
}

// ApplicationGroupsClientListBySubscriptionOptions contains the optional parameters for the ApplicationGroupsClient.ListBySubscription
// method.
type ApplicationGroupsClientListBySubscriptionOptions struct {
	// OData filter expression. Valid properties for filtering are applicationGroupType.
	Filter *string
}

// ApplicationGroupsClientUpdateOptions contains the optional parameters for the ApplicationGroupsClient.Update method.
type ApplicationGroupsClientUpdateOptions struct {
	// Object containing ApplicationGroup definitions.
	ApplicationGroup *ApplicationGroupPatch
}

// ApplicationList - List of Application definitions.
type ApplicationList struct {
	// List of Application definitions.
	Value []*Application `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ApplicationPatch - Application properties that can be patched.
type ApplicationPatch struct {
	// Detailed properties for Application
	Properties *ApplicationPatchProperties `json:"properties,omitempty"`

	// tags to be updated
	Tags map[string]*string `json:"tags,omitempty"`
}

// ApplicationPatchProperties - Application properties that can be patched.
type ApplicationPatchProperties struct {
	// Resource Type of Application.
	ApplicationType *RemoteApplicationType `json:"applicationType,omitempty"`

	// Command Line Arguments for Application.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`

	// Specifies whether this published application can be launched with command line arguments provided by the client, command
	// line arguments specified at publish time, or no command line arguments at all.
	CommandLineSetting *CommandLineSetting `json:"commandLineSetting,omitempty"`

	// Description of Application.
	Description *string `json:"description,omitempty"`

	// Specifies a path for the executable file for the application.
	FilePath *string `json:"filePath,omitempty"`

	// Friendly name of Application.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`

	// Path to icon.
	IconPath *string `json:"iconPath,omitempty"`

	// Specifies the package application Id for MSIX applications
	MsixPackageApplicationID *string `json:"msixPackageApplicationId,omitempty"`

	// Specifies the package family name for MSIX applications
	MsixPackageFamilyName *string `json:"msixPackageFamilyName,omitempty"`

	// Specifies whether to show the RemoteApp program in the RD Web Access server.
	ShowInPortal *bool `json:"showInPortal,omitempty"`
}

// ApplicationProperties - Schema for Application properties.
type ApplicationProperties struct {
	// REQUIRED; Specifies whether this published application can be launched with command line arguments provided by the client,
	// command line arguments specified at publish time, or no command line arguments at all.
	CommandLineSetting *CommandLineSetting `json:"commandLineSetting,omitempty"`

	// Resource Type of Application.
	ApplicationType *RemoteApplicationType `json:"applicationType,omitempty"`

	// Command Line Arguments for Application.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`

	// Description of Application.
	Description *string `json:"description,omitempty"`

	// Specifies a path for the executable file for the application.
	FilePath *string `json:"filePath,omitempty"`

	// Friendly name of Application.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`

	// Path to icon.
	IconPath *string `json:"iconPath,omitempty"`

	// Specifies the package application Id for MSIX applications
	MsixPackageApplicationID *string `json:"msixPackageApplicationId,omitempty"`

	// Specifies the package family name for MSIX applications
	MsixPackageFamilyName *string `json:"msixPackageFamilyName,omitempty"`

	// Specifies whether to show the RemoteApp program in the RD Web Access server.
	ShowInPortal *bool `json:"showInPortal,omitempty"`

	// READ-ONLY; the icon a 64 bit string as a byte array.
	IconContent []byte `json:"iconContent,omitempty" azure:"ro"`

	// READ-ONLY; Hash of the icon.
	IconHash *string `json:"iconHash,omitempty" azure:"ro"`

	// READ-ONLY; ObjectId of Application. (internal use)
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`
}

// ApplicationsClientCreateOrUpdateOptions contains the optional parameters for the ApplicationsClient.CreateOrUpdate method.
type ApplicationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientDeleteOptions contains the optional parameters for the ApplicationsClient.Delete method.
type ApplicationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientGetOptions contains the optional parameters for the ApplicationsClient.Get method.
type ApplicationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientListOptions contains the optional parameters for the ApplicationsClient.List method.
type ApplicationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientUpdateOptions contains the optional parameters for the ApplicationsClient.Update method.
type ApplicationsClientUpdateOptions struct {
	// Object containing Application definitions.
	Application *ApplicationPatch
}

// CloudError - Cloud error object.
type CloudError struct {
	// Cloud error object properties.
	Error *CloudErrorProperties `json:"error,omitempty"`
}

// CloudErrorProperties - Cloud error object properties.
type CloudErrorProperties struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Desktop - Schema for Desktop properties.
type Desktop struct {
	// Detailed properties for Desktop
	Properties *DesktopProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DesktopList - List of Desktop definitions.
type DesktopList struct {
	// List of Desktop definitions.
	Value []*Desktop `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DesktopPatch - Desktop properties that can be patched.
type DesktopPatch struct {
	// Detailed properties for Desktop
	Properties *DesktopPatchProperties `json:"properties,omitempty"`

	// tags to be updated
	Tags map[string]*string `json:"tags,omitempty"`
}

// DesktopPatchProperties - Desktop properties that can be patched.
type DesktopPatchProperties struct {
	// Description of Desktop.
	Description *string `json:"description,omitempty"`

	// Friendly name of Desktop.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// DesktopProperties - Schema for Desktop properties.
type DesktopProperties struct {
	// Description of Desktop.
	Description *string `json:"description,omitempty"`

	// Friendly name of Desktop.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// READ-ONLY; The icon a 64 bit string as a byte array.
	IconContent []byte `json:"iconContent,omitempty" azure:"ro"`

	// READ-ONLY; Hash of the icon.
	IconHash *string `json:"iconHash,omitempty" azure:"ro"`

	// READ-ONLY; ObjectId of Desktop. (internal use)
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`
}

// DesktopsClientGetOptions contains the optional parameters for the DesktopsClient.Get method.
type DesktopsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DesktopsClientListOptions contains the optional parameters for the DesktopsClient.List method.
type DesktopsClientListOptions struct {
	// placeholder for future optional parameters
}

// DesktopsClientUpdateOptions contains the optional parameters for the DesktopsClient.Update method.
type DesktopsClientUpdateOptions struct {
	// Object containing Desktop definitions.
	Desktop *DesktopPatch
}

// ExpandMsixImage - Represents the definition of contents retrieved after expanding the MSIX Image.
type ExpandMsixImage struct {
	// Detailed properties for ExpandMsixImage
	Properties *ExpandMsixImageProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpandMsixImageList - List of MSIX package properties retrieved from MSIX Image expansion.
type ExpandMsixImageList struct {
	// List of MSIX package properties from give MSIX Image.
	Value []*ExpandMsixImage `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ExpandMsixImageProperties - Schema for Expand MSIX Image properties.
type ExpandMsixImageProperties struct {
	// User friendly Name to be displayed in the portal.
	DisplayName *string `json:"displayName,omitempty"`

	// VHD/CIM image path on Network Share.
	ImagePath *string `json:"imagePath,omitempty"`

	// Make this version of the package the active one across the hostpool.
	IsActive *bool `json:"isActive,omitempty"`

	// Specifies how to register Package in feed.
	IsRegularRegistration *bool `json:"isRegularRegistration,omitempty"`

	// Date Package was last updated, found in the appxmanifest.xml.
	LastUpdated *time.Time `json:"lastUpdated,omitempty"`

	// Alias of MSIX Package.
	PackageAlias *string `json:"packageAlias,omitempty"`

	// List of package applications.
	PackageApplications []*MsixPackageApplications `json:"packageApplications,omitempty"`

	// List of package dependencies.
	PackageDependencies []*MsixPackageDependencies `json:"packageDependencies,omitempty"`

	// Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
	PackageFamilyName *string `json:"packageFamilyName,omitempty"`

	// Package Full Name from appxmanifest.xml.
	PackageFullName *string `json:"packageFullName,omitempty"`

	// Package Name from appxmanifest.xml.
	PackageName *string `json:"packageName,omitempty"`

	// Relative Path to the package inside the image.
	PackageRelativePath *string `json:"packageRelativePath,omitempty"`

	// Package Version found in the appxmanifest.xml.
	Version *string `json:"version,omitempty"`
}

// HostPool - Represents a HostPool definition.
type HostPool struct {
	// REQUIRED; Detailed properties for HostPool
	Properties *HostPoolProperties                          `json:"properties,omitempty"`
	Identity   *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string                                  `json:"managedBy,omitempty"`
	Plan      *ResourceModelWithAllowedPropertySetPlan `json:"plan,omitempty"`
	SKU       *ResourceModelWithAllowedPropertySetSKU  `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HostPoolList - List of HostPool definitions.
type HostPoolList struct {
	// List of HostPool definitions.
	Value []*HostPool `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// HostPoolPatch - HostPool properties that can be patched.
type HostPoolPatch struct {
	// HostPool properties that can be patched.
	Properties *HostPoolPatchProperties `json:"properties,omitempty"`

	// tags to be updated
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HostPoolPatchProperties - Properties of HostPool.
type HostPoolPatchProperties struct {
	// The preferred settings for updating the agent components (RDAgent, Geneva Monitoring agent, and side-by-side stack) on
	// session hosts.
	AgentUpdate *AgentUpdatePatchProperties `json:"agentUpdate,omitempty"`

	// Custom rdp property of HostPool.
	CustomRdpProperty *string `json:"customRdpProperty,omitempty"`

	// Description of HostPool.
	Description *string `json:"description,omitempty"`

	// Friendly name of HostPool.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The type of the load balancer.
	LoadBalancerType *LoadBalancerType `json:"loadBalancerType,omitempty"`

	// The max session limit of HostPool.
	MaxSessionLimit *int32 `json:"maxSessionLimit,omitempty"`

	// PersonalDesktopAssignment type for HostPool.
	PersonalDesktopAssignmentType *PersonalDesktopAssignmentType `json:"personalDesktopAssignmentType,omitempty"`

	// The type of preferred application group type, default to Desktop Application Group
	PreferredAppGroupType *PreferredAppGroupType `json:"preferredAppGroupType,omitempty"`

	// Enabled to allow this resource to be access from the public network
	PublicNetworkAccess *HostpoolPublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// The registration info of HostPool.
	RegistrationInfo *RegistrationInfoPatch `json:"registrationInfo,omitempty"`

	// The ring number of HostPool.
	Ring *int32 `json:"ring,omitempty"`

	// ClientId for the registered Relying Party used to issue WVD SSO certificates.
	SsoClientID *string `json:"ssoClientId,omitempty"`

	// Path to Azure KeyVault storing the secret used for communication to ADFS.
	SsoClientSecretKeyVaultPath *string `json:"ssoClientSecretKeyVaultPath,omitempty"`

	// The type of single sign on Secret Type.
	SsoSecretType *SSOSecretType `json:"ssoSecretType,omitempty"`

	// URL to customer ADFS server for signing WVD SSO certificates.
	SsoadfsAuthority *string `json:"ssoadfsAuthority,omitempty"`

	// The flag to turn on/off StartVMOnConnect feature.
	StartVMOnConnect *bool `json:"startVMOnConnect,omitempty"`

	// VM template for sessionhosts configuration within hostpool.
	VMTemplate *string `json:"vmTemplate,omitempty"`

	// Is validation environment.
	ValidationEnvironment *bool `json:"validationEnvironment,omitempty"`
}

// HostPoolProperties - Properties of HostPool.
type HostPoolProperties struct {
	// REQUIRED; HostPool type for desktop.
	HostPoolType *HostPoolType `json:"hostPoolType,omitempty"`

	// REQUIRED; The type of the load balancer.
	LoadBalancerType *LoadBalancerType `json:"loadBalancerType,omitempty"`

	// REQUIRED; The type of preferred application group type, default to Desktop Application Group
	PreferredAppGroupType *PreferredAppGroupType `json:"preferredAppGroupType,omitempty"`

	// The preferred settings for updating the agent components (RDAgent, Geneva Monitoring agent, and side-by-side stack) on
	// session hosts.
	AgentUpdate *AgentUpdateProperties `json:"agentUpdate,omitempty"`

	// Custom rdp property of HostPool.
	CustomRdpProperty *string `json:"customRdpProperty,omitempty"`

	// Description of HostPool.
	Description *string `json:"description,omitempty"`

	// Friendly name of HostPool.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The max session limit of HostPool.
	MaxSessionLimit *int32 `json:"maxSessionLimit,omitempty"`

	// The registration info of HostPool.
	MigrationRequest *MigrationRequestProperties `json:"migrationRequest,omitempty"`

	// PersonalDesktopAssignment type for HostPool.
	PersonalDesktopAssignmentType *PersonalDesktopAssignmentType `json:"personalDesktopAssignmentType,omitempty"`

	// Enabled allows this resource to be accessed from both public and private networks, Disabled allows this resource to only
	// be accessed via private endpoints
	PublicNetworkAccess *HostpoolPublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// The registration info of HostPool.
	RegistrationInfo *RegistrationInfo `json:"registrationInfo,omitempty"`

	// The ring number of HostPool.
	Ring *int32 `json:"ring,omitempty"`

	// ClientId for the registered Relying Party used to issue WVD SSO certificates.
	SsoClientID *string `json:"ssoClientId,omitempty"`

	// Path to Azure KeyVault storing the secret used for communication to ADFS.
	SsoClientSecretKeyVaultPath *string `json:"ssoClientSecretKeyVaultPath,omitempty"`

	// The type of single sign on Secret Type.
	SsoSecretType *SSOSecretType `json:"ssoSecretType,omitempty"`

	// URL to customer ADFS server for signing WVD SSO certificates.
	SsoadfsAuthority *string `json:"ssoadfsAuthority,omitempty"`

	// The flag to turn on/off StartVMOnConnect feature.
	StartVMOnConnect *bool `json:"startVMOnConnect,omitempty"`

	// VM template for sessionhosts configuration within hostpool.
	VMTemplate *string `json:"vmTemplate,omitempty"`

	// Is validation environment.
	ValidationEnvironment *bool `json:"validationEnvironment,omitempty"`

	// READ-ONLY; List of applicationGroup links.
	ApplicationGroupReferences []*string `json:"applicationGroupReferences,omitempty" azure:"ro"`

	// READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool `json:"cloudPcResource,omitempty" azure:"ro"`

	// READ-ONLY; ObjectId of HostPool. (internal use)
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connection associated with the specified resource
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`
}

// HostPoolsClientCreateOrUpdateOptions contains the optional parameters for the HostPoolsClient.CreateOrUpdate method.
type HostPoolsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// HostPoolsClientDeleteOptions contains the optional parameters for the HostPoolsClient.Delete method.
type HostPoolsClientDeleteOptions struct {
	// Force flag to delete sessionHost.
	Force *bool
}

// HostPoolsClientGetOptions contains the optional parameters for the HostPoolsClient.Get method.
type HostPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HostPoolsClientListByResourceGroupOptions contains the optional parameters for the HostPoolsClient.ListByResourceGroup
// method.
type HostPoolsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// HostPoolsClientListOptions contains the optional parameters for the HostPoolsClient.List method.
type HostPoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// HostPoolsClientRetrieveRegistrationTokenOptions contains the optional parameters for the HostPoolsClient.RetrieveRegistrationToken
// method.
type HostPoolsClientRetrieveRegistrationTokenOptions struct {
	// placeholder for future optional parameters
}

// HostPoolsClientUpdateOptions contains the optional parameters for the HostPoolsClient.Update method.
type HostPoolsClientUpdateOptions struct {
	// Object containing HostPool definitions.
	HostPool *HostPoolPatch
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// LogSpecification - Specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the log
	Name *string `json:"name,omitempty"`
}

// MSIXImageURI - Represents URI referring to MSIX Image
type MSIXImageURI struct {
	// URI to Image
	URI *string `json:"uri,omitempty"`
}

// MSIXPackage - Schema for MSIX Package properties.
type MSIXPackage struct {
	// REQUIRED; Detailed properties for MSIX Package
	Properties *MSIXPackageProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MSIXPackageList - List of MSIX Package definitions.
type MSIXPackageList struct {
	// List of MSIX Package definitions.
	Value []*MSIXPackage `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MSIXPackagePatch - MSIX Package properties that can be patched.
type MSIXPackagePatch struct {
	// Detailed properties for MSIX Package
	Properties *MSIXPackagePatchProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MSIXPackagePatchProperties - MSIX Package properties that can be patched.
type MSIXPackagePatchProperties struct {
	// Display name for MSIX Package.
	DisplayName *string `json:"displayName,omitempty"`

	// Set a version of the package to be active across hostpool.
	IsActive *bool `json:"isActive,omitempty"`

	// Set Registration mode. Regular or Delayed.
	IsRegularRegistration *bool `json:"isRegularRegistration,omitempty"`
}

// MSIXPackageProperties - Schema for MSIX Package properties.
type MSIXPackageProperties struct {
	// User friendly Name to be displayed in the portal.
	DisplayName *string `json:"displayName,omitempty"`

	// VHD/CIM image path on Network Share.
	ImagePath *string `json:"imagePath,omitempty"`

	// Make this version of the package the active one across the hostpool.
	IsActive *bool `json:"isActive,omitempty"`

	// Specifies how to register Package in feed.
	IsRegularRegistration *bool `json:"isRegularRegistration,omitempty"`

	// Date Package was last updated, found in the appxmanifest.xml.
	LastUpdated *time.Time `json:"lastUpdated,omitempty"`

	// List of package applications.
	PackageApplications []*MsixPackageApplications `json:"packageApplications,omitempty"`

	// List of package dependencies.
	PackageDependencies []*MsixPackageDependencies `json:"packageDependencies,omitempty"`

	// Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
	PackageFamilyName *string `json:"packageFamilyName,omitempty"`

	// Package Name from appxmanifest.xml.
	PackageName *string `json:"packageName,omitempty"`

	// Relative Path to the package inside the image.
	PackageRelativePath *string `json:"packageRelativePath,omitempty"`

	// Package Version found in the appxmanifest.xml.
	Version *string `json:"version,omitempty"`
}

// MSIXPackagesClientCreateOrUpdateOptions contains the optional parameters for the MSIXPackagesClient.CreateOrUpdate method.
type MSIXPackagesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// MSIXPackagesClientDeleteOptions contains the optional parameters for the MSIXPackagesClient.Delete method.
type MSIXPackagesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// MSIXPackagesClientGetOptions contains the optional parameters for the MSIXPackagesClient.Get method.
type MSIXPackagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// MSIXPackagesClientListOptions contains the optional parameters for the MSIXPackagesClient.List method.
type MSIXPackagesClientListOptions struct {
	// placeholder for future optional parameters
}

// MSIXPackagesClientUpdateOptions contains the optional parameters for the MSIXPackagesClient.Update method.
type MSIXPackagesClientUpdateOptions struct {
	// Object containing MSIX Package definitions.
	MsixPackage *MSIXPackagePatch
}

// MaintenanceWindowPatchProperties - Maintenance window starting hour and day of week.
type MaintenanceWindowPatchProperties struct {
	// The day of the week (Monday-Sunday).
	DayOfWeek *DayOfWeek `json:"dayOfWeek,omitempty"`

	// The starting hour of the maintenance window (0-23). Note that maintenance windows are 2 hours long. This means that updates
	// can be applied anytime from the specified start hour to 2 hours after.
	Hour *int32 `json:"hour,omitempty"`
}

// MaintenanceWindowProperties - Maintenance window starting hour and day of week.
type MaintenanceWindowProperties struct {
	// The day of the week (Monday-Sunday).
	DayOfWeek *DayOfWeek `json:"dayOfWeek,omitempty"`

	// The starting hour of the maintenance window (0-23). Note that maintenance windows are 2 hours long. This means that updates
	// can be applied anytime from the specified start hour to 2 hours after.
	Hour *int32 `json:"hour,omitempty"`
}

// MigrationRequestProperties - Properties for arm migration.
type MigrationRequestProperties struct {
	// The path to the legacy object to migrate.
	MigrationPath *string `json:"migrationPath,omitempty"`

	// The type of operation for migration.
	Operation *Operation `json:"operation,omitempty"`
}

// MsixImagesClientExpandOptions contains the optional parameters for the MsixImagesClient.Expand method.
type MsixImagesClientExpandOptions struct {
	// placeholder for future optional parameters
}

// MsixPackageApplications - Schema for MSIX Package Application properties.
type MsixPackageApplications struct {
	// Package Application Id, found in appxmanifest.xml.
	AppID *string `json:"appId,omitempty"`

	// Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
	AppUserModelID *string `json:"appUserModelID,omitempty"`

	// Description of Package Application.
	Description *string `json:"description,omitempty"`

	// User friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// User friendly name.
	IconImageName *string `json:"iconImageName,omitempty"`

	// the icon a 64 bit string as a byte array.
	RawIcon []byte `json:"rawIcon,omitempty"`

	// the icon a 64 bit string as a byte array.
	RawPNG []byte `json:"rawPng,omitempty"`
}

// MsixPackageDependencies - Schema for MSIX Package Dependencies properties.
type MsixPackageDependencies struct {
	// Name of package dependency.
	DependencyName *string `json:"dependencyName,omitempty"`

	// Dependency version required.
	MinVersion *string `json:"minVersion,omitempty"`

	// Name of dependency publisher.
	Publisher *string `json:"publisher,omitempty"`
}

// OperationProperties - Properties of the operation
type OperationProperties struct {
	// Service specification payload
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Plan for the resource.
type Plan struct {
	// REQUIRED; A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact
	// at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`

	// REQUIRED; The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`

	// A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResultWithSystemData - List of private endpoint connection associated with the specified storage
// account
type PrivateEndpointConnectionListResultWithSystemData struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnectionWithSystemData `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionWithSystemData - The Private Endpoint Connection resource.
type PrivateEndpointConnectionWithSystemData struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientDeleteByHostPoolOptions contains the optional parameters for the PrivateEndpointConnectionsClient.DeleteByHostPool
// method.
type PrivateEndpointConnectionsClientDeleteByHostPoolOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientDeleteByWorkspaceOptions contains the optional parameters for the PrivateEndpointConnectionsClient.DeleteByWorkspace
// method.
type PrivateEndpointConnectionsClientDeleteByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetByHostPoolOptions contains the optional parameters for the PrivateEndpointConnectionsClient.GetByHostPool
// method.
type PrivateEndpointConnectionsClientGetByHostPoolOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetByWorkspaceOptions contains the optional parameters for the PrivateEndpointConnectionsClient.GetByWorkspace
// method.
type PrivateEndpointConnectionsClientGetByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByHostPoolOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByHostPool
// method.
type PrivateEndpointConnectionsClientListByHostPoolOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByWorkspaceOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByWorkspace
// method.
type PrivateEndpointConnectionsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientUpdateByHostPoolOptions contains the optional parameters for the PrivateEndpointConnectionsClient.UpdateByHostPool
// method.
type PrivateEndpointConnectionsClientUpdateByHostPoolOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientUpdateByWorkspaceOptions contains the optional parameters for the PrivateEndpointConnectionsClient.UpdateByWorkspace
// method.
type PrivateEndpointConnectionsClientUpdateByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListByHostPoolOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByHostPool
// method.
type PrivateLinkResourcesClientListByHostPoolOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByWorkspaceOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByWorkspace
// method.
type PrivateLinkResourcesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// RegistrationInfo - Represents a RegistrationInfo definition.
type RegistrationInfo struct {
	// Expiration time of registration token.
	ExpirationTime *time.Time `json:"expirationTime,omitempty"`

	// The type of resetting the token.
	RegistrationTokenOperation *RegistrationTokenOperation `json:"registrationTokenOperation,omitempty"`

	// The registration token base64 encoded string.
	Token *string `json:"token,omitempty"`
}

// RegistrationInfoPatch - Represents a RegistrationInfo definition.
type RegistrationInfoPatch struct {
	// Expiration time of registration token.
	ExpirationTime *time.Time `json:"expirationTime,omitempty"`

	// The type of resetting the token.
	RegistrationTokenOperation *RegistrationTokenOperation `json:"registrationTokenOperation,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceModelWithAllowedPropertySet - The resource model definition containing the full set of allowed properties for a
// resource. Except properties bag, there cannot be a top level property outside of this set.
type ResourceModelWithAllowedPropertySet struct {
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string                                  `json:"managedBy,omitempty"`
	Plan      *ResourceModelWithAllowedPropertySetPlan `json:"plan,omitempty"`
	SKU       *ResourceModelWithAllowedPropertySetSKU  `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ResourceModelWithAllowedPropertySetIdentity struct {
	// The identity type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

type ResourceModelWithAllowedPropertySetPlan struct {
	// REQUIRED; A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact
	// at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`

	// REQUIRED; The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`

	// A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

type ResourceModelWithAllowedPropertySetSKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier `json:"tier,omitempty"`
}

// ResourceProviderOperation - Supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`

	// Is a data action.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`
}

// ResourceProviderOperationDisplay - Display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Description of this operation.
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Resource provider: Microsoft Desktop Virtualization.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// ResourceProviderOperationList - Result of the request to list operations.
type ResourceProviderOperationList struct {
	// List of operations supported by this resource provider.
	Value []*ResourceProviderOperation `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier `json:"tier,omitempty"`
}

// ScalingHostPoolReference - Scaling plan reference to hostpool.
type ScalingHostPoolReference struct {
	// Arm path of referenced hostpool.
	HostPoolArmPath *string `json:"hostPoolArmPath,omitempty"`

	// Is the scaling plan enabled for this hostpool.
	ScalingPlanEnabled *bool `json:"scalingPlanEnabled,omitempty"`
}

// ScalingPlan - Represents a scaling plan definition.
type ScalingPlan struct {
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string                                  `json:"managedBy,omitempty"`
	Plan      *ResourceModelWithAllowedPropertySetPlan `json:"plan,omitempty"`

	// Detailed properties for scaling plan.
	Properties *ScalingPlanProperties                  `json:"properties,omitempty"`
	SKU        *ResourceModelWithAllowedPropertySetSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScalingPlanList - List of scaling plan definitions.
type ScalingPlanList struct {
	// List of scaling plan definitions.
	Value []*ScalingPlan `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ScalingPlanPatch - Scaling plan properties that can be patched.
type ScalingPlanPatch struct {
	// Detailed properties for scaling plan
	Properties *ScalingPlanPatchProperties `json:"properties,omitempty"`

	// tags to be updated
	Tags map[string]*string `json:"tags,omitempty"`
}

// ScalingPlanPatchProperties - Scaling plan properties.
type ScalingPlanPatchProperties struct {
	// Description of scaling plan.
	Description *string `json:"description,omitempty"`

	// Exclusion tag for scaling plan.
	ExclusionTag *string `json:"exclusionTag,omitempty"`

	// User friendly name of scaling plan.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// List of ScalingHostPoolReference definitions.
	HostPoolReferences []*ScalingHostPoolReference `json:"hostPoolReferences,omitempty"`

	// List of ScalingSchedule definitions.
	Schedules []*ScalingSchedule `json:"schedules,omitempty"`

	// Timezone of the scaling plan.
	TimeZone *string `json:"timeZone,omitempty"`
}

// ScalingPlanProperties - Scaling plan properties.
type ScalingPlanProperties struct {
	// Description of scaling plan.
	Description *string `json:"description,omitempty"`

	// Exclusion tag for scaling plan.
	ExclusionTag *string `json:"exclusionTag,omitempty"`

	// User friendly name of scaling plan.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// List of ScalingHostPoolReference definitions.
	HostPoolReferences []*ScalingHostPoolReference `json:"hostPoolReferences,omitempty"`

	// HostPool type for desktop.
	HostPoolType *ScalingHostPoolType `json:"hostPoolType,omitempty"`

	// List of ScalingSchedule definitions.
	Schedules []*ScalingSchedule `json:"schedules,omitempty"`

	// Timezone of the scaling plan.
	TimeZone *string `json:"timeZone,omitempty"`

	// READ-ONLY; ObjectId of scaling plan. (internal use)
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`
}

// ScalingPlansClientCreateOptions contains the optional parameters for the ScalingPlansClient.Create method.
type ScalingPlansClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ScalingPlansClientDeleteOptions contains the optional parameters for the ScalingPlansClient.Delete method.
type ScalingPlansClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ScalingPlansClientGetOptions contains the optional parameters for the ScalingPlansClient.Get method.
type ScalingPlansClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScalingPlansClientListByHostPoolOptions contains the optional parameters for the ScalingPlansClient.ListByHostPool method.
type ScalingPlansClientListByHostPoolOptions struct {
	// placeholder for future optional parameters
}

// ScalingPlansClientListByResourceGroupOptions contains the optional parameters for the ScalingPlansClient.ListByResourceGroup
// method.
type ScalingPlansClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ScalingPlansClientListBySubscriptionOptions contains the optional parameters for the ScalingPlansClient.ListBySubscription
// method.
type ScalingPlansClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ScalingPlansClientUpdateOptions contains the optional parameters for the ScalingPlansClient.Update method.
type ScalingPlansClientUpdateOptions struct {
	// Object containing scaling plan definitions.
	ScalingPlan *ScalingPlanPatch
}

// ScalingSchedule - Scaling plan schedule.
type ScalingSchedule struct {
	// Set of days of the week on which this schedule is active.
	DaysOfWeek []*ScalingScheduleDaysOfWeekItem `json:"daysOfWeek,omitempty"`

	// Name of the scaling schedule.
	Name *string `json:"name,omitempty"`

	// Load balancing algorithm for off-peak period.
	OffPeakLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm `json:"offPeakLoadBalancingAlgorithm,omitempty"`

	// Starting time for off-peak period.
	OffPeakStartTime *Time `json:"offPeakStartTime,omitempty"`

	// Load balancing algorithm for peak period.
	PeakLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm `json:"peakLoadBalancingAlgorithm,omitempty"`

	// Starting time for peak period.
	PeakStartTime *Time `json:"peakStartTime,omitempty"`

	// Capacity threshold for ramp down period.
	RampDownCapacityThresholdPct *int32 `json:"rampDownCapacityThresholdPct,omitempty"`

	// Should users be logged off forcefully from hosts.
	RampDownForceLogoffUsers *bool `json:"rampDownForceLogoffUsers,omitempty"`

	// Load balancing algorithm for ramp down period.
	RampDownLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm `json:"rampDownLoadBalancingAlgorithm,omitempty"`

	// Minimum host percentage for ramp down period.
	RampDownMinimumHostsPct *int32 `json:"rampDownMinimumHostsPct,omitempty"`

	// Notification message for users during ramp down period.
	RampDownNotificationMessage *string `json:"rampDownNotificationMessage,omitempty"`

	// Starting time for ramp down period.
	RampDownStartTime *Time `json:"rampDownStartTime,omitempty"`

	// Specifies when to stop hosts during ramp down period.
	RampDownStopHostsWhen *StopHostsWhen `json:"rampDownStopHostsWhen,omitempty"`

	// Number of minutes to wait to stop hosts during ramp down period.
	RampDownWaitTimeMinutes *int32 `json:"rampDownWaitTimeMinutes,omitempty"`

	// Capacity threshold for ramp up period.
	RampUpCapacityThresholdPct *int32 `json:"rampUpCapacityThresholdPct,omitempty"`

	// Load balancing algorithm for ramp up period.
	RampUpLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm `json:"rampUpLoadBalancingAlgorithm,omitempty"`

	// Minimum host percentage for ramp up period.
	RampUpMinimumHostsPct *int32 `json:"rampUpMinimumHostsPct,omitempty"`

	// Starting time for ramp up period.
	RampUpStartTime *Time `json:"rampUpStartTime,omitempty"`
}

// SendMessage - Represents message sent to a UserSession.
type SendMessage struct {
	// Body of message.
	MessageBody *string `json:"messageBody,omitempty"`

	// Title of message.
	MessageTitle *string `json:"messageTitle,omitempty"`
}

// ServiceSpecification - Service specification payload
type ServiceSpecification struct {
	// Specifications of the Log for Azure Monitoring
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`
}

// SessionHost - Represents a SessionHost definition.
type SessionHost struct {
	// Detailed properties for SessionHost
	Properties *SessionHostProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SessionHostHealthCheckFailureDetails - Contains details on the failure.
type SessionHostHealthCheckFailureDetails struct {
	// READ-ONLY; Error code corresponding for the failure.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of the last update.
	LastHealthCheckDateTime *time.Time `json:"lastHealthCheckDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Failure message: hints on what is wrong and how to recover.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// SessionHostHealthCheckReport - The report for session host information.
type SessionHostHealthCheckReport struct {
	// READ-ONLY; Additional detailed information on the failure.
	AdditionalFailureDetails *SessionHostHealthCheckFailureDetails `json:"additionalFailureDetails,omitempty" azure:"ro"`

	// READ-ONLY; Represents the name of the health check operation performed.
	HealthCheckName *HealthCheckName `json:"healthCheckName,omitempty" azure:"ro"`

	// READ-ONLY; Represents the Health state of the health check we performed.
	HealthCheckResult *HealthCheckResult `json:"healthCheckResult,omitempty" azure:"ro"`
}

// SessionHostList - List of SessionHost definitions.
type SessionHostList struct {
	// List of SessionHost definitions.
	Value []*SessionHost `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SessionHostPatch - SessionHost properties that can be patched.
type SessionHostPatch struct {
	// Detailed properties for SessionHost
	Properties *SessionHostPatchProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SessionHostPatchProperties - SessionHost properties that can be patched.
type SessionHostPatchProperties struct {
	// Allow a new session.
	AllowNewSession *bool `json:"allowNewSession,omitempty"`

	// User assigned to SessionHost.
	AssignedUser *string `json:"assignedUser,omitempty"`

	// Friendly name of SessionHost
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// SessionHostProperties - Schema for SessionHost properties.
type SessionHostProperties struct {
	// Version of agent on SessionHost.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// Allow a new session.
	AllowNewSession *bool `json:"allowNewSession,omitempty"`

	// User assigned to SessionHost.
	AssignedUser *string `json:"assignedUser,omitempty"`

	// Friendly name of SessionHost
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Last heart beat from SessionHost.
	LastHeartBeat *time.Time `json:"lastHeartBeat,omitempty"`

	// The version of the OS on the session host.
	OSVersion *string `json:"osVersion,omitempty"`

	// Number of sessions on SessionHost.
	Sessions *int32 `json:"sessions,omitempty"`

	// Status for a SessionHost.
	Status *Status `json:"status,omitempty"`

	// The version of the side by side stack on the session host.
	SxSStackVersion *string `json:"sxSStackVersion,omitempty"`

	// The error message.
	UpdateErrorMessage *string `json:"updateErrorMessage,omitempty"`

	// Update state of a SessionHost.
	UpdateState *UpdateState `json:"updateState,omitempty"`

	// READ-ONLY; The timestamp of the last update.
	LastUpdateTime *time.Time `json:"lastUpdateTime,omitempty" azure:"ro"`

	// READ-ONLY; ObjectId of SessionHost. (internal use)
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`

	// READ-ONLY; Resource Id of SessionHost's underlying virtual machine.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; List of SessionHostHealthCheckReports
	SessionHostHealthCheckResults []*SessionHostHealthCheckReport `json:"sessionHostHealthCheckResults,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of the status.
	StatusTimestamp *time.Time `json:"statusTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Virtual Machine Id of SessionHost's underlying virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty" azure:"ro"`
}

// SessionHostsClientDeleteOptions contains the optional parameters for the SessionHostsClient.Delete method.
type SessionHostsClientDeleteOptions struct {
	// Force flag to force sessionHost deletion even when userSession exists.
	Force *bool
}

// SessionHostsClientGetOptions contains the optional parameters for the SessionHostsClient.Get method.
type SessionHostsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SessionHostsClientListOptions contains the optional parameters for the SessionHostsClient.List method.
type SessionHostsClientListOptions struct {
	// placeholder for future optional parameters
}

// SessionHostsClientUpdateOptions contains the optional parameters for the SessionHostsClient.Update method.
type SessionHostsClientUpdateOptions struct {
	// Force flag to update assign, unassign or reassign personal desktop.
	Force *bool
	// Object containing SessionHost definitions.
	SessionHost *SessionHostPatch
}

// StartMenuItem - Represents a StartMenuItem definition.
type StartMenuItem struct {
	// Detailed properties for StartMenuItem
	Properties *StartMenuItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StartMenuItemList - List of StartMenuItem definitions.
type StartMenuItemList struct {
	// List of StartMenuItem definitions.
	Value []*StartMenuItem `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StartMenuItemProperties - Schema for StartMenuItem properties.
type StartMenuItemProperties struct {
	// Alias of StartMenuItem.
	AppAlias *string `json:"appAlias,omitempty"`

	// Command line arguments for StartMenuItem.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`

	// Path to the file of StartMenuItem.
	FilePath *string `json:"filePath,omitempty"`

	// Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`

	// Path to the icon.
	IconPath *string `json:"iconPath,omitempty"`
}

// StartMenuItemsClientListOptions contains the optional parameters for the StartMenuItemsClient.List method.
type StartMenuItemsClientListOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// Time - The time for a scaling action to occur.
type Time struct {
	// REQUIRED; The hour.
	Hour *int32 `json:"hour,omitempty"`

	// REQUIRED; The minute.
	Minute *int32 `json:"minute,omitempty"`
}

// UserSession - Represents a UserSession definition.
type UserSession struct {
	// Detailed properties for UserSession
	Properties *UserSessionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserSessionList - List of UserSession definitions.
type UserSessionList struct {
	// List of UserSession definitions.
	Value []*UserSession `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// UserSessionProperties - Schema for UserSession properties.
type UserSessionProperties struct {
	// The active directory user name.
	ActiveDirectoryUserName *string `json:"activeDirectoryUserName,omitempty"`

	// Application type of application.
	ApplicationType *ApplicationType `json:"applicationType,omitempty"`

	// The timestamp of the user session create.
	CreateTime *time.Time `json:"createTime,omitempty"`

	// State of user session.
	SessionState *SessionState `json:"sessionState,omitempty"`

	// The user principal name.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`

	// READ-ONLY; ObjectId of user session. (internal use)
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`
}

// UserSessionsClientDeleteOptions contains the optional parameters for the UserSessionsClient.Delete method.
type UserSessionsClientDeleteOptions struct {
	// Force flag to login off userSession.
	Force *bool
}

// UserSessionsClientDisconnectOptions contains the optional parameters for the UserSessionsClient.Disconnect method.
type UserSessionsClientDisconnectOptions struct {
	// placeholder for future optional parameters
}

// UserSessionsClientGetOptions contains the optional parameters for the UserSessionsClient.Get method.
type UserSessionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// UserSessionsClientListByHostPoolOptions contains the optional parameters for the UserSessionsClient.ListByHostPool method.
type UserSessionsClientListByHostPoolOptions struct {
	// OData filter expression. Valid properties for filtering are userprincipalname and sessionstate.
	Filter *string
}

// UserSessionsClientListOptions contains the optional parameters for the UserSessionsClient.List method.
type UserSessionsClientListOptions struct {
	// placeholder for future optional parameters
}

// UserSessionsClientSendMessageOptions contains the optional parameters for the UserSessionsClient.SendMessage method.
type UserSessionsClientSendMessageOptions struct {
	// Object containing message includes title and message body
	SendMessage *SendMessage
}

// Workspace - Represents a Workspace definition.
type Workspace struct {
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string                                  `json:"managedBy,omitempty"`
	Plan      *ResourceModelWithAllowedPropertySetPlan `json:"plan,omitempty"`

	// Detailed properties for Workspace
	Properties *WorkspaceProperties                    `json:"properties,omitempty"`
	SKU        *ResourceModelWithAllowedPropertySetSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceList - List of Workspace definitions.
type WorkspaceList struct {
	// List of Workspace definitions.
	Value []*Workspace `json:"value,omitempty"`

	// READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WorkspacePatch - Workspace properties that can be patched.
type WorkspacePatch struct {
	// Detailed properties for Workspace
	Properties *WorkspacePatchProperties `json:"properties,omitempty"`

	// tags to be updated
	Tags map[string]*string `json:"tags,omitempty"`
}

// WorkspacePatchProperties - Workspace properties that can be patched.
type WorkspacePatchProperties struct {
	// List of applicationGroup links.
	ApplicationGroupReferences []*string `json:"applicationGroupReferences,omitempty"`

	// Description of Workspace.
	Description *string `json:"description,omitempty"`

	// Friendly name of Workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Enabled to allow this resource to be access from the public network
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// WorkspaceProperties - Schema for Workspace properties.
type WorkspaceProperties struct {
	// List of applicationGroup resource Ids.
	ApplicationGroupReferences []*string `json:"applicationGroupReferences,omitempty"`

	// Description of Workspace.
	Description *string `json:"description,omitempty"`

	// Friendly name of Workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Enabled allows this resource to be accessed from both public and private networks, Disabled allows this resource to only
	// be accessed via private endpoints
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool `json:"cloudPcResource,omitempty" azure:"ro"`

	// READ-ONLY; ObjectId of Workspace. (internal use)
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connection associated with the specified resource
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`
}

// WorkspacesClientCreateOrUpdateOptions contains the optional parameters for the WorkspacesClient.CreateOrUpdate method.
type WorkspacesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientDeleteOptions contains the optional parameters for the WorkspacesClient.Delete method.
type WorkspacesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientGetOptions contains the optional parameters for the WorkspacesClient.Get method.
type WorkspacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListByResourceGroupOptions contains the optional parameters for the WorkspacesClient.ListByResourceGroup
// method.
type WorkspacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListBySubscriptionOptions contains the optional parameters for the WorkspacesClient.ListBySubscription
// method.
type WorkspacesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientUpdateOptions contains the optional parameters for the WorkspacesClient.Update method.
type WorkspacesClientUpdateOptions struct {
	// Object containing Workspace definitions.
	Workspace *WorkspacePatch
}
