//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdomainservices

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// OuContainerClient contains the methods for the OuContainer group.
// Don't use this type directly, use NewOuContainerClient() instead.
type OuContainerClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewOuContainerClient creates a new instance of OuContainerClient with the specified values.
// subscriptionID - Gets subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription
// ID forms part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewOuContainerClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*OuContainerClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &OuContainerClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreate - The Create OuContainer operation creates a new OuContainer under the specified Domain Service instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-05-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// domainServiceName - The name of the domain service.
// ouContainerName - The name of the OuContainer.
// containerAccount - Container Account Description.
// options - OuContainerClientBeginCreateOptions contains the optional parameters for the OuContainerClient.BeginCreate method.
func (client *OuContainerClient) BeginCreate(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, containerAccount ContainerAccount, options *OuContainerClientBeginCreateOptions) (*runtime.Poller[OuContainerClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, domainServiceName, ouContainerName, containerAccount, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[OuContainerClientCreateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[OuContainerClientCreateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Create - The Create OuContainer operation creates a new OuContainer under the specified Domain Service instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-05-01
func (client *OuContainerClient) create(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, containerAccount ContainerAccount, options *OuContainerClientBeginCreateOptions) (*http.Response, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, domainServiceName, ouContainerName, containerAccount, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createCreateRequest creates the Create request.
func (client *OuContainerClient) createCreateRequest(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, containerAccount ContainerAccount, options *OuContainerClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Aad/domainServices/{domainServiceName}/ouContainer/{ouContainerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainServiceName == "" {
		return nil, errors.New("parameter domainServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainServiceName}", url.PathEscape(domainServiceName))
	if ouContainerName == "" {
		return nil, errors.New("parameter ouContainerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ouContainerName}", url.PathEscape(ouContainerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, containerAccount)
}

// BeginDelete - The Delete OuContainer operation deletes specified OuContainer.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-05-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// domainServiceName - The name of the domain service.
// ouContainerName - The name of the OuContainer.
// options - OuContainerClientBeginDeleteOptions contains the optional parameters for the OuContainerClient.BeginDelete method.
func (client *OuContainerClient) BeginDelete(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, options *OuContainerClientBeginDeleteOptions) (*runtime.Poller[OuContainerClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, domainServiceName, ouContainerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[OuContainerClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[OuContainerClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - The Delete OuContainer operation deletes specified OuContainer.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-05-01
func (client *OuContainerClient) deleteOperation(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, options *OuContainerClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, domainServiceName, ouContainerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *OuContainerClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, options *OuContainerClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Aad/domainServices/{domainServiceName}/ouContainer/{ouContainerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainServiceName == "" {
		return nil, errors.New("parameter domainServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainServiceName}", url.PathEscape(domainServiceName))
	if ouContainerName == "" {
		return nil, errors.New("parameter ouContainerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ouContainerName}", url.PathEscape(ouContainerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get OuContainer in DomainService instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-05-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// domainServiceName - The name of the domain service.
// ouContainerName - The name of the OuContainer.
// options - OuContainerClientGetOptions contains the optional parameters for the OuContainerClient.Get method.
func (client *OuContainerClient) Get(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, options *OuContainerClientGetOptions) (OuContainerClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, domainServiceName, ouContainerName, options)
	if err != nil {
		return OuContainerClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return OuContainerClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return OuContainerClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *OuContainerClient) getCreateRequest(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, options *OuContainerClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Aad/domainServices/{domainServiceName}/ouContainer/{ouContainerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainServiceName == "" {
		return nil, errors.New("parameter domainServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainServiceName}", url.PathEscape(domainServiceName))
	if ouContainerName == "" {
		return nil, errors.New("parameter ouContainerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ouContainerName}", url.PathEscape(ouContainerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *OuContainerClient) getHandleResponse(resp *http.Response) (OuContainerClientGetResponse, error) {
	result := OuContainerClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OuContainer); err != nil {
		return OuContainerClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - The List of OuContainers in DomainService instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-05-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// domainServiceName - The name of the domain service.
// options - OuContainerClientListOptions contains the optional parameters for the OuContainerClient.List method.
func (client *OuContainerClient) NewListPager(resourceGroupName string, domainServiceName string, options *OuContainerClientListOptions) *runtime.Pager[OuContainerClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[OuContainerClientListResponse]{
		More: func(page OuContainerClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *OuContainerClientListResponse) (OuContainerClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceGroupName, domainServiceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return OuContainerClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return OuContainerClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return OuContainerClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *OuContainerClient) listCreateRequest(ctx context.Context, resourceGroupName string, domainServiceName string, options *OuContainerClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Aad/domainServices/{domainServiceName}/ouContainer"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainServiceName == "" {
		return nil, errors.New("parameter domainServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainServiceName}", url.PathEscape(domainServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *OuContainerClient) listHandleResponse(resp *http.Response) (OuContainerClientListResponse, error) {
	result := OuContainerClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OuContainerListResult); err != nil {
		return OuContainerClientListResponse{}, err
	}
	return result, nil
}

// BeginUpdate - The Update OuContainer operation can be used to update the existing OuContainers.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-05-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// domainServiceName - The name of the domain service.
// ouContainerName - The name of the OuContainer.
// containerAccount - Container Account Description.
// options - OuContainerClientBeginUpdateOptions contains the optional parameters for the OuContainerClient.BeginUpdate method.
func (client *OuContainerClient) BeginUpdate(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, containerAccount ContainerAccount, options *OuContainerClientBeginUpdateOptions) (*runtime.Poller[OuContainerClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, domainServiceName, ouContainerName, containerAccount, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[OuContainerClientUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[OuContainerClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - The Update OuContainer operation can be used to update the existing OuContainers.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-05-01
func (client *OuContainerClient) update(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, containerAccount ContainerAccount, options *OuContainerClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, domainServiceName, ouContainerName, containerAccount, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *OuContainerClient) updateCreateRequest(ctx context.Context, resourceGroupName string, domainServiceName string, ouContainerName string, containerAccount ContainerAccount, options *OuContainerClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Aad/domainServices/{domainServiceName}/ouContainer/{ouContainerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainServiceName == "" {
		return nil, errors.New("parameter domainServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainServiceName}", url.PathEscape(domainServiceName))
	if ouContainerName == "" {
		return nil, errors.New("parameter ouContainerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ouContainerName}", url.PathEscape(ouContainerName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, containerAccount)
}
