//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridcontainerservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// HybridIdentityMetadataClient contains the methods for the HybridIdentityMetadata group.
// Don't use this type directly, use NewHybridIdentityMetadataClient() instead.
type HybridIdentityMetadataClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewHybridIdentityMetadataClient creates a new instance of HybridIdentityMetadataClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewHybridIdentityMetadataClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*HybridIdentityMetadataClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &HybridIdentityMetadataClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Delete - Deletes the hybrid identity metadata proxy resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-05-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// provisionedClustersName - Parameter for the name of the provisioned cluster
// hybridIdentityMetadataResourceName - Parameter for the name of the hybrid identity metadata resource.
// options - HybridIdentityMetadataClientDeleteOptions contains the optional parameters for the HybridIdentityMetadataClient.Delete
// method.
func (client *HybridIdentityMetadataClient) Delete(ctx context.Context, resourceGroupName string, provisionedClustersName string, hybridIdentityMetadataResourceName string, options *HybridIdentityMetadataClientDeleteOptions) (HybridIdentityMetadataClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, provisionedClustersName, hybridIdentityMetadataResourceName, options)
	if err != nil {
		return HybridIdentityMetadataClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return HybridIdentityMetadataClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return HybridIdentityMetadataClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return HybridIdentityMetadataClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *HybridIdentityMetadataClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, provisionedClustersName string, hybridIdentityMetadataResourceName string, options *HybridIdentityMetadataClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{provisionedClustersName}/hybridIdentityMetadata/{hybridIdentityMetadataResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if provisionedClustersName == "" {
		return nil, errors.New("parameter provisionedClustersName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisionedClustersName}", url.PathEscape(provisionedClustersName))
	if hybridIdentityMetadataResourceName == "" {
		return nil, errors.New("parameter hybridIdentityMetadataResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hybridIdentityMetadataResourceName}", url.PathEscape(hybridIdentityMetadataResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get the hybrid identity metadata proxy resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-05-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// provisionedClustersName - Parameter for the name of the provisioned cluster
// hybridIdentityMetadataResourceName - Parameter for the name of the hybrid identity metadata resource.
// options - HybridIdentityMetadataClientGetOptions contains the optional parameters for the HybridIdentityMetadataClient.Get
// method.
func (client *HybridIdentityMetadataClient) Get(ctx context.Context, resourceGroupName string, provisionedClustersName string, hybridIdentityMetadataResourceName string, options *HybridIdentityMetadataClientGetOptions) (HybridIdentityMetadataClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, provisionedClustersName, hybridIdentityMetadataResourceName, options)
	if err != nil {
		return HybridIdentityMetadataClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return HybridIdentityMetadataClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return HybridIdentityMetadataClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *HybridIdentityMetadataClient) getCreateRequest(ctx context.Context, resourceGroupName string, provisionedClustersName string, hybridIdentityMetadataResourceName string, options *HybridIdentityMetadataClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{provisionedClustersName}/hybridIdentityMetadata/{hybridIdentityMetadataResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if provisionedClustersName == "" {
		return nil, errors.New("parameter provisionedClustersName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisionedClustersName}", url.PathEscape(provisionedClustersName))
	if hybridIdentityMetadataResourceName == "" {
		return nil, errors.New("parameter hybridIdentityMetadataResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hybridIdentityMetadataResourceName}", url.PathEscape(hybridIdentityMetadataResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *HybridIdentityMetadataClient) getHandleResponse(resp *http.Response) (HybridIdentityMetadataClientGetResponse, error) {
	result := HybridIdentityMetadataClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridIdentityMetadata); err != nil {
		return HybridIdentityMetadataClientGetResponse{}, err
	}
	return result, nil
}

// NewListByClusterPager - Lists the hybrid identity metadata proxy resource in a cluster.
// Generated from API version 2022-05-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// provisionedClustersName - Parameter for the name of the provisioned cluster
// options - HybridIdentityMetadataClientListByClusterOptions contains the optional parameters for the HybridIdentityMetadataClient.ListByCluster
// method.
func (client *HybridIdentityMetadataClient) NewListByClusterPager(resourceGroupName string, provisionedClustersName string, options *HybridIdentityMetadataClientListByClusterOptions) *runtime.Pager[HybridIdentityMetadataClientListByClusterResponse] {
	return runtime.NewPager(runtime.PagingHandler[HybridIdentityMetadataClientListByClusterResponse]{
		More: func(page HybridIdentityMetadataClientListByClusterResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *HybridIdentityMetadataClientListByClusterResponse) (HybridIdentityMetadataClientListByClusterResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByClusterCreateRequest(ctx, resourceGroupName, provisionedClustersName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return HybridIdentityMetadataClientListByClusterResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return HybridIdentityMetadataClientListByClusterResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return HybridIdentityMetadataClientListByClusterResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByClusterHandleResponse(resp)
		},
	})
}

// listByClusterCreateRequest creates the ListByCluster request.
func (client *HybridIdentityMetadataClient) listByClusterCreateRequest(ctx context.Context, resourceGroupName string, provisionedClustersName string, options *HybridIdentityMetadataClientListByClusterOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{provisionedClustersName}/hybridIdentityMetadata"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if provisionedClustersName == "" {
		return nil, errors.New("parameter provisionedClustersName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisionedClustersName}", url.PathEscape(provisionedClustersName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByClusterHandleResponse handles the ListByCluster response.
func (client *HybridIdentityMetadataClient) listByClusterHandleResponse(resp *http.Response) (HybridIdentityMetadataClientListByClusterResponse, error) {
	result := HybridIdentityMetadataClientListByClusterResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridIdentityMetadataList); err != nil {
		return HybridIdentityMetadataClientListByClusterResponse{}, err
	}
	return result, nil
}

// Put - Creates the hybrid identity metadata proxy resource that facilitates the managed identity provisioning.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-05-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// provisionedClustersName - Parameter for the name of the provisioned cluster
// hybridIdentityMetadataResourceName - Parameter for the name of the hybrid identity metadata resource.
// options - HybridIdentityMetadataClientPutOptions contains the optional parameters for the HybridIdentityMetadataClient.Put
// method.
func (client *HybridIdentityMetadataClient) Put(ctx context.Context, resourceGroupName string, provisionedClustersName string, hybridIdentityMetadataResourceName string, body HybridIdentityMetadata, options *HybridIdentityMetadataClientPutOptions) (HybridIdentityMetadataClientPutResponse, error) {
	req, err := client.putCreateRequest(ctx, resourceGroupName, provisionedClustersName, hybridIdentityMetadataResourceName, body, options)
	if err != nil {
		return HybridIdentityMetadataClientPutResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return HybridIdentityMetadataClientPutResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return HybridIdentityMetadataClientPutResponse{}, runtime.NewResponseError(resp)
	}
	return client.putHandleResponse(resp)
}

// putCreateRequest creates the Put request.
func (client *HybridIdentityMetadataClient) putCreateRequest(ctx context.Context, resourceGroupName string, provisionedClustersName string, hybridIdentityMetadataResourceName string, body HybridIdentityMetadata, options *HybridIdentityMetadataClientPutOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{provisionedClustersName}/hybridIdentityMetadata/{hybridIdentityMetadataResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if provisionedClustersName == "" {
		return nil, errors.New("parameter provisionedClustersName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisionedClustersName}", url.PathEscape(provisionedClustersName))
	if hybridIdentityMetadataResourceName == "" {
		return nil, errors.New("parameter hybridIdentityMetadataResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hybridIdentityMetadataResourceName}", url.PathEscape(hybridIdentityMetadataResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}

// putHandleResponse handles the Put response.
func (client *HybridIdentityMetadataClient) putHandleResponse(resp *http.Response) (HybridIdentityMetadataClientPutResponse, error) {
	result := HybridIdentityMetadataClientPutResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridIdentityMetadata); err != nil {
		return HybridIdentityMetadataClientPutResponse{}, err
	}
	return result, nil
}
