//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armorbital

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AuthorizedGroundstation.
func (a AuthorizedGroundstation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateDateType(objectMap, "expirationDate", a.ExpirationDate)
	populate(objectMap, "groundStation", a.GroundStation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizedGroundstation.
func (a *AuthorizedGroundstation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulateDateType(val, "ExpirationDate", &a.ExpirationDate)
			delete(rawMsg, key)
		case "groundStation":
			err = unpopulate(val, "GroundStation", &a.GroundStation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableContactsProperties.
func (a *AvailableContactsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endAzimuthDegrees":
			err = unpopulate(val, "EndAzimuthDegrees", &a.EndAzimuthDegrees)
			delete(rawMsg, key)
		case "endElevationDegrees":
			err = unpopulate(val, "EndElevationDegrees", &a.EndElevationDegrees)
			delete(rawMsg, key)
		case "maximumElevationDegrees":
			err = unpopulate(val, "MaximumElevationDegrees", &a.MaximumElevationDegrees)
			delete(rawMsg, key)
		case "rxEndTime":
			err = unpopulateTimeRFC3339(val, "RxEndTime", &a.RxEndTime)
			delete(rawMsg, key)
		case "rxStartTime":
			err = unpopulateTimeRFC3339(val, "RxStartTime", &a.RxStartTime)
			delete(rawMsg, key)
		case "startAzimuthDegrees":
			err = unpopulate(val, "StartAzimuthDegrees", &a.StartAzimuthDegrees)
			delete(rawMsg, key)
		case "startElevationDegrees":
			err = unpopulate(val, "StartElevationDegrees", &a.StartElevationDegrees)
			delete(rawMsg, key)
		case "txEndTime":
			err = unpopulateTimeRFC3339(val, "TxEndTime", &a.TxEndTime)
			delete(rawMsg, key)
		case "txStartTime":
			err = unpopulateTimeRFC3339(val, "TxStartTime", &a.TxStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactInstanceProperties.
func (c *ContactInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endAzimuthDegrees":
			err = unpopulate(val, "EndAzimuthDegrees", &c.EndAzimuthDegrees)
			delete(rawMsg, key)
		case "endElevationDegrees":
			err = unpopulate(val, "EndElevationDegrees", &c.EndElevationDegrees)
			delete(rawMsg, key)
		case "maximumElevationDegrees":
			err = unpopulate(val, "MaximumElevationDegrees", &c.MaximumElevationDegrees)
			delete(rawMsg, key)
		case "rxEndTime":
			err = unpopulateTimeRFC3339(val, "RxEndTime", &c.RxEndTime)
			delete(rawMsg, key)
		case "rxStartTime":
			err = unpopulateTimeRFC3339(val, "RxStartTime", &c.RxStartTime)
			delete(rawMsg, key)
		case "startAzimuthDegrees":
			err = unpopulate(val, "StartAzimuthDegrees", &c.StartAzimuthDegrees)
			delete(rawMsg, key)
		case "startElevationDegrees":
			err = unpopulate(val, "StartElevationDegrees", &c.StartElevationDegrees)
			delete(rawMsg, key)
		case "txEndTime":
			err = unpopulateTimeRFC3339(val, "TxEndTime", &c.TxEndTime)
			delete(rawMsg, key)
		case "txStartTime":
			err = unpopulateTimeRFC3339(val, "TxStartTime", &c.TxStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactParameters.
func (c ContactParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contactProfile", c.ContactProfile)
	populateTimeRFC3339(objectMap, "endTime", c.EndTime)
	populate(objectMap, "groundStationName", c.GroundStationName)
	populateTimeRFC3339(objectMap, "startTime", c.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactParameters.
func (c *ContactParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactProfile":
			err = unpopulate(val, "ContactProfile", &c.ContactProfile)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &c.EndTime)
			delete(rawMsg, key)
		case "groundStationName":
			err = unpopulate(val, "GroundStationName", &c.GroundStationName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfile.
func (c ContactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfileLink.
func (c ContactProfileLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "channels", c.Channels)
	populate(objectMap, "direction", c.Direction)
	populate(objectMap, "eirpdBW", c.EirpdBW)
	populate(objectMap, "gainOverTemperature", c.GainOverTemperature)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "polarization", c.Polarization)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfileProperties.
func (c ContactProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoTrackingConfiguration", c.AutoTrackingConfiguration)
	populate(objectMap, "eventHubUri", c.EventHubURI)
	populate(objectMap, "links", c.Links)
	populate(objectMap, "minimumElevationDegrees", c.MinimumElevationDegrees)
	populate(objectMap, "minimumViableContactDuration", c.MinimumViableContactDuration)
	populate(objectMap, "networkConfiguration", c.NetworkConfiguration)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfilesProperties.
func (c ContactProfilesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoTrackingConfiguration", c.AutoTrackingConfiguration)
	populate(objectMap, "eventHubUri", c.EventHubURI)
	populate(objectMap, "links", c.Links)
	populate(objectMap, "minimumElevationDegrees", c.MinimumElevationDegrees)
	populate(objectMap, "minimumViableContactDuration", c.MinimumViableContactDuration)
	populate(objectMap, "networkConfiguration", c.NetworkConfiguration)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ContactsProperties.
func (c ContactsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "antennaConfiguration", c.AntennaConfiguration)
	populate(objectMap, "contactProfile", c.ContactProfile)
	populate(objectMap, "endAzimuthDegrees", c.EndAzimuthDegrees)
	populate(objectMap, "endElevationDegrees", c.EndElevationDegrees)
	populate(objectMap, "errorMessage", c.ErrorMessage)
	populate(objectMap, "groundStationName", c.GroundStationName)
	populate(objectMap, "maximumElevationDegrees", c.MaximumElevationDegrees)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populateTimeRFC3339(objectMap, "reservationEndTime", c.ReservationEndTime)
	populateTimeRFC3339(objectMap, "reservationStartTime", c.ReservationStartTime)
	populateTimeRFC3339(objectMap, "rxEndTime", c.RxEndTime)
	populateTimeRFC3339(objectMap, "rxStartTime", c.RxStartTime)
	populate(objectMap, "startAzimuthDegrees", c.StartAzimuthDegrees)
	populate(objectMap, "startElevationDegrees", c.StartElevationDegrees)
	populate(objectMap, "status", c.Status)
	populateTimeRFC3339(objectMap, "txEndTime", c.TxEndTime)
	populateTimeRFC3339(objectMap, "txStartTime", c.TxStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactsProperties.
func (c *ContactsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "antennaConfiguration":
			err = unpopulate(val, "AntennaConfiguration", &c.AntennaConfiguration)
			delete(rawMsg, key)
		case "contactProfile":
			err = unpopulate(val, "ContactProfile", &c.ContactProfile)
			delete(rawMsg, key)
		case "endAzimuthDegrees":
			err = unpopulate(val, "EndAzimuthDegrees", &c.EndAzimuthDegrees)
			delete(rawMsg, key)
		case "endElevationDegrees":
			err = unpopulate(val, "EndElevationDegrees", &c.EndElevationDegrees)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &c.ErrorMessage)
			delete(rawMsg, key)
		case "groundStationName":
			err = unpopulate(val, "GroundStationName", &c.GroundStationName)
			delete(rawMsg, key)
		case "maximumElevationDegrees":
			err = unpopulate(val, "MaximumElevationDegrees", &c.MaximumElevationDegrees)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "reservationEndTime":
			err = unpopulateTimeRFC3339(val, "ReservationEndTime", &c.ReservationEndTime)
			delete(rawMsg, key)
		case "reservationStartTime":
			err = unpopulateTimeRFC3339(val, "ReservationStartTime", &c.ReservationStartTime)
			delete(rawMsg, key)
		case "rxEndTime":
			err = unpopulateTimeRFC3339(val, "RxEndTime", &c.RxEndTime)
			delete(rawMsg, key)
		case "rxStartTime":
			err = unpopulateTimeRFC3339(val, "RxStartTime", &c.RxStartTime)
			delete(rawMsg, key)
		case "startAzimuthDegrees":
			err = unpopulate(val, "StartAzimuthDegrees", &c.StartAzimuthDegrees)
			delete(rawMsg, key)
		case "startElevationDegrees":
			err = unpopulate(val, "StartElevationDegrees", &c.StartElevationDegrees)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "txEndTime":
			err = unpopulateTimeRFC3339(val, "TxEndTime", &c.TxEndTime)
			delete(rawMsg, key)
		case "txStartTime":
			err = unpopulateTimeRFC3339(val, "TxStartTime", &c.TxStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactsPropertiesAntennaConfiguration.
func (c ContactsPropertiesAntennaConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "destinationIp", c.DestinationIP)
	populate(objectMap, "sourceIps", c.SourceIPs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &o.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Spacecraft.
func (s Spacecraft) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SpacecraftLink.
func (s SpacecraftLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorizations", s.Authorizations)
	populate(objectMap, "bandwidthMHz", s.BandwidthMHz)
	populate(objectMap, "centerFrequencyMHz", s.CenterFrequencyMHz)
	populate(objectMap, "direction", s.Direction)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "polarization", s.Polarization)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SpacecraftsProperties.
func (s SpacecraftsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "links", s.Links)
	populate(objectMap, "noradId", s.NoradID)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "titleLine", s.TitleLine)
	populate(objectMap, "tleLine1", s.TleLine1)
	populate(objectMap, "tleLine2", s.TleLine2)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
