//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpeering

const (
	moduleName    = "armpeering"
	moduleVersion = "v1.0.0"
)

// Command - Invoked command
type Command string

const (
	CommandBgpRoute   Command = "BgpRoute"
	CommandPing       Command = "Ping"
	CommandTraceroute Command = "Traceroute"
)

// PossibleCommandValues returns the possible values for the Command const type.
func PossibleCommandValues() []Command {
	return []Command{
		CommandBgpRoute,
		CommandPing,
		CommandTraceroute,
	}
}

// ConnectionState - The state of the connection.
type ConnectionState string

const (
	ConnectionStateActive                ConnectionState = "Active"
	ConnectionStateApproved              ConnectionState = "Approved"
	ConnectionStateNone                  ConnectionState = "None"
	ConnectionStatePendingApproval       ConnectionState = "PendingApproval"
	ConnectionStateProvisioningCompleted ConnectionState = "ProvisioningCompleted"
	ConnectionStateProvisioningFailed    ConnectionState = "ProvisioningFailed"
	ConnectionStateProvisioningStarted   ConnectionState = "ProvisioningStarted"
	ConnectionStateValidating            ConnectionState = "Validating"
)

// PossibleConnectionStateValues returns the possible values for the ConnectionState const type.
func PossibleConnectionStateValues() []ConnectionState {
	return []ConnectionState{
		ConnectionStateActive,
		ConnectionStateApproved,
		ConnectionStateNone,
		ConnectionStatePendingApproval,
		ConnectionStateProvisioningCompleted,
		ConnectionStateProvisioningFailed,
		ConnectionStateProvisioningStarted,
		ConnectionStateValidating,
	}
}

// DirectPeeringType - The type of direct peering.
type DirectPeeringType string

const (
	DirectPeeringTypeCdn                  DirectPeeringType = "Cdn"
	DirectPeeringTypeEdge                 DirectPeeringType = "Edge"
	DirectPeeringTypeEdgeZoneForOperators DirectPeeringType = "EdgeZoneForOperators"
	DirectPeeringTypeInternal             DirectPeeringType = "Internal"
	DirectPeeringTypeIx                   DirectPeeringType = "Ix"
	DirectPeeringTypeIxRs                 DirectPeeringType = "IxRs"
	DirectPeeringTypeTransit              DirectPeeringType = "Transit"
	DirectPeeringTypeVoice                DirectPeeringType = "Voice"
)

// PossibleDirectPeeringTypeValues returns the possible values for the DirectPeeringType const type.
func PossibleDirectPeeringTypeValues() []DirectPeeringType {
	return []DirectPeeringType{
		DirectPeeringTypeCdn,
		DirectPeeringTypeEdge,
		DirectPeeringTypeEdgeZoneForOperators,
		DirectPeeringTypeInternal,
		DirectPeeringTypeIx,
		DirectPeeringTypeIxRs,
		DirectPeeringTypeTransit,
		DirectPeeringTypeVoice,
	}
}

type Enum0 string

const (
	Enum0Available   Enum0 = "Available"
	Enum0Unavailable Enum0 = "Unavailable"
)

// PossibleEnum0Values returns the possible values for the Enum0 const type.
func PossibleEnum0Values() []Enum0 {
	return []Enum0{
		Enum0Available,
		Enum0Unavailable,
	}
}

// Family - The family of the peering SKU.
type Family string

const (
	FamilyDirect   Family = "Direct"
	FamilyExchange Family = "Exchange"
)

// PossibleFamilyValues returns the possible values for the Family const type.
func PossibleFamilyValues() []Family {
	return []Family{
		FamilyDirect,
		FamilyExchange,
	}
}

// Kind - The kind of the peering.
type Kind string

const (
	KindDirect   Kind = "Direct"
	KindExchange Kind = "Exchange"
)

// PossibleKindValues returns the possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{
		KindDirect,
		KindExchange,
	}
}

// LearnedType - The prefix learned type
type LearnedType string

const (
	LearnedTypeNone               LearnedType = "None"
	LearnedTypeViaServiceProvider LearnedType = "ViaServiceProvider"
	LearnedTypeViaSession         LearnedType = "ViaSession"
)

// PossibleLearnedTypeValues returns the possible values for the LearnedType const type.
func PossibleLearnedTypeValues() []LearnedType {
	return []LearnedType{
		LearnedTypeNone,
		LearnedTypeViaServiceProvider,
		LearnedTypeViaSession,
	}
}

type LegacyPeeringsKind string

const (
	LegacyPeeringsKindDirect   LegacyPeeringsKind = "Direct"
	LegacyPeeringsKindExchange LegacyPeeringsKind = "Exchange"
)

// PossibleLegacyPeeringsKindValues returns the possible values for the LegacyPeeringsKind const type.
func PossibleLegacyPeeringsKindValues() []LegacyPeeringsKind {
	return []LegacyPeeringsKind{
		LegacyPeeringsKindDirect,
		LegacyPeeringsKindExchange,
	}
}

type LookingGlassCommand string

const (
	LookingGlassCommandBgpRoute   LookingGlassCommand = "BgpRoute"
	LookingGlassCommandPing       LookingGlassCommand = "Ping"
	LookingGlassCommandTraceroute LookingGlassCommand = "Traceroute"
)

// PossibleLookingGlassCommandValues returns the possible values for the LookingGlassCommand const type.
func PossibleLookingGlassCommandValues() []LookingGlassCommand {
	return []LookingGlassCommand{
		LookingGlassCommandBgpRoute,
		LookingGlassCommandPing,
		LookingGlassCommandTraceroute,
	}
}

type LookingGlassSourceType string

const (
	LookingGlassSourceTypeAzureRegion LookingGlassSourceType = "AzureRegion"
	LookingGlassSourceTypeEdgeSite    LookingGlassSourceType = "EdgeSite"
)

// PossibleLookingGlassSourceTypeValues returns the possible values for the LookingGlassSourceType const type.
func PossibleLookingGlassSourceTypeValues() []LookingGlassSourceType {
	return []LookingGlassSourceType{
		LookingGlassSourceTypeAzureRegion,
		LookingGlassSourceTypeEdgeSite,
	}
}

type PeeringLocationsDirectPeeringType string

const (
	PeeringLocationsDirectPeeringTypeCdn                  PeeringLocationsDirectPeeringType = "Cdn"
	PeeringLocationsDirectPeeringTypeEdge                 PeeringLocationsDirectPeeringType = "Edge"
	PeeringLocationsDirectPeeringTypeEdgeZoneForOperators PeeringLocationsDirectPeeringType = "EdgeZoneForOperators"
	PeeringLocationsDirectPeeringTypeInternal             PeeringLocationsDirectPeeringType = "Internal"
	PeeringLocationsDirectPeeringTypeIx                   PeeringLocationsDirectPeeringType = "Ix"
	PeeringLocationsDirectPeeringTypeIxRs                 PeeringLocationsDirectPeeringType = "IxRs"
	PeeringLocationsDirectPeeringTypeTransit              PeeringLocationsDirectPeeringType = "Transit"
	PeeringLocationsDirectPeeringTypeVoice                PeeringLocationsDirectPeeringType = "Voice"
)

// PossiblePeeringLocationsDirectPeeringTypeValues returns the possible values for the PeeringLocationsDirectPeeringType const type.
func PossiblePeeringLocationsDirectPeeringTypeValues() []PeeringLocationsDirectPeeringType {
	return []PeeringLocationsDirectPeeringType{
		PeeringLocationsDirectPeeringTypeCdn,
		PeeringLocationsDirectPeeringTypeEdge,
		PeeringLocationsDirectPeeringTypeEdgeZoneForOperators,
		PeeringLocationsDirectPeeringTypeInternal,
		PeeringLocationsDirectPeeringTypeIx,
		PeeringLocationsDirectPeeringTypeIxRs,
		PeeringLocationsDirectPeeringTypeTransit,
		PeeringLocationsDirectPeeringTypeVoice,
	}
}

type PeeringLocationsKind string

const (
	PeeringLocationsKindDirect   PeeringLocationsKind = "Direct"
	PeeringLocationsKindExchange PeeringLocationsKind = "Exchange"
)

// PossiblePeeringLocationsKindValues returns the possible values for the PeeringLocationsKind const type.
func PossiblePeeringLocationsKindValues() []PeeringLocationsKind {
	return []PeeringLocationsKind{
		PeeringLocationsKindDirect,
		PeeringLocationsKindExchange,
	}
}

// PrefixValidationState - The prefix validation state.
type PrefixValidationState string

const (
	PrefixValidationStateFailed   PrefixValidationState = "Failed"
	PrefixValidationStateInvalid  PrefixValidationState = "Invalid"
	PrefixValidationStateNone     PrefixValidationState = "None"
	PrefixValidationStatePending  PrefixValidationState = "Pending"
	PrefixValidationStateUnknown  PrefixValidationState = "Unknown"
	PrefixValidationStateVerified PrefixValidationState = "Verified"
	PrefixValidationStateWarning  PrefixValidationState = "Warning"
)

// PossiblePrefixValidationStateValues returns the possible values for the PrefixValidationState const type.
func PossiblePrefixValidationStateValues() []PrefixValidationState {
	return []PrefixValidationState{
		PrefixValidationStateFailed,
		PrefixValidationStateInvalid,
		PrefixValidationStateNone,
		PrefixValidationStatePending,
		PrefixValidationStateUnknown,
		PrefixValidationStateVerified,
		PrefixValidationStateWarning,
	}
}

// ProvisioningState - The provisioning state of the resource.
type ProvisioningState string

const (
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	ProvisioningStateUpdating  ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// Role - The role of the contact.
type Role string

const (
	RoleEscalation Role = "Escalation"
	RoleNoc        Role = "Noc"
	RoleOther      Role = "Other"
	RolePolicy     Role = "Policy"
	RoleService    Role = "Service"
	RoleTechnical  Role = "Technical"
)

// PossibleRoleValues returns the possible values for the Role const type.
func PossibleRoleValues() []Role {
	return []Role{
		RoleEscalation,
		RoleNoc,
		RoleOther,
		RolePolicy,
		RoleService,
		RoleTechnical,
	}
}

// SessionAddressProvider - The field indicating if Microsoft provides session ip addresses.
type SessionAddressProvider string

const (
	SessionAddressProviderMicrosoft SessionAddressProvider = "Microsoft"
	SessionAddressProviderPeer      SessionAddressProvider = "Peer"
)

// PossibleSessionAddressProviderValues returns the possible values for the SessionAddressProvider const type.
func PossibleSessionAddressProviderValues() []SessionAddressProvider {
	return []SessionAddressProvider{
		SessionAddressProviderMicrosoft,
		SessionAddressProviderPeer,
	}
}

// SessionStateV4 - The state of the IPv4 session.
type SessionStateV4 string

const (
	SessionStateV4Active        SessionStateV4 = "Active"
	SessionStateV4Connect       SessionStateV4 = "Connect"
	SessionStateV4Established   SessionStateV4 = "Established"
	SessionStateV4Idle          SessionStateV4 = "Idle"
	SessionStateV4None          SessionStateV4 = "None"
	SessionStateV4OpenConfirm   SessionStateV4 = "OpenConfirm"
	SessionStateV4OpenReceived  SessionStateV4 = "OpenReceived"
	SessionStateV4OpenSent      SessionStateV4 = "OpenSent"
	SessionStateV4PendingAdd    SessionStateV4 = "PendingAdd"
	SessionStateV4PendingRemove SessionStateV4 = "PendingRemove"
	SessionStateV4PendingUpdate SessionStateV4 = "PendingUpdate"
)

// PossibleSessionStateV4Values returns the possible values for the SessionStateV4 const type.
func PossibleSessionStateV4Values() []SessionStateV4 {
	return []SessionStateV4{
		SessionStateV4Active,
		SessionStateV4Connect,
		SessionStateV4Established,
		SessionStateV4Idle,
		SessionStateV4None,
		SessionStateV4OpenConfirm,
		SessionStateV4OpenReceived,
		SessionStateV4OpenSent,
		SessionStateV4PendingAdd,
		SessionStateV4PendingRemove,
		SessionStateV4PendingUpdate,
	}
}

// SessionStateV6 - The state of the IPv6 session.
type SessionStateV6 string

const (
	SessionStateV6Active        SessionStateV6 = "Active"
	SessionStateV6Connect       SessionStateV6 = "Connect"
	SessionStateV6Established   SessionStateV6 = "Established"
	SessionStateV6Idle          SessionStateV6 = "Idle"
	SessionStateV6None          SessionStateV6 = "None"
	SessionStateV6OpenConfirm   SessionStateV6 = "OpenConfirm"
	SessionStateV6OpenReceived  SessionStateV6 = "OpenReceived"
	SessionStateV6OpenSent      SessionStateV6 = "OpenSent"
	SessionStateV6PendingAdd    SessionStateV6 = "PendingAdd"
	SessionStateV6PendingRemove SessionStateV6 = "PendingRemove"
	SessionStateV6PendingUpdate SessionStateV6 = "PendingUpdate"
)

// PossibleSessionStateV6Values returns the possible values for the SessionStateV6 const type.
func PossibleSessionStateV6Values() []SessionStateV6 {
	return []SessionStateV6{
		SessionStateV6Active,
		SessionStateV6Connect,
		SessionStateV6Established,
		SessionStateV6Idle,
		SessionStateV6None,
		SessionStateV6OpenConfirm,
		SessionStateV6OpenReceived,
		SessionStateV6OpenSent,
		SessionStateV6PendingAdd,
		SessionStateV6PendingRemove,
		SessionStateV6PendingUpdate,
	}
}

// Size - The size of the peering SKU.
type Size string

const (
	SizeFree      Size = "Free"
	SizeMetered   Size = "Metered"
	SizeUnlimited Size = "Unlimited"
)

// PossibleSizeValues returns the possible values for the Size const type.
func PossibleSizeValues() []Size {
	return []Size{
		SizeFree,
		SizeMetered,
		SizeUnlimited,
	}
}

// Tier - The tier of the peering SKU.
type Tier string

const (
	TierBasic   Tier = "Basic"
	TierPremium Tier = "Premium"
)

// PossibleTierValues returns the possible values for the Tier const type.
func PossibleTierValues() []Tier {
	return []Tier{
		TierBasic,
		TierPremium,
	}
}

// ValidationState - The validation state of the ASN associated with the peer.
type ValidationState string

const (
	ValidationStateApproved ValidationState = "Approved"
	ValidationStateFailed   ValidationState = "Failed"
	ValidationStateNone     ValidationState = "None"
	ValidationStatePending  ValidationState = "Pending"
)

// PossibleValidationStateValues returns the possible values for the ValidationState const type.
func PossibleValidationStateValues() []ValidationState {
	return []ValidationState{
		ValidationStateApproved,
		ValidationStateFailed,
		ValidationStateNone,
		ValidationStatePending,
	}
}
