//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresqlhsc

import "time"

// CloudError - An error response from the Batch service.
type CloudError struct {
	// The error.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Batch service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// ConfigurationsClientBeginUpdateOptions contains the optional parameters for the ConfigurationsClient.BeginUpdate method.
type ConfigurationsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigurationsClientGetOptions contains the optional parameters for the ConfigurationsClient.Get method.
type ConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationsClientListByServerGroupOptions contains the optional parameters for the ConfigurationsClient.ListByServerGroup
// method.
type ConfigurationsClientListByServerGroupOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationsClientListByServerOptions contains the optional parameters for the ConfigurationsClient.ListByServer method.
type ConfigurationsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// FirewallRule - Represents a server group firewall rule.
type FirewallRule struct {
	// REQUIRED; The properties of a firewall rule.
	Properties *FirewallRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FirewallRuleListResult - A list of firewall rules.
type FirewallRuleListResult struct {
	// The list of firewall rules in a server group.
	Value []*FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties - The properties of a server group firewall rule.
type FirewallRuleProperties struct {
	// REQUIRED; The end IP address of the server group firewall rule. Must be IPv4 format.
	EndIPAddress *string `json:"endIpAddress,omitempty"`

	// REQUIRED; The start IP address of the server group firewall rule. Must be IPv4 format.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
}

// FirewallRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the FirewallRulesClient.BeginCreateOrUpdate
// method.
type FirewallRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FirewallRulesClientBeginDeleteOptions contains the optional parameters for the FirewallRulesClient.BeginDelete method.
type FirewallRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FirewallRulesClientGetOptions contains the optional parameters for the FirewallRulesClient.Get method.
type FirewallRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientListByServerGroupOptions contains the optional parameters for the FirewallRulesClient.ListByServerGroup
// method.
type FirewallRulesClientListByServerGroupOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceWindow - Maintenance window of a server group.
type MaintenanceWindow struct {
	// indicates whether custom window is enabled or disabled
	CustomWindow *string `json:"customWindow,omitempty"`

	// day of week for maintenance window
	DayOfWeek *int32 `json:"dayOfWeek,omitempty"`

	// start hour for maintenance window
	StartHour *int32 `json:"startHour,omitempty"`

	// start minute for maintenance window
	StartMinute *int32 `json:"startMinute,omitempty"`
}

// NameAvailability - Represents a resource name availability.
type NameAvailability struct {
	// Error Message.
	Message *string `json:"message,omitempty"`

	// name of the PostgreSQL server.
	Name *string `json:"name,omitempty"`

	// Indicates whether the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// type of the server
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityRequest - Request from client to check resource name availability.
type NameAvailabilityRequest struct {
	// REQUIRED; Resource name to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Resource type used for verification.
	Type *string `json:"type,omitempty"`
}

// Operation - REST API operation definition.
type Operation struct {
	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// READ-ONLY; The localized display information for this particular operation or action.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties,omitempty" azure:"ro"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly name for the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Operation resource provider name.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of resource provider operations.
type OperationListResult struct {
	// Collection of available operation details
	Value []*Operation `json:"value,omitempty"`

	// READ-ONLY; URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Role - Represents a server group role.
type Role struct {
	// The properties of a role.
	Properties *RoleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleListResult - A list of roles.
type RoleListResult struct {
	// The list of roles in a server group.
	Value []*Role `json:"value,omitempty"`
}

// RoleProperties - The properties of a server group role.
type RoleProperties struct {
	// REQUIRED; The password of the server group role.
	Password *string `json:"password,omitempty"`
}

// RolesClientBeginCreateOptions contains the optional parameters for the RolesClient.BeginCreate method.
type RolesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RolesClientBeginDeleteOptions contains the optional parameters for the RolesClient.BeginDelete method.
type RolesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RolesClientListByServerGroupOptions contains the optional parameters for the RolesClient.ListByServerGroup method.
type RolesClientListByServerGroupOptions struct {
	// placeholder for future optional parameters
}

// ServerConfiguration - Represents a configuration.
type ServerConfiguration struct {
	// The properties of a configuration.
	Properties *ServerConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerConfigurationListResult - A list of server configurations.
type ServerConfigurationListResult struct {
	// The list of server configurations.
	Value []*ServerConfiguration `json:"value,omitempty"`

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ServerConfigurationProperties - The properties of a configuration.
type ServerConfigurationProperties struct {
	// REQUIRED; Value of the configuration.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; Allowed values of the configuration.
	AllowedValues *string `json:"allowedValues,omitempty" azure:"ro"`

	// READ-ONLY; Data type of the configuration.
	DataType *ConfigurationDataType `json:"dataType,omitempty" azure:"ro"`

	// READ-ONLY; Default value of the configuration.
	DefaultValue *string `json:"defaultValue,omitempty" azure:"ro"`

	// READ-ONLY; Description of the configuration.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Source of the configuration.
	Source *string `json:"source,omitempty" azure:"ro"`
}

// ServerGroup - Represents a server group for create.
type ServerGroup struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of the server group create.
	Properties *ServerGroupProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerGroupConfiguration - Represents the configuration list of server role groups in a server group.
type ServerGroupConfiguration struct {
	// The properties of server group configuration.
	Properties *ServerGroupConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerGroupConfigurationListResult - A list of server group configurations.
type ServerGroupConfigurationListResult struct {
	// The list of server group configurations.
	Value []*ServerGroupConfiguration `json:"value,omitempty"`

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ServerGroupConfigurationProperties - The properties of server group configuration.
type ServerGroupConfigurationProperties struct {
	// REQUIRED; The list of server role group configuration values.
	ServerRoleGroupConfigurations []*ServerRoleGroupConfiguration `json:"serverRoleGroupConfigurations,omitempty"`

	// READ-ONLY; Allowed values of the configuration.
	AllowedValues *string `json:"allowedValues,omitempty" azure:"ro"`

	// READ-ONLY; Data type of the configuration.
	DataType *ConfigurationDataType `json:"dataType,omitempty" azure:"ro"`

	// READ-ONLY; Description of the configuration.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// ServerGroupForUpdate - Represents a server group for update.
type ServerGroupForUpdate struct {
	// The location the resource resides in.
	Location *string `json:"location,omitempty"`

	// Properties of the server group.
	Properties *ServerGroupPropertiesForUpdate `json:"properties,omitempty"`

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServerGroupListResult - A list of server groups.
type ServerGroupListResult struct {
	// The list of server groups
	Value []*ServerGroup `json:"value,omitempty"`

	// READ-ONLY; The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ServerGroupProperties - The properties used to create a new server group.
type ServerGroupProperties struct {
	// The administrator's login name of servers in server group. Can only be specified when the server is being created (and
	// is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// The password of the administrator login.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// Availability Zone information of the server group.
	AvailabilityZone *string `json:"availabilityZone,omitempty"`

	// The backup retention days for server group.
	BackupRetentionDays *int32 `json:"backupRetentionDays,omitempty"`

	// The Citus version of server group.
	CitusVersion *CitusVersion `json:"citusVersion,omitempty"`

	// The mode to create a new server group.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// The delegated subnet arguments for a server group.
	DelegatedSubnetArguments *ServerGroupPropertiesDelegatedSubnetArguments `json:"delegatedSubnetArguments,omitempty"`

	// If Citus MX is enabled or not for the server group.
	EnableMx *bool `json:"enableMx,omitempty"`

	// If shards on coordinator is enabled or not for the server group.
	EnableShardsOnCoordinator *bool `json:"enableShardsOnCoordinator,omitempty"`

	// If ZFS compression is enabled or not for the server group.
	EnableZfs *bool `json:"enableZfs,omitempty"`

	// Maintenance window of a server group.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`

	// Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when 'createMode' is 'PointInTimeRestore'
	PointInTimeUTC *time.Time `json:"pointInTimeUTC,omitempty"`

	// The PostgreSQL version of server group.
	PostgresqlVersion *PostgreSQLVersion `json:"postgresqlVersion,omitempty"`

	// The private dns zone arguments for a server group.
	PrivateDNSZoneArguments *ServerGroupPropertiesPrivateDNSZoneArguments `json:"privateDnsZoneArguments,omitempty"`

	// The list of server role groups.
	ServerRoleGroups []*ServerRoleGroup `json:"serverRoleGroups,omitempty"`

	// The source server group location to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'ReadReplica'
	SourceLocation *string `json:"sourceLocation,omitempty"`

	// The source resource group name to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'ReadReplica'
	SourceResourceGroupName *string `json:"sourceResourceGroupName,omitempty"`

	// The source server group name to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'ReadReplica'
	SourceServerGroupName *string `json:"sourceServerGroupName,omitempty"`

	// The source subscription id to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'ReadReplica'
	SourceSubscriptionID *string `json:"sourceSubscriptionId,omitempty"`

	// Standby Availability Zone information of the server group.
	StandbyAvailabilityZone *string `json:"standbyAvailabilityZone,omitempty"`

	// READ-ONLY; The earliest restore point time (ISO8601 format) for server group.
	EarliestRestoreTime *time.Time `json:"earliestRestoreTime,omitempty" azure:"ro"`

	// READ-ONLY; The array of read replica server groups.
	ReadReplicas []*string `json:"readReplicas,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider type of server group.
	ResourceProviderType *ResourceProviderType `json:"resourceProviderType,omitempty" azure:"ro"`

	// READ-ONLY; The source server group id for read replica server groups.
	SourceServerGroup *string `json:"sourceServerGroup,omitempty" azure:"ro"`

	// READ-ONLY; A state of a server group that is visible to user.
	State *ServerState `json:"state,omitempty" azure:"ro"`
}

// ServerGroupPropertiesDelegatedSubnetArguments - The delegated subnet arguments for a server group.
type ServerGroupPropertiesDelegatedSubnetArguments struct {
	// delegated subnet arm resource id.
	SubnetArmResourceID *string `json:"subnetArmResourceId,omitempty"`
}

// ServerGroupPropertiesForUpdate - The properties used to update a server group.
type ServerGroupPropertiesForUpdate struct {
	// The password of the administrator login.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// Availability Zone information of the server group.
	AvailabilityZone *string `json:"availabilityZone,omitempty"`

	// The backup retention days for server group.
	BackupRetentionDays *int32 `json:"backupRetentionDays,omitempty"`

	// The Citus version of server group.
	CitusVersion *CitusVersion `json:"citusVersion,omitempty"`

	// If shards on coordinator is enabled or not for the server group.
	EnableShardsOnCoordinator *bool `json:"enableShardsOnCoordinator,omitempty"`

	// Maintenance window of a server group.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`

	// The PostgreSQL version of server group.
	PostgresqlVersion *PostgreSQLVersion `json:"postgresqlVersion,omitempty"`

	// The list of server role groups.
	ServerRoleGroups []*ServerRoleGroup `json:"serverRoleGroups,omitempty"`

	// Standby Availability Zone information of the server group.
	StandbyAvailabilityZone *string `json:"standbyAvailabilityZone,omitempty"`
}

// ServerGroupPropertiesPrivateDNSZoneArguments - The private dns zone arguments for a server group.
type ServerGroupPropertiesPrivateDNSZoneArguments struct {
	// private dns zone arm resource id.
	PrivateDNSZoneArmResourceID *string `json:"privateDnsZoneArmResourceId,omitempty"`
}

// ServerGroupServer - Represents a server in a server group.
type ServerGroupServer struct {
	// The properties of a server in a server group.
	Properties *ServerGroupServerProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerGroupServerListResult - A list of servers in a server group.
type ServerGroupServerListResult struct {
	// The list of servers in a server group.
	Value []*ServerGroupServer `json:"value,omitempty"`
}

// ServerGroupServerProperties - The properties of a server in server group.
type ServerGroupServerProperties struct {
	// The administrator's login name of a servers in server group.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// Availability Zone information of the server group.
	AvailabilityZone *string `json:"availabilityZone,omitempty"`

	// The Citus version of server.
	CitusVersion *CitusVersion `json:"citusVersion,omitempty"`

	// If high availability is enabled or not for the server.
	EnableHa *bool `json:"enableHa,omitempty"`

	// The PostgreSQL version of server.
	PostgresqlVersion *PostgreSQLVersion `json:"postgresqlVersion,omitempty"`

	// The role of server in the server group.
	Role *ServerRole `json:"role,omitempty"`

	// The edition of a server (default: GeneralPurpose).
	ServerEdition *ServerEdition `json:"serverEdition,omitempty"`

	// Standby Availability Zone information of the server group.
	StandbyAvailabilityZone *string `json:"standbyAvailabilityZone,omitempty"`

	// The storage of a server in MB (max: 2097152 = 2TiB).
	StorageQuotaInMb *int64 `json:"storageQuotaInMb,omitempty"`

	// The vCores count of a server (max: 64).
	VCores *int64 `json:"vCores,omitempty"`

	// READ-ONLY; If public IP is requested or not for a server.
	EnablePublicIP *bool `json:"enablePublicIp,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified domain name of a server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty" azure:"ro"`

	// READ-ONLY; A state of a server group that is visible to user for HA feature.
	HaState *ServerHaState `json:"haState,omitempty" azure:"ro"`

	// READ-ONLY; A state of a server that is visible to user.
	State *ServerState `json:"state,omitempty" azure:"ro"`
}

// ServerGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerGroupsClient.BeginCreateOrUpdate
// method.
type ServerGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerGroupsClientBeginDeleteOptions contains the optional parameters for the ServerGroupsClient.BeginDelete method.
type ServerGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerGroupsClientBeginRestartOptions contains the optional parameters for the ServerGroupsClient.BeginRestart method.
type ServerGroupsClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerGroupsClientBeginStartOptions contains the optional parameters for the ServerGroupsClient.BeginStart method.
type ServerGroupsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerGroupsClientBeginStopOptions contains the optional parameters for the ServerGroupsClient.BeginStop method.
type ServerGroupsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerGroupsClientBeginUpdateOptions contains the optional parameters for the ServerGroupsClient.BeginUpdate method.
type ServerGroupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerGroupsClientCheckNameAvailabilityOptions contains the optional parameters for the ServerGroupsClient.CheckNameAvailability
// method.
type ServerGroupsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServerGroupsClientGetOptions contains the optional parameters for the ServerGroupsClient.Get method.
type ServerGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerGroupsClientListByResourceGroupOptions contains the optional parameters for the ServerGroupsClient.ListByResourceGroup
// method.
type ServerGroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServerGroupsClientListOptions contains the optional parameters for the ServerGroupsClient.List method.
type ServerGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// ServerNameItem - The name object for a server.
type ServerNameItem struct {
	// The name of a server.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The fully qualified domain name of a server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty" azure:"ro"`
}

// ServerProperties - The properties of a server.
type ServerProperties struct {
	// If high availability is enabled or not for the server.
	EnableHa *bool `json:"enableHa,omitempty"`

	// The edition of a server (default: GeneralPurpose).
	ServerEdition *ServerEdition `json:"serverEdition,omitempty"`

	// The storage of a server in MB (max: 2097152 = 2TiB).
	StorageQuotaInMb *int64 `json:"storageQuotaInMb,omitempty"`

	// The vCores count of a server (max: 64).
	VCores *int64 `json:"vCores,omitempty"`

	// READ-ONLY; If public IP is requested or not for a server.
	EnablePublicIP *bool `json:"enablePublicIp,omitempty" azure:"ro"`
}

// ServerRoleGroup - Represents a server role group.
type ServerRoleGroup struct {
	// If high availability is enabled or not for the server.
	EnableHa *bool `json:"enableHa,omitempty"`

	// The name of the server role group.
	Name *string `json:"name,omitempty"`

	// The role of servers in the server role group.
	Role *ServerRole `json:"role,omitempty"`

	// The number of servers in the server role group.
	ServerCount *int32 `json:"serverCount,omitempty"`

	// The edition of a server (default: GeneralPurpose).
	ServerEdition *ServerEdition `json:"serverEdition,omitempty"`

	// The storage of a server in MB (max: 2097152 = 2TiB).
	StorageQuotaInMb *int64 `json:"storageQuotaInMb,omitempty"`

	// The vCores count of a server (max: 64).
	VCores *int64 `json:"vCores,omitempty"`

	// READ-ONLY; If public IP is requested or not for a server.
	EnablePublicIP *bool `json:"enablePublicIp,omitempty" azure:"ro"`

	// READ-ONLY; The list of server names in the server role group.
	ServerNames []*ServerNameItem `json:"serverNames,omitempty" azure:"ro"`
}

// ServerRoleGroupConfiguration - Represents server role group configuration value.
type ServerRoleGroupConfiguration struct {
	// REQUIRED; The role of servers in the server role group.
	Role *ServerRole `json:"role,omitempty"`

	// REQUIRED; Value of the configuration.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; Default value of the configuration.
	DefaultValue *string `json:"defaultValue,omitempty" azure:"ro"`

	// READ-ONLY; Source of the configuration.
	Source *string `json:"source,omitempty" azure:"ro"`
}

// ServersClientGetOptions contains the optional parameters for the ServersClient.Get method.
type ServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListByServerGroupOptions contains the optional parameters for the ServersClient.ListByServerGroup method.
type ServersClientListByServerGroupOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}
