//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServerVulnerabilityAssessmentClient contains the methods for the ServerVulnerabilityAssessment group.
// Don't use this type directly, use NewServerVulnerabilityAssessmentClient() instead.
type ServerVulnerabilityAssessmentClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewServerVulnerabilityAssessmentClient creates a new instance of ServerVulnerabilityAssessmentClient with the specified values.
// subscriptionID - Azure subscription ID
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewServerVulnerabilityAssessmentClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServerVulnerabilityAssessmentClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ServerVulnerabilityAssessmentClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creating a server vulnerability assessment on a resource, which will onboard a resource for having a vulnerability
// assessment on it
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// resourceNamespace - The Namespace of the resource.
// resourceType - The type of the resource.
// resourceName - Name of the resource.
// options - ServerVulnerabilityAssessmentClientCreateOrUpdateOptions contains the optional parameters for the ServerVulnerabilityAssessmentClient.CreateOrUpdate
// method.
func (client *ServerVulnerabilityAssessmentClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientCreateOrUpdateOptions) (ServerVulnerabilityAssessmentClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, resourceNamespace, resourceType, resourceName, options)
	if err != nil {
		return ServerVulnerabilityAssessmentClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return ServerVulnerabilityAssessmentClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ServerVulnerabilityAssessmentClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceNamespace == "" {
		return nil, errors.New("parameter resourceNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceNamespace}", url.PathEscape(resourceNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	urlPath = strings.ReplaceAll(urlPath, "{serverVulnerabilityAssessment}", url.PathEscape("default"))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ServerVulnerabilityAssessmentClient) createOrUpdateHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentClientCreateOrUpdateResponse, error) {
	result := ServerVulnerabilityAssessmentClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessment); err != nil {
		return ServerVulnerabilityAssessmentClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// BeginDelete - Removing server vulnerability assessment from a resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// resourceNamespace - The Namespace of the resource.
// resourceType - The type of the resource.
// resourceName - Name of the resource.
// options - ServerVulnerabilityAssessmentClientBeginDeleteOptions contains the optional parameters for the ServerVulnerabilityAssessmentClient.BeginDelete
// method.
func (client *ServerVulnerabilityAssessmentClient) BeginDelete(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientBeginDeleteOptions) (*runtime.Poller[ServerVulnerabilityAssessmentClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, resourceNamespace, resourceType, resourceName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[ServerVulnerabilityAssessmentClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
		})
	} else {
		return runtime.NewPollerFromResumeToken[ServerVulnerabilityAssessmentClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Removing server vulnerability assessment from a resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-01-01
func (client *ServerVulnerabilityAssessmentClient) deleteOperation(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceNamespace, resourceType, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ServerVulnerabilityAssessmentClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceNamespace == "" {
		return nil, errors.New("parameter resourceNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceNamespace}", url.PathEscape(resourceNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	urlPath = strings.ReplaceAll(urlPath, "{serverVulnerabilityAssessment}", url.PathEscape("default"))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets a server vulnerability assessment onboarding statuses on a given resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// resourceNamespace - The Namespace of the resource.
// resourceType - The type of the resource.
// resourceName - Name of the resource.
// options - ServerVulnerabilityAssessmentClientGetOptions contains the optional parameters for the ServerVulnerabilityAssessmentClient.Get
// method.
func (client *ServerVulnerabilityAssessmentClient) Get(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientGetOptions) (ServerVulnerabilityAssessmentClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, resourceNamespace, resourceType, resourceName, options)
	if err != nil {
		return ServerVulnerabilityAssessmentClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServerVulnerabilityAssessmentClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ServerVulnerabilityAssessmentClient) getCreateRequest(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceNamespace == "" {
		return nil, errors.New("parameter resourceNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceNamespace}", url.PathEscape(resourceNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	urlPath = strings.ReplaceAll(urlPath, "{serverVulnerabilityAssessment}", url.PathEscape("default"))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ServerVulnerabilityAssessmentClient) getHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentClientGetResponse, error) {
	result := ServerVulnerabilityAssessmentClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessment); err != nil {
		return ServerVulnerabilityAssessmentClientGetResponse{}, err
	}
	return result, nil
}

// ListByExtendedResource - Gets a list of server vulnerability assessment onboarding statuses on a given resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-01-01
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// resourceNamespace - The Namespace of the resource.
// resourceType - The type of the resource.
// resourceName - Name of the resource.
// options - ServerVulnerabilityAssessmentClientListByExtendedResourceOptions contains the optional parameters for the ServerVulnerabilityAssessmentClient.ListByExtendedResource
// method.
func (client *ServerVulnerabilityAssessmentClient) ListByExtendedResource(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientListByExtendedResourceOptions) (ServerVulnerabilityAssessmentClientListByExtendedResourceResponse, error) {
	req, err := client.listByExtendedResourceCreateRequest(ctx, resourceGroupName, resourceNamespace, resourceType, resourceName, options)
	if err != nil {
		return ServerVulnerabilityAssessmentClientListByExtendedResourceResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentClientListByExtendedResourceResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServerVulnerabilityAssessmentClientListByExtendedResourceResponse{}, runtime.NewResponseError(resp)
	}
	return client.listByExtendedResourceHandleResponse(resp)
}

// listByExtendedResourceCreateRequest creates the ListByExtendedResource request.
func (client *ServerVulnerabilityAssessmentClient) listByExtendedResourceCreateRequest(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *ServerVulnerabilityAssessmentClientListByExtendedResourceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceNamespace == "" {
		return nil, errors.New("parameter resourceNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceNamespace}", url.PathEscape(resourceNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByExtendedResourceHandleResponse handles the ListByExtendedResource response.
func (client *ServerVulnerabilityAssessmentClient) listByExtendedResourceHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentClientListByExtendedResourceResponse, error) {
	result := ServerVulnerabilityAssessmentClientListByExtendedResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessmentsList); err != nil {
		return ServerVulnerabilityAssessmentClientListByExtendedResourceResponse{}, err
	}
	return result, nil
}
